% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-encrypt.R
\name{Symmetric encryption}
\alias{Symmetric encryption}
\alias{data_encrypt}
\alias{data_decrypt}
\alias{data_tag}
\title{Symmetric Encryption and Tagging}
\usage{
data_encrypt(msg, key, nonce = random(24))

data_decrypt(bin, key, nonce = attr(bin, "nonce"))

data_tag(msg, key)
}
\arguments{
\item{msg}{message to be encrypted}

\item{key}{shared secret key used for both encryption and decryption}

\item{nonce}{non-secret unique data to randomize the cipher}

\item{bin}{encrypted ciphertext}
}
\description{
Encryption with authentication using a 256 bit shared secret. Mainly useful for
encrypting local data. For secure communication use public-key encryption
(\link{simple_encrypt} and \link{auth_encrypt}).
}
\details{
Symmetric encryption uses a secret key to encode and decode a message. This can be
used to encrypt local data on disk, or as a building block for more complex methods.

Because the same \code{secret} is used for both encryption and decryption, symmetric
encryption by itself is impractical for communication. For exchanging secure messages
with other parties, use assymetric (public-key) methods (see \link{simple_encrypt} or
\link{auth_encrypt}).

The \code{nonce} is not confidential but required for decryption, and should be
stored or sent along with the ciphertext. The purpose of the \code{nonce} is to
randomize the cipher to protect gainst re-use attacks. This way you can use one
and the same secret for encrypting multiple messages.

The \link{data_tag} function generates an authenticated hash that can be stored
alongside the data to be able to verify the integrity of the data later on. For
public key signatures see \code{sig_sign} instead.
}
\examples{
# 256-bit key
key <- sha256(charToRaw("This is a secret passphrase"))
msg <- serialize(iris, NULL)

# Encrypts with random nonce
cipher <- data_encrypt(msg, key)
orig <- data_decrypt(cipher, key)
stopifnot(identical(msg, orig))

# Tag the message with your key (HMAC)
tag <- data_tag(msg, key)
}
\references{
\url{https://libsodium.gitbook.io/doc/public-key_cryptography/authenticated_encryption}
}
