% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegionsExtend.R
\name{setRegionBoundaries}
\alias{setRegionBoundaries}
\title{Build a RegionDefinition object that includes CDR3 and FWR4.}
\usage{
setRegionBoundaries(juncLength, sequenceImgt, regionDefinition = NULL)
}
\arguments{
\item{juncLength}{junction length of the sequence.}

\item{sequenceImgt}{IMGT-numbered sequence.}

\item{regionDefinition}{\code{RegionDefinition} type to calculate the region definition for. 
Can be one of \code{IMGT_VDJ_BY_REGIONS} or \code{IMGT_VDJ},
which are template definitions that include CDR1-3 and FWR1-4. 
Only these two regions include all CDR1-3 and FWR1-4 regions.
If this argument is set to \code{NULL}, then an empty 
\code{RegionDefinition} will be returned.}
}
\value{
A \code{RegionDefinition} object that includes CDR1-3 and FWR1-4 for the  
         \code{sequenceImgt}, \code{juncLength}, and \code{regionDefinition} specified.
        
         For \code{regionDefinition=IMGT_VDJ_BY_REGIONS}, the returned \code{RegionDefinition} 
         includes:

         \itemize{
            \item  \code{fwr1}:   Positions 1 to 78.
            \item  \code{cdr1}:   Positions 79 to 114.
            \item  \code{fwr2}:   Positions 115 to 165.
            \item  \code{cdr2}:   Positions 166 to 195.
            \item  \code{fwr3}:   Positions 196 to 312.
            \item  \code{cdr3}:   Positions 313 to (313 + juncLength - 6) since the junction 
                                  sequence includes (on the left) the last codon from FWR3 and 
                                  (on the right) the first codon from FWR4.  
            \item  \code{fwr4}:   Positions (313 + juncLength - 6 + 1) to the end of the sequence.
          }

          For \code{regionDefinition=IMGT_VDJ}, the returned \code{RegionDefinition} includes:

          \itemize{
            \item  \code{fwr}:   Positions belonging to a FWR.
            \item  \code{cdr}:   Positions belonging to a CDR.
          }

          In the case that the \code{regionDefinition} argument is not one of the extended
          regions (\code{IMGT_VDJ_BY_REGIONS} or \code{IMGT_VDJ}), the input 
          \code{regionDefinition} is returned as is.
}
\description{
\code{setRegionBoundaries} takes as input a junction length and an IMGT-numbered sequence
and outputs a custom \code{RegionDefinition} object that includes the boundary definitions of 
CDR1-3 and FWR1-4 for that sequence. In contrast to the universal \code{RegionDefinition} object 
that end with FWR3, the returned definition is per-sequence due to variable junction lengths.
}
\examples{
# Load and subset example data
data(ExampleDb, package = "alakazam")  
len <- ExampleDb$junction_length[1]
sequence <- ExampleDb$sequence_alignment[1]
region <- setRegionBoundaries(len, sequence, regionDefinition = IMGT_VDJ)

}
\seealso{
See \link{RegionDefinition} for the return object. 
          See \link{IMGT_SCHEMES} for a set of predefined \code{RegionDefinition} objects.
}
