% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.FindObject}
\alias{.FindObject}
\title{Find A Subobject}
\usage{
.FindObject(object, name, exclude = c("misc", "tools"))
}
\arguments{
\item{object}{An \link[methods:Classes_Details]{S4} object}

\item{name}{Name of subobject to find}

\item{exclude}{A character vector of slot names to exclude}
}
\value{
The name of the slot that contains \code{name}; returns \code{NULL}
if a subobject named \code{name} cannot be found
}
\description{
Determine the slot that a subobject is contained in
}
\examples{
.FindObject(pbmc_small, "tsne")

}
\seealso{

\code{\link{.Collections}()},
\code{\link{.FilterObjects}()},
\code{\link{.Subobjects}()}
}
\concept{subobjects}
\concept{utils}
\keyword{internal}
