% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay5.R
\name{merge.Assay5}
\alias{merge.Assay5}
\title{Merge Assays}
\usage{
\method{merge}{Assay5}(x, y, labels = NULL, add.cell.ids = NULL, collapse = FALSE, ...)
}
\arguments{
\item{x}{An \code{\link{Assay5}} object}

\item{y}{One or more \code{\link{Assay5}} objects}

\item{labels}{A character vector equal to the number of objects; defaults to
\code{as.character(seq_along(c(x, y)))}}

\item{add.cell.ids}{A character vector equal to the number of objects
provided to append to all cell names; if \code{TRUE}, uses \code{labels} as
\code{add.cell.ids}}

\item{collapse}{If \code{TRUE}, merge layers of the same name together; if
\code{FALSE}, appends \code{labels} to the layer name}

\item{...}{Ignored}
}
\value{
A new v5 assay with data merged from \code{c(x, y)}
}
\description{
Merge one or more v5 assays together
}
\details{
\strong{Note}: collapsing layers is currently not supported
}
\seealso{
v5 Assay object, validity, and interaction methods:
\code{\link{$.Assay5}()},
\code{\link{Assay5-class}},
\code{\link{Assay5-validity}},
\code{\link{[.Assay5}()},
\code{\link{[[.Assay5}()},
\code{\link{dim.Assay5}()},
\code{\link{dimnames.Assay5}()},
\code{\link{split.Assay5}()},
\code{\link{subset.Assay5}()}
}
\concept{assay5}
