% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWorkbook.R
\name{read.xlsx}
\alias{read.xlsx}
\title{Read from an Excel file or Workbook object}
\usage{
read.xlsx(
  xlsxFile,
  sheet = 1,
  startRow = 1,
  colNames = TRUE,
  rowNames = FALSE,
  detectDates = FALSE,
  skipEmptyRows = TRUE,
  skipEmptyCols = TRUE,
  rows = NULL,
  cols = NULL,
  check.names = FALSE,
  sep.names = ".",
  namedRegion = NULL,
  na.strings = "NA",
  fillMergedCells = FALSE
)
}
\arguments{
\item{xlsxFile}{An xlsx file, Workbook object or URL to xlsx file.}

\item{sheet}{The name or index of the sheet to read data from.}

\item{startRow}{first row to begin looking for data.  Empty rows at the top of a file are always skipped,
regardless of the value of startRow.}

\item{colNames}{If \code{TRUE}, the first row of data will be used as column names.}

\item{rowNames}{If \code{TRUE}, first column of data will be used as row names.}

\item{detectDates}{If \code{TRUE}, attempt to recognise dates and perform conversion.}

\item{skipEmptyRows}{If \code{TRUE}, empty rows are skipped else empty rows after the first row containing data
will return a row of NAs.}

\item{skipEmptyCols}{If \code{TRUE}, empty columns are skipped.}

\item{rows}{A numeric vector specifying which rows in the Excel file to read.
If NULL, all rows are read.}

\item{cols}{A numeric vector specifying which columns in the Excel file to read.
If NULL, all columns are read.}

\item{check.names}{logical. If TRUE then the names of the variables in the data frame
are checked to ensure that they are syntactically valid variable names}

\item{sep.names}{One character which substitutes blanks in column names. By default, "."}

\item{namedRegion}{A named region in the Workbook. If not NULL startRow, rows and cols parameters are ignored.}

\item{na.strings}{A character vector of strings which are to be interpreted as NA. Blank cells will be returned as NA.}

\item{fillMergedCells}{If TRUE, the value in a merged cell is given to all cells within the merge.}
}
\value{
data.frame
}
\description{
Read data from an Excel file or Workbook object into a data.frame
}
\details{
Formulae written using writeFormula to a Workbook object will not get picked up by read.xlsx().
This is because only the formula is written and left to be evaluated when the file is opened in Excel.
Opening, saving and closing the file with Excel will resolve this.
}
\seealso{
\code{\link{getNamedRegions}}
}
\author{
Alexander Walker
}
