% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{laplacian_matrix}
\alias{laplacian_matrix}
\alias{graph.laplacian}
\title{Graph Laplacian}
\usage{
laplacian_matrix(
  graph,
  normalized = FALSE,
  weights = NULL,
  sparse = igraph_opt("sparsematrices")
)
}
\arguments{
\item{graph}{The input graph.}

\item{normalized}{Whether to calculate the normalized Laplacian. See
definitions below.}

\item{weights}{An optional vector giving edge weights for weighted Laplacian
matrix. If this is \code{NULL} and the graph has an edge attribute called
\code{weight}, then it will be used automatically. Set this to \code{NA} if
you want the unweighted Laplacian on a graph that has a \code{weight} edge
attribute.}

\item{sparse}{Logical scalar, whether to return the result as a sparse
matrix. The \code{Matrix} package is required for sparse matrices.}
}
\value{
A numeric matrix.
}
\description{
The Laplacian of a graph.
}
\details{
The Laplacian Matrix of a graph is a symmetric matrix having the same number
of rows and columns as the number of vertices in the graph and element (i,j)
is d[i], the degree of vertex i if if i==j, -1 if i!=j and there is an edge
between vertices i and j and 0 otherwise.

A normalized version of the Laplacian Matrix is similar: element (i,j) is 1
if i==j, -1/sqrt(d[i] d[j]) if i!=j and there is an edge between vertices i
and j and 0 otherwise.

The weighted version of the Laplacian simply works with the weighted degree
instead of the plain degree. I.e. (i,j) is d[i], the weighted degree of
vertex i if if i==j, -w if i!=j and there is an edge between vertices i and
j with weight w, and 0 otherwise. The weighted degree of a vertex is the sum
of the weights of its adjacent edges.
}
\examples{

g <- make_ring(10)
laplacian_matrix(g)
laplacian_matrix(g, norm = TRUE)
laplacian_matrix(g, norm = TRUE, sparse = FALSE)

}
\seealso{
Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{knn}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
