% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_lines.R
\name{write_lines}
\alias{write_lines}
\title{Write lines to a file}
\usage{
write_lines(text, path, eol = "\\n")
}
\arguments{
\item{text}{A character vector to write}

\item{path}{A character string giving the file path to write to.}

\item{eol}{The end of line characters to use between lines.}
}
\value{
The UTF-8 encoded input text (invisibly).
}
\description{
The text is converted to UTF-8 encoding before writing.
}
\details{
The files are opened in binary mode, so they always use exactly the string
given in \code{eol} as the line separator.

To write a file with windows line endings use \code{write_lines(eol = "\\r\\n")}
}
\examples{
tf <- tempfile()

write_lines(rownames(mtcars), tf)

# Write with Windows style line endings
write_lines(rownames(mtcars), tf, eol = "\r\n")

unlink(tf)
}
