/*
  Bear Engine

  Copyright (C) 20052011 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file input_status.hpp
 * \brief A class observing the state of keys/buttons.
 * \author Julien Jorge
 */
#ifndef __INPUT_INPUT_STATUS_HPP__
#define __INPUT_INPUT_STATUS_HPP__

#include "input/joystick_status.hpp"
#include "input/keyboard_status.hpp"
#include "input/mouse_status.hpp"

#include "input/class_export.hpp"

namespace bear
{
  namespace input
  {
    /**
     * \brief A class observing the state of keys/buttons.
     * \author Julien Jorge
     */
    class INPUT_EXPORT input_status
    {
    public:
      void read();

      void scan_inputs( input_listener& listener ) const;

    private:
      /** \brief Status of the keyboard's keys. */
      keyboard_status m_keyboard;

      /** \brief Status of the joysticks' buttons. */
      joystick_status m_joystick;

      /** \brief Status of the mouse's keys. */
      mouse_status m_mouse;

    }; // input_status
  } // namespace input
} // namespace bear

#endif // __INPUT_INPUT_STATUS_HPP__
