###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# SquirrelMail Prior to 1.4.18 Multiple Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100203);
 script_bugtraq_id(34916);
 script_cve_id("CVE-2009-1578","CVE-2009-1579","CVE-2009-1580","CVE-2009-1581");
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");

 script_name("SquirrelMail Prior to 1.4.18 Multiple Vulnerabilities");
 desc = "

 Overview:
  SquirrelMail is prone to multiple vulnerabilities, including
  multiple session-fixation issues, a code-injection issue, and
  multiple cross-site scripting issues.

  Attackers may exploit these issues to execute arbitrary script code
  in the browser of an unsuspecting user, to hijack the session of a
  valid user, or to inject and execute arbitrary PHP code in the
  context of the webserver process. This may facilitate a compromise
  of the application and the computer; other attacks are also
  possible.

  Versions prior to SquirrelMail 1.4.18 are vulnerable. 

 See also:
  http://www.securityfocus.com/bid/34916

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if SquirrelMail Version <= 1.4.18");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("squirrelmail_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/squirrelmail")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less_equal(version: vers, test_version: "1.4.18")) {
      security_warning(port:port);
      exit(0);
  }  

} 

exit(0);
