###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openwebmail_mult_xss_vuln.nasl 4686 2009-09-17 12:24:11Z sep $
#
# OpenWebMail Multiple XSS Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900943);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-7202");
  script_bugtraq_id(25175);
  script_name("OpenWebMail Multiple XSS Vulnerabilities");
  desc = "
  Overview: This host is installed with OpenWebMail and is prone to
  multiple cross-sites scripting vulnerabilities.

  Vulnerability Insight:
  The vulnerability is caused because the application does not
  sanitise the user supplied data.

  Impact:
  Successful exploitation will allow remote attackers to inject arbitrary
  web script or HTML via unknown vectors and conduct cross-sites attacks.

  Impact Level: Application

  Affected Software/OS:
  OpenWebMail versions prior to 2.53

  Fix: Upgrade to version 2.53 or later.
  http://openwebmail.org/

  References:
  http://osvdb.org/40581
  http://freshmeat.net/projects/openwebmail/releases/270453
  http://pridels-team.blogspot.com/2007/08/openwebmail-multiple-xss-vuln.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of OpenWebMail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("openwebmail_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

owmPort = get_http_port(default:80);
if(!owmPort)
{
  exit(0);
}

owmVer = get_kb_item("www/" + owmPort + "/openwebmail");
owmVer = eregmatch(pattern:"^(.+) under (/.*)$", string:owmVer);

if(owmVer[1] =~ "[0-9.]+")
{
  if(version_is_less(version:owmVer[1], test_version:"2.53")){
    security_warning(owmPort);
  }
}
