##############################################################################
#
#  Novell eDirectory Multiple Vulnerabilities (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/02
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0159
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900209);
 script_bugtraq_id(30947);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("Novell eDirectory Multiple Vulnerabilities (Win)");
 script_summary("Check for Novell eDirectory version");
 desc = "
 Overview : This host is running Novell eDirectory, which is prone to XSS,
 Denial of Service, and Remote Code Execution Vulnerabilities.

 Vulnerability Insight :

        Multiple flaw are due to,
        - errors in HTTP Protocol Stack that can be exploited to cause heap
          based buffer overflow via a specially crafted language/content-length
          headers.
        - input passed via unspecified parameters to the HTTP Protocol Stack is
          not properly sanitzed before being returned to the user.
        - Multiple unknown error exist in LDAP and NDS services.

        Impact : Successful Remote exploitation will allow execution of 
        arbitrary code, heap-based buffer overflow, Cross Site Scripting 
        attacks, or cause memory corruption.

 Impact Level : System

 Affected Software/OS :
       	Novell eDirectory 8.8 SP2 and prior versions on Windows 2000/2003. 

 Fix : Apply 8.8 Service Pack 3.
 http://download.novell.com/Download?buildid=RH_B5b3M6EQ~

 References : http://secunia.com/advisories/31684
              http://securitytracker.com/alerts/2008/Aug/1020788.html
              http://securitytracker.com/alerts/2008/Aug/1020787.html
              http://securitytracker.com/alerts/2008/Aug/1020786.html
              http://securitytracker.com/alerts/2008/Aug/1020785.html

 CVSS Score :
        CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
        CVSS Temporal Score : 6.9
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 port = 8028;
 if(!get_port_state(port))
 {
 	port = 8030;
 	if(!get_port_state(port)){
        	exit(0);
	}
 }

 eDirVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                               "\Uninstall\NDSonNT", item:"DisplayName");
 if(!eDirVer){
	exit(0);
 }

 # Grep for Novell eDirectory Version < 8.8 SP2 
 if(!(egrep(pattern:"^Novell eDirectory ([0-7]\..*|8\.[0-7]( .*)?|8\.8( SP[0-2])?)$",
            string:eDirVer))){
        exit(0);
 }

 eDirPath = registry_get_sz(key:"SOFTWARE\NOVELL\NDS\NDSSNMPAgent" + 
                                "\CurrentVersion", item:"Pathname");
 if(!eDirPath){
        exit(0);
 }

 eDirPath = eDirPath - "ndssnmpsa.dll";

 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:eDirPath);
 file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:eDirPath + 
                      "nauditds.dlm ");

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot){
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r){
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

 tid = tconx_extract_tid(reply:r);
 if(!tid){
        close(soc);
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid){
        close(soc);
        exit(0);
 }

 # Check for patch (By file size).
 fsize = smb_get_file_size(socket:soc, uid:uid, tid:tid, fid:fid);
 close(soc);

 if(!fsize){
	exit(0);
 }

 if(fsize < 110592){
        security_warning(0);
 }
