#############################################################################
#
#  AVG Anti-Virus UPX Processing Denial of Service Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/07/30
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0065
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900017);
 script_cve_id("CVE-2008-3373");
 script_bugtraq_id(30417);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_tag(name:"cvss_base", value:"7.1");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("AVG Anti-Virus UPX Processing Denial of Service Vulnerability");
 script_summary("Check for the version of AVG Anti-Virus");
 desc = "
 Overview : The remote host is installed with AVG AntiVirus, which is prone
 to denial of service vulnerability.

 Vulnerability Insight :

        The flaw is caused to a divide by zero error in file parsing engine
        while handling UPX compressed executables.

        Impact : Remote attackers with successful exploitation could deny
        the service by causing the scanning engine to crash.

 Impact Level : Application.

 Affected Software/OS :
	AVG Anti-Virus prior to 8.0.156 on Windows (All).

 Fix : Upgrade to latest AVG Anti-Virus 8.0.156 or later.
 http://www.grisoft.com/ww.download-trial

 References : http://www.grisoft.com/ww.94247

 CVSS Score :
        CVSS Base Score	    : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 5.3
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 if(!registry_key_exists(key:"SOFTWARE\AVG")){
	exit(0);
 }

 for (i=1; i<=8; i++)
 {
 	avgVer = registry_get_sz(key:"SOFTWARE\AVG\AVG" + i + "\LinkScanner\Prevalence",
			 	 item:"CODEVER");
	if(avgVer)
	{
		# Grep AVG Anti-Virus version < 8.0.156
 		if(egrep(pattern:"^([0-7]\..*|8\.0(\.([0-9]?[0-9]|1[0-4]" +
				 "[0-9]|15[0-5])))$", string:avgVer)){
			security_hole(0);
		}
		exit(0);
	}
 }
