###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wireshark_wiretap_dos_vuln_nov09_win.nasl 5564 2009-11-03 18:23:24Z nov $
#
# Wireshark 'wiretap/erf.c' Unsigned Integer Wrap Vulnerability - Nov09 (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801036);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3829");
  script_bugtraq_id(36846);
  script_name("Wireshark 'wiretap/erf.c' Unsigned Integer Wrap Vulnerability - Nov09 (Win)");
  desc = "
  Overview: This host is installed with Wireshark and is prone to unsigned integer
  wrap vulnerability.

  Vulnerability Insight:
  The flaw exists due to an integer overflow error in 'wiretap/erf.c' when
  processing an 'erf' file causes Wireshark to allocate a very large buffer.

  Impact:
  Successful remote exploitation will let the attacker execute arbitrary code
  or cause a Denial of Service.

  Impact Level: Application.

  Affected Software/OS:
  Wireshark version prior to 1.2.2 on Windows.

  Fix: Upgrade to Wireshark 1.2.2
  http://www.wireshark.org/download.html

  References:
  http://www.kb.cert.org/vuls/id/676492
  https://bugs.wireshark.org/bugzilla/show_bug.cgi?id=3849

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_win.nasl");
  script_require_keys("Wireshark/Win/Ver");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Win/Ver");
if(!sharkVer){
  exit(0);
}

# Grep for Wireshark version < 1.2.2
if(version_is_less(version:sharkVer, test_version:"1.2.2")){
  security_hole(0);
}
