###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for PostgreSQL vulnerabilities USN-876-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840360);
  script_version("$Revision: 7480 $: 1.0");
  script_tag(name:"cvss_base", value:"6.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "876-1");
  script_cve_id("CVE-2009-4034", "CVE-2009-4136");
  script_name("Ubuntu Update for PostgreSQL vulnerabilities USN-876-1");
  desc = "

  Vulnerability Insight:

  It was discovered that PostgreSQL did not properly handle certificates with
  NULL characters in the Common Name field of X.509 certificates. An attacker
  could exploit this to perform a man in the middle attack to view sensitive
  information or alter encrypted communications. (CVE-2009-4034)
  
  It was discovered that PostgreSQL did not properly manage session-local
  state. A remote authenticated user could exploit this to escalate
  priviliges within PostgreSQL. (CVE-2009-4136)

  Affected Software/OS:
  PostgreSQL vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001018.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of PostgreSQL vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg6", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq5", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.3_8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3_8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3_8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.3_8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.3_8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.3_8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.3_8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3_8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.3.9-0ubuntu9.04", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.1_8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.1_8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.1_8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.1_8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.1_8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.1_8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.1_8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.1_8.1.19-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg6", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq5", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.3_8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3_8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3_8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.3_8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.3_8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.3_8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.3_8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3_8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.3.9-0ubuntu8.10", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg6", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq5", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.3_8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3_8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3_8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.3_8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.3_8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.3_8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.3_8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3_8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.3.9-0ubuntu8.04", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg6", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq5", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.4_8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.4_8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.4_8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.4_8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.4_8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.4_8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.4_8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.4_8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.4.2-0ubuntu9.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}