###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_xml_dos_vuln_lin.nasl 1428 2009-04-06 18:13:23Z apr $
#
# Opera Web Browser XML Denial Of Service Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800551);
  script_version("$Revision: 7922 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1234");
  script_bugtraq_id(34298);
  script_name("Opera Web Browser XML Denial Of Service Vulnerability (Linux)");
  desc = "

  Overview: The host is installed with Opera Web Browser and is prone to
  XML Denial of Service vulnerability.

  Vulnerability Insight:
  This flaw is caused due to improper boundary check while parsing XML
  documents containing an overly large number of nested elements.

  Impact:
  Successful exploitation will let the attacker craft a malicious XML page
  and cause denial of service by persuading the user to open the malicious
  arbitrary page.

  Impact Level: Application

  Affected Software/OS:
  Opera version 9.64 and prior on Linux.

  Fix: Upgrade to Opera version 10.00 or later.
  For updates refer, http://www.opera.com/download

  References:
  http://www.milw0rm.com/exploits/8320
  http://xforce.iss.net/xforce/xfdb/49522

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Opera");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_opera_detection_linux_900037.nasl");
  script_require_keys("Opera/Linux/Version");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Linux/Version");
if(!operaVer){
  exit(0);
}

if(version_is_less_equal(version:operaVer, test_version:"9.64")){
  security_warning(0);
}
