###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_gdiplus_png_infinite_loop_vuln.nasl 2009-05-04 16:11:07Z may $
#
# Microsoft GDIPlus PNG Infinite Loop Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800700);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1511");
  script_bugtraq_id(34586);
  script_name("Microsoft GDIPlus PNG Infinite Loop Vulnerability");
  desc = "

  Overview : This host is running Windows XP Operating System with GDI libraries
  installed which is prone to Infinite Loop vulnerability.

  Vulnerability Insight:
  This flaw is caused while processing crafted PNG file containing a large
  btChunkLen value which causes the control to enter an infinite loop.

  Impact:
  Successful exploitation will let the attacker cause denial of service.

  Impact Level: System

  Affected Software/OS:
  Windows XP Service Pack 3 and prior.

  Fix: No solution or patch is available as on 6th May, 2009. Information
  regarding this issue wil be updated once the solution details are available.
  For further updates, refer http://www.microsoft.com

  References:
  http://www.milw0rm.com/exploits/8466

  CVSS Score:
    CVSS Base Score     : 7.8 (AV:N/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 7.0
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Windows and Service Pack");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4) > 0){
  security_hole(0);
}
