###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for quagga FEDORA-2007-0838
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861433);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.3");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-0838");
  script_cve_id("CVE-2007-1995");
  script_name( "Fedora Update for quagga FEDORA-2007-0838");
  desc = "

  Vulnerability Insight:
  Quagga is a free software that manages TCP/IP based routing
  protocol. It takes multi-server and multi-thread approach to resolve
  the current complexity of the Internet.
  
  Quagga supports BGP4, BGP4+, OSPFv2, OSPFv3, RIPv1, RIPv2, and RIPng.
  
  Quagga is intended to be used as a Route Server and a Route Reflector. It is
  not a toolkit, it provides full routing power under a new architecture.
  Quagga by design has a process for each protocol.
  
  Quagga is a fork of GNU Zebra.


  Affected Software/OS:
  quagga on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-July/msg00060.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of quagga");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"quagga", rpm:"quagga~0.99.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"quagga-contrib", rpm:"quagga-contrib~0.99.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"quagga", rpm:"quagga~0.99.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"quagga-debuginfo", rpm:"quagga-debuginfo~0.99.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"quagga-devel", rpm:"quagga-devel~0.99.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"quagga-devel", rpm:"quagga-devel~0.99.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"quagga-debuginfo", rpm:"quagga-debuginfo~0.99.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"quagga-contrib", rpm:"quagga-contrib~0.99.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"quagga", rpm:"quagga~0.99.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}