###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_drupal_info_disclosure_vuln.nasl 3364 2009-07-14 11:56:45Z jul $
#
# Drupal Information Disclosure Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800909);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2374");
  script_bugtraq_id(35548);
  script_name("Drupal Information Disclosure Vulnerability");
  desc = "

  Overview: The host is installed with Drupal and is prone to Information
  Disclosure vulnerability.

  Vulnerability Insight:
  Application fails to sanitize login attempts for pages that contain a sortable
  table, which includes the username and password in links that can be read from
  the HTTP referer header of external web sites that are visited from those links
  or when page caching is enabled, the Drupal page cache.

  Impact:
  Attackers can exploit this issue to obtain that set of credentials which
  are included in the generated links.

  Impact Level: Application

  Affected Software/OS:
  Drupal Version 5.x before 5.19 and 6.x before 6.13 on all platforms.

  Fix: Upgrade to Drupal 5.19 or 6.13 or later
  http://drupal.org

  References:
  http://drupal.org/node/507572
  http://secunia.com/advisories/35657
  http://securitytracker.com/alerts/2009/Jul/1022497.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Drupal");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("drupal_detect.nasl");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

drPort = get_http_port(default:80);
if(!drPort){
  exit(0);
}

drupalVer = get_kb_item(string("www/", drPort, "/drupal"));
drupalVer = eregmatch(pattern:"^(.+) under (/.*)$", string:drupalVer);

if(!drupalVer[1]){
  exit(0);
}

# Check for Drupal Version 5.0 < 5.19 and 6.0 < 6.13
if(version_in_range(version:drupalVer[1], test_version:"5.0", test_version2:"5.18") ||
   version_in_range(version:drupalVer[1], test_version:"6.0", test_version2:"6.12")){
  security_warning(drPort);
}
