#
#VID d864a0a7-6f27-11dd-acfe-00104b9e1a4a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(61447);
 script_cve_id("CVE-2008-2377");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.6");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: gnutls";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: gnutls

CVE-2008-2377
Use after free vulnerability in the
_gnutls_handshake_hash_buffers_clear function in
lib/gnutls_handshake.c in libgnutls in GnuTLS 2.3.5 through 2.4.0
allows remote attackers to cause a denial of service (crash) or
possibly execute arbitrary code via TLS transmission of data that is
improperly used when the peer calls gnutls_handshake within a normal
session, leading to attempted access to a deallocated libgcrypt
handle.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://article.gmane.org/gmane.comp.encryption.gpg.gnutls.devel/2947
http://secunia.com/advisories/31505/
http://www.vuxml.org/freebsd/d864a0a7-6f27-11dd-acfe-00104b9e1a4a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gnutls";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gnutls");
if(!isnull(bver) && revcomp(a:bver, b:"2.3.5")>=0 && revcomp(a:bver, b:"2.4.1")<0) {
    security_note(0, data:"Package gnutls version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
