# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9837 (wireshark)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66186);
 script_cve_id("CVE-2009-2559", "CVE-2009-2560", "CVE-2009-2561", "CVE-2009-2562", "CVE-2009-2563", "CVE-2009-3241", "CVE-2009-3242");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-9837 (wireshark)");

 desc = "The remote host is missing an update to wireshark
announced via advisory FEDORA-2009-9837.

Update Information:

Update to Wireshark 1.2.2 fixing multiple security issues:
http://www.wireshark.org/docs/relnotes/wireshark-1.2.2.html
http://www.wireshark.org/security/wnpa-sec-2009-06.html

For details, please visit the referenced security advisories.

ChangeLog:

* Tue Sep 22 2009 Radek Vokal  - 1.2.2
- upgrade to 1.2.2
- http://www.wireshark.org/docs/relnotes/wireshark-1.2.2.html

References:

[ 1 ] Bug #512953 - CVE-2009-2559 Wireshark-1.2.0: DoS (crash) due array index error in IPMI dissector
https://bugzilla.redhat.com/show_bug.cgi?id=512953
[ 2 ] Bug #513008 - CVE-2009-2560 Wireshark: Null-ptr dereference in the RADIUS dissector
https://bugzilla.redhat.com/show_bug.cgi?id=513008
[ 3 ] Bug #513033 - CVE-2009-2561 Wireshark: Dos (excessive CPU and memory use) via large amount of tree items in the sFlow dissector
https://bugzilla.redhat.com/show_bug.cgi?id=513033
[ 4 ] Bug #512987 - CVE-2009-2562 Wireshark: Integer overflow in the AFS dissector
https://bugzilla.redhat.com/show_bug.cgi?id=512987
[ 5 ] Bug #512992 - CVE-2009-2563 Wireshark: Null-ptr dereference in the InfiniBand dissector
https://bugzilla.redhat.com/show_bug.cgi?id=512992
[ 6 ] Bug #523987 - CVE-2009-3241 Wireshark: DoS (excessive CPU use) in OPCUA dissector
https://bugzilla.redhat.com/show_bug.cgi?id=523987
[ 7 ] Bug #524001 - CVE-2009-3242 Wireshark: DoS (crash) in GSM A RR dissector
https://bugzilla.redhat.com/show_bug.cgi?id=524001

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update wireshark' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9837

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-9837 (wireshark)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.2.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~1.2.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-debuginfo", rpm:"wireshark-debuginfo~1.2.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
