# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1842-1 (openexr)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64481);
 script_cve_id("CVE-2009-1720", "CVE-2009-1721", "CVE-2009-1722");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1842-1 (openexr)");

 desc = "The remote host is missing an update to openexr
announced via advisory DSA 1842-1.

Several vulnerabilities have been discovered in the OpenEXR image
library, which can lead to the execution of arbitrary code. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2009-1720

Drew Yao discovered integer overflows in the preview and
compression code.

CVE-2009-1721

Drew Yao discovered that an uninitialised pointer could be freed
in the decompression code.

CVE-2009-1722

A buffer overflow was discovered in the compression code.

For the old stable distribution (etch), these problems have been fixed
in version 1.2.2-4.3+etch2.

For the stable distribution (lenny), these problems have been fixed
in version 1.6.1-3+lenny3.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your openexr packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201842-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1842-1 (openexr)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libopenexr-dev", ver:"1.2.2-4.3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openexr", ver:"1.2.2-4.3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenexr2c2a", ver:"1.2.2-4.3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openexr", ver:"1.6.1-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenexr6", ver:"1.6.1-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenexr-dev", ver:"1.6.1-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
