# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1239-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57738);
 script_cve_id("CVE-2006-4244", "CVE-2006-4731", "CVE-2006-5872");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1239-1 (sql-ledger)";
 script_name(name);

 desc = "The remote host is missing an update to sql-ledger
announced via advisory DSA 1239-1.

Several remote vulnerabilities have been discovered in SQL Ledger, a web
based double-entry accounting program, which may lead to the execution
of arbitrary code. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2006-4244

Chris Travers discovered that the session management can be tricked
into hijacking existing sessions.

CVE-2006-4731

Chris Travers discovered that directory traversal vulnerabilities
can be exploited to execute arbitrary Perl code.

CVE-2006-5872

It was discovered that missing input sanitising allows execution of
arbitrary Perl code.

For the stable distribution (sarge) these problems have been fixed in
version 2.4.7-2sarge1.

For the upcoming stable distribution (etch) these problems have been
fixed in version 2.6.21-1.

For the unstable distribution (sid) these problems have been fixed in
version 2.6.21-1.

We recommend that you upgrade your sql-ledger packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201239-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1239-1 (sql-ledger)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sql-ledger", ver:"2.4.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
