%%NAME
%%  eappend -  append an eps-file  behind an other eps-file
%%
%%SYNOPSIS
%%  eappend(toEpsFileName[,addEpsFilenName])
%%
%%PARAMETER(S)
%%  toEpsFileName   name of new eps-file 
%%  addEpsFileName  name of eps-file, which have to add
%%                  default: last eps file
%%
%%GLOBAL PARAMETER(S)
%%  eFileName
% written by stefan.mueller@fhr.fraunhofer.de (C) 2010

function eappend(toEpsFileName,addEpsFileName)
  if nargin<1
    eusage('eappend(toEpsFileName [,addEpsFileName])');
  end

  eglobpar;
  if nargin<2
    addEpsFileName=eFileName;
  end
  
  addEpsFile=fopen(addEpsFileName,'rb');
  [data n]=fread(addEpsFile,inf,'uchar');
  fclose(addEpsFile);
  epsFile=fopen(toEpsFileName,'ab');
  fwrite(epsFile,data,'uchar');
  fclose(epsFile);
