/* NVTV direct card access (header) -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: card_direct.h,v 1.5 2003/10/10 16:16:57 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Access the graphics card directly (via mmaps)
 *
 */

#ifndef _CARD_DIRECT_H
#define _CARD_DIRECT_H

#include "backend.h"

#define DEV_WINIO	"winio"
#define DEV_MEM		"/dev/mem"
#define DEV_NVCTL	"/dev/nvidiactl"

int openDevMem (CardPtr card);
void closeDevMem (CardPtr card, int fd);
void *mapDevMem (CardPtr card, int fd, unsigned long Base, unsigned long Size);
void unmapDevMem (CardPtr card, unsigned long Base, unsigned long Size);

void scan_cards_pci (CardPtr *card_root_list, char *devname);
void scan_cards_nvdev (CardPtr *card_nvdev_list);

#endif /* _CARD_DIRECT_H */
