<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Mouse](./puppeteer.mouse.md) &gt; [wheel](./puppeteer.mouse.wheel.md)

## Mouse.wheel() method

Dispatches a `mousewheel` event.

<b>Signature:</b>

```typescript
wheel(options?: MouseWheelOptions): Promise<void>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | [MouseWheelOptions](./puppeteer.mousewheeloptions.md) | Optional: <code>MouseWheelOptions</code>. |

<b>Returns:</b>

Promise&lt;void&gt;

## Example

An example of zooming into an element:

```js
await page.goto('https://mdn.mozillademos.org/en-US/docs/Web/API/Element/wheel_event$samples/Scaling_an_element_via_the_wheel?revision=1587366');

const elem = await page.$('div');
const boundingBox = await elem.boundingBox();
await page.mouse.move(
  boundingBox.x + boundingBox.width / 2,
  boundingBox.y + boundingBox.height / 2
);

await page.mouse.wheel({ deltaY: -100 })

```

