/*
 * Generated with the genpubsuffix tool.
 *  From file public_suffix_list.dat
 *  Converted on Sun May 24 17:31:24 2020
 */

/**
 * Public suffix list graph node
 */
union pnode {
    struct {
        unsigned int idx:24; /**< index of domain element in string table */
        unsigned int len:6; /**< length of domain element in string table */
        unsigned int children:1; /**< has children */
    } label;
    struct {
        uint16_t index; /**< index of first child node */
        uint16_t count; /**< number of children of this node */
    } child;
};

enum stab_entities {
    STAB_WILDCARD = 0,
    STAB_EXCEPTION = 11
};

/**
 * Huffman coding node
 */
struct hnode {
    uint8_t term:1; /**< non zero if the node terminates a code */
    uint8_t value:7; /**< value in node */
};

/**
 * Huffman decoding table
 *
 * nodes are in pairs even nodes are for 0bit odd for 1
 */
static const struct hnode htable[76] = {
    { 0, 2 },
    { 0, 46 },
    { 0, 4 },
    { 0, 38 },
    { 0, 6 },
    { 0, 18 },
    { 0, 8 },
    { 1, 't' }, /* 't': 0001 */
    { 0, 10 },
    { 1, 'g' }, /* 'g': 00001 */
    { 0, 12 },
    { 1, 'w' }, /* 'w': 000001 */
    { 0, 14 },
    { 0, 16 },
    { 1, '0' }, /* '0': 00000000 */
    { 1, '2' }, /* '2': 00000001 */
    { 1, '3' }, /* '3': 00000010 */
    { 1, 'q' }, /* 'q': 00000011 */
    { 0, 20 },
    { 0, 36 },
    { 0, 22 },
    { 1, 'c' }, /* 'c': 00101 */
    { 0, 24 },
    { 1, 'v' }, /* 'v': 001001 */
    { 0, 26 },
    { 1, 'j' }, /* 'j': 0010001 */
    { 0, 28 },
    { 0, 34 },
    { 0, 30 },
    { 1, '8' }, /* '8': 001000001 */
    { 0, 32 },
    { 1, '9' }, /* '9': 0010000001 */
    { 1, '*' }, /* '*': 00100000000 */
    { 1, '!' }, /* '!': 00100000001 */
    { 1, '6' }, /* '6': 001000010 */
    { 1, '7' }, /* '7': 001000011 */
    { 1, 'h' }, /* 'h': 00110 */
    { 1, 'd' }, /* 'd': 00111 */
    { 0, 40 },
    { 1, 'a' }, /* 'a': 011 */
    { 1, 'r' }, /* 'r': 0100 */
    { 0, 42 },
    { 0, 44 },
    { 1, 'k' }, /* 'k': 01011 */
    { 1, 'f' }, /* 'f': 010100 */
    { 1, 'x' }, /* 'x': 010101 */
    { 0, 48 },
    { 0, 64 },
    { 0, 50 },
    { 0, 62 },
    { 1, 's' }, /* 's': 1000 */
    { 0, 52 },
    { 0, 54 },
    { 1, 'm' }, /* 'm': 10011 */
    { 0, 56 },
    { 1, 'p' }, /* 'p': 100101 */
    { 0, 58 },
    { 1, 'z' }, /* 'z': 1001001 */
    { 1, '1' }, /* '1': 10010000 */
    { 0, 60 },
    { 1, '5' }, /* '5': 100100010 */
    { 1, '4' }, /* '4': 100100011 */
    { 1, 'o' }, /* 'o': 1010 */
    { 1, 'e' }, /* 'e': 1011 */
    { 0, 66 },
    { 0, 70 },
    { 1, 'n' }, /* 'n': 1100 */
    { 0, 68 },
    { 1, 'u' }, /* 'u': 11010 */
    { 1, 'l' }, /* 'l': 11011 */
    { 1, 'i' }, /* 'i': 1110 */
    { 0, 72 },
    { 0, 74 },
    { 1, '-' }, /* '-': 11111 */
    { 1, 'y' }, /* 'y': 111100 */
    { 1, 'b' }, /* 'b': 111101 */
};

/**
 * Domain label string table huffman encoded.
 * 6344 labels(368592 bits) reduced to 4423 labels(173312 bits)
 */
static const uint32_t stab[5416] = {
    0x3AA02004, 0xE912D3FF, 0xB1FDF8AB, 0x6BCAD377, 0x43E3BA8E, 0x34090146,
    0xE04B2765, 0x3DE7C4F5, 0xBF1D8178, 0xA1E22BE7, 0x7C60569D, 0xBBD8FF0F,
    0xE6BCE569, 0x426AF1A8, 0x7A51FF9D, 0xF07EA6F0, 0x3FB5278F, 0xC87B7A05,
    0x83DC9A93, 0x5A26B4DE, 0x04D5E348, 0x8DFB07D0, 0xFF4EFEC3, 0x076B2094,
    0xFA0084FE, 0xD871BF60, 0x5A8FE9DF, 0x3F81DAC8, 0xD83E8021, 0x77F61C6F,
    0xB216A3FA, 0x5407E076, 0x1E947FE7, 0x3FC1F9BC, 0x92FED49E, 0x1FF9D57C,
    0xEA6F07A5, 0xDA93C707, 0x3AAF923F, 0xE0F4A3FF, 0x78FF054D, 0xF24BFB52,
    0xB27FE755, 0x789EC325, 0xE06B8C5B, 0x9537C14F, 0x6C978D23, 0x6EC8DED6,
    0xB6878962, 0xF4A3FF3A, 0x8E0FCDE0, 0x613FB527, 0x7FE755F2, 0xA9BC1E94,
    0xFB5278E0, 0x755F2613, 0xC1E947FE, 0x4F1FE09B, 0xE4427F6A, 0x64FFCEAB,
    0xF13D864B, 0x3E5B18B6, 0x1E94D7C5, 0x437FC1EF, 0xE341E076, 0x3FF3A8D5,
    0x04DE0F4A, 0x7FDA93C7, 0xFFE755E2, 0x3F3C3BD7, 0xFED49E38, 0xFF3AAF13,
    0xE7876BBF, 0xDA93C707, 0xE755E27F, 0x70A240FF, 0xD1DE60EF, 0x55F803F3,
    0xFD2CFFE7, 0x1CA97E0B, 0x0303FBDC, 0x4FFCEABF, 0xA0146537, 0x4202F00D,
    0x29081340, 0x03D11D4F, 0x8A23BE5B, 0x146AF19E, 0x93EFB5B9, 0x7F3C9D3D,
    0xD59F6B78, 0xDEF49FF9, 0x0577F9FD, 0x7AF66FF6, 0x6BFF9CB8, 0x8FE88DD9,
    0x970F39E2, 0xDCF147F3, 0x11BB2D7F, 0x23765AFD, 0xEE78A3FA, 0xD59CB87B,
    0x64ADFFF9, 0x278E0FCF, 0xBD603FB5, 0xDFE926B9, 0xFEDEF79F, 0x69279CAF,
    0x0F7DCF14, 0x2D7FF397, 0xE28D11BB, 0x765AFFB9, 0xB87BFA23, 0xDFF9D59C,
    0xFC17424B, 0x27F87B6C, 0xFFCEABCE, 0x4D883B93, 0x1FD7CEAE, 0xFA00EBE9,
    0x57F1A5CA, 0x07E4587C, 0x5C27F03B, 0xC6E57F7C, 0x9CDBCF43, 0x37A928BC,
    0xBBBF485A, 0x1AD0B457, 0x6E4541EC, 0x4F64FBED, 0xD6F0CF27, 0x6B722B3E,
    0xC9D3D91F, 0xF6B787F3, 0x39AED699, 0x3EF6F06F, 0x409778E7, 0x95A7FE75,
    0xC7751CD7, 0xB0190927, 0x9BC4B8C6, 0x93C9605D, 0xEACAF457, 0x4A04FFFC,
    0xA5C7D8FF, 0xEABE22FF, 0xFD119FFC, 0x8D122149, 0xA2B6135F, 0x6260FFCE,
    0x37A89821, 0x44AD8541, 0xF401C47C, 0xB0E37EC1, 0x0EDF8AFF, 0xF40109FC,
    0xB0E37EC1, 0x760F8AFF, 0xA0084FE0, 0x871BF60F, 0xB07C57FD, 0x00603F03,
    0x38DFB07D, 0x83EBDFEC, 0x0213F81D, 0xC6FD83E8, 0x6FF0FF61, 0xD784FE07,
    0x2FF7BD22, 0x7029EBE5, 0xF17D8737, 0xA896D3FD, 0x4DF146F1, 0xBB533C4B,
    0x85F9F3E0, 0x8D5E340E, 0x83DE3D29, 0x7B26953F, 0xF27C6AF0, 0x4728AC51,
    0xA941AD3F, 0x7DADC8AD, 0xCF274F64, 0xA33ED6F0, 0x7D4DE0F4, 0x7E6FAC6F,
    0xF07A51B0, 0xE6AC7EA6, 0xAB6A4F1F, 0xBDE93FF3, 0xFB02BBFB, 0xF3AAFBF7,
    0x9BBDE93F, 0xF7FB02BB, 0x9CB87AFB, 0x446ECB5F, 0xC3CE78A3, 0xB9E28CE5,
    0xD11BB2D7, 0x3B4FFCEA, 0x9295FC7A, 0xD57D33FD, 0xD9295FF9, 0xF8F4769F,
    0xF145F42B, 0xF9CB879C, 0x3446ECB5, 0xCB5EE78A, 0xB87B446E, 0x4BF3739C,
    0x2C0BB0DE, 0x63ACA0B9, 0xD8096B8C, 0x399413D8, 0xF9D47B4D, 0x3A7C3C3F,
    0x0BF3D882, 0xFFFCEABE, 0xAE4D4A32, 0x84D7F1C2, 0x10FFCEAD, 0xFED3BC9A,
    0x26271F04, 0x9FF9D4CC, 0x3B4A2CE5, 0x9B123FD0, 0xAEBFF3AA, 0x3FA34ABD,
    0x0889C7E1, 0xD7FE7533, 0xFDA62C42, 0x3137E819, 0xFE754481, 0xC5A4F90F,
    0x843E5B03, 0x33FF3AAF, 0xD76AB1DA, 0x2818FC27, 0xFFCEABD1, 0x692DBE19,
    0x89E22762, 0x5430904D, 0x5F0CFFE7, 0xA610FDE0, 0x58442600, 0x916BE979,
    0xAF94BFDE, 0x1CDDC0A7, 0x0B69AB76, 0x5395A7C6, 0x503BBBF4, 0xC7E6F07A,
    0xA4F1FE6A, 0xDE0F4A36, 0x32C6F7D4, 0x3D28D83F, 0x163F5378, 0x1B5278FF,
    0xEA6F07A5, 0x278E6AC7, 0xF07A51B5, 0xBEB1BCA6, 0xE946C1F9, 0xD58A9BC1,
    0x6D49E3FC, 0xBD27FE75, 0xFB02BB77, 0xF3AB6137, 0xB1E8ED3F, 0x11FFB252,
    0x2BFF3AB4, 0xF4769B25, 0xCE8253F8, 0xEF374935, 0x79CAFDBD, 0xB2166692,
    0x7EEF6903, 0x413578C5, 0x87B687AF, 0x2815F0DF, 0xA1EBD04F, 0xD25C631D,
    0xF3A8777B, 0x4F332BFF, 0x133FE1AC, 0xFFE75534, 0x24DE2DB7, 0xC49FF7D3,
    0x97FFE756, 0x70AB9351, 0xD5B123FC, 0xD6985FF9, 0x7D71242D, 0xEA2B0480,
    0xD0DBBFFC, 0x4FF69DE4, 0xF3AAF804, 0x7246DE7F, 0x47EF9A55, 0x3FF3AB62,
    0x10F64937, 0x893FFA05, 0x81FFCEAD, 0x7B0B1FD2, 0xEABE927E, 0xA5C31FFC,
    0x0FF0F6FF, 0xFE755F40, 0x11F5F0CF, 0x1A4D44E8, 0x129DE000, 0xB6076064,
    0xBCB85E4C, 0x6EF64C51, 0xE2589B89, 0xE6D6FDA1, 0x037581FB, 0xD2D640A7,
    0xAE9FDF17, 0x1FEEE8F7, 0x86A764DB, 0xCF37691D, 0x64BEDEF5, 0x4D90B44B,
    0x04B60D6B, 0x17E6E9CA, 0x4D5C457A, 0x947D2DBC, 0xCDE0F4A1, 0x9E3FC58F,
    0xC1E946D4, 0x39AB1F9B, 0xE946D49E, 0xB1FA9BC1, 0x46D49E38, 0xF29BC1E9,
    0xD83F32C6, 0x53783D28, 0x93C7F8B1, 0x783D28DA, 0xE39AB153, 0x1E946D49,
    0xFCD589BC, 0xB7ED49E3, 0xDF53D276, 0x60FCCB1B, 0x735BCB53, 0xC77707FE,
    0x8EEE0E39, 0x796A7C73, 0xA0ECCE6B, 0xC6365D83, 0xECD9760A, 0x7A8E4B02,
    0x7C6BD147, 0x5D84B8C6, 0x6505C960, 0x87AF411D, 0x0BB387B6, 0x77B0792C,
    0xCD79CAEB, 0xA8D5E369, 0x3D937FF3, 0x0D8001F7, 0xCEAD0090, 0x5BF60CFF,
    0x021FE681, 0xB5FF9D59, 0xE62D60F0, 0x3AB4133F, 0xBFD293FF, 0x4D7CB74F,
    0x9FFCEAD0, 0x3F5C0496, 0x148480D0, 0xF90FFE75, 0xFFBDC25E, 0xFE756826,
    0x84903B27, 0x84D53FCF, 0x33FF9D4A, 0x0C12CD7C, 0xB85A88C4, 0x9AABFF3A,
    0xE40DF202, 0x4C00DD44, 0x7C33FF9D, 0x093A047D, 0x44425381, 0xF0CFFE75,
    0x3B13496D, 0x516C4F11, 0x02A07FE7, 0x6E48204E, 0x1100E982, 0x27FF3AB2,
    0x9894058A, 0xA1102048, 0xE7540617, 0x84EA97FF, 0xE2274097, 0x006989D2,
    0x4A7FA77D, 0x7F03B590, 0xA77D0042, 0xB5904A7F, 0x00603F03, 0x6A3FA77D,
    0xFE076B21, 0x4EFA0084, 0xD642D47F, 0xAF80FC0E, 0x612D1814, 0x16C9F1A5,
    0x69FDF17D, 0xC690B44D, 0xFBE2FB23, 0xA0B0ACA7, 0x172D6538, 0xB07BF3DF,
    0x02D37D05, 0x577AD90F, 0xEC1AD0B4, 0xC8DED641, 0xB4B4B53E, 0x63F39252,
    0x3F36478A, 0x8F258A69, 0xF3FCCA77, 0xE94E3C03, 0x4D03C5AE, 0x3FA96B35,
    0x4E89608D, 0xE3409FB7, 0x6BBA7CD5, 0x58FC9F71, 0xEDEDF642, 0x45D6CDA1,
    0xAE27CB5C, 0xC8ADA3C0, 0xEC9F7DAD, 0x33ED6F0F, 0xFCDE0F4A, 0x6A4F1C58,
    0x4DE0F4A3, 0x83F37F7D, 0x3783D28D, 0x49E3E3F5, 0xBC1E946D, 0x4F1C58A9,
    0xE0F4A36A, 0xF1FE2C4D, 0x0F4A36A4, 0x8E6AC4DE, 0xEF5FB527, 0xCD58FCF0,
    0xBBF6A4F1, 0xAC7E7876, 0x9B5278E6, 0xF39ADE5A, 0x8E71DDC1, 0x1CE3BB83,
    0x9CD6F2D4, 0xBB0741D9, 0x06D62760, 0xD83A0ECD, 0x760A93B1, 0x83A0ECD9,
    0x4F7CAC5D, 0xD0763B05, 0x631B2EC1, 0x6E76CE3D, 0xE0F1EA39, 0x578EAF01,
    0x6F01FC3C, 0xFDDEF49A, 0x792C0BB0, 0x3D7A094A, 0x5E8AF3B4, 0x39E96C99,
    0x78C70378, 0x49CADE35, 0xF18C725B, 0xCB59BC6A, 0xECA761A1, 0x94EF79B6,
    0x15ED2D9D, 0xF18969BC, 0xA860B6C8, 0xD2513FF3, 0x13FE1EDE, 0xFF3AB625,
    0xEF70E267, 0xB1284F9E, 0x9B7FF9D5, 0x7D7139B5, 0xF9D58FC2, 0x8850C5FF,
    0x9813FC25, 0xC3FF3AB4, 0xEF43BCDB, 0xCEAC010F, 0x903C5AFF, 0x802FFEE9,
    0x3D9FF9D5, 0x7F1BC3DB, 0xE756C4A2, 0x078E4D7F, 0x600D7CF6, 0x4787FE75,
    0x27F1C2AE, 0xFF9D58F8, 0x2E84F4B7, 0xB62513F8, 0x0D93FF3A, 0xA7DF5825,
    0x7FE75600, 0x6F405355, 0xA034F620, 0xC33FF9D5, 0x843F7817, 0xD4456929,
    0x90013FF9, 0x7A050016, 0x75693713, 0x4F9257FE, 0x0884E410, 0xEACC245C,
    0x6BE19FFC, 0x7DE014C2, 0x1DBDC007, 0x4F6DF478, 0xA00EB7A0, 0x22C3E2BF,
    0x3F81D83F, 0x829787A1, 0x65B06FAC, 0xE7F03B1A, 0x82EEFF9A, 0x7C5C97AB,
    0x1FE1667F, 0x172DD12C, 0xDBDF7FDF, 0x5CF39682, 0xA537CF7C, 0x783D06B5,
    0x3EB06FF1, 0xC4D560B5, 0x4FC29FC5, 0x6B94F05B, 0x82D9117E, 0x4F3CC82D,
    0xF1D930AD, 0x9907F591, 0x2094C777, 0x6B49DAFB, 0x1C51E816, 0x2D8F9FB8,
    0x9595B962, 0x51BE25E6, 0xE2D774C4, 0x696516B4, 0xB914B1A1, 0xD344FC8E,
    0x750F8725, 0xD272B16E, 0xD0FEF7A0, 0xA71FA0D8, 0xBC6A3EE9, 0x716BBA1A,
    0xC1A6702C, 0x378681F8, 0x2DFF9D50, 0x7FE09695, 0xDCAEC31F, 0x4D5BFD28,
    0xFF9D505B, 0xE40D7C33, 0x21024AC4, 0xDF6B722B, 0xB5BC3F27, 0xDADC8ACF,
    0xB786C9F7, 0x5B9159F6, 0xF0FEC8FB, 0xF4A33ED6, 0x9B7D4DE0, 0x1E946C1F,
    0x781FA9BC, 0x07A51B52, 0xFCDFCA6F, 0xE0F4A360, 0x93C7C54D, 0x783D28DA,
    0x49E38B13, 0x3C3BD7ED, 0x93C7163F, 0x7B256FDA, 0x78E6AC7E, 0x3B5DFB52,
    0xC7163F3C, 0x39D4DA93, 0x9FA9EE3D, 0xE6E55F9B, 0xA73A9F57, 0x0D253DC7,
    0xDEA7D5E1, 0xCEACE57E, 0xA4F1C1FF, 0x3F401FF6, 0xBDD82BA5, 0xC72DA766,
    0x19D83A0E, 0xE765631A, 0x9C7BE71B, 0xD8A4EC1D, 0xA7BB0741, 0x66834178,
    0x28EC1D07, 0x5DEECA3B, 0x5D83A0EC, 0xD9C7E25E, 0x5D838579, 0xD9C7E25E,
    0x369E22CA, 0x3B28B868, 0xE7A16F5D, 0xF0B437A8, 0x2F0E579E, 0xF2BDAD18,
    0x36ECA67B, 0x16809E97, 0x976B43DE, 0x8DBA5798, 0xA72B45ED, 0x05D85B0B,
    0x06B43C96, 0x9625A73B, 0xF3AC82C7, 0x4A1E40FB, 0x8F86BBC9, 0xD0778971,
    0x451DA1EB, 0x9C5053DB, 0x1D5E03B2, 0x7F687AF4, 0x4D5E28E5, 0xE14BB1A0,
    0x7A5A0DBD, 0x2835AD05, 0x7B1A074F, 0x06F23EC5, 0x792C0BB2, 0xDF652340,
    0x45DD3FC3, 0x6BFF3AB5, 0x9F3CE669, 0x7FE756AB, 0xC454AD36, 0x3AB04E07,
    0x6C0F6FFF, 0xEAA27E12, 0xF7096240, 0x3D1DE60E, 0xB6FFFCEA, 0x27E126EC,
    0xFFE756AA, 0xFC4E7397, 0x26F2FC59, 0x7E0BFD89, 0x91D33256, 0xFC17FA4B,
    0xB7B83952, 0xDAB3FF3A, 0x533E7BB8, 0xECFFCEAD, 0x0F96C0F1, 0xFE75609C,
    0x2C42A4D7, 0xAB547FE1, 0xAB90FFF3, 0x6819FC70, 0xFCDFFE75, 0xE07CF606,
    0xFFF3AB04, 0xFF3CB620, 0xFCEADC7D, 0x50DA695F, 0xEAD53FF8, 0x0B40FFFC,
    0x8269F9EF, 0x7A5FF9D5, 0x64F9E3A6, 0x5FF9D582, 0xF9EC0DF6, 0xFF3AB559,
    0x90B62687, 0xAC1327CF, 0x67A1FFCE, 0x5457F87B, 0x207FF3AB, 0x8FF7B851,
    0x7FF3AB04, 0xE6A457C8, 0x9D582703, 0x717E43FF, 0x609C0FEF, 0x910FFE75,
    0x4E07F0BE, 0xA3FF3AB0, 0x2FF340C0, 0x7FE75609, 0xE05B789C, 0x76B04E07,
    0x24B5F2F2, 0x8F3DAF3F, 0x78D79CAE, 0x1AEF252B, 0xBEA7A47E, 0x647D1E22,
    0xDFFE7568, 0x098D7DF0, 0xEA8904E6, 0x4BE19FFC, 0x93A04C01, 0x7FF3AA14,
    0x8E552002, 0xC12FA9E0, 0xD472DCED, 0x1D2A6AD3, 0x49E45BA1, 0xBC16D2A5,
    0xF270F08E, 0xECA92D34, 0xBFFE7541, 0x9BD09784, 0x6C064260, 0x54D7FE75,
    0x7984C254, 0xEAD89A82, 0x6BE19FFC, 0x93984A6B, 0x0FFF3A8A, 0x09584930,
    0x0ECE8000, 0x69FD4FA0, 0x4FF78A0F, 0xEBDFA008, 0xEF141ED3, 0x2D77409F,
    0x6A506B4E, 0xD774E6EF, 0xA506B4E2, 0x5594D3B6, 0x74FC0DE0, 0xFE16C0AF,
    0x6505F38C, 0x744F9F1D, 0xFEDFF7E0, 0x1D3517D9, 0x7FB7FDF8, 0xB28D5C76,
    0xB905B11A, 0x17931A63, 0xD2ADFFDF, 0xB96D3BBA, 0x37B4FEF8, 0x73C50D1E,
    0x87B7FDF1, 0x72DA7507, 0xCDF7FDF1, 0x968AFF52, 0x9D2FEF8B, 0xF51F77AE,
    0xF7CF7C5C, 0xC0BB2858, 0xB21E0F8B, 0x0F5FAC8F, 0xED7E076F, 0xF40B35A4,
    0xD33FF3A8, 0x27E7A6FA, 0x772ACD02, 0xF8725D34, 0xBA68D364, 0x5341F0E4,
    0x30B51A3C, 0x41CEC09E, 0x9BCE2D77, 0x1E01F9FC, 0xE2D774A7, 0xCA92D83D,
    0x8B5DD345, 0x9C35A943, 0x81BEF879, 0xE19FFCEA, 0x5627206B, 0x9F6F9DC4,
    0x1C3654BF, 0xDF6B722B, 0x7DADE127, 0x3ED6E456, 0xFB5BC3F2, 0x7DADC8AC,
    0xFB5BC364, 0x3783D28C, 0x8D83F365, 0x153783D2, 0xF49B5278, 0x7F9FDDDE,
    0x95BF6057, 0x38B1F9EC, 0xCEA6D49E, 0xE54F71E9, 0xF7BC57E6, 0x39F705FE,
    0x5F9B9C50, 0xB8F4E751, 0xBC21A4A7, 0xE57EDEA2, 0x9CFFCEAC, 0x90184128,
    0x3A8F5A13, 0x01460FFF, 0x640AB01C, 0x89E7FE75, 0x49C24980, 0xD1098482,
    0x0E7CE37C, 0x7662D076, 0xA9EEC1D0, 0x38F53760, 0xDC974B1B, 0xE87D6CE3,
    0xB15C36B1, 0x98ECA2F4, 0xAC3B5B1F, 0x369D947D, 0x2C617CE8, 0xDAEE650B,
    0x537A8F05, 0xE76F7987, 0x4CA6E69A, 0xF13CF02E, 0x1CB4812E, 0xE95BCDE8,
    0xC6D74DA1, 0x07B4DE25, 0x365F585B, 0x498BE1AE, 0x92C0BB0F, 0x7456ACA3,
    0x6B8135E8, 0x3838EF38, 0x9DB23C63, 0x827A8E5B, 0xDA6D0F5E, 0xF4112D83,
    0x0BB3687A, 0xD6A2792C, 0x2F270F70, 0xFF9D46AE, 0x7B2FE409, 0x4FC42437,
    0x0573FF9D, 0x63F7E7B1, 0x1DDFFE75, 0xCB67F86B, 0xE0BA125E, 0x5C3DB567,
    0x225FFF9D, 0xA29F96E7, 0x25FFF9D5, 0x95F3F45A, 0xFFFCEAC7, 0xC1F3CCCA,
    0xFFCEAA65, 0xF9E5BC37, 0xFE7563CA, 0x96C0EE27, 0xE7563EFF, 0x2D862D7F,
    0xE7563E1F, 0xC61E4D7F, 0xEAC795F3, 0x6215AFFC, 0xACB7FF09, 0x45B9FFCE,
    0xACBD7CB7, 0xA4B9FFCE, 0x72E27F75, 0x1FD28E3E, 0xADEE6D7A, 0x4779FFCE,
    0xF2DFF26F, 0xD883B9D8, 0xAD7CEAE4, 0x886BFFCE, 0xAD05FD02, 0xD815FFCE,
    0xB1E57CF2, 0x0E4BFF3A, 0x8FBFF05D, 0x1E5FF9D5, 0xF7FF4F21, 0x87FF3AB1,
    0x2FF216BE, 0x87FF3AB4, 0x7FF9B528, 0x3FF3AB1F, 0x57E21029, 0xF9D5CD81,
    0x7CF1849F, 0x510032E0, 0x9503FF9D, 0xA813FCDA, 0x5E4B8C7A, 0x93E03A59,
    0x52A74F87, 0x1914A369, 0x52A5CF9A, 0x1914A369, 0x33FF9D5A, 0xD84CED7C,
    0xFF3A9904, 0x12FC4A27, 0x9400D056, 0x033FF3AA, 0x5021A57C, 0xFFCEAD93,
    0x0684D242, 0x756A0670, 0x7DF0CFFE, 0x27098259, 0x67FF3AB4, 0x8461FAF8,
    0xFE756A61, 0x1355F0CF, 0xD7E00E53, 0x87EDF38A, 0x8F3D4E56, 0x8F51CB73,
    0x79FB7CE2, 0xA74B1E3D, 0xA947DDEB, 0x4748B687, 0x55A3285B, 0xE65206FA,
    0x45BADE99, 0x02F05D9E, 0x46D8068F, 0x679942D6, 0x3FF3AB7A, 0x02606021,
    0x817A1209, 0xFFCEADD4, 0xDC0C0104, 0xD5824B94, 0x0C4DFFF9, 0xA4480212,
    0xFE7570B4, 0x10180E57, 0xC44D2090, 0x89FF9D42, 0x4131381B, 0xA8140180,
    0x0DC4FFCE, 0x1161284C, 0xD57E1208, 0xD7C33FF9, 0x226A0640, 0x867FF3AA,
    0x9E61352F, 0xFFCEA5E4, 0xB897BE19, 0x9D29AB69, 0xC0C8253F, 0x4E09FC0E,
    0x6B2094FF, 0xD7A07E07, 0x379FC7BB, 0x3C83B479, 0x79BDD5C1, 0xCFE1BEE5,
    0xFC6F89F0, 0x67F372AC, 0x7E37C4F8, 0x7C5F44B0, 0xB2858F7F, 0xFEF8BC0B,
    0x509BACAF, 0xFFDF173C, 0x57C77B5D, 0x9FDF173C, 0x6371F87A, 0x71FF7C5F,
    0xB9E28B50, 0xF451FEF8, 0xE2F02FBC, 0x716B23FB, 0xDF17817A, 0x4DE07BF3,
    0x1DEF44B7, 0xBBF9295F, 0xEC394023, 0xEEF17640, 0x7F72AC82, 0x2168DFB0,
    0x9207145B, 0x2168FC69, 0xC5AEE85B, 0xAF143595, 0x7E8DF626, 0x5DD3FC2C,
    0xA4B93B8B, 0xA6FA0D69, 0x4465CDE5, 0x307B9653, 0x7F0378DA, 0x651CF409,
    0x2E9A3B95, 0x1A527C39, 0x9BE7642D, 0x690562A6, 0xD4729E0B, 0xC8F43578,
    0x78CF26DB, 0x82D83D35, 0x983DC9BE, 0xA63725EE, 0x9D4DE357, 0xF1431BD3,
    0xFB7CEEF0, 0xC70D952C, 0x47DADC8A, 0x4CFB5BC2, 0xFCFEEF7A, 0xA0ED02BB,
    0x47A7EFB5, 0xA37A8A7B, 0xD11A22E7, 0xFF1622D4, 0xDEF308EC, 0x073EE0BB,
    0xFC23B38A, 0xCE2C45A9, 0x57FF4935, 0xAE7493CE, 0x395FBA49, 0x8769D24F,
    0xF792FEA5, 0xBC21A4A6, 0x9F6F9DFA, 0xF537BC97, 0x914B0ED3, 0xBD27D6F7,
    0xCEACF07B, 0xC02800FF, 0x33C25384, 0xDD83A0EC, 0x39745658, 0x8713B05F,
    0xF38DF2B1, 0xEC976535, 0x54F37609, 0xE7CAC3B0, 0xDAD02E4B, 0xC2AB18D9,
    0x11F3B4FA, 0x741D9B2F, 0x4B86D3B0, 0x4ECD0FAC, 0xCB65D82A, 0x41EC95E9,
    0x41D9A36B, 0x686D3B07, 0x958C61D0, 0x97DC3D1D, 0x3C2F9C6F, 0x3B057A72,
    0xD83B4ECA, 0x945F4BD2, 0x760AF4B2, 0x972EC1D9, 0x6CE3F43E, 0xDD94D06D,
    0x1D8A7A18, 0x4BD3B074, 0xD0766E56, 0x3671EEC1, 0xD3B298D6, 0x6C4B58C6,
    0x2A70F0C1, 0xE11C3056, 0xD5E31B88, 0xF79BDDBC, 0xF8EBDEC0, 0x0A39E85B,
    0xB287BC2D, 0xDD6DA70E, 0x92C51FAF, 0x9A5D781B, 0x61B2F07B, 0x1AD4787B,
    0x8604D7AE, 0x606BDE73, 0x1414F6D1, 0xD468ECA7, 0xB52D4642, 0x291A0C6F,
    0x8BBA70F3, 0xDFFE756A, 0xCB4FF850, 0xB9FF9D54, 0x5C1FD6BC, 0x8AFFE756,
    0xCB83EA47, 0xAC2FFCEA, 0x0E2CFE36, 0xE9723CDD, 0xE7546892, 0xC258857F,
    0xF3AB16FF, 0xFF78B47F, 0x7FE7562D, 0x7FCF2D93, 0xFFF9D596, 0xD13F2E3D,
    0xFFF3AA98, 0x07E24D7B, 0xFF3AB600, 0xFCF3372B, 0xFF9D5967, 0xFD3C9121,
    0xFE7565C1, 0xF96E6F67, 0xF9D5B02A, 0xE4F9A59F, 0xE756C0AB, 0xCFC96D7F,
    0x2AE1967F, 0x8FB61B92, 0x0CD782CF, 0x8E32AE4D, 0x977FF9D5, 0xC000FC5F,
    0x7DFFE756, 0x62A7E3C3, 0x2CDFFE75, 0xC0ABEF4D, 0x2DFFE756, 0x5887FBDC,
    0x3C73FF9D, 0x30036D7F, 0xABCFFE75, 0xB0003F02, 0xC17FA4A7, 0xADEE48BF,
    0xCF23FFCE, 0x4113B67F, 0x31D7FE75, 0xAB2D7F1D, 0x0F6CBFF3, 0x9D596BFF,
    0xC17425FF, 0x09EB96BF, 0x8FB1FE94, 0xBFF3AB4B, 0x93E7BA3C, 0x1FFCEACB,
    0x67FCFE1E, 0x43FF9D59, 0x807FE1CF, 0x31FFCEAD, 0xCE23FE8E, 0x2D27F446,
    0x5F91A244, 0xAB3DCE6F, 0xFF9D4E44, 0x7FCF3C51, 0x1FF9D596, 0xE4FC72A5,
    0xD1123F32, 0xB1C2AE41, 0x13E3FF3A, 0x4C527CA4, 0x8FF4A076, 0x9D5A5C7D,
    0xFE7949FF, 0xCE089DB3, 0x2ACA2CB5, 0xE753D057, 0x0AF8067F, 0x904A4091,
    0x92BFF3AA, 0x48122152, 0xFF3AB881, 0x480A492B, 0xAA406C09, 0x7C0FFFCE,
    0xAB39D00F, 0x28FFFCEA, 0x108F8952, 0xFFE752E1, 0xA09A4004, 0xEA2BC034,
    0xE880CFFC, 0x7E04EA4A, 0xC632D837, 0xA7DEF1AB, 0xF12C4DF4, 0xDA548ED0,
    0x1BC46DFC, 0x37B26288, 0x0DE99E65, 0xD096C6D6, 0xEA2D817B, 0x06A94FFC,
    0xD5C8DAA9, 0x26A9BFF9, 0xB9025239, 0x01E3FF3A, 0x05502627, 0xF5E6887E,
    0x5DD33BB6, 0x77D0078B, 0xB216A3FA, 0xBF40109F, 0xEF196C55, 0x38F6A09F,
    0x5C9C6B4D, 0xDD0F28D2, 0x2DB2B8B5, 0xFA3C681D, 0xBC47694D, 0x878236EB,
    0x7F345B8C, 0x52FC4F86, 0x9FCDA394, 0x3A5F13E1, 0x867F3617, 0x2168FC4F,
    0x29787A5B, 0x8D32D837, 0xFF77F81D, 0xAC3528D4, 0xF252BFA5, 0x7C5F4973,
    0xA8B9DE7F, 0x3FBE2F18, 0x2D3838EF, 0xAF3FDF17, 0x8B9E7A38, 0x75452FEF,
    0x7BE2E5A0, 0x474A29BE, 0xAC1BFC5C, 0x17DCB9EF, 0x43EB06FF, 0x4F8B8EE7,
    0xC03F3CB6, 0x67F0BC6E, 0xB33F7545, 0x68E514B0, 0xAC8F9AFF, 0xB4D38A83,
    0x4761C7E5, 0x2D4F1DEF, 0x523B9561, 0x5F58FED3, 0xBDC5107A, 0xF316C232,
    0xDCAB0FCE, 0x16C85A3F, 0x538979A5, 0x54536229, 0x56692E16, 0x59503781,
    0x6FB3A4B8, 0xAE9DC0DF, 0xD835A168, 0x78A6FB83, 0x8A6C4BD7, 0x0692E4E1,
    0x0EC38DFB, 0x678E83C5, 0x68EAE1B7, 0xCA55BB21, 0xACD7B03C, 0x4B69DE58,
    0xD90B44D4, 0xA7D95BCC, 0xF8B5DD34, 0x6C0AF743, 0xB7EF7B01, 0xA6B2606F,
    0xBE40DD91, 0xB4D1B902, 0xF8735E72, 0x3C8A54FC, 0x2D1DE5C1, 0xCE650B64,
    0xBB04D5E9, 0x37D12C14, 0xD4AD4A10, 0x7A4FE815, 0xEF487EEF, 0x02BB9FDD,
    0xE6EF7A4D, 0xD26815DF, 0x577F777B, 0xBBDE9360, 0xDB02BB9B, 0x7A5F6B41,
    0x45A8A7B4, 0x308ECE2C, 0x57F1E8ED, 0x2529F64A, 0xE8ED3EFB, 0xA9847671,
    0x35CE2C45, 0x9E72BF49, 0xE7BF6BA4, 0xABD39D8F, 0x4B52C3B4, 0x86929BDE,
    0xEDF3AAF0, 0xAF4E7633, 0xBCF7ED7E, 0xB4A9BDE4, 0xBDE452C3, 0xE0F77A45,
    0x09FF9D59, 0x09018023, 0xD0FAA625, 0x8B5EAEC1, 0x41F3B5B5, 0x37898B33,
    0xC174FAD1, 0xAC6CE61E, 0x69631B79, 0x86358BE7, 0x5497AD06, 0x5F1AC636,
    0x653E71BE, 0xDAC6A789, 0xBE358C61, 0x7E5636B1, 0xBB05631B, 0x18537609,
    0xB29A1D8B, 0xE78F7CAB, 0xE554DD82, 0x1D0766C2, 0x54D630EC, 0x7CBE71BE,
    0xDD83A053, 0xB29B2A78, 0x9DA3760B, 0x7696160F, 0xC7E87D3E, 0xB1B38FD9,
    0xF9DCDAD0, 0xCD56F9C6, 0x760B9ECA, 0x9897AD06, 0xABB0741D, 0x70D636B0,
    0xEC1C7EBF, 0xE82C9630, 0x0ECD9760, 0x725DD83A, 0x760B9AE5, 0x7B2EC153,
    0xD5D82B1C, 0x6CAEB16B, 0xB2EC158C, 0x369D82E7, 0x907B12C6, 0x0BB5A549,
    0x0ECA163E, 0xB692E29B, 0x8EF387A0, 0xE6C16383, 0x86AF1A8B, 0xC54A93B2,
    0x23D28F14, 0xAF185F6F, 0xFB791E86, 0xE9ABC692, 0x95DD0FA1, 0x94AA3F36,
    0x5A88BE60, 0x92788ADB, 0x72D3DA17, 0x3140AF7B, 0x3F0DCD5E, 0x17DAD38F,
    0xD93CFC37, 0xB06F1BA2, 0x43D83EF7, 0x66F5177B, 0xE4F25817, 0xED32BD15,
    0x906996C1, 0x4EC1A739, 0x168E953A, 0x723578D2, 0xE9E89BC5, 0xD26F0A93,
    0x5F7B84BC, 0xD0F11478, 0x41E15A0B, 0xE2D796BF, 0x65236870, 0xB2827A0D,
    0x594171DD, 0xD8DA6047, 0x1812EF12, 0x04D7604B, 0x83A0DEF3, 0xE1AC40DD,
    0x95FF9D54, 0x6289F25D, 0xCD03A52D, 0x8E9E937B, 0xB03D1CE2, 0x3A7C3C27,
    0xEA3D5882, 0xCFE1EFFC, 0xFF3AB13F, 0x69FEF70B, 0x1DFF9D59, 0x5627F9FA,
    0x8E98FFE7, 0xF9D5969F, 0x7BF8DDFF, 0x28CD7DFB, 0xC70AB935, 0xCAFFFCEA,
    0xAB2C9FCA, 0x779BFFF3, 0xE756287D, 0xF3C8FE7F, 0xFFCEAC4F, 0x8A1FC67C,
    0x915FF9D5, 0xEACB07F1, 0xE3C8AFFC, 0xFCEAC4CF, 0x0FEF08AF, 0x5B39CCC5,
    0x99A07694, 0xEF621511, 0xF9D5BDCD, 0xFF3CB59F, 0xCFFCEAC4, 0xC4FFDDEA,
    0x770FFCEA, 0xEAA6DEFC, 0xBBF7AFFC, 0x72D6583E, 0x0F09E781, 0xE78172D7,
    0x9D5C3589, 0xE792F7FF, 0xFF9D589F, 0x287CF637, 0xDCFFE756, 0xDE27F9FB,
    0x5720EEB6, 0xFE756BE7, 0x44FF0B97, 0x97FE7563, 0xAC457F40, 0xFE62FFCE,
    0xF3AB13FC, 0x3FC85CBF, 0x0BFF3AB1, 0xF8C03E7F, 0x917FE755, 0xEAC50F8A,
    0x7F1B1FFC, 0xFCEABF6F, 0x13F8DB1F, 0x3FF9D58D, 0x28FF5134, 0xE47FF3AB,
    0xEAC4CFED, 0xFE131FFC, 0xFFE75652, 0x8A1FD380, 0xF23FF9D5, 0x947143F8,
    0x81E2D27C, 0x1FFCEA2D, 0x6287F2B2, 0x6247FE75, 0xEAC4CFEE, 0xFE328FFC,
    0x891F9960, 0x1F15720E, 0x693FF3AB, 0x56289F1E, 0xC2D27FE7, 0x764C513F,
    0xC2C7F4A0, 0x27FE751E, 0x9703E7A1, 0xDC9FF9D5, 0xACB81F2D, 0xE4B9FFCE,
    0xD898703E, 0x61FCE7BB, 0x0BBD0389, 0x3B6B07F4, 0x0ACA62D0, 0xFCEADA3C,
    0x5C00549F, 0xB35B1284, 0x430E7BDC, 0xEE59A3DF, 0x7E860F3D, 0xE4B4E92E,
    0xCEC92C92, 0x389FFCEA, 0xE8892BD1, 0x3FF9D5B3, 0x822E17C3, 0x7FE75680,
    0x097806A0, 0x756E1003, 0x25F0CFFE, 0xA8ABE0D0, 0x6F867FF3, 0xA61501BA,
    0xDF05FFCE, 0x6CA82154, 0xF0CFFE75, 0xB2A08545, 0x033FF9D5, 0x04400651,
    0x67FF3AB2, 0xDE7202F8, 0x65026B41, 0x9D9ABC51, 0x43C6E56E, 0xAB283BCF,
    0x6976096D, 0x94712D90, 0xEA81ACB5, 0xC0104FFC, 0xD43A655C, 0x80209FF9,
    0xD57F19A3, 0x03E09FF9, 0x40420060, 0x487FE756, 0x002900B5, 0x67FF3A8A,
    0x7C05FAF8, 0x67FF3AB9, 0x671022F8, 0xB3FF9D5C, 0xE257784E, 0xFF9D54C4,
    0x9134BE07, 0xFF9D5C93, 0x604DBE07, 0xFF9D5803, 0x4276A981, 0xFD00699A,
    0xC0EC1F5E, 0xBF40109F, 0xF03B07D7, 0xEFD00603, 0xFC0EC1F5, 0xC3F40140,
    0x13F81DBF, 0xF8AFE802, 0x180FC0ED, 0x07C57F40, 0x0427F03B, 0xC1F15FD0,
    0xAF80FC0E, 0xA7B74EA9, 0x36EFA69D, 0xA717AFD5, 0xC21F287C, 0x5D347F84,
    0x32D837D2, 0xD04F9F8D, 0xE5B95815, 0xED2E3D17, 0x25B02ACC, 0xF0F5FF8C,
    0xE6539D4F, 0xEAFCC5FC, 0xFDF17A57, 0xB6105DDF, 0x6A7F7C5C, 0xF8B9696C,
    0x16DEFBFE, 0x9FEF8BEF, 0x2E5B06FA, 0x0C6A7FBE, 0xFDF173C5, 0xC1EF1703,
    0x6D8FEF8B, 0xBE2E5ACA, 0x02F05BE7, 0xC16D3E2F, 0xC5F9AE53, 0xD4FAC1BF,
    0x6C9F1712, 0xB7937E79, 0xF2D93E2F, 0x2FC5587C, 0xFCF2D93E, 0x4B81DA39,
    0x1FE27E51, 0xCA6D8DDE, 0xD053FE3A, 0xA712F34A, 0x656EE95D, 0x02AC333F,
    0xC1EC206F, 0x2F4E83DD, 0x0BEEF5D2, 0xCFA94A96, 0x1FEDEBA6, 0x14CB642D,
    0x43DBD7EF, 0xD25C9C5B, 0xBB7BD73F, 0xB4D9176F, 0xD1D86EF6, 0xA8587642,
    0xFA258323, 0x81B92DE2, 0x522B61A9, 0xD4D34E83, 0xE26BAC83, 0x3D026FB0,
    0x0E2D7748, 0xDDED2EBC, 0x3A4307B9, 0x6F0D026E, 0x55827E60, 0x3AA2EEFA,
    0xA9E6ED22, 0x7805A705, 0x66B4D51D, 0x8279229A, 0x68AFFBCB, 0xF7081E61,
    0x7D981BF1, 0xDA1E3D83, 0x2D94C5A9, 0xC5A981BC, 0x81BF1F70, 0x316D2AB4,
    0x4A54E91E, 0xEF1AB8E9, 0x632DBD70, 0xB63645E1, 0xD5A4F8DC, 0x64A41FF9,
    0x75720200, 0x1494DFFE, 0xCEAE4020, 0x030330FF, 0x75380224, 0x600E2FFE,
    0x9D57A060, 0xF00517FF, 0x40AED893, 0x1FBBDE93, 0xEFF3FBD2, 0xBDE9340A,
    0x4D02BBFB, 0xAEE6EF7A, 0xBBDE9340, 0xDED815DB, 0x72E1E11D, 0x563D1DA6,
    0x2529F64A, 0x8F4768FB, 0xEC67BF6B, 0xE7615E9C, 0x7BF6AAF4, 0x127FE756,
    0x8000C4AE, 0x15FF9D54, 0x226AC042, 0xFFF3AB20, 0x404040BA, 0x59FFCEA6,
    0xE89C4ACB, 0xE09FF9D4, 0xA8042146, 0x301FF9D5, 0xA2427627, 0x207FE756,
    0x02053240, 0x9FFCEA60, 0x813090F8, 0xFF3AB584, 0x20E06C27, 0xF9D5C09C,
    0x9A60913F, 0xCEAA4098, 0x018889FF, 0x57113890, 0xC066FFE7, 0x468444C9,
    0x3613FF9D, 0x8D000070, 0x0303FF3A, 0x42426303, 0x34FFE756, 0x6D010162,
    0x0C1FFE75, 0x50C204E0, 0x10E7FF9D, 0x56913010, 0xC0B5FFE7, 0xD5A08895,
    0xAAF93FF9, 0xB8898000, 0x06F7FF3A, 0xC4204E06, 0xF13FF9D4, 0x82210261,
    0xF5FF9D5C, 0x0904C246, 0x4FFE7573, 0x940C0824, 0xBFF3AB58, 0x810CFC26,
    0xFF9D5A89, 0x280124B1, 0x3B2998A1, 0xB0746829, 0x6517A5D3, 0x18DAC6AB,
    0x1A341A0B, 0x60E3F5FB, 0xB4B18CC7, 0xECA3B28F, 0x8DBD74D2, 0x0741D8B1,
    0xDAD06D3B, 0x2B1D82F9, 0x5760B9A9, 0xA7B4D2BA, 0x1B7B92DE, 0x3B05C963,
    0x2F116539, 0x419F38DF, 0xD82E6F13, 0xCC7BE54D, 0x8DD94D0E, 0xE563B5B5,
    0x74625E83, 0x4BD2C636, 0x9725D82E, 0xB0EC175E, 0x5F2EC1C2, 0x73E76972,
    0x7CE15EB6, 0xD7057CE3, 0xA2F4B29C, 0x4F671EEC, 0x26BA0D25, 0x1D83B47A,
    0xBDF5A4E8, 0xB5A1606B, 0xF38DF3B9, 0x85561F71, 0xB38FC3B5, 0xC6B11D83,
    0x0A9FB1A0, 0x72D05376, 0xB2998F95, 0xF6B09ECB, 0x8D631BE5, 0x1B4EE7B5,
    0x35CBB074, 0x594FAD15, 0xD82A7BC4, 0xE71BE771, 0xA469DEFB, 0xAF4D92CC,
    0xE8E50C27, 0x9DA4B8DA, 0x2C7A8E5B, 0x5DCCA168, 0x9943E0BB, 0xD0553D11,
    0x312D24B4, 0x9DEF0D5E, 0x6049587B, 0x578D45F3, 0x7748ADE3, 0x03C8D476,
    0x782ED73B, 0x878A1BD4, 0x71E3D38B, 0x78A62D83, 0x7F171364, 0xB87B65A0,
    0x89EFFF3A, 0x1BBDBC0F, 0x77B7C8BC, 0xDC6E3E4B, 0xD25A3C1E, 0xB7C506B0,
    0xA91CEF53, 0x5948C0DC, 0xCA714161, 0x1A7B749E, 0x5072B72D, 0xACAF3D56,
    0x74ACA099, 0xBC1EF36D, 0xBD3BBADC, 0xDD6D6481, 0x7EF0D7A3, 0x89EA66A5,
    0xE6915C35, 0x9CD03A72, 0x3D2688AC, 0xFF9D47B0, 0xA67DFE37, 0xF79FFCEA,
    0xE756DC7D, 0x71F85CFF, 0x378B6DFB, 0x9D4FA669, 0x1FE2DFFF, 0x519AFC70,
    0xAC70AB93, 0x15BAD6EC, 0xB5670962, 0x878A0773, 0xE4181AEB, 0x33116C0D,
    0x124C5BAD, 0x340F6ED7, 0x6FBDA779, 0xB9CE66EF, 0xC91B7B25, 0x69BE6955,
    0x74FBFD2E, 0xEFF094CB, 0x9B9BDC25, 0x16887B24, 0xD2E129E8, 0x05787B7F,
    0xEC2C7F4A, 0xA7FFE751, 0xEAC727E5, 0x1F812FFC, 0xFFCEAC60, 0xEDAFFBC2,
    0x9BDF92C0, 0xC351DEE4, 0x70F6FFA5, 0xA0779B24, 0xFF3AB878, 0xE73FF093,
    0xB1DDADF7, 0x00D35E0D, 0x83116A6F, 0x3FF3AB5E, 0x48080A4D, 0x2D3A4DF0,
    0xB24B24B9, 0x227FE756, 0x40813021, 0xFFCEA820, 0x48854180, 0x7FE75520,
    0x48854620, 0x7FE75520, 0x048854D8, 0x0FFE7552, 0x12215F02, 0x3FF9D548,
    0x8857A271, 0xFE755204, 0x1545F0CF, 0x7FE755F0, 0xC02E0082, 0x7FF3AB04,
    0x8120953E, 0xFF3A8A09, 0x080153E7, 0xFCEA2A02, 0x51F4405F, 0xFFCEAD01,
    0x80037C29, 0xD7FE7533, 0x08893CA9, 0xD7FE7573, 0x400980A9, 0x67FF9D5C,
    0x04822054, 0x0D6B4A6D, 0x0B5E307A, 0x85A87EDD, 0x2B54DBBF, 0xBBCFDC72,
    0x0577EA8B, 0x1C72BCB6, 0x534D6076, 0xEF46F26F, 0x2835A1BE, 0x541258A6,
    0xB9AE1F9A, 0xD3781E9A, 0x07B0372D, 0xE8B9525B, 0x34F8AA50, 0x86FA2582,
    0x83DCC0EC, 0x61E45BA1, 0x3B63BD85, 0xDD9025BF, 0xA12C2E5C, 0xB51DDD0F,
    0xD4A078FD, 0xBE29534A, 0xA44D5E28, 0xE23A5052, 0x2BE696C8, 0x5B7BD2BF,
    0xB234320E, 0xDEDE0DCA, 0x6F6ECCE7, 0x484FFE75, 0x20531378, 0x09FFCEAE,
    0xC2760354, 0x09FFCEAB, 0x2020C0C0, 0x1FF9D590, 0x00040DE8, 0x0FFCEAC8,
    0x627123C4, 0xFFCEA820, 0x20290189, 0xFCEAD027, 0x3011289F, 0xAA101898,
    0x45213FF3, 0xA1010492, 0xA813FF3A, 0xAC000105, 0x6A94FFCE, 0x55E817C0,
    0x149A7FE7, 0x7E260442, 0x279FF9D5, 0x5E811298, 0x856FFE75, 0x6412087C,
    0x50AFFCEA, 0xA0480C4C, 0x857FE756, 0x10184C08, 0xAFFCEAC0, 0x5128106C,
    0x3FF3AB42, 0xC4D55404, 0xFF3AA904, 0x4C640D43, 0x67FE7568, 0x484C122A,
    0x7FFCEADC, 0x00251259, 0x13FF3A8D, 0x48204949, 0x7FE75660, 0x09C22E9D,
    0xFE751484, 0x01F8079F, 0xFE756424, 0x09845C2F, 0xF9D5C424, 0x40917D3F,
    0x3AA984C2, 0x481303FF, 0x54C4DE7C, 0x0185FF9D, 0x82120493, 0x452FFCEA,
    0x5F04822E, 0x8E8FFE75, 0x43128944, 0x4247FE75, 0x42226F00, 0x727FE756,
    0x94241301, 0x3FF3AAF0, 0x31225898, 0x7FE756C0, 0x02270195, 0xF9D5784C,
    0x0248A93F, 0x806FC4A1, 0x9A7698DD, 0xA49EBCB6, 0x9C5AEE8F, 0x94DC5AEE,
    0xC67F0476, 0x13E7E8F9, 0x6B149E54, 0xCFE51F2A, 0xEEFF89F0, 0x3E19FC82,
    0xE6E915F1, 0xCF89F0CF, 0x867F372A, 0xDBECFC4F, 0xF13E19FC, 0x9FC1A3D3,
    0x3C1F13E1, 0x3E19FC7D, 0xFD12C1F1, 0x47CB6236, 0x31D5E1E6, 0x4205EAD8,
    0x42D1FEE7, 0x647CDCB6, 0xBF0F5FFD, 0x28BCFEF8, 0x7F7C5C96, 0x2E5B06B6,
    0x839EBFBE, 0xFFBE2F0C, 0x5CB4F836, 0xFB74FF7C, 0xFEF8B969, 0xB9E2AA51,
    0x94D8FEF8, 0xCF7C5F5D, 0x8B92C537, 0xDD96DEBF, 0x6C9F178D, 0xBE6BFE79,
    0xFE27FC3D, 0x82F9DDE1, 0x9A2B28D6, 0x5F1DEF47, 0xEC0BF929, 0x349F9A57,
    0x9F9B7245, 0xB49DA936, 0xBD81E668, 0xBEF46343, 0x94E62829, 0x7077A679,
    0x0DDB9452, 0x94BDF2DB, 0xF2DB0DDB, 0x1BB72B79, 0x57C3E5B6, 0x2DB0DDB9,
    0xDDB95AFF, 0x989F2DB0, 0xB61BB72A, 0x4E5407E5, 0xD3B475FA, 0xDE6E9154,
    0xF052B1A1, 0x70B53D90, 0xEC9BCDBD, 0xC1EE695D, 0x68ED6CA0, 0x1CF45B21,
    0x0DD69864, 0x6A7896BE, 0x96BF4DF6, 0xB60F6878, 0xAC1EC364, 0x68DCEC38,
    0x72B283DA, 0xEDEDE4AE, 0xEFD4857F, 0x778B9FEE, 0x3D9487E6, 0x68D2E4B5,
    0x5CAD9B21, 0xA297024B, 0x179B4960, 0x7914A938, 0xA61605BC, 0x935D641E,
    0x7CB6236E, 0xF2F029A7, 0x69CAE53E, 0xAC8E6D2A, 0x8E90D179, 0xD1E4DE1B,
    0x4E57CFCE, 0x6FDEF41A, 0x2BE7C1AD, 0x2B146F6B, 0xB774D1CA, 0x2ED4CF1A,
    0xE41E7CF8, 0x15EF2E09, 0xB7878F2D, 0xFE2D774A, 0x0B468E3A, 0x1413E2D9,
    0xD7D1CA2B, 0x0DCD577B, 0x4B4A35A4, 0x135A6D0F, 0x6907A36B, 0x378DAC4D,
    0x62DE6950, 0x64581ABC, 0x241EE4CB, 0xBEF192D6, 0x6A547CC0, 0x2638641F,
    0x46AF1A0F, 0xAF1B4A9A, 0xA84B0A46, 0xB9DE4158, 0x739E98A8, 0x07AF9791,
    0xED4E9B0B, 0x4F146782, 0xE1D825A4, 0x39CB6741, 0x2E1E583C, 0x787A54ED,
    0xFF3A8767, 0xAC044A27, 0xFCEAE226, 0xC260057F, 0xC5FFCEA7, 0x6A61BC01,
    0x83DCE7D9, 0x559FFCEA, 0xEAC84E04, 0x30330FFC, 0xFCEAC898, 0x4C00549F,
    0x9FFCEAAA, 0x53D58035, 0x0145FFE7, 0xB8EBE48C, 0xD268D47D, 0xA05773FB,
    0x5DFE6F49, 0x77BD2681, 0x9D4D02BB, 0x511D7AD3, 0x814FFCEA, 0x56712122,
    0x29827FE7, 0x3A978929, 0x0E42B7FF, 0xFFCEA181, 0xC26015FA, 0xEBFFCEA5,
    0xD5040922, 0x8BD09FF9, 0xF3AB2260, 0x1512A13F, 0x5FF9D450, 0x684A1218,
    0x8617FE75, 0xEA938480, 0xF889CFFC, 0xFCEAD624, 0x893E37AF, 0xD7FE7554,
    0xAD02551B, 0x637AFFCE, 0xF3AB984A, 0x9403CCBF, 0xF5A1F4C0, 0x762D82B3,
    0x896EC1D0, 0xCA9BB28F, 0xCB40B8F7, 0xAC6ECC39, 0x2E5B2BCD, 0x537651D8,
    0xF9C799AC, 0x1BE741A0, 0x6A2B7BE7, 0x38FD2D0C, 0xA3ED29FB, 0x853F5EEC,
    0xD78FB4B1, 0xE668D063, 0xAF4ECA6C, 0x4BE53760, 0xAC617CAE, 0x760E831B,
    0xF9D0DA52, 0xEB45D82E, 0x8F166683, 0xC598A7A1, 0x2594F9DA, 0x8B6B429E,
    0x1D9B4B93, 0x742BB29A, 0x34312F58, 0x0B9760E8, 0x651F6563, 0x4FAD1537,
    0xAC3A1A7B, 0x712F5B2F, 0x8DF2FAD2, 0xC3A7A1F3, 0xC598F9D0, 0x82F14F73,
    0x6318FD06, 0x31A93B05, 0xA7EB6974, 0x654DD82E, 0x9D06D3EB, 0xDF2F9C6F,
    0xC4535D63, 0xE7CE37CA, 0x9C6F97D3, 0xE3DF5B2F, 0xD945A9EC, 0x4DD945E9,
    0x68342C61, 0xAC2C2E71, 0xD2C5707C, 0x59D82E6B, 0xB18D9D0E, 0xB0EC15DE,
    0x0D254974, 0xB0741D9A, 0x6FA57CAB, 0x2B65D82A, 0xF953788B, 0x9BEB671E,
    0xE76B1662, 0xAD06D29B, 0x38F58E2D, 0xC2E5D83B, 0xDAD1BA58, 0x5E8349D3,
    0xDF2A6B18, 0x158C6CE3, 0x636B60EC, 0xADA760AC, 0xB057256B, 0x96E71ECB,
    0x9DAD06D3, 0x7671EA6F, 0xD0525E76, 0x8F671FA0, 0x105975B5, 0xC796EF7A,
    0x1E172B0B, 0xB209EFD9, 0xF5369B74, 0xCE64A53E, 0xD2BF69D4, 0x582D4358,
    0xACA41635, 0x6730F637, 0xC66F437A, 0x6EF6B478, 0x2B43578A, 0x3D8661ED,
    0x722B40ED, 0x1EC9BDD4, 0xE777BD2E, 0xCB78EA57, 0x6B9583D3, 0x655A7C17,
    0x8D5E1EF7, 0xF1B86B52, 0x2EF7986A, 0xB66E7145, 0x3AF0E7B2, 0xBC64B588,
    0x3571322F, 0x43ACA0BF, 0xCC3DBF57, 0x750F6CE4, 0x15DE93B0, 0x63BBD81E,
    0x5BF3B52F, 0x50F6604B, 0xD92D81D6, 0x24B66CF2, 0xD1E0D730, 0x43D2BBDE,
    0x6409778C, 0xF1A0F6E9, 0xDC12D26A, 0x3A51A0FB, 0x3B43D02E, 0xD6BB837C,
    0x8CF49845, 0xE2347419, 0xC183DCEE, 0xD2A95E5A, 0x92D7D81D, 0xB29B1A2D,
    0xC1F05DA9, 0x5C5E4DDE, 0x5B239ACD, 0xE159F0E2, 0x1D5E03C1, 0xF6F84B64,
    0x3DB720EE, 0x5927A5BC, 0xF51E0BB5, 0x967FE756, 0x794C86E0, 0xEF78EEB6,
    0xBCACAFDD, 0x48EF7386, 0xC9B5BD89, 0x0777AFD3, 0xF3AB878A, 0xF27FB2BF,
    0xE4D03D0C, 0xCE73369D, 0x5A074A2D, 0x1A55ED4F, 0x73BD88CD, 0x86670F6F,
    0xB9A056FD, 0xC58838B6, 0x9617B5B4, 0x52D29BEE, 0xB98B583C, 0xB5866F26,
    0x64937398, 0x76771DC7, 0xDE12C428, 0x3BDCCE33, 0x4738F8FA, 0x229E82E8,
    0x6E9F7FA5, 0x856F0F09, 0x6E63C258, 0xC258856F, 0x55C83B2B, 0xEF928E38,
    0xED7BDC25, 0x2DD613DD, 0x209EEF6B, 0xD19A903D, 0xC8BB558E, 0x58856E1B,
    0x3BBDA5C2, 0xDFAFD8D0, 0x7E2587F3, 0xEBC0BBCF, 0x48EBDFA4, 0xA3F9A4D2,
    0xE496BDEB, 0x84D75B43, 0xB3B6B02E, 0x43B5A577, 0x40A502BB, 0x9534EB70,
    0xA3C0ACA2, 0x5BF5E01D, 0x9683793C, 0x0D9257A9, 0x23996B29, 0x96B28E31,
    0xD1E31229, 0x14164527, 0x81D7E8F3, 0x268ED695, 0x6D69581D, 0x087FFE75,
    0xD5819034, 0xE0395FF9, 0xFCEA1820, 0x92701CAF, 0x7FE750C0, 0x812CBE10,
    0x813FF3AA, 0x55320600, 0xBE107FE7, 0xF9D5909B, 0x982880BF, 0x60B53998,
    0x4470C1EE, 0xBC7633D1, 0x7AF8DD0E, 0xD4D277EF, 0xADE3AF72, 0x5B037266,
    0xEF43D3A8, 0xFCD2A69A, 0x5D385A90, 0xB7BD3717, 0x1791497B, 0x8A2AD357,
    0xD66D3523, 0xA5A8C8DE, 0x6F7AE72F, 0x5F0DCF5F, 0xD91D7281, 0x07B9D863,
    0xF7AC61F3, 0xAF18DD82, 0xD3DE3C06, 0x3DBDAB20, 0x7E455A7C, 0x9E6B14D2,
    0x3BC7125A, 0x78A6C295, 0xDE2CA935, 0x1D2DE783, 0x0C1E25E8, 0xB28ADCCA,
    0x053C025B, 0x682D9169, 0x092C2E74, 0xD00EB6B2, 0xFF9D47B0, 0x08440081,
    0x0FFCEA3F, 0xA08BAA94, 0xC4FFE756, 0x12138089, 0x27FF3AA8, 0x565CAF86,
    0x9844FFE7, 0x3AA089CC, 0x700413FF, 0xFF9D5080, 0x302FE409, 0x9FF9D5A0,
    0x8044C6C0, 0x29FF9D4B, 0xA1842BE0, 0x9853FF3A, 0xCEA7D5F8, 0x012934FF,
    0x4FFCEA80, 0xB900B293, 0x072BFF3A, 0xABF1284C, 0x5D3AFFCE, 0xFCEA7408,
    0x803C469F, 0xD7FF9D4B, 0xE3F134AC, 0x05E42D8D, 0x13F41BDA, 0x6BBA68DC,
    0x906A4571, 0x64129FCE, 0x3BE6A13F, 0xBF777BC5, 0x5BF1BE8D, 0xB64DDD2A,
    0x4C034D38, 0xD7749379, 0xACBF60E2, 0x9F206F02, 0xB6372958, 0xB47F51E8,
    0x88DC2D90, 0x737A8BB5, 0xF6F49623, 0x13E19FC3, 0x5DF7EC1F, 0xD15AB04F,
    0xF5F99FC1, 0x92944BC3, 0x0B6236FF, 0x91F1D294, 0xDF7AB05D, 0x5F61C7E7,
    0xDD287F7C, 0xF7FDF173, 0xF7C5F676, 0x17D1259F, 0x5BB037D8, 0x0E3029EB,
    0x17EEF7BD, 0x72634F2F, 0x181AE1F7, 0x0774FB3D, 0xE6A7F0F5, 0xF60FEB23,
    0x9F9E6D2B, 0xCB8C1777, 0x64BFEEE9, 0x1FD12583, 0xF4576799, 0x4D2E4B53,
    0x92C1E31F, 0xACF8D6D0, 0x93B426F7, 0xE88FAF2D, 0x04F81EC9, 0x748AD6DB,
    0x0AFEA5BF, 0x514BB956, 0x82AC368E, 0xC05E9DBB, 0x169BB82A, 0xC190F06F,
    0x399BB82A, 0x4D3BF896, 0x6DFF33F9, 0x6FB937D9, 0x890B45FE, 0x5A2FF81D,
    0x364FDD48, 0x6FBD3765, 0x8ED561F4, 0x42D1737C, 0x5A0BD0B6, 0xAD35B48A,
    0xE2B61BBD, 0x2D13CEE1, 0xB89F0B64, 0x81FA37D0, 0x5B7A1ADD, 0x2BF1A67D,
    0xD691D6D2, 0xBB22020D, 0x75475E00, 0x6D21D83C, 0x1D2ADFFE, 0x1F6F0B40,
    0x3F34875E, 0xA3B98A69, 0x65E06C85, 0x78B695DD, 0x7E8761CD, 0xA69C5B60,
    0x252A36E9, 0xB4E91839, 0xBC5AEE84, 0xB2878BE6, 0x74ACA096, 0x9F91D6E9,
    0xFA0D8D0F, 0xD2728FC9, 0x9E8EF7A0, 0x181B96E8, 0x38C3D2AC, 0xAE3F5CEC,
    0x97904F73, 0xA69D8DC6, 0x715713D1, 0xD653E8D8, 0xFB913E7C, 0x4B0793E6,
    0x6ECA2B40, 0xA5BB7BDA, 0xB751E35E, 0xEDCA9714, 0xA1EDAEFC, 0x73A2BCED,
    0x816E760F, 0x9561F43D, 0x31B75DFB, 0x6FBDEF17, 0xC1EBD060, 0xF0FD0C0B,
    0x0DE06F23, 0x7672815F, 0xDC7A696A, 0x6F21BAC4, 0x57AB96EF, 0x7328B43C,
    0xD4E50D7E, 0x701E9FF9, 0x8FFCEA3A, 0x2BB86003, 0x267E16BF, 0xD02BB9BD,
    0x07B07286, 0xB269EDEB, 0x3D1A8B07, 0x52294B49, 0xDBD35371, 0x9E4ED23F,
    0x53DE12D3, 0x82B0DAD3, 0x5E96365D, 0x71FB2EC1, 0xDD945C36, 0xB071ECE3,
    0xC4FFE753, 0x3A86A929, 0x045027FF, 0x85FF9D4B, 0x760F1021, 0xB0A4EC13,
    0xD9760BDE, 0x07314F58, 0xBA7CED3B, 0x6D0FA73C, 0x725CE87D, 0x67BB054F,
    0x621AB1C9, 0x53765331, 0x78FD0FAC, 0xE3594F0C, 0x2F2EC1D7, 0xE834958C,
    0x4DD838B1, 0xCA5CBB05, 0x86F1470A, 0x94C7E25E, 0xAF5A365D, 0x47B05D6C,
    0xCE3D631B, 0x16765346, 0x62F4B3DF, 0xE4BE760E, 0x2FB03D7A, 0xAD25F2B9,
    0xF9D82E6F, 0x3671EB92, 0x0ED392C6, 0x6D2C6367, 0x071BB074, 0x836977BB,
    0xE6B9760E, 0xDF4B18D0, 0xE70E5353, 0x168BE71B, 0x873B05CF, 0x768369D9,
    0x631B7BB0, 0x1ED292B1, 0x97CE81DF, 0xB97D6834, 0xBA58C6DE, 0xE4BE5D82,
    0x4E9BAC2A, 0xD7A725D3, 0x2C2B18DB, 0x2B18594B, 0xEB6765D8, 0xB4B9760B,
    0xF13B0741, 0x2760ED2C, 0xEC3B28B7, 0x8D0DA760, 0xFB2BAD95, 0x683E9630,
    0xBB0742F4, 0x3A1B39F1, 0xF41B4FAC, 0x0B9BB05C, 0x05F5A076, 0x1E89A9BB,
    0xD82F1165, 0xA0B3C949, 0x5D82FAC3, 0x60EC6E2E, 0xC2C61527, 0x12DD9458,
    0x725F13B3, 0x58C6CBE5, 0x3B28B0B9, 0x763EB0E8, 0x3DA58C62, 0xC2B0EC17,
    0x598EC173, 0x8F429FAC, 0xD9C7AEDF, 0xC45BEB49, 0x3F168343, 0xE3760ECE,
    0xD6158C6C, 0x77CE37CE, 0xED694FD1, 0x9D82ECA3, 0x5D3B05D4, 0xBB071FAF,
    0x4B18525C, 0xE5D82E7B, 0x7A765316, 0x5B4BD2B1, 0x3A0D25D6, 0x8369631B,
    0x25D945CE, 0x9760BE97, 0x3468162B, 0x631BB076, 0xEC15EB41, 0x6BF65D82,
    0x63B076B1, 0x2C636B16, 0x9760BC31, 0x4BBB28EB, 0xEB495CAE, 0xA6CED2C3,
    0x0EE5D8EC, 0x8FCCD976, 0x5EB65D83, 0x0FA760E2, 0xEC1CCDAD, 0xDA760AE0,
    0xB9A1F4F9, 0x3B4B0B0F, 0x1653E9D8, 0xF8B78EF1, 0x615F2B92, 0x7CAE4BAC,
    0x60ED29E1, 0x2FAC5A07, 0xCEE681D8, 0xC5AF58C6, 0xA2E0E4B9, 0x765D82EC,
    0x36B42C2E, 0x9DA7D2C6, 0x9F2B92EF, 0xFD0760AE, 0x60E3DF38, 0xB054F527,
    0x173D06D3, 0xA1F49CEC, 0x365D83B5, 0xC6367673, 0xD29AE4BA, 0xF41B4E6B,
    0xC6C9AB34, 0xCBEB4958, 0xC977CE37, 0x9B2E4B95, 0x760B9BB2, 0x18F0E8DA,
    0xEC176516, 0xE75E9D82, 0xD9760E82, 0xD77AF4BA, 0x39AF4F10, 0x57976534,
    0x154DD838, 0x38B41874, 0x41A18DD8, 0x6D3B29A3, 0x2BD2CAD0, 0xD652C61F,
    0x59D83998, 0x341A1B8E, 0x85CBB073, 0x6B0F9DA5, 0x760AF5B8, 0x9D82B0B9,
    0x1D9B3998, 0x9E9BB074, 0xA0DA760B, 0x6938F5EB, 0x8C4EC1D0, 0x3B8BD6D6,
    0xB58D631B, 0xF07651F3, 0x2EF81AE9, 0x81AE9F0D, 0xD81CECE3, 0xD33D9DC2,
    0xE5B4788A, 0xD95C692D, 0x5B07B482, 0x9535281C, 0xF140AF1F, 0x78DEBF3E,
    0x0B5FA4B9, 0xB7E35DED, 0xC60B54BD, 0x1D4E652B, 0x7B52CAF8, 0xFCEA0EEF,
    0x94D871CA, 0x6C6DAD15, 0xAA579E2A, 0x45A0BF34, 0x40ED3CB6, 0x8BEC0E5A,
    0x1A6CD79E, 0xF82ED4D9, 0xD81C9628, 0x636DCAE6, 0x8252B3EF, 0x45320960,
    0xAD17D43C, 0x4B2B4788, 0x87325950, 0x6F761A4B, 0x8BEA86F2, 0x0F64A5DD,
    0x25A515B1, 0x2B2D886A, 0x1B133BBC, 0xD41660BC, 0x25C6D396, 0x0B64C3B9,
    0x1D337CEF, 0x89069E85, 0x34CFD12D, 0x5A3D5B98, 0x4EA460D3, 0x96F3525B,
    0x765264B7, 0x91FBD8DB, 0x5B03ACA2, 0xB2A683C2, 0x190B5192, 0x968181D8,
    0x60605B79, 0xE76ACD51, 0x2D0885C0, 0x8DAE82B8, 0xBB057A4B, 0xEC0792C0,
    0xE7BBC540, 0x4EC1D129, 0xFBADA95A, 0x3D1377BD, 0x21E9FB3F, 0x3DBDA496,
    0xB86B133C, 0x7FAE4F77, 0x340E3C5F, 0xD5BBDEB2, 0x04FF7FF9, 0x6681DEC5,
    0xACDBD05E, 0xC3CB89CD, 0xA976AB1D, 0x04FC7FF3, 0x9A7C5EC5, 0x60578F7B,
    0x57B7B593, 0xFCBEB0A0, 0xEC0F6F7A, 0x2143BD79, 0xD897F096, 0xBF2FA5A2,
    0x5B03D9D2, 0xFDFFF9D4, 0x635FA089, 0xCE12C428, 0x7B9B03C5, 0x5896C1F7,
    0xF46D95C3, 0x9B7816C0, 0x286F6877, 0xD1EC0F46, 0xBA640F62, 0x58EC1799,
    0xDCC959C3, 0xECF66F70, 0xACE681DD, 0x8DE1ED9E, 0x3ECFFCEA, 0x035D62A0,
    0x9A816DE3, 0xDEE0E9BC, 0xE8EC3C9A, 0x78F49AE3, 0x91F40F60, 0xFBBC70AB,
    0xECB607B4, 0x2588513E, 0x1DDEDF7C, 0x786FBE1E, 0x92EC74C7, 0xB305D09E,
    0x7BDC2C65, 0xE681D33C, 0x22BFC253, 0x7FC25335, 0xE129EF71, 0x256617D2,
    0x8BC3DBDC, 0xDBDE616C, 0x60784969, 0x50125A4B, 0xEB588CD6, 0x0F17340E,
    0xE502DBF7, 0x6E9CB606, 0xDD6181B9, 0x81E3CE12, 0xE349612D, 0x0351812D,
    0xA44F77B9, 0x05B7EF0F, 0xC0F49A06, 0xD1BEC096, 0x12C096C4, 0xE3C25885,
    0x64D9FAD1, 0xF37B120F, 0x6A51C358, 0x64CBEB38, 0x3EB04B43, 0xC34903B2,
    0x7B26C87A, 0x92E39A07, 0x0ED1F027, 0x582054B4, 0x813F79EF, 0xC387DFA5,
    0xF24D248A, 0xD6ED60BD, 0x95EBB5D6, 0x940AC364, 0x815DADDA, 0x4D35E052,
    0x8F02EB6B, 0x24B95A76, 0xC92A75F4, 0x47424B06, 0x4D7814C5, 0x9257EF41,
    0x2EE0650F, 0x06B60DBA, 0xB62F278B, 0x4B29A4C1, 0x6124972B, 0x5377B249,
    0x9B6B135A, 0xA7D7E757, 0x16B29B9A, 0xB28788ED, 0x24583996, 0xEC732D65,
    0x1E66F248, 0xBE67B38C, 0x1D012DE5, 0xAA0C7B0C, 0x00813FF3, 0xFFE750BE,
    0xAA62704E, 0xAAC0FFCE, 0xFF9D5909, 0xA2B78279, 0xC13BFFCE, 0x3FF3AA94,
    0xD509304D, 0x00409FF9, 0xFF3A9927, 0x53298257, 0x82627FE7, 0x3DA53333,
    0x15BDA4B8, 0xEF2EE54B, 0x9278DCAD, 0x8F07EF1E, 0xA5978186, 0x5777EEF7,
    0x5205B7E5, 0x1D981726, 0x1BC04F8A, 0x0749CA1E, 0x1D22B4D6, 0x9142B73D,
    0xA255E41A, 0x2DA9E22C, 0x3CDAC2A5, 0x17641BAD, 0x58B187CE, 0x169DE6E5,
    0xAB0DCAB2, 0x1DCAB078, 0x8137D13D, 0xAF5B0B87, 0xA56A50D2, 0xD81D43DB,
    0x8A5C3DB2, 0x74A7D96C, 0x5B3BB3E0, 0xCC0DE374, 0x3BDE6096, 0x96B7EF72,
    0x52A3E74C, 0x1EA60A51, 0xD4D1CD47, 0x913D8611, 0x51CB738A, 0xE16651CB,
    0x8B1282FB, 0xF304D44D, 0xA8EDB940, 0x226AF0BD, 0x47AFD8D0, 0xB15B1A07,
    0x78D4D264, 0xFFCEA135, 0xD4FB7B0A, 0xE0989FF9, 0x7FF9D456, 0x3AAA2BE0,
    0xA609A7FF, 0x23FF3A8A, 0xF3AB60D5, 0x1780C93F, 0xD7AF14F9, 0xA23B4EC1,
    0x76716C85, 0xD060C6B2, 0xFEC2E9CA, 0x07797C09, 0x38FCEA9A, 0x6BC96056,
    0x0F0B1FAA, 0x496B417E, 0x49379134, 0xF94E2D77, 0x23FC2610, 0x78B5DD36,
    0xD7FB3E1F, 0xECFEFF87, 0x02ACDEA2, 0x340EC39B, 0x2BE1EFD5, 0x67F361C7,
    0x94BFC4F8, 0x17AB60D7, 0xB2319FC8, 0x6A60ADCA, 0x3A023B4A, 0x081567F7,
    0x647C74A5, 0xBEF72ACD, 0x7B39EA59, 0x7C5F676F, 0xB95ACA7F, 0x5BB0FEF8,
    0xB87F7C5F, 0x3AA3E964, 0xE9F623BE, 0x075E9F8E, 0x0DE9A715, 0xA1B2168C,
    0xB06B2373, 0x94D4A744, 0xAE750476, 0x51CAFC51, 0x4FA60EBF, 0xE862DACE,
    0xDACCD6E1, 0x8E2D6711, 0x82C16E29, 0x8A788CFB, 0x6F4F5303, 0x52DFBA45,
    0x4B85942B, 0xBBA0E69A, 0x069A7716, 0x9CBD296B, 0xF4A5ACA6, 0x11F9D88A,
    0xCDFC3D93, 0xBBD41355, 0xB2DBFE6F, 0xBBFE6E6F, 0xE1E05B10, 0x822B4E97,
    0x569D2F9C, 0x0D4F36EC, 0x9BC1763B, 0xCD69D37D, 0x6E740B19, 0x69A712EC,
    0x1D4E1AD4, 0x117E1F98, 0xDC9F983D, 0x1AD29CFC, 0x729E0D64, 0xDBF642D1,
    0xF642D12D, 0x0B460BBB, 0x8D310CD9, 0xA3D3B216, 0x150F6951, 0x44B6982B,
    0x0F0D14DA, 0x91D86A7F, 0xB0B52F9F, 0xD829D825, 0xF65F70FC, 0x2E0F87A7,
    0xFDBE7155, 0x5225B7AC, 0x64AB26D3, 0x5582DA57, 0x9D81295B, 0x592946FB,
    0xF7452DD9, 0xC5427D7A, 0xCB63520A, 0xA8BE6C0D, 0x3A1B24B1, 0x42D1D379,
    0x5288ED1E, 0x3534B410, 0x4D47DAB2, 0x9B9F3BCD, 0x6E782ED6, 0x7CF9535A,
    0x38F60FC3, 0xE37A3F37, 0x8E7A3C29, 0x51E1F6B4, 0x02F265BF, 0x1BD39D4D,
    0xC341AD07, 0xE1C974CE, 0x5C35DEBD, 0xF6F72C6E, 0x52AE4B89, 0xC170AC69,
    0x2928EA1A, 0xA96ED7EA, 0xD0A704B4, 0xD0371D27, 0xE6BA3DB8, 0x75177B21,
    0x5DE73D4E, 0x27F0B5F9, 0x06B9E6BD, 0x835CEBD3, 0x70DE161D, 0x737E161C,
    0xDF7BD936, 0xFC372BD4, 0x3EE1A8E2, 0xA4BB29CB, 0x8A943687, 0x48EDAC68,
    0xA6CE793B, 0x5C97462D, 0x33D2A7A0, 0x4E3A49ED, 0x6C98574C, 0xB2673D79,
    0xC7DEF685, 0x2F1F6B4A, 0x683431ED, 0x6173B2BD, 0xB49C7BE5, 0x587431BE,
    0xAE4BB05F, 0xFDAD06D2, 0x3671FB38, 0x741B5A34, 0xBA53DF58, 0xB3A1B398,
    0xB5A1C961, 0x74B1B399, 0x3D63738D, 0x595A0DA5, 0x69630BC4, 0xB1F3A1A3,
    0xD3EB0A93, 0x9D82EA4B, 0xAC535E94, 0x1663B28F, 0x3F43676B, 0x0D05CED6,
    0x9C585F5A, 0x97117A5C, 0xEC68725E, 0x6C58D9C7, 0xE561582A, 0xF38D630B,
    0x3B29A369, 0xEC3D92BD, 0xB341B4A4, 0xBECE3F0B, 0x97D2C631, 0xED6831EF,
    0xAD95C97C, 0x36B1AF2F, 0x0D0DAC7A, 0x4B861C3A, 0x1A18F1EE, 0xF164B2B4,
    0x7E9ED29A, 0x3A0DAD9C, 0xAD0FAD1B, 0x86E70E8D, 0x1B4B1D06, 0x5B3A341A,
    0x0C7A341B, 0xCC3B5897, 0x8687D62C, 0xD29BE746, 0xB92F95CE, 0xDAC2F9C6,
    0x9E81E0AC, 0x765D945A, 0xF9760EBF, 0xC6F9DAC6, 0x42C453DA, 0xA1F5876B,
    0x6312F3B3, 0xF7586CAC, 0x6D2BB054, 0x38F5E965, 0x51F2A6BB, 0x8E6EC176,
    0x66EB43B2, 0xB075FB16, 0x8C4F7B93, 0x6D2CA725, 0x92CAD068, 0x59989EF5,
    0xAB363717, 0xB1631B79, 0xFB7A9A92, 0x9CB69D82, 0xD06D3E76, 0x7C7AB9DA,
    0x28BBF3BA, 0x854F7D3B, 0xE99AF4B1, 0xC97A5D34, 0xC6CECE3D, 0x2B9DD958,
    0x72B18DBF, 0x3760AF45, 0xBA69DA77, 0xD82BA3C4, 0xF42EB305, 0x29B7BB04,
    0x2C1BB073, 0xB4FAD0BD, 0x4DF5A341, 0x0A7AC6AD, 0x7AC61F2B, 0xD681631B,
    0x9653E3DA, 0xDA7D615E, 0x6B41A0BA, 0x172583E7, 0x46CE3F0E, 0x5161876B,
    0xDF457A76, 0xBE9D838D, 0x34686E71, 0xDE199B5A, 0xC598ECA2, 0x41A4E3DA,
    0x87D6836B, 0x614F6B1E, 0x651D4D4D, 0x31BB28B7, 0x1788B2B7, 0xCE3CCD06,
    0x2FA077D6, 0x6769F2B9, 0x87D3B05F, 0x57A7CED6, 0xCBEB6572, 0xD0615C97,
    0xB46629E8, 0xE2762C2E, 0xB9D0596C, 0xB2EC15C7, 0x95376517, 0xB183D92F,
    0x7A0DA788, 0x1B58F6FC, 0x95968D3D, 0xB3B4B92F, 0x7BEB12F5, 0xDCF41B4A,
    0xE1C7BE54, 0x3F41B4BC, 0xF6962BA5, 0x8B41A0B3, 0x41A1A1F5, 0x9C7AC2E7,
    0x4BCED63D, 0xCC58ACFC, 0x6CE37CE2, 0x973B5A34, 0x1EF95E9C, 0xD0A7EB67,
    0x0A7EB5F9, 0x73B4B03D, 0x17D6CE3F, 0xA4B7D615, 0xB294DD83, 0xCE836964,
    0x2E4B9596, 0xF67415D8, 0x585CECE3, 0x41A0BCDA, 0x958735EB, 0x1BB28E6F,
    0xAC1BB04F, 0x666D687C, 0xF1ED6859, 0xA4ED68DB, 0x367619F5, 0xF687D2C6,
    0x0D95D3E9, 0x8AEC1D3D, 0x18D97278, 0x92F5896B, 0x8A9BEB42, 0xD68D0686,
    0xAC3B92C6, 0x979D0683, 0xB45F3B58, 0xEFD06D3E, 0xA535581A, 0xB5630F9D,
    0x7D61735E, 0xD945EB0E, 0x9BE74369, 0x651EF7D2, 0x16B1A2AB, 0x0EC17765,
    0xB95E9F5A, 0xD7AD9789, 0xB43E741C, 0x4F7CAC6E, 0x7ACB5F8D, 0x1CD70C6A,
    0xA6FA7BF3, 0xD1B589D8, 0xC963657A, 0x06863F4D, 0x60BED68D, 0x58D4F587,
    0xF17A595B, 0x8D9CC7CA, 0x97CED6CE, 0x9A1F5A6F, 0xE22CAD19, 0xC6629BE5,
    0x8CCC7E82, 0x40FB38F5, 0xDA7D2C63, 0xDA58C2F9, 0xD6DFB4B1, 0x6CBC4D06,
    0x585CE87D, 0x3F43657A, 0x38F525CE, 0x258D0C7B, 0x0D0DCE35, 0x4B89D83A,
    0x341F4B1B, 0x8F725CE8, 0xCCD0C7B3, 0xD05853D9, 0xECC4B1A0, 0x153D6372,
    0x37D6D2C6, 0xBAF4AFA5, 0xADA5CAE4, 0x3EB41A1B, 0xCF41A0BD, 0xAE4BBB05,
    0xF5A4EECA, 0x16834315, 0xCBB05F5B, 0x8AECA666, 0x98A6EC78, 0x1D7E87C5,
    0xD0D1A2EC, 0x10DD838F, 0xE0B15E97, 0x8369F38D, 0xE76B1666, 0x9D8ECA3B,
    0x7D683414, 0x75A0DA53, 0x5A0D0D25, 0xB38F5E2F, 0x46863595, 0x671FB58F,
    0x83437587, 0xA3336B46, 0xD2AC9631, 0xF53D9C7E, 0x49D353F6, 0xEBD2C683,
    0x63F33671, 0x5963D06D, 0xE273D061, 0xEBF43EB0, 0xA7ABD9C7, 0xAD94C598,
    0x94D2EF81, 0x0CE381AD, 0xF081AE9F, 0x8597027C, 0x6E59781B, 0x5A364765,
    0xEBF475F0, 0xBBDEDFBD, 0x8B6FD5C9, 0x2BCFDDEE, 0xBC77A22B, 0x81BF36EB,
    0xABC0DCD4, 0x1B791E83, 0x2BDAD0B4, 0x09682BBF, 0x8DCD88D9, 0x6FCD1D7E,
    0xD784BC2A, 0xE1B9E054, 0x3A79E293, 0x3C69DDBD, 0xD2D5C1CA, 0x05B4DCA1,
    0xDE1ED943, 0xBDF48A12, 0xF722A04B, 0xACA812D6, 0x7057A6E1, 0xC3F44CB5,
    0x3E8DC77A, 0xD2758176, 0xC176A4AC, 0x7DE3D767, 0x977BD981, 0x5C4F6750,
    0xE1CB644D, 0xC396CEE5, 0xCF2D95CB, 0xB9DCF0F6, 0x51F3BCE4, 0x6F93D076,
    0x5C9E5A1F, 0xCB216B93, 0x9DED2835, 0x3D650F57, 0xB604F579, 0xAD59B5E4,
    0xEFCAF1E8, 0x8AFD3812, 0x98753B43, 0x966538F7, 0x25A4FA6C, 0x953C3DB8,
    0xE257E38E, 0xE1E652DB, 0xC0977C9D, 0x586BF0F0, 0x87B70B41, 0x96EE2347,
    0x3D7EF408, 0x9325E411, 0x6B4AC62D, 0xF0D67C17, 0x80AF6896, 0x9E43DE16,
    0xE8339BC0, 0xC1AE6BBD, 0xD29F7CDB, 0xB7CF0DE0, 0x83A25837, 0x7454FA55,
    0xBD20EC3E, 0x96B70B5F, 0xB0D3CE66, 0x5670D625, 0xCE1AC75A, 0x08A95A6A,
    0xBEB04762, 0x4F744FAC, 0x85B4AE87, 0xB03DBD3C, 0xED12C349, 0xF1E82D81,
    0x65B796C0, 0x9EF86937, 0xD78E9EE8, 0x8D139CDC, 0xF45B3BBD, 0xE1EDF094,
    0x96215C7D, 0x6F1E3EF0, 0x41E3EC0B, 0xB03DDED6, 0xD9377B85, 0xB65388E3,
    0xB2B9A075, 0xA816DE3B, 0xBDC1D23C, 0xCB85B121, 0x12D890CA, 0x72E50E68,
    0x6F2DB9A0, 0x1CEB3609, 0xD119BDCD, 0xD59BDC82, 0x561EEF46, 0x10B6078F,
    0x16EB1C9B, 0x4B10716D, 0xD63BD26B, 0x215A4D70, 0xB931F096, 0xA4DBC70A,
    0x26ECF607, 0x1765B03D, 0xB93D81BF, 0x8C74F742, 0x1ED3BC85, 0x6DEE40AF,
    0xC56C12DD, 0x2CB742BB, 0x79C51D3E, 0x73445CCF, 0xE6C439EF, 0xB5C253DE,
    0x8B0A74D3, 0xC4299EF3, 0x4D2A7A96, 0x3D785A1B, 0xD27BC2D0, 0x25C0F092,
    0x47BBDC3D, 0x1EA3A67A, 0x3D81BEF1, 0x3D81EDE1, 0xB52A0764, 0x16B17879,
    0x2297D0F3, 0xD89A18D9, 0xDA13D642, 0x4A3C3DB3, 0x2C787B70, 0x28EF7319,
    0x44D48AF9, 0x1DEE2FC9, 0xC617D225, 0xDED6481B, 0x37E1E528, 0xCD030528,
    0x588509F1, 0xDE26B1C2, 0x9E7A4816, 0x3D90F64D, 0x6BADB1D3, 0x17A36D62,
    0x1205815C, 0xA724960D, 0xA3C0B1B4, 0x0A7B2FBD, 0xC0B27674, 0x6814F648,
    0xF169DC59, 0x654EB8ED, 0x28175245, 0x93B3FD06, 0xE1681681, 0xA39F1E01,
    0x364D248E, 0x4D2489BD, 0x5A05383E, 0xA9D06922, 0x9B4BD0DC, 0x78ED16B2,
    0xFB6BA3F2, 0xDB5D39C8, 0x54CB624D, 0x19257B7A, 0x649E292C, 0x924F9587,
    0x8FCAC1EC, 0x813FF3A8, 0xFE756E00, 0xCEADE29F, 0xB3AAC0FF, 0x04F3FF3A,
    0x13FF3AA3, 0xE752F004, 0xE7C134FF, 0xF7E67177, 0xD094A27C, 0xC681DEF6,
    0xF4C96236, 0xF6E85AF3, 0x95A5AF13, 0xD02D7C2A, 0xC2D6F137, 0x8AFD5E03,
    0x57AD0779, 0xF3F41CCA, 0x03B4EE2E, 0xB79B75DF, 0xA6E2BBC4, 0xC6D3A823,
    0x2A5E8702, 0xF87A39E7, 0x6EE831B4, 0xFBA40DCF, 0xD35780E6, 0x206EC85D,
    0x8F5F9CAD, 0x6C8FBDE6, 0x3AEF7879, 0x5CE7E6C4, 0xD05F83C3, 0xC0BC835A,
    0x72DE65D9, 0x63A6A234, 0xE3768789, 0xE951B785, 0x56A9AFE6, 0x7C3EF78E,
    0xBDCC9394, 0xD7C2A95B, 0x83522B7B, 0xF8AB02D7, 0xBE2816D3, 0x59702D81,
    0x571879F8, 0xACD1EBE8, 0xC181BF36, 0xEF43D22A, 0xF0E6E51B, 0x40F13D2E,
    0x5DE7A05F, 0x12E6989B, 0x1907D9E8, 0x86BDC0DE, 0xB6754DBF, 0x766215C8,
    0x532F18B4, 0xE4FD137D, 0xF073AA16, 0xB0D0825C, 0xB2168DEB, 0xB4E0B525,
    0x97147A44, 0xE57BA474, 0x52A606F7, 0xD23E0B69, 0xA5A6B03C, 0x876879F7,
    0xC3C3DB2D, 0x6F5EE839, 0x1BD34AB0, 0xBC40AC18, 0xBE0A51DC, 0xA1481D1E,
    0xA5634AD4, 0x788EBEE9, 0xA29B07B2, 0x9206E6F8, 0x9C2CB81E, 0x1D25C1EC,
    0xC1C5CB64, 0x1C78AB01, 0x40DA046F, 0x7A608029, 0xEFD07AF9, 0x9A2D9D83,
    0x0080A3EE, 0x748A0000, 0x5DD361C7, 0xE958B78B, 0x7297FEC0, 0x2FD81623,
    0xF14E9A77, 0xF387E2E6, 0x8C177789, 0x74A57EC3, 0xE13E43FF, 0x8CFE0E7D,
    0x929439F7, 0x559B951F, 0x5EA735EE, 0xFA9A7F7C, 0x86B52BE2, 0xD930FC5F,
    0x3EC7E2FC, 0x61FC2FAA, 0xD12DCEB7, 0x949F9D37, 0x1B4C5615, 0xBD1D92FF,
    0x68C3FC77, 0x237DFB21, 0x3056C85A, 0xA7AA660D, 0xD62C9911, 0x7F99FCD2,
    0xDE626029, 0xF365CDCA, 0xE6D31409, 0x6E91427C, 0xB76027CE, 0xDDAE0FCE,
    0x99EC9B4E, 0xEC9F9DE2, 0xB0DC2DDB, 0x3BDA3D03, 0x57ACFA3F, 0x4B97C7A0,
    0x72679178, 0xF13E5F9B, 0x679399AB, 0xCD7E8307, 0x2B076F5F, 0xBACBB292,
    0xEC92F307, 0x96969D09, 0x83A34322, 0x1C541EE9, 0xE6FD9FB8, 0x117BD787,
    0x4A371825, 0x9A741EC1, 0x460BBBC6, 0x778B485A, 0xC1CC85A4, 0x9D640F5E,
    0xD3B0252A, 0x54DF6B53, 0x56514DA4, 0x559037D6, 0x05AF5EE0, 0x947ECC0B,
    0x27CE4093, 0x9F9D91F6, 0x5205594B, 0xF03782B1, 0xC1E305DD, 0xFB71C57E,
    0x94569F9C, 0x642D18A6, 0x5BE980A7, 0xE6E7686B, 0xC0DF427C, 0x84FB2168,
    0x39D90B46, 0x575A4A05, 0x1B74E9EA, 0xA54D25B1, 0x4C51A6B0, 0x6BB27675,
    0x84B787A4, 0x04635387, 0xB4B414AB, 0x4BB294D3, 0xDF74D39E, 0x7B0E2F24,
    0x4D4895B7, 0xE7621F5B, 0x7889F3F4, 0x5C5AEE86, 0xF0FDBE71, 0xD48DFB00,
    0xB13C51B4, 0xF3F17364, 0x3E7E44F9, 0x6C04B079, 0x47AEE9DE, 0xC836173A,
    0x45DFE017, 0x8E514BBD, 0xDB53F79E, 0x72ACD871, 0x93ED1BEF, 0x493ED37D,
    0x0B32904B, 0x435AD0B6, 0xDC76EF6F, 0x2DF4E940, 0xDF98A0FE, 0xAF395A40,
    0xCE6F9BE9, 0xDAAB2825, 0xBDA45AF1, 0x9E47DADE, 0x33D0F5E9, 0xBB04B4EF,
    0x961D2A73, 0xAFD02F26, 0xB29CB565, 0xAC352E4B, 0xE5B39CF3, 0x5B0E7A06,
    0x82EF5AEA, 0xD379B91D, 0xA3C2969B, 0x6D3C296E, 0xC992B2BF, 0x9C9707DA,
    0x739EA2F7, 0xC67DBD1C, 0xAE31EA0A, 0xEDE79EA0, 0xDBD4D7BD, 0xADEB9D02,
    0x4AFC705D, 0x47533D07, 0x3D1A9A0B, 0x93D15A67, 0x35CE9534, 0x62C45A56,
    0xD927A4E5, 0xE792E4B0, 0xF9CB69CB, 0xDBCE65A2, 0xF7B6EBC0, 0xD9532591,
    0x773A4583, 0xEF538DC4, 0xCB695C96, 0x83B4E782, 0x605E9C5A, 0x9EC2D39D,
    0xCF64C5A4, 0xA65BBC38, 0x8B9611C2, 0x68572E1A, 0x38A160F1, 0x934A1CF5,
    0x1D728517, 0x9ED1E4D8, 0x96C3C9A4, 0x57A594B7, 0xB16BDF69, 0x4683B9BE,
    0xE831BE97, 0x83B3A1F0, 0x1634F65D, 0x0B0F0765, 0x69C2E4B1, 0xF5AC525A,
    0x49C6E78D, 0x8F59BE83, 0x9D822FB3, 0x97AD03BE, 0xF4163B58, 0x9BB045CD,
    0x5F5A4ED2, 0xB18B43B0, 0xED6EB29E, 0x153DA57C, 0xF3A2A4EC, 0x13B17A5B,
    0x533C2F8F, 0xB41631AC, 0x0B258C2C, 0xC61F2FAD, 0xBC58C6CA, 0xE8341F2A,
    0xB5D62760, 0x3D638FC4, 0xBA9EECA6, 0xD972D7EC, 0xEE6A6B18, 0x6817B398,
    0xB1F765E2, 0x7651E23E, 0xECA2C17A, 0x771622F4, 0xD2ACA7D2, 0x3E17D686,
    0x4F58D068, 0xB5872C61, 0x760BE741, 0x0EC173D9, 0x86C2E556, 0xC172EC15,
    0x9BB05F42, 0x2E4BE3C7, 0x8ECA6A4F, 0xB365D839, 0xEEA2ECA3, 0x94D0683D,
    0xCADC53DD, 0x5F695E22, 0xA1DF5874, 0x15EB12F5, 0xC9E358C6, 0xBE5617A5,
    0xF1346ED2, 0x6BD583B2, 0x8C6DEFB1, 0xC4F7ED65, 0x1D83BAD6, 0xDD158765,
    0xC58C6DF9, 0xD6792F4A, 0xEB4F6B65, 0xBD3E35D3, 0x5E949D82, 0x3B279948,
    0x4BCEE9D8, 0x49E33C4A, 0x63DEAA4B, 0xCA585527, 0xB4EC1DD2, 0xDA760EDF,
    0x5C4EC175, 0xC636F517, 0x896A7AC2, 0x341B5897, 0x05E708E8, 0x43E9D82B,
    0xAC29AC63, 0xF2BB4AA7, 0x9631B3A1, 0xCE3DAF5E, 0x7ACC5C97, 0xBD630785,
    0x592C6346, 0x6565B4F0, 0xD2B92E5F, 0xB18D652E, 0x7886A7B4, 0x0B185E68,
    0xE9582A6B, 0x2FB38F5A, 0x8D9C599A, 0x1B8BB8B1, 0xBA3C78B4, 0xE94F82F4,
    0x2F4FA585, 0xD83B2ECA, 0x5DCED3E9, 0x5C97D9DA, 0xF0DAC6B2, 0xB0D06D29,
    0x7C5A341A, 0x76567A07, 0x0E8D7BB0, 0xFAD9DA76, 0xF53C4BD0, 0xB93B6976,
    0x76514DF2, 0x5E9F657A, 0x60AAED61, 0x5638FDA7, 0xC4765369, 0xE6617D03,
    0x30F058C7, 0x82CB69D6, 0x7D6C9ED6, 0x75EEC1DA, 0x61F12F58, 0xC7E8368F,
    0x7CEAC9D9, 0xC6374B18, 0x975B9D7A, 0x58C6A9AE, 0x0ED3E57A, 0xB95EB697,
    0x0AC613C7, 0x40A6F056, 0x96BF730F, 0xBC47D635, 0x88B97609, 0xF43E54F7,
    0x69725F68, 0x5B4BB9A3, 0xA7D6927B, 0xBA58C62D, 0xF4BD2B16, 0x2CF0C4B3,
    0x6BAD06D6, 0xDD2AC54D, 0x29E5A0D0, 0x054F7CED, 0xF7D97CBB, 0x40B18C5A,
    0x58C63D4F, 0x5E22CADA, 0x2F4B2B73, 0x9D8583A9, 0x6BDF335F, 0xF38CF6B1,
    0xEE6CBB05, 0xEFB4ECA3, 0x5A6B2B40, 0xCA8BA92F, 0xACBA760E, 0x3314D64F,
    0x5D2C4765, 0x05D627DC, 0x94D97D3D, 0x85E9771D, 0xEF760ECE, 0x6B0BAC7A,
    0xA5DAD189, 0xA5C9C6BD, 0x71D82EAF, 0xE6BD681F, 0xD2CAD594, 0xAEC4DDC7,
    0xD6081E81, 0x8903D040, 0xAEB286EB, 0xBBCD7621, 0xC66BB134, 0xF3BCD4D9,
    0xD9D7EDE3, 0xCB4DE416, 0xD7E83DB8, 0xBE4AC4DC, 0xBF9B8C86, 0x7AF5F02D,
    0x5F05B84F, 0xEFDAC0B9, 0xA14AC812, 0xEA16B916, 0xECA0E940, 0x7DD161A8,
    0x36B43583, 0x86B42D07, 0x815A41EC, 0xC9EF372B, 0xA51BCD16, 0xF6E07B0E,
    0x5B92C570, 0x1ED9B942, 0xE392ECAE, 0xE0BB5D86, 0x9E04BB03, 0x0F4475E1,
    0x40977E73, 0x4351E1E6, 0x21A8BE74, 0x1E5BD836, 0xEA3EE2E2, 0xEDED626D,
    0xD9A8896D, 0xECF6B437, 0xB3A65B45, 0x73025DE5, 0xF9DEA3F3, 0x34F76E22,
    0x34E09698, 0x29E894F8, 0x1AEB6A51, 0xDA555CB4, 0xF4D493E3, 0xAB29A394,
    0xB7C5539E, 0x54523F41, 0x683C305B, 0xB03283A5, 0xB4ED192F, 0x9EDEE304,
    0xE0BB51D3, 0xB78AB634, 0x5B1B591B, 0x7EEF6A50, 0xF7605650, 0x267CB60A,
    0x26C36F6F, 0x06F5704F, 0x4C0DF799, 0x8F82ED56, 0xB4D79CAE, 0xF86B18D2,
    0x74F213EE, 0x4F5620AE, 0x1CAE236C, 0x0C65B268, 0x77874F79, 0xE96E1AC7,
    0x1E96D16C, 0x64D0EDEE, 0xDB25EDED, 0x39135FC3, 0x8B44BCB7, 0xBC5DE7AE,
    0x3EF5C489, 0x17387B70, 0xC7D3DCE7, 0x4DEC1743, 0xD3DCACB6, 0x9C6EB5AF,
    0x258ADEE6, 0x556570D6, 0xD5652E84, 0xED4A5E85, 0x9295BDCD, 0x6A4570F0,
    0x0AF4387B, 0x9D890DEE, 0x3B1203A7, 0x95DC37B8, 0x3C503DA6, 0xB6730DE4,
    0x812CC3D4, 0xA076F7E6, 0xA96F0DF9, 0x1EDEC8E7, 0xD81DAC4E, 0xEA3B2DA2,
    0x52D862D1, 0x7A8C3C9A, 0x096215B4, 0x2F0D26DF, 0xEF1DBF76, 0x79075BB3,
    0xB9033F7A, 0x6EB16E77, 0xDD6965C9, 0xE1AC78F9, 0x4F77B8B9, 0xE4DE8EF6,
    0xCFBF4474, 0x7A05A21A, 0x66F7384A, 0x5745B3CD, 0xD23D4B60, 0xB92EFD33,
    0xA92EFD81, 0xD4A0BA1C, 0xB8E9E423, 0xBC3ADBDE, 0x6F477B91, 0x7D0F0962,
    0xE0A3A42D, 0x3D28EF70, 0x0FB03BDC, 0x709604F6, 0x70F140EF, 0xDEE19AC7,
    0x4F26F641, 0x9B528947, 0x1EE84963, 0x37B83AD2, 0x48D08169, 0x936069DA,
    0x151D381D, 0x58E6D4A8, 0xDBF22E4B, 0xEF3F8FA1, 0x7A6836F5, 0x6867C91D,
    0x1279B7B2, 0x0A7275CE, 0x0DA3EC96, 0x4B06C4C5, 0xA4D3525B, 0x3E4AE0B6,
    0xEF5C91DA, 0xF9251BA3, 0x93C5DE8C, 0x39C376BA, 0x1349DDEA, 0xB7EF6743,
    0x2C316744, 0x12476AB0, 0x68B4A99F, 0xA502AA72, 0xCCE2D3B8, 0x25CAD3BB,
    0x476496C9, 0x45D0C0B2, 0x02C60593, 0xB581F5BD, 0x5280DF2B, 0x95D41B74,
    0x5C379295, 0xE50DB958, 0xD2B791A6, 0xDF2BCD13, 0x8D35E51C, 0xE8B335A1,
    0xE8B33523, 0x896B3522, 0x27A0BD9A, 0x4D1B5A74, 0xA399BC9A, 0x2DC35286,
    0x979A0B7E, 0x78F335A1, 0x1ED7EBDF, 0xC8DC752E, 0x28BDA376, 0xBF178D5E,
    0xA457B777, 0x3CF26815, 0xB9C7AFD4, 0x798BD7D5, 0xBB83DBC5, 0xDF03B79F,
    0xFA55BCF5, 0xC852BE06, 0x8D05DE5A, 0xD262D478, 0x12DD2D43, 0x1F0E5994,
    0x47D06ECA, 0xD37BCD0F, 0x9CDCDEBD, 0x4D382ED6, 0xD207532B, 0x69A5A9CA,
    0x2D229A0D, 0xB5A6A389, 0xB5A09AD2, 0x1CA83A24, 0xD6548DD5, 0x783F0745,
    0xFB2BCDE8, 0x2B4D5A26, 0x760E2B9A, 0x588B4A35, 0x9691694E, 0xB43C6E52,
    0x03760B95, 0x08E9C395, 0x18641F65, 0x40B92ECA, 0x12D81765, 0xB778494A,
    0xA13D0522, 0x2C61E22C, 0x103783D8, 0x0FE73716, 0x0F2DA294, 0x6096875C,
    0x590B581E, 0x587EE3ED, 0x560EEF61, 0x3D9B7D98, 0x22EFB86B, 0xD711F6FB,
    0x0FA2DA5C, 0xA6D9EB29, 0xA3DBD53E, 0x7876C476, 0xA946DEEF, 0xDDD377B7,
    0xC3E5F742, 0x1BA2D9E6, 0x53EE3723, 0xB604D73A, 0xD1EBE34C, 0x53ECA8D3,
    0xA5A057A7, 0x4F931F36, 0x489BC1C9, 0x234BEDD9, 0x496E9ABD, 0x4B5E1F6B,
    0x3489637B, 0x7A43B4BD, 0xC9A43BD0, 0x55A4306B, 0x1CE16429, 0x9650606B,
    0x0650638F, 0x4EC1925A, 0x39307307, 0xB81B8E71, 0xEE9D023B, 0xC312C08E,
    0x25A6958E, 0xCB604B18, 0xAD1D9D83, 0x1A51B591, 0xC0C6EA8F, 0x83CF1453,
    0x835EEC15, 0xA082D9DE, 0xA05AC207, 0xB00EB291, 0x2081BF39, 0x815900AB,
    0x00C0BC37, 0x5425A66F, 0x79F0E6E5, 0x49AEAD9C, 0xCCA396AE, 0x698D37D1,
    0x6935291D, 0x7E4B61A1, 0xBE4C3914, 0x3A2B2AA5, 0x09A59780, 0x6D36E9BF,
    0x43305B4E, 0x2716BBA1, 0xD12C0844, 0x2D77412D, 0x8E2B413E, 0x5295D04F,
    0x370FCEEB, 0x5609F162, 0xA5C3F3B9, 0x6A8BE2DE, 0x82EEF13E, 0x6536827C,
    0x7827CD27, 0xC7578B11, 0x9955E43F, 0xBF25284F, 0x1F252896, 0xF9522B59,
    0xF9522B5B, 0xF9522B7B, 0xFCA9145B, 0xF2A4549D, 0xF2A456A7, 0xE548A5A7,
    0xCA91514F, 0x2A45539F, 0x548ADE7F, 0xA456CAFE, 0xA45687F2, 0x48A767F2,
    0xA4567FE5, 0x48AE3FF2, 0x915B7FE5, 0x9146FFCA, 0x22875FCA, 0x147EBF95,
    0x15B7FCA9, 0x15B3FCA9, 0x5733FCA9, 0xADCFF2A4, 0x4F9FE548, 0x8F3FCA91,
    0x2E7F9522, 0x1CFF2A45, 0x19FE548A, 0x87FCA915, 0x0FF9522A, 0x9FF2A457,
    0x1FF2A456, 0x3FE548A6, 0xFF2A4544, 0xFE548AC9, 0xF9522A43, 0xE548A3CF,
    0xCA914C5F, 0x9522B4BF, 0x9522897F, 0x2A456A7F, 0xA91454FF, 0xA914E5FC,
    0x522A83FC, 0xA45707F9, 0xA451C7F2, 0x915547F2, 0x22A17FCA, 0x45693F95,
    0x15127F2A, 0x2B41FCA9, 0xA783F952, 0x920FE548, 0xE0FE548A, 0x73F31B03,
    0x7F8C6C29, 0x9F372AC8, 0xA6B0F8B8, 0xC6EEFE2F, 0xF02BBF8B, 0xA4DF7302,
    0xCD3593C5, 0x0913E19F, 0xDCEA61D4, 0xCD0AA5F3, 0xC78FD81F, 0x96D3B29B,
    0xE57E73DC, 0x977E84F1, 0xE91F1666, 0xC5B4B229, 0xF4B6B6B4, 0x373BD73E,
    0x30EA51A1, 0x20BB5934, 0xB8DD22B7, 0xA76C39A3, 0x68F1A069, 0x5697DAEC,
    0xB48D34EA, 0x56538A10, 0x69C8C1AA, 0xA53D2FBA, 0x7E1ED9E6, 0xB7E77303,
    0xE638B425, 0xE7C78074, 0xFB3CDD34, 0x53EE34F6, 0x5A3F619E, 0x558251C8,
    0xF9F814E0, 0x5A267F04, 0x69E169C8, 0x515B586D, 0x0DE0BB3C, 0x88375A56,
    0x82DBC535, 0xB4781F70, 0x8B5DD185, 0x9A279507, 0xB07B042E, 0x8B5DD079,
    0x38CFC8F3, 0xBDD274C8, 0x7BF77B02, 0x7CE3C108, 0x0DE07637, 0x42F2F274,
    0x6952EEF6, 0xF87E2E0E, 0x93E67F04, 0xF533C4E9, 0x32FD8079, 0xD959834B,
    0x74CC037E, 0x51F9E2D7, 0x17A6564A, 0x06F93528, 0x07B0DA5B, 0xC9590BC3,
    0x505BA52B, 0x8AF25BCC, 0xAFCA9EA3, 0x73946A74, 0x45DDFABA, 0x8BA65C20,
    0x5D073D5A, 0x094AD7E7, 0xA753677A, 0x957DA6CE, 0x4B915E3D, 0xA0E15C7A,
    0x87677A95, 0x53A53D34, 0x593688E9, 0x56B268D4, 0x14DC7507, 0x2923A0B1,
    0x5633B7AD, 0x742F7832, 0xA4D691D2, 0x5942D91D, 0x9D17DAE7, 0x71CFB82E,
    0xF2B3F6F4, 0xA7B2672B, 0xC6B43CB1, 0xEB264E96, 0x94DBDEBD, 0x0529E35D,
    0x14F619E1, 0x71BC6DE9, 0xDF38B636, 0xDE2E54F6, 0x3BBA71E3, 0x538B48A6,
    0x862D22F3, 0x6F972C2B, 0x583C8A4E, 0xD8C6B261, 0x72585CE2, 0x583D2853,
    0xC9A3A5A4, 0xB64DA39E, 0x63DF38D4, 0x8F586378, 0x96793B29, 0x7D63DCB6,
    0x95D2C54F, 0xA2E0AFAD, 0x9A9EB0EC, 0xFD0A7AC6, 0xF71F2B18, 0x622C0F45,
    0xD34E66E5, 0xF886AC5A, 0x4D727694, 0xCF6B0AE9, 0x4A7AB369, 0x29AC3617,
    0xA0C2F9D6, 0xAF1358A7, 0xEC1D1C4E, 0x68161606, 0x3C6ACA6E, 0x51F45594,
    0x594EC156, 0x2574B188, 0x353F4FAD, 0xE4BC7C9E, 0x8F16BD72, 0x3963C5A1,
    0xE9710D74, 0x1D62EC15, 0x3EB4F416, 0x87657A56, 0x0ED681F5, 0xEFA36B33,
    0x3B5B4B92, 0xD06D63D6, 0x3D17DD62, 0xF5B1897A, 0xD6378292, 0x46829ECE,
    0x2B81BB07, 0x630F8D58, 0xD9C7BE9D, 0xFB87AFDC, 0xCD7E8594, 0x4ECD063C,
    0x8D0EEA6A, 0xBE5CD7AD, 0x1EB2CC7C, 0x369F4BBF, 0xB0B9D5E8, 0x9789A162,
    0xF69F2B0F, 0x9E58C2E3, 0xE836B6B1, 0xD1B2B3D7, 0x394F657A, 0xC2394958,
    0x594F7AEF, 0x92B1EFDA, 0x5631B7EA, 0xF31D8387, 0xB8EC525B, 0x85E959B5,
    0xA7C7A075, 0x7D6DF8FD, 0xA7E37CE8, 0x92F3A6A4, 0xA3654B0A, 0x656163B5,
    0xD63D61CB, 0xD62BC4B5, 0x3D72BD63, 0x0B9D9475, 0x5CB31F5A, 0xC4DCBB36,
    0xB078CF0B, 0x258DBD72, 0x3B057BC7, 0x16831EBD, 0xE22DEB13, 0x8EB14DCD,
    0x98FD0F95, 0xAC3E75F9, 0xF4B3C2A7, 0x363D4F69, 0xCCC782C6, 0x6BACC53D,
    0x0FA2FB5A, 0xB075E963, 0x92F2FA2F, 0xCB331AC2, 0x17D2C615, 0xB15CAF4B,
    0xC71EFAC2, 0xACA7CEE2, 0xAC7431E9, 0x6B938F7C, 0x9D01E83C, 0x72BADA5C,
    0x7A05E94D, 0xBC162F9C, 0x58B96BF1, 0xCE8DA5C9, 0x189797D6, 0x1A6F9D1D,
    0xD02C4D0D, 0x8D063D7A, 0x1DA58396, 0x1D1B2F9D, 0xB335EEEC, 0x89D9AF5E,
    0x2F11DF1F, 0xF671EEFB, 0x758D725D, 0xF7CA92E5, 0x53DF3B98, 0xA8BC31E8,
    0x8740BD2A, 0xF585F5B5, 0x692B1562, 0x3C36B46D, 0x8FC4B82C, 0xE1CCDAC3,
    0xBCC4EC7C, 0xE17DA7C2, 0xC358B7E8, 0xB1EF9725, 0xC43760EE, 0x2C635622,
    0xD1D0396D, 0x37D0B527, 0xAECA2C3E, 0xF5D3B31E, 0x3341A4AC, 0xBAD1B387,
    0xD03ED6D1, 0xF3A073D9, 0xB3A1F585, 0xC36B1EA7, 0x34953786, 0xB0F8B13B,
    0xF79B47B2, 0xBBD61738, 0xAC6CE2D0, 0x8E25BEB1, 0xF3B3A4EA, 0xB478CF31,
    0x33D153D1, 0x58C4689E, 0x61C9E268, 0x3965353D, 0xDA3D86EB, 0xC7ED2CA7,
    0xF3B8B1CC, 0x93C4A78D, 0x79B584F4, 0x058782C5, 0xE3DEFC5A, 0xE94F5760,
    0x5D3B364A, 0xDCD9CCD3, 0xCBE5F4EC, 0x8D9DC58E, 0xFD9D1AB1, 0xE0B1C7AC,
    0xAE4E8369, 0x15C9D959, 0x7B4A6A2B, 0x6C2E7656, 0x1EAEC178, 0xC678DF6B,
    0x1340B0B2, 0x29B99F4F, 0x7E8D77BB, 0x312F398A, 0xFADE29BB, 0x0DCE8A9E,
    0xE4BE5497, 0x972D3562, 0x7E1C2F9D, 0x588B0C6A, 0xA4BD63CC, 0x25679EDE,
    0x9BE5F47B, 0x3897A62A, 0xB60E8DAC, 0x577E83C6, 0xB058AEB4, 0xCBBD4DF3,
    0x88EDA1DB, 0xBC0AF38B, 0xE65ABD79, 0xDEBAFDBD, 0x0B79AC0A, 0x6B2BCF3D,
    0x582BBF7A, 0x6E63D43F, 0xF4DDC0EA, 0x09E9B3A6, 0x0D6B415D, 0x3B7BDC3E,
    0xDCE612F8, 0x5B025DFB, 0x06616C6D, 0x6F7AC77D, 0x7B18B687, 0xDB25ADFB,
    0x0D763BC3, 0x48B5D9AF, 0x2D92BDE9, 0x78E5CD93, 0x7C8E96EE, 0xE6F912D3,
    0x2DE2E606, 0x81682B93, 0xCEBD0D79, 0xAE71BA2B, 0x2AA5DA53, 0x36F53C25,
    0x6176F4ED, 0x9183DBA4, 0xF037A096, 0xACA9B7EA, 0xB1207388, 0x88BAC4D8,
    0x4FD2258E, 0xE27BCD80, 0x0ACFD3E1, 0x41E9060B, 0x037D3C9B, 0x72234B8F,
    0xA2BAD7A9, 0xAB31291E, 0xF79E288D, 0x977EF0F1, 0x64DBC5A3, 0xF3AF3D4B,
    0x0B6DFBBB, 0x659F6F5F, 0xBCB71F5E, 0xBDE7B02D, 0x35EFDEE1, 0xA7B26C69,
    0xDD0AF143, 0xA3D4CDCA, 0x0A2D121C, 0xA945BBD1, 0x2A450E98, 0x3C99D0D0,
    0x05B6BD0D, 0xCD3C8B12, 0xF337A3CC, 0x6FCC3DE6, 0xF34E616E, 0x71F4B309,
    0xB34F20E6, 0x4AC1D3CE, 0xE12D87B0, 0x6EF48CDE, 0xCF5C96D1, 0x77A790B6,
    0x1EEE35F9, 0x96BEF4F2, 0x1DC37DE9, 0x6F4D2CDB, 0xFD9699AF, 0x16D9EC0C,
    0xB85BBDEE, 0xC6155E77, 0xD9DEE1EC, 0x6F725BA2, 0xB37B9DEE, 0x3C82B915,
    0xF5CA26ED, 0x58C54738, 0x11D3D3C8, 0x3A63A58D, 0x77B94D2A, 0xB2DEE689,
    0x0DCA348A, 0xDBDA96F7, 0x3DD1EA50, 0xC4F5E1E1, 0xB71DEE41, 0xE1389E89,
    0x138BA1DE, 0x30E7B43B, 0xB18E1CA6, 0x1AF6A3A3, 0x1D81E81E, 0xAC775A58,
    0x1B79BDCD, 0xEA78A167, 0x851CA941, 0xF28C3952, 0x267C6DC4, 0xE989F11A,
    0xCB4827C0, 0xD93138C2, 0x16C9BDC2, 0xF81D90F1, 0x1A19643E, 0x27A8C349,
    0x169D039F, 0xEA48C678, 0xF99306DA, 0x4F36F816, 0xB77EF4DE, 0x0B05DC21,
    0xC917DED4, 0xDE896FDD, 0x664D1E05, 0xF93C9727, 0xD7CD377A, 0x5376AA7B,
    0x8AF5B55D, 0xC1B6BA64, 0x4E779E47, 0x68695EC7, 0x60CF92D0, 0xBC102943,
    0x65746BDE, 0xF3DBA972, 0x4D7CDBDE, 0x95A1BE63, 0x176E5CA9, 0xB5A708EF,
    0x296A768F, 0x905AFCCA, 0xD10B7DF9, 0x1B5E4BEF, 0x27C7D0F6, 0x609F0AEF,
    0xFD4BEF6F, 0x7B698778, 0x00F65607, 0x99C58F2F, 0x65A7EBD6, 0xE7C2F6DE,
    0xB7BC1665, 0x47534F02, 0xD3CCA31F, 0xDCA9329B, 0x8CA12D94, 0x74DDD09E,
    0x7DD072FB, 0xA2969473, 0xD1CAD374, 0x0AF0D694, 0xDC81BC6E, 0x43786B18,
    0xE83DE6E9, 0x4AECD7CD, 0x906B4AF9, 0x9D3D792F, 0x69EEA85B, 0x3D934F81,
    0xAA3ECA18, 0xD6F85945, 0xA57BDE86, 0xC3604BB0, 0xDC206F23, 0x31437AF5,
    0xDC96B05E, 0x95652EC1, 0xC75905B2, 0x4DE36765, 0x5C1BE92C, 0x65C34487,
    0x04BBD621, 0x0AC35712, 0xE8F4A5ED, 0x6FA2DE1B, 0xC15D6EF8, 0x9E87B65A,
    0x76A6F1B7, 0x8BBD622B, 0xD4BD96EA, 0xEEB64F25, 0xF6236695, 0x960E35CE,
    0x5CCD724B, 0xC22E6784, 0xCD6094CF, 0x592B2814, 0xC4BBBA62, 0x2E553B03,
    0x27B292D9, 0xD8A3D2AE, 0x5037A628, 0xE91F1BDA, 0xD4E91E8B, 0x0969D227,
    0x22D6514A, 0x9E425B05, 0x9E159FA5, 0x5B282E52, 0x5377A3BB, 0x788B560C,
    0x04B69451, 0x2E073B4A, 0x4D2B157E, 0xB92B13F7, 0xA46805F4, 0x1F697D0C,
    0x5A175EBA, 0xB11A2360, 0x02E67B0A, 0x891B87AF, 0x3A8AAAD9, 0x1CD7555B,
    0x899E4CAD, 0xEDEDE41D, 0x206F0B20, 0x93618F59, 0xE80577AB, 0xBF602D8D,
    0xB63D59D4, 0xC3298F3C, 0x2B4D3A48, 0x7EEC1E9C, 0xADFA373F, 0xE9DCDBCA,
    0x9EFDE6BE, 0x27C29387, 0x08581294, 0xAB04F90B, 0x27E697DC, 0xADE88C6D,
    0xCBF60A5C, 0x3BBB852A, 0x9399D4D9, 0xA4F01F92, 0x44F9C3F3, 0x0451CD4F,
    0xA9436FB3, 0x72D93CE4, 0xF7E744D3, 0x417BDAD9, 0x83D025EB, 0xF993B92D,
    0xBCA81C51, 0x6BD0AFEA, 0x766C0F78, 0xFB70F032, 0xB290FB85, 0x7BCAFF9B,
    0x9BEC79F3, 0x1F93A64F, 0x1CA14DE2, 0xE9EB10D6, 0xEDD2CD41, 0x8E4D3767,
    0xCDF77AF7, 0xC8C17BD2, 0x0011A39D, 0x41040120, 0x24E564A5, 0xE09F0E99,
    0xBCE750A4, 0xB393C55F, 0x5B28CF15, 0x8ADB0CF1, 0x3C568527, 0x478AA14B,
    0x6981758B, 0xF353C725, 0xF5D37EC1, 0x77E00EE2, 0xD7CD4B45, 0xE5F35140,
    0xAF74C52A, 0xD2EB05D8, 0xC0C6E3E8, 0x7C8115DA, 0x27B90BDF, 0x9CCFE434,
    0xC8782F9B, 0xE729A42F, 0x67F04F9F, 0xF3F274C8, 0x6FF90F41, 0x5CEEE294,
    0xEF6246A3, 0x902AC53D, 0x9605605A, 0x8E2F7874, 0xEF6F8C3A, 0x989F4ACE,
    0x9C3A9CE8, 0xB4694353, 0x2868DAF9, 0x20ED6D96, 0x276D778F, 0x2E9AE8AF,
    0xEC1725A5, 0xA945EF29, 0x6A549567, 0xB25A9CBE, 0x54E79353, 0x63D7158C,
    0x25C3996C, 0xB4DF8B37, 0xB83AF4B2, 0x053D9B26, 0xA765174B, 0xD2C2C29F,
    0x6E96394F, 0x9ED6E1E6, 0x29E35D6B, 0x29FA5966, 0x0E7A05D0, 0x3DF975AD,
    0x5F49375D, 0x47C3BB58, 0xEA7BE8AC, 0xEBD77374, 0x7EEBF0EC, 0x60A7B257,
    0xE85E55C9, 0xFA5EE6A8, 0xDC957598, 0x2B056078, 0x07D3D8D0, 0x59683C6F,
    0x7D623DA7, 0x07DCACF2, 0x2D94595A, 0xD0AB0356, 0x7D7BDFBA, 0x74AB972D,
    0x565A1563, 0x5E9DBD61, 0x77E92E9A, 0xA1CB304D, 0xCB161F4F, 0xB0770F0E,
    0xBC3D7A8B, 0xA1D60FB8, 0x653AC575, 0xE375EB31, 0xFB8B2971, 0x42DF41B4,
    0x9AF59727, 0xF4FA5766, 0xC567AE8D, 0xEE8E3F3A, 0x96F9C6F7, 0x8F136578,
    0xAC2A7AB2, 0xED3E8A9F, 0x3E8DBF1B, 0x14DEFDD0, 0xF874167B, 0x5C39F2B0,
    0x4BCAB968, 0xA3D926BC, 0xA7AA9E4B, 0x16078578, 0x8AC1C8F6, 0x3B4EBC9E,
    0x88ABA53F, 0xC43C38F7, 0x6FD0EA7A, 0x9F0AE9A7, 0xDF4B15BE, 0xB99EC97B,
    0x1FAC77CB, 0xE3C7B25F, 0xCBC15621, 0x3F6564B7, 0x3DBF68EE, 0x589E3DA5,
    0x299E6687, 0xC9D679E6, 0xA4BB9ECA, 0x1874560B, 0xF41897B1, 0x0BE77253,
    0x4FA2BA56, 0x59E4B10E, 0xAC6160C5, 0xD039E335, 0x6BAD39E8, 0xF1FAEF11,
    0x453D0FA1, 0x594B2959, 0x3C31BE11, 0x9E3DD95D, 0xB7E3D577, 0x1F4627D1,
    0xF0E59EF1, 0xF3C6FA18, 0xB1BA1854, 0xAC3E5787, 0xE9D82BC5, 0x1BB8B60A,
    0xFB5AE8AE, 0x8D7EF475, 0x777BDE2C, 0xA16DE7D3, 0x6BC5964F, 0x5688E8EF,
    0xE1CDEB95, 0x812C0476, 0x6CF7ABAD, 0xA6B925BF, 0x3DE9319F, 0x9B2A3ABD,
    0x52B0D0B9, 0x72D4AEEF, 0x9D276E91, 0xB076B7AE, 0xED743BDE, 0x6C676C0E,
    0x777A01D5, 0xBD90B53C, 0xBB2B4CF2, 0xC5BA1CA4, 0x743B2FA1, 0xFC5A5E3D,
    0x897AF85A, 0xE8FBCE0B, 0xE565AFDD, 0x5E2EF2B7, 0xA47F34A4, 0x56335E1E,
    0xD95B139A, 0xE0A45625, 0x958F5228, 0x42F0DE12, 0x434F1437, 0xED7081A9,
    0x661DE61E, 0x7AB0F52D, 0x2B25B36B, 0xDEB0EF43, 0xFB7AA69D, 0xE883BB5D,
    0xBDEA695D, 0xD85D9EA4, 0x93D77B93, 0x6B9CAF8B, 0x785F16F3, 0x0494F52C,
    0x91EBCC5A, 0x945CB08B, 0x4B6103C8, 0xA4A47AF1, 0x2BBF7A22, 0xB43B137A,
    0x5A2684D7, 0x18EDAE47, 0x99E50387, 0x0A2AFB20, 0x71E5474E, 0xC48CAC94,
    0x31E28DCA, 0x5A451E69, 0xC4AD9178, 0x64C7A790, 0x52D26E6D, 0x81E8690F,
    0x77A1C6F9, 0xA78168A7, 0x06A91A73, 0x07DF48D3, 0x0764D32B, 0x226836DE,
    0x74EEB12C, 0xE8DCD74A, 0x72BB5385, 0x37BD7BD2, 0x6B02E97B, 0xB5A5741B,
    0x472BCC5B, 0xED89E713, 0x1E4B08D0, 0x1F1AD25C, 0xA8159ECA, 0x24F4349D,
    0x6126052D, 0xC329A589, 0x6A57B7B7, 0x430BDBC1, 0x1CB0EF17, 0x4E452D39,
    0x799FB591, 0x1C6ED1BC, 0xCECE2B3B, 0xDD34ED47, 0xBCAFC5ED, 0xF1F5E2B0,
    0xDE31B6F5, 0x196F581B, 0x8CA0ADE3, 0x85A86A7A, 0x94ED6507, 0xFBA51E1E,
    0xCA65A6A8, 0xDC3814A8, 0xA1EE12EF, 0x783BDBCD, 0x2397346F, 0xD7D7AF9B,
    0x5BCD6416, 0x51A8D3BB, 0xE694C87C, 0xDE372AAD, 0xF0AB494A, 0x64780C14,
    0x0DE6DC07, 0xE505BD77, 0xD28B86D2, 0xB378EB83, 0x12566E1A, 0x9E231ECD,
    0x9B23B05C, 0x8931B116, 0x1BBD1DBB, 0x5756EF7A, 0xD9FBDBEC, 0x4FB3C697,
    0x13CBBDBD, 0x5D8AE8BB, 0x7A57B588, 0xC89F4D93, 0x9CF9581E, 0x3D79172F,
    0xD398AEAD, 0xF4437335, 0x814F3E94, 0x8C16A648, 0xCA4F82D4, 0x64BD3A6A,
    0x96E969D2, 0x2A5EAC54, 0x75780B95, 0x2BF334A0, 0xF1498B47, 0x7DF0592E,
    0x7A26BBC2, 0xD259825A, 0xFA11D560, 0x0DF63B49, 0xA3BB7C8C, 0xF17025B6,
    0x11D51627, 0x49E045E0, 0x83F71607, 0xD0B07E25, 0xE0496B1B, 0xC15C0E9A,
    0x9A3D7AD6, 0x8B20E86C, 0xC9B5936B, 0x016DFB02, 0x4B02DEFB, 0xAACC7F36,
    0x418769BC, 0x08B524DE, 0xE455A707, 0xF8B99FCD, 0x44F9C3EF, 0xEB64BBC0,
    0x0558164A, 0x219FC3D7, 0x7348D509, 0xCD578DE5, 0x3AB45E0F, 0xC167BB8D,
    0x45175931, 0x69CC29D9, 0x52952B4A, 0xF762B55E, 0x2940EA5E, 0x173A8ECD,
    0xF20E9738, 0xB14E93BD, 0xAC1333F8, 0xA4FCAC52, 0x4BFD4EA1, 0x9A60A3F3,
    0xA068721F, 0x95F14F61, 0xCC14A853, 0xBA69DA4F, 0x267F343B, 0x302A5011,
    0x7D242A4B, 0x0913E522, 0x581A69DA, 0x34EA0C42, 0x130B4A8D, 0x525ECBEF,
    0x6BF0DCE0, 0xBC3F5E75, 0xF953CD73, 0x720D2A2D, 0xDEACAD48, 0x3128409D,
    0xD5A245AC, 0xB7C17723, 0x55B24636, 0xACA1BD62, 0xC2E4E628, 0x0582C3EA,
    0xC45C178B, 0x56BA4BD2, 0xCA8AC45E, 0xE22F4AC7, 0x1F4BA5E5, 0x9EBCC2B1,
    0xA228ACA5, 0x4ED6EB41, 0x666E3156, 0x9AEF7CE8, 0xBC179782, 0x6C45C955,
    0xBCC472E2, 0x335BF7B7, 0xC503F8B4, 0x130313C9, 0xA3D929D7, 0x184F33CE,
    0x17ADB8D5, 0xE8F22D9A, 0xED58BC5B, 0x91F3A4D6, 0xA88AE570, 0x891605A7,
    0x4303C0FA, 0x579782CB, 0xD11A605A, 0x78208492, 0x179BD2C7, 0x07280ABC,
    0x7592AB82, 0x27D3B792, 0x22F4EDBD, 0x61514A69, 0xFB0465A1, 0x26BEA4BD,
    0x26E473F5, 0xCFDEF48F, 0x5F79F7EB, 0x7EE9EFD2, 0x14B7EAF7, 0x5DFC35BF,
    0xDEF524C9, 0xA7D36AB4, 0xF35BA716, 0x4349C60B, 0x3395B0C5, 0xD94BC72A,
    0x24BDF027, 0xBF30DD84, 0xACD82E0C, 0x9220CA77, 0xF47A5E2C, 0x97DDD7A5,
    0x4EEC4BF9, 0xE684A989, 0xE19A74FC, 0xBE1B586E, 0xDCEF8FB8, 0xD773B98D,
    0x0A5295DE, 0x2D3A37A6, 0x0192D3B6, 0x31646B4E, 0xAB0ECB09, 0x5A3ADD15,
    0x8C19827D, 0x5B144AA1, 0x12C4F351, 0xAC0D2F05, 0x8B23C827, 0xB0B26C2C,
    0xDF513EC0, 0x7C039D52, 0xA1F9920F, 0x9D29D0BC, 0x484BA1F4, 0x5970D4FA,
    0xFE68D71C, 0x13F5EACC, 0x5EC07D7A, 0x4FD7A81F, 0xAC27E2BC, 0x3E2B80F8,
    0x189F8AD0, 0xD22E36D7, 0x7ABE96B4, 0x689735DF, 0xBDC334E7, 0x0CF35A60,
    0xF49F95C5, 0x17FD0812, 0x84BFF008, 0x6917FF12, 0x9C4D589A, 0xD2EA6818,
    0x4E91E9F7, 0x0E550877, 0x7E712810, 0xB2002478, 0x88080134, 0x10002030,
    0xC1094BC1, 0x15084004, 0x14D25722, 0x8E0324A6, 0x1B1A441D, 0x013A9086,
    0x51212150, 0x55230AD1, 0x7C297D55, 0x773CA833, 0x26F71248, 0x443894E6,
    0x38CA4E9D, 0x48514930, 0x45440324, 0x1284927D, 0xA0069612, 0xC9BD0884,
    0x24F7F024, 0x46AA6046, 0x54F007A2, 0x0000DD52,
};

/**
 * PSL represented as a directed acyclic graph
 * There are 9084 labels in 9742 nodes
 */
static const union pnode pnodes[9742] = {
    /* root entry */
    { .label = { 0, 0, 1 } }, { .child = { 2, 1525 } },
    /* entries 2 to 1835 */
    { .label = {    103,  2, 1 } }, { .child = { 1836, 6 } }, /* ac */
    { .label = {    124,  2, 1 } }, { .child = { 1842, 1 } }, /* ad */
    { .label = {     99,  2, 1 } }, { .child = { 1843, 9 } }, /* ae */
    { .label = {  82226,  4, 1 } }, { .child = { 1852, 86 } }, /* aero */
    { .label = {    109,  2, 1 } }, { .child = { 1938, 6 } }, /* af */
    { .label = {   1383,  2, 1 } }, { .child = { 1944, 5 } }, /* ag */
    { .label = {     60,  2, 1 } }, { .child = { 1949, 6 } }, /* ai */
    { .label = {     94,  2, 1 } }, { .child = { 1955, 8 } }, /* al */
    { .label = {     26,  2, 1 } }, { .child = { 1963, 8 } }, /* am */
    { .label = {   1422,  2, 1 } }, { .child = { 1971, 6 } }, /* ao */
    { .label = {   1428,  2, 0 } }, /* aq */
    { .label = {     45,  2, 1 } }, { .child = { 1977, 10 } }, /* ar */
    { .label = {  90210,  4, 1 } }, { .child = { 1989, 6 } }, /* arpa */
    { .label = {    128,  2, 1 } }, { .child = { 1995, 1 } }, /* as */
    { .label = {  11127,  4, 1 } }, { .child = { 1996, 1 } }, /* asia */
    { .label = {    160,  2, 1 } }, { .child = { 1997, 15 } }, /* at */
    { .label = {    117,  2, 1 } }, { .child = { 2031, 18 } }, /* au */
    { .label = {   4090,  2, 1 } }, { .child = { 2071, 1 } }, /* aw */
    { .label = {   1563,  2, 1 } }, { .child = { 2072, 8 } }, /* ax */
    { .label = {    199,  2, 1 } }, { .child = { 2080, 12 } }, /* az */
    { .label = {    118,  2, 1 } }, { .child = { 2092, 7 } }, /* ba */
    { .label = {   6118,  2, 1 } }, { .child = { 2099, 10 } }, /* bb */
    { .label = {  21343,  2, 1 } }, { .child = { 2109, 1 } }, /* bd */
    { .label = {    555,  2, 1 } }, { .child = { 2110, 4 } }, /* be */
    { .label = {     62,  2, 1 } }, { .child = { 2116, 1 } }, /* bf */
    { .label = {   5589,  2, 1 } }, { .child = { 2117, 38 } }, /* bg */
    { .label = {   6972,  2, 1 } }, { .child = { 2155, 5 } }, /* bh */
    { .label = {    245,  2, 1 } }, { .child = { 2160, 5 } }, /* bi */
    { .label = {   3641,  3, 1 } }, { .child = { 2165, 14 } }, /* biz */
    { .label = {  17893,  2, 1 } }, { .child = { 2179, 4 } }, /* bj */
    { .label = {   1058,  2, 1 } }, { .child = { 2183, 5 } }, /* bm */
    { .label = {    716,  2, 1 } }, { .child = { 2188, 6 } }, /* bn */
    { .label = {   2883,  2, 1 } }, { .child = { 2194, 41 } }, /* bo */
    { .label = {    294,  2, 1 } }, { .child = { 2235, 129 } }, /* br */
    { .label = {    693,  2, 1 } }, { .child = { 2424, 6 } }, /* bs */
    { .label = {   4002,  2, 1 } }, { .child = { 2430, 5 } }, /* bt */
    { .label = {   1108,  2, 0 } }, /* bv */
    { .label = {   2526,  2, 1 } }, { .child = { 2435, 2 } }, /* bw */
    { .label = {   2832,  2, 1 } }, { .child = { 2437, 5 } }, /* by */
    { .label = {   9169,  2, 1 } }, { .child = { 2444, 8 } }, /* bz */
    { .label = {    133,  2, 1 } }, { .child = { 2452, 20 } }, /* ca */
    { .label = {    417,  3, 0 } }, /* cat */
    { .label = {    466,  2, 1 } }, { .child = { 2474, 7 } }, /* cc */
    { .label = {   2713,  2, 1 } }, { .child = { 2481, 1 } }, /* cd */
    { .label = {  23246,  2, 1 } }, { .child = { 2482, 1 } }, /* cf */
    { .label = {   2419,  2, 0 } }, /* cg */
    { .label = {    190,  2, 1 } }, { .child = { 2483, 9 } }, /* ch */
    { .label = {    471,  2, 1 } }, { .child = { 2492, 17 } }, /* ci */
    { .label = {     19,  2, 1 } }, { .child = { 2509, 2 } }, /* ck */
    { .label = {   2620,  2, 1 } }, { .child = { 2513, 7 } }, /* cl */
    { .label = {   8805,  2, 1 } }, { .child = { 2520, 4 } }, /* cm */
    { .label = {   2854,  2, 1 } }, { .child = { 2524, 45 } }, /* cn */
    { .label = {     42,  2, 1 } }, { .child = { 2585, 22 } }, /* co */
    { .label = {    106,  3, 1 } }, { .child = { 2611, 328 } }, /* com */
    { .label = {  53152,  4, 0 } }, /* coop */
    { .label = {   1284,  2, 1 } }, { .child = { 3135, 7 } }, /* cr */
    { .label = {   3660,  2, 1 } }, { .child = { 3142, 6 } }, /* cu */
    { .label = {   4009,  2, 1 } }, { .child = { 3148, 1 } }, /* cv */
    { .label = {   1444,  2, 1 } }, { .child = { 3149, 4 } }, /* cw */
    { .label = {   7229,  2, 1 } }, { .child = { 3153, 3 } }, /* cx */
    { .label = {    674,  2, 1 } }, { .child = { 3156, 13 } }, /* cy */
    { .label = {   5677,  2, 1 } }, { .child = { 3171, 6 } }, /* cz */
    { .label = {    243,  2, 1 } }, { .child = { 3185, 63 } }, /* de */
    { .label = {   7118,  2, 0 } }, /* dj */
    { .label = {   1421,  2, 1 } }, { .child = { 3259, 6 } }, /* dk */
    { .label = {   2224,  2, 1 } }, { .child = { 3265, 5 } }, /* dm */
    { .label = {    116,  2, 1 } }, { .child = { 3270, 10 } }, /* do */
    { .label = {    517,  2, 1 } }, { .child = { 3280, 8 } }, /* dz */
    { .label = {    102,  2, 1 } }, { .child = { 3288, 13 } }, /* ec */
    { .label = {  44279,  3, 1 } }, { .child = { 3301, 1 } }, /* edu */
    { .label = {     98,  2, 1 } }, { .child = { 3304, 10 } }, /* ee */
    { .label = {   2038,  2, 1 } }, { .child = { 3316, 9 } }, /* eg */
    { .label = {     44,  2, 1 } }, { .child = { 3327, 1 } }, /* er */
    { .label = {    141,  2, 1 } }, { .child = { 3328, 5 } }, /* es */
    { .label = {    421,  2, 1 } }, { .child = { 3335, 8 } }, /* et */
    { .label = {   2994,  2, 1 } }, { .child = { 3343, 7 } }, /* eu */
    { .label = {    391,  2, 1 } }, { .child = { 3352, 5 } }, /* fi */
    { .label = {   4709,  2, 1 } }, { .child = { 3357, 10 } }, /* fj */
    { .label = {   2776,  2, 1 } }, { .child = { 3367, 1 } }, /* fk */
    { .label = {   3284,  2, 0 } }, /* fm */
    { .label = {   5781,  2, 0 } }, /* fo */
    { .label = {    298,  2, 1 } }, { .child = { 3368, 29 } }, /* fr */
    { .label = {    182,  2, 0 } }, /* ga */
    { .label = {   1450,  2, 0 } }, /* gb */
    { .label = {    567,  2, 1 } }, { .child = { 3397, 1 } }, /* gd */
    { .label = {    267,  2, 1 } }, { .child = { 3398, 8 } }, /* ge */
    { .label = {   4106,  2, 0 } }, /* gf */
    { .label = {   2677,  2, 1 } }, { .child = { 3406, 6 } }, /* gg */
    { .label = {    154,  2, 1 } }, { .child = { 3414, 5 } }, /* gh */
    { .label = {    217,  2, 1 } }, { .child = { 3419, 6 } }, /* gi */
    { .label = {   2424,  2, 1 } }, { .child = { 3425, 8 } }, /* gl */
    { .label = {   2441,  2, 0 } }, /* gm */
    { .label = {   1188,  2, 1 } }, { .child = { 3433, 6 } }, /* gn */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   7797,  2, 1 } }, { .child = { 3439, 7 } }, /* gp */
    { .label = {  12412,  2, 0 } }, /* gq */
    { .label = {   4597,  2, 1 } }, { .child = { 3446, 7 } }, /* gr */
    { .label = {    337,  2, 0 } }, /* gs */
    { .label = {   1874,  2, 1 } }, { .child = { 3453, 11 } }, /* gt */
    { .label = {   3007,  2, 1 } }, { .child = { 3464, 8 } }, /* gu */
    { .label = {   4801,  2, 0 } }, /* gw */
    { .label = {   5569,  2, 1 } }, { .child = { 3472, 8 } }, /* gy */
    { .label = {   4289,  2, 1 } }, { .child = { 3480, 25 } }, /* hk */
    { .label = {   7165,  2, 0 } }, /* hm */
    { .label = {   1496,  2, 1 } }, { .child = { 3505, 8 } }, /* hn */
    { .label = {   1659,  2, 1 } }, { .child = { 3513, 6 } }, /* hr */
    { .label = {   1382,  2, 1 } }, { .child = { 3519, 17 } }, /* ht */
    { .label = {   1370,  2, 1 } }, { .child = { 3536, 32 } }, /* hu */
    { .label = {    143,  2, 1 } }, { .child = { 3568, 12 } }, /* id */
    { .label = {    119,  2, 1 } }, { .child = { 3582, 3 } }, /* ie */
    { .label = {    556,  2, 1 } }, { .child = { 3585, 8 } }, /* il */
    { .label = {   3011,  2, 1 } }, { .child = { 3595, 9 } }, /* im */
    { .label = {    100,  2, 1 } }, { .child = { 3607, 15 } }, /* in */
    { .label = {  99429,  4, 1 } }, { .child = { 3622, 21 } }, /* info */
    { .label = {   4321,  3, 1 } }, { .child = { 3643, 1 } }, /* int */
    { .label = {     63,  2, 1 } }, { .child = { 3644, 54 } }, /* io */
    { .label = {   3339,  2, 1 } }, { .child = { 3744, 6 } }, /* iq */
    { .label = {    200,  2, 1 } }, { .child = { 3750, 9 } }, /* ir */
    { .label = {    260,  2, 1 } }, { .child = { 3759, 8 } }, /* is */
    { .label = {    151,  2, 1 } }, { .child = { 3767, 411 } }, /* it */
    { .label = {   3761,  2, 1 } }, { .child = { 4178, 3 } }, /* je */
    { .label = {  20253,  2, 1 } }, { .child = { 4181, 1 } }, /* jm */
    { .label = {   1535,  2, 1 } }, { .child = { 4182, 8 } }, /* jo */
    { .label = { 169247,  4, 0 } }, /* jobs */
    { .label = {  12841,  2, 1 } }, { .child = { 4190, 112 } }, /* jp */
    { .label = {    136,  2, 1 } }, { .child = { 6062, 10 } }, /* ke */
    { .label = {   9092,  2, 1 } }, { .child = { 6074, 12 } }, /* kg */
    { .label = {   8806,  2, 1 } }, { .child = { 6086, 1 } }, /* kh */
    { .label = {     58,  2, 1 } }, { .child = { 6087, 7 } }, /* ki */
    { .label = {     24,  2, 1 } }, { .child = { 6094, 17 } }, /* km */
    { .label = {    225,  2, 1 } }, { .child = { 6111, 4 } }, /* kn */
    { .label = {  13846,  2, 1 } }, { .child = { 6115, 6 } }, /* kp */
    { .label = {     43,  2, 1 } }, { .child = { 6121, 30 } }, /* kr */
    { .label = {   4088,  2, 1 } }, { .child = { 6151, 7 } }, /* kw */
    { .label = {    494,  2, 1 } }, { .child = { 6158, 5 } }, /* ky */
    { .label = {   2855,  2, 1 } }, { .child = { 6163, 7 } }, /* kz */
    { .label = {    557,  2, 1 } }, { .child = { 6170, 11 } }, /* la */
    { .label = {    688,  2, 1 } }, { .child = { 6181, 5 } }, /* lb */
    { .label = {    101,  2, 1 } }, { .child = { 6186, 8 } }, /* lc */
    { .label = {   2828,  2, 1 } }, { .child = { 6194, 4 } }, /* li */
    { .label = {   2820,  2, 1 } }, { .child = { 6198, 15 } }, /* lk */
    { .label = {   1372,  2, 1 } }, { .child = { 6213, 5 } }, /* lr */
    { .label = {    140,  2, 1 } }, { .child = { 6218, 10 } }, /* ls */
    { .label = {    695,  2, 1 } }, { .child = { 6228, 3 } }, /* lt */
    { .label = {   2993,  2, 1 } }, { .child = { 6231, 2 } }, /* lu */
    { .label = {   3767,  2, 1 } }, { .child = { 6233, 10 } }, /* lv */
    { .label = {   7783,  2, 1 } }, { .child = { 6243, 9 } }, /* ly */
    { .label = {    194,  2, 1 } }, { .child = { 6252, 6 } }, /* ma */
    { .label = {   4288,  2, 1 } }, { .child = { 6258, 2 } }, /* mc */
    { .label = {   6836,  2, 1 } }, { .child = { 6260, 5 } }, /* md */
    { .label = {    591,  2, 1 } }, { .child = { 6265, 42 } }, /* me */
    { .label = {   1381,  2, 1 } }, { .child = { 6309, 9 } }, /* mg */
    { .label = {   8810,  2, 0 } }, /* mh */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    749,  2, 1 } }, { .child = { 6318, 9 } }, /* mk */
    { .label = {    242,  2, 1 } }, { .child = { 6327, 7 } }, /* ml */
    { .label = {    394,  2, 1 } }, { .child = { 6334, 1 } }, /* mm */
    { .label = {    571,  2, 1 } }, { .child = { 6335, 5 } }, /* mn */
    { .label = {   3360,  2, 1 } }, { .child = { 6340, 5 } }, /* mo */
    { .label = {  10299,  4, 1 } }, { .child = { 6345, 2 } }, /* mobi */
    { .label = {   6840,  2, 0 } }, /* mp */
    { .label = {   9954,  2, 0 } }, /* mq */
    { .label = {    205,  2, 1 } }, { .child = { 6347, 2 } }, /* mr */
    { .label = {    126,  2, 1 } }, { .child = { 6349, 6 } }, /* ms */
    { .label = {    158,  2, 1 } }, { .child = { 6355, 4 } }, /* mt */
    { .label = {    115,  2, 1 } }, { .child = { 6361, 7 } }, /* mu */
    { .label = {   4540,  6, 1 } }, { .child = { 6368, 546 } }, /* museum */
    { .label = {   9983,  2, 1 } }, { .child = { 6914, 14 } }, /* mv */
    { .label = {  11687,  2, 1 } }, { .child = { 6928, 11 } }, /* mw */
    { .label = {   2900,  2, 1 } }, { .child = { 6939, 7 } }, /* mx */
    { .label = {   1064,  2, 1 } }, { .child = { 6946, 8 } }, /* my */
    { .label = {   3991,  2, 1 } }, { .child = { 6954, 8 } }, /* mz */
    { .label = {     87,  2, 1 } }, { .child = { 6962, 17 } }, /* na */
    { .label = {  30106,  4, 1 } }, { .child = { 6979, 2 } }, /* name */
    { .label = {    311,  2, 1 } }, { .child = { 6985, 2 } }, /* nc */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {  13820,  3, 1 } }, { .child = { 6987, 122 } }, /* net */
    { .label = {    161,  2, 1 } }, { .child = { 7135, 10 } }, /* nf */
    { .label = {    761,  2, 1 } }, { .child = { 7145, 15 } }, /* ng */
    { .label = {    125,  2, 1 } }, { .child = { 7162, 14 } }, /* ni */
    { .label = {   2989,  2, 1 } }, { .child = { 7176, 9 } }, /* nl */
    { .label = {    188,  2, 1 } }, { .child = { 7187, 726 } }, /* no */
    { .label = {    521,  2, 1 } }, { .child = { 7985, 1 } }, /* np */
    { .label = {   1220,  2, 1 } }, { .child = { 7986, 7 } }, /* nr */
    { .label = {   1501,  2, 1 } }, { .child = { 7993, 6 } }, /* nu */
    { .label = {   3369,  2, 1 } }, { .child = { 7999, 17 } }, /* nz */
    { .label = {    111,  2, 1 } }, { .child = { 8018, 9 } }, /* om */
    { .label = {  61459,  5, 0 } }, /* onion */
    { .label = {    209,  3, 1 } }, { .child = { 8027, 113 } }, /* org */
    { .label = {    490,  2, 1 } }, { .child = { 8218, 11 } }, /* pa */
    { .label = {   5481,  2, 1 } }, { .child = { 8229, 9 } }, /* pe */
    { .label = {  23245,  2, 1 } }, { .child = { 8238, 3 } }, /* pf */
    { .label = {   4707,  2, 1 } }, { .child = { 8241, 1 } }, /* pg */
    { .label = {    189,  2, 1 } }, { .child = { 8242, 8 } }, /* ph */
    { .label = {  12141,  2, 1 } }, { .child = { 8250, 14 } }, /* pk */
    { .label = {   2619,  2, 1 } }, { .child = { 8264, 172 } }, /* pl */
    { .label = {   8804,  2, 1 } }, { .child = { 8484, 1 } }, /* pm */
    { .label = {   2853,  2, 1 } }, { .child = { 8485, 5 } }, /* pn */
    { .label = {    324,  4, 0 } }, /* post */
    { .label = {   1283,  2, 1 } }, { .child = { 8490, 13 } }, /* pr */
    { .label = {  23387,  3, 1 } }, { .child = { 8503, 14 } }, /* pro */
    { .label = {    643,  2, 1 } }, { .child = { 8519, 7 } }, /* ps */
    { .label = {   1981,  2, 1 } }, { .child = { 8526, 10 } }, /* pt */
    { .label = {   1443,  2, 1 } }, { .child = { 8536, 9 } }, /* pw */
    { .label = {  10477,  2, 1 } }, { .child = { 8545, 7 } }, /* py */
    { .label = {    265,  2, 1 } }, { .child = { 8552, 10 } }, /* qa */
    { .label = {     55,  2, 1 } }, { .child = { 8562, 4 } }, /* re */
    { .label = {    524,  2, 1 } }, { .child = { 8566, 14 } }, /* ro */
    { .label = {     48,  2, 1 } }, { .child = { 8580, 10 } }, /* rs */
    { .label = {    204,  2, 1 } }, { .child = { 8590, 32 } }, /* ru */
    { .label = {     12,  2, 1 } }, { .child = { 8637, 7 } }, /* rw */
    { .label = {    355,  2, 1 } }, { .child = { 8644, 8 } }, /* sa */
    { .label = {    424,  2, 1 } }, { .child = { 8652, 5 } }, /* sb */
    { .label = {    601,  2, 1 } }, { .child = { 8657, 5 } }, /* sc */
    { .label = {    253,  2, 1 } }, { .child = { 8662, 8 } }, /* sd */
    { .label = {    629,  2, 1 } }, { .child = { 8670, 42 } }, /* se */
    { .label = {     13,  2, 1 } }, { .child = { 8712, 7 } }, /* sg */
    { .label = {    682,  2, 1 } }, { .child = { 8719, 10 } }, /* sh */
    { .label = {    699,  2, 1 } }, { .child = { 8731, 2 } }, /* si */
    { .label = {   3757,  2, 0 } }, /* sj */
    { .label = {    312,  2, 1 } }, { .child = { 8733, 2 } }, /* sk */
    { .label = {     88,  2, 1 } }, { .child = { 8735, 5 } }, /* sl */
    { .label = {   1519,  2, 0 } }, /* sm */
    { .label = {   1414,  2, 1 } }, { .child = { 8740, 8 } }, /* sn */
    { .label = {    131,  2, 1 } }, { .child = { 8748, 7 } }, /* so */
    { .label = {    153,  2, 0 } }, /* sr */
    { .label = {    301,  2, 1 } }, { .child = { 8755, 6 } }, /* ss */
    { .label = {    179,  2, 1 } }, { .child = { 8761, 14 } }, /* st */
    { .label = {   1537,  2, 1 } }, { .child = { 8775, 53 } }, /* su */
    { .label = {    743,  2, 1 } }, { .child = { 8828, 5 } }, /* sv */
    { .label = {    441,  2, 1 } }, { .child = { 8833, 2 } }, /* sx */
    { .label = {    305,  2, 1 } }, { .child = { 8835, 6 } }, /* sy */
    { .label = {   1221,  2, 1 } }, { .child = { 8841, 3 } }, /* sz */
    { .label = {     53,  2, 1 } }, { .child = { 8844, 3 } }, /* tc */
    { .label = {    568,  2, 1 } }, { .child = { 8847, 1 } }, /* td */
    { .label = {     89,  3, 0 } }, /* tel */
    { .label = {   4107,  2, 0 } }, /* tf */
    { .label = {   2678,  2, 0 } }, /* tg */
    { .label = {    155,  2, 1 } }, { .child = { 8848, 9 } }, /* th */
    { .label = {   2411,  2, 1 } }, { .child = { 8857, 16 } }, /* tj */
    { .label = {    132,  2, 0 } }, /* tk */
    { .label = {   2425,  2, 1 } }, { .child = { 8873, 1 } }, /* tl */
    { .label = {   2442,  2, 1 } }, { .child = { 8874, 8 } }, /* tm */
    { .label = {    700,  2, 1 } }, { .child = { 8882, 20 } }, /* tn */
    { .label = {   1538,  2, 1 } }, { .child = { 8902, 11 } }, /* to */
    { .label = {    163,  2, 1 } }, { .child = { 8915, 22 } }, /* tr */
    { .label = {    302,  2, 1 } }, { .child = { 8941, 17 } }, /* tt */
    { .label = {   1222,  2, 1 } }, { .child = { 8958, 4 } }, /* tv */
    { .label = {   4802,  2, 1 } }, { .child = { 8962, 16 } }, /* tw */
    { .label = {   1658,  2, 1 } }, { .child = { 8980, 12 } }, /* tz */
    { .label = {   1971,  2, 1 } }, { .child = { 8992, 83 } }, /* ua */
    { .label = {   2528,  2, 1 } }, { .child = { 9075, 10 } }, /* ug */
    { .label = {   2514,  2, 1 } }, { .child = { 9085, 14 } }, /* uk */
    { .label = {    296,  2, 1 } }, { .child = { 9120, 71 } }, /* us */
    { .label = {    223,  2, 1 } }, { .child = { 9417, 7 } }, /* uy */
    { .label = {   3282,  2, 1 } }, { .child = { 9426, 4 } }, /* uz */
    { .label = {     54,  2, 0 } }, /* va */
    { .label = {   3371,  2, 1 } }, { .child = { 9430, 9 } }, /* vc */
    { .label = {   1367,  2, 1 } }, { .child = { 9441, 17 } }, /* ve */
    { .label = {   3652,  2, 1 } }, { .child = { 9458, 2 } }, /* vg */
    { .label = {    569,  2, 1 } }, { .child = { 9460, 5 } }, /* vi */
    { .label = {  11308,  2, 1 } }, { .child = { 9465, 13 } }, /* vn */
    { .label = {   3772,  2, 1 } }, { .child = { 9478, 7 } }, /* vu */
    { .label = {   4105,  2, 0 } }, /* wf */
    { .label = {    336,  2, 1 } }, { .child = { 9485, 9 } }, /* ws */
    { .label = {    250,  2, 0 } }, /* yt */
    { .label = {  29509, 14, 0 } }, /* xn--mgbaam7a8h */
    { .label = {  76383, 10, 0 } }, /* xn--y9a3aq */
    { .label = {  29582, 14, 0 } }, /* xn--54b7fta0cc */
    { .label = { 114850,  8, 0 } }, /* xn--90ae */
    { .label = {  94394,  9, 0 } }, /* xn--90ais */
    { .label = {  76441, 10, 0 } }, /* xn--fiqs8s */
    { .label = {  76496, 10, 0 } }, /* xn--fiqz9s */
    { .label = {  23047, 15, 0 } }, /* xn--lgbbat1ad8j */
    { .label = {  76555, 10, 0 } }, /* xn--wgbh1c */
    { .label = {  94443,  9, 0 } }, /* xn--e1a4c */
    { .label = {  94492,  9, 0 } }, /* xn--qxa6a */
    { .label = {  12165, 17, 0 } }, /* xn--mgbah1a3hjkrd */
    { .label = { 114895,  8, 0 } }, /* xn--node */
    { .label = { 114932,  8, 0 } }, /* xn--qxam */
    { .label = {  60131, 11, 1 } }, { .child = { 9496, 6 } }, /* xn--j6w193g */
    { .label = {  60204, 11, 0 } }, /* xn--2scrj9c */
    { .label = {  60267, 11, 0 } }, /* xn--3hcrj9c */
    { .label = {  48800, 12, 0 } }, /* xn--45br5cyl */
    { .label = {  29666, 14, 0 } }, /* xn--h2breg3eve */
    { .label = {  38131, 13, 0 } }, /* xn--h2brj9c8c */
    { .label = {  48873, 12, 0 } }, /* xn--mgbgu82a */
    { .label = {  29740, 14, 0 } }, /* xn--rvc1e0am3e */
    { .label = {  38131, 11, 0 } }, /* xn--h2brj9c */
    { .label = {  29815, 11, 0 } }, /* xn--mgbbh1a */
    { .label = {  29815, 14, 0 } }, /* xn--mgbbh1a71e */
    { .label = {  38210, 13, 0 } }, /* xn--fpcrj9c3d */
    { .label = {  60331, 11, 0 } }, /* xn--gecrj9c */
    { .label = {  60391, 11, 0 } }, /* xn--s9brj9c */
    { .label = {  60457, 11, 0 } }, /* xn--45brj9c */
    { .label = {  12254, 17, 0 } }, /* xn--xkc2dl3a5ee0h */
    { .label = {  18445, 15, 0 } }, /* xn--mgba3a4f16a */
    { .label = {  25440, 14, 0 } }, /* xn--mgba3a4fra */
    { .label = {  60527, 11, 0 } }, /* xn--mgbtx2b */
    { .label = {  29894, 14, 0 } }, /* xn--mgbayh7gpa */
    { .label = {  48939, 12, 0 } }, /* xn--3e0b707e */
    { .label = {  60587, 11, 0 } }, /* xn--80ao21a */
    { .label = {  38286, 13, 0 } }, /* xn--fzc2c9e2c */
    { .label = {  16523, 16, 0 } }, /* xn--xkc2al3hye2a */
    { .label = {  23128, 15, 0 } }, /* xn--mgbc0a9azcg */
    { .label = {  94541,  9, 0 } }, /* xn--d1alf */
    { .label = {  94588,  9, 0 } }, /* xn--l1acc */
    { .label = {  60650, 11, 0 } }, /* xn--mix891f */
    { .label = {  60718, 11, 0 } }, /* xn--mix082f */
    { .label = {  29967, 14, 0 } }, /* xn--mgbx4cd0ab */
    { .label = {  49015, 12, 0 } }, /* xn--mgb9awbf */
    { .label = {  12349, 17, 0 } }, /* xn--mgbai9azgqp6j */
    { .label = {   9839, 18, 0 } }, /* xn--mgbai9a5eva00b */
    { .label = {  38364, 13, 0 } }, /* xn--ygbi2ammx */
    { .label = {  76610, 10, 1 } }, { .child = { 9502, 6 } }, /* xn--90a3ac */
    { .label = { 115059,  8, 0 } }, /* xn--p1ai */
    { .label = {  76667, 10, 0 } }, /* xn--wgbl6a */
    { .label = {  12447, 17, 0 } }, /* xn--mgberp4a5d4ar */
    { .label = {   7628, 19, 0 } }, /* xn--mgberp4a5d4a87g */
    { .label = {   7739, 19, 0 } }, /* xn--mgbqly7c0a67fbc */
    { .label = {  16609, 16, 0 } }, /* xn--mgbqly7cvafr */
    { .label = {  49082, 12, 0 } }, /* xn--mgbpl2fh */
    { .label = {  38432, 13, 0 } }, /* xn--yfro4i67o */
    { .label = {   2600, 22, 0 } }, /* xn--clchc0ea0b2g2a9gcd */
    { .label = {  49148, 12, 0 } }, /* xn--ogbpf8fl */
    { .label = {  49215, 12, 0 } }, /* xn--mgbtf8fl */
    { .label = {  76721, 10, 1 } }, { .child = { 9508, 6 } }, /* xn--o3cw4h */
    { .label = {  60844, 11, 0 } }, /* xn--pgbs0dh */
    { .label = {  60903, 11, 0 } }, /* xn--kpry57d */
    { .label = {  60967, 11, 0 } }, /* xn--kprw13d */
    { .label = {  61029, 11, 0 } }, /* xn--nnx388a */
    { .label = {  94779,  9, 0 } }, /* xn--j1amh */
    { .label = {  49350, 12, 0 } }, /* xn--mgb2ddes */
    { .label = { 172857,  3, 0 } }, /* xxx */
    { .label = {     38,  2, 1 } }, { .child = { 9514, 1 } }, /* ye */
    { .label = {   2924,  2, 1 } }, { .child = { 9515, 18 } }, /* za */
    { .label = {  21446,  2, 1 } }, { .child = { 9535, 11 } }, /* zm */
    { .label = {  22749,  2, 1 } }, { .child = { 9546, 5 } }, /* zw */
    { .label = {   3681,  3, 0 } }, /* aaa */
    { .label = {   7662,  4, 0 } }, /* aarp */
    { .label = { 154025,  6, 0 } }, /* abarth */
    { .label = {   6115,  3, 0 } }, /* abb */
    { .label = { 154050,  6, 0 } }, /* abbott */
    { .label = { 154077,  6, 0 } }, /* abbvie */
    { .label = {   2536,  3, 0 } }, /* abc */
    { .label = {   4047,  4, 0 } }, /* able */
    { .label = { 134208,  7, 0 } }, /* abogado */
    { .label = { 115100,  8, 0 } }, /* abudhabi */
    { .label = { 128613,  7, 1 } }, { .child = { 9551, 1 } }, /* academy */
    { .label = {  94827,  9, 0 } }, /* accenture */
    { .label = {  17427, 10, 0 } }, /* accountant */
    { .label = {  61092, 11, 0 } }, /* accountants */
    { .label = {    103,  3, 0 } }, /* aco */
    { .label = {  13668,  5, 0 } }, /* actor */
    { .label = {  26952,  4, 0 } }, /* adac */
    { .label = {  25406,  3, 0 } }, /* ads */
    { .label = { 159230,  5, 0 } }, /* adult */
    { .label = {  27615,  3, 0 } }, /* aeg */
    { .label = { 165552,  5, 0 } }, /* aetna */
    { .label = {  30045, 14, 0 } }, /* afamilycompany */
    { .label = {  19628,  3, 0 } }, /* afl */
    { .label = {  72975,  6, 0 } }, /* africa */
    { .label = { 134238,  7, 0 } }, /* agakhan */
    { .label = { 154106,  6, 0 } }, /* agency */
    { .label = {    677,  3, 0 } }, /* aig */
    { .label = {  43486,  4, 0 } }, /* aigo */
    { .label = { 154133,  6, 0 } }, /* airbus */
    { .label = { 115137,  8, 0 } }, /* airforce */
    { .label = { 154159,  6, 0 } }, /* airtel */
    { .label = {  82104,  4, 0 } }, /* akdn */
    { .label = {  94865,  9, 0 } }, /* alfaromeo */
    { .label = { 134266,  7, 0 } }, /* alibaba */
    { .label = { 154183,  6, 0 } }, /* alipay */
    { .label = {  94903,  9, 0 } }, /* allfinanz */
    { .label = { 115171,  8, 0 } }, /* allstate */
    { .label = { 170539,  4, 0 } }, /* ally */
    { .label = { 154210,  6, 0 } }, /* alsace */
    { .label = { 154234,  6, 0 } }, /* alstom */
    { .label = {  96595,  6, 0 } }, /* amazon */
    { .label = {  23300, 15, 0 } }, /* americanexpress */
    { .label = {  30110, 14, 0 } }, /* americanfamily */
    { .label = { 134485,  4, 0 } }, /* amex */
    { .label = { 165570,  5, 0 } }, /* amfam */
    { .label = { 165592,  5, 0 } }, /* amica */
    { .label = {  88844,  9, 0 } }, /* amsterdam */
    { .label = {  94944,  9, 0 } }, /* analytics */
    { .label = { 134296,  7, 0 } }, /* android */
    { .label = { 154259,  6, 0 } }, /* anquan */
    { .label = {   3438,  3, 0 } }, /* anz */
    { .label = {   2310,  3, 0 } }, /* aol */
    { .label = {  76778, 10, 0 } }, /* apartments */
    { .label = {   6842,  3, 1 } }, { .child = { 9552, 8 } }, /* app */
    { .label = { 165612,  5, 0 } }, /* apple */
    { .label = {  94982,  9, 0 } }, /* aquarelle */
    { .label = {  21378,  4, 0 } }, /* arab */
    { .label = { 154286,  6, 0 } }, /* aramco */
    { .label = {  24802,  5, 0 } }, /* archi */
    { .label = {  36460,  4, 0 } }, /* army */
    { .label = {   7959,  3, 0 } }, /* art */
    { .label = {  17621,  4, 0 } }, /* arte */
    { .label = {   2553,  4, 0 } }, /* asda */
    { .label = {  76819, 10, 0 } }, /* associates */
    { .label = { 134325,  7, 0 } }, /* athleta */
    { .label = { 115203,  8, 0 } }, /* attorney */
    { .label = { 134353,  7, 0 } }, /* auction */
    { .label = { 134382,  4, 0 } }, /* audi */
    { .label = { 134382,  7, 0 } }, /* audible */
    { .label = { 165636,  5, 0 } }, /* audio */
    { .label = { 134414,  7, 0 } }, /* auspost */
    { .label = { 142053,  6, 0 } }, /* author */
    { .label = {  72573,  4, 0 } }, /* auto */
    { .label = { 165657,  5, 0 } }, /* autos */
    { .label = { 134444,  7, 0 } }, /* avianca */
    { .label = {  18262,  3, 0 } }, /* aws */
    { .label = {   7563,  3, 0 } }, /* axa */
    { .label = {  32458,  5, 0 } }, /* azure */
    { .label = { 170558,  4, 0 } }, /* baby */
    { .label = { 165677,  5, 0 } }, /* baidu */
    { .label = { 134472,  7, 0 } }, /* banamex */
    { .label = {  30171, 14, 0 } }, /* bananarepublic */
    { .label = {   2996,  4, 0 } }, /* band */
    { .label = {  96144,  4, 0 } }, /* bank */
    { .label = {   3030,  3, 0 } }, /* bar */
    { .label = {  89105,  9, 0 } }, /* barcelona */
    { .label = {  61137, 11, 0 } }, /* barclaycard */
    { .label = { 115236,  8, 0 } }, /* barclays */
    { .label = { 115272,  8, 0 } }, /* barefoot */
    { .label = { 115307,  8, 0 } }, /* bargains */
    { .label = { 109253,  8, 0 } }, /* baseball */
    { .label = {  76858, 10, 0 } }, /* basketball */
    { .label = { 134503,  7, 0 } }, /* bauhaus */
    { .label = { 154310,  6, 0 } }, /* bayern */
    { .label = { 154184,  3, 0 } }, /* bbc */
    { .label = {  51296,  3, 0 } }, /* bbt */
    { .label = { 170579,  4, 0 } }, /* bbva */
    { .label = { 172875,  3, 0 } }, /* bcg */
    { .label = {  24720,  3, 0 } }, /* bcn */
    { .label = { 165700,  5, 0 } }, /* beats */
    { .label = { 154337,  6, 0 } }, /* beauty */
    { .label = {  82219,  4, 0 } }, /* beer */
    { .label = { 134534,  7, 0 } }, /* bentley */
    { .label = {  80725,  6, 0 } }, /* berlin */
    { .label = {   4945,  4, 0 } }, /* best */
    { .label = { 134567,  7, 0 } }, /* bestbuy */
    { .label = {   9513,  3, 0 } }, /* bet */
    { .label = { 154365,  6, 0 } }, /* bharti */
    { .label = { 162697,  5, 0 } }, /* bible */
    { .label = {  19662,  3, 0 } }, /* bid */
    { .label = { 170600,  4, 0 } }, /* bike */
    { .label = {  55375,  4, 0 } }, /* bing */
    { .label = { 165721,  5, 0 } }, /* bingo */
    { .label = {  44643,  3, 0 } }, /* bio */
    { .label = {  50768,  5, 0 } }, /* black */
    { .label = {  61186, 11, 0 } }, /* blackfriday */
    { .label = {  61238, 11, 0 } }, /* blockbuster */
    { .label = {  17228,  4, 0 } }, /* blog */
    { .label = {  95023,  9, 0 } }, /* bloomberg */
    { .label = { 170619,  4, 0 } }, /* blue */
    { .label = { 105952,  3, 0 } }, /* bms */
    { .label = { 172891,  3, 0 } }, /* bmw */
    { .label = {  76903, 10, 0 } }, /* bnpparibas */
    { .label = { 165744,  5, 0 } }, /* boats */
    { .label = {  76949, 10, 0 } }, /* boehringer */
    { .label = { 170639,  4, 0 } }, /* bofa */
    { .label = {  15401,  3, 0 } }, /* bom */
    { .label = { 170658,  4, 0 } }, /* bond */
    { .label = {  24461,  3, 0 } }, /* boo */
    { .label = {  24461,  4, 0 } }, /* book */
    { .label = { 134602,  7, 0 } }, /* booking */
    { .label = { 165765,  5, 0 } }, /* bosch */
    { .label = { 154391,  6, 0 } }, /* bostik */
    { .label = { 149689,  6, 0 } }, /* boston */
    { .label = {  20040,  3, 0 } }, /* bot */
    { .label = { 115340,  8, 0 } }, /* boutique */
    { .label = {  18325,  3, 0 } }, /* box */
    { .label = { 115380,  8, 0 } }, /* bradesco */
    { .label = {  61290, 11, 0 } }, /* bridgestone */
    { .label = { 115415,  8, 0 } }, /* broadway */
    { .label = { 142078,  6, 0 } }, /* broker */
    { .label = { 134634,  7, 0 } }, /* brother */
    { .label = { 109366,  8, 0 } }, /* brussels */
    { .label = { 115452,  8, 0 } }, /* budapest */
    { .label = { 134665,  7, 0 } }, /* bugatti */
    { .label = { 109402,  5, 0 } }, /* build */
    { .label = { 115489,  8, 0 } }, /* builders */
    { .label = { 115526,  8, 1 } }, { .child = { 9562, 1 } }, /* business */
    { .label = {  79445,  3, 0 } }, /* buy */
    { .label = { 170677,  4, 0 } }, /* buzz */
    { .label = {   9169,  3, 0 } }, /* bzh */
    { .label = {  66896,  3, 0 } }, /* cab */
    { .label = {  61848,  4, 0 } }, /* cafe */
    { .label = {   4017,  3, 0 } }, /* cal */
    { .label = { 170702,  4, 0 } }, /* call */
    { .label = {  61338, 11, 0 } }, /* calvinklein */
    { .label = {    444,  3, 0 } }, /* cam */
    { .label = {  18070,  6, 0 } }, /* camera */
    { .label = {  19248,  4, 0 } }, /* camp */
    { .label = {  30233, 14, 0 } }, /* cancerresearch */
    { .label = { 165789,  5, 0 } }, /* canon */
    { .label = { 115561,  8, 0 } }, /* capetown */
    { .label = {  76993,  7, 0 } }, /* capital */
    { .label = {  76993, 10, 0 } }, /* capitalone */
    { .label = {    853,  3, 0 } }, /* car */
    { .label = { 134696,  7, 0 } }, /* caravan */
    { .label = { 165809,  5, 0 } }, /* cards */
    { .label = {  13574,  4, 0 } }, /* care */
    { .label = { 134724,  6, 0 } }, /* career */
    { .label = { 134724,  7, 0 } }, /* careers */
    { .label = {  40564,  4, 0 } }, /* cars */
    { .label = {  26906,  4, 1 } }, { .child = { 9563, 1 } }, /* casa */
    { .label = { 122162,  4, 0 } }, /* case */
    { .label = { 154418,  6, 0 } }, /* caseih */
    { .label = {  73462,  4, 0 } }, /* cash */
    { .label = { 142598,  6, 0 } }, /* casino */
    { .label = {  99530,  8, 0 } }, /* catering */
    { .label = {  99702,  8, 0 } }, /* catholic */
    { .label = {   3809,  3, 0 } }, /* cba */
    { .label = {  12862,  3, 0 } }, /* cbn */
    { .label = { 107939,  4, 0 } }, /* cbre */
    { .label = {  30303,  3, 0 } }, /* cbs */
    { .label = {  10083,  3, 0 } }, /* ceb */
    { .label = {  27120,  6, 0 } }, /* center */
    { .label = {  51963,  3, 0 } }, /* ceo */
    { .label = { 129668,  4, 0 } }, /* cern */
    { .label = {  61575,  3, 0 } }, /* cfa */
    { .label = { 115293,  3, 0 } }, /* cfd */
    { .label = { 154443,  6, 0 } }, /* chanel */
    { .label = {  30322,  7, 0 } }, /* channel */
    { .label = { 134752,  7, 0 } }, /* charity */
    { .label = { 137427,  5, 0 } }, /* chase */
    { .label = {  57556,  4, 0 } }, /* chat */
    { .label = { 165830,  5, 0 } }, /* cheap */
    { .label = { 134783,  7, 0 } }, /* chintai */
    { .label = {  95066,  9, 0 } }, /* christmas */
    { .label = { 154469,  6, 0 } }, /* chrome */
    { .label = { 154496,  6, 0 } }, /* church */
    { .label = { 115597,  8, 0 } }, /* cipriani */
    { .label = { 154525,  6, 0 } }, /* circle */
    { .label = {  45178,  5, 0 } }, /* cisco */
    { .label = { 134812,  7, 0 } }, /* citadel */
    { .label = {  17123,  4, 0 } }, /* citi */
    { .label = { 165853,  5, 0 } }, /* citic */
    { .label = {  99235,  4, 1 } }, { .child = { 9566, 1 } }, /* city */
    { .label = { 115631,  8, 0 } }, /* cityeats */
    { .label = { 154552,  6, 0 } }, /* claims */
    { .label = { 115665,  8, 0 } }, /* cleaning */
    { .label = { 165875,  5, 0 } }, /* click */
    { .label = { 154578,  6, 0 } }, /* clinic */
    { .label = { 115699,  8, 0 } }, /* clinique */
    { .label = { 115738,  8, 0 } }, /* clothing */
    { .label = {  13753,  5, 1 } }, { .child = { 9567, 11 } }, /* cloud */
    { .label = {  99476,  4, 1 } }, { .child = { 9588, 3 } }, /* club */
    { .label = { 134842,  7, 0 } }, /* clubmed */
    { .label = { 165899,  5, 0 } }, /* coach */
    { .label = { 119532,  5, 1 } }, { .child = { 9591, 1 } }, /* codes */
    { .label = { 154605,  6, 0 } }, /* coffee */
    { .label = {  52344,  7, 0 } }, /* college */
    { .label = { 134877,  7, 0 } }, /* cologne */
    { .label = { 134908,  7, 0 } }, /* comcast */
    { .label = { 115774,  8, 0 } }, /* commbank */
    { .label = {  41528,  9, 1 } }, { .child = { 9594, 2 } }, /* community */
    { .label = {  30077,  7, 0 } }, /* company */
    { .label = { 134938,  7, 0 } }, /* compare */
    { .label = {  20300,  8, 0 } }, /* computer */
    { .label = { 154634,  6, 0 } }, /* comsec */
    { .label = { 154661,  6, 0 } }, /* condos */
    { .label = {  49412, 12, 0 } }, /* construction */
    { .label = {  67929, 10, 0 } }, /* consulting */
    { .label = { 134969,  7, 0 } }, /* contact */
    { .label = {  61387, 11, 0 } }, /* contractors */
    { .label = {  30291,  7, 0 } }, /* cooking */
    { .label = {  30291, 14, 0 } }, /* cookingchannel */
    { .label = { 170720,  4, 1 } }, { .child = { 9596, 1 } }, /* cool */
    { .label = { 134998,  7, 0 } }, /* corsica */
    { .label = {  20774,  7, 0 } }, /* country */
    { .label = { 135027,  6, 0 } }, /* coupon */
    { .label = { 135027,  7, 0 } }, /* coupons */
    { .label = { 135059,  7, 0 } }, /* courses */
    { .label = {  33306,  3, 0 } }, /* cpa */
    { .label = {  61432,  6, 0 } }, /* credit */
    { .label = {  77035, 10, 0 } }, /* creditcard */
    { .label = {  61432, 11, 0 } }, /* creditunion */
    { .label = { 135089,  7, 0 } }, /* cricket */
    { .label = { 165921,  5, 0 } }, /* crown */
    { .label = {  23616,  3, 0 } }, /* crs */
    { .label = { 135120,  6, 0 } }, /* cruise */
    { .label = { 135120,  7, 0 } }, /* cruises */
    { .label = {  18106,  3, 0 } }, /* csc */
    { .label = {  77078, 10, 0 } }, /* cuisinella */
    { .label = { 162747,  5, 0 } }, /* cymru */
    { .label = { 170738,  4, 0 } }, /* cyou */
    { .label = { 165944,  5, 0 } }, /* dabur */
    { .label = {   6698,  3, 0 } }, /* dad */
    { .label = { 165967,  5, 0 } }, /* dance */
    { .label = {  41513,  4, 0 } }, /* data */
    { .label = {  31826,  4, 0 } }, /* date */
    { .label = { 154687,  6, 0 } }, /* dating */
    { .label = { 154712,  6, 0 } }, /* datsun */
    { .label = {  17825,  3, 0 } }, /* day */
    { .label = { 170758,  4, 0 } }, /* dclk */
    { .label = {   3081,  3, 0 } }, /* dds */
    { .label = {   4330,  4, 0 } }, /* deal */
    { .label = {  82678,  6, 0 } }, /* dealer */
    { .label = { 165988,  5, 0 } }, /* deals */
    { .label = { 154737,  6, 0 } }, /* degree */
    { .label = { 115811,  8, 0 } }, /* delivery */
    { .label = {   3397,  4, 0 } }, /* dell */
    { .label = { 115849,  8, 0 } }, /* deloitte */
    { .label = { 166009,  5, 0 } }, /* delta */
    { .label = {  39943,  8, 0 } }, /* democrat */
    { .label = { 154763,  6, 0 } }, /* dental */
    { .label = {    243,  7, 0 } }, /* dentist */
    { .label = {  27302,  4, 0 } }, /* desi */
    { .label = {  27302,  6, 1 } }, { .child = { 9597, 1 } }, /* design */
    { .label = {   9167,  3, 1 } }, { .child = { 9598, 10 } }, /* dev */
    { .label = {  15079,  3, 0 } }, /* dhl */
    { .label = { 115883,  8, 0 } }, /* diamonds */
    { .label = { 151873,  4, 0 } }, /* diet */
    { .label = { 135150,  7, 1 } }, { .child = { 9614, 1 } }, /* digital */
    { .label = {  13654,  6, 1 } }, { .child = { 9617, 1 } }, /* direct */
    { .label = {  13654,  9, 0 } }, /* directory */
    { .label = { 115917,  8, 0 } }, /* discount */
    { .label = {  89382,  8, 0 } }, /* discover */
    { .label = { 170778,  4, 0 } }, /* dish */
    { .label = {    278,  3, 0 } }, /* diy */
    { .label = {   7465,  3, 0 } }, /* dnp */
    { .label = {  67329,  4, 0 } }, /* docs */
    { .label = {  65200,  6, 0 } }, /* doctor */
    { .label = {  19745,  3, 0 } }, /* dog */
    { .label = { 135180,  7, 0 } }, /* domains */
    { .label = {   9991,  3, 0 } }, /* dot */
    { .label = { 115952,  8, 0 } }, /* download */
    { .label = { 166030,  5, 0 } }, /* drive */
    { .label = {  59802,  3, 0 } }, /* dtv */
    { .label = { 166053,  5, 0 } }, /* dubai */
    { .label = { 137963,  4, 0 } }, /* duck */
    { .label = { 154788,  6, 0 } }, /* dunlop */
    { .label = { 154817,  6, 0 } }, /* dupont */
    { .label = { 154845,  6, 0 } }, /* durban */
    { .label = { 170796,  4, 0 } }, /* dvag */
    { .label = {  66042,  3, 0 } }, /* dvr */
    { .label = { 166076,  5, 1 } }, { .child = { 9618, 1 } }, /* earth */
    { .label = {   8095,  3, 0 } }, /* eat */
    { .label = {    102,  3, 0 } }, /* eco */
    { .label = { 166096,  5, 0 } }, /* edeka */
    { .label = {  44279,  9, 1 } }, { .child = { 9624, 1 } }, /* education */
    { .label = {  40909,  5, 0 } }, /* email */
    { .label = { 154872,  6, 0 } }, /* emerck */
    { .label = { 154899,  6, 0 } }, /* energy */
    { .label = {  32041,  8, 0 } }, /* engineer */
    { .label = {  61479, 11, 0 } }, /* engineering */
    { .label = {  61525, 11, 0 } }, /* enterprises */
    { .label = { 166117,  5, 0 } }, /* epson */
    { .label = {  35233,  9, 0 } }, /* equipment */
    { .label = { 115988,  8, 0 } }, /* ericsson */
    { .label = {  76171,  4, 0 } }, /* erni */
    { .label = { 137593,  3, 0 } }, /* esq */
    { .label = {  20806,  6, 1 } }, { .child = { 9625, 1 } }, /* estate */
    { .label = { 116021,  8, 0 } }, /* esurance */
    { .label = { 116054,  8, 0 } }, /* etisalat */
    { .label = {  77121, 10, 0 } }, /* eurovision */
    { .label = {   4061,  3, 1 } }, { .child = { 9628, 1 } }, /* eus */
    { .label = { 154926,  6, 1 } }, { .child = { 9631, 1 } }, /* events */
    { .label = {  41197,  8, 0 } }, /* exchange */
    { .label = {   7942,  6, 0 } }, /* expert */
    { .label = { 135209,  7, 0 } }, /* exposed */
    { .label = {  23332,  7, 0 } }, /* express */
    { .label = {  77164, 10, 0 } }, /* extraspace */
    { .label = { 170815,  4, 0 } }, /* fage */
    { .label = {  58159,  4, 0 } }, /* fail */
    { .label = {  95104,  9, 0 } }, /* fairwinds */
    { .label = { 166139,  5, 1 } }, { .child = { 9632, 1 } }, /* faith */
    { .label = {  30048,  6, 0 } }, /* family */
    { .label = {   3070,  3, 0 } }, /* fan */
    { .label = {  68401,  4, 0 } }, /* fans */
    { .label = {  13672,  4, 1 } }, { .child = { 9633, 1 } }, /* farm */
    { .label = { 129223,  7, 0 } }, /* farmers */
    { .label = { 135242,  7, 1 } }, { .child = { 9634, 2 } }, /* fashion */
    { .label = {  17811,  4, 0 } }, /* fast */
    { .label = { 166161,  5, 0 } }, /* fedex */
    { .label = { 116085,  8, 0 } }, /* feedback */
    { .label = { 135272,  7, 0 } }, /* ferrari */
    { .label = { 135301,  7, 0 } }, /* ferrero */
    { .label = { 170833,  4, 0 } }, /* fiat */
    { .label = { 116123,  8, 0 } }, /* fidelity */
    { .label = { 170850,  4, 0 } }, /* fido */
    { .label = {  82288,  4, 0 } }, /* film */
    { .label = { 166186,  5, 0 } }, /* final */
    { .label = { 135331,  7, 0 } }, /* finance */
    { .label = {   3951,  9, 1 } }, { .child = { 9636, 1 } }, /* financial */
    { .label = {  15408,  4, 0 } }, /* fire */
    { .label = {  95144,  9, 0 } }, /* firestone */
    { .label = { 116161,  8, 0 } }, /* firmdale */
    { .label = { 135361,  4, 0 } }, /* fish */
    { .label = { 135361,  7, 0 } }, /* fishing */
    { .label = {  20107,  3, 1 } }, { .child = { 9637, 1 } }, /* fit */
    { .label = { 135393,  7, 0 } }, /* fitness */
    { .label = { 154952,  6, 0 } }, /* flickr */
    { .label = { 135423,  7, 0 } }, /* flights */
    { .label = { 170869,  4, 0 } }, /* flir */
    { .label = { 135456,  7, 0 } }, /* florist */
    { .label = { 135487,  7, 0 } }, /* flowers */
    { .label = {  51991,  3, 0 } }, /* fly */
    { .label = {  29657,  3, 0 } }, /* foo */
    { .label = {  61571,  4, 0 } }, /* food */
    { .label = {  61571, 11, 0 } }, /* foodnetwork */
    { .label = { 116197,  8, 1 } }, { .child = { 9638, 1 } }, /* football */
    { .label = { 150490,  4, 0 } }, /* ford */
    { .label = { 166208,  5, 0 } }, /* forex */
    { .label = { 135520,  7, 0 } }, /* forsale */
    { .label = {  99437,  5, 0 } }, /* forum */
    { .label = {  73182, 10, 0 } }, /* foundation */
    { .label = {  52136,  3, 0 } }, /* fox */
    { .label = {  57740,  4, 0 } }, /* free */
    { .label = {  95182,  9, 0 } }, /* fresenius */
    { .label = {  95640,  3, 0 } }, /* frl */
    { .label = { 135550,  7, 0 } }, /* frogans */
    { .label = {  95221,  9, 0 } }, /* frontdoor */
    { .label = { 116234,  8, 0 } }, /* frontier */
    { .label = {  20587,  3, 0 } }, /* ftr */
    { .label = { 135580,  7, 0 } }, /* fujitsu */
    { .label = {  95260,  9, 0 } }, /* fujixerox */
    { .label = {  32353,  3, 0 } }, /* fun */
    { .label = { 109940,  4, 0 } }, /* fund */
    { .label = {  89733,  9, 0 } }, /* furniture */
    { .label = { 154981,  6, 0 } }, /* futbol */
    { .label = { 172908,  3, 0 } }, /* fyi */
    { .label = {    549,  3, 0 } }, /* gal */
    { .label = {  72541,  7, 0 } }, /* gallery */
    { .label = { 111191,  5, 0 } }, /* gallo */
    { .label = { 155011,  6, 0 } }, /* gallup */
    { .label = {  40282,  4, 0 } }, /* game */
    { .label = {  40282,  5, 0 } }, /* games */
    { .label = {  52075,  3, 0 } }, /* gap */
    { .label = {  20078,  6, 0 } }, /* garden */
    { .label = {  18153,  3, 0 } }, /* gay */
    { .label = { 170888,  4, 0 } }, /* gbiz */
    { .label = {   7460,  3, 1 } }, { .child = { 9639, 1 } }, /* gdn */
    { .label = {  30415,  3, 0 } }, /* gea */
    { .label = {   4094,  4, 0 } }, /* gent */
    { .label = { 135615,  7, 0 } }, /* genting */
    { .label = { 155040,  6, 0 } }, /* george */
    { .label = { 170910,  4, 0 } }, /* ggee */
    { .label = {  77774,  4, 0 } }, /* gift */
    { .label = { 166232,  5, 0 } }, /* gifts */
    { .label = { 166255,  5, 0 } }, /* gives */
    { .label = { 155066,  6, 0 } }, /* giving */
    { .label = { 166278,  5, 0 } }, /* glade */
    { .label = { 162841,  5, 0 } }, /* glass */
    { .label = {   5432,  3, 0 } }, /* gle */
    { .label = { 155094,  6, 0 } }, /* global */
    { .label = { 166300,  5, 0 } }, /* globo */
    { .label = { 135839,  5, 0 } }, /* gmail */
    { .label = { 170928,  4, 0 } }, /* gmbh */
    { .label = {  49658,  3, 0 } }, /* gmo */
    { .label = {  16878,  3, 0 } }, /* gmx */
    { .label = { 135645,  7, 0 } }, /* godaddy */
    { .label = {  95306,  4, 0 } }, /* gold */
    { .label = {  95306,  9, 0 } }, /* goldpoint */
    { .label = { 141223,  4, 0 } }, /* golf */
    { .label = {  17513,  3, 0 } }, /* goo */
    { .label = { 116268,  8, 0 } }, /* goodyear */
    { .label = {  80526,  4, 1 } }, { .child = { 9640, 1 } }, /* goog */
    { .label = {  80526,  6, 0 } }, /* google */
    { .label = {  13209,  3, 0 } }, /* gop */
    { .label = {  43493,  3, 0 } }, /* got */
    { .label = { 116303,  8, 0 } }, /* grainger */
    { .label = {  35414,  8, 0 } }, /* graphics */
    { .label = { 155122,  6, 0 } }, /* gratis */
    { .label = {  79695,  5, 0 } }, /* green */
    { .label = { 166324,  5, 0 } }, /* gripe */
    { .label = { 135678,  7, 0 } }, /* grocery */
    { .label = {  41733,  5, 1 } }, { .child = { 9641, 1 } }, /* group */
    { .label = { 116336,  8, 0 } }, /* guardian */
    { .label = { 166347,  5, 0 } }, /* gucci */
    { .label = { 170949,  4, 0 } }, /* guge */
    { .label = { 166371,  5, 0 } }, /* guide */
    { .label = { 135710,  7, 0 } }, /* guitars */
    { .label = {  97559,  4, 0 } }, /* guru */
    { .label = { 138137,  4, 0 } }, /* hair */
    { .label = { 129406,  7, 0 } }, /* hamburg */
    { .label = { 135739,  7, 0 } }, /* hangout */
    { .label = { 134517,  4, 0 } }, /* haus */
    { .label = {  74565,  3, 0 } }, /* hbo */
    { .label = { 116369,  4, 0 } }, /* hdfc */
    { .label = { 116369,  8, 0 } }, /* hdfcbank */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = {  77207, 10, 0 } }, /* healthcare */
    { .label = { 170968,  4, 0 } }, /* help */
    { .label = { 110012,  8, 0 } }, /* helsinki */
    { .label = {  10159,  4, 0 } }, /* here */
    { .label = { 155146,  6, 0 } }, /* hermes */
    { .label = { 170988,  4, 0 } }, /* hgtv */
    { .label = { 155172,  6, 0 } }, /* hiphop */
    { .label = {  95347,  9, 0 } }, /* hisamitsu */
    { .label = {  43205,  7, 0 } }, /* hitachi */
    { .label = {  10269,  3, 0 } }, /* hiv */
    { .label = {  17179,  3, 0 } }, /* hkt */
    { .label = {  40379,  6, 0 } }, /* hockey */
    { .label = { 116408,  8, 0 } }, /* holdings */
    { .label = { 135769,  7, 0 } }, /* holiday */
    { .label = {  95385,  9, 0 } }, /* homedepot */
    { .label = {  95426,  9, 0 } }, /* homegoods */
    { .label = {  25036,  5, 0 } }, /* homes */
    { .label = {  95466,  9, 0 } }, /* homesense */
    { .label = { 166394,  5, 0 } }, /* honda */
    { .label = { 166415,  5, 0 } }, /* horse */
    { .label = { 116444,  8, 0 } }, /* hospital */
    { .label = {  24117,  4, 1 } }, { .child = { 9642, 6 } }, /* host */
    { .label = {  24117,  7, 1 } }, { .child = { 9648, 1 } }, /* hosting */
    { .label = {  13352,  3, 0 } }, /* hot */
    { .label = { 135801,  7, 0 } }, /* hoteles */
    { .label = {  61691,  6, 0 } }, /* hotels */
    { .label = { 135831,  7, 0 } }, /* hotmail */
    { .label = {  27240,  5, 0 } }, /* house */
    { .label = {  48532,  3, 0 } }, /* how */
    { .label = { 171008,  4, 0 } }, /* hsbc */
    { .label = { 155202,  6, 0 } }, /* hughes */
    { .label = { 166436,  5, 0 } }, /* hyatt */
    { .label = { 135861,  7, 0 } }, /* hyundai */
    { .label = {  31438,  3, 0 } }, /* ibm */
    { .label = { 171028,  4, 0 } }, /* icbc */
    { .label = {  14055,  3, 0 } }, /* ice */
    { .label = {  22905,  3, 0 } }, /* icu */
    { .label = { 171048,  4, 0 } }, /* ieee */
    { .label = { 136377,  3, 0 } }, /* ifm */
    { .label = { 146206,  5, 0 } }, /* ikano */
    { .label = { 155230,  6, 0 } }, /* imamat */
    { .label = { 171064,  4, 0 } }, /* imdb */
    { .label = {  77249,  4, 0 } }, /* immo */
    { .label = {  77249, 10, 0 } }, /* immobilien */
    { .label = {  20072,  3, 0 } }, /* inc */
    { .label = {  77294, 10, 0 } }, /* industries */
    { .label = { 116479,  8, 0 } }, /* infiniti */
    { .label = {  10132,  3, 0 } }, /* ing */
    { .label = {   4024,  3, 1 } }, { .child = { 9649, 1 } }, /* ink */
    { .label = {  95504,  9, 0 } }, /* institute */
    { .label = {   1529,  9, 0 } }, /* insurance */
    { .label = { 155254,  6, 0 } }, /* insure */
    { .label = {  44785,  5, 0 } }, /* intel */
    { .label = {  38656, 13, 0 } }, /* international */
    { .label = { 155279,  6, 0 } }, /* intuit */
    { .label = {  61621, 11, 0 } }, /* investments */
    { .label = { 116513,  8, 0 } }, /* ipiranga */
    { .label = { 166458,  5, 0 } }, /* irish */
    { .label = { 135893,  7, 0 } }, /* ismaili */
    { .label = {    260,  3, 0 } }, /* ist */
    { .label = { 116546,  8, 0 } }, /* istanbul */
    { .label = {  27260,  4, 0 } }, /* itau */
    { .label = { 172924,  3, 0 } }, /* itv */
    { .label = { 166479,  5, 0 } }, /* iveco */
    { .label = { 155304,  6, 0 } }, /* jaguar */
    { .label = {  58633,  4, 0 } }, /* java */
    { .label = {     50,  3, 0 } }, /* jcb */
    { .label = { 136529,  3, 0 } }, /* jcp */
    { .label = { 171084,  4, 0 } }, /* jeep */
    { .label = { 166502,  5, 0 } }, /* jetzt */
    { .label = { 129499,  7, 0 } }, /* jewelry */
    { .label = {   2175,  3, 0 } }, /* jio */
    { .label = { 172938,  3, 0 } }, /* jll */
    { .label = { 172955,  3, 0 } }, /* jmp */
    { .label = { 172973,  3, 0 } }, /* jnj */
    { .label = { 155331,  6, 0 } }, /* joburg */
    { .label = {   4791,  3, 0 } }, /* jot */
    { .label = { 157930,  3, 0 } }, /* joy */
    { .label = { 116581,  8, 0 } }, /* jpmorgan */
    { .label = { 171105,  4, 0 } }, /* jprs */
    { .label = { 155362,  6, 0 } }, /* juegos */
    { .label = { 135922,  7, 0 } }, /* juniper */
    { .label = { 155391,  6, 0 } }, /* kaufen */
    { .label = { 171126,  4, 0 } }, /* kddi */
    { .label = {  61668, 11, 0 } }, /* kerryhotels */
    { .label = {  30352, 14, 0 } }, /* kerrylogistics */
    { .label = {  23364, 15, 0 } }, /* kerryproperties */
    { .label = {  17663,  3, 0 } }, /* kfh */
    { .label = {  48858,  3, 0 } }, /* kia */
    { .label = {  27149,  3, 0 } }, /* kim */
    { .label = { 155418,  6, 0 } }, /* kinder */
    { .label = { 155444,  6, 0 } }, /* kindle */
    { .label = { 135956,  7, 0 } }, /* kitchen */
    { .label = { 170112,  4, 0 } }, /* kiwi */
    { .label = { 162884,  5, 0 } }, /* koeln */
    { .label = {  44014,  7, 0 } }, /* komatsu */
    { .label = { 155471,  6, 0 } }, /* kosher */
    { .label = { 171145,  4, 0 } }, /* kpmg */
    { .label = { 172991,  3, 0 } }, /* kpn */
    { .label = {  11769,  3, 1 } }, { .child = { 9650, 2 } }, /* krd */
    { .label = { 118619,  4, 0 } }, /* kred */
    { .label = {  95541,  9, 0 } }, /* kuokgroup */
    { .label = { 159708,  5, 0 } }, /* kyoto */
    { .label = { 135987,  7, 0 } }, /* lacaixa */
    { .label = {  61717, 11, 0 } }, /* lamborghini */
    { .label = {  15086,  5, 0 } }, /* lamer */
    { .label = {  95584,  9, 0 } }, /* lancaster */
    { .label = { 155497,  6, 0 } }, /* lancia */
    { .label = {   3685,  4, 1 } }, { .child = { 9652, 1 } }, /* land */
    { .label = {  95620,  9, 0 } }, /* landrover */
    { .label = { 136016,  7, 0 } }, /* lanxess */
    { .label = { 136046,  7, 0 } }, /* lasalle */
    { .label = {   9515,  3, 0 } }, /* lat */
    { .label = { 155521,  6, 0 } }, /* latino */
    { .label = { 136075,  7, 0 } }, /* latrobe */
    { .label = {  20740,  3, 0 } }, /* law */
    { .label = {  65342,  6, 0 } }, /* lawyer */
    { .label = {  35811,  3, 0 } }, /* lds */
    { .label = { 166528,  5, 0 } }, /* lease */
    { .label = { 136105,  7, 0 } }, /* leclerc */
    { .label = { 155545,  6, 0 } }, /* lefrak */
    { .label = { 166548,  5, 0 } }, /* legal */
    { .label = { 171166,  4, 0 } }, /* lego */
    { .label = { 166570,  5, 0 } }, /* lexus */
    { .label = { 171184,  4, 0 } }, /* lgbt */
    { .label = { 171204,  4, 0 } }, /* lidl */
    { .label = {  38707,  4, 0 } }, /* life */
    { .label = {  38707, 13, 0 } }, /* lifeinsurance */
    { .label = {  95659,  9, 0 } }, /* lifestyle */
    { .label = { 116619,  8, 0 } }, /* lighting */
    { .label = {  11868,  4, 0 } }, /* like */
    { .label = { 166594,  5, 0 } }, /* lilly */
    { .label = { 136137,  7, 0 } }, /* limited */
    { .label = { 125821,  4, 0 } }, /* limo */
    { .label = { 129627,  7, 0 } }, /* lincoln */
    { .label = {  92268,  5, 0 } }, /* linde */
    { .label = {  32393,  4, 1 } }, { .child = { 9656, 3 } }, /* link */
    { .label = { 166619,  5, 0 } }, /* lipsy */
    { .label = {   4221,  4, 0 } }, /* live */
    { .label = {  20838,  6, 0 } }, /* living */
    { .label = { 166644,  5, 0 } }, /* lixil */
    { .label = {  33625,  3, 0 } }, /* llc */
    { .label = {  15533,  3, 0 } }, /* llp */
    { .label = { 166668,  4, 0 } }, /* loan */
    { .label = { 166668,  5, 0 } }, /* loans */
    { .label = { 155572,  6, 0 } }, /* locker */
    { .label = { 166688,  5, 0 } }, /* locus */
    { .label = {  41688,  4, 0 } }, /* loft */
    { .label = {   2308,  3, 0 } }, /* lol */
    { .label = { 150161,  6, 1 } }, { .child = { 9661, 2 } }, /* london */
    { .label = {  98424,  5, 0 } }, /* lotte */
    { .label = { 166711,  5, 0 } }, /* lotto */
    { .label = {  52325,  4, 0 } }, /* love */
    { .label = {  49463,  3, 0 } }, /* lpl */
    { .label = {  49463, 12, 0 } }, /* lplfinancial */
    { .label = {  38987,  3, 0 } }, /* ltd */
    { .label = { 132412,  4, 0 } }, /* ltda */
    { .label = { 116655,  8, 0 } }, /* lundbeck */
    { .label = { 166732,  5, 0 } }, /* lupin */
    { .label = {  73533,  4, 0 } }, /* luxe */
    { .label = { 155599,  6, 0 } }, /* luxury */
    { .label = { 166756,  5, 0 } }, /* macys */
    { .label = { 150244,  6, 0 } }, /* madrid */
    { .label = {  41328,  4, 0 } }, /* maif */
    { .label = {  24288,  6, 0 } }, /* maison */
    { .label = { 155630,  6, 0 } }, /* makeup */
    { .label = {   2844,  3, 0 } }, /* man */
    { .label = {  77336, 10, 1 } }, { .child = { 9663, 1 } }, /* management */
    { .label = { 166779,  5, 0 } }, /* mango */
    { .label = {  10250,  3, 0 } }, /* map */
    { .label = {  44760,  6, 0 } }, /* market */
    { .label = {  95701,  9, 0 } }, /* marketing */
    { .label = { 136168,  7, 0 } }, /* markets */
    { .label = { 116694,  8, 0 } }, /* marriott */
    { .label = {  95739,  9, 0 } }, /* marshalls */
    { .label = { 116726,  8, 0 } }, /* maserati */
    { .label = { 155658,  6, 0 } }, /* mattel */
    { .label = {   6236,  3, 0 } }, /* mba */
    { .label = { 116757,  8, 0 } }, /* mckinsey */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {  98775,  5, 0 } }, /* media */
    { .label = { 171223,  4, 0 } }, /* meet */
    { .label = {  95777,  9, 0 } }, /* melbourne */
    { .label = { 171240,  4, 0 } }, /* meme */
    { .label = { 110319,  8, 0 } }, /* memorial */
    { .label = {    591,  3, 1 } }, { .child = { 9664, 1 } }, /* men */
    { .label = {  37675,  4, 1 } }, { .child = { 9665, 1 } }, /* menu */
    { .label = { 116794,  8, 0 } }, /* merckmsd */
    { .label = { 136197,  7, 0 } }, /* metlife */
    { .label = { 166800,  5, 0 } }, /* miami */
    { .label = {  95818,  9, 0 } }, /* microsoft */
    { .label = {  80927,  4, 0 } }, /* mini */
    { .label = { 142000,  4, 0 } }, /* mint */
    { .label = {   7502,  3, 0 } }, /* mit */
    { .label = {  77377, 10, 0 } }, /* mitsubishi */
    { .label = { 157066,  3, 0 } }, /* mlb */
    { .label = {   2446,  3, 0 } }, /* mls */
    { .label = {  42858,  3, 0 } }, /* mma */
    { .label = {  52293,  6, 0 } }, /* mobile */
    { .label = {  85534,  4, 0 } }, /* moda */
    { .label = {   3774,  3, 0 } }, /* moe */
    { .label = {  18008,  3, 0 } }, /* moi */
    { .label = {  43897,  3, 1 } }, { .child = { 9666, 2 } }, /* mom */
    { .label = { 155683,  6, 0 } }, /* monash */
    { .label = { 162928,  5, 0 } }, /* money */
    { .label = { 136229,  7, 0 } }, /* monster */
    { .label = { 155708,  6, 0 } }, /* mormon */
    { .label = { 116831,  8, 0 } }, /* mortgage */
    { .label = { 150372,  6, 0 } }, /* moscow */
    { .label = {  61766,  4, 0 } }, /* moto */
    { .label = {  61766, 11, 0 } }, /* motorcycles */
    { .label = {  68313,  3, 0 } }, /* mov */
    { .label = { 166821,  5, 0 } }, /* movie */
    { .label = {   2551,  3, 0 } }, /* msd */
    { .label = {  24191,  3, 0 } }, /* mtn */
    { .label = {    158,  3, 0 } }, /* mtr */
    { .label = {   9990,  6, 0 } }, /* mutual */
    { .label = {    275,  3, 0 } }, /* nab */
    { .label = { 143528,  6, 0 } }, /* nagoya */
    { .label = {  77422, 10, 0 } }, /* nationwide */
    { .label = {   4481,  6, 0 } }, /* natura */
    { .label = { 136363,  4, 0 } }, /* navy */
    { .label = {    398,  3, 0 } }, /* nba */
    { .label = {   6844,  3, 0 } }, /* nec */
    { .label = { 136258,  7, 0 } }, /* netbank */
    { .label = { 136288,  7, 0 } }, /* netflix */
    { .label = {  13820,  7, 1 } }, { .child = { 9668, 4 } }, /* network */
    { .label = { 136321,  7, 0 } }, /* neustar */
    { .label = {  18257,  3, 0 } }, /* new */
    { .label = {  77464, 10, 0 } }, /* newholland */
    { .label = {  18257,  4, 0 } }, /* news */
    { .label = {  77160,  4, 0 } }, /* next */
    { .label = {  77509, 10, 0 } }, /* nextdirect */
    { .label = { 166844,  5, 0 } }, /* nexus */
    { .label = {  19798,  3, 0 } }, /* nfl */
    { .label = {  10119,  3, 0 } }, /* ngo */
    { .label = {  66629,  3, 0 } }, /* nhk */
    { .label = { 156662,  4, 0 } }, /* nico */
    { .label = {  24041,  4, 0 } }, /* nike */
    { .label = { 166867,  5, 0 } }, /* nikon */
    { .label = { 166888,  5, 0 } }, /* ninja */
    { .label = { 155734,  6, 0 } }, /* nissan */
    { .label = { 155757,  6, 0 } }, /* nissay */
    { .label = { 166910,  5, 0 } }, /* nokia */
    { .label = {   9939, 18, 0 } }, /* northwesternmutual */
    { .label = { 155782,  6, 0 } }, /* norton */
    { .label = {    540,  3, 0 } }, /* now */
    { .label = { 155806,  6, 0 } }, /* nowruz */
    { .label = { 166930,  5, 0 } }, /* nowtv */
    { .label = {   4869,  3, 0 } }, /* nra */
    { .label = {  97292,  3, 0 } }, /* nrw */
    { .label = {   3756,  3, 0 } }, /* ntt */
    { .label = { 113472,  3, 0 } }, /* nyc */
    { .label = {  10203,  3, 0 } }, /* obi */
    { .label = { 116865,  8, 0 } }, /* observer */
    { .label = {  39607,  3, 0 } }, /* off */
    { .label = {  39607,  6, 0 } }, /* office */
    { .label = { 123074,  7, 0 } }, /* okinawa */
    { .label = {  61816,  6, 0 } }, /* olayan */
    { .label = {  61816, 11, 0 } }, /* olayangroup */
    { .label = { 136349,  7, 0 } }, /* oldnavy */
    { .label = { 171258,  4, 0 } }, /* ollo */
    { .label = { 114555,  5, 0 } }, /* omega */
    { .label = {   7947,  3, 1 } }, { .child = { 9674, 3 } }, /* one */
    { .label = {   1425,  3, 0 } }, /* ong */
    { .label = {  19549,  3, 0 } }, /* onl */
    { .label = {  66681,  6, 1 } }, { .child = { 9679, 1 } }, /* online */
    { .label = {  77553, 10, 0 } }, /* onyourside */
    { .label = {  38425,  3, 0 } }, /* ooo */
    { .label = {  72921,  4, 0 } }, /* open */
    { .label = { 155836,  6, 0 } }, /* oracle */
    { .label = { 155861,  6, 0 } }, /* orange */
    { .label = {  32606,  7, 0 } }, /* organic */
    { .label = { 136382,  7, 0 } }, /* origins */
    { .label = {  43739,  5, 0 } }, /* osaka */
    { .label = {  70456,  6, 0 } }, /* otsuka */
    { .label = {   4710,  3, 0 } }, /* ott */
    { .label = { 113495,  3, 1 } }, { .child = { 9680, 1 } }, /* ovh */
    { .label = {  10258,  4, 1 } }, { .child = { 9681, 3 } }, /* page */
    { .label = {  95858,  9, 0 } }, /* panasonic */
    { .label = { 163055,  5, 0 } }, /* paris */
    { .label = {  40563,  4, 0 } }, /* pars */
    { .label = { 116901,  8, 0 } }, /* partners */
    { .label = { 166954,  5, 0 } }, /* parts */
    { .label = { 166975,  5, 1 } }, { .child = { 9684, 1 } }, /* party */
    { .label = {  95895,  9, 0 } }, /* passagens */
    { .label = {    490,  3, 0 } }, /* pay */
    { .label = { 171276,  4, 0 } }, /* pccw */
    { .label = {  11552,  3, 0 } }, /* pet */
    { .label = { 155885,  6, 0 } }, /* pfizer */
    { .label = { 110701,  8, 0 } }, /* pharmacy */
    { .label = { 173006,  3, 0 } }, /* phd */
    { .label = { 136411,  7, 0 } }, /* philips */
    { .label = { 166998,  5, 0 } }, /* phone */
    { .label = {  13346,  5, 0 } }, /* photo */
    { .label = {  58227, 11, 0 } }, /* photography */
    { .label = { 118391,  6, 0 } }, /* photos */
    { .label = { 155916,  6, 0 } }, /* physio */
    { .label = {  64865,  4, 0 } }, /* pics */
    { .label = { 155945,  6, 0 } }, /* pictet */
    { .label = { 116934,  8, 1 } }, { .child = { 9685, 1 } }, /* pictures */
    { .label = {   2004,  3, 0 } }, /* pid */
    { .label = {  32993,  3, 0 } }, /* pin */
    { .label = {  58453,  4, 0 } }, /* ping */
    { .label = { 171298,  4, 0 } }, /* pink */
    { .label = { 136445,  7, 0 } }, /* pioneer */
    { .label = { 167021,  5, 0 } }, /* pizza */
    { .label = {  72639,  5, 1 } }, { .child = { 9686, 1 } }, /* place */
    { .label = {  13851,  4, 0 } }, /* play */
    { .label = {  13851, 11, 0 } }, /* playstation */
    { .label = { 116970,  8, 0 } }, /* plumbing */
    { .label = {  24151,  4, 0 } }, /* plus */
    { .label = {  49678,  3, 0 } }, /* pnc */
    { .label = { 171317,  4, 0 } }, /* pohl */
    { .label = { 167048,  5, 0 } }, /* poker */
    { .label = { 136475,  7, 0 } }, /* politie */
    { .label = { 171337,  4, 1 } }, { .child = { 9687, 1 } }, /* porn */
    { .label = {  95932,  9, 0 } }, /* pramerica */
    { .label = { 167071,  5, 0 } }, /* praxi */
    { .label = {  23342,  5, 0 } }, /* press */
    { .label = { 153920,  5, 0 } }, /* prime */
    { .label = {  61865,  4, 0 } }, /* prod */
    { .label = {  61865, 11, 0 } }, /* productions */
    { .label = {  53199,  4, 0 } }, /* prof */
    { .label = {  61914, 11, 0 } }, /* progressive */
    { .label = { 167094,  5, 0 } }, /* promo */
    { .label = {  23387, 10, 0 } }, /* properties */
    { .label = { 117010,  8, 0 } }, /* property */
    { .label = {  77597, 10, 0 } }, /* protection */
    { .label = {  77640,  3, 0 } }, /* pru */
    { .label = {  77640, 10, 0 } }, /* prudential */
    { .label = {  10196,  3, 1 } }, { .child = { 9688, 1 } }, /* pub */
    { .label = {  77781,  3, 0 } }, /* pwc */
    { .label = { 171355,  4, 0 } }, /* qpon */
    { .label = { 150614,  6, 0 } }, /* quebec */
    { .label = { 167117,  5, 0 } }, /* quest */
    { .label = { 173022,  3, 0 } }, /* qvc */
    { .label = { 155972,  6, 0 } }, /* racing */
    { .label = {  51113,  5, 0 } }, /* radio */
    { .label = {  18953,  4, 0 } }, /* raid */
    { .label = {  38773,  4, 0 } }, /* read */
    { .label = {  75657, 10, 0 } }, /* realestate */
    { .label = { 136506,  7, 0 } }, /* realtor */
    { .label = { 155997,  6, 0 } }, /* realty */
    { .label = { 136534,  7, 0 } }, /* recipes */
    { .label = {   9541,  3, 0 } }, /* red */
    { .label = { 117048,  8, 0 } }, /* redstone */
    { .label = {  61963, 11, 0 } }, /* redumbrella */
    { .label = { 167142,  5, 0 } }, /* rehab */
    { .label = { 156023,  5, 0 } }, /* reise */
    { .label = { 156023,  6, 0 } }, /* reisen */
    { .label = {  34683,  4, 0 } }, /* reit */
    { .label = { 117081,  8, 0 } }, /* reliance */
    { .label = {    469,  3, 0 } }, /* ren */
    { .label = {    469,  4, 0 } }, /* rent */
    { .label = { 136565,  7, 0 } }, /* rentals */
    { .label = { 156047,  6, 0 } }, /* repair */
    { .label = { 156072,  6, 0 } }, /* report */
    { .label = {  24724, 10, 0 } }, /* republican */
    { .label = {  39452,  4, 0 } }, /* rest */
    { .label = {  77684, 10, 0 } }, /* restaurant */
    { .label = { 136593,  6, 1 } }, { .child = { 9689, 1 } }, /* review */
    { .label = { 136593,  7, 0 } }, /* reviews */
    { .label = { 136625,  7, 0 } }, /* rexroth */
    { .label = {  27227,  4, 0 } }, /* rich */
    { .label = {  95970,  9, 0 } }, /* richardli */
    { .label = { 167164,  5, 0 } }, /* ricoh */
    { .label = {  62013, 11, 0 } }, /* rightathome */
    { .label = {  44632,  3, 0 } }, /* ril */
    { .label = {   3773,  3, 0 } }, /* rio */
    { .label = {   3842,  3, 1 } }, { .child = { 9690, 1 } }, /* rip */
    { .label = {  75862,  4, 0 } }, /* rmit */
    { .label = { 156098,  6, 0 } }, /* rocher */
    { .label = {  40108,  5, 1 } }, { .child = { 9691, 3 } }, /* rocks */
    { .label = { 167186,  5, 0 } }, /* rodeo */
    { .label = { 156124,  6, 0 } }, /* rogers */
    { .label = { 137569,  4, 0 } }, /* room */
    { .label = {  62960,  4, 0 } }, /* rsvp */
    { .label = { 167207,  5, 0 } }, /* rugby */
    { .label = { 171377,  4, 0 } }, /* ruhr */
    { .label = {  32355,  3, 1 } }, { .child = { 9694, 4 } }, /* run */
    { .label = {   6802,  3, 0 } }, /* rwe */
    { .label = { 156149,  6, 0 } }, /* ryukyu */
    { .label = { 117114,  8, 0 } }, /* saarland */
    { .label = {  13208,  4, 0 } }, /* safe */
    { .label = {  13208,  6, 0 } }, /* safety */
    { .label = {  70910,  6, 0 } }, /* sakura */
    { .label = {  33023,  4, 1 } }, { .child = { 9698, 1 } }, /* sale */
    { .label = { 167233,  5, 0 } }, /* salon */
    { .label = { 117145,  8, 0 } }, /* samsclub */
    { .label = { 136656,  7, 0 } }, /* samsung */
    { .label = {  23431,  7, 0 } }, /* sandvik */
    { .label = {  23431, 15, 0 } }, /* sandvikcoromant */
    { .label = { 156180,  6, 0 } }, /* sanofi */
    { .label = {  33858,  3, 0 } }, /* sap */
    { .label = { 171395,  4, 0 } }, /* sarl */
    { .label = {   7009,  3, 0 } }, /* sas */
    { .label = {  17671,  4, 0 } }, /* save */
    { .label = { 171411,  4, 0 } }, /* saxo */
    { .label = {   2012,  3, 0 } }, /* sbi */
    { .label = {   5504,  3, 0 } }, /* sbs */
    { .label = {  14780,  3, 0 } }, /* sca */
    { .label = {  13442,  3, 0 } }, /* scb */
    { .label = {  77723, 10, 0 } }, /* schaeffler */
    { .label = { 136686,  7, 0 } }, /* schmidt */
    { .label = {  49517, 12, 0 } }, /* scholarships */
    { .label = { 121381,  6, 1 } }, { .child = { 9699, 1 } }, /* school */
    { .label = { 156205,  6, 0 } }, /* schule */
    { .label = { 136718,  7, 0 } }, /* schwarz */
    { .label = {   8888,  7, 1 } }, { .child = { 9700, 1 } }, /* science */
    { .label = {  96009,  9, 0 } }, /* scjohnson */
    { .label = { 109549,  4, 0 } }, /* scor */
    { .label = {  57501,  4, 1 } }, { .child = { 9701, 1 } }, /* scot */
    { .label = {  30266,  6, 0 } }, /* search */
    { .label = {  32573,  4, 0 } }, /* seat */
    { .label = {  50862,  6, 0 } }, /* secure */
    { .label = {  18034,  8, 0 } }, /* security */
    { .label = { 171428,  4, 0 } }, /* seek */
    { .label = { 156233,  6, 0 } }, /* select */
    { .label = { 167253,  5, 0 } }, /* sener */
    { .label = {  99632,  8, 1 } }, { .child = { 9702, 1 } }, /* services */
    { .label = {  24246,  3, 0 } }, /* ses */
    { .label = { 143441,  5, 0 } }, /* seven */
    { .label = {  64873,  3, 0 } }, /* sew */
    { .label = {   6360,  3, 0 } }, /* sex */
    { .label = { 171445,  4, 0 } }, /* sexy */
    { .label = {  95217,  3, 0 } }, /* sfr */
    { .label = {  96050,  9, 0 } }, /* shangrila */
    { .label = { 167273,  5, 0 } }, /* sharp */
    { .label = { 171465,  4, 0 } }, /* shaw */
    { .label = { 163126,  5, 0 } }, /* shell */
    { .label = {  19597,  4, 0 } }, /* shia */
    { .label = { 136752,  7, 0 } }, /* shiksha */
    { .label = { 167295,  5, 0 } }, /* shoes */
    { .label = {  52753,  4, 1 } }, { .child = { 9703, 1 } }, /* shop */
    { .label = { 117182,  8, 0 } }, /* shopping */
    { .label = { 156259,  6, 0 } }, /* shouji */
    { .label = { 117220,  4, 0 } }, /* show */
    { .label = { 117220,  8, 0 } }, /* showtime */
    { .label = { 136782,  7, 0 } }, /* shriram */
    { .label = { 169927,  4, 0 } }, /* silk */
    { .label = {  31824,  4, 0 } }, /* sina */
    { .label = { 136811,  7, 0 } }, /* singles */
    { .label = {    699,  4, 1 } }, { .child = { 9704, 9 } }, /* site */
    { .label = {   6533,  3, 0 } }, /* ski */
    { .label = {  81119,  4, 0 } }, /* skin */
    { .label = {  34693,  3, 0 } }, /* sky */
    { .label = { 167316,  5, 0 } }, /* skype */
    { .label = { 167341,  5, 0 } }, /* sling */
    { .label = {  17612,  5, 0 } }, /* smart */
    { .label = { 167363,  5, 0 } }, /* smile */
    { .label = { 171483,  4, 0 } }, /* sncf */
    { .label = { 156288,  6, 0 } }, /* soccer */
    { .label = {  31920,  6, 0 } }, /* social */
    { .label = { 117256,  8, 0 } }, /* softbank */
    { .label = {  99667,  8, 0 } }, /* software */
    { .label = { 171502,  4, 0 } }, /* sohu */
    { .label = { 167385,  5, 0 } }, /* solar */
    { .label = {  96087,  9, 0 } }, /* solutions */
    { .label = {  92912,  4, 0 } }, /* song */
    { .label = { 171520,  4, 0 } }, /* sony */
    { .label = {  15109,  3, 0 } }, /* soy */
    { .label = {  22510,  3, 0 } }, /* spa */
    { .label = {  40597,  5, 1 } }, { .child = { 9715, 4 } }, /* space */
    { .label = {  68414,  5, 0 } }, /* sport */
    { .label = { 119514,  4, 0 } }, /* spot */
    { .label = {  38763, 13, 0 } }, /* spreadbetting */
    { .label = {   2041,  3, 0 } }, /* srl */
    { .label = {  87240,  5, 0 } }, /* stada */
    { .label = { 136841,  7, 0 } }, /* staples */
    { .label = {  22063,  4, 0 } }, /* star */
    { .label = {  96125,  9, 0 } }, /* statebank */
    { .label = {  96162,  9, 0 } }, /* statefarm */
    { .label = {   8833,  3, 0 } }, /* stc */
    { .label = { 117292,  8, 0 } }, /* stcgroup */
    { .label = {  90454,  9, 0 } }, /* stockholm */
    { .label = { 136871,  7, 0 } }, /* storage */
    { .label = { 159058,  5, 1 } }, { .child = { 9719, 1 } }, /* store */
    { .label = { 156314,  6, 0 } }, /* stream */
    { .label = { 156338,  6, 0 } }, /* studio */
    { .label = { 167405,  5, 0 } }, /* study */
    { .label = {  95678,  5, 0 } }, /* style */
    { .label = { 167429,  5, 0 } }, /* sucks */
    { .label = { 117329,  8, 0 } }, /* supplies */
    { .label = { 156364,  6, 0 } }, /* supply */
    { .label = { 136899,  7, 1 } }, { .child = { 9720, 1 } }, /* support */
    { .label = { 171538,  4, 0 } }, /* surf */
    { .label = { 136932,  7, 0 } }, /* surgery */
    { .label = { 156396,  6, 0 } }, /* suzuki */
    { .label = { 156426,  6, 0 } }, /* swatch */
    { .label = {  77769, 10, 0 } }, /* swiftcover */
    { .label = { 167452,  5, 0 } }, /* swiss */
    { .label = { 150777,  6, 0 } }, /* sydney */
    { .label = { 117367,  8, 0 } }, /* symantec */
    { .label = {  25181,  7, 1 } }, { .child = { 9721, 1 } }, /* systems */
    { .label = {   3165,  3, 0 } }, /* tab */
    { .label = { 156453,  6, 0 } }, /* taipei */
    { .label = {  17026,  4, 0 } }, /* talk */
    { .label = { 156478,  6, 0 } }, /* taobao */
    { .label = { 156502,  6, 0 } }, /* target */
    { .label = {  77816, 10, 0 } }, /* tatamotors */
    { .label = {  67724,  5, 0 } }, /* tatar */
    { .label = { 156526,  6, 0 } }, /* tattoo */
    { .label = {   6361,  3, 0 } }, /* tax */
    { .label = { 169170,  4, 0 } }, /* taxi */
    { .label = {   5378,  3, 0 } }, /* tci */
    { .label = {  18005,  3, 0 } }, /* tdk */
    { .label = {  61714,  4, 1 } }, { .child = { 9722, 1 } }, /* team */
    { .label = {  65488,  4, 0 } }, /* tech */
    { .label = {  74093, 10, 1 } }, { .child = { 9723, 1 } }, /* technology */
    { .label = { 136964,  7, 0 } }, /* temasek */
    { .label = { 156549,  6, 0 } }, /* tennis */
    { .label = {  41954,  4, 0 } }, /* teva */
    { .label = {  39548,  3, 0 } }, /* thd */
    { .label = { 130245,  7, 0 } }, /* theater */
    { .label = { 136993,  7, 0 } }, /* theatre */
    { .label = {  41140,  4, 0 } }, /* tiaa */
    { .label = { 137021,  7, 0 } }, /* tickets */
    { .label = { 156573,  6, 0 } }, /* tienda */
    { .label = { 137051,  7, 0 } }, /* tiffany */
    { .label = { 171557,  4, 0 } }, /* tips */
    { .label = { 167474,  5, 0 } }, /* tires */
    { .label = {    516,  5, 0 } }, /* tirol */
    { .label = { 156597,  6, 0 } }, /* tjmaxx */
    { .label = {   7428,  3, 0 } }, /* tjx */
    { .label = { 156628,  6, 0 } }, /* tkmaxx */
    { .label = { 110148,  5, 0 } }, /* tmall */
    { .label = { 167494,  5, 0 } }, /* today */
    { .label = { 159731,  5, 0 } }, /* tokyo */
    { .label = {  80906,  5, 0 } }, /* tools */
    { .label = {   8601,  3, 1 } }, { .child = { 9724, 2 } }, /* top */
    { .label = { 167516,  5, 0 } }, /* toray */
    { .label = { 137084,  7, 0 } }, /* toshiba */
    { .label = { 167537,  5, 0 } }, /* total */
    { .label = { 167557,  5, 0 } }, /* tours */
    { .label = {  18239,  4, 0 } }, /* town */
    { .label = { 143715,  6, 0 } }, /* toyota */
    { .label = { 171575,  4, 0 } }, /* toys */
    { .label = { 142105,  5, 1 } }, { .child = { 9726, 1 } }, /* trade */
    { .label = { 121290,  7, 0 } }, /* trading */
    { .label = { 117402,  8, 0 } }, /* training */
    { .label = {  10017,  6, 0 } }, /* travel */
    { .label = {  38820, 13, 0 } }, /* travelchannel */
    { .label = {  10017,  9, 0 } }, /* travelers */
    { .label = {  10017, 18, 0 } }, /* travelersinsurance */
    { .label = {  76034,  5, 0 } }, /* trust */
    { .label = { 173041,  3, 0 } }, /* trv */
    { .label = {  53249,  4, 0 } }, /* tube */
    { .label = {  59068,  3, 0 } }, /* tui */
    { .label = { 167578,  5, 0 } }, /* tunes */
    { .label = { 167599,  5, 0 } }, /* tushu */
    { .label = { 173055,  3, 0 } }, /* tvs */
    { .label = { 167622,  5, 0 } }, /* ubank */
    { .label = {  55511,  3, 0 } }, /* ubs */
    { .label = { 156657,  6, 0 } }, /* unicom */
    { .label = {  74182, 10, 0 } }, /* university */
    { .label = {   1993,  3, 0 } }, /* uno */
    { .label = {   7564,  3, 0 } }, /* uol */
    { .label = {  13213,  3, 0 } }, /* ups */
    { .label = {  96199,  9, 0 } }, /* vacations */
    { .label = {  92077,  4, 0 } }, /* vana */
    { .label = { 117434,  8, 0 } }, /* vanguard */
    { .label = { 167645,  5, 0 } }, /* vegas */
    { .label = { 117469,  8, 0 } }, /* ventures */
    { .label = { 117504,  8, 0 } }, /* verisign */
    { .label = {  49570, 12, 0 } }, /* versicherung */
    { .label = {  53292,  3, 0 } }, /* vet */
    { .label = { 156684,  6, 0 } }, /* viajes */
    { .label = { 159291,  5, 0 } }, /* video */
    { .label = {  11494,  3, 0 } }, /* vig */
    { .label = { 150853,  6, 0 } }, /* viking */
    { .label = { 156712,  6, 0 } }, /* villas */
    { .label = {   6716,  3, 0 } }, /* vin */
    { .label = {  31136,  3, 0 } }, /* vip */
    { .label = { 111156,  6, 0 } }, /* virgin */
    { .label = {   9988,  4, 0 } }, /* visa */
    { .label = {  27539,  6, 0 } }, /* vision */
    { .label = { 170523,  4, 0 } }, /* viva */
    { .label = { 171593,  4, 0 } }, /* vivo */
    { .label = {  74315, 10, 0 } }, /* vlaanderen */
    { .label = { 167667,  5, 0 } }, /* vodka */
    { .label = {  77855, 10, 0 } }, /* volkswagen */
    { .label = { 167690,  5, 0 } }, /* volvo */
    { .label = { 171613,  4, 0 } }, /* vote */
    { .label = { 156739,  6, 0 } }, /* voting */
    { .label = { 171631,  4, 0 } }, /* voto */
    { .label = { 156766,  6, 0 } }, /* voyage */
    { .label = { 156794,  6, 0 } }, /* vuelos */
    { .label = { 163212,  5, 0 } }, /* wales */
    { .label = { 137114,  7, 0 } }, /* walmart */
    { .label = { 156822,  6, 0 } }, /* walter */
    { .label = { 128450,  4, 0 } }, /* wang */
    { .label = { 137144,  7, 0 } }, /* wanggou */
    { .label = {  20897,  5, 0 } }, /* watch */
    { .label = { 137176,  7, 0 } }, /* watches */
    { .label = {  30414,  7, 0 } }, /* weather */
    { .label = {  30414, 14, 0 } }, /* weatherchannel */
    { .label = { 156848,  6, 0 } }, /* webcam */
    { .label = { 167715,  5, 0 } }, /* weber */
    { .label = {    683,  7, 0 } }, /* website */
    { .label = {  29154,  3, 0 } }, /* wed */
    { .label = { 137207,  7, 0 } }, /* wedding */
    { .label = { 167739,  5, 0 } }, /* weibo */
    { .label = { 171649,  4, 0 } }, /* weir */
    { .label = { 137240,  7, 0 } }, /* whoswho */
    { .label = {    216,  4, 0 } }, /* wien */
    { .label = {  64917,  4, 0 } }, /* wiki */
    { .label = {  62060, 11, 0 } }, /* williamhill */
    { .label = {    479,  3, 0 } }, /* win */
    { .label = { 137274,  7, 0 } }, /* windows */
    { .label = {  15187,  4, 0 } }, /* wine */
    { .label = { 137307,  7, 0 } }, /* winners */
    { .label = {  61641,  3, 0 } }, /* wme */
    { .label = {  38876, 13, 0 } }, /* wolterskluwer */
    { .label = { 117539,  8, 0 } }, /* woodside */
    { .label = {  13832,  4, 1 } }, { .child = { 9727, 2 } }, /* work */
    { .label = { 111302,  5, 0 } }, /* works */
    { .label = { 167763,  5, 0 } }, /* world */
    { .label = { 114058,  3, 0 } }, /* wow */
    { .label = { 172741,  3, 0 } }, /* wtc */
    { .label = { 173069,  3, 0 } }, /* wtf */
    { .label = { 171667,  4, 0 } }, /* xbox */
    { .label = {  95282,  5, 0 } }, /* xerox */
    { .label = { 137337,  7, 0 } }, /* xfinity */
    { .label = { 156877,  6, 0 } }, /* xihuan */
    { .label = {   4018,  3, 0 } }, /* xin */
    { .label = {  62111, 11, 0 } }, /* xn--11b4c3d */
    { .label = {  62180, 11, 0 } }, /* xn--1ck2e1b */
    { .label = {  62244, 11, 0 } }, /* xn--1qqw23a */
    { .label = {  77901, 10, 0 } }, /* xn--30rr7y */
    { .label = {  62313, 11, 0 } }, /* xn--3bst00m */
    { .label = {  62376, 11, 0 } }, /* xn--3ds443g */
    { .label = {  12539, 17, 0 } }, /* xn--3oq18vl8pn36a */
    { .label = {  77960, 10, 0 } }, /* xn--3pxu8k */
    { .label = {  62444, 11, 0 } }, /* xn--42c2d9a */
    { .label = {  78019, 10, 0 } }, /* xn--45q11c */
    { .label = {  78086, 10, 0 } }, /* xn--4gbrim */
    { .label = {  62512, 11, 0 } }, /* xn--55qw42g */
    { .label = {  68558, 10, 0 } }, /* xn--55qx5d */
    { .label = {  12646, 17, 0 } }, /* xn--5su34j936bgsg */
    { .label = {  78139, 10, 0 } }, /* xn--5tzm5g */
    { .label = {  62586, 11, 0 } }, /* xn--6frz82g */
    { .label = {  30474, 14, 0 } }, /* xn--6qq986b3xl */
    { .label = {  49624, 12, 0 } }, /* xn--80adxhks */
    { .label = {  30572, 14, 0 } }, /* xn--80aqecdr1a */
    { .label = {  49689, 12, 0 } }, /* xn--80asehdb */
    { .label = {  78198, 10, 0 } }, /* xn--80aswg */
    { .label = {  49753, 12, 0 } }, /* xn--8y0a063a */
    { .label = {  78253, 10, 0 } }, /* xn--9dbq2a */
    { .label = {  78313, 10, 0 } }, /* xn--9et52u */
    { .label = {  62654, 11, 0 } }, /* xn--9krt00a */
    { .label = {  30649, 14, 0 } }, /* xn--b4w605ferd */
    { .label = {  12755, 17, 0 } }, /* xn--bck1b9a5dre4c */
    { .label = {  94634,  9, 0 } }, /* xn--c1avg */
    { .label = {  78373, 10, 0 } }, /* xn--c2br7g */
    { .label = {  62716, 11, 0 } }, /* xn--cck2b3b */
    { .label = {  38936, 13, 0 } }, /* xn--cckwcxetd */
    { .label = {  78430, 10, 0 } }, /* xn--cg4bki */
    { .label = {  62779, 11, 0 } }, /* xn--czr694b */
    { .label = {  78484, 10, 0 } }, /* xn--czrs0t */
    { .label = {  78536, 10, 0 } }, /* xn--czru2d */
    { .label = {  62849, 11, 0 } }, /* xn--d1acj3b */
    { .label = {  39001, 13, 0 } }, /* xn--eckvdtc9d */
    { .label = {  62911, 11, 0 } }, /* xn--efvy88h */
    { .label = {  62976, 11, 0 } }, /* xn--fct429k */
    { .label = {  96236,  9, 0 } }, /* xn--fhbei */
    { .label = {  30735, 14, 0 } }, /* xn--fiq228c5hs */
    { .label = {  78590, 10, 0 } }, /* xn--fiq64b */
    { .label = {  63043, 11, 0 } }, /* xn--fjq720a */
    { .label = {  63112, 11, 0 } }, /* xn--flw351e */
    { .label = {  16791, 16, 0 } }, /* xn--fzys8d69uvgm */
    { .label = {  63178, 11, 0 } }, /* xn--g2xx48c */
    { .label = {  49827, 12, 0 } }, /* xn--gckr3f0f */
    { .label = {  63246, 11, 0 } }, /* xn--gk3at1e */
    { .label = {  63303, 11, 0 } }, /* xn--hxt814e */
    { .label = {  23495, 15, 0 } }, /* xn--i1b6b1a6a2e */
    { .label = {  63368, 11, 0 } }, /* xn--imr513n */
    { .label = {  68624, 10, 0 } }, /* xn--io0a7i */
    { .label = {  96281,  9, 0 } }, /* xn--j1aef */
    { .label = {  30821, 14, 0 } }, /* xn--jlq480n2rg */
    { .label = {  30908, 14, 0 } }, /* xn--jlq61u9w7b */
    { .label = {  63430, 11, 0 } }, /* xn--jvr189m */
    { .label = {  23583, 15, 0 } }, /* xn--kcrx77d1x4a */
    { .label = {  63499, 11, 0 } }, /* xn--kpu716f */
    { .label = {  78652, 10, 0 } }, /* xn--kput3i */
    { .label = {  31001, 14, 0 } }, /* xn--mgba3a3ejt */
    { .label = {  16888, 16, 0 } }, /* xn--mgba7c0bbn0a */
    { .label = {  23672, 15, 0 } }, /* xn--mgbaakc7dvf */
    { .label = {  49894, 12, 0 } }, /* xn--mgbab2bd */
    { .label = {  31074, 14, 0 } }, /* xn--mgbca7dzdo */
    { .label = {  31148, 14, 0 } }, /* xn--mgbi4ecexp */
    { .label = {  49958, 12, 0 } }, /* xn--mgbt3dhd */
    { .label = {  50021, 12, 0 } }, /* xn--mk1bu44c */
    { .label = {  68768, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  50093, 12, 0 } }, /* xn--ngbc5azd */
    { .label = {  50157, 12, 0 } }, /* xn--ngbe9e0a */
    { .label = {  96329,  9, 0 } }, /* xn--ngbrx */
    { .label = {  23750,  9, 0 } }, /* xn--nqv7f */
    { .label = {  23750, 15, 0 } }, /* xn--nqv7fs00ema */
    { .label = {  63567, 11, 0 } }, /* xn--nyqy26a */
    { .label = {  63631, 11, 0 } }, /* xn--otu796d */
    { .label = {  96374,  9, 0 } }, /* xn--p1acf */
    { .label = {  63697, 11, 0 } }, /* xn--pbt977c */
    { .label = {  78704, 10, 0 } }, /* xn--pssy2u */
    { .label = {  63766, 11, 0 } }, /* xn--q9jyb4c */
    { .label = {  50221, 12, 0 } }, /* xn--qcka1pmc */
    { .label = {  63837, 11, 0 } }, /* xn--rhqv96g */
    { .label = {  63904, 11, 0 } }, /* xn--rovu88b */
    { .label = {  63967, 11, 0 } }, /* xn--ses554g */
    { .label = {  64031, 11, 0 } }, /* xn--t60b56a */
    { .label = {  96422,  9, 0 } }, /* xn--tckwe */
    { .label = {  39070, 13, 0 } }, /* xn--tiq49xqyj */
    { .label = {  78757, 10, 0 } }, /* xn--unup4y */
    { .label = {   1892, 23, 0 } }, /* xn--vermgensberater-ctb */
    { .label = {   1347, 24, 0 } }, /* xn--vermgensberatung-pwb */
    { .label = {  96466,  9, 0 } }, /* xn--vhquv */
    { .label = {  64099, 11, 0 } }, /* xn--vuq861b */
    { .label = {   4764, 20, 0 } }, /* xn--w4r85el8fhu5dnra */
    { .label = {  64170, 11, 0 } }, /* xn--w4rs40l */
    { .label = {  64235, 11, 0 } }, /* xn--xhq521b */
    { .label = {  64305, 11, 0 } }, /* xn--zfr164b */
    { .label = { 173085,  3, 1 } }, { .child = { 9729, 5 } }, /* xyz */
    { .label = { 156904,  6, 0 } }, /* yachts */
    { .label = { 167787,  5, 0 } }, /* yahoo */
    { .label = { 137371,  7, 0 } }, /* yamaxun */
    { .label = {  67656,  6, 0 } }, /* yandex */
    { .label = {  96516,  9, 0 } }, /* yodobashi */
    { .label = {  51918,  4, 0 } }, /* yoga */
    { .label = { 101326,  8, 0 } }, /* yokohama */
    { .label = {  11179,  3, 0 } }, /* you */
    { .label = {  66474,  7, 0 } }, /* youtube */
    { .label = {  68953,  3, 0 } }, /* yun */
    { .label = { 156931,  6, 0 } }, /* zappos */
    { .label = {   7471,  4, 0 } }, /* zara */
    { .label = { 143475,  4, 0 } }, /* zero */
    { .label = {  31135,  3, 0 } }, /* zip */
    { .label = {  41454,  4, 1 } }, { .child = { 9736, 4 } }, /* zone */
    { .label = { 137403,  7, 0 } }, /* zuerich */

    /* entries 1836 to 1841 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 1842 */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1843 to 1851 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6759,  3, 0 } }, /* sch */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1852 to 1937 */
    { .label = {   1997, 22, 0 } }, /* accident-investigation */
    { .label = {   5630, 19, 0 } }, /* accident-prevention */
    { .label = {  82226,  9, 0 } }, /* aerobatic */
    { .label = {  99461,  8, 0 } }, /* aeroclub */
    { .label = {  82263,  9, 0 } }, /* aerodrome */
    { .label = { 142029,  6, 0 } }, /* agents */
    { .label = {  99497,  8, 0 } }, /* aircraft */
    { .label = { 121108,  7, 0 } }, /* airline */
    { .label = { 121136,  7, 0 } }, /* airport */
    { .label = {  13927, 16, 0 } }, /* air-surveillance */
    { .label = {  67756, 10, 0 } }, /* airtraffic */
    { .label = {   5713, 19, 0 } }, /* air-traffic-control */
    { .label = {  82300,  9, 0 } }, /* ambulance */
    { .label = {  82340,  9, 0 } }, /* amusement */
    { .label = {   2766, 11, 0 } }, /* association */
    { .label = { 142053,  6, 0 } }, /* author */
    { .label = {  67799, 10, 0 } }, /* ballooning */
    { .label = { 142078,  6, 0 } }, /* broker */
    { .label = {    526,  3, 0 } }, /* caa */
    { .label = { 159037,  5, 0 } }, /* cargo */
    { .label = {  99530,  8, 0 } }, /* catering */
    { .label = {  32761, 13, 0 } }, /* certification */
    { .label = {  41646, 12, 0 } }, /* championship */
    { .label = { 121165,  7, 0 } }, /* charter */
    { .label = {  32816, 13, 0 } }, /* civilaviation */
    { .label = {  99476,  4, 0 } }, /* club */
    { .label = {  67843, 10, 0 } }, /* conference */
    { .label = {  67887, 10, 0 } }, /* consultant */
    { .label = {  67929, 10, 0 } }, /* consulting */
    { .label = {   5766,  7, 0 } }, /* control */
    { .label = { 121194,  7, 0 } }, /* council */
    { .label = { 169063,  4, 0 } }, /* crew */
    { .label = {  27302,  6, 0 } }, /* design */
    { .label = { 169082,  4, 0 } }, /* dgca */
    { .label = {  99563,  8, 0 } }, /* educator */
    { .label = {  82378,  9, 0 } }, /* emergency */
    { .label = {  32041,  6, 0 } }, /* engine */
    { .label = {  32041,  8, 0 } }, /* engineer */
    { .label = {  32872, 13, 0 } }, /* entertainment */
    { .label = {  35233,  9, 0 } }, /* equipment */
    { .label = {  41197,  8, 0 } }, /* exchange */
    { .label = {  23332,  7, 0 } }, /* express */
    { .label = {  67973, 10, 0 } }, /* federation */
    { .label = { 135423,  6, 0 } }, /* flight */
    { .label = { 169100,  4, 0 } }, /* fuel */
    { .label = {  52980,  7, 0 } }, /* gliding */
    { .label = {  68015, 10, 0 } }, /* government */
    { .label = {  25378, 14, 0 } }, /* groundhandling */
    { .label = {  41733,  5, 0 } }, /* group */
    { .label = {  52963, 11, 0 } }, /* hanggliding */
    { .label = {  82419,  9, 0 } }, /* homebuilt */
    { .label = {   1529,  9, 0 } }, /* insurance */
    { .label = {  68059,  7, 0 } }, /* journal */
    { .label = {  68059, 10, 0 } }, /* journalist */
    { .label = { 121226,  7, 0 } }, /* leasing */
    { .label = {  30375,  9, 0 } }, /* logistics */
    { .label = {  99597,  8, 0 } }, /* magazine */
    { .label = {  53012, 11, 0 } }, /* maintenance */
    { .label = {  98775,  5, 0 } }, /* media */
    { .label = {  68103, 10, 0 } }, /* microlight */
    { .label = {  82461,  9, 0 } }, /* modelling */
    { .label = {  68148, 10, 0 } }, /* navigation */
    { .label = {  53056, 11, 0 } }, /* parachuting */
    { .label = {  53104, 11, 0 } }, /* paragliding */
    { .label = {   2723, 21, 0 } }, /* passenger-association */
    { .label = { 150535,  5, 0 } }, /* pilot */
    { .label = {  23342,  5, 0 } }, /* press */
    { .label = {  61865, 10, 0 } }, /* production */
    { .label = {  68189, 10, 0 } }, /* recreation */
    { .label = { 121255,  7, 0 } }, /* repbody */
    { .label = {  23348,  3, 0 } }, /* res */
    { .label = {  30258,  8, 0 } }, /* research */
    { .label = {  68229, 10, 0 } }, /* rotorcraft */
    { .label = {  13208,  6, 0 } }, /* safety */
    { .label = {  82502,  9, 0 } }, /* scientist */
    { .label = {  99632,  8, 0 } }, /* services */
    { .label = { 117220,  4, 0 } }, /* show */
    { .label = {  82539,  9, 0 } }, /* skydiving */
    { .label = {  99667,  8, 0 } }, /* software */
    { .label = {  51425,  7, 0 } }, /* student */
    { .label = { 142105,  6, 0 } }, /* trader */
    { .label = { 121290,  7, 0 } }, /* trading */
    { .label = {   5515,  7, 0 } }, /* trainer */
    { .label = {  61458,  5, 0 } }, /* union */
    { .label = {  41701, 12, 0 } }, /* workinggroup */
    { .label = { 111302,  5, 0 } }, /* works */

    /* entries 1938 to 1943 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1944 to 1948 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1949 to 1954 */
    { .label = {  39607,  3, 0 } }, /* off */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  55252,  3, 0 } }, /* uwu */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1955 to 1962 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1963 to 1970 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 121319,  7, 0 } }, /* commune */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = { 162188,  4, 0 } }, /* neko */
    { .label = { 157831,  4, 0 } }, /* nyaa */

    /* entries 1971 to 1976 */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {   9350,  2, 0 } }, /* gv */
    { .label = {   1288,  2, 0 } }, /* og */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     56,  2, 0 } }, /* pb */
    { .label = {    151,  2, 0 } }, /* it */

    /* entries 1977 to 1987 */
    { .label = {    106,  3, 1 } }, { .child = { 1988, 1 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = { 142129,  6, 0 } }, /* musica */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4488,  3, 0 } }, /* tur */

    /* entry 1988 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 1989 to 1994 */
    { .label = { 169120,  4, 0 } }, /* e164 */
    { .label = { 121351,  7, 0 } }, /* in-addr */
    { .label = { 172615,  3, 0 } }, /* ip6 */
    { .label = {  64116,  4, 0 } }, /* iris */
    { .label = {   6746,  3, 0 } }, /* uri */
    { .label = {   1375,  3, 0 } }, /* urn */

    /* entry 1995 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entry 1996 */
    { .label = { 137772,  7, 0 } }, /* cloudns */

    /* entries 1997 to 2015 */
    { .label = {    103,  2, 1 } }, { .child = { 2016, 1 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 2017, 1 } }, /* co */
    { .label = {   9350,  2, 0 } }, /* gv */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  98121,  9, 1 } }, { .child = { 2018, 3 } }, /* futurecms */
    { .label = {  40827, 13, 0 } }, /* futurehosting */
    { .label = {  40885, 13, 0 } }, /* futuremailing */
    { .label = { 119424,  8, 1 } }, { .child = { 2025, 2 } }, /* ortsinfo */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = { 172522,  4, 0 } }, /* 12hp */
    { .label = { 173261,  3, 0 } }, /* 2ix */
    { .label = { 168921,  5, 0 } }, /* 4lima */
    { .label = {  99213,  9, 0 } }, /* lima-city */

    /* entry 2016 */
    { .label = {  10151,  3, 0 } }, /* sth */

    /* entry 2017 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 2018 to 2022 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {   1562,  2, 1 } }, { .child = { 2023, 1 } }, /* ex */
    { .label = {    100,  2, 1 } }, { .child = { 2024, 1 } }, /* in */

    /* entry 2023 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2024 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2025 to 2028 */
    { .label = {   1562,  2, 1 } }, { .child = { 2029, 1 } }, /* ex */
    { .label = { 157683,  6, 1 } }, { .child = { 2030, 1 } }, /* kunden */

    /* entry 2029 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2030 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2031 to 2051 */
    { .label = {    106,  3, 1 } }, { .child = { 2052, 1 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 1 } }, { .child = { 2053, 9 } }, /* edu */
    { .label = {   3879,  3, 1 } }, { .child = { 2066, 5 } }, /* gov */
    { .label = {   6774,  3, 0 } }, /* asn */
    { .label = {    143,  2, 0 } }, /* id */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  65725,  4, 0 } }, /* conf */
    { .label = {   3283,  2, 0 } }, /* oz */
    { .label = {  13628,  3, 0 } }, /* act */
    { .label = { 150746,  3, 0 } }, /* nsw */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = { 111168,  3, 0 } }, /* qld */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {   5596,  3, 0 } }, /* tas */
    { .label = {  31390,  3, 0 } }, /* vic */
    { .label = {    181,  2, 0 } }, /* wa */

    /* entry 2052 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 2053 to 2063 */
    { .label = {  13628,  3, 0 } }, /* act */
    { .label = {  99702,  8, 0 } }, /* catholic */
    { .label = { 150746,  3, 1 } }, { .child = { 2064, 1 } }, /* nsw */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = { 111168,  3, 0 } }, /* qld */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {   5596,  3, 1 } }, { .child = { 2065, 1 } }, /* tas */
    { .label = {  31390,  3, 0 } }, /* vic */
    { .label = {    181,  2, 0 } }, /* wa */

    /* entry 2064 */
    { .label = { 121381,  7, 0 } }, /* schools */

    /* entry 2065 */
    { .label = {  44279,  9, 0 } }, /* education */

    /* entries 2066 to 2070 */
    { .label = { 111168,  3, 0 } }, /* qld */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {   5596,  3, 0 } }, /* tas */
    { .label = {  31390,  3, 0 } }, /* vic */
    { .label = {    181,  2, 0 } }, /* wa */

    /* entry 2071 */
    { .label = {    106,  3, 0 } }, /* com */

    /* entries 2072 to 2079 */
    { .label = {    555,  2, 0 } }, /* be */
    { .label = {    417,  3, 0 } }, /* cat */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   2994,  2, 0 } }, /* eu */
    { .label = {   2677,  2, 0 } }, /* gg */
    { .label = {   4288,  2, 0 } }, /* mc */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = {  19331,  2, 0 } }, /* xy */

    /* entries 2080 to 2091 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {   6845,  2, 0 } }, /* pp */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  23387,  3, 0 } }, /* pro */
    { .label = {   3641,  3, 0 } }, /* biz */

    /* entries 2092 to 2098 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 2099 to 2108 */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 159058,  5, 0 } }, /* store */
    { .label = {   1222,  2, 0 } }, /* tv */

    /* entry 2109 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2110 to 2114 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  79176, 10, 0 } }, /* webhosting */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = { 120777,  8, 1 } }, { .child = { 2115, 1 } }, /* transurl */

    /* entry 2115 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2116 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 2117 to 2154 */
    { .label = {     26,  1, 0 } }, /* a */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = {     19,  1, 0 } }, /* c */
    { .label = {     30,  1, 0 } }, /* d */
    { .label = {     25,  1, 0 } }, /* e */
    { .label = {     68,  1, 0 } }, /* f */
    { .label = {      9,  1, 0 } }, /* g */
    { .label = {     90,  1, 0 } }, /* h */
    { .label = {     27,  1, 0 } }, /* i */
    { .label = {     50,  1, 0 } }, /* j */
    { .label = {     24,  1, 0 } }, /* k */
    { .label = {     79,  1, 0 } }, /* l */
    { .label = {     29,  1, 0 } }, /* m */
    { .label = {     28,  1, 0 } }, /* n */
    { .label = {     21,  1, 0 } }, /* o */
    { .label = {     41,  1, 0 } }, /* p */
    { .label = {    215,  1, 0 } }, /* q */
    { .label = {      1,  1, 0 } }, /* r */
    { .label = {      2,  1, 0 } }, /* s */
    { .label = {     10,  1, 0 } }, /* t */
    { .label = {     46,  1, 0 } }, /* u */
    { .label = {     54,  1, 0 } }, /* v */
    { .label = {      8,  1, 0 } }, /* w */
    { .label = {     20,  1, 0 } }, /* x */
    { .label = {     38,  1, 0 } }, /* y */
    { .label = {    202,  1, 0 } }, /* z */
    { .label = {      3,  1, 0 } }, /* 0 */
    { .label = {    176,  1, 0 } }, /* 1 */
    { .label = {      6,  1, 0 } }, /* 2 */
    { .label = {      7,  1, 0 } }, /* 3 */
    { .label = {    231,  1, 0 } }, /* 4 */
    { .label = {     49,  1, 0 } }, /* 5 */
    { .label = {    439,  1, 0 } }, /* 6 */
    { .label = {   1654,  1, 0 } }, /* 7 */
    { .label = {    741,  1, 0 } }, /* 8 */
    { .label = {    177,  1, 0 } }, /* 9 */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  66658,  5, 0 } }, /* barsy */

    /* entries 2155 to 2159 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 2160 to 2164 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2165 to 2178 */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = {  31475,  6, 0 } }, /* dyndns */
    { .label = {  79537, 10, 0 } }, /* for-better */
    { .label = {  39886,  8, 0 } }, /* for-more */
    { .label = { 118097,  8, 0 } }, /* for-some */
    { .label = { 138186,  7, 0 } }, /* for-the */
    { .label = { 157231,  6, 0 } }, /* selfip */
    { .label = { 157260,  6, 0 } }, /* webhop */
    { .label = {  32053,  3, 0 } }, /* bpl */
    { .label = {   5490,  3, 0 } }, /* orx */
    { .label = { 158260,  6, 0 } }, /* mmafan */
    { .label = { 168545,  5, 0 } }, /* myftp */
    { .label = { 168522,  5, 0 } }, /* no-ip */
    { .label = { 141473,  7, 0 } }, /* dscloud */

    /* entries 2179 to 2182 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = { 121412,  7, 0 } }, /* barreau */
    { .label = { 169150,  4, 0 } }, /* gouv */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 2183 to 2187 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2188 to 2193 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 2194 to 2234 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {  99737,  8, 0 } }, /* academia */
    { .label = {  95557,  4, 0 } }, /* agro */
    { .label = {  17621,  4, 0 } }, /* arte */
    { .label = {  17228,  4, 0 } }, /* blog */
    { .label = { 121441,  7, 0 } }, /* bolivia */
    { .label = { 121473,  7, 0 } }, /* ciencia */
    { .label = {  53152, 11, 0 } }, /* cooperativa */
    { .label = {  68271, 10, 0 } }, /* democracia */
    { .label = { 121502,  7, 0 } }, /* deporte */
    { .label = {  99769,  8, 0 } }, /* ecologia */
    { .label = {  99803,  8, 0 } }, /* economia */
    { .label = { 121533,  7, 0 } }, /* empresa */
    { .label = {  99836,  8, 0 } }, /* indigena */
    { .label = {  82582,  9, 0 } }, /* industria */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  99869,  8, 0 } }, /* medicina */
    { .label = {  68313, 10, 0 } }, /* movimiento */
    { .label = { 142129,  6, 0 } }, /* musica */
    { .label = {   4481,  7, 0 } }, /* natural */
    { .label = { 142155,  6, 0 } }, /* nombre */
    { .label = {  99903,  8, 0 } }, /* noticias */
    { .label = { 142182,  6, 0 } }, /* patria */
    { .label = {  99935,  8, 0 } }, /* politica */
    { .label = {  53199, 11, 0 } }, /* profesional */
    { .label = {  32924, 13, 0 } }, /* plurinacional */
    { .label = { 142206,  6, 0 } }, /* pueblo */
    { .label = { 121563,  7, 0 } }, /* revista */
    { .label = { 159078,  5, 0 } }, /* salud */
    { .label = {  68357, 10, 0 } }, /* tecnologia */
    { .label = { 159100,  5, 0 } }, /* tksat */
    { .label = {  68399, 10, 0 } }, /* transporte */
    { .label = {  64917,  4, 0 } }, /* wiki */

    /* entries 2235 to 2367 */
    { .label = { 142236,  6, 0 } }, /* 9guacu */
    { .label = {   2536,  3, 0 } }, /* abc */
    { .label = {  10291,  3, 0 } }, /* adm */
    { .label = {   3989,  3, 0 } }, /* adv */
    { .label = {  10494,  3, 0 } }, /* agr */
    { .label = {  17525,  3, 0 } }, /* aju */
    { .label = {     26,  2, 0 } }, /* am */
    { .label = {  43247,  5, 0 } }, /* anani */
    { .label = {  82619,  9, 0 } }, /* aparecida */
    { .label = {  52846,  3, 0 } }, /* arq */
    { .label = {   7959,  3, 0 } }, /* art */
    { .label = {   5924,  3, 0 } }, /* ato */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = { 121592,  7, 0 } }, /* barueri */
    { .label = { 159120,  5, 0 } }, /* belem */
    { .label = {  63387,  3, 0 } }, /* bhz */
    { .label = {  44643,  3, 0 } }, /* bio */
    { .label = {  17228,  4, 0 } }, /* blog */
    { .label = {  94284,  3, 0 } }, /* bmd */
    { .label = {  99970,  8, 0 } }, /* boavista */
    { .label = {  89073,  3, 0 } }, /* bsb */
    { .label = {  32980, 13, 0 } }, /* campinagrande */
    { .label = { 100004,  8, 0 } }, /* campinas */
    { .label = { 142269,  6, 0 } }, /* caxias */
    { .label = {  98222,  3, 0 } }, /* cim */
    { .label = {   5597,  3, 0 } }, /* cng */
    { .label = {  11227,  3, 0 } }, /* cnt */
    { .label = {    106,  3, 1 } }, { .child = { 2368, 1 } }, /* com */
    { .label = { 100038,  8, 0 } }, /* contagem */
    { .label = {  53152,  4, 0 } }, /* coop */
    { .label = {   1462,  3, 0 } }, /* cri */
    { .label = { 142294,  6, 0 } }, /* cuiaba */
    { .label = { 100072,  8, 0 } }, /* curitiba */
    { .label = {  15399,  3, 0 } }, /* def */
    { .label = {  24306,  3, 0 } }, /* ecn */
    { .label = {    102,  3, 0 } }, /* eco */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  19252,  3, 0 } }, /* emp */
    { .label = {   2740,  3, 0 } }, /* eng */
    { .label = {  10272,  3, 0 } }, /* esp */
    { .label = {  20902,  3, 0 } }, /* etc */
    { .label = {    421,  3, 0 } }, /* eti */
    { .label = {  10813,  3, 0 } }, /* far */
    { .label = { 159144,  5, 0 } }, /* feira */
    { .label = {  43446,  4, 0 } }, /* flog */
    { .label = { 121622,  7, 0 } }, /* floripa */
    { .label = {   3284,  2, 0 } }, /* fm */
    { .label = { 165362,  3, 0 } }, /* fnd */
    { .label = { 142320,  6, 0 } }, /* fortal */
    { .label = {  77601,  3, 0 } }, /* fot */
    { .label = { 157461,  3, 0 } }, /* foz */
    { .label = {  38333,  3, 0 } }, /* fst */
    { .label = { 172634,  3, 0 } }, /* g12 */
    { .label = { 172655,  3, 0 } }, /* ggf */
    { .label = { 121654,  7, 0 } }, /* goiania */
    { .label = {   3879,  3, 1 } }, { .child = { 2369, 27 } }, /* gov */
    { .label = {   6761,  3, 0 } }, /* gru */
    { .label = {  36632,  3, 0 } }, /* imb */
    { .label = {   8930,  3, 0 } }, /* ind */
    { .label = {   5509,  3, 0 } }, /* inf */
    { .label = {   3162,  3, 0 } }, /* jab */
    { .label = { 159165,  5, 0 } }, /* jampa */
    { .label = { 172671,  3, 0 } }, /* jdf */
    { .label = {  82656,  9, 0 } }, /* joinville */
    { .label = {   1535,  3, 0 } }, /* jor */
    { .label = {  14035,  3, 0 } }, /* jus */
    { .label = {  27613,  3, 1 } }, { .child = { 2396, 27 } }, /* leg */
    { .label = {  19822,  3, 0 } }, /* lel */
    { .label = { 100107,  8, 0 } }, /* londrina */
    { .label = { 142346,  6, 0 } }, /* macapa */
    { .label = { 142371,  6, 0 } }, /* maceio */
    { .label = { 142396,  6, 0 } }, /* manaus */
    { .label = { 121681,  7, 0 } }, /* maringa */
    { .label = {  11246,  3, 0 } }, /* mat */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = { 142420,  6, 0 } }, /* morena */
    { .label = {   6840,  2, 0 } }, /* mp */
    { .label = {   4540,  3, 0 } }, /* mus */
    { .label = {  65960,  5, 0 } }, /* natal */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = { 121709,  7, 0 } }, /* niteroi */
    { .label = {   1460,  3, 1 } }, { .child = { 2423, 1 } }, /* nom */
    { .label = {  17547,  3, 0 } }, /* not */
    { .label = {   5775,  3, 0 } }, /* ntr */
    { .label = {  19741,  3, 0 } }, /* odo */
    { .label = {   1425,  3, 0 } }, /* ong */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 142444,  6, 0 } }, /* osasco */
    { .label = { 142468,  6, 0 } }, /* palmas */
    { .label = {  27023,  3, 0 } }, /* poa */
    { .label = { 172689,  3, 0 } }, /* ppg */
    { .label = {  23387,  3, 0 } }, /* pro */
    { .label = {  18105,  3, 0 } }, /* psc */
    { .label = {  82012,  3, 0 } }, /* psi */
    { .label = { 172706,  3, 0 } }, /* pvh */
    { .label = { 172723,  3, 0 } }, /* qsl */
    { .label = {  51113,  5, 0 } }, /* radio */
    { .label = {  13663,  3, 0 } }, /* rec */
    { .label = { 142494,  6, 0 } }, /* recife */
    { .label = { 100140,  8, 0 } }, /* ribeirao */
    { .label = {   3773,  3, 0 } }, /* rio */
    { .label = {  82699,  9, 0 } }, /* riobranco */
    { .label = { 100173,  8, 0 } }, /* riopreto */
    { .label = {  45099,  8, 0 } }, /* salvador */
    { .label = { 159189,  5, 0 } }, /* sampa */
    { .label = {  68440, 10, 0 } }, /* santamaria */
    { .label = {  68477, 10, 0 } }, /* santoandre */
    { .label = {  53247, 11, 0 } }, /* saobernardo */
    { .label = { 100207,  8, 0 } }, /* saogonca */
    { .label = { 172740,  3, 0 } }, /* sjc */
    { .label = { 172756,  3, 0 } }, /* slg */
    { .label = {  14912,  3, 0 } }, /* slz */
    { .label = { 100239,  8, 0 } }, /* sorocaba */
    { .label = { 172770,  3, 0 } }, /* srv */
    { .label = { 169170,  4, 0 } }, /* taxi */
    { .label = {     53,  2, 0 } }, /* tc */
    { .label = {   6729,  3, 0 } }, /* teo */
    { .label = {    746,  3, 0 } }, /* the */
    { .label = {  65998,  3, 0 } }, /* tmp */
    { .label = {   2418,  3, 0 } }, /* trd */
    { .label = {   4488,  3, 0 } }, /* tur */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {  21379,  3, 0 } }, /* udi */
    { .label = {  53292,  3, 0 } }, /* vet */
    { .label = { 161348,  3, 0 } }, /* vix */
    { .label = { 169187,  4, 0 } }, /* vlog */
    { .label = {  64917,  4, 0 } }, /* wiki */
    { .label = {  36513,  3, 0 } }, /* zlg */

    /* entry 2368 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 2369 to 2395 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {     26,  2, 0 } }, /* am */
    { .label = {    321,  2, 0 } }, /* ap */
    { .label = {    118,  2, 0 } }, /* ba */
    { .label = {    315,  2, 0 } }, /* ce */
    { .label = {  14039,  2, 0 } }, /* df */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {    194,  2, 0 } }, /* ma */
    { .label = {   1381,  2, 0 } }, /* mg */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {    158,  2, 0 } }, /* mt */
    { .label = {    490,  2, 0 } }, /* pa */
    { .label = {     56,  2, 0 } }, /* pb */
    { .label = {   5481,  2, 0 } }, /* pe */
    { .label = {    470,  2, 0 } }, /* pi */
    { .label = {   1283,  2, 0 } }, /* pr */
    { .label = {   1872,  2, 0 } }, /* rj */
    { .label = {    157,  2, 0 } }, /* rn */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {     51,  2, 0 } }, /* rr */
    { .label = {     48,  2, 0 } }, /* rs */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {     52,  2, 0 } }, /* sp */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entries 2396 to 2422 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {     26,  2, 0 } }, /* am */
    { .label = {    321,  2, 0 } }, /* ap */
    { .label = {    118,  2, 0 } }, /* ba */
    { .label = {    315,  2, 0 } }, /* ce */
    { .label = {  14039,  2, 0 } }, /* df */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {    194,  2, 0 } }, /* ma */
    { .label = {   1381,  2, 0 } }, /* mg */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {    158,  2, 0 } }, /* mt */
    { .label = {    490,  2, 0 } }, /* pa */
    { .label = {     56,  2, 0 } }, /* pb */
    { .label = {   5481,  2, 0 } }, /* pe */
    { .label = {    470,  2, 0 } }, /* pi */
    { .label = {   1283,  2, 0 } }, /* pr */
    { .label = {   1872,  2, 0 } }, /* rj */
    { .label = {    157,  2, 0 } }, /* rn */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {     51,  2, 0 } }, /* rr */
    { .label = {     48,  2, 0 } }, /* rs */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {     52,  2, 0 } }, /* sp */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entry 2423 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2424 to 2429 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    266,  2, 0 } }, /* we */

    /* entries 2430 to 2434 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2435 to 2436 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2437 to 2442 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    106,  3, 1 } }, { .child = { 2443, 1 } }, /* com */
    { .label = {   5403,  2, 0 } }, /* of */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entry 2443 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 2444 to 2451 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   2924,  2, 0 } }, /* za */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 2452 to 2472 */
    { .label = {     74,  2, 0 } }, /* ab */
    { .label = {   2539,  2, 0 } }, /* bc */
    { .label = {   5584,  2, 0 } }, /* mb */
    { .label = {    241,  2, 0 } }, /* nb */
    { .label = {    161,  2, 0 } }, /* nf */
    { .label = {   2989,  2, 0 } }, /* nl */
    { .label = {    230,  2, 0 } }, /* ns */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = {   1501,  2, 0 } }, /* nu */
    { .label = {    121,  2, 0 } }, /* on */
    { .label = {   5481,  2, 0 } }, /* pe */
    { .label = {  12340,  2, 0 } }, /* qc */
    { .label = {    312,  2, 0 } }, /* sk */
    { .label = {  10212,  2, 0 } }, /* yk */
    { .label = {    639,  2, 0 } }, /* gc */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = { 167830,  5, 1 } }, { .child = { 2473, 1 } }, /* awdev */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = { 168522,  5, 0 } }, /* no-ip */

    /* entry 2473 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2474 to 2480 */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = {  97260,  9, 0 } }, /* ftpaccess */
    { .label = {  65082, 11, 0 } }, /* game-server */
    { .label = { 118380,  8, 0 } }, /* myphotos */
    { .label = {  97658,  9, 0 } }, /* scrapping */
    { .label = { 157431,  6, 0 } }, /* twmail */
    { .label = {  41119, 13, 0 } }, /* fantasyleague */

    /* entry 2481 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entry 2482 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 2483 to 2491 */
    { .label = { 137597,  7, 0 } }, /* square7 */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  32393, 14, 0 } }, /* linkyard-cloud */
    { .label = { 120128,  7, 0 } }, /* dnsking */
    { .label = { 157148,  6, 0 } }, /* gotdns */
    { .label = { 172522,  4, 0 } }, /* 12hp */
    { .label = { 173261,  3, 0 } }, /* 2ix */
    { .label = { 168921,  5, 0 } }, /* 4lima */
    { .label = {  99213,  9, 0 } }, /* lima-city */

    /* entries 2492 to 2508 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {  18309, 15, 0 } }, /* xn--aroport-bya */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = { 142521,  6, 0 } }, /* presse */
    { .label = {   6836,  2, 0 } }, /* md */
    { .label = { 169150,  4, 0 } }, /* gouv */
    { .label = {   3951,  3, 0 } }, /* fin */
    { .label = {   2989,  2, 0 } }, /* nl */

    /* entries 2509 to 2511 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 158125,  3, 1 } }, { .child = { 2512, 1 } }, /* www */

    /* entry 2512 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 2513 to 2519 */
    { .label = {  68516, 10, 0 } }, /* aprendemas */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 2520 to 2523 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */

    /* entries 2524 to 2569 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    106,  3, 1 } }, { .child = { 2570, 1 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  68558, 10, 0 } }, /* xn--55qx5d */
    { .label = {  68624, 10, 0 } }, /* xn--io0a7i */
    { .label = {  68676, 10, 0 } }, /* xn--od0alg */
    { .label = {   1500,  2, 0 } }, /* ah */
    { .label = {  17893,  2, 0 } }, /* bj */
    { .label = {   5425,  2, 0 } }, /* cq */
    { .label = {   4709,  2, 0 } }, /* fj */
    { .label = {    567,  2, 0 } }, /* gd */
    { .label = {    337,  2, 0 } }, /* gs */
    { .label = {   1657,  2, 0 } }, /* gz */
    { .label = {     17,  2, 0 } }, /* gx */
    { .label = {   2443,  2, 0 } }, /* ha */
    { .label = {     90,  2, 0 } }, /* hb */
    { .label = {    750,  2, 0 } }, /* he */
    { .label = {    195,  2, 0 } }, /* hi */
    { .label = {   3680,  2, 0 } }, /* hl */
    { .label = {   1496,  2, 0 } }, /* hn */
    { .label = {  10049,  2, 0 } }, /* jl */
    { .label = {  12224,  2, 0 } }, /* js */
    { .label = {   7432,  2, 0 } }, /* jx */
    { .label = {    247,  2, 0 } }, /* ln */
    { .label = {    201,  2, 0 } }, /* nm */
    { .label = {    130,  2, 0 } }, /* nx */
    { .label = {  53005,  2, 0 } }, /* qh */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {    253,  2, 0 } }, /* sd */
    { .label = {    682,  2, 0 } }, /* sh */
    { .label = {   1414,  2, 0 } }, /* sn */
    { .label = {    441,  2, 0 } }, /* sx */
    { .label = {   2411,  2, 0 } }, /* tj */
    { .label = {  37690,  2, 0 } }, /* xj */
    { .label = {    582,  2, 0 } }, /* xz */
    { .label = {   2785,  2, 0 } }, /* yn */
    { .label = {  21402,  2, 0 } }, /* zj */
    { .label = {   4289,  2, 0 } }, /* hk */
    { .label = {   3360,  2, 0 } }, /* mo */
    { .label = {   4802,  2, 0 } }, /* tw */
    { .label = {  52585, 12, 0 } }, /* instantcloud */

    /* entries 2570 to 2571 */
    { .label = {  96595,  9, 1 } }, { .child = { 2572, 4 } }, /* amazonaws */

    /* entries 2572 to 2579 */
    { .label = {  20300,  7, 1 } }, { .child = { 2580, 1 } }, /* compute */
    { .label = {    689,  2, 1 } }, { .child = { 2581, 2 } }, /* eb */
    { .label = {  41422,  3, 1 } }, { .child = { 2583, 1 } }, /* elb */
    { .label = {  78941, 10, 1 } }, { .child = { 2584, 1 } }, /* cn-north-1 */

    /* entry 2580 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2581 to 2582 */
    { .label = {  78941, 10, 0 } }, /* cn-north-1 */
    { .label = {  31222, 14, 0 } }, /* cn-northwest-1 */

    /* entry 2583 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2584 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2585 to 2608 */
    { .label = {   7959,  4, 0 } }, /* arts */
    { .label = {    106,  3, 1 } }, { .child = { 2609, 1 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = { 116161,  4, 0 } }, /* firm */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13663,  3, 0 } }, /* rec */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = { 167854,  5, 0 } }, /* carrd */
    { .label = {  45093,  3, 0 } }, /* crd */
    { .label = { 171749,  4, 1 } }, { .child = { 2610, 1 } }, /* otap */
    { .label = {  98530,  9, 0 } }, /* leadpages */
    { .label = {  10253,  6, 0 } }, /* lpages */
    { .label = { 172236,  4, 0 } }, /* mypi */
    { .label = { 173206,  3, 0 } }, /* n4t */
    { .label = { 168618,  5, 0 } }, /* nodum */
    { .label = { 172435,  4, 0 } }, /* repl */

    /* entry 2609 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entry 2610 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2611 to 2958 */
    { .label = {  39152, 13, 1 } }, { .child = { 2959, 1 } }, /* adobeaemcloud */
    { .label = {  96557,  9, 0 } }, /* kasserver */
    { .label = {  96595,  9, 1 } }, { .child = { 2962, 42 } }, /* amazonaws */
    { .label = {  16976, 16, 1 } }, { .child = { 3076, 17 } }, /* elasticbeanstalk */
    { .label = {  78989, 10, 0 } }, /* on-aptible */
    { .label = {  96719,  9, 0 } }, /* myasustor */
    { .label = {  31351, 14, 0 } }, /* balena-devices */
    { .label = {  79034, 10, 0 } }, /* betainabox */
    { .label = { 137634,  7, 0 } }, /* bplaced */
    { .label = {     45,  2, 0 } }, /* ar */
    { .label = {    294,  2, 0 } }, /* br */
    { .label = {   2854,  2, 0 } }, /* cn */
    { .label = {    243,  2, 0 } }, /* de */
    { .label = {   2994,  2, 0 } }, /* eu */
    { .label = {   1450,  2, 0 } }, /* gb */
    { .label = {   1370,  2, 0 } }, /* hu */
    { .label = { 153009,  3, 0 } }, /* jpn */
    { .label = {     43,  2, 0 } }, /* kr */
    { .label = {  90148,  3, 0 } }, /* mex */
    { .label = {    188,  2, 0 } }, /* no */
    { .label = {  12340,  2, 0 } }, /* qc */
    { .label = {    204,  2, 0 } }, /* ru */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {   2514,  2, 0 } }, /* uk */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = {    223,  2, 0 } }, /* uy */
    { .label = {   2924,  2, 0 } }, /* za */
    { .label = {  72975,  6, 0 } }, /* africa */
    { .label = {   4597,  2, 0 } }, /* gr */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  39340, 13, 0 } }, /* xenapponazure */
    { .label = {  96838,  9, 0 } }, /* jdevcloud */
    { .label = {  79125, 10, 0 } }, /* wpdevcloud */
    { .label = {  23980, 15, 0 } }, /* cloudcontrolled */
    { .label = {  24048, 15, 0 } }, /* cloudcontrolapp */
    { .label = {  39400, 13, 0 } }, /* trycloudflare */
    { .label = {  50938, 12, 1 } }, { .child = { 3093, 4 } }, /* customer-oci */
    { .label = {  79312, 10, 0 } }, /* dattolocal */
    { .label = {  79354, 10, 0 } }, /* dattorelay */
    { .label = { 117850,  8, 0 } }, /* dattoweb */
    { .label = { 137867,  7, 0 } }, /* mydatto */
    { .label = {  39514, 13, 0 } }, /* builtwithdark */
    { .label = { 117923,  8, 0 } }, /* drayddns */
    { .label = {  50991, 12, 0 } }, /* dreamhosters */
    { .label = { 137929,  7, 0 } }, /* mydrobo */
    { .label = {  31475, 14, 0 } }, /* dyndns-at-home */
    { .label = {  31538, 14, 0 } }, /* dyndns-at-work */
    { .label = {  64627, 11, 0 } }, /* dyndns-blog */
    { .label = {  64680, 11, 0 } }, /* dyndns-free */
    { .label = {  64731, 11, 0 } }, /* dyndns-home */
    { .label = {  97138,  9, 0 } }, /* dyndns-ip */
    { .label = {  64782, 11, 0 } }, /* dyndns-mail */
    { .label = {  39574, 13, 0 } }, /* dyndns-office */
    { .label = {  64832, 11, 0 } }, /* dyndns-pics */
    { .label = {  39636, 13, 0 } }, /* dyndns-remote */
    { .label = {  39694, 13, 0 } }, /* dyndns-server */
    { .label = {  79396, 10, 0 } }, /* dyndns-web */
    { .label = {  64884, 11, 0 } }, /* dyndns-wiki */
    { .label = {  64936, 11, 0 } }, /* dyndns-work */
    { .label = { 137996,  7, 0 } }, /* blogdns */
    { .label = { 138029,  7, 0 } }, /* cechire */
    { .label = { 118031,  8, 0 } }, /* dnsalias */
    { .label = { 138060,  7, 0 } }, /* dnsdojo */
    { .label = {  65035, 11, 0 } }, /* doesntexist */
    { .label = {  97181,  9, 0 } }, /* dontexist */
    { .label = { 138123,  7, 0 } }, /* doomdns */
    { .label = {  79492, 10, 0 } }, /* dyn-o-saur */
    { .label = { 118063,  8, 0 } }, /* dynalias */
    { .label = {  24250, 15, 0 } }, /* est-a-la-maison */
    { .label = {  24312, 15, 0 } }, /* est-a-la-masion */
    { .label = {  39808, 13, 0 } }, /* est-le-patron */
    { .label = {  17193, 16, 0 } }, /* est-mon-blogueur */
    { .label = { 138218,  7, 0 } }, /* from-ak */
    { .label = { 138250,  7, 0 } }, /* from-al */
    { .label = { 138282,  7, 0 } }, /* from-ar */
    { .label = { 138347,  7, 0 } }, /* from-ca */
    { .label = { 138412,  7, 0 } }, /* from-ct */
    { .label = { 138445,  7, 0 } }, /* from-dc */
    { .label = { 138479,  7, 0 } }, /* from-de */
    { .label = { 138512,  7, 0 } }, /* from-fl */
    { .label = { 138547,  7, 0 } }, /* from-ga */
    { .label = { 138579,  7, 0 } }, /* from-hi */
    { .label = { 138612,  7, 0 } }, /* from-ia */
    { .label = { 138643,  7, 0 } }, /* from-id */
    { .label = { 138676,  7, 0 } }, /* from-il */
    { .label = { 138709,  7, 0 } }, /* from-in */
    { .label = { 138741,  7, 0 } }, /* from-ks */
    { .label = { 138774,  7, 0 } }, /* from-ky */
    { .label = { 138841,  7, 0 } }, /* from-ma */
    { .label = { 138873,  7, 0 } }, /* from-md */
    { .label = { 138940,  7, 0 } }, /* from-mi */
    { .label = { 138973,  7, 0 } }, /* from-mn */
    { .label = { 139006,  7, 0 } }, /* from-mo */
    { .label = { 139039,  7, 0 } }, /* from-ms */
    { .label = { 139072,  7, 0 } }, /* from-mt */
    { .label = { 139105,  7, 0 } }, /* from-nc */
    { .label = { 139138,  7, 0 } }, /* from-nd */
    { .label = { 139171,  7, 0 } }, /* from-ne */
    { .label = { 139203,  7, 0 } }, /* from-nh */
    { .label = { 139236,  7, 0 } }, /* from-nj */
    { .label = { 139271,  7, 0 } }, /* from-nm */
    { .label = { 139304,  7, 0 } }, /* from-nv */
    { .label = { 139372,  7, 0 } }, /* from-oh */
    { .label = { 139405,  7, 0 } }, /* from-ok */
    { .label = { 139438,  7, 0 } }, /* from-or */
    { .label = { 139470,  7, 0 } }, /* from-pa */
    { .label = { 139503,  7, 0 } }, /* from-pr */
    { .label = { 139537,  7, 0 } }, /* from-ri */
    { .label = { 139569,  7, 0 } }, /* from-sc */
    { .label = { 139602,  7, 0 } }, /* from-sd */
    { .label = { 139635,  7, 0 } }, /* from-tn */
    { .label = { 139667,  7, 0 } }, /* from-tx */
    { .label = { 139701,  7, 0 } }, /* from-ut */
    { .label = { 139734,  7, 0 } }, /* from-va */
    { .label = { 139767,  7, 0 } }, /* from-vt */
    { .label = { 139801,  7, 0 } }, /* from-wa */
    { .label = { 139834,  7, 0 } }, /* from-wi */
    { .label = { 139868,  7, 0 } }, /* from-wv */
    { .label = { 139904,  7, 0 } }, /* from-wy */
    { .label = { 139940,  7, 0 } }, /* getmyip */
    { .label = { 157148,  6, 0 } }, /* gotdns */
    { .label = {  79626, 10, 0 } }, /* hobby-site */
    { .label = {  97380,  9, 0 } }, /* homelinux */
    { .label = { 118133,  8, 0 } }, /* homeunix */
    { .label = {  97422,  9, 0 } }, /* iamallama */
    { .label = {  31602, 14, 0 } }, /* is-a-anarchist */
    { .label = {  51148, 12, 0 } }, /* is-a-blogger */
    { .label = {  24440, 15, 0 } }, /* is-a-bookkeeper */
    { .label = {  31720, 14, 0 } }, /* is-a-bulls-fan */
    { .label = {  51202, 12, 0 } }, /* is-a-caterer */
    { .label = {  97458,  9, 0 } }, /* is-a-chef */
    { .label = {  13252, 17, 0 } }, /* is-a-conservative */
    { .label = { 118170,  8, 0 } }, /* is-a-cpa */
    { .label = {  10176, 18, 0 } }, /* is-a-cubicle-slave */
    { .label = {  39922, 13, 0 } }, /* is-a-democrat */
    { .label = {  39977, 13, 0 } }, /* is-a-designer */
    { .label = {  65179, 11, 0 } }, /* is-a-doctor */
    { .label = {   3930, 21, 0 } }, /* is-a-financialadvisor */
    { .label = {  97499,  9, 0 } }, /* is-a-geek */
    { .label = {  79674, 10, 0 } }, /* is-a-green */
    { .label = {  97538,  9, 0 } }, /* is-a-guru */
    { .label = {  17266, 16, 0 } }, /* is-a-hard-worker */
    { .label = {  65226, 11, 0 } }, /* is-a-hunter */
    { .label = {  24572, 15, 0 } }, /* is-a-landscaper */
    { .label = {  65321, 11, 0 } }, /* is-a-lawyer */
    { .label = {  51251, 12, 0 } }, /* is-a-liberal */
    { .label = {  17336, 16, 0 } }, /* is-a-libertarian */
    { .label = {  79716, 10, 0 } }, /* is-a-llama */
    { .label = {  40032, 13, 0 } }, /* is-a-musician */
    { .label = {  31842, 14, 0 } }, /* is-a-nascarfan */
    { .label = {  79758, 10, 0 } }, /* is-a-nurse */
    { .label = {  51303, 12, 0 } }, /* is-a-painter */
    { .label = {   5460, 20, 0 } }, /* is-a-personaltrainer */
    { .label = {  13325, 17, 0 } }, /* is-a-photographer */
    { .label = {  65370, 11, 0 } }, /* is-a-player */
    { .label = {  24703, 15, 0 } }, /* is-a-republican */
    { .label = {  40087, 13, 0 } }, /* is-a-rockstar */
    { .label = {  31899, 14, 0 } }, /* is-a-socialist */
    { .label = {  51404, 12, 0 } }, /* is-a-student */
    { .label = {  51455, 12, 0 } }, /* is-a-teacher */
    { .label = {  65467, 11, 0 } }, /* is-a-techie */
    { .label = {  31957, 14, 0 } }, /* is-a-therapist */
    { .label = {  17402, 16, 0 } }, /* is-an-accountant */
    { .label = {  65514, 11, 0 } }, /* is-an-actor */
    { .label = {  40141, 13, 0 } }, /* is-an-actress */
    { .label = {  24770, 15, 0 } }, /* is-an-anarchist */
    { .label = {  51505, 12, 0 } }, /* is-an-artist */
    { .label = {  32016, 14, 0 } }, /* is-an-engineer */
    { .label = {  13400, 17, 0 } }, /* is-an-entertainer */
    { .label = {  51553, 12, 0 } }, /* is-certified */
    { .label = { 140035,  7, 0 } }, /* is-gone */
    { .label = {  40194, 13, 0 } }, /* is-into-anime */
    { .label = {  51606, 12, 0 } }, /* is-into-cars */
    { .label = {  17468, 16, 0 } }, /* is-into-cartoons */
    { .label = {  40248, 13, 0 } }, /* is-into-games */
    { .label = { 140065,  7, 0 } }, /* is-leet */
    { .label = {  17534, 16, 0 } }, /* is-not-certified */
    { .label = { 118277,  8, 0 } }, /* is-slick */
    { .label = {  65559, 11, 0 } }, /* is-uberleet */
    { .label = {  24831, 15, 0 } }, /* is-with-theband */
    { .label = { 118313,  8, 0 } }, /* isa-geek */
    { .label = {  40363, 13, 0 } }, /* isa-hockeynut */
    { .label = {  17604, 16, 0 } }, /* issmarterthanyou */
    { .label = {  97617,  9, 0 } }, /* likes-pie */
    { .label = {  79976, 10, 0 } }, /* likescandy */
    { .label = { 118418,  8, 0 } }, /* neat-url */
    { .label = {  17671, 16, 0 } }, /* saves-the-whales */
    { .label = { 157231,  6, 0 } }, /* selfip */
    { .label = {  32074, 14, 0 } }, /* sells-for-less */
    { .label = {  65762, 11, 0 } }, /* sells-for-u */
    { .label = { 118487,  8, 0 } }, /* servebbs */
    { .label = {  80115, 10, 0 } }, /* simple-url */
    { .label = {  40597, 13, 0 } }, /* space-to-rent */
    { .label = {  51884, 12, 0 } }, /* teaches-yoga */
    { .label = {  32137, 14, 0 } }, /* writesthisblog */
    { .label = { 118747,  8, 0 } }, /* ddnsfree */
    { .label = { 118783,  8, 0 } }, /* ddnsgeek */
    { .label = { 167970,  5, 0 } }, /* giize */
    { .label = { 157291,  6, 0 } }, /* gleeze */
    { .label = { 167994,  5, 0 } }, /* kozow */
    { .label = {  80205, 10, 0 } }, /* loseyourip */
    { .label = { 168020,  5, 0 } }, /* ooguy */
    { .label = {  97738,  9, 0 } }, /* theworkpc */
    { .label = { 118819,  8, 0 } }, /* mytuleap */
    { .label = { 118857,  8, 1 } }, { .child = { 3103, 8 } }, /* evennode */
    { .label = {  97819,  9, 0 } }, /* onfabrica */
    { .label = { 168095,  5, 1 } }, { .child = { 3111, 1 } }, /* fbsbx */
    { .label = {  17811, 16, 0 } }, /* fastly-terrarium */
    { .label = {  32265, 14, 0 } }, /* fastvps-server */
    { .label = { 119386,  8, 0 } }, /* mydobiss */
    { .label = {  66355, 11, 0 } }, /* firebaseapp */
    { .label = {  80432, 10, 0 } }, /* freebox-os */
    { .label = {  98079,  9, 0 } }, /* freeboxos */
    { .label = { 119458,  8, 0 } }, /* gentapps */
    { .label = {  52046, 12, 0 } }, /* gentlentapis */
    { .label = {  13468, 17, 0 } }, /* githubusercontent */
    { .label = {  38404,  4, 1 } }, { .child = { 3112, 1 } }, /* 0emm */
    { .label = { 140740,  7, 1 } }, { .child = { 3113, 1 } }, /* appspot */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = { 119532,  8, 0 } }, /* codespot */
    { .label = {  80526, 10, 0 } }, /* googleapis */
    { .label = {  80570, 10, 0 } }, /* googlecode */
    { .label = {  10258, 18, 0 } }, /* pagespeedmobilizer */
    { .label = {  52097, 12, 0 } }, /* publishproxy */
    { .label = {  80615, 10, 0 } }, /* withgoogle */
    { .label = {  66455, 11, 0 } }, /* withyoutube */
    { .label = { 140806,  7, 0 } }, /* awsmppl */
    { .label = {  98206,  9, 0 } }, /* herokuapp */
    { .label = {  98248,  9, 0 } }, /* herokussl */
    { .label = {  98288,  9, 0 } }, /* myravendb */
    { .label = { 119641,  8, 0 } }, /* pixolino */
    { .label = { 157930,  6, 1 } }, { .child = { 3116, 1 } }, /* joyent */
    { .label = {  40943, 13, 0 } }, /* lpusercontent */
    { .label = { 172157,  4, 1 } }, { .child = { 3119, 1 } }, /* lmpm */
    { .label = {  41000,  6, 1 } }, { .child = { 3120, 2 } }, /* linode */
    { .label = {  41000, 13, 1 } }, { .child = { 3124, 1 } }, /* linodeobjects */
    { .label = {  66706, 11, 0 } }, /* barsycenter */
    { .label = {  66658, 11, 0 } }, /* barsyonline */
    { .label = {  80927, 10, 0 } }, /* miniserver */
    { .label = {  98646,  9, 1 } }, { .child = { 3125, 1 } }, /* meteorapp */
    { .label = {   2174,  2, 0 } }, /* 4u */
    { .label = { 141095,  7, 0 } }, /* nfshost */
    { .label = { 158101,  6, 0 } }, /* 001www */
    { .label = { 119823,  8, 0 } }, /* ddnslive */
    { .label = { 119860,  8, 0 } }, /* myiphost */
    { .label = { 119933,  8, 0 } }, /* blogsyte */
    { .label = {  80970, 10, 0 } }, /* ciscofreak */
    { .label = {  81059, 10, 0 } }, /* damnserver */
    { .label = {  66947, 11, 0 } }, /* ditchyourip */
    { .label = {  81102, 10, 0 } }, /* dnsiskinky */
    { .label = { 168449,  5, 0 } }, /* dynns */
    { .label = {  81147, 10, 0 } }, /* geekgalaxy */
    { .label = {  13543, 17, 0 } }, /* health-carereform */
    { .label = {  25036, 15, 0 } }, /* homesecuritymac */
    { .label = {  32635, 14, 0 } }, /* homesecuritypc */
    { .label = {  13617, 17, 0 } }, /* myactivedirectory */
    { .label = {  18023, 16, 0 } }, /* mysecuritycamera */
    { .label = {  81193, 10, 0 } }, /* net-freaks */
    { .label = {  98807,  9, 0 } }, /* onthewifi */
    { .label = {  81236, 10, 0 } }, /* point2this */
    { .label = {  81283, 10, 0 } }, /* quicksytes */
    { .label = {  25103, 15, 0 } }, /* securitytactics */
    { .label = {  41175, 13, 0 } }, /* serveexchange */
    { .label = {  66999, 11, 0 } }, /* servehumour */
    { .label = { 120044,  8, 0 } }, /* servep2p */
    { .label = {  52376, 12, 0 } }, /* servesarcasm */
    { .label = {  67049, 11, 0 } }, /* stufftoread */
    { .label = {  41233, 13, 0 } }, /* unusualperson */
    { .label = {  52426, 12, 0 } }, /* workisboring */
    { .label = {  81376, 10, 0 } }, /* 3utilities */
    { .label = { 120123,  8, 0 } }, /* ddnsking */
    { .label = { 168572,  5, 0 } }, /* myvnc */
    { .label = {  98848,  9, 0 } }, /* servebeer */
    { .label = {  10342, 18, 0 } }, /* servecounterstrike */
    { .label = { 118525,  8, 0 } }, /* serveftp */
    { .label = {  97699,  9, 0 } }, /* servegame */
    { .label = {  41290, 13, 0 } }, /* servehalflife */
    { .label = {  98930,  9, 0 } }, /* servehttp */
    { .label = { 120159,  8, 0 } }, /* serveirc */
    { .label = { 120194,  8, 0 } }, /* servemp3 */
    { .label = {  98971,  9, 0 } }, /* servepics */
    { .label = {  81465, 10, 0 } }, /* servequake */
    { .label = {   4019, 21, 1 } }, { .child = { 3126, 1 } }, /* observableusercontent */
    { .label = {  81512, 10, 0 } }, /* operaunite */
    { .label = {  81554, 10, 0 } }, /* skygearapp */
    { .label = {  25168, 15, 0 } }, /* outsystemscloud */
    { .label = {  67098, 11, 0 } }, /* ownprovider */
    { .label = { 168641,  5, 0 } }, /* pgfog */
    { .label = {  52480, 12, 0 } }, /* pagefrontapp */
    { .label = {  67149, 11, 0 } }, /* gotpantheon */
    { .label = {  67196, 11, 0 } }, /* platter-app */
    { .label = { 168750,  5, 1 } }, { .child = { 3127, 1 } }, /* prgmr */
    { .label = {  67246, 11, 0 } }, /* qualifioapp */
    { .label = { 158511,  6, 0 } }, /* qbuser */
    { .label = {  38340,  3, 0 } }, /* qa2 */
    { .label = {  25236, 15, 0 } }, /* dev-myqnapcloud */
    { .label = {  13694, 17, 0 } }, /* alpha-myqnapcloud */
    { .label = {  13721, 11, 0 } }, /* myqnapcloud */
    { .label = {  52636, 12, 1 } }, { .child = { 3128, 1 } }, /* quipelements */
    { .label = { 120341,  8, 0 } }, /* rackmaze */
    { .label = { 141377,  7, 0 } }, /* rhcloud */
    { .label = { 120385,  6, 1 } }, { .child = { 3129, 1 } }, /* render */
    { .label = { 120377,  8, 0 } }, /* onrender */
    { .label = { 158627,  6, 0 } }, /* logoip */
    { .label = { 141410,  7, 0 } }, /* scrysec */
    { .label = {  18094, 16, 0 } }, /* firewall-gateway */
    { .label = {  52742, 12, 0 } }, /* myshopblocks */
    { .label = {  81916, 10, 0 } }, /* shopitsite */
    { .label = { 168824,  5, 0 } }, /* 1kapp */
    { .label = { 120478,  8, 0 } }, /* appchizi */
    { .label = { 120518,  8, 0 } }, /* applinzi */
    { .label = {  82018,  7, 0 } }, /* sinaapp */
    { .label = {  82002, 10, 0 } }, /* vipsinaapp */
    { .label = {  67448, 11, 1 } }, { .child = { 3130, 2 } }, /* bounty-full */
    { .label = {  13777, 17, 0 } }, /* stackhero-network */
    { .label = {  13851, 17, 0 } }, /* playstation-cloud */
    { .label = { 158704,  6, 1 } }, { .child = { 3132, 1 } }, /* stdlib */
    { .label = { 120626,  8, 0 } }, /* temp-dns */
    { .label = { 141506,  7, 0 } }, /* dsmynas */
    { .label = { 120701,  8, 0 } }, /* familyds */
    { .label = {  41473, 13, 0 } }, /* thingdustdata */
    { .label = { 141700,  7, 0 } }, /* bloxcms */
    { .label = {  18239, 16, 0 } }, /* townnews-staging */
    { .label = {   4289,  2, 0 } }, /* hk */
    { .label = {  82177, 10, 0 } }, /* wafflecell */
    { .label = { 120925,  8, 0 } }, /* remotewd */
    { .label = { 168991,  5, 1 } }, { .child = { 3133, 2 } }, /* xnbay */
    { .label = { 121038,  8, 0 } }, /* yolasite */

    /* entries 2959 to 2960 */
    { .label = {   9167,  3, 1 } }, { .child = { 2961, 1 } }, /* dev */

    /* entry 2961 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2962 to 3019 */
    { .label = {  20300,  7, 1 } }, { .child = { 3020, 1 } }, /* compute */
    { .label = {  96634,  9, 1 } }, { .child = { 3021, 1 } }, /* compute-1 */
    { .label = {   4934,  9, 1 } }, { .child = { 3022, 1 } }, /* us-east-1 */
    { .label = {  41422,  3, 1 } }, { .child = { 3025, 1 } }, /* elb */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  12854, 17, 0 } }, /* s3-ap-northeast-1 */
    { .label = {  12934, 17, 0 } }, /* s3-ap-northeast-2 */
    { .label = {  39210, 13, 0 } }, /* s3-ap-south-1 */
    { .label = {  13014, 17, 0 } }, /* s3-ap-southeast-1 */
    { .label = {  13095, 17, 0 } }, /* s3-ap-southeast-2 */
    { .label = {  23835, 15, 0 } }, /* s3-ca-central-1 */
    { .label = {  23907, 15, 0 } }, /* s3-eu-central-1 */
    { .label = {  50286, 12, 0 } }, /* s3-eu-west-1 */
    { .label = {  50348, 12, 0 } }, /* s3-eu-west-2 */
    { .label = {  50410, 12, 0 } }, /* s3-eu-west-3 */
    { .label = {  39276, 13, 0 } }, /* s3-external-1 */
    { .label = {   3823, 21, 0 } }, /* s3-fips-us-gov-west-1 */
    { .label = {  50472, 12, 0 } }, /* s3-sa-east-1 */
    { .label = {  17043, 16, 0 } }, /* s3-us-gov-west-1 */
    { .label = {  50529, 12, 0 } }, /* s3-us-east-2 */
    { .label = {  50588, 12, 0 } }, /* s3-us-west-1 */
    { .label = {  50650, 12, 0 } }, /* s3-us-west-2 */
    { .label = {  12951, 14, 1 } }, { .child = { 3026, 3 } }, /* ap-northeast-2 */
    { .label = {  39227, 10, 1 } }, { .child = { 3031, 3 } }, /* ap-south-1 */
    { .label = {  23852, 12, 1 } }, { .child = { 3036, 3 } }, /* ca-central-1 */
    { .label = {  23924, 12, 1 } }, { .child = { 3041, 3 } }, /* eu-central-1 */
    { .label = {  50365,  9, 1 } }, { .child = { 3046, 3 } }, /* eu-west-2 */
    { .label = {  50427,  9, 1 } }, { .child = { 3051, 3 } }, /* eu-west-3 */
    { .label = {  50546,  9, 1 } }, { .child = { 3056, 3 } }, /* us-east-2 */
    { .label = {    720, 14, 1 } }, { .child = { 3061, 1 } }, /* ap-northeast-1 */
    { .label = {    837, 14, 1 } }, { .child = { 3064, 1 } }, /* ap-southeast-1 */
    { .label = {    955, 14, 1 } }, { .child = { 3067, 1 } }, /* ap-southeast-2 */
    { .label = {   5228,  9, 1 } }, { .child = { 3070, 1 } }, /* eu-west-1 */
    { .label = {   5327,  9, 1 } }, { .child = { 3073, 1 } }, /* sa-east-1 */
    { .label = {   4880, 20, 0 } }, /* s3-website-us-east-1 */
    { .label = {   4976, 20, 0 } }, /* s3-website-us-west-1 */
    { .label = {   5075, 20, 0 } }, /* s3-website-us-west-2 */
    { .label = {    666, 25, 0 } }, /* s3-website-ap-northeast-1 */
    { .label = {    783, 25, 0 } }, /* s3-website-ap-southeast-1 */
    { .label = {    901, 25, 0 } }, /* s3-website-ap-southeast-2 */
    { .label = {   5174, 20, 0 } }, /* s3-website-eu-west-1 */
    { .label = {   5273, 20, 0 } }, /* s3-website-sa-east-1 */

    /* entry 3020 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3021 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3022 to 3023 */
    { .label = {  96680,  9, 1 } }, { .child = { 3024, 1 } }, /* dualstack */

    /* entry 3024 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entry 3025 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3026 to 3029 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  96680,  9, 1 } }, { .child = { 3030, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3030 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3031 to 3034 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  96680,  9, 1 } }, { .child = { 3035, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3035 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3036 to 3039 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  96680,  9, 1 } }, { .child = { 3040, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3040 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3041 to 3044 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  96680,  9, 1 } }, { .child = { 3045, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3045 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3046 to 3049 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  96680,  9, 1 } }, { .child = { 3050, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3050 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3051 to 3054 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  96680,  9, 1 } }, { .child = { 3055, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3055 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3056 to 3059 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  96680,  9, 1 } }, { .child = { 3060, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3060 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3061 to 3062 */
    { .label = {  96680,  9, 1 } }, { .child = { 3063, 1 } }, /* dualstack */

    /* entry 3063 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3064 to 3065 */
    { .label = {  96680,  9, 1 } }, { .child = { 3066, 1 } }, /* dualstack */

    /* entry 3066 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3067 to 3068 */
    { .label = {  96680,  9, 1 } }, { .child = { 3069, 1 } }, /* dualstack */

    /* entry 3069 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3070 to 3071 */
    { .label = {  96680,  9, 1 } }, { .child = { 3072, 1 } }, /* dualstack */

    /* entry 3072 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3073 to 3074 */
    { .label = {  96680,  9, 1 } }, { .child = { 3075, 1 } }, /* dualstack */

    /* entry 3075 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3076 to 3092 */
    { .label = {    720, 14, 0 } }, /* ap-northeast-1 */
    { .label = {  12951, 14, 0 } }, /* ap-northeast-2 */
    { .label = {  31288, 14, 0 } }, /* ap-northeast-3 */
    { .label = {  39227, 10, 0 } }, /* ap-south-1 */
    { .label = {    837, 14, 0 } }, /* ap-southeast-1 */
    { .label = {    955, 14, 0 } }, /* ap-southeast-2 */
    { .label = {  23852, 12, 0 } }, /* ca-central-1 */
    { .label = {  23924, 12, 0 } }, /* eu-central-1 */
    { .label = {   5228,  9, 0 } }, /* eu-west-1 */
    { .label = {  50365,  9, 0 } }, /* eu-west-2 */
    { .label = {  50427,  9, 0 } }, /* eu-west-3 */
    { .label = {   5327,  9, 0 } }, /* sa-east-1 */
    { .label = {   4934,  9, 0 } }, /* us-east-1 */
    { .label = {  50546,  9, 0 } }, /* us-east-2 */
    { .label = {   3865, 13, 0 } }, /* us-gov-west-1 */
    { .label = {   5030,  9, 0 } }, /* us-west-1 */
    { .label = {   5129,  9, 0 } }, /* us-west-2 */

    /* entries 3093 to 3099 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {   2777,  3, 1 } }, { .child = { 3100, 1 } }, /* oci */
    { .label = {  25344,  3, 1 } }, { .child = { 3101, 1 } }, /* ocp */
    { .label = {  67334,  3, 1 } }, { .child = { 3102, 1 } }, /* ocs */

    /* entry 3100 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3101 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3102 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3103 to 3110 */
    { .label = { 171883,  4, 0 } }, /* eu-1 */
    { .label = { 171905,  4, 0 } }, /* eu-2 */
    { .label = { 171927,  4, 0 } }, /* eu-3 */
    { .label = { 171949,  4, 0 } }, /* eu-4 */
    { .label = { 171972,  4, 0 } }, /* us-1 */
    { .label = { 171994,  4, 0 } }, /* us-2 */
    { .label = { 172016,  4, 0 } }, /* us-3 */
    { .label = { 172038,  4, 0 } }, /* us-4 */

    /* entry 3111 */
    { .label = {  79106,  4, 0 } }, /* apps */

    /* entry 3112 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3113 to 3114 */
    { .label = {      1,  1, 1 } }, { .child = { 3115, 1 } }, /* r */

    /* entry 3115 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3116 to 3117 */
    { .label = {   9889,  3, 1 } }, { .child = { 3118, 1 } }, /* cns */

    /* entry 3118 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3119 */
    { .label = {   6842,  3, 0 } }, /* app */

    /* entries 3120 to 3122 */
    { .label = { 140905,  7, 0 } }, /* members */
    { .label = {  52214, 12, 1 } }, { .child = { 3123, 1 } }, /* nodebalancer */

    /* entry 3123 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3124 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3125 */
    { .label = {   2994,  2, 0 } }, /* eu */

    /* entry 3126 */
    { .label = {  39460,  6, 0 } }, /* static */

    /* entry 3127 */
    { .label = {  39340,  3, 0 } }, /* xen */

    /* entry 3128 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3129 */
    { .label = {   6842,  3, 0 } }, /* app */

    /* entries 3130 to 3131 */
    { .label = {  13694,  5, 0 } }, /* alpha */
    { .label = {  79034,  4, 0 } }, /* beta */

    /* entry 3132 */
    { .label = {  19258,  3, 0 } }, /* api */

    /* entries 3133 to 3134 */
    { .label = {  49860,  2, 0 } }, /* u2 */
    { .label = { 120961,  8, 0 } }, /* u2-local */

    /* entries 3135 to 3141 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {    391,  2, 0 } }, /* fi */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    355,  2, 0 } }, /* sa */

    /* entries 3142 to 3147 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   5509,  3, 0 } }, /* inf */

    /* entry 3148 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 3149 to 3152 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 3153 to 3155 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   1517,  3, 0 } }, /* ath */
    { .label = {  99429,  4, 0 } }, /* info */

    /* entries 3156 to 3169 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    106,  3, 1 } }, { .child = { 3170, 1 } }, /* com */
    { .label = { 121737,  7, 0 } }, /* ekloges */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  38987,  3, 0 } }, /* ltd */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  68726, 10, 0 } }, /* parliament */
    { .label = {  23342,  5, 0 } }, /* press */
    { .label = {  23387,  3, 0 } }, /* pro */
    { .label = {   2442,  2, 0 } }, /* tm */

    /* entry 3170 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 3171 to 3178 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 110476,  5, 0 } }, /* realm */
    { .label = {  12836,  2, 0 } }, /* e4 */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  66799, 11, 1 } }, { .child = { 3179, 2 } }, /* metacentrum */
    { .label = {    115,  4, 1 } }, { .child = { 3181, 1 } }, /* muni */

    /* entries 3179 to 3180 */
    { .label = {  13753,  5, 0 } }, /* cloud */
    { .label = {  50938,  6, 0 } }, /* custom */

    /* entries 3181 to 3182 */
    { .label = {  13753,  5, 1 } }, { .child = { 3183, 2 } }, /* cloud */

    /* entries 3183 to 3184 */
    { .label = {  42971,  3, 0 } }, /* flt */
    { .label = {  28335,  3, 0 } }, /* usr */

    /* entries 3185 to 3252 */
    { .label = { 137634,  7, 0 } }, /* bplaced */
    { .label = { 137597,  7, 0 } }, /* square7 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 137804,  7, 1 } }, { .child = { 3253, 1 } }, /* cosidns */
    { .label = {  24183, 15, 0 } }, /* dynamisches-dns */
    { .label = {  79222, 10, 0 } }, /* dnsupdater */
    { .label = {  50888, 12, 0 } }, /* internet-dns */
    { .label = {  96976,  9, 0 } }, /* l-o-g-i-n */
    { .label = { 137898,  7, 0 } }, /* dnshome */
    { .label = {  24374, 15, 0 } }, /* fuettertdasnetz */
    { .label = {  79800, 10, 0 } }, /* isteingeek */
    { .label = { 140125,  7, 0 } }, /* istmein */
    { .label = {  79886, 10, 0 } }, /* lebtimnetz */
    { .label = {  79933, 10, 0 } }, /* leitungsen */
    { .label = {  40653, 13, 0 } }, /* traeumtgerade */
    { .label = { 167948,  5, 1 } }, { .child = { 3254, 2 } }, /* ddnss */
    { .label = { 140188,  7, 0 } }, /* dyndns1 */
    { .label = { 118632,  8, 0 } }, /* dyn-ip24 */
    { .label = {  32200, 14, 1 } }, { .child = { 3256, 1 } }, /* home-webserver */
    { .label = {  40707, 13, 0 } }, /* myhome-server */
    { .label = { 158636,  4, 0 } }, /* goip */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  80705, 10, 0 } }, /* dyn-berlin */
    { .label = {  98369,  9, 0 } }, /* in-berlin */
    { .label = { 157791,  6, 0 } }, /* in-brb */
    { .label = {  98409,  9, 0 } }, /* in-butter */
    { .label = { 157820,  6, 0 } }, /* in-dsl */
    { .label = { 157847,  6, 0 } }, /* in-vpn */
    { .label = {  80752, 10, 0 } }, /* mein-iserv */
    { .label = {  66559, 11, 0 } }, /* schulserver */
    { .label = {  80796, 10, 0 } }, /* test-iserv */
    { .label = {  80839, 10, 0 } }, /* keymachine */
    { .label = {  98449,  9, 0 } }, /* git-repos */
    { .label = {  52158, 12, 0 } }, /* lcube-server */
    { .label = {  98489,  9, 0 } }, /* svn-repos */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = { 158627,  6, 0 } }, /* logoip */
    { .label = {  18094, 16, 0 } }, /* firewall-gateway */
    { .label = {  81780, 10, 0 } }, /* my-gateway */
    { .label = {  99132,  9, 0 } }, /* my-router */
    { .label = { 168801,  5, 0 } }, /* spdns */
    { .label = {  52801, 12, 1 } }, { .child = { 3257, 1 } }, /* speedpartner */
    { .label = {  82088, 10, 0 } }, /* taifun-dns */
    { .label = { 172522,  4, 0 } }, /* 12hp */
    { .label = { 173261,  3, 0 } }, /* 2ix */
    { .label = { 168921,  5, 0 } }, /* 4lima */
    { .label = {  99213,  9, 0 } }, /* lima-city */
    { .label = { 158838,  6, 0 } }, /* dd-dns */
    { .label = { 120810,  8, 0 } }, /* dray-dns */
    { .label = { 141735,  7, 0 } }, /* draydns */
    { .label = { 141766,  7, 0 } }, /* dyn-vpn */
    { .label = { 158866,  6, 0 } }, /* dynvpn */
    { .label = {  82132, 10, 0 } }, /* mein-vigor */
    { .label = { 120846,  8, 0 } }, /* my-vigor */
    { .label = { 158897,  6, 0 } }, /* my-wan */
    { .label = { 141802,  7, 0 } }, /* syno-ds */
    { .label = {   5542, 20, 0 } }, /* synology-diskstation */
    { .label = {  67556, 11, 0 } }, /* synology-ds */
    { .label = {  99298,  9, 1 } }, { .child = { 3258, 1 } }, /* uberspace */
    { .label = {  67608, 11, 0 } }, /* virtualuser */
    { .label = {  52910, 12, 0 } }, /* virtual-user */
    { .label = {  41528, 13, 0 } }, /* community-pro */
    { .label = {  10419, 18, 0 } }, /* diskussionsbereich */

    /* entry 3253 */
    { .label = {  21800,  3, 0 } }, /* dyn */

    /* entries 3254 to 3255 */
    { .label = {  21800,  3, 0 } }, /* dyn */
    { .label = {  31475,  6, 0 } }, /* dyndns */

    /* entry 3256 */
    { .label = {  21800,  3, 0 } }, /* dyn */

    /* entry 3257 */
    { .label = {  50938,  8, 0 } }, /* customer */

    /* entry 3258 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3259 to 3264 */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 116161,  4, 0 } }, /* firm */
    { .label = {  19380,  3, 0 } }, /* reg */
    { .label = { 159058,  5, 0 } }, /* store */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 3265 to 3269 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 3270 to 3279 */
    { .label = {   7959,  3, 0 } }, /* art */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 109579,  3, 0 } }, /* sld */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 3280 to 3287 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {   4292,  3, 0 } }, /* pol */
    { .label = {   7959,  3, 0 } }, /* art */

    /* entries 3288 to 3300 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3951,  3, 0 } }, /* fin */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {  23387,  3, 0 } }, /* pro */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 3301 to 3302 */
    { .label = {  15482,  3, 1 } }, { .child = { 3303, 1 } }, /* rit */

    /* entry 3303 */
    { .label = {  99092,  9, 0 } }, /* git-pages */

    /* entries 3304 to 3314 */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 117884,  4, 0 } }, /* riik */
    { .label = {  17357,  3, 0 } }, /* lib */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {    106,  3, 1 } }, { .child = { 3315, 1 } }, /* com */
    { .label = {   1461,  3, 0 } }, /* pri */
    { .label = {  23156,  3, 0 } }, /* aip */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  17585,  3, 0 } }, /* fie */

    /* entry 3315 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 3316 to 3325 */
    { .label = {    106,  3, 1 } }, { .child = { 3326, 1 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  11340,  3, 0 } }, /* eun */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    601,  3, 0 } }, /* sci */

    /* entry 3326 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entry 3327 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3328 to 3333 */
    { .label = {    106,  3, 1 } }, { .child = { 3334, 1 } }, /* com */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  44279,  3, 0 } }, /* edu */

    /* entry 3334 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 3335 to 3342 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  13820,  3, 0 } }, /* net */

    /* entries 3343 to 3350 */
    { .label = { 171728,  4, 0 } }, /* mycd */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = {  41411, 13, 0 } }, /* wellbeingzone */
    { .label = { 168801,  5, 0 } }, /* spdns */
    { .label = { 120777,  8, 1 } }, { .child = { 3351, 1 } }, /* transurl */
    { .label = {   5585, 11, 0 } }, /* diskstation */

    /* entry 3351 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3352 to 3356 */
    { .label = {  15680,  5, 0 } }, /* aland */
    { .label = {    767,  2, 0 } }, /* dy */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  24962, 15, 0 } }, /* xn--hkkinen-5wa */
    { .label = {  43523,  3, 0 } }, /* iki */

    /* entries 3357 to 3366 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  23387,  3, 0 } }, /* pro */

    /* entry 3367 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3368 to 3396 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 169150,  4, 0 } }, /* gouv */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  45092,  3, 0 } }, /* prd */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = { 100272,  8, 0 } }, /* aeroport */
    { .label = { 142547,  6, 0 } }, /* avocat */
    { .label = { 142572,  6, 0 } }, /* avoues */
    { .label = {    466,  3, 0 } }, /* cci */
    { .label = {  82737,  9, 0 } }, /* chambagri */
    { .label = {    190, 21, 0 } }, /* chirurgiens-dentistes */
    { .label = {   7942, 18, 0 } }, /* experts-comptables */
    { .label = {  18378, 15, 0 } }, /* geometre-expert */
    { .label = { 159210,  5, 0 } }, /* greta */
    { .label = {  13996, 16, 0 } }, /* huissier-justice */
    { .label = { 121768,  7, 0 } }, /* medecin */
    { .label = { 100305,  8, 0 } }, /* notaires */
    { .label = {  57370, 10, 0 } }, /* pharmacien */
    { .label = {  18340,  4, 0 } }, /* port */
    { .label = {  53292, 11, 0 } }, /* veterinaire */
    { .label = { 140252,  7, 0 } }, /* en-root */
    { .label = { 157652,  6, 0 } }, /* fbx-os */
    { .label = { 168283,  5, 0 } }, /* fbxos */
    { .label = {  80432, 10, 0 } }, /* freebox-os */
    { .label = {  98079,  9, 0 } }, /* freeboxos */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = { 158452,  6, 0 } }, /* on-web */
    { .label = {    190, 31, 0 } }, /* chirurgiens-dentistes-en-france */

    /* entry 3397 */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 3398 to 3405 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  69344,  3, 0 } }, /* pvt */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 3406 to 3412 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  48498,  4, 0 } }, /* kaas */
    { .label = {  64926,  3, 0 } }, /* cya */
    { .label = {  98057,  5, 1 } }, { .child = { 3413, 1 } }, /* panel */

    /* entry 3413 */
    { .label = { 158955,  6, 0 } }, /* daemon */

    /* entries 3414 to 3418 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25516,  3, 0 } }, /* mil */

    /* entries 3419 to 3424 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  38987,  3, 0 } }, /* ltd */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13397,  3, 0 } }, /* mod */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 3425 to 3432 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  38426,  2, 0 } }, /* xx */

    /* entries 3433 to 3438 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */

    /* entries 3439 to 3445 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  10299,  4, 0 } }, /* mobi */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {   6842,  3, 0 } }, /* app */

    /* entries 3446 to 3452 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 3453 to 3463 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   8930,  3, 0 } }, /* ind */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  17228,  4, 0 } }, /* blog */
    { .label = {    243,  2, 0 } }, /* de */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entries 3464 to 3471 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3007,  4, 0 } }, /* guam */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 3472 to 3479 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44750,  3, 0 } }, /* nym */
    { .label = {    555,  2, 0 } }, /* be */

    /* entries 3480 to 3504 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  88621,  3, 0 } }, /* idv */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  68558, 10, 0 } }, /* xn--55qx5d */
    { .label = {  53337, 11, 0 } }, /* xn--wcvs22d */
    { .label = {  53399, 11, 0 } }, /* xn--lcvr32d */
    { .label = {  68768, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  68824, 10, 0 } }, /* xn--gmqw5a */
    { .label = {  82777,  9, 0 } }, /* xn--ciqpn */
    { .label = {  53460, 11, 0 } }, /* xn--gmq050i */
    { .label = {  68880, 10, 0 } }, /* xn--zf0avx */
    { .label = {  68624, 10, 0 } }, /* xn--io0a7i */
    { .label = {  68936, 10, 0 } }, /* xn--mk0axi */
    { .label = {  68676, 10, 0 } }, /* xn--od0alg */
    { .label = {  53527, 11, 0 } }, /* xn--od0aq3b */
    { .label = {  82824,  9, 0 } }, /* xn--tn0ag */
    { .label = {  68987, 10, 0 } }, /* xn--uc0atv */
    { .label = {  53589, 11, 0 } }, /* xn--uc0ay4a */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */
    { .label = {  38987,  3, 0 } }, /* ltd */
    { .label = {  20072,  3, 0 } }, /* inc */

    /* entries 3505 to 3512 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    466,  2, 0 } }, /* cc */

    /* entries 3513 to 3518 */
    { .label = {   1109,  2, 0 } }, /* iz */
    { .label = { 138218,  4, 0 } }, /* from */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  57740,  4, 0 } }, /* free */

    /* entries 3519 to 3535 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  52753,  4, 0 } }, /* shop */
    { .label = { 116161,  4, 0 } }, /* firm */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = { 159230,  5, 0 } }, /* adult */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  23387,  3, 0 } }, /* pro */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {   7959,  3, 0 } }, /* art */
    { .label = {  53152,  4, 0 } }, /* coop */
    { .label = {   4292,  3, 0 } }, /* pol */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   2926,  3, 0 } }, /* rel */
    { .label = { 169150,  4, 0 } }, /* gouv */
    { .label = {   5481,  5, 0 } }, /* perso */

    /* entries 3536 to 3567 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = {  68414,  5, 0 } }, /* sport */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = { 117712,  4, 0 } }, /* 2000 */
    { .label = { 159252,  5, 0 } }, /* agrar */
    { .label = { 169207,  4, 0 } }, /* bolt */
    { .label = { 142598,  6, 0 } }, /* casino */
    { .label = {  99235,  4, 0 } }, /* city */
    { .label = { 121799,  7, 0 } }, /* erotica */
    { .label = { 121827,  7, 0 } }, /* erotika */
    { .label = {  82288,  4, 0 } }, /* film */
    { .label = {  99437,  5, 0 } }, /* forum */
    { .label = {  40282,  5, 0 } }, /* games */
    { .label = {  61691,  5, 0 } }, /* hotel */
    { .label = { 100336,  8, 0 } }, /* ingatlan */
    { .label = { 142622,  6, 0 } }, /* jogasz */
    { .label = { 100368,  8, 0 } }, /* konyvelo */
    { .label = { 159271,  5, 0 } }, /* lakas */
    { .label = {  98775,  5, 0 } }, /* media */
    { .label = {  18257,  4, 0 } }, /* news */
    { .label = { 142652,  6, 0 } }, /* reklam */
    { .label = {   6360,  3, 0 } }, /* sex */
    { .label = {  52753,  4, 0 } }, /* shop */
    { .label = { 148956,  4, 0 } }, /* suli */
    { .label = { 169226,  4, 0 } }, /* szex */
    { .label = { 142678,  6, 0 } }, /* tozsde */
    { .label = { 142706,  6, 0 } }, /* utazas */
    { .label = { 159291,  5, 0 } }, /* video */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 3568 to 3580 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 1 } }, { .child = { 3581, 1 } }, /* co */
    { .label = {  53238,  4, 0 } }, /* desa */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {   1064,  2, 0 } }, /* my */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = { 142732,  6, 0 } }, /* ponpes */
    { .label = {   6759,  3, 0 } }, /* sch */
    { .label = {    683,  3, 0 } }, /* web */

    /* entry 3581 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 3582 to 3584 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 3585 to 3593 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 3594, 1 } }, /* co */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 104928,  3, 0 } }, /* idf */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    115,  4, 0 } }, /* muni */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 3594 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 3595 to 3604 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 3605, 2 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    302,  2, 0 } }, /* tt */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 3605 to 3606 */
    { .label = {  38987,  3, 0 } }, /* ltd */
    { .label = {   2619,  3, 0 } }, /* plc */

    /* entries 3607 to 3621 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 116161,  4, 0 } }, /* firm */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {   8930,  3, 0 } }, /* ind */
    { .label = {    125,  3, 0 } }, /* nic */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  23348,  3, 0 } }, /* res */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  66658,  5, 0 } }, /* barsy */

    /* entries 3622 to 3642 */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = {  64526, 11, 0 } }, /* dynamic-dns */
    { .label = {  31475,  6, 0 } }, /* dyndns */
    { .label = {   7854, 19, 0 } }, /* barrel-of-knowledge */
    { .label = {   5367, 20, 0 } }, /* barrell-of-knowledge */
    { .label = { 138154,  7, 0 } }, /* for-our */
    { .label = {  97340,  9, 0 } }, /* groks-the */
    { .label = {  79582, 10, 0 } }, /* groks-this */
    { .label = {  39864, 13, 0 } }, /* here-for-more */
    { .label = {  79842, 10, 0 } }, /* knowsitall */
    { .label = { 157231,  6, 0 } }, /* selfip */
    { .label = { 157260,  6, 0 } }, /* webhop */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = { 119787,  8, 0 } }, /* mayfirst */
    { .label = { 158143,  6, 0 } }, /* forumz */
    { .label = {  79227,  8, 0 } }, /* nsupdate */
    { .label = { 158203,  6, 0 } }, /* dvrcam */
    { .label = {  52321, 12, 0 } }, /* ilovecollege */
    { .label = { 168522,  5, 0 } }, /* no-ip */
    { .label = {  79222,  9, 0 } }, /* dnsupdate */
    { .label = { 158926,  6, 0 } }, /* v-info */

    /* entry 3643 */
    { .label = {   2994,  2, 0 } }, /* eu */

    /* entries 3644 to 3712 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 156961,  6, 0 } }, /* apigee */
    { .label = { 156987,  6, 0 } }, /* b-data */
    { .label = {  50712, 12, 0 } }, /* backplaneapp */
    { .label = {  64426, 11, 1 } }, { .child = { 3713, 2 } }, /* banzaicloud */
    { .label = { 137562,  7, 0 } }, /* boxfuse */
    { .label = {  13176, 17, 0 } }, /* browsersafetymark */
    { .label = { 171707,  4, 1 } }, { .child = { 3717, 1 } }, /* bigv */
    { .label = {  79078, 10, 0 } }, /* cleverapps */
    { .label = { 117886,  8, 1 } }, { .child = { 3718, 1 } }, /* dappnode */
    { .label = { 167899,  5, 0 } }, /* dedyn */
    { .label = { 171826,  4, 0 } }, /* drud */
    { .label = { 118679,  8, 0 } }, /* definima */
    { .label = { 157406,  6, 1 } }, { .child = { 3719, 1 } }, /* enonic */
    { .label = {  12212,  3, 0 } }, /* shw */
    { .label = {  13468,  6, 0 } }, /* github */
    { .label = { 157736,  6, 0 } }, /* gitlab */
    { .label = { 140706,  7, 0 } }, /* lolipop */
    { .label = {  80661, 10, 0 } }, /* hasura-app */
    { .label = {  98331,  9, 1 } }, { .child = { 3720, 1 } }, /* moonscale */
    { .label = {  98569,  9, 0 } }, /* loginline */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = {  32458, 14, 1 } }, { .child = { 3721, 1 } }, /* azurecontainer */
    { .label = { 168334,  5, 0 } }, /* ngrok */
    { .label = { 141316,  7, 1 } }, { .child = { 3722, 1 } }, /* nodeart */
    { .label = { 168618,  5, 0 } }, /* nodum */
    { .label = {   4353,  3, 0 } }, /* nid */
    { .label = {  52535, 12, 0 } }, /* pantheonsite */
    { .label = { 168718,  5, 0 } }, /* dyn53 */
    { .label = { 120307,  8, 0 } }, /* protonet */
    { .label = { 173223,  3, 1 } }, { .child = { 3723, 1 } }, /* qcx */
    { .label = {  81646, 10, 0 } }, /* vaporcloud */
    { .label = { 158542,  6, 1 } }, { .child = { 3726, 1 } }, /* on-k3s */
    { .label = { 158572,  6, 1 } }, { .child = { 3727, 1 } }, /* on-rio */
    { .label = {  67300, 11, 0 } }, /* readthedocs */
    { .label = {  67347, 11, 0 } }, /* resindevice */
    { .label = {  52693, 12, 1 } }, { .child = { 3728, 1 } }, /* resinstaging */
    { .label = {  90783,  3, 0 } }, /* hzc */
    { .label = { 120410,  8, 0 } }, /* sandcats */
    { .label = {  99173,  9, 0 } }, /* shiftedit */
    { .label = {  81959, 10, 0 } }, /* mo-siemens */
    { .label = { 100150,  4, 1 } }, { .child = { 3729, 1 } }, /* lair */
    { .label = { 158679,  6, 1 } }, { .child = { 3730, 1 } }, /* stolos */
    { .label = { 120591,  8, 0 } }, /* spacekit */
    { .label = { 141442,  7, 0 } }, /* utwente */
    { .label = {  18167, 16, 0 } }, /* applicationcloud */
    { .label = { 168875,  5, 0 } }, /* scapp */
    { .label = { 173242,  3, 1 } }, { .child = { 3731, 1 } }, /* s5y */
    { .label = { 141573,  7, 0 } }, /* telebit */
    { .label = {  41473,  9, 1 } }, { .child = { 3732, 4 } }, /* thingdust */
    { .label = { 172582,  4, 0 } }, /* 2038 */
    { .label = { 120885,  8, 0 } }, /* wedeploy */
    { .label = {  67708, 11, 0 } }, /* basicserver */
    { .label = {  41589, 13, 0 } }, /* virtualserver */

    /* entries 3713 to 3715 */
    { .label = {   6842,  3, 0 } }, /* app */
    { .label = {  96758,  9, 1 } }, { .child = { 3716, 1 } }, /* backyards */

    /* entry 3716 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3717 */
    { .label = { 173129,  3, 0 } }, /* uk0 */

    /* entry 3718 */
    { .label = {  31475,  6, 0 } }, /* dyndns */

    /* entry 3719 */
    { .label = {  50938,  8, 0 } }, /* customer */

    /* entry 3720 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3721 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3722 */
    { .label = { 168598,  5, 0 } }, /* stage */

    /* entries 3723 to 3724 */
    { .label = {   7697,  3, 1 } }, { .child = { 3725, 1 } }, /* sys */

    /* entry 3725 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3726 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3727 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3728 */
    { .label = {  31381,  7, 0 } }, /* devices */

    /* entry 3729 */
    { .label = {  79106,  4, 0 } }, /* apps */

    /* entry 3730 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3731 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3732 to 3739 */
    { .label = {   9167,  3, 1 } }, { .child = { 3740, 1 } }, /* dev */
    { .label = { 158812,  6, 1 } }, { .child = { 3741, 1 } }, /* disrec */
    { .label = {  61865,  4, 1 } }, { .child = { 3742, 1 } }, /* prod */
    { .label = { 141638,  7, 1 } }, { .child = { 3743, 1 } }, /* testing */

    /* entry 3740 */
    { .label = {  50938,  4, 0 } }, /* cust */

    /* entry 3741 */
    { .label = {  50938,  4, 0 } }, /* cust */

    /* entry 3742 */
    { .label = {  50938,  4, 0 } }, /* cust */

    /* entry 3743 */
    { .label = {  50938,  4, 0 } }, /* cust */

    /* entries 3744 to 3749 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */

    /* entries 3750 to 3758 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    143,  2, 0 } }, /* id */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6759,  3, 0 } }, /* sch */
    { .label = {  18445, 15, 0 } }, /* xn--mgba3a4f16a */
    { .label = {  25440, 14, 0 } }, /* xn--mgba3a4fra */

    /* entries 3759 to 3766 */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = { 137834,  7, 0 } }, /* cupcake */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 3767 to 4177 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   8777,  3, 0 } }, /* abr */
    { .label = { 121855,  7, 0 } }, /* abruzzo */
    { .label = {  41757, 12, 0 } }, /* aosta-valley */
    { .label = {  53648, 11, 0 } }, /* aostavalley */
    { .label = {   3814,  3, 0 } }, /* bas */
    { .label = {  69038, 10, 0 } }, /* basilicata */
    { .label = {   4017,  3, 0 } }, /* cal */
    { .label = {  19411,  8, 0 } }, /* calabria */
    { .label = {    444,  3, 0 } }, /* cam */
    { .label = { 100406,  8, 0 } }, /* campania */
    { .label = {  25512, 14, 0 } }, /* emilia-romagna */
    { .label = {  33035, 13, 0 } }, /* emiliaromagna */
    { .label = {  71732,  3, 0 } }, /* emr */
    { .label = {  18530, 15, 0 } }, /* friuli-v-giulia */
    { .label = {  14068, 16, 0 } }, /* friuli-ve-giulia */
    { .label = {  18600, 15, 0 } }, /* friuli-vegiulia */
    { .label = {   2809, 21, 0 } }, /* friuli-venezia-giulia */
    { .label = {   4111, 20, 0 } }, /* friuli-veneziagiulia */
    { .label = {  25570, 14, 0 } }, /* friuli-vgiulia */
    { .label = {  25635, 14, 0 } }, /* friuliv-giulia */
    { .label = {  18669, 15, 0 } }, /* friulive-giulia */
    { .label = {  25700, 14, 0 } }, /* friulivegiulia */
    { .label = {   4202, 20, 0 } }, /* friulivenezia-giulia */
    { .label = {   5796, 19, 0 } }, /* friuliveneziagiulia */
    { .label = {  33088, 13, 0 } }, /* friulivgiulia */
    { .label = { 172805,  3, 0 } }, /* fvg */
    { .label = { 126509,  3, 0 } }, /* laz */
    { .label = { 159314,  5, 0 } }, /* lazio */
    { .label = {  44806,  3, 0 } }, /* lig */
    { .label = { 121891,  7, 0 } }, /* liguria */
    { .label = {  18382,  3, 0 } }, /* lom */
    { .label = {  82868,  9, 0 } }, /* lombardia */
    { .label = { 100439,  8, 0 } }, /* lombardy */
    { .label = { 121921,  7, 0 } }, /* lucania */
    { .label = {   1369,  3, 0 } }, /* mar */
    { .label = { 142760,  6, 0 } }, /* marche */
    { .label = {  57797,  3, 0 } }, /* mol */
    { .label = { 142786,  6, 0 } }, /* molise */
    { .label = { 100477,  8, 0 } }, /* piedmont */
    { .label = { 100513,  8, 0 } }, /* piemonte */
    { .label = {  48088,  3, 0 } }, /* pmn */
    { .label = {  42831,  3, 0 } }, /* pug */
    { .label = { 142812,  6, 0 } }, /* puglia */
    { .label = {   3878,  3, 0 } }, /* sar */
    { .label = { 100548,  8, 0 } }, /* sardegna */
    { .label = { 100580,  8, 0 } }, /* sardinia */
    { .label = {  28517,  3, 0 } }, /* sic */
    { .label = { 121950,  7, 0 } }, /* sicilia */
    { .label = { 142840,  6, 0 } }, /* sicily */
    { .label = {    314,  3, 0 } }, /* taa */
    { .label = {   5735,  3, 0 } }, /* tos */
    { .label = { 121979,  7, 0 } }, /* toscana */
    { .label = {  10498, 17, 0 } }, /* trentin-sud-tirol */
    { .label = {   1019, 24, 0 } }, /* xn--trentin-sd-tirol-rzb */
    { .label = {  14142, 16, 0 } }, /* trentin-sudtirol */
    { .label = {   1566, 23, 0 } }, /* xn--trentin-sdtirol-7vb */
    { .label = {   8025, 18, 0 } }, /* trentin-sued-tirol */
    { .label = {  10571, 17, 0 } }, /* trentin-suedtirol */
    { .label = {  14210, 16, 0 } }, /* trentino-a-adige */
    { .label = {  18738, 15, 0 } }, /* trentino-aadige */
    { .label = {   5882, 19, 0 } }, /* trentino-alto-adige */
    { .label = {   8102, 18, 0 } }, /* trentino-altoadige */
    { .label = {  14276, 16, 0 } }, /* trentino-s-tirol */
    { .label = {  18799, 15, 0 } }, /* trentino-stirol */
    { .label = {   8176, 18, 0 } }, /* trentino-sud-tirol */
    { .label = {    445, 25, 0 } }, /* xn--trentino-sd-tirol-c3b */
    { .label = {  10643, 17, 0 } }, /* trentino-sudtirol */
    { .label = {   1129, 24, 0 } }, /* xn--trentino-sdtirol-szb */
    { .label = {   5961, 19, 0 } }, /* trentino-sued-tirol */
    { .label = {   8253, 18, 0 } }, /* trentino-suedtirol */
    { .label = {    465,  8, 0 } }, /* trentino */
    { .label = {  18861, 15, 0 } }, /* trentinoa-adige */
    { .label = {  25764, 14, 0 } }, /* trentinoaadige */
    { .label = {   8329, 18, 0 } }, /* trentinoalto-adige */
    { .label = {  10715, 17, 0 } }, /* trentinoaltoadige */
    { .label = {  18922, 15, 0 } }, /* trentinos-tirol */
    { .label = {  25820, 14, 0 } }, /* trentinostirol */
    { .label = {  10784, 17, 0 } }, /* trentinosud-tirol */
    { .label = {   1238, 24, 0 } }, /* xn--trentinosd-tirol-rzb */
    { .label = {  14343, 16, 0 } }, /* trentinosudtirol */
    { .label = {   1675, 23, 0 } }, /* xn--trentinosdtirol-7vb */
    { .label = {   8403, 18, 0 } }, /* trentinosued-tirol */
    { .label = {  10856, 17, 0 } }, /* trentinosuedtirol */
    { .label = {  14410, 16, 0 } }, /* trentinsud-tirol */
    { .label = {   1783, 23, 0 } }, /* xn--trentinsd-tirol-6vb */
    { .label = {  18984, 15, 0 } }, /* trentinsudtirol */
    { .label = {   2090, 22, 0 } }, /* xn--trentinsdtirol-nsb */
    { .label = {  10927, 17, 0 } }, /* trentinsued-tirol */
    { .label = {  14478, 16, 0 } }, /* trentinsuedtirol */
    { .label = { 122006,  7, 0 } }, /* tuscany */
    { .label = {  20148,  3, 0 } }, /* umb */
    { .label = { 142868,  6, 0 } }, /* umbria */
    { .label = {  53695, 11, 0 } }, /* val-d-aosta */
    { .label = {  69079, 10, 0 } }, /* val-daosta */
    { .label = {  69121, 10, 0 } }, /* vald-aosta */
    { .label = {  82907,  9, 0 } }, /* valdaosta */
    { .label = {  53742, 11, 0 } }, /* valle-aosta */
    { .label = {  33148, 13, 0 } }, /* valle-d-aosta */
    { .label = {  41809, 12, 0 } }, /* valle-daosta */
    { .label = {  69163, 10, 0 } }, /* valleaosta */
    { .label = {  41860, 12, 0 } }, /* valled-aosta */
    { .label = {  53788, 11, 0 } }, /* valledaosta */
    { .label = {  41911, 12, 0 } }, /* vallee-aoste */
    { .label = {   6042, 19, 0 } }, /* xn--valle-aoste-ebb */
    { .label = {  25877, 14, 0 } }, /* vallee-d-aoste */
    { .label = {   2905, 21, 0 } }, /* xn--valle-d-aoste-ehb */
    { .label = {  53834, 11, 0 } }, /* valleeaoste */
    { .label = {   8479, 18, 0 } }, /* xn--valleaoste-e7a */
    { .label = {  41962, 12, 0 } }, /* valleedaoste */
    { .label = {   6130, 19, 0 } }, /* xn--valledaoste-ebb */
    { .label = {  42304,  3, 0 } }, /* vao */
    { .label = {  12593,  3, 0 } }, /* vda */
    { .label = {   2842,  3, 0 } }, /* ven */
    { .label = { 142895,  6, 0 } }, /* veneto */
    { .label = {   1383,  2, 0 } }, /* ag */
    { .label = {  82944,  9, 0 } }, /* agrigento */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {  53880, 11, 0 } }, /* alessandria */
    { .label = {   5919, 10, 0 } }, /* alto-adige */
    { .label = {   8139,  9, 0 } }, /* altoadige */
    { .label = {    227,  2, 0 } }, /* an */
    { .label = { 142921,  6, 0 } }, /* ancona */
    { .label = {   3002, 21, 0 } }, /* andria-barletta-trani */
    { .label = {   3087, 21, 0 } }, /* andria-trani-barletta */
    { .label = {   6218, 19, 0 } }, /* andriabarlettatrani */
    { .label = {   6293, 19, 0 } }, /* andriatranibarletta */
    { .label = {   1422,  2, 0 } }, /* ao */
    { .label = {  33186,  5, 0 } }, /* aosta */
    { .label = {   2963,  5, 0 } }, /* aoste */
    { .label = {    321,  2, 0 } }, /* ap */
    { .label = {   1428,  2, 0 } }, /* aq */
    { .label = { 122429,  6, 0 } }, /* aquila */
    { .label = {     45,  2, 0 } }, /* ar */
    { .label = { 142944,  6, 0 } }, /* arezzo */
    { .label = {  33204, 13, 0 } }, /* ascoli-piceno */
    { .label = {  42013, 12, 0 } }, /* ascolipiceno */
    { .label = {   2051,  4, 0 } }, /* asti */
    { .label = {    160,  2, 0 } }, /* at */
    { .label = {    586,  2, 0 } }, /* av */
    { .label = { 100611,  8, 0 } }, /* avellino */
    { .label = {    118,  2, 0 } }, /* ba */
    { .label = {  19047, 15, 0 } }, /* balsan-sudtirol */
    { .label = {   2187, 22, 0 } }, /* xn--balsan-sdtirol-nsb */
    { .label = {  14545, 16, 0 } }, /* balsan-suedtirol */
    { .label = {   2207,  6, 0 } }, /* balsan */
    { .label = {  37282,  4, 0 } }, /* bari */
    { .label = {   3172, 21, 0 } }, /* barletta-trani-andria */
    { .label = {   6241, 19, 0 } }, /* barlettatraniandria */
    { .label = { 122037,  7, 0 } }, /* belluno */
    { .label = {  82981,  9, 0 } }, /* benevento */
    { .label = { 122070,  7, 0 } }, /* bergamo */
    { .label = {   5589,  2, 0 } }, /* bg */
    { .label = {    245,  2, 0 } }, /* bi */
    { .label = { 142973,  6, 0 } }, /* biella */
    { .label = {     95,  2, 0 } }, /* bl */
    { .label = {    716,  2, 0 } }, /* bn */
    { .label = {   2883,  2, 0 } }, /* bo */
    { .label = { 122101,  7, 0 } }, /* bologna */
    { .label = {  10999, 17, 0 } }, /* bolzano-altoadige */
    { .label = {  10999,  7, 0 } }, /* bolzano */
    { .label = {  25938, 14, 0 } }, /* bozen-sudtirol */
    { .label = {   3257, 21, 0 } }, /* xn--bozen-sdtirol-2ob */
    { .label = {  19112, 15, 0 } }, /* bozen-suedtirol */
    { .label = {   3277,  5, 0 } }, /* bozen */
    { .label = {    294,  2, 0 } }, /* br */
    { .label = { 122132,  7, 0 } }, /* brescia */
    { .label = { 100646,  8, 0 } }, /* brindisi */
    { .label = {    693,  2, 0 } }, /* bs */
    { .label = {   4002,  2, 0 } }, /* bt */
    { .label = {  19181, 15, 0 } }, /* bulsan-sudtirol */
    { .label = {   2286, 22, 0 } }, /* xn--bulsan-sdtirol-nsb */
    { .label = {  14614, 16, 0 } }, /* bulsan-suedtirol */
    { .label = {   2306,  6, 0 } }, /* bulsan */
    { .label = {   9169,  2, 0 } }, /* bz */
    { .label = {    133,  2, 0 } }, /* ca */
    { .label = { 100681,  8, 0 } }, /* cagliari */
    { .label = {  33261, 13, 0 } }, /* caltanissetta */
    { .label = {  19248, 15, 0 } }, /* campidano-medio */
    { .label = {  26003, 14, 0 } }, /* campidanomedio */
    { .label = {  69204, 10, 0 } }, /* campobasso */
    { .label = {  11074, 17, 0 } }, /* carbonia-iglesias */
    { .label = {  14685, 16, 0 } }, /* carboniaiglesias */
    { .label = {  33312, 13, 0 } }, /* carrara-massa */
    { .label = {  42065, 12, 0 } }, /* carraramassa */
    { .label = { 122162,  7, 0 } }, /* caserta */
    { .label = { 122189,  7, 0 } }, /* catania */
    { .label = {  83021,  9, 0 } }, /* catanzaro */
    { .label = {     57,  2, 0 } }, /* cb */
    { .label = {    315,  2, 0 } }, /* ce */
    { .label = {  42110, 12, 0 } }, /* cesena-forli */
    { .label = {   6368, 19, 0 } }, /* xn--cesena-forl-mcb */
    { .label = {  53923, 11, 0 } }, /* cesenaforli */
    { .label = {   8562, 18, 0 } }, /* xn--cesenaforl-i8a */
    { .label = {    190,  2, 0 } }, /* ch */
    { .label = { 143000,  6, 0 } }, /* chieti */
    { .label = {    471,  2, 0 } }, /* ci */
    { .label = {   2620,  2, 0 } }, /* cl */
    { .label = {   2854,  2, 0 } }, /* cn */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  93735,  4, 0 } }, /* como */
    { .label = { 122215,  7, 0 } }, /* cosenza */
    { .label = {   1284,  2, 0 } }, /* cr */
    { .label = { 122246,  7, 0 } }, /* cremona */
    { .label = { 120308,  7, 0 } }, /* crotone */
    { .label = {    644,  2, 0 } }, /* cs */
    { .label = {   1982,  2, 0 } }, /* ct */
    { .label = { 159337,  5, 0 } }, /* cuneo */
    { .label = {   5677,  2, 0 } }, /* cz */
    { .label = {  26064, 14, 0 } }, /* dell-ogliastra */
    { .label = {  33362, 13, 0 } }, /* dellogliastra */
    { .label = {    226,  2, 0 } }, /* en */
    { .label = {   2783,  4, 0 } }, /* enna */
    { .label = {   6530,  2, 0 } }, /* fc */
    { .label = {    467,  2, 0 } }, /* fe */
    { .label = { 159359,  5, 0 } }, /* fermo */
    { .label = { 122275,  7, 0 } }, /* ferrara */
    { .label = {    331,  2, 0 } }, /* fg */
    { .label = {    391,  2, 0 } }, /* fi */
    { .label = { 122303,  7, 0 } }, /* firenze */
    { .label = { 100714,  8, 0 } }, /* florence */
    { .label = {   3284,  2, 0 } }, /* fm */
    { .label = { 143026,  6, 0 } }, /* foggia */
    { .label = {  42162, 12, 0 } }, /* forli-cesena */
    { .label = {   6457, 19, 0 } }, /* xn--forl-cesena-fcb */
    { .label = {  53970, 11, 0 } }, /* forlicesena */
    { .label = {   8646, 18, 0 } }, /* xn--forlcesena-c8a */
    { .label = {    298,  2, 0 } }, /* fr */
    { .label = {  83058,  9, 0 } }, /* frosinone */
    { .label = {    267,  2, 0 } }, /* ge */
    { .label = { 159382,  5, 0 } }, /* genoa */
    { .label = { 143053,  6, 0 } }, /* genova */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = { 122336,  7, 0 } }, /* gorizia */
    { .label = {   4597,  2, 0 } }, /* gr */
    { .label = { 100750,  8, 0 } }, /* grosseto */
    { .label = {  11145, 17, 0 } }, /* iglesias-carbonia */
    { .label = {  14751, 16, 0 } }, /* iglesiascarbonia */
    { .label = {   3011,  2, 0 } }, /* im */
    { .label = { 122367,  7, 0 } }, /* imperia */
    { .label = {    260,  2, 0 } }, /* is */
    { .label = { 122397,  7, 0 } }, /* isernia */
    { .label = {     43,  2, 0 } }, /* kr */
    { .label = {  83096,  9, 0 } }, /* la-spezia */
    { .label = { 122424,  7, 0 } }, /* laquila */
    { .label = { 100783,  8, 0 } }, /* laspezia */
    { .label = { 143079,  6, 0 } }, /* latina */
    { .label = {    101,  2, 0 } }, /* lc */
    { .label = {     97,  2, 0 } }, /* le */
    { .label = { 123444,  5, 0 } }, /* lecce */
    { .label = {  94065,  5, 0 } }, /* lecco */
    { .label = {   2828,  2, 0 } }, /* li */
    { .label = { 122457,  7, 0 } }, /* livorno */
    { .label = {   2308,  2, 0 } }, /* lo */
    { .label = { 112757,  4, 0 } }, /* lodi */
    { .label = {    695,  2, 0 } }, /* lt */
    { .label = {   2993,  2, 0 } }, /* lu */
    { .label = { 159402,  5, 0 } }, /* lucca */
    { .label = { 100819,  8, 0 } }, /* macerata */
    { .label = { 122488,  7, 0 } }, /* mantova */
    { .label = {  33417, 13, 0 } }, /* massa-carrara */
    { .label = {  42214, 12, 0 } }, /* massacarrara */
    { .label = { 143102,  6, 0 } }, /* matera */
    { .label = {   5584,  2, 0 } }, /* mb */
    { .label = {   4288,  2, 0 } }, /* mc */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  19314, 15, 0 } }, /* medio-campidano */
    { .label = {  26124, 14, 0 } }, /* mediocampidano */
    { .label = { 122517,  7, 0 } }, /* messina */
    { .label = {    290,  2, 0 } }, /* mi */
    { .label = { 143125,  5, 0 } }, /* milan */
    { .label = { 143125,  6, 0 } }, /* milano */
    { .label = {    571,  2, 0 } }, /* mn */
    { .label = {   3360,  2, 0 } }, /* mo */
    { .label = { 143150,  6, 0 } }, /* modena */
    { .label = {  33467, 13, 0 } }, /* monza-brianza */
    { .label = {   3360, 21, 0 } }, /* monza-e-della-brianza */
    { .label = {   3360,  5, 0 } }, /* monza */
    { .label = {  42259, 12, 0 } }, /* monzabrianza */
    { .label = {  33526, 13, 0 } }, /* monzaebrianza */
    { .label = {   8731, 18, 0 } }, /* monzaedellabrianza */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {    158,  2, 0 } }, /* mt */
    { .label = {     87,  2, 0 } }, /* na */
    { .label = { 143175,  6, 0 } }, /* naples */
    { .label = {  44706,  6, 0 } }, /* napoli */
    { .label = {    188,  2, 0 } }, /* no */
    { .label = { 143201,  6, 0 } }, /* novara */
    { .label = {   1501,  2, 0 } }, /* nu */
    { .label = { 159425,  5, 0 } }, /* nuoro */
    { .label = {   1288,  2, 0 } }, /* og */
    { .label = {  26088,  9, 0 } }, /* ogliastra */
    { .label = {  42313, 12, 0 } }, /* olbia-tempio */
    { .label = {  54017, 11, 0 } }, /* olbiatempio */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = { 100850,  8, 0 } }, /* oristano */
    { .label = {    636,  2, 0 } }, /* ot */
    { .label = {    490,  2, 0 } }, /* pa */
    { .label = { 143225,  6, 0 } }, /* padova */
    { .label = { 159446,  5, 0 } }, /* padua */
    { .label = { 122545,  7, 0 } }, /* palermo */
    { .label = { 159468,  5, 0 } }, /* parma */
    { .label = { 159489,  5, 0 } }, /* pavia */
    { .label = {   1999,  2, 0 } }, /* pc */
    { .label = {   2712,  2, 0 } }, /* pd */
    { .label = {   5481,  2, 0 } }, /* pe */
    { .label = { 122576,  7, 0 } }, /* perugia */
    { .label = {  33584, 13, 0 } }, /* pesaro-urbino */
    { .label = {  42367, 12, 0 } }, /* pesarourbino */
    { .label = { 122607,  7, 0 } }, /* pescara */
    { .label = {   4707,  2, 0 } }, /* pg */
    { .label = {    470,  2, 0 } }, /* pi */
    { .label = { 100881,  8, 0 } }, /* piacenza */
    { .label = { 124770,  4, 0 } }, /* pisa */
    { .label = { 122636,  7, 0 } }, /* pistoia */
    { .label = {   2853,  2, 0 } }, /* pn */
    { .label = {     41,  2, 0 } }, /* po */
    { .label = {  83137,  9, 0 } }, /* pordenone */
    { .label = { 122665,  7, 0 } }, /* potenza */
    { .label = {   1283,  2, 0 } }, /* pr */
    { .label = { 159511,  5, 0 } }, /* prato */
    { .label = {   1981,  2, 0 } }, /* pt */
    { .label = {  10196,  2, 0 } }, /* pu */
    { .label = {   6420,  2, 0 } }, /* pv */
    { .label = {   5676,  2, 0 } }, /* pz */
    { .label = {     70,  2, 0 } }, /* ra */
    { .label = { 143252,  6, 0 } }, /* ragusa */
    { .label = { 122697,  7, 0 } }, /* ravenna */
    { .label = {    440,  2, 0 } }, /* rc */
    { .label = {     55,  2, 0 } }, /* re */
    { .label = {  19380, 15, 0 } }, /* reggio-calabria */
    { .label = {  33641, 13, 0 } }, /* reggio-emilia */
    { .label = {  26185, 14, 0 } }, /* reggiocalabria */
    { .label = {  42419, 12, 0 } }, /* reggioemilia */
    { .label = {    178,  2, 0 } }, /* rg */
    { .label = {    393,  2, 0 } }, /* ri */
    { .label = { 146611,  5, 0 } }, /* rieti */
    { .label = { 143276,  6, 0 } }, /* rimini */
    { .label = {   1115,  2, 0 } }, /* rm */
    { .label = {    157,  2, 0 } }, /* rn */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {  23471,  4, 0 } }, /* roma */
    { .label = {  58199,  4, 0 } }, /* rome */
    { .label = { 143301,  6, 0 } }, /* rovigo */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = { 122725,  7, 0 } }, /* salerno */
    { .label = { 122753,  7, 0 } }, /* sassari */
    { .label = { 143328,  6, 0 } }, /* savona */
    { .label = {    699,  2, 0 } }, /* si */
    { .label = { 159532,  5, 0 } }, /* siena */
    { .label = { 100917,  8, 0 } }, /* siracusa */
    { .label = {    131,  2, 0 } }, /* so */
    { .label = { 122779,  7, 0 } }, /* sondrio */
    { .label = {     52,  2, 0 } }, /* sp */
    { .label = {    153,  2, 0 } }, /* sr */
    { .label = {    301,  2, 0 } }, /* ss */
    { .label = {   8290,  9, 0 } }, /* suedtirol */
    { .label = {  19444, 15, 0 } }, /* xn--sdtirol-n2a */
    { .label = {    743,  2, 0 } }, /* sv */
    { .label = {    183,  2, 0 } }, /* ta */
    { .label = { 122808,  7, 0 } }, /* taranto */
    { .label = {     89,  2, 0 } }, /* te */
    { .label = {  42470, 12, 0 } }, /* tempio-olbia */
    { .label = {  54066, 11, 0 } }, /* tempioolbia */
    { .label = { 143352,  6, 0 } }, /* teramo */
    { .label = { 159551,  5, 0 } }, /* terni */
    { .label = {    700,  2, 0 } }, /* tn */
    { .label = {   1538,  2, 0 } }, /* to */
    { .label = { 143376,  6, 0 } }, /* torino */
    { .label = {   5628,  2, 0 } }, /* tp */
    { .label = {    163,  2, 0 } }, /* tr */
    { .label = {   3455, 21, 0 } }, /* trani-andria-barletta */
    { .label = {   3540, 21, 0 } }, /* trani-barletta-andria */
    { .label = {   6547, 19, 0 } }, /* traniandriabarletta */
    { .label = {   6622, 19, 0 } }, /* tranibarlettaandria */
    { .label = { 122834,  7, 0 } }, /* trapani */
    { .label = { 143400,  6, 0 } }, /* trento */
    { .label = { 122862,  7, 0 } }, /* treviso */
    { .label = { 122892,  7, 0 } }, /* trieste */
    { .label = {    338,  2, 0 } }, /* ts */
    { .label = { 159571,  5, 0 } }, /* turin */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {   3931,  2, 0 } }, /* ud */
    { .label = { 159592,  5, 0 } }, /* udine */
    { .label = {  33697, 13, 0 } }, /* urbino-pesaro */
    { .label = {  42524, 12, 0 } }, /* urbinopesaro */
    { .label = {     54,  2, 0 } }, /* va */
    { .label = { 143424,  6, 0 } }, /* varese */
    { .label = {   1117,  2, 0 } }, /* vb */
    { .label = {   3371,  2, 0 } }, /* vc */
    { .label = {   1367,  2, 0 } }, /* ve */
    { .label = {   2842,  7, 0 } }, /* venezia */
    { .label = { 143449,  6, 0 } }, /* venice */
    { .label = { 100949,  8, 0 } }, /* verbania */
    { .label = { 100983,  8, 0 } }, /* vercelli */
    { .label = { 143476,  6, 0 } }, /* verona */
    { .label = {    569,  2, 0 } }, /* vi */
    { .label = {  33754, 13, 0 } }, /* vibo-valentia */
    { .label = {  42576, 12, 0 } }, /* vibovalentia */
    { .label = { 122920,  7, 0 } }, /* vicenza */
    { .label = { 122953,  7, 0 } }, /* viterbo */
    { .label = {   2710,  2, 0 } }, /* vr */
    { .label = {    156,  2, 0 } }, /* vs */
    { .label = {   2412,  2, 0 } }, /* vt */
    { .label = {   9606,  2, 0 } }, /* vv */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = { 172257,  4, 0 } }, /* 16-b */
    { .label = { 172285,  4, 0 } }, /* 32-b */
    { .label = { 172312,  4, 0 } }, /* 64-b */
    { .label = { 120663,  8, 0 } }, /* syncloud */

    /* entries 4178 to 4180 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 4181 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 4182 to 4189 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   6759,  3, 0 } }, /* sch */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  30106,  4, 0 } }, /* name */

    /* entries 4190 to 4356 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    124,  2, 0 } }, /* ad */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   4597,  2, 0 } }, /* gr */
    { .label = {   2037,  2, 0 } }, /* lg */
    { .label = {     40,  2, 1 } }, { .child = { 4357, 2 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  26785,  5, 1 } }, { .child = { 4361, 52 } }, /* aichi */
    { .label = {  26668,  5, 1 } }, { .child = { 4413, 28 } }, /* akita */
    { .label = {  87837,  6, 1 } }, { .child = { 4441, 22 } }, /* aomori */
    { .label = {  70427,  5, 1 } }, { .child = { 4463, 58 } }, /* chiba */
    { .label = { 145890,  5, 1 } }, { .child = { 4521, 22 } }, /* ehime */
    { .label = { 159614,  5, 1 } }, { .child = { 4543, 15 } }, /* fukui */
    { .label = { 122985,  7, 1 } }, { .child = { 4558, 63 } }, /* fukuoka */
    { .label = {  34622,  9, 1 } }, { .child = { 4621, 51 } }, /* fukushima */
    { .label = {  83812,  4, 1 } }, { .child = { 4672, 38 } }, /* gifu */
    { .label = { 159639,  5, 1 } }, { .child = { 4710, 36 } }, /* gunma */
    { .label = {  14914,  9, 1 } }, { .child = { 4746, 25 } }, /* hiroshima */
    { .label = { 101020,  8, 1 } }, { .child = { 4771, 142 } }, /* hokkaido */
    { .label = { 159661,  5, 1 } }, { .child = { 4913, 46 } }, /* hyogo */
    { .label = { 123018,  7, 1 } }, { .child = { 4959, 51 } }, /* ibaraki */
    { .label = {  88575,  8, 1 } }, { .child = { 5010, 19 } }, /* ishikawa */
    { .label = {  20808,  5, 1 } }, { .child = { 5029, 34 } }, /* iwate */
    { .label = {  34415,  6, 1 } }, { .child = { 5063, 15 } }, /* kagawa */
    { .label = {  83176,  9, 1 } }, { .child = { 5078, 20 } }, /* kagoshima */
    { .label = { 101055,  8, 1 } }, { .child = { 5098, 30 } }, /* kanagawa */
    { .label = { 159685,  5, 1 } }, { .child = { 5128, 31 } }, /* kochi */
    { .label = { 101087,  8, 1 } }, { .child = { 5159, 23 } }, /* kumamoto */
    { .label = { 159708,  5, 1 } }, { .child = { 5182, 31 } }, /* kyoto */
    { .label = {   3787,  3, 1 } }, { .child = { 5213, 30 } }, /* mie */
    { .label = { 143501,  6, 1 } }, { .child = { 5243, 32 } }, /* miyagi */
    { .label = { 101122,  8, 1 } }, { .child = { 5275, 27 } }, /* miyazaki */
    { .label = {  34750,  6, 1 } }, { .child = { 5302, 75 } }, /* nagano */
    { .label = { 101159,  8, 1 } }, { .child = { 5377, 22 } }, /* nagasaki */
    { .label = {   8212,  4, 1 } }, { .child = { 5399, 38 } }, /* nara */
    { .label = { 123047,  7, 1 } }, { .child = { 5437, 34 } }, /* niigata */
    { .label = {  73395,  4, 1 } }, { .child = { 5471, 19 } }, /* oita */
    { .label = { 108759,  7, 1 } }, { .child = { 5490, 26 } }, /* okayama */
    { .label = { 123074,  7, 1 } }, { .child = { 5516, 42 } }, /* okinawa */
    { .label = {  43739,  5, 1 } }, { .child = { 5558, 50 } }, /* osaka */
    { .label = {  48659,  4, 1 } }, { .child = { 5608, 26 } }, /* saga */
    { .label = { 123103,  7, 1 } }, { .child = { 5634, 69 } }, /* saitama */
    { .label = {  26523,  5, 1 } }, { .child = { 5703, 23 } }, /* shiga */
    { .label = { 123129,  7, 1 } }, { .child = { 5726, 23 } }, /* shimane */
    { .label = { 101190,  8, 1 } }, { .child = { 5749, 36 } }, /* shizuoka */
    { .label = { 123158,  7, 1 } }, { .child = { 5785, 31 } }, /* tochigi */
    { .label = {  83214,  9, 1 } }, { .child = { 5816, 17 } }, /* tokushima */
    { .label = { 159731,  5, 1 } }, { .child = { 5833, 57 } }, /* tokyo */
    { .label = { 123189,  7, 1 } }, { .child = { 5890, 13 } }, /* tottori */
    { .label = {  15066,  6, 1 } }, { .child = { 5903, 24 } }, /* toyama */
    { .label = { 101227,  8, 1 } }, { .child = { 5927, 29 } }, /* wakayama */
    { .label = { 101261,  8, 1 } }, { .child = { 5956, 34 } }, /* yamagata */
    { .label = {  83253,  9, 1 } }, { .child = { 5990, 16 } }, /* yamaguchi */
    { .label = {  83294,  9, 1 } }, { .child = { 6006, 28 } }, /* yamanashi */
    { .label = {  83331,  9, 0 } }, /* xn--4pvxs */
    { .label = {  54115, 11, 0 } }, /* xn--vgu402c */
    { .label = {  69248, 10, 0 } }, /* xn--c3s14m */
    { .label = {  54181, 11, 0 } }, /* xn--f6qx53a */
    { .label = {  69307, 10, 0 } }, /* xn--8pvr4u */
    { .label = {  54250, 11, 0 } }, /* xn--uist22h */
    { .label = {  26244, 14, 0 } }, /* xn--djrs72d6uy */
    { .label = {  54308, 11, 0 } }, /* xn--mkru45i */
    { .label = {  33812, 13, 0 } }, /* xn--0trq7p7nn */
    { .label = {  54369, 11, 0 } }, /* xn--8ltr62k */
    { .label = {  54433, 11, 0 } }, /* xn--2m4a15e */
    { .label = {  69366, 10, 0 } }, /* xn--efvn9s */
    { .label = {  54499, 11, 0 } }, /* xn--32vp30h */
    { .label = {  54568, 11, 0 } }, /* xn--4it797k */
    { .label = {  54638, 11, 0 } }, /* xn--1lqs71d */
    { .label = {  54705, 11, 0 } }, /* xn--5rtp49c */
    { .label = {  54772, 11, 0 } }, /* xn--5js045d */
    { .label = {  54843, 11, 0 } }, /* xn--ehqz56n */
    { .label = {  54909, 11, 0 } }, /* xn--1lqs03n */
    { .label = {  54974, 11, 0 } }, /* xn--qqqt11m */
    { .label = {  69420, 10, 0 } }, /* xn--kbrq7o */
    { .label = {  55043, 11, 0 } }, /* xn--pssu33l */
    { .label = {  55103, 11, 0 } }, /* xn--ntsq17g */
    { .label = {  69476, 10, 0 } }, /* xn--uisz3g */
    { .label = {  69529, 10, 0 } }, /* xn--6btw5a */
    { .label = {  83382,  9, 0 } }, /* xn--1ctwo */
    { .label = {  69586, 10, 0 } }, /* xn--6orx2r */
    { .label = {  69641, 10, 0 } }, /* xn--rht61e */
    { .label = {  69695, 10, 0 } }, /* xn--rht27z */
    { .label = {  69752, 10, 0 } }, /* xn--djty4k */
    { .label = {  55165, 11, 0 } }, /* xn--nit225k */
    { .label = {  83429,  9, 0 } }, /* xn--rht3d */
    { .label = {  69808, 10, 0 } }, /* xn--klty5x */
    { .label = {  69863, 10, 0 } }, /* xn--kltx9a */
    { .label = {  69916, 10, 0 } }, /* xn--kltp7d */
    { .label = {  55227, 11, 0 } }, /* xn--uuwu58a */
    { .label = {  55289, 11, 0 } }, /* xn--zbx025d */
    { .label = {  26326, 14, 0 } }, /* xn--ntso0iqx3a */
    { .label = {  55358, 11, 0 } }, /* xn--elqq16h */
    { .label = {  55425, 11, 0 } }, /* xn--4it168d */
    { .label = {  55493, 11, 0 } }, /* xn--klt787d */
    { .label = {  69970, 10, 0 } }, /* xn--rny31h */
    { .label = {  42629, 12, 0 } }, /* xn--7t0a264c */
    { .label = {  55559, 11, 0 } }, /* xn--5rtq34k */
    { .label = {  55626, 11, 0 } }, /* xn--k7yn95e */
    { .label = {  55693, 11, 0 } }, /* xn--tor131o */
    { .label = {  26399, 14, 0 } }, /* xn--d5qv7z876c */
    { .label = { 101293,  8, 1 } }, { .child = { 6034, 2 } }, /* kawasaki */
    { .label = {  70025, 10, 1 } }, { .child = { 6038, 2 } }, /* kitakyushu */
    { .label = {  52164,  4, 1 } }, { .child = { 6042, 2 } }, /* kobe */
    { .label = { 143528,  6, 1 } }, { .child = { 6046, 2 } }, /* nagoya */
    { .label = { 123217,  7, 1 } }, { .child = { 6050, 2 } }, /* sapporo */
    { .label = {  34468,  6, 1 } }, { .child = { 6054, 2 } }, /* sendai */
    { .label = { 101326,  8, 1 } }, { .child = { 6058, 2 } }, /* yokohama */
    { .label = {   4065, 11, 0 } }, /* usercontent */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 4357 to 4359 */
    { .label = { 137437,  7, 1 } }, { .child = { 4360, 1 } }, /* aseinet */
    { .label = { 157710,  6, 0 } }, /* gehirn */

    /* entry 4360 */
    { .label = {   4065,  4, 0 } }, /* user */

    /* entries 4361 to 4412 */
    { .label = { 124205,  5, 0 } }, /* aisai */
    { .label = {  11470,  3, 0 } }, /* ama */
    { .label = {  90772,  4, 0 } }, /* anjo */
    { .label = { 159754,  5, 0 } }, /* asuke */
    { .label = { 143553,  6, 0 } }, /* chiryu */
    { .label = { 103101,  5, 0 } }, /* chita */
    { .label = { 169268,  4, 0 } }, /* fuso */
    { .label = { 101361,  8, 0 } }, /* gamagori */
    { .label = { 159775,  5, 0 } }, /* handa */
    { .label = { 169287,  4, 0 } }, /* hazu */
    { .label = { 123248,  7, 0 } }, /* hekinan */
    { .label = {  70071, 10, 0 } }, /* higashiura */
    { .label = {  70113, 10, 0 } }, /* ichinomiya */
    { .label = { 123277,  7, 0 } }, /* inazawa */
    { .label = { 123307,  7, 0 } }, /* inuyama */
    { .label = { 123337,  7, 0 } }, /* isshiki */
    { .label = { 123367,  7, 0 } }, /* iwakura */
    { .label = { 159795,  5, 0 } }, /* kanie */
    { .label = { 143582,  6, 0 } }, /* kariya */
    { .label = { 123397,  7, 0 } }, /* kasugai */
    { .label = { 159149,  4, 0 } }, /* kira */
    { .label = { 143607,  6, 0 } }, /* kiyosu */
    { .label = { 143635,  6, 0 } }, /* komaki */
    { .label = { 159815,  5, 0 } }, /* konan */
    { .label = { 103822,  4, 0 } }, /* kota */
    { .label = { 107171,  6, 0 } }, /* mihama */
    { .label = {  14991,  7, 0 } }, /* miyoshi */
    { .label = {  56135,  6, 0 } }, /* nishio */
    { .label = { 123426,  7, 0 } }, /* nisshin */
    { .label = {  13487,  3, 0 } }, /* obu */
    { .label = { 143661,  6, 0 } }, /* oguchi */
    { .label = { 159835,  5, 0 } }, /* oharu */
    { .label = { 123455,  7, 0 } }, /* okazaki */
    { .label = {  70157, 10, 0 } }, /* owariasahi */
    { .label = {  47130,  4, 0 } }, /* seto */
    { .label = {  44073,  8, 0 } }, /* shikatsu */
    { .label = {  83475,  9, 0 } }, /* shinshiro */
    { .label = { 123486,  7, 0 } }, /* shitara */
    { .label = {  42779,  6, 0 } }, /* tahara */
    { .label = { 101394,  8, 0 } }, /* takahama */
    { .label = {  83513,  9, 0 } }, /* tobishima */
    { .label = { 169307,  4, 0 } }, /* toei */
    { .label = { 169323,  4, 0 } }, /* togo */
    { .label = {  55953,  5, 0 } }, /* tokai */
    { .label = { 101425,  8, 0 } }, /* tokoname */
    { .label = { 123513,  7, 0 } }, /* toyoake */
    { .label = {  83552,  9, 0 } }, /* toyohashi */
    { .label = { 101458,  8, 0 } }, /* toyokawa */
    { .label = { 143689,  6, 0 } }, /* toyone */
    { .label = { 143715,  6, 0 } }, /* toyota */
    { .label = {  11254,  8, 0 } }, /* tsushima */
    { .label = { 143740,  6, 0 } }, /* yatomi */

    /* entries 4413 to 4440 */
    { .label = {  26668,  5, 0 } }, /* akita */
    { .label = { 143766,  6, 0 } }, /* daisen */
    { .label = { 101493,  8, 0 } }, /* fujisato */
    { .label = { 143790,  6, 0 } }, /* gojome */
    { .label = {  55753, 11, 0 } }, /* hachirogata */
    { .label = { 143819,  6, 0 } }, /* happou */
    { .label = {  33888, 13, 0 } }, /* higashinaruse */
    { .label = {  83722,  5, 0 } }, /* honjo */
    { .label = { 143848,  6, 0 } }, /* honjyo */
    { .label = {  19986,  5, 0 } }, /* ikawa */
    { .label = {  83591,  9, 0 } }, /* kamikoani */
    { .label = { 123543,  7, 0 } }, /* kamioka */
    { .label = { 101530,  8, 0 } }, /* katagami */
    { .label = { 143878,  6, 0 } }, /* kazuno */
    { .label = {  83628,  9, 0 } }, /* kitaakita */
    { .label = { 143906,  6, 0 } }, /* kosaka */
    { .label = { 159856,  5, 0 } }, /* kyowa */
    { .label = {  26823,  6, 0 } }, /* misato */
    { .label = {  71137,  6, 0 } }, /* mitane */
    { .label = {  83663,  9, 0 } }, /* moriyoshi */
    { .label = { 143930,  6, 0 } }, /* nikaho */
    { .label = { 123572,  7, 0 } }, /* noshiro */
    { .label = {  85539,  5, 0 } }, /* odate */
    { .label = {  13440,  3, 0 } }, /* oga */
    { .label = {  55779,  5, 0 } }, /* ogata */
    { .label = { 123601,  7, 0 } }, /* semboku */
    { .label = { 143955,  6, 0 } }, /* yokote */
    { .label = {  83703,  9, 0 } }, /* yurihonjo */

    /* entries 4441 to 4462 */
    { .label = {  87837,  6, 0 } }, /* aomori */
    { .label = { 143982,  6, 0 } }, /* gonohe */
    { .label = {  83746,  9, 0 } }, /* hachinohe */
    { .label = {  83570,  9, 0 } }, /* hashikami */
    { .label = { 123634,  7, 0 } }, /* hiranai */
    { .label = { 101562,  8, 0 } }, /* hirosaki */
    { .label = {  83785,  9, 0 } }, /* itayanagi */
    { .label = { 101595,  8, 0 } }, /* kuroishi */
    { .label = { 144008,  6, 0 } }, /* misawa */
    { .label = {  83861,  5, 0 } }, /* mutsu */
    { .label = {  70197, 10, 0 } }, /* nakadomari */
    { .label = { 144033,  6, 0 } }, /* noheji */
    { .label = { 144061,  6, 0 } }, /* oirase */
    { .label = { 159880,  5, 0 } }, /* owani */
    { .label = { 101630,  8, 0 } }, /* rokunohe */
    { .label = { 123661,  7, 0 } }, /* sannohe */
    { .label = {  70237, 10, 0 } }, /* shichinohe */
    { .label = { 144084,  6, 0 } }, /* shingo */
    { .label = { 159901,  5, 0 } }, /* takko */
    { .label = { 144110,  6, 0 } }, /* towada */
    { .label = { 123689,  7, 0 } }, /* tsugaru */
    { .label = { 123719,  7, 0 } }, /* tsuruta */

    /* entries 4463 to 4520 */
    { .label = { 159922,  5, 0 } }, /* abiko */
    { .label = {  70178,  5, 0 } }, /* asahi */
    { .label = { 144135,  6, 0 } }, /* chonan */
    { .label = { 144160,  6, 0 } }, /* chosei */
    { .label = { 144186,  6, 0 } }, /* choshi */
    { .label = {  55830,  4, 0 } }, /* chuo */
    { .label = {  83821,  9, 0 } }, /* funabashi */
    { .label = { 144213,  6, 0 } }, /* futtsu */
    { .label = {  70281, 10, 0 } }, /* hanamigawa */
    { .label = { 101665,  8, 0 } }, /* ichihara */
    { .label = {  26788,  8, 0 } }, /* ichikawa */
    { .label = {  70113, 10, 0 } }, /* ichinomiya */
    { .label = { 159944,  5, 0 } }, /* inzai */
    { .label = {  14978,  5, 0 } }, /* isumi */
    { .label = { 101698,  8, 0 } }, /* kamagaya */
    { .label = { 101731,  8, 0 } }, /* kamogawa */
    { .label = {  56809,  7, 0 } }, /* kashiwa */
    { .label = { 106363,  6, 0 } }, /* katori */
    { .label = {  34907,  8, 0 } }, /* katsuura */
    { .label = { 123748,  7, 0 } }, /* kimitsu */
    { .label = { 101765,  8, 0 } }, /* kisarazu */
    { .label = { 144241,  6, 0 } }, /* kozaki */
    { .label = { 101800,  8, 0 } }, /* kujukuri */
    { .label = { 144269,  6, 0 } }, /* kyonan */
    { .label = { 123779,  7, 0 } }, /* matsudo */
    { .label = { 144295,  6, 0 } }, /* midori */
    { .label = { 107171,  6, 0 } }, /* mihama */
    { .label = {  70322, 10, 0 } }, /* minamiboso */
    { .label = { 144321,  6, 0 } }, /* mobara */
    { .label = {  83861,  9, 0 } }, /* mutsuzawa */
    { .label = { 144346,  6, 0 } }, /* nagara */
    { .label = {  70365, 10, 0 } }, /* nagareyama */
    { .label = {  83903,  9, 0 } }, /* narashino */
    { .label = { 144368,  6, 0 } }, /* narita */
    { .label = {  97983,  4, 0 } }, /* noda */
    { .label = {  33942, 13, 0 } }, /* oamishirasato */
    { .label = { 123809,  7, 0 } }, /* omigawa */
    { .label = { 144390,  6, 0 } }, /* onjuku */
    { .label = { 103909,  5, 0 } }, /* otaki */
    { .label = { 159966,  5, 0 } }, /* sakae */
    { .label = {  70910,  6, 0 } }, /* sakura */
    { .label = {  83938,  9, 0 } }, /* shimofusa */
    { .label = { 123839,  7, 0 } }, /* shirako */
    { .label = {  86129,  6, 0 } }, /* shiroi */
    { .label = { 144420,  6, 0 } }, /* shisui */
    { .label = {  83978,  9, 0 } }, /* sodegaura */
    { .label = { 105692,  4, 0 } }, /* sosa */
    { .label = { 104855,  4, 0 } }, /* tako */
    { .label = { 101840,  8, 0 } }, /* tateyama */
    { .label = { 144446,  6, 0 } }, /* togane */
    { .label = { 101872,  8, 0 } }, /* tohnosho */
    { .label = { 101906,  8, 0 } }, /* tomisato */
    { .label = { 123868,  7, 0 } }, /* urayasu */
    { .label = {  84015,  9, 0 } }, /* yachimata */
    { .label = { 123898,  7, 0 } }, /* yachiyo */
    { .label = {  70405, 10, 0 } }, /* yokaichiba */
    { .label = {  19514, 15, 0 } }, /* yokoshibahikari */
    { .label = {  70450, 10, 0 } }, /* yotsukaido */

    /* entries 4521 to 4542 */
    { .label = { 123259,  5, 0 } }, /* ainan */
    { .label = { 144801,  5, 0 } }, /* honai */
    { .label = {  87900,  5, 0 } }, /* ikata */
    { .label = { 123931,  7, 0 } }, /* imabari */
    { .label = {  14996,  3, 0 } }, /* iyo */
    { .label = {  34185,  8, 0 } }, /* kamijima */
    { .label = { 144470,  6, 0 } }, /* kihoku */
    { .label = {  84053,  9, 0 } }, /* kumakogen */
    { .label = { 144498,  6, 0 } }, /* masaki */
    { .label = { 123960,  7, 0 } }, /* matsuno */
    { .label = {  15053,  9, 0 } }, /* matsuyama */
    { .label = { 101938,  8, 0 } }, /* namikata */
    { .label = { 123989,  7, 0 } }, /* niihama */
    { .label = {  72326,  3, 0 } }, /* ozu */
    { .label = { 159985,  5, 0 } }, /* saijo */
    { .label = { 160007,  5, 0 } }, /* seiyo */
    { .label = {  55798, 11, 0 } }, /* shikokuchuo */
    { .label = {  82973,  4, 0 } }, /* tobe */
    { .label = {  17514,  4, 0 } }, /* toon */
    { .label = {  20012,  6, 0 } }, /* uchiko */
    { .label = { 124017,  7, 0 } }, /* uwajima */
    { .label = {  70494, 10, 0 } }, /* yawatahama */

    /* entries 4543 to 4557 */
    { .label = {  34018,  7, 0 } }, /* echizen */
    { .label = { 124050,  7, 0 } }, /* eiheiji */
    { .label = { 159614,  5, 0 } }, /* fukui */
    { .label = { 160029,  5, 0 } }, /* ikeda */
    { .label = {  84093,  9, 0 } }, /* katsuyama */
    { .label = { 107171,  6, 0 } }, /* mihama */
    { .label = {  33993, 13, 0 } }, /* minamiechizen */
    { .label = { 160050,  5, 0 } }, /* obama */
    { .label = {  19701,  3, 0 } }, /* ohi */
    { .label = {   1994,  3, 0 } }, /* ono */
    { .label = { 160071,  5, 0 } }, /* sabae */
    { .label = {  26773,  5, 0 } }, /* sakai */
    { .label = { 101394,  8, 0 } }, /* takahama */
    { .label = {  43809,  7, 0 } }, /* tsuruga */
    { .label = { 144522,  6, 0 } }, /* wakasa */

    /* entries 4558 to 4620 */
    { .label = {  34845,  6, 0 } }, /* ashiya */
    { .label = { 160091,  5, 0 } }, /* buzen */
    { .label = { 124082,  7, 0 } }, /* chikugo */
    { .label = {  86282,  7, 0 } }, /* chikuho */
    { .label = { 124115,  7, 0 } }, /* chikujo */
    { .label = {  70535, 10, 0 } }, /* chikushino */
    { .label = { 101969,  8, 0 } }, /* chikuzen */
    { .label = {  55830,  4, 0 } }, /* chuo */
    { .label = { 124150,  7, 0 } }, /* dazaifu */
    { .label = {  56710,  7, 0 } }, /* fukuchi */
    { .label = { 144546,  6, 0 } }, /* hakata */
    { .label = {  11216,  7, 0 } }, /* higashi */
    { .label = { 102008,  8, 0 } }, /* hirokawa */
    { .label = { 102042,  8, 0 } }, /* hisayama */
    { .label = { 144569,  6, 0 } }, /* iizuka */
    { .label = { 102075,  8, 0 } }, /* inatsuki */
    { .label = { 102712,  4, 0 } }, /* kaho */
    { .label = { 123397,  6, 0 } }, /* kasuga */
    { .label = { 144597,  6, 0 } }, /* kasuya */
    { .label = { 144623,  6, 0 } }, /* kawara */
    { .label = { 144647,  6, 0 } }, /* keisen */
    { .label = {  75234,  4, 0 } }, /* koga */
    { .label = { 144672,  6, 0 } }, /* kurate */
    { .label = { 144697,  6, 0 } }, /* kurogi */
    { .label = {  34803,  6, 0 } }, /* kurume */
    { .label = {  19642,  6, 0 } }, /* minami */
    { .label = {  71413,  6, 0 } }, /* miyako */
    { .label = {  19658,  6, 0 } }, /* miyama */
    { .label = { 102108,  8, 0 } }, /* miyawaka */
    { .label = { 102143,  8, 0 } }, /* mizumaki */
    { .label = { 102181,  8, 0 } }, /* munakata */
    { .label = { 102213,  8, 0 } }, /* nakagawa */
    { .label = { 144724,  6, 0 } }, /* nakama */
    { .label = {  43257,  5, 0 } }, /* nishi */
    { .label = { 144747,  6, 0 } }, /* nogata */
    { .label = { 160117,  5, 0 } }, /* ogori */
    { .label = { 124183,  7, 0 } }, /* okagaki */
    { .label = {  72039,  5, 0 } }, /* okawa */
    { .label = {   7846,  3, 0 } }, /* oki */
    { .label = { 160138,  5, 0 } }, /* omuta */
    { .label = { 128443,  4, 0 } }, /* onga */
    { .label = {  71436,  5, 0 } }, /* onojo */
    { .label = {  13357,  3, 0 } }, /* oto */
    { .label = { 124212,  7, 0 } }, /* saigawa */
    { .label = { 102245,  8, 0 } }, /* sasaguri */
    { .label = { 144770,  6, 0 } }, /* shingu */
    { .label = {  34051, 13, 0 } }, /* shinyoshitomi */
    { .label = { 144797,  6, 0 } }, /* shonai */
    { .label = { 160159,  5, 0 } }, /* soeda */
    { .label = {   5998,  3, 0 } }, /* sue */
    { .label = {  84131,  9, 0 } }, /* tachiarai */
    { .label = { 105354,  6, 0 } }, /* tagawa */
    { .label = {  34363,  6, 0 } }, /* takata */
    { .label = {  84698,  4, 0 } }, /* toho */
    { .label = { 124240,  7, 0 } }, /* toyotsu */
    { .label = { 144821,  6, 0 } }, /* tsuiki */
    { .label = { 160179,  5, 0 } }, /* ukiha */
    { .label = {  14986,  3, 0 } }, /* umi */
    { .label = { 160773,  4, 0 } }, /* usui */
    { .label = { 144847,  6, 0 } }, /* yamada */
    { .label = {  30104,  4, 0 } }, /* yame */
    { .label = { 102277,  8, 0 } }, /* yanagawa */
    { .label = {  84166,  9, 0 } }, /* yukuhashi */

    /* entries 4621 to 4671 */
    { .label = {  84208,  9, 0 } }, /* aizubange */
    { .label = {  70580, 10, 0 } }, /* aizumisato */
    { .label = {  34108, 13, 0 } }, /* aizuwakamatsu */
    { .label = { 124271,  7, 0 } }, /* asakawa */
    { .label = { 144872,  6, 0 } }, /* bandai */
    { .label = {  31826,  4, 0 } }, /* date */
    { .label = {  34622,  9, 0 } }, /* fukushima */
    { .label = { 102310,  8, 0 } }, /* furudono */
    { .label = { 144897,  6, 0 } }, /* futaba */
    { .label = { 144924,  6, 0 } }, /* hanawa */
    { .label = {  11216,  7, 0 } }, /* higashi */
    { .label = {  88652,  6, 0 } }, /* hirata */
    { .label = { 144948,  6, 0 } }, /* hirono */
    { .label = { 144973,  6, 0 } }, /* iitate */
    { .label = {  70623, 10, 0 } }, /* inawashiro */
    { .label = {  88575,  8, 0 } }, /* ishikawa */
    { .label = {  85380,  5, 0 } }, /* iwaki */
    { .label = {  84249,  9, 0 } }, /* izumizaki */
    { .label = {  70664, 10, 0 } }, /* kagamiishi */
    { .label = { 102347,  8, 0 } }, /* kaneyama */
    { .label = { 102380,  8, 0 } }, /* kawamata */
    { .label = { 102412,  8, 0 } }, /* kitakata */
    { .label = {  42704, 12, 0 } }, /* kitashiobara */
    { .label = { 160201,  5, 0 } }, /* koori */
    { .label = {  26637,  8, 0 } }, /* koriyama */
    { .label = { 144996,  6, 0 } }, /* kunimi */
    { .label = { 145023,  6, 0 } }, /* miharu */
    { .label = { 124298,  7, 0 } }, /* mishima */
    { .label = {  34002,  5, 0 } }, /* namie */
    { .label = { 160222,  5, 0 } }, /* nango */
    { .label = {  84293,  9, 0 } }, /* nishiaizu */
    { .label = { 124328,  7, 0 } }, /* nishigo */
    { .label = { 107548,  5, 0 } }, /* okuma */
    { .label = { 124358,  7, 0 } }, /* omotego */
    { .label = {   1994,  3, 0 } }, /* ono */
    { .label = { 128184,  5, 0 } }, /* otama */
    { .label = { 102443,  8, 0 } }, /* samegawa */
    { .label = { 124388,  7, 0 } }, /* shimogo */
    { .label = {  14847,  9, 0 } }, /* shirakawa */
    { .label = { 160242,  5, 0 } }, /* showa */
    { .label = { 127987,  4, 0 } }, /* soma */
    { .label = { 102476,  8, 0 } }, /* sukagawa */
    { .label = { 124419,  7, 0 } }, /* taishin */
    { .label = { 102510,  8, 0 } }, /* tamakawa */
    { .label = { 102542,  8, 0 } }, /* tanagura */
    { .label = { 160264,  5, 0 } }, /* tenei */
    { .label = { 145049,  6, 0 } }, /* yabuki */
    { .label = {  26612,  6, 0 } }, /* yamato */
    { .label = {  84333,  9, 0 } }, /* yamatsuri */
    { .label = { 124447,  7, 0 } }, /* yanaizu */
    { .label = { 105310,  6, 0 } }, /* yugawa */

    /* entries 4672 to 4709 */
    { .label = { 124479,  7, 0 } }, /* anpachi */
    { .label = {   2007,  3, 0 } }, /* ena */
    { .label = {  83812,  4, 0 } }, /* gifu */
    { .label = { 160284,  5, 0 } }, /* ginan */
    { .label = { 169340,  4, 0 } }, /* godo */
    { .label = { 169358,  4, 0 } }, /* gujo */
    { .label = { 124509,  7, 0 } }, /* hashima */
    { .label = { 124538,  7, 0 } }, /* hichiso */
    { .label = {  57305,  4, 0 } }, /* hida */
    { .label = {  14817, 16, 0 } }, /* higashishirakawa */
    { .label = { 124569,  7, 0 } }, /* ibigawa */
    { .label = { 160029,  5, 0 } }, /* ikeda */
    { .label = {  42753, 12, 0 } }, /* kakamigahara */
    { .label = {  57185,  4, 0 } }, /* kani */
    { .label = { 102573,  8, 0 } }, /* kasahara */
    { .label = {  84371,  9, 0 } }, /* kasamatsu */
    { .label = { 145078,  6, 0 } }, /* kawaue */
    { .label = { 102603,  8, 0 } }, /* kitagata */
    { .label = {  17419,  4, 0 } }, /* mino */
    { .label = { 102634,  8, 0 } }, /* minokamo */
    { .label = { 106830,  6, 0 } }, /* mitake */
    { .label = { 102668,  8, 0 } }, /* mizunami */
    { .label = { 145104,  6, 0 } }, /* motosu */
    { .label = {  55849, 11, 0 } }, /* nakatsugawa */
    { .label = { 145849,  5, 0 } }, /* ogaki */
    { .label = { 102705,  8, 0 } }, /* sakahogi */
    { .label = {  42816,  4, 0 } }, /* seki */
    { .label = {  70706, 10, 0 } }, /* sekigahara */
    { .label = {  14847,  9, 0 } }, /* shirakawa */
    { .label = { 145130,  6, 0 } }, /* tajimi */
    { .label = { 101229,  8, 0 } }, /* takayama */
    { .label = { 160304,  5, 0 } }, /* tarui */
    { .label = {  84525,  4, 0 } }, /* toki */
    { .label = { 145157,  6, 0 } }, /* tomika */
    { .label = { 102738,  8, 0 } }, /* wanouchi */
    { .label = { 101261,  8, 0 } }, /* yamagata */
    { .label = { 145182,  6, 0 } }, /* yaotsu */
    { .label = { 145623,  4, 0 } }, /* yoro */

    /* entries 4710 to 4745 */
    { .label = { 145208,  6, 0 } }, /* annaka */
    { .label = { 124600,  7, 0 } }, /* chiyoda */
    { .label = { 124632,  7, 0 } }, /* fujioka */
    { .label = {  19580, 15, 0 } }, /* higashiagatsuma */
    { .label = { 124666,  7, 0 } }, /* isesaki */
    { .label = { 124694,  7, 0 } }, /* itakura */
    { .label = { 127846,  5, 0 } }, /* kanna */
    { .label = { 160324,  5, 0 } }, /* kanra */
    { .label = {  84407,  9, 0 } }, /* katashina */
    { .label = { 145230,  6, 0 } }, /* kawaba */
    { .label = { 160343,  5, 0 } }, /* kiryu */
    { .label = { 124722,  7, 0 } }, /* kusatsu */
    { .label = { 102774,  8, 0 } }, /* maebashi */
    { .label = { 160367,  5, 0 } }, /* meiwa */
    { .label = { 144295,  6, 0 } }, /* midori */
    { .label = { 102808,  8, 0 } }, /* minakami */
    { .label = {  70746, 10, 0 } }, /* naganohara */
    { .label = { 102841,  8, 0 } }, /* nakanojo */
    { .label = { 124752,  7, 0 } }, /* nanmoku */
    { .label = { 145256,  6, 0 } }, /* numata */
    { .label = {  87139,  6, 0 } }, /* oizumi */
    { .label = {   1542,  3, 0 } }, /* ora */
    { .label = {   4077,  3, 0 } }, /* ota */
    { .label = {  84442,  9, 0 } }, /* shibukawa */
    { .label = {  84483,  9, 0 } }, /* shimonita */
    { .label = { 103878,  6, 0 } }, /* shinto */
    { .label = { 160242,  5, 0 } }, /* showa */
    { .label = { 102875,  8, 0 } }, /* takasaki */
    { .label = { 101229,  8, 0 } }, /* takayama */
    { .label = { 102906,  8, 0 } }, /* tamamura */
    { .label = {  55894, 11, 0 } }, /* tatebayashi */
    { .label = { 124782,  7, 0 } }, /* tomioka */
    { .label = {  84520,  9, 0 } }, /* tsukiyono */
    { .label = { 102938,  8, 0 } }, /* tsumagoi */
    { .label = {  68975,  4, 0 } }, /* ueno */
    { .label = { 102972,  8, 0 } }, /* yoshioka */

    /* entries 4746 to 4770 */
    { .label = {  84560,  9, 0 } }, /* asaminami */
    { .label = { 128346,  5, 0 } }, /* daiwa */
    { .label = { 124811,  7, 0 } }, /* etajima */
    { .label = { 160389,  5, 0 } }, /* fuchu */
    { .label = { 103007,  8, 0 } }, /* fukuyama */
    { .label = {  55940, 11, 0 } }, /* hatsukaichi */
    { .label = {  14884, 16, 0 } }, /* higashihiroshima */
    { .label = { 160415,  5, 0 } }, /* hongo */
    { .label = {  42801, 12, 0 } }, /* jinsekikogen */
    { .label = { 156466,  5, 0 } }, /* kaita */
    { .label = {  56542,  3, 0 } }, /* kui */
    { .label = { 145280,  6, 0 } }, /* kumano */
    { .label = { 169379,  4, 0 } }, /* kure */
    { .label = {  71176,  6, 0 } }, /* mihara */
    { .label = {  14991,  7, 0 } }, /* miyoshi */
    { .label = {  26687,  4, 0 } }, /* naka */
    { .label = { 103045,  8, 0 } }, /* onomichi */
    { .label = {  34165, 13, 0 } }, /* osakikamijima */
    { .label = { 160437,  5, 0 } }, /* otake */
    { .label = {  26773,  4, 0 } }, /* saka */
    { .label = {  35942,  4, 0 } }, /* sera */
    { .label = {  84595,  9, 0 } }, /* seranishi */
    { .label = { 103080,  8, 0 } }, /* shinichi */
    { .label = { 124841,  7, 0 } }, /* shobara */
    { .label = { 103115,  8, 0 } }, /* takehara */

    /* entries 4771 to 4912 */
    { .label = { 103146,  8, 0 } }, /* abashiri */
    { .label = { 124908,  5, 0 } }, /* abira */
    { .label = { 124870,  7, 0 } }, /* aibetsu */
    { .label = { 124900,  7, 0 } }, /* akabira */
    { .label = { 124928,  7, 0 } }, /* akkeshi */
    { .label = {  84631,  9, 0 } }, /* asahikawa */
    { .label = {  84667,  9, 0 } }, /* ashibetsu */
    { .label = { 145306,  6, 0 } }, /* ashoro */
    { .label = { 145330,  6, 0 } }, /* assabu */
    { .label = {  19618,  6, 0 } }, /* atsuma */
    { .label = { 160457,  5, 0 } }, /* bibai */
    { .label = {   5225,  4, 0 } }, /* biei */
    { .label = { 145355,  6, 0 } }, /* bifuka */
    { .label = { 145384,  6, 0 } }, /* bihoro */
    { .label = { 103179,  8, 0 } }, /* biratori */
    { .label = {  55987, 11, 0 } }, /* chippubetsu */
    { .label = { 124958,  7, 0 } }, /* chitose */
    { .label = {  31826,  4, 0 } }, /* date */
    { .label = { 145411,  6, 0 } }, /* ebetsu */
    { .label = { 124988,  7, 0 } }, /* embetsu */
    { .label = { 147876,  5, 0 } }, /* eniwa */
    { .label = { 160480,  5, 0 } }, /* erimo */
    { .label = {   2217,  4, 0 } }, /* esan */
    { .label = { 145438,  6, 0 } }, /* esashi */
    { .label = { 103212,  8, 0 } }, /* fukagawa */
    { .label = {  34622,  9, 0 } }, /* fukushima */
    { .label = {  43031,  6, 0 } }, /* furano */
    { .label = { 103248,  8, 0 } }, /* furubira */
    { .label = { 145462,  6, 0 } }, /* haboro */
    { .label = { 103285,  8, 0 } }, /* hakodate */
    { .label = {  42855, 12, 0 } }, /* hamatonbetsu */
    { .label = { 145488,  6, 0 } }, /* hidaka */
    { .label = {  34221, 13, 0 } }, /* higashikagura */
    { .label = {  56041, 11, 0 } }, /* higashikawa */
    { .label = { 125275,  5, 0 } }, /* hiroo */
    { .label = { 125020,  7, 0 } }, /* hokuryu */
    { .label = { 145513,  6, 0 } }, /* hokuto */
    { .label = { 103318,  8, 0 } }, /* honbetsu */
    { .label = {  84706,  9, 0 } }, /* horokanai */
    { .label = { 103354,  8, 0 } }, /* horonobe */
    { .label = { 160029,  5, 0 } }, /* ikeda */
    { .label = { 125054,  7, 0 } }, /* imakane */
    { .label = { 103389,  8, 0 } }, /* ishikari */
    { .label = {  84742,  9, 0 } }, /* iwamizawa */
    { .label = { 145540,  6, 0 } }, /* iwanai */
    { .label = {  70784, 10, 0 } }, /* kamifurano */
    { .label = { 103422,  8, 0 } }, /* kamikawa */
    { .label = {  56088, 11, 0 } }, /* kamishihoro */
    { .label = {  42906, 12, 0 } }, /* kamisunagawa */
    { .label = { 103456,  8, 0 } }, /* kamoenai */
    { .label = { 145564,  6, 0 } }, /* kayabe */
    { .label = { 103488,  8, 0 } }, /* kembuchi */
    { .label = { 125082,  7, 0 } }, /* kikonai */
    { .label = {  84783,  9, 0 } }, /* kimobetsu */
    { .label = {  34276, 13, 0 } }, /* kitahiroshima */
    { .label = { 145591,  6, 0 } }, /* kitami */
    { .label = { 103527,  8, 0 } }, /* kiyosato */
    { .label = {  84824,  9, 0 } }, /* koshimizu */
    { .label = { 103561,  8, 0 } }, /* kunneppu */
    { .label = { 103600,  8, 0 } }, /* kuriyama */
    { .label = {  42956, 12, 0 } }, /* kuromatsunai */
    { .label = { 125111,  7, 0 } }, /* kushiro */
    { .label = { 125142,  7, 0 } }, /* kutchan */
    { .label = { 159856,  5, 0 } }, /* kyowa */
    { .label = { 125173,  7, 0 } }, /* mashike */
    { .label = { 103635,  8, 0 } }, /* matsumae */
    { .label = { 127050,  6, 0 } }, /* mikasa */
    { .label = {  43006, 12, 0 } }, /* minamifurano */
    { .label = { 103668,  8, 0 } }, /* mombetsu */
    { .label = { 103705,  8, 0 } }, /* moseushi */
    { .label = { 105247,  6, 0 } }, /* mukawa */
    { .label = { 125203,  7, 0 } }, /* muroran */
    { .label = {  76878,  4, 0 } }, /* naie */
    { .label = { 102213,  8, 0 } }, /* nakagawa */
    { .label = {  43057, 12, 0 } }, /* nakasatsunai */
    { .label = {  43103, 12, 0 } }, /* nakatombetsu */
    { .label = {  57872,  5, 0 } }, /* nanae */
    { .label = { 125232,  7, 0 } }, /* nanporo */
    { .label = { 145616,  6, 0 } }, /* nayoro */
    { .label = { 145641,  6, 0 } }, /* nemuro */
    { .label = { 103740,  8, 0 } }, /* niikappu */
    { .label = {  83620,  4, 0 } }, /* niki */
    { .label = {  56135, 11, 0 } }, /* nishiokoppe */
    { .label = {  56185, 11, 0 } }, /* noboribetsu */
    { .label = { 145256,  6, 0 } }, /* numata */
    { .label = { 125261,  7, 0 } }, /* obihiro */
    { .label = { 103264,  5, 0 } }, /* obira */
    { .label = { 160501,  5, 0 } }, /* oketo */
    { .label = {  56156,  6, 0 } }, /* okoppe */
    { .label = { 160522,  5, 0 } }, /* otaru */
    { .label = { 160542,  5, 0 } }, /* otobe */
    { .label = { 125292,  7, 0 } }, /* otofuke */
    { .label = {  84867,  9, 0 } }, /* otoineppu */
    { .label = { 169397,  4, 0 } }, /* oumu */
    { .label = { 155825,  5, 0 } }, /* ozora */
    { .label = { 160564,  5, 0 } }, /* pippu */
    { .label = { 103777,  8, 0 } }, /* rankoshi */
    { .label = { 160591,  5, 0 } }, /* rebun */
    { .label = {  84908,  9, 0 } }, /* rikubetsu */
    { .label = {  56234,  7, 0 } }, /* rishiri */
    { .label = {  56234, 11, 0 } }, /* rishirifuji */
    { .label = { 145667,  6, 0 } }, /* saroma */
    { .label = {  84949,  9, 0 } }, /* sarufutsu */
    { .label = { 103810,  8, 0 } }, /* shakotan */
    { .label = { 160614,  5, 0 } }, /* shari */
    { .label = { 103842,  8, 0 } }, /* shibecha */
    { .label = {  84670,  8, 0 } }, /* shibetsu */
    { .label = { 125324,  7, 0 } }, /* shikabe */
    { .label = { 125355,  7, 0 } }, /* shikaoi */
    { .label = {  84989,  9, 0 } }, /* shimamaki */
    { .label = {  56584,  7, 0 } }, /* shimizu */
    { .label = {  85027,  9, 0 } }, /* shimokawa */
    { .label = {  43154, 12, 0 } }, /* shinshinotsu */
    { .label = { 103878,  8, 0 } }, /* shintoku */
    { .label = {  85066,  9, 0 } }, /* shiranuka */
    { .label = { 125384,  7, 0 } }, /* shiraoi */
    { .label = {  85103,  9, 0 } }, /* shiriuchi */
    { .label = { 125412,  7, 0 } }, /* sobetsu */
    { .label = {  42923,  8, 0 } }, /* sunagawa */
    { .label = { 160634,  5, 0 } }, /* taiki */
    { .label = { 145690,  6, 0 } }, /* takasu */
    { .label = { 103913,  8, 0 } }, /* takikawa */
    { .label = { 103946,  8, 0 } }, /* takinoue */
    { .label = {  85143,  9, 0 } }, /* teshikaga */
    { .label = { 104019,  7, 0 } }, /* tobetsu */
    { .label = { 160654,  5, 0 } }, /* tohma */
    { .label = {  85180,  9, 0 } }, /* tomakomai */
    { .label = { 145714,  6, 0 } }, /* tomari */
    { .label = {  15066,  4, 0 } }, /* toya */
    { .label = { 145738,  6, 0 } }, /* toyako */
    { .label = { 103979,  8, 0 } }, /* toyotomi */
    { .label = { 125443,  7, 0 } }, /* toyoura */
    { .label = { 104014,  8, 0 } }, /* tsubetsu */
    { .label = {  85217,  9, 0 } }, /* tsukigata */
    { .label = { 125473,  7, 0 } }, /* urakawa */
    { .label = { 145764,  6, 0 } }, /* urausu */
    { .label = { 125034,  4, 0 } }, /* uryu */
    { .label = {  85254,  9, 0 } }, /* utashinai */
    { .label = { 104050,  8, 0 } }, /* wakkanai */
    { .label = { 125502,  7, 0 } }, /* wassamu */
    { .label = { 145790,  6, 0 } }, /* yakumo */
    { .label = { 145818,  6, 0 } }, /* yoichi */

    /* entries 4913 to 4958 */
    { .label = { 128318,  4, 0 } }, /* aioi */
    { .label = {  86595,  6, 0 } }, /* akashi */
    { .label = {  11519,  3, 0 } }, /* ako */
    { .label = {  85290,  9, 0 } }, /* amagasaki */
    { .label = { 145846,  6, 0 } }, /* aogaki */
    { .label = { 104231,  5, 0 } }, /* asago */
    { .label = {  34845,  6, 0 } }, /* ashiya */
    { .label = {  56310,  5, 0 } }, /* awaji */
    { .label = { 104083,  8, 0 } }, /* fukusaki */
    { .label = { 125532,  7, 0 } }, /* goshiki */
    { .label = { 145870,  6, 0 } }, /* harima */
    { .label = { 145894,  6, 0 } }, /* himeji */
    { .label = {  26788,  8, 0 } }, /* ichikawa */
    { .label = {  88198,  7, 0 } }, /* inagawa */
    { .label = { 145596,  5, 0 } }, /* itami */
    { .label = { 104120,  8, 0 } }, /* kakogawa */
    { .label = { 104154,  8, 0 } }, /* kamigori */
    { .label = { 103422,  8, 0 } }, /* kamikawa */
    { .label = {  73877,  5, 0 } }, /* kasai */
    { .label = { 123397,  6, 0 } }, /* kasuga */
    { .label = {  85325,  9, 0 } }, /* kawanishi */
    { .label = {  43518,  4, 0 } }, /* miki */
    { .label = {  56285, 11, 0 } }, /* minamiawaji */
    { .label = {  56333, 11, 0 } }, /* nishinomiya */
    { .label = {  85363,  9, 0 } }, /* nishiwaki */
    { .label = {   1994,  3, 0 } }, /* ono */
    { .label = { 160675,  5, 0 } }, /* sanda */
    { .label = { 145923,  6, 0 } }, /* sannan */
    { .label = { 104188,  8, 0 } }, /* sasayama */
    { .label = { 149268,  4, 0 } }, /* sayo */
    { .label = { 144770,  6, 0 } }, /* shingu */
    { .label = {  85402,  9, 0 } }, /* shinonsen */
    { .label = { 160694,  5, 0 } }, /* shiso */
    { .label = {  85687,  6, 0 } }, /* sumoto */
    { .label = { 124419,  6, 0 } }, /* taishi */
    { .label = {  20133,  4, 0 } }, /* taka */
    { .label = {  70827, 10, 0 } }, /* takarazuka */
    { .label = { 104219,  8, 0 } }, /* takasago */
    { .label = { 103946,  6, 0 } }, /* takino */
    { .label = { 105593,  5, 0 } }, /* tamba */
    { .label = { 125563,  7, 0 } }, /* tatsuno */
    { .label = { 125591,  7, 0 } }, /* toyooka */
    { .label = { 145049,  4, 0 } }, /* yabu */
    { .label = {  87502,  7, 0 } }, /* yashiro */
    { .label = {  70405,  4, 0 } }, /* yoka */
    { .label = { 101466,  6, 0 } }, /* yokawa */

    /* entries 4959 to 5009 */
    { .label = {   3784,  3, 0 } }, /* ami */
    { .label = {  70178,  5, 0 } }, /* asahi */
    { .label = { 160715,  5, 0 } }, /* bando */
    { .label = { 104250,  8, 0 } }, /* chikusei */
    { .label = { 160737,  5, 0 } }, /* daigo */
    { .label = {  85439,  9, 0 } }, /* fujishiro */
    { .label = {  43205,  7, 0 } }, /* hitachi */
    { .label = {  56380, 11, 0 } }, /* hitachinaka */
    { .label = {  43205, 12, 0 } }, /* hitachiomiya */
    { .label = {  70869, 10, 0 } }, /* hitachiota */
    { .label = { 123018,  7, 0 } }, /* ibaraki */
    { .label = {    694,  3, 0 } }, /* ina */
    { .label = { 104286,  8, 0 } }, /* inashiki */
    { .label = { 160758,  5, 0 } }, /* itako */
    { .label = { 147859,  5, 0 } }, /* iwama */
    { .label = { 169416,  4, 0 } }, /* joso */
    { .label = {  42906,  6, 0 } }, /* kamisu */
    { .label = {  84371,  6, 0 } }, /* kasama */
    { .label = {  87617,  7, 0 } }, /* kashima */
    { .label = {  56425, 11, 0 } }, /* kasumigaura */
    { .label = {  75234,  4, 0 } }, /* koga */
    { .label = { 169435,  4, 0 } }, /* miho */
    { .label = {  51743,  4, 0 } }, /* mito */
    { .label = { 107751,  6, 0 } }, /* moriya */
    { .label = {  26687,  4, 0 } }, /* naka */
    { .label = { 104319,  8, 0 } }, /* namegata */
    { .label = { 112949,  5, 0 } }, /* oarai */
    { .label = {  19750,  5, 0 } }, /* ogawa */
    { .label = { 125621,  7, 0 } }, /* omitama */
    { .label = {  85482,  9, 0 } }, /* ryugasaki */
    { .label = {  26773,  5, 0 } }, /* sakai */
    { .label = {  70910, 10, 0 } }, /* sakuragawa */
    { .label = {  85521,  9, 0 } }, /* shimodate */
    { .label = {  70951, 10, 0 } }, /* shimotsuma */
    { .label = {  85559,  9, 0 } }, /* shirosato */
    { .label = {   9628,  4, 0 } }, /* sowa */
    { .label = { 160778,  5, 0 } }, /* suifu */
    { .label = { 104350,  8, 0 } }, /* takahagi */
    { .label = {  56471, 11, 0 } }, /* tamatsukuri */
    { .label = {  55953,  5, 0 } }, /* tokai */
    { .label = { 145945,  6, 0 } }, /* tomobe */
    { .label = {  61322,  4, 0 } }, /* tone */
    { .label = { 145972,  6, 0 } }, /* toride */
    { .label = {  85595,  9, 0 } }, /* tsuchiura */
    { .label = { 125649,  7, 0 } }, /* tsukuba */
    { .label = { 104382,  8, 0 } }, /* uchihara */
    { .label = { 145997,  6, 0 } }, /* ushiku */
    { .label = { 123898,  7, 0 } }, /* yachiyo */
    { .label = { 101261,  8, 0 } }, /* yamagata */
    { .label = { 146025,  6, 0 } }, /* yawara */
    { .label = { 146190,  4, 0 } }, /* yuki */

    /* entries 5010 to 5028 */
    { .label = { 125681,  7, 0 } }, /* anamizu */
    { .label = { 160802,  5, 0 } }, /* hakui */
    { .label = { 125712,  7, 0 } }, /* hakusan */
    { .label = {  34415,  4, 0 } }, /* kaga */
    { .label = { 145505,  6, 0 } }, /* kahoku */
    { .label = { 104416,  8, 0 } }, /* kanazawa */
    { .label = { 104450,  8, 0 } }, /* kawakita */
    { .label = {  44014,  7, 0 } }, /* komatsu */
    { .label = { 104483,  8, 0 } }, /* nakanoto */
    { .label = { 160824,  5, 0 } }, /* nanao */
    { .label = {  43350,  4, 0 } }, /* nomi */
    { .label = { 104514,  8, 0 } }, /* nonoichi */
    { .label = { 103989,  4, 0 } }, /* noto */
    { .label = {  34238,  5, 0 } }, /* shika */
    { .label = { 146775,  4, 0 } }, /* suzu */
    { .label = { 125741,  7, 0 } }, /* tsubata */
    { .label = { 125770,  7, 0 } }, /* tsurugi */
    { .label = { 104548,  8, 0 } }, /* uchinada */
    { .label = { 107491,  6, 0 } }, /* wajima */

    /* entries 5029 to 5062 */
    { .label = { 160842,  5, 0 } }, /* fudai */
    { .label = { 104582,  8, 0 } }, /* fujisawa */
    { .label = { 104620,  8, 0 } }, /* hanamaki */
    { .label = {  85634,  9, 0 } }, /* hiraizumi */
    { .label = { 144948,  6, 0 } }, /* hirono */
    { .label = {  70246,  8, 0 } }, /* ichinohe */
    { .label = {  70994, 10, 0 } }, /* ichinoseki */
    { .label = { 104652,  8, 0 } }, /* iwaizumi */
    { .label = {  20808,  5, 0 } }, /* iwate */
    { .label = { 146050,  6, 0 } }, /* joboji */
    { .label = { 104690,  8, 0 } }, /* kamaishi */
    { .label = {  71037, 10, 0 } }, /* kanegasaki */
    { .label = { 125801,  7, 0 } }, /* karumai */
    { .label = { 160865,  5, 0 } }, /* kawai */
    { .label = { 104723,  8, 0 } }, /* kitakami */
    { .label = { 169453,  4, 0 } }, /* kuji */
    { .label = { 101638,  6, 0 } }, /* kunohe */
    { .label = { 104756,  8, 0 } }, /* kuzumaki */
    { .label = {  71413,  6, 0 } }, /* miyako */
    { .label = { 104795,  8, 0 } }, /* mizusawa */
    { .label = { 125830,  7, 0 } }, /* morioka */
    { .label = { 146082,  6, 0 } }, /* ninohe */
    { .label = {  97983,  4, 0 } }, /* noda */
    { .label = { 125859,  7, 0 } }, /* ofunato */
    { .label = {  70053,  4, 0 } }, /* oshu */
    { .label = {  85591,  7, 0 } }, /* otsuchi */
    { .label = {  34330, 13, 0 } }, /* rikuzentakata */
    { .label = {  56817,  5, 0 } }, /* shiwa */
    { .label = {  56517, 11, 0 } }, /* shizukuishi */
    { .label = { 146107,  6, 0 } }, /* sumita */
    { .label = { 104832,  8, 0 } }, /* tanohata */
    { .label = {  43342,  4, 0 } }, /* tono */
    { .label = { 146132,  6, 0 } }, /* yahaba */
    { .label = { 144847,  6, 0 } }, /* yamada */

    /* entries 5063 to 5077 */
    { .label = { 107047,  7, 0 } }, /* ayagawa */
    { .label = {  34385, 13, 0 } }, /* higashikagawa */
    { .label = { 125889,  7, 0 } }, /* kanonji */
    { .label = { 104862,  8, 0 } }, /* kotohira */
    { .label = { 118863,  5, 0 } }, /* manno */
    { .label = { 104895,  8, 0 } }, /* marugame */
    { .label = { 146158,  6, 0 } }, /* mitoyo */
    { .label = { 104929,  8, 0 } }, /* naoshima */
    { .label = { 146185,  6, 0 } }, /* sanuki */
    { .label = { 125920,  7, 0 } }, /* tadotsu */
    { .label = {  34129,  9, 0 } }, /* takamatsu */
    { .label = { 125949,  7, 0 } }, /* tonosho */
    { .label = { 104961,  8, 0 } }, /* uchinomi */
    { .label = { 160886,  5, 0 } }, /* utazu */
    { .label = { 104997,  8, 0 } }, /* zentsuji */

    /* entries 5078 to 5097 */
    { .label = { 160910,  5, 0 } }, /* akune */
    { .label = { 148174,  5, 0 } }, /* amami */
    { .label = { 160931,  5, 0 } }, /* hioki */
    { .label = {   9322,  3, 0 } }, /* isa */
    { .label = {  50976,  4, 0 } }, /* isen */
    { .label = {  70583,  5, 0 } }, /* izumi */
    { .label = {  83176,  9, 0 } }, /* kagoshima */
    { .label = { 146210,  6, 0 } }, /* kanoya */
    { .label = { 105036,  8, 0 } }, /* kawanabe */
    { .label = { 160953,  5, 0 } }, /* kinko */
    { .label = { 125978,  7, 0 } }, /* kouyama */
    { .label = {  71077, 10, 0 } }, /* makurazaki */
    { .label = {  85675,  9, 0 } }, /* matsumoto */
    { .label = {  71121, 10, 0 } }, /* minamitane */
    { .label = { 105070,  8, 0 } }, /* nakatane */
    { .label = {  43257, 12, 0 } }, /* nishinoomote */
    { .label = {  34440, 13, 0 } }, /* satsumasendai */
    { .label = {  21169,  3, 0 } }, /* soo */
    { .label = { 105100,  8, 0 } }, /* tarumizu */
    { .label = { 160975,  5, 0 } }, /* yusui */

    /* entries 5098 to 5127 */
    { .label = {  71364,  6, 0 } }, /* aikawa */
    { .label = { 146235,  6, 0 } }, /* atsugi */
    { .label = { 160999,  5, 0 } }, /* ayase */
    { .label = {  85713,  9, 0 } }, /* chigasaki */
    { .label = { 161019,  5, 0 } }, /* ebina */
    { .label = { 104582,  8, 0 } }, /* fujisawa */
    { .label = { 146260,  6, 0 } }, /* hadano */
    { .label = { 146284,  6, 0 } }, /* hakone */
    { .label = {  85751,  9, 0 } }, /* hiratsuka */
    { .label = { 126009,  7, 0 } }, /* isehara */
    { .label = { 146309,  6, 0 } }, /* kaisei */
    { .label = { 105137,  8, 0 } }, /* kamakura */
    { .label = { 105170,  8, 0 } }, /* kiyokawa */
    { .label = { 126036,  7, 0 } }, /* matsuda */
    { .label = {  26495, 14, 0 } }, /* minamiashigara */
    { .label = { 161040,  5, 0 } }, /* miura */
    { .label = { 148955,  5, 0 } }, /* nakai */
    { .label = { 105206,  8, 0 } }, /* ninomiya */
    { .label = { 126065,  7, 0 } }, /* odawara */
    { .label = {     23,  2, 0 } }, /* oi */
    { .label = { 125404,  4, 0 } }, /* oiso */
    { .label = {  71161, 10, 0 } }, /* sagamihara */
    { .label = { 105240,  8, 0 } }, /* samukawa */
    { .label = { 146333,  6, 0 } }, /* tsukui */
    { .label = {  26654,  8, 0 } }, /* yamakita */
    { .label = {  26612,  6, 0 } }, /* yamato */
    { .label = { 105274,  8, 0 } }, /* yokosuka */
    { .label = { 105310,  8, 0 } }, /* yugawara */
    { .label = {  40903,  4, 0 } }, /* zama */
    { .label = {  72330,  5, 0 } }, /* zushi */

    /* entries 5128 to 5158 */
    { .label = {   5929,  3, 0 } }, /* aki */
    { .label = { 146360,  6, 0 } }, /* geisei */
    { .label = { 145488,  6, 0 } }, /* hidaka */
    { .label = {  43307, 12, 0 } }, /* higashitsuno */
    { .label = {    485,  3, 0 } }, /* ino */
    { .label = {  70664,  6, 0 } }, /* kagami */
    { .label = {  34185,  4, 0 } }, /* kami */
    { .label = { 105345,  8, 0 } }, /* kitagawa */
    { .label = { 159685,  5, 0 } }, /* kochi */
    { .label = {  71176,  6, 0 } }, /* mihara */
    { .label = { 105378,  8, 0 } }, /* motoyama */
    { .label = { 146385,  6, 0 } }, /* muroto */
    { .label = { 146411,  6, 0 } }, /* nahari */
    { .label = { 105412,  8, 0 } }, /* nakamura */
    { .label = { 126093,  7, 0 } }, /* nankoku */
    { .label = {  85788,  9, 0 } }, /* nishitosa */
    { .label = {  71200, 10, 0 } }, /* niyodogawa */
    { .label = {  20013,  4, 0 } }, /* ochi */
    { .label = {  72039,  5, 0 } }, /* okawa */
    { .label = { 125439,  5, 0 } }, /* otoyo */
    { .label = { 146434,  6, 0 } }, /* otsuki */
    { .label = { 124274,  6, 0 } }, /* sakawa */
    { .label = { 146460,  6, 0 } }, /* sukumo */
    { .label = { 146488,  6, 0 } }, /* susaki */
    { .label = {  56569,  4, 0 } }, /* tosa */
    { .label = {  56569, 11, 0 } }, /* tosashimizu */
    { .label = {  83552,  4, 0 } }, /* toyo */
    { .label = {  43337,  5, 0 } }, /* tsuno */
    { .label = { 161061,  5, 0 } }, /* umaji */
    { .label = { 146513,  6, 0 } }, /* yasuda */
    { .label = { 105444,  8, 0 } }, /* yusuhara */

    /* entries 5159 to 5181 */
    { .label = {  56635,  7, 0 } }, /* amakusa */
    { .label = {  32342,  4, 0 } }, /* arao */
    { .label = {    128,  3, 0 } }, /* aso */
    { .label = { 161085,  5, 0 } }, /* choyo */
    { .label = { 126123,  7, 0 } }, /* gyokuto */
    { .label = {  56618, 11, 0 } }, /* kamiamakusa */
    { .label = { 126156,  7, 0 } }, /* kikuchi */
    { .label = { 101087,  8, 0 } }, /* kumamoto */
    { .label = { 126189,  7, 0 } }, /* mashiki */
    { .label = { 146539,  6, 0 } }, /* mifune */
    { .label = { 105479,  8, 0 } }, /* minamata */
    { .label = {  56663, 11, 0 } }, /* minamioguni */
    { .label = { 146567,  6, 0 } }, /* nagasu */
    { .label = {  85824,  9, 0 } }, /* nishihara */
    { .label = {  56688,  5, 0 } }, /* oguni */
    { .label = {  72326,  3, 0 } }, /* ozu */
    { .label = {  85687,  6, 0 } }, /* sumoto */
    { .label = { 105510,  8, 0 } }, /* takamori */
    { .label = {   7845,  3, 0 } }, /* uki */
    { .label = {  27139,  3, 0 } }, /* uto */
    { .label = { 101261,  6, 0 } }, /* yamaga */
    { .label = {  26612,  6, 0 } }, /* yamato */
    { .label = {  71244, 10, 0 } }, /* yatsushiro */

    /* entries 5182 to 5212 */
    { .label = { 145569,  5, 0 } }, /* ayabe */
    { .label = {  56710, 11, 0 } }, /* fukuchiyama */
    { .label = {  34831, 11, 0 } }, /* higashiyama */
    { .label = {   2010,  3, 0 } }, /* ide */
    { .label = {    100,  3, 0 } }, /* ine */
    { .label = { 161528,  4, 0 } }, /* joyo */
    { .label = { 126219,  7, 0 } }, /* kameoka */
    { .label = { 101731,  4, 0 } }, /* kamo */
    { .label = {  26671,  4, 0 } }, /* kita */
    { .label = { 104660,  4, 0 } }, /* kizu */
    { .label = { 105542,  8, 0 } }, /* kumiyama */
    { .label = { 105578,  8, 0 } }, /* kyotamba */
    { .label = {  85860,  9, 0 } }, /* kyotanabe */
    { .label = { 105614,  8, 0 } }, /* kyotango */
    { .label = { 126248,  7, 0 } }, /* maizuru */
    { .label = {  19642,  6, 0 } }, /* minami */
    { .label = {  19642, 15, 0 } }, /* minamiyamashiro */
    { .label = { 146591,  6, 0 } }, /* miyazu */
    { .label = { 169474,  4, 0 } }, /* muko */
    { .label = {  71287, 10, 0 } }, /* nagaokakyo */
    { .label = { 126281,  7, 0 } }, /* nakagyo */
    { .label = { 146621,  6, 0 } }, /* nantan */
    { .label = {  85899,  9, 0 } }, /* oyamazaki */
    { .label = { 161109,  5, 0 } }, /* sakyo */
    { .label = { 161131,  5, 0 } }, /* seika */
    { .label = {  85875,  6, 0 } }, /* tanabe */
    { .label = {  19974,  3, 0 } }, /* uji */
    { .label = {  85939,  9, 0 } }, /* ujitawara */
    { .label = { 146643,  6, 0 } }, /* wazuka */
    { .label = {  85978,  9, 0 } }, /* yamashina */
    { .label = {  70494,  6, 0 } }, /* yawata */

    /* entries 5213 to 5242 */
    { .label = {  70178,  5, 0 } }, /* asahi */
    { .label = { 161151,  5, 0 } }, /* inabe */
    { .label = {  20294,  3, 0 } }, /* ise */
    { .label = { 105649,  8, 0 } }, /* kameyama */
    { .label = { 126311,  7, 0 } }, /* kawagoe */
    { .label = { 144470,  4, 0 } }, /* kiho */
    { .label = { 105683,  8, 0 } }, /* kisosaki */
    { .label = { 144513,  4, 0 } }, /* kiwa */
    { .label = { 146672,  6, 0 } }, /* komono */
    { .label = { 145280,  6, 0 } }, /* kumano */
    { .label = { 146698,  6, 0 } }, /* kuwana */
    { .label = {  86015,  9, 0 } }, /* matsusaka */
    { .label = { 160367,  5, 0 } }, /* meiwa */
    { .label = { 107171,  6, 0 } }, /* mihama */
    { .label = {  86051,  9, 0 } }, /* minamiise */
    { .label = { 146724,  6, 0 } }, /* misugi */
    { .label = {  19658,  6, 0 } }, /* miyama */
    { .label = { 146751,  6, 0 } }, /* nabari */
    { .label = {  11233,  5, 0 } }, /* shima */
    { .label = { 146775,  6, 0 } }, /* suzuka */
    { .label = {  39148,  4, 0 } }, /* tado */
    { .label = { 160634,  5, 0 } }, /* taiki */
    { .label = {  42817,  4, 0 } }, /* taki */
    { .label = { 146804,  6, 0 } }, /* tamaki */
    { .label = {  87272,  4, 0 } }, /* toba */
    { .label = {  11254,  3, 0 } }, /* tsu */
    { .label = { 102325,  5, 0 } }, /* udono */
    { .label = { 105716,  8, 0 } }, /* ureshino */
    { .label = { 126341,  7, 0 } }, /* watarai */
    { .label = {  86088,  9, 0 } }, /* yokkaichi */

    /* entries 5243 to 5274 */
    { .label = { 105750,  8, 0 } }, /* furukawa */
    { .label = {  11216, 17, 0 } }, /* higashimatsushima */
    { .label = {  71329, 10, 0 } }, /* ishinomaki */
    { .label = { 126368,  7, 0 } }, /* iwanuma */
    { .label = {  88675,  6, 0 } }, /* kakuda */
    { .label = {  34185,  4, 0 } }, /* kami */
    { .label = { 101293,  8, 0 } }, /* kawasaki */
    { .label = { 105787,  8, 0 } }, /* marumori */
    { .label = {  11246, 10, 0 } }, /* matsushima */
    { .label = {  34492, 13, 0 } }, /* minamisanriku */
    { .label = {  26823,  6, 0 } }, /* misato */
    { .label = { 146828,  6, 0 } }, /* murata */
    { .label = {  56219,  6, 0 } }, /* natori */
    { .label = { 105317,  7, 0 } }, /* ogawara */
    { .label = { 104875,  5, 0 } }, /* ohira */
    { .label = {  42928,  7, 0 } }, /* onagawa */
    { .label = {  34165,  5, 0 } }, /* osaki */
    { .label = {  56255,  4, 0 } }, /* rifu */
    { .label = { 146852,  6, 0 } }, /* semine */
    { .label = { 126398,  7, 0 } }, /* shibata */
    { .label = {  34546, 13, 0 } }, /* shichikashuku */
    { .label = { 126427,  7, 0 } }, /* shikama */
    { .label = { 105821,  8, 0 } }, /* shiogama */
    { .label = {  86129,  9, 0 } }, /* shiroishi */
    { .label = { 146877,  6, 0 } }, /* tagajo */
    { .label = { 161172,  5, 0 } }, /* taiwa */
    { .label = {  50952,  4, 0 } }, /* tome */
    { .label = { 101114,  6, 0 } }, /* tomiya */
    { .label = { 146903,  6, 0 } }, /* wakuya */
    { .label = { 146931,  6, 0 } }, /* watari */
    { .label = { 105854,  8, 0 } }, /* yamamoto */
    { .label = {  42303,  3, 0 } }, /* zao */

    /* entries 5275 to 5301 */
    { .label = {   5992,  3, 0 } }, /* aya */
    { .label = { 161192,  5, 0 } }, /* ebino */
    { .label = { 146955,  6, 0 } }, /* gokase */
    { .label = { 161214,  5, 0 } }, /* hyuga */
    { .label = { 105888,  8, 0 } }, /* kadogawa */
    { .label = {  71371, 10, 0 } }, /* kawaminami */
    { .label = { 169493,  4, 0 } }, /* kijo */
    { .label = { 105345,  8, 0 } }, /* kitagawa */
    { .label = { 102412,  8, 0 } }, /* kitakata */
    { .label = { 126456,  7, 0 } }, /* kitaura */
    { .label = {  86167,  9, 0 } }, /* kobayashi */
    { .label = { 105922,  8, 0 } }, /* kunitomi */
    { .label = {  34633,  7, 0 } }, /* kushima */
    { .label = { 146980,  6, 0 } }, /* mimata */
    { .label = {  71413, 10, 0 } }, /* miyakonojo */
    { .label = { 101122,  8, 0 } }, /* miyazaki */
    { .label = {  86207,  9, 0 } }, /* morotsuka */
    { .label = { 105957,  8, 0 } }, /* nichinan */
    { .label = {  86245,  9, 0 } }, /* nishimera */
    { .label = { 126484,  7, 0 } }, /* nobeoka */
    { .label = { 161238,  5, 0 } }, /* saito */
    { .label = { 147004,  6, 0 } }, /* shiiba */
    { .label = { 105990,  8, 0 } }, /* shintomi */
    { .label = { 106024,  8, 0 } }, /* takaharu */
    { .label = { 106056,  8, 0 } }, /* takanabe */
    { .label = { 106088,  8, 0 } }, /* takazaki */
    { .label = {  43337,  5, 0 } }, /* tsuno */

    /* entries 5302 to 5376 */
    { .label = {    187,  4, 0 } }, /* achi */
    { .label = { 106122,  8, 0 } }, /* agematsu */
    { .label = {  15116,  4, 0 } }, /* anan */
    { .label = {  34679,  4, 0 } }, /* aoki */
    { .label = {  70178,  5, 0 } }, /* asahi */
    { .label = { 126514,  7, 0 } }, /* azumino */
    { .label = {  86282,  9, 0 } }, /* chikuhoku */
    { .label = { 126546,  7, 0 } }, /* chikuma */
    { .label = {  70117,  5, 0 } }, /* chino */
    { .label = {  56263,  6, 0 } }, /* fujimi */
    { .label = { 147030,  6, 0 } }, /* hakuba */
    { .label = {  42786,  4, 0 } }, /* hara */
    { .label = { 147057,  6, 0 } }, /* hiraya */
    { .label = {  75110,  4, 0 } }, /* iida */
    { .label = { 147082,  6, 0 } }, /* iijima */
    { .label = { 147109,  6, 0 } }, /* iiyama */
    { .label = { 147134,  6, 0 } }, /* iizuna */
    { .label = { 160029,  5, 0 } }, /* ikeda */
    { .label = { 126578,  7, 0 } }, /* ikusaka */
    { .label = {    694,  3, 0 } }, /* ina */
    { .label = {  86325,  9, 0 } }, /* karuizawa */
    { .label = {  56071,  8, 0 } }, /* kawakami */
    { .label = {   6537,  4, 0 } }, /* kiso */
    { .label = {  34605, 13, 0 } }, /* kisofukushima */
    { .label = { 106155,  8, 0 } }, /* kitaaiki */
    { .label = { 106187,  8, 0 } }, /* komagane */
    { .label = { 147161,  6, 0 } }, /* komoro */
    { .label = {  86365,  9, 0 } }, /* matsukawa */
    { .label = {  85675,  9, 0 } }, /* matsumoto */
    { .label = { 161257,  5, 0 } }, /* miasa */
    { .label = {  71459, 10, 0 } }, /* minamiaiki */
    { .label = {  71500, 10, 0 } }, /* minamimaki */
    { .label = {  43358, 12, 0 } }, /* minamiminowa */
    { .label = {  43383,  6, 0 } }, /* minowa */
    { .label = { 147187,  6, 0 } }, /* miyada */
    { .label = { 147213,  6, 0 } }, /* miyota */
    { .label = {  86403,  9, 0 } }, /* mochizuki */
    { .label = {  34750,  6, 0 } }, /* nagano */
    { .label = {  42932,  6, 0 } }, /* nagawa */
    { .label = { 147239,  6, 0 } }, /* nagiso */
    { .label = { 102213,  8, 0 } }, /* nakagawa */
    { .label = { 102841,  6, 0 } }, /* nakano */
    { .label = {  56762, 11, 0 } }, /* nozawaonsen */
    { .label = {  13487,  5, 0 } }, /* obuse */
    { .label = {  19750,  5, 0 } }, /* ogawa */
    { .label = { 108759,  5, 0 } }, /* okaya */
    { .label = {  43433,  6, 0 } }, /* omachi */
    { .label = {  14987,  3, 0 } }, /* omi */
    { .label = { 147263,  6, 0 } }, /* ookuwa */
    { .label = { 126607,  7, 0 } }, /* ooshika */
    { .label = { 103909,  5, 0 } }, /* otaki */
    { .label = { 161276,  5, 0 } }, /* otari */
    { .label = { 159966,  5, 0 } }, /* sakae */
    { .label = { 147290,  6, 0 } }, /* sakaki */
    { .label = {  70910,  4, 0 } }, /* saku */
    { .label = { 147314,  6, 0 } }, /* sakuho */
    { .label = {  86447,  9, 0 } }, /* shimosuwa */
    { .label = {  43409, 12, 0 } }, /* shinanomachi */
    { .label = { 106220,  8, 0 } }, /* shiojiri */
    { .label = {  86469,  4, 0 } }, /* suwa */
    { .label = { 147340,  6, 0 } }, /* suzaka */
    { .label = { 147367,  6, 0 } }, /* takagi */
    { .label = { 105510,  8, 0 } }, /* takamori */
    { .label = { 101229,  8, 0 } }, /* takayama */
    { .label = {  86487,  9, 0 } }, /* tateshina */
    { .label = { 125563,  7, 0 } }, /* tatsuno */
    { .label = {  86522,  9, 0 } }, /* togakushi */
    { .label = { 147391,  6, 0 } }, /* togura */
    { .label = {  14983,  4, 0 } }, /* tomi */
    { .label = {  44675,  4, 0 } }, /* ueda */
    { .label = {  87242,  4, 0 } }, /* wada */
    { .label = { 101261,  8, 0 } }, /* yamagata */
    { .label = {  71542, 10, 0 } }, /* yamanouchi */
    { .label = { 147416,  6, 0 } }, /* yasaka */
    { .label = { 126636,  7, 0 } }, /* yasuoka */

    /* entries 5377 to 5398 */
    { .label = { 126666,  7, 0 } }, /* chijiwa */
    { .label = {  84965,  5, 0 } }, /* futsu */
    { .label = {  43493,  4, 0 } }, /* goto */
    { .label = { 147440,  6, 0 } }, /* hasami */
    { .label = { 147464,  6, 0 } }, /* hirado */
    { .label = {  43523,  3, 0 } }, /* iki */
    { .label = { 126700,  7, 0 } }, /* isahaya */
    { .label = { 102525,  8, 0 } }, /* kawatana */
    { .label = {  71586, 10, 0 } }, /* kuchinotsu */
    { .label = { 106256,  8, 0 } }, /* matsuura */
    { .label = { 101159,  8, 0 } }, /* nagasaki */
    { .label = { 160050,  5, 0 } }, /* obama */
    { .label = { 161295,  5, 0 } }, /* omura */
    { .label = { 106693,  5, 0 } }, /* oseto */
    { .label = { 147489,  6, 0 } }, /* saikai */
    { .label = { 147512,  6, 0 } }, /* sasebo */
    { .label = { 110035,  5, 0 } }, /* seihi */
    { .label = {  86561,  9, 0 } }, /* shimabara */
    { .label = {  43459, 12, 0 } }, /* shinkamigoto */
    { .label = { 126728,  7, 0 } }, /* togitsu */
    { .label = {  11254,  8, 0 } }, /* tsushima */
    { .label = { 161316,  5, 0 } }, /* unzen */

    /* entries 5399 to 5436 */
    { .label = {  17126,  4, 0 } }, /* ando */
    { .label = { 124971,  4, 0 } }, /* gose */
    { .label = { 147537,  6, 0 } }, /* heguri */
    { .label = {  26551, 14, 0 } }, /* higashiyoshino */
    { .label = { 126758,  7, 0 } }, /* ikaruga */
    { .label = { 106183,  5, 0 } }, /* ikoma */
    { .label = {  43510, 12, 0 } }, /* kamikitayama */
    { .label = { 126787,  7, 0 } }, /* kanmaki */
    { .label = { 126816,  7, 0 } }, /* kashiba */
    { .label = {  86598,  9, 0 } }, /* kashihara */
    { .label = {  86634,  9, 0 } }, /* katsuragi */
    { .label = { 160865,  5, 0 } }, /* kawai */
    { .label = {  56071,  8, 0 } }, /* kawakami */
    { .label = {  85325,  9, 0 } }, /* kawanishi */
    { .label = { 161340,  5, 0 } }, /* koryo */
    { .label = { 106289,  8, 0 } }, /* kurotaki */
    { .label = { 106532,  6, 0 } }, /* mitsue */
    { .label = { 147564,  6, 0 } }, /* miyake */
    { .label = {   8212,  4, 0 } }, /* nara */
    { .label = { 106323,  8, 0 } }, /* nosegawa */
    { .label = {    299,  3, 0 } }, /* oji */
    { .label = {  13913,  4, 0 } }, /* ouda */
    { .label = { 161363,  5, 0 } }, /* oyodo */
    { .label = { 126846,  7, 0 } }, /* sakurai */
    { .label = { 161386,  5, 0 } }, /* sango */
    { .label = {  86671,  9, 0 } }, /* shimoichi */
    { .label = {  34664, 13, 0 } }, /* shimokitayama */
    { .label = { 147591,  6, 0 } }, /* shinjo */
    { .label = {  95874,  4, 0 } }, /* soni */
    { .label = { 106356,  8, 0 } }, /* takatori */
    { .label = {  71631, 10, 0 } }, /* tawaramoto */
    { .label = { 126874,  7, 0 } }, /* tenkawa */
    { .label = { 161406,  5, 0 } }, /* tenri */
    { .label = {  13917,  3, 0 } }, /* uda */
    { .label = {  26612, 14, 0 } }, /* yamatokoriyama */
    { .label = {  43560, 12, 0 } }, /* yamatotakada */
    { .label = { 126903,  7, 0 } }, /* yamazoe */
    { .label = {  26581,  7, 0 } }, /* yoshino */

    /* entries 5437 to 5470 */
    { .label = {   9429,  3, 0 } }, /* aga */
    { .label = {  34754,  5, 0 } }, /* agano */
    { .label = { 161426,  5, 0 } }, /* gosen */
    { .label = { 106387,  8, 0 } }, /* itoigawa */
    { .label = {  86711,  9, 0 } }, /* izumozaki */
    { .label = { 147619,  6, 0 } }, /* joetsu */
    { .label = { 101731,  4, 0 } }, /* kamo */
    { .label = { 147647,  6, 0 } }, /* kariwa */
    { .label = {  56809, 11, 0 } }, /* kashiwazaki */
    { .label = {  43608, 12, 0 } }, /* minamiuonuma */
    { .label = { 126935,  7, 0 } }, /* mitsuke */
    { .label = { 161447,  5, 0 } }, /* muika */
    { .label = { 106420,  8, 0 } }, /* murakami */
    { .label = { 161469,  5, 0 } }, /* myoko */
    { .label = {  71287,  7, 0 } }, /* nagaoka */
    { .label = { 123047,  7, 0 } }, /* niigata */
    { .label = { 161493,  5, 0 } }, /* ojiya */
    { .label = {  14987,  3, 0 } }, /* omi */
    { .label = { 169513,  4, 0 } }, /* sado */
    { .label = { 161517,  5, 0 } }, /* sanjo */
    { .label = {  76248,  5, 0 } }, /* seiro */
    { .label = { 147672,  6, 0 } }, /* seirou */
    { .label = { 106454,  8, 0 } }, /* sekikawa */
    { .label = { 126398,  7, 0 } }, /* shibata */
    { .label = { 101538,  6, 0 } }, /* tagami */
    { .label = { 147697,  6, 0 } }, /* tainai */
    { .label = { 147719,  6, 0 } }, /* tochio */
    { .label = {  86755,  9, 0 } }, /* tokamachi */
    { .label = { 126966,  7, 0 } }, /* tsubame */
    { .label = { 124739,  6, 0 } }, /* tsunan */
    { .label = {  43633,  6, 0 } }, /* uonuma */
    { .label = { 147745,  6, 0 } }, /* yahiko */
    { .label = { 161539,  5, 0 } }, /* yoita */
    { .label = { 147772,  6, 0 } }, /* yuzawa */

    /* entries 5471 to 5489 */
    { .label = { 161560,  5, 0 } }, /* beppu */
    { .label = { 106488,  8, 0 } }, /* bungoono */
    { .label = {  56858, 11, 0 } }, /* bungotakada */
    { .label = { 147802,  6, 0 } }, /* hasama */
    { .label = { 126671,  4, 0 } }, /* hiji */
    { .label = {  86793,  9, 0 } }, /* himeshima */
    { .label = {  43205,  4, 0 } }, /* hita */
    { .label = { 106524,  8, 0 } }, /* kamitsue */
    { .label = { 126997,  7, 0 } }, /* kokonoe */
    { .label = { 101800,  4, 0 } }, /* kuju */
    { .label = { 106558,  8, 0 } }, /* kunisaki */
    { .label = { 108358,  4, 0 } }, /* kusu */
    { .label = {  73395,  4, 0 } }, /* oita */
    { .label = { 161587,  5, 0 } }, /* saiki */
    { .label = { 147825,  6, 0 } }, /* taketa */
    { .label = { 127027,  7, 0 } }, /* tsukumi */
    { .label = {  13354,  3, 0 } }, /* usa */
    { .label = { 161607,  5, 0 } }, /* usuki */
    { .label = { 169529,  4, 0 } }, /* yufu */

    /* entries 5490 to 5515 */
    { .label = { 147848,  6, 0 } }, /* akaiwa */
    { .label = { 106592,  8, 0 } }, /* asakuchi */
    { .label = { 161630,  5, 0 } }, /* bizen */
    { .label = {  86832,  9, 0 } }, /* hayashima */
    { .label = { 123018,  5, 0 } }, /* ibara */
    { .label = { 106626,  8, 0 } }, /* kagamino */
    { .label = { 127059,  7, 0 } }, /* kasaoka */
    { .label = { 106659,  8, 0 } }, /* kibichuo */
    { .label = { 127086,  7, 0 } }, /* kumenan */
    { .label = {  86870,  9, 0 } }, /* kurashiki */
    { .label = { 147872,  6, 0 } }, /* maniwa */
    { .label = { 147897,  6, 0 } }, /* misaki */
    { .label = {  83805,  4, 0 } }, /* nagi */
    { .label = { 161655,  5, 0 } }, /* niimi */
    { .label = {  43659, 12, 0 } }, /* nishiawakura */
    { .label = { 108759,  7, 0 } }, /* okayama */
    { .label = { 127116,  7, 0 } }, /* satosho */
    { .label = { 106697,  8, 0 } }, /* setouchi */
    { .label = { 147591,  6, 0 } }, /* shinjo */
    { .label = { 124347,  4, 0 } }, /* shoo */
    { .label = { 169551,  4, 0 } }, /* soja */
    { .label = {  86909,  9, 0 } }, /* takahashi */
    { .label = { 147922,  6, 0 } }, /* tamano */
    { .label = {  15061,  7, 0 } }, /* tsuyama */
    { .label = { 169569,  4, 0 } }, /* wake */
    { .label = { 147945,  6, 0 } }, /* yakage */

    /* entries 5516 to 5557 */
    { .label = { 106921,  5, 0 } }, /* aguni */
    { .label = { 127144,  7, 0 } }, /* ginowan */
    { .label = { 147971,  6, 0 } }, /* ginoza */
    { .label = {  86945,  9, 0 } }, /* gushikami */
    { .label = { 127174,  7, 0 } }, /* haebaru */
    { .label = {  11216,  7, 0 } }, /* higashi */
    { .label = { 147998,  6, 0 } }, /* hirara */
    { .label = { 161676,  5, 0 } }, /* iheya */
    { .label = { 106732,  8, 0 } }, /* ishigaki */
    { .label = {  88575,  8, 0 } }, /* ishikawa */
    { .label = { 148021,  6, 0 } }, /* itoman */
    { .label = { 161698,  5, 0 } }, /* izena */
    { .label = { 148045,  6, 0 } }, /* kadena */
    { .label = {   5932,  3, 0 } }, /* kin */
    { .label = {  86985,  9, 0 } }, /* kitadaito */
    { .label = {  26671, 14, 0 } }, /* kitanakagusuku */
    { .label = { 106766,  8, 0 } }, /* kumejima */
    { .label = { 106804,  8, 0 } }, /* kunigami */
    { .label = {  56905, 11, 0 } }, /* minamidaito */
    { .label = { 148069,  6, 0 } }, /* motobu */
    { .label = {  87926,  4, 0 } }, /* nago */
    { .label = {  88318,  4, 0 } }, /* naha */
    { .label = {  26687, 10, 0 } }, /* nakagusuku */
    { .label = { 127204,  7, 0 } }, /* nakijin */
    { .label = { 161720,  5, 0 } }, /* nanjo */
    { .label = {  85824,  9, 0 } }, /* nishihara */
    { .label = { 161742,  5, 0 } }, /* ogimi */
    { .label = { 123074,  7, 0 } }, /* okinawa */
    { .label = { 128593,  4, 0 } }, /* onna */
    { .label = { 127235,  7, 0 } }, /* shimoji */
    { .label = { 106839,  8, 0 } }, /* taketomi */
    { .label = { 148097,  6, 0 } }, /* tarama */
    { .label = {  87021,  9, 0 } }, /* tokashiki */
    { .label = {  71671, 10, 0 } }, /* tomigusuku */
    { .label = { 148119,  6, 0 } }, /* tonaki */
    { .label = { 148143,  6, 0 } }, /* urasoe */
    { .label = { 161764,  5, 0 } }, /* uruma */
    { .label = { 161786,  5, 0 } }, /* yaese */
    { .label = { 127268,  7, 0 } }, /* yomitan */
    { .label = { 106872,  8, 0 } }, /* yonabaru */
    { .label = { 106907,  8, 0 } }, /* yonaguni */
    { .label = { 148167,  6, 0 } }, /* zamami */

    /* entries 5558 to 5607 */
    { .label = { 161807,  5, 0 } }, /* abeno */
    { .label = {  26731, 14, 0 } }, /* chihayaakasaka */
    { .label = {  55830,  4, 0 } }, /* chuo */
    { .label = {  56930,  5, 0 } }, /* daito */
    { .label = {  87059,  9, 0 } }, /* fujiidera */
    { .label = { 106942,  8, 0 } }, /* habikino */
    { .label = { 148194,  6, 0 } }, /* hannan */
    { .label = {  43709, 12, 0 } }, /* higashiosaka */
    { .label = {  14952, 16, 0 } }, /* higashisumiyoshi */
    { .label = {  19705, 15, 0 } }, /* higashiyodogawa */
    { .label = { 106977,  8, 0 } }, /* hirakata */
    { .label = { 123018,  7, 0 } }, /* ibaraki */
    { .label = { 160029,  5, 0 } }, /* ikeda */
    { .label = {  70583,  5, 0 } }, /* izumi */
    { .label = {  87101,  9, 0 } }, /* izumiotsu */
    { .label = {  87143,  9, 0 } }, /* izumisano */
    { .label = {  70204,  6, 0 } }, /* kadoma */
    { .label = { 127298,  7, 0 } }, /* kaizuka */
    { .label = { 161828,  5, 0 } }, /* kanan */
    { .label = {  87183,  9, 0 } }, /* kashiwara */
    { .label = { 148217,  6, 0 } }, /* katano */
    { .label = {  34719, 13, 0 } }, /* kawachinagano */
    { .label = {  87220,  9, 0 } }, /* kishiwada */
    { .label = {  26671,  4, 0 } }, /* kita */
    { .label = { 107008,  8, 0 } }, /* kumatori */
    { .label = {  87259,  9, 0 } }, /* matsubara */
    { .label = {  57154,  6, 0 } }, /* minato */
    { .label = {  65531,  5, 0 } }, /* minoh */
    { .label = { 147897,  6, 0 } }, /* misaki */
    { .label = {  87296,  9, 0 } }, /* moriguchi */
    { .label = { 107042,  8, 0 } }, /* neyagawa */
    { .label = {  43257,  5, 0 } }, /* nishi */
    { .label = {  57244,  4, 0 } }, /* nose */
    { .label = {  56950, 11, 0 } }, /* osakasayama */
    { .label = {  26773,  5, 0 } }, /* sakai */
    { .label = {  56969,  6, 0 } }, /* sayama */
    { .label = { 148240,  6, 0 } }, /* sennan */
    { .label = { 148263,  6, 0 } }, /* settsu */
    { .label = {  56993, 11, 0 } }, /* shijonawate */
    { .label = {  87337,  9, 0 } }, /* shimamoto */
    { .label = { 161847,  5, 0 } }, /* suita */
    { .label = { 127330,  7, 0 } }, /* tadaoka */
    { .label = { 124419,  6, 0 } }, /* taishi */
    { .label = { 148288,  6, 0 } }, /* tajiri */
    { .label = { 107076,  8, 0 } }, /* takaishi */
    { .label = {  87375,  9, 0 } }, /* takatsuki */
    { .label = {  43758, 12, 0 } }, /* tondabayashi */
    { .label = { 107108,  8, 0 } }, /* toyonaka */
    { .label = { 148314,  6, 0 } }, /* toyono */
    { .label = {   4623,  3, 0 } }, /* yao */

    /* entries 5608 to 5633 */
    { .label = { 148340,  6, 0 } }, /* ariake */
    { .label = {  15479,  5, 0 } }, /* arita */
    { .label = { 107141,  8, 0 } }, /* fukudomi */
    { .label = { 148363,  6, 0 } }, /* genkai */
    { .label = { 107180,  8, 0 } }, /* hamatama */
    { .label = {  34027,  5, 0 } }, /* hizen */
    { .label = {  34318,  5, 0 } }, /* imari */
    { .label = { 107211,  8, 0 } }, /* kamimine */
    { .label = { 127357,  7, 0 } }, /* kanzaki */
    { .label = { 127388,  7, 0 } }, /* karatsu */
    { .label = {  87617,  7, 0 } }, /* kashima */
    { .label = { 102603,  8, 0 } }, /* kitagata */
    { .label = { 107245,  8, 0 } }, /* kitahata */
    { .label = {  71533,  6, 0 } }, /* kiyama */
    { .label = { 127416,  7, 0 } }, /* kouhoku */
    { .label = { 127449,  7, 0 } }, /* kyuragi */
    { .label = {  71717, 10, 0 } }, /* nishiarita */
    { .label = {  15578,  3, 0 } }, /* ogi */
    { .label = {  43433,  6, 0 } }, /* omachi */
    { .label = {  71563,  5, 0 } }, /* ouchi */
    { .label = {  48659,  4, 0 } }, /* saga */
    { .label = {  86129,  9, 0 } }, /* shiroishi */
    { .label = {  42949,  4, 0 } }, /* taku */
    { .label = {  26537,  4, 0 } }, /* tara */
    { .label = { 145113,  4, 0 } }, /* tosu */
    { .label = {  57041, 11, 0 } }, /* yoshinogari */

    /* entries 5634 to 5702 */
    { .label = { 127481,  7, 0 } }, /* arakawa */
    { .label = {  26770,  5, 0 } }, /* asaka */
    { .label = {  19801,  8, 0 } }, /* chichibu */
    { .label = {  56263,  6, 0 } }, /* fujimi */
    { .label = { 107276,  8, 0 } }, /* fujimino */
    { .label = { 148388,  6, 0 } }, /* fukaya */
    { .label = { 161867,  5, 0 } }, /* hanno */
    { .label = { 161887,  5, 0 } }, /* hanyu */
    { .label = { 148416,  6, 0 } }, /* hasuda */
    { .label = { 107315,  8, 0 } }, /* hatogaya */
    { .label = { 107348,  8, 0 } }, /* hatoyama */
    { .label = { 145488,  6, 0 } }, /* hidaka */
    { .label = {  19771, 15, 0 } }, /* higashichichibu */
    { .label = {  15023, 16, 0 } }, /* higashimatsuyama */
    { .label = {  83722,  5, 0 } }, /* honjo */
    { .label = {    694,  3, 0 } }, /* ina */
    { .label = { 161910,  5, 0 } }, /* iruma */
    { .label = { 107381,  8, 0 } }, /* iwatsuki */
    { .label = {  87412,  9, 0 } }, /* kamiizumi */
    { .label = { 103422,  8, 0 } }, /* kamikawa */
    { .label = { 107416,  8, 0 } }, /* kamisato */
    { .label = { 107448,  8, 0 } }, /* kasukabe */
    { .label = { 126311,  7, 0 } }, /* kawagoe */
    { .label = {  19990,  9, 0 } }, /* kawaguchi */
    { .label = { 107483,  8, 0 } }, /* kawajima */
    { .label = { 169587,  4, 0 } }, /* kazo */
    { .label = { 107519,  8, 0 } }, /* kitamoto */
    { .label = {  87454,  9, 0 } }, /* koshigaya */
    { .label = { 127508,  7, 0 } }, /* kounosu */
    { .label = {  34595,  4, 0 } }, /* kuki */
    { .label = { 107552,  8, 0 } }, /* kumagaya */
    { .label = {  71756, 10, 0 } }, /* matsubushi */
    { .label = { 148441,  6, 0 } }, /* minano */
    { .label = {  26823,  6, 0 } }, /* misato */
    { .label = {  87493,  9, 0 } }, /* miyashiro */
    { .label = {  14991,  7, 0 } }, /* miyoshi */
    { .label = { 107587,  8, 0 } }, /* moroyama */
    { .label = { 107621,  8, 0 } }, /* nagatoro */
    { .label = { 107652,  8, 0 } }, /* namegawa */
    { .label = { 161931,  5, 0 } }, /* niiza */
    { .label = {  38116,  5, 0 } }, /* ogano */
    { .label = {  19750,  5, 0 } }, /* ogawa */
    { .label = { 161953,  5, 0 } }, /* ogose */
    { .label = { 127539,  7, 0 } }, /* okegawa */
    { .label = {  43235,  5, 0 } }, /* omiya */
    { .label = { 103909,  5, 0 } }, /* otaki */
    { .label = { 148465,  6, 0 } }, /* ranzan */
    { .label = { 127569,  7, 0 } }, /* ryokami */
    { .label = { 123103,  7, 0 } }, /* saitama */
    { .label = { 148490,  6, 0 } }, /* sakado */
    { .label = { 161974,  5, 0 } }, /* satte */
    { .label = {  56969,  6, 0 } }, /* sayama */
    { .label = {  86887,  5, 0 } }, /* shiki */
    { .label = { 107685,  8, 0 } }, /* shiraoka */
    { .label = {   7181,  4, 0 } }, /* soka */
    { .label = { 148514,  6, 0 } }, /* sugito */
    { .label = { 124142,  4, 0 } }, /* toda */
    { .label = { 107717,  8, 0 } }, /* tokigawa */
    { .label = {  71801, 10, 0 } }, /* tokorozawa */
    { .label = {  43809, 12, 0 } }, /* tsurugashima */
    { .label = { 161993,  5, 0 } }, /* urawa */
    { .label = { 148540,  6, 0 } }, /* warabi */
    { .label = { 148566,  6, 0 } }, /* yashio */
    { .label = { 148592,  6, 0 } }, /* yokoze */
    { .label = {  84542,  4, 0 } }, /* yono */
    { .label = { 162014,  5, 0 } }, /* yorii */
    { .label = {  57291,  7, 0 } }, /* yoshida */
    { .label = {  87532,  9, 0 } }, /* yoshikawa */
    { .label = { 127600,  7, 0 } }, /* yoshimi */

    /* entries 5703 to 5725 */
    { .label = { 162036,  5, 0 } }, /* aisho */
    { .label = {   8723,  4, 0 } }, /* gamo */
    { .label = {  71845, 10, 0 } }, /* higashiomi */
    { .label = { 148622,  6, 0 } }, /* hikone */
    { .label = {  52646,  4, 0 } }, /* koka */
    { .label = { 159815,  5, 0 } }, /* konan */
    { .label = { 162056,  5, 0 } }, /* kosei */
    { .label = { 104862,  4, 0 } }, /* koto */
    { .label = { 124722,  7, 0 } }, /* kusatsu */
    { .label = { 127632,  7, 0 } }, /* maibara */
    { .label = { 107751,  8, 0 } }, /* moriyama */
    { .label = { 107785,  8, 0 } }, /* nagahama */
    { .label = {  87572,  9, 0 } }, /* nishiazai */
    { .label = { 107816,  8, 0 } }, /* notogawa */
    { .label = {  57088, 11, 0 } }, /* omihachiman */
    { .label = {  26830,  4, 0 } }, /* otsu */
    { .label = { 162077,  5, 0 } }, /* ritto */
    { .label = { 162097,  5, 0 } }, /* ryuoh */
    { .label = {  87610,  9, 0 } }, /* takashima */
    { .label = {  87375,  9, 0 } }, /* takatsuki */
    { .label = { 107849,  8, 0 } }, /* torahime */
    { .label = { 107882,  8, 0 } }, /* toyosato */
    { .label = {  43963,  4, 0 } }, /* yasu */

    /* entries 5726 to 5748 */
    { .label = { 147371,  5, 0 } }, /* akagi */
    { .label = {  11470,  3, 0 } }, /* ama */
    { .label = { 162121,  5, 0 } }, /* gotsu */
    { .label = { 148648,  6, 0 } }, /* hamada */
    { .label = {  43860, 12, 0 } }, /* higashiizumo */
    { .label = {  26797,  6, 0 } }, /* hikawa */
    { .label = { 148672,  6, 0 } }, /* hikimi */
    { .label = {  43890,  5, 0 } }, /* izumo */
    { .label = { 107915,  8, 0 } }, /* kakinoki */
    { .label = { 148699,  6, 0 } }, /* masuda */
    { .label = { 148724,  6, 0 } }, /* matsue */
    { .label = {  26823,  6, 0 } }, /* misato */
    { .label = {  43915, 12, 0 } }, /* nishinoshima */
    { .label = { 169606,  4, 0 } }, /* ohda */
    { .label = {  71888, 10, 0 } }, /* okinoshima */
    { .label = { 107949,  8, 0 } }, /* okuizumo */
    { .label = { 123129,  7, 0 } }, /* shimane */
    { .label = { 148749,  6, 0 } }, /* tamayu */
    { .label = { 127660,  7, 0 } }, /* tsuwano */
    { .label = { 162143,  5, 0 } }, /* unnan */
    { .label = { 145790,  6, 0 } }, /* yakumo */
    { .label = { 148775,  6, 0 } }, /* yasugi */
    { .label = { 127690,  7, 0 } }, /* yatsuka */

    /* entries 5749 to 5784 */
    { .label = {  67749,  4, 0 } }, /* arai */
    { .label = { 102624,  5, 0 } }, /* atami */
    { .label = {  19968,  4, 0 } }, /* fuji */
    { .label = { 127720,  7, 0 } }, /* fujieda */
    { .label = {  19968,  8, 0 } }, /* fujikawa */
    { .label = {  71930, 10, 0 } }, /* fujinomiya */
    { .label = { 127754,  7, 0 } }, /* fukuroi */
    { .label = { 127787,  7, 0 } }, /* gotemba */
    { .label = { 127818,  7, 0 } }, /* haibara */
    { .label = {  87646,  9, 0 } }, /* hamamatsu */
    { .label = {  43860, 10, 0 } }, /* higashiizu */
    { .label = {   3876,  3, 0 } }, /* ito */
    { .label = { 162163,  5, 0 } }, /* iwata */
    { .label = {  17256,  3, 0 } }, /* izu */
    { .label = {  87683,  9, 0 } }, /* izunokuni */
    { .label = { 107988,  8, 0 } }, /* kakegawa */
    { .label = { 127846,  7, 0 } }, /* kannami */
    { .label = {  87725,  9, 0 } }, /* kawanehon */
    { .label = { 148802,  6, 0 } }, /* kawazu */
    { .label = { 108022,  8, 0 } }, /* kikugawa */
    { .label = { 161578,  5, 0 } }, /* kosai */
    { .label = {  71978, 10, 0 } }, /* makinohara */
    { .label = {  87763,  9, 0 } }, /* matsuzaki */
    { .label = {  87803,  9, 0 } }, /* minamiizu */
    { .label = { 124298,  7, 0 } }, /* mishima */
    { .label = {  87844,  9, 0 } }, /* morimachi */
    { .label = { 108058,  8, 0 } }, /* nishiizu */
    { .label = { 148831,  6, 0 } }, /* numazu */
    { .label = { 108095,  8, 0 } }, /* omaezaki */
    { .label = { 127874,  7, 0 } }, /* shimada */
    { .label = {  56584,  7, 0 } }, /* shimizu */
    { .label = {  85521,  7, 0 } }, /* shimoda */
    { .label = { 101190,  8, 0 } }, /* shizuoka */
    { .label = { 148860,  6, 0 } }, /* susono */
    { .label = { 124454,  5, 0 } }, /* yaizu */
    { .label = {  57291,  7, 0 } }, /* yoshida */

    /* entries 5785 to 5815 */
    { .label = {  34399,  8, 0 } }, /* ashikaga */
    { .label = { 102184,  4, 0 } }, /* bato */
    { .label = { 169623,  4, 0 } }, /* haga */
    { .label = { 127903,  7, 0 } }, /* ichikai */
    { .label = { 127933,  7, 0 } }, /* iwafune */
    { .label = {  72018, 10, 0 } }, /* kaminokawa */
    { .label = { 148885,  6, 0 } }, /* kanuma */
    { .label = {  72060, 10, 0 } }, /* karasuyama */
    { .label = { 127965,  7, 0 } }, /* kuroiso */
    { .label = { 127995,  7, 0 } }, /* mashiko */
    { .label = { 169639,  4, 0 } }, /* mibu */
    { .label = {  56609,  4, 0 } }, /* moka */
    { .label = { 148910,  6, 0 } }, /* motegi */
    { .label = {  36596,  4, 0 } }, /* nasu */
    { .label = {  43965, 12, 0 } }, /* nasushiobara */
    { .label = { 162183,  5, 0 } }, /* nikko */
    { .label = {  87883,  9, 0 } }, /* nishikata */
    { .label = { 169659,  4, 0 } }, /* nogi */
    { .label = { 104875,  5, 0 } }, /* ohira */
    { .label = { 108130,  8, 0 } }, /* ohtawara */
    { .label = {  15070,  5, 0 } }, /* oyama */
    { .label = {  70910,  6, 0 } }, /* sakura */
    { .label = {  83811,  4, 0 } }, /* sano */
    { .label = {  72101, 10, 0 } }, /* shimotsuke */
    { .label = { 148936,  6, 0 } }, /* shioya */
    { .label = {  72145, 10, 0 } }, /* takanezawa */
    { .label = { 123158,  7, 0 } }, /* tochigi */
    { .label = {  55864,  5, 0 } }, /* tsuga */
    { .label = { 162205,  5, 0 } }, /* ujiie */
    { .label = {  72187, 10, 0 } }, /* utsunomiya */
    { .label = { 162229,  5, 0 } }, /* yaita */

    /* entries 5816 to 5832 */
    { .label = {  70580,  6, 0 } }, /* aizumi */
    { .label = {  15116,  4, 0 } }, /* anan */
    { .label = {  70423,  6, 0 } }, /* ichiba */
    { .label = { 162249,  5, 0 } }, /* itano */
    { .label = { 148962,  6, 0 } }, /* kainan */
    { .label = {  44014, 12, 0 } }, /* komatsushima */
    { .label = {  72231, 10, 0 } }, /* matsushige */
    { .label = {  71516,  4, 0 } }, /* mima */
    { .label = {  19642,  6, 0 } }, /* minami */
    { .label = {  14991,  7, 0 } }, /* miyoshi */
    { .label = { 169676,  4, 0 } }, /* mugi */
    { .label = { 102213,  8, 0 } }, /* nakagawa */
    { .label = { 148985,  6, 0 } }, /* naruto */
    { .label = {  87919,  9, 0 } }, /* sanagochi */
    { .label = {  87956,  9, 0 } }, /* shishikui */
    { .label = {  83214,  9, 0 } }, /* tokushima */
    { .label = { 149009,  6, 0 } }, /* wajiki */

    /* entries 5833 to 5889 */
    { .label = { 149038,  6, 0 } }, /* adachi */
    { .label = { 128025,  7, 0 } }, /* akiruno */
    { .label = { 108162,  8, 0 } }, /* akishima */
    { .label = {  87996,  9, 0 } }, /* aogashima */
    { .label = { 127481,  7, 0 } }, /* arakawa */
    { .label = { 149063,  6, 0 } }, /* bunkyo */
    { .label = { 124600,  7, 0 } }, /* chiyoda */
    { .label = { 162268,  5, 0 } }, /* chofu */
    { .label = {  55830,  4, 0 } }, /* chuo */
    { .label = { 105892,  7, 0 } }, /* edogawa */
    { .label = { 160389,  5, 0 } }, /* fuchu */
    { .label = { 162293,  5, 0 } }, /* fussa */
    { .label = { 128054,  7, 0 } }, /* hachijo */
    { .label = { 108195,  8, 0 } }, /* hachioji */
    { .label = { 149093,  6, 0 } }, /* hamura */
    { .label = {  34773, 13, 0 } }, /* higashikurume */
    { .label = {  19840, 15, 0 } }, /* higashimurayama */
    { .label = {  34831, 13, 0 } }, /* higashiyamato */
    { .label = {  26595,  4, 0 } }, /* hino */
    { .label = { 149118,  6, 0 } }, /* hinode */
    { .label = { 108232,  8, 0 } }, /* hinohara */
    { .label = { 162315,  5, 0 } }, /* inagi */
    { .label = { 108264,  8, 0 } }, /* itabashi */
    { .label = {  72274, 10, 0 } }, /* katsushika */
    { .label = {  26671,  4, 0 } }, /* kita */
    { .label = { 149144,  6, 0 } }, /* kiyose */
    { .label = { 128087,  7, 0 } }, /* kodaira */
    { .label = { 128115,  7, 0 } }, /* koganei */
    { .label = {  88032,  9, 0 } }, /* kokubunji */
    { .label = { 162335,  5, 0 } }, /* komae */
    { .label = { 104862,  4, 0 } }, /* koto */
    { .label = {  72316, 10, 0 } }, /* kouzushima */
    { .label = {  88077,  9, 0 } }, /* kunitachi */
    { .label = { 128144,  7, 0 } }, /* machida */
    { .label = { 149171,  6, 0 } }, /* meguro */
    { .label = {  57154,  6, 0 } }, /* minato */
    { .label = { 106015,  6, 0 } }, /* mitaka */
    { .label = { 149198,  6, 0 } }, /* mizuho */
    { .label = {  19904, 15, 0 } }, /* musashimurayama */
    { .label = {  88116,  9, 0 } }, /* musashino */
    { .label = { 102841,  6, 0 } }, /* nakano */
    { .label = { 149228,  6, 0 } }, /* nerima */
    { .label = {  88154,  9, 0 } }, /* ogasawara */
    { .label = { 128174,  7, 0 } }, /* okutama */
    { .label = {   3950,  3, 0 } }, /* ome */
    { .label = {  11263,  6, 0 } }, /* oshima */
    { .label = {   4077,  3, 0 } }, /* ota */
    { .label = { 108297,  8, 0 } }, /* setagaya */
    { .label = { 128203,  7, 0 } }, /* shibuya */
    { .label = {  88189,  9, 0 } }, /* shinagawa */
    { .label = { 108329,  8, 0 } }, /* shinjuku */
    { .label = { 108368,  8, 0 } }, /* suginami */
    { .label = { 143748,  6, 0 } }, /* sumida */
    { .label = {  88226,  9, 0 } }, /* tachikawa */
    { .label = {  80895,  5, 0 } }, /* taito */
    { .label = {  23820,  4, 0 } }, /* tama */
    { .label = {  11259,  7, 0 } }, /* toshima */

    /* entries 5890 to 5902 */
    { .label = {  86412,  5, 0 } }, /* chizu */
    { .label = {  26595,  4, 0 } }, /* hino */
    { .label = { 108402,  8, 0 } }, /* kawahara */
    { .label = {  42833,  4, 0 } }, /* koge */
    { .label = { 128236,  7, 0 } }, /* kotoura */
    { .label = { 149252,  6, 0 } }, /* misasa */
    { .label = { 162356,  5, 0 } }, /* nanbu */
    { .label = { 105957,  8, 0 } }, /* nichinan */
    { .label = {  57135, 11, 0 } }, /* sakaiminato */
    { .label = { 123189,  7, 0 } }, /* tottori */
    { .label = { 144522,  6, 0 } }, /* wakasa */
    { .label = { 146600,  4, 0 } }, /* yazu */
    { .label = { 149275,  6, 0 } }, /* yonago */

    /* entries 5903 to 5926 */
    { .label = {  70178,  5, 0 } }, /* asahi */
    { .label = { 160389,  5, 0 } }, /* fuchu */
    { .label = {  88264,  9, 0 } }, /* fukumitsu */
    { .label = {  88307,  9, 0 } }, /* funahashi */
    { .label = {  56588,  4, 0 } }, /* himi */
    { .label = {  56593,  5, 0 } }, /* imizu */
    { .label = {  19647,  5, 0 } }, /* inami */
    { .label = { 149301,  6, 0 } }, /* johana */
    { .label = { 108434,  8, 0 } }, /* kamiichi */
    { .label = { 149327,  6, 0 } }, /* kurobe */
    { .label = {  57178, 11, 0 } }, /* nakaniikawa */
    { .label = {  72363, 10, 0 } }, /* namerikawa */
    { .label = {  80264,  5, 0 } }, /* nanto */
    { .label = { 149355,  6, 0 } }, /* nyuzen */
    { .label = { 162378,  5, 0 } }, /* oyabe */
    { .label = { 162401,  5, 0 } }, /* taira */
    { .label = { 128265,  7, 0 } }, /* takaoka */
    { .label = { 101840,  8, 0 } }, /* tateyama */
    { .label = {  55869,  4, 0 } }, /* toga */
    { .label = { 101930,  6, 0 } }, /* tonami */
    { .label = {  15066,  6, 0 } }, /* toyama */
    { .label = { 128292,  7, 0 } }, /* unazuki */
    { .label = { 169695,  4, 0 } }, /* uozu */
    { .label = { 144847,  6, 0 } }, /* yamada */

    /* entries 5927 to 5955 */
    { .label = {  88346,  5, 0 } }, /* arida */
    { .label = {  88346,  9, 0 } }, /* aridagawa */
    { .label = { 165735,  4, 0 } }, /* gobo */
    { .label = {  88382,  9, 0 } }, /* hashimoto */
    { .label = { 145488,  6, 0 } }, /* hidaka */
    { .label = { 108469,  8, 0 } }, /* hirogawa */
    { .label = {  19647,  5, 0 } }, /* inami */
    { .label = {  45583,  5, 0 } }, /* iwade */
    { .label = { 148962,  6, 0 } }, /* kainan */
    { .label = {  88420,  9, 0 } }, /* kamitonda */
    { .label = {  86634,  9, 0 } }, /* katsuragi */
    { .label = { 149385,  6, 0 } }, /* kimino */
    { .label = { 108503,  8, 0 } }, /* kinokawa */
    { .label = {  34686,  8, 0 } }, /* kitayama */
    { .label = { 163353,  4, 0 } }, /* koya */
    { .label = { 108537,  4, 0 } }, /* koza */
    { .label = { 108537,  8, 0 } }, /* kozagawa */
    { .label = { 108573,  8, 0 } }, /* kudoyama */
    { .label = {  88457,  9, 0 } }, /* kushimoto */
    { .label = { 107171,  6, 0 } }, /* mihama */
    { .label = {  26823,  6, 0 } }, /* misato */
    { .label = {  34886, 13, 0 } }, /* nachikatsuura */
    { .label = { 144770,  6, 0 } }, /* shingu */
    { .label = {  88497,  9, 0 } }, /* shirahama */
    { .label = { 162419,  5, 0 } }, /* taiji */
    { .label = {  85875,  6, 0 } }, /* tanabe */
    { .label = { 101227,  8, 0 } }, /* wakayama */
    { .label = { 162441,  5, 0 } }, /* yuasa */
    { .label = { 127454,  4, 0 } }, /* yura */

    /* entries 5956 to 5989 */
    { .label = {  70178,  5, 0 } }, /* asahi */
    { .label = { 108609,  8, 0 } }, /* funagata */
    { .label = {  88533,  9, 0 } }, /* higashine */
    { .label = {  74473,  4, 0 } }, /* iide */
    { .label = { 145505,  6, 0 } }, /* kahoku */
    { .label = {  72404, 10, 0 } }, /* kaminoyama */
    { .label = { 102347,  8, 0 } }, /* kaneyama */
    { .label = {  85325,  9, 0 } }, /* kawanishi */
    { .label = {  72446, 10, 0 } }, /* mamurogawa */
    { .label = { 103430,  6, 0 } }, /* mikawa */
    { .label = {  19870,  8, 0 } }, /* murayama */
    { .label = { 162462,  5, 0 } }, /* nagai */
    { .label = { 108642,  8, 0 } }, /* nakayama */
    { .label = { 162481,  5, 0 } }, /* nanyo */
    { .label = {  88571,  9, 0 } }, /* nishikawa */
    { .label = {  88609,  9, 0 } }, /* obanazawa */
    { .label = {     21,  2, 0 } }, /* oe */
    { .label = {  56688,  5, 0 } }, /* oguni */
    { .label = { 149411,  6, 0 } }, /* ohkura */
    { .label = { 128325,  7, 0 } }, /* oishida */
    { .label = { 162502,  5, 0 } }, /* sagae */
    { .label = { 149437,  6, 0 } }, /* sakata */
    { .label = { 108674,  8, 0 } }, /* sakegawa */
    { .label = { 147591,  6, 0 } }, /* shinjo */
    { .label = {  88648,  9, 0 } }, /* shirataka */
    { .label = { 144797,  6, 0 } }, /* shonai */
    { .label = { 108707,  8, 0 } }, /* takahata */
    { .label = { 162521,  5, 0 } }, /* tendo */
    { .label = {  83876,  6, 0 } }, /* tozawa */
    { .label = { 108737,  8, 0 } }, /* tsuruoka */
    { .label = { 101261,  8, 0 } }, /* yamagata */
    { .label = { 108771,  8, 0 } }, /* yamanobe */
    { .label = { 108806,  8, 0 } }, /* yonezawa */
    { .label = { 147772,  4, 0 } }, /* yuza */

    /* entries 5990 to 6005 */
    { .label = {  14611,  3, 0 } }, /* abu */
    { .label = { 104365,  4, 0 } }, /* hagi */
    { .label = {  19555,  6, 0 } }, /* hikari */
    { .label = { 162273,  4, 0 } }, /* hofu */
    { .label = { 128354,  7, 0 } }, /* iwakuni */
    { .label = {  88683,  9, 0 } }, /* kudamatsu */
    { .label = { 162542,  5, 0 } }, /* mitou */
    { .label = { 107621,  6, 0 } }, /* nagato */
    { .label = {  11263,  6, 0 } }, /* oshima */
    { .label = {  57222, 11, 0 } }, /* shimonoseki */
    { .label = { 149459,  6, 0 } }, /* shunan */
    { .label = { 149484,  6, 0 } }, /* tabuse */
    { .label = { 108843,  8, 0 } }, /* tokuyama */
    { .label = { 143715,  6, 0 } }, /* toyota */
    { .label = {  39159,  3, 0 } }, /* ube */
    { .label = {  46561,  3, 0 } }, /* yuu */

    /* entries 6006 to 6033 */
    { .label = {  55830,  4, 0 } }, /* chuo */
    { .label = { 162564,  5, 0 } }, /* doshi */
    { .label = { 128385,  7, 0 } }, /* fuefuki */
    { .label = {  19968,  8, 0 } }, /* fujikawa */
    { .label = {  19968, 15, 0 } }, /* fujikawaguchiko */
    { .label = {  57269, 11, 0 } }, /* fujiyoshida */
    { .label = { 108878,  8, 0 } }, /* hayakawa */
    { .label = { 145513,  6, 0 } }, /* hokuto */
    { .label = {  26788, 14, 0 } }, /* ichikawamisato */
    { .label = {   2825,  3, 0 } }, /* kai */
    { .label = { 131206,  4, 0 } }, /* kofu */
    { .label = { 162586,  5, 0 } }, /* koshu */
    { .label = { 149510,  6, 0 } }, /* kosuge */
    { .label = {  57322, 11, 0 } }, /* minami-alps */
    { .label = { 149537,  6, 0 } }, /* minobu */
    { .label = {  88722,  9, 0 } }, /* nakamichi */
    { .label = { 162356,  5, 0 } }, /* nanbu */
    { .label = { 108912,  8, 0 } }, /* narusawa */
    { .label = { 108944,  8, 0 } }, /* nirasaki */
    { .label = {  44065, 12, 0 } }, /* nishikatsura */
    { .label = {  26587,  6, 0 } }, /* oshino */
    { .label = { 146434,  6, 0 } }, /* otsuki */
    { .label = { 160242,  5, 0 } }, /* showa */
    { .label = { 108975,  8, 0 } }, /* tabayama */
    { .label = {  43809,  5, 0 } }, /* tsuru */
    { .label = { 109008,  8, 0 } }, /* uenohara */
    { .label = {  72489, 10, 0 } }, /* yamanakako */
    { .label = {  83294,  9, 0 } }, /* yamanashi */

    /* entries 6034 to 6036 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  99235,  4, 1 } }, { .child = { 6037, 1 } }, /* city */

    /* entry 6037 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 6038 to 6040 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  99235,  4, 1 } }, { .child = { 6041, 1 } }, /* city */

    /* entry 6041 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 6042 to 6044 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  99235,  4, 1 } }, { .child = { 6045, 1 } }, /* city */

    /* entry 6045 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 6046 to 6048 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  99235,  4, 1 } }, { .child = { 6049, 1 } }, /* city */

    /* entry 6049 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 6050 to 6052 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  99235,  4, 1 } }, { .child = { 6053, 1 } }, /* city */

    /* entry 6053 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 6054 to 6056 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  99235,  4, 1 } }, { .child = { 6057, 1 } }, /* city */

    /* entry 6057 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 6058 to 6060 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  99235,  4, 1 } }, { .child = { 6061, 1 } }, /* city */

    /* entry 6061 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 6062 to 6072 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 6073, 1 } }, /* co */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  10299,  4, 0 } }, /* mobi */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entry 6073 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 6074 to 6085 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  17228,  4, 0 } }, /* blog */
    { .label = {     63,  2, 0 } }, /* io */
    { .label = {  12841,  2, 0 } }, /* jp */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {   2514,  2, 0 } }, /* uk */
    { .label = {    296,  2, 0 } }, /* us */

    /* entry 6086 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 6087 to 6093 */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {    106,  3, 0 } }, /* com */

    /* entries 6094 to 6110 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  45092,  3, 0 } }, /* prd */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {   2729,  3, 0 } }, /* ass */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  53152,  4, 0 } }, /* coop */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = { 142521,  6, 0 } }, /* presse */
    { .label = { 121768,  7, 0 } }, /* medecin */
    { .label = { 100305,  8, 0 } }, /* notaires */
    { .label = {  57370, 11, 0 } }, /* pharmaciens */
    { .label = {  53292, 11, 0 } }, /* veterinaire */
    { .label = { 169150,  4, 0 } }, /* gouv */

    /* entries 6111 to 6114 */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 6115 to 6120 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  24724,  3, 0 } }, /* rep */
    { .label = {   3068,  3, 0 } }, /* tra */

    /* entries 6121 to 6150 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   3881,  2, 0 } }, /* hs */
    { .label = {   9092,  2, 0 } }, /* kg */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {   5481,  2, 0 } }, /* pe */
    { .label = {     55,  2, 0 } }, /* re */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {  73489,  5, 0 } }, /* busan */
    { .label = { 109040,  8, 0 } }, /* chungbuk */
    { .label = { 109080,  8, 0 } }, /* chungnam */
    { .label = { 162609,  5, 0 } }, /* daegu */
    { .label = { 128420,  7, 0 } }, /* daejeon */
    { .label = { 128451,  7, 0 } }, /* gangwon */
    { .label = { 128482,  7, 0 } }, /* gwangju */
    { .label = {  88760,  9, 0 } }, /* gyeongbuk */
    { .label = { 109116,  8, 0 } }, /* gyeonggi */
    { .label = {  88804,  9, 0 } }, /* gyeongnam */
    { .label = { 128517,  7, 0 } }, /* incheon */
    { .label = { 169716,  4, 0 } }, /* jeju */
    { .label = { 128547,  7, 0 } }, /* jeonbuk */
    { .label = { 128582,  7, 0 } }, /* jeonnam */
    { .label = { 162631,  5, 0 } }, /* seoul */
    { .label = {   2312,  5, 0 } }, /* ulsan */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 6151 to 6157 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  20437,  3, 0 } }, /* emb */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   8930,  3, 0 } }, /* ind */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6158 to 6162 */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */

    /* entries 6163 to 6169 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 6170 to 6180 */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   5481,  3, 0 } }, /* per */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   2762,  3, 0 } }, /* bnr */
    { .label = {     19,  1, 0 } }, /* c */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 6181 to 6185 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6186 to 6193 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44750,  3, 0 } }, /* nym */
    { .label = {    224,  2, 0 } }, /* oy */

    /* entries 6194 to 6197 */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {    526,  3, 0 } }, /* caa */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 6198 to 6212 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   6759,  3, 0 } }, /* sch */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  10119,  3, 0 } }, /* ngo */
    { .label = {   2773,  3, 0 } }, /* soc */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {  38987,  3, 0 } }, /* ltd */
    { .label = { 169739,  4, 0 } }, /* assn */
    { .label = { 120229,  3, 0 } }, /* grp */
    { .label = {  61691,  5, 0 } }, /* hotel */
    { .label = {    103,  2, 0 } }, /* ac */

    /* entries 6213 to 6217 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */

    /* entries 6218 to 6227 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {    243,  2, 0 } }, /* de */

    /* entries 6228 to 6230 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 6231 to 6232 */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 6233 to 6242 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    143,  2, 0 } }, /* id */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   6774,  3, 0 } }, /* asn */
    { .label = {  65725,  4, 0 } }, /* conf */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 6243 to 6251 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   2619,  3, 0 } }, /* plc */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   6759,  3, 0 } }, /* sch */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    143,  2, 0 } }, /* id */

    /* entries 6252 to 6257 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  23342,  5, 0 } }, /* press */

    /* entries 6258 to 6259 */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {   2766,  4, 0 } }, /* asso */

    /* entries 6260 to 6264 */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {    160,  2, 0 } }, /* at */
    { .label = {    243,  2, 0 } }, /* de */
    { .label = {  12841,  2, 0 } }, /* jp */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entries 6265 to 6307 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  28274,  3, 0 } }, /* its */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = { 173147,  3, 0 } }, /* c66 */
    { .label = { 157040,  6, 1 } }, { .child = { 6308, 1 } }, /* daplie */
    { .label = {  97057,  9, 0 } }, /* edgestack */
    { .label = { 172096,  4, 0 } }, /* couk */
    { .label = { 134959,  4, 0 } }, /* ukco */
    { .label = {  66057,  8, 0 } }, /* filegear */
    { .label = {  66057, 11, 0 } }, /* filegear-au */
    { .label = {  66105, 11, 0 } }, /* filegear-de */
    { .label = {  66154, 11, 0 } }, /* filegear-gb */
    { .label = {  66205, 11, 0 } }, /* filegear-ie */
    { .label = {  66253, 11, 0 } }, /* filegear-jp */
    { .label = {  66306, 11, 0 } }, /* filegear-sg */
    { .label = { 157763,  6, 0 } }, /* glitch */
    { .label = {  98299,  7, 0 } }, /* ravendb */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = { 172218,  4, 0 } }, /* nctu */
    { .label = {  98686,  9, 0 } }, /* soundcast */
    { .label = { 172341,  4, 0 } }, /* tcp4 */
    { .label = { 119971,  8, 0 } }, /* brasilia */
    { .label = { 117941,  4, 0 } }, /* ddns */
    { .label = { 138141,  6, 0 } }, /* dnsfor */
    { .label = { 168472,  5, 0 } }, /* hopto */
    { .label = { 141256,  7, 0 } }, /* loginto */
    { .label = { 172397,  4, 0 } }, /* noip */
    { .label = { 157260,  6, 0 } }, /* webhop */
    { .label = {  44750,  3, 0 } }, /* nym */
    { .label = {   5585, 11, 0 } }, /* diskstation */
    { .label = { 141473,  7, 0 } }, /* dscloud */
    { .label = { 172473,  4, 0 } }, /* i234 */
    { .label = { 172502,  4, 0 } }, /* myds */
    { .label = {   5542,  8, 0 } }, /* synology */
    { .label = { 120885,  8, 0 } }, /* wedeploy */
    { .label = { 169038,  5, 0 } }, /* yombo */
    { .label = { 159012,  6, 0 } }, /* nohost */

    /* entry 6308 */
    { .label = {  97018,  9, 0 } }, /* localhost */

    /* entries 6309 to 6317 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  45092,  3, 0 } }, /* prd */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 6318 to 6326 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   5509,  3, 0 } }, /* inf */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 6327 to 6333 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = { 169150,  4, 0 } }, /* gouv */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 142521,  6, 0 } }, /* presse */

    /* entry 6334 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 6335 to 6339 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 113472,  3, 0 } }, /* nyc */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 6340 to 6344 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 6345 to 6346 */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = { 141473,  7, 0 } }, /* dscloud */

    /* entries 6347 to 6348 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 6349 to 6354 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   8772,  3, 0 } }, /* lab */

    /* entries 6355 to 6359 */
    { .label = {    106,  3, 1 } }, { .child = { 6360, 1 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 6360 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 6361 to 6367 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     47,  2, 0 } }, /* or */

    /* entries 6368 to 6913 */
    { .label = { 128613,  7, 0 } }, /* academy */
    { .label = {  57417, 11, 0 } }, /* agriculture */
    { .label = {   2836,  3, 0 } }, /* air */
    { .label = { 109153,  8, 0 } }, /* airguard */
    { .label = { 128644,  7, 0 } }, /* alabama */
    { .label = { 149565,  6, 0 } }, /* alaska */
    { .label = { 140911,  5, 0 } }, /* amber */
    { .label = {  82300,  9, 0 } }, /* ambulance */
    { .label = {  15091,  8, 0 } }, /* american */
    { .label = {  15091,  9, 0 } }, /* americana */
    { .label = {  15091, 16, 0 } }, /* americanantiques */
    { .label = {  57465, 11, 0 } }, /* americanart */
    { .label = {  88844,  9, 0 } }, /* amsterdam */
    { .label = {    351,  3, 0 } }, /* and */
    { .label = {  88881,  9, 0 } }, /* annefrank */
    { .label = {  44114,  6, 0 } }, /* anthro */
    { .label = {  44114, 12, 0 } }, /* anthropology */
    { .label = {  15123,  8, 0 } }, /* antiques */
    { .label = { 109186,  8, 0 } }, /* aquarium */
    { .label = {  88918,  9, 0 } }, /* arboretum */
    { .label = {  26847, 14, 0 } }, /* archaeological */
    { .label = {  57508, 11, 0 } }, /* archaeology */
    { .label = {  44168, 12, 0 } }, /* architecture */
    { .label = {   7959,  3, 0 } }, /* art */
    { .label = {  44219, 12, 0 } }, /* artanddesign */
    { .label = {  88957,  9, 0 } }, /* artcenter */
    { .label = { 128672,  7, 0 } }, /* artdeco */
    { .label = {  44268, 12, 0 } }, /* arteducation */
    { .label = {  72530, 10, 0 } }, /* artgallery */
    { .label = {   7959,  4, 0 } }, /* arts */
    { .label = {  34940, 13, 0 } }, /* artsandcrafts */
    { .label = { 109223,  8, 0 } }, /* asmatart */
    { .label = {  34993, 13, 0 } }, /* assassination */
    { .label = { 149588,  6, 0 } }, /* assisi */
    { .label = {   2766, 11, 0 } }, /* association */
    { .label = {  88993,  9, 0 } }, /* astronomy */
    { .label = { 128701,  7, 0 } }, /* atlanta */
    { .label = { 149611,  6, 0 } }, /* austin */
    { .label = {  89031,  9, 0 } }, /* australia */
    { .label = {  72573, 10, 0 } }, /* automotive */
    { .label = {  32840,  8, 0 } }, /* aviation */
    { .label = {  65061,  4, 0 } }, /* axis */
    { .label = { 128727,  7, 0 } }, /* badajoz */
    { .label = { 128762,  7, 0 } }, /* baghdad */
    { .label = {  89479,  4, 0 } }, /* bahn */
    { .label = {  31351,  4, 0 } }, /* bale */
    { .label = {  89066,  9, 0 } }, /* baltimore */
    { .label = {  89105,  9, 0 } }, /* barcelona */
    { .label = { 109253,  8, 0 } }, /* baseball */
    { .label = { 162653,  5, 0 } }, /* basel */
    { .label = { 162675,  5, 0 } }, /* baths */
    { .label = { 149635,  6, 0 } }, /* bauern */
    { .label = {  89143,  9, 0 } }, /* beauxarts */
    { .label = {  35042, 13, 0 } }, /* beeldengeluid */
    { .label = { 109289,  8, 0 } }, /* bellevue */
    { .label = { 128794,  7, 0 } }, /* bergbau */
    { .label = { 109328,  8, 0 } }, /* berkeley */
    { .label = {  80725,  6, 0 } }, /* berlin */
    { .label = {  53258,  4, 0 } }, /* bern */
    { .label = { 162697,  5, 0 } }, /* bible */
    { .label = { 149661,  6, 0 } }, /* bilbao */
    { .label = { 169754,  4, 0 } }, /* bill */
    { .label = { 128827,  7, 0 } }, /* birdart */
    { .label = {  72616, 10, 0 } }, /* birthplace */
    { .label = { 169774,  4, 0 } }, /* bonn */
    { .label = { 149689,  6, 0 } }, /* boston */
    { .label = {  20040,  9, 0 } }, /* botanical */
    { .label = {  20040, 15, 0 } }, /* botanicalgarden */
    { .label = {  35102, 13, 0 } }, /* botanicgarden */
    { .label = { 149715,  6, 0 } }, /* botany */
    { .label = {  15159, 16, 0 } }, /* brandywinevalley */
    { .label = { 119971,  6, 0 } }, /* brasil */
    { .label = { 128857,  7, 0 } }, /* bristol */
    { .label = {  20103,  7, 0 } }, /* british */
    { .label = {  20103, 15, 0 } }, /* britishcolumbia */
    { .label = {  89182,  9, 0 } }, /* broadcast */
    { .label = { 149742,  6, 0 } }, /* brunel */
    { .label = { 109366,  7, 0 } }, /* brussel */
    { .label = { 109366,  8, 0 } }, /* brussels */
    { .label = {  89220,  9, 0 } }, /* bruxelles */
    { .label = { 109402,  8, 0 } }, /* building */
    { .label = { 128888,  7, 0 } }, /* burghof */
    { .label = {   2959,  3, 0 } }, /* bus */
    { .label = { 149770,  6, 0 } }, /* bushey */
    { .label = { 109440,  8, 0 } }, /* cadaques */
    { .label = {  72662, 10, 0 } }, /* california */
    { .label = {  89263,  9, 0 } }, /* cambridge */
    { .label = {  15111,  3, 0 } }, /* can */
    { .label = { 149800,  6, 0 } }, /* canada */
    { .label = {  72704, 10, 0 } }, /* capebreton */
    { .label = { 128923,  7, 0 } }, /* carrier */
    { .label = {  72748, 10, 0 } }, /* cartoonart */
    { .label = {  26906, 14, 0 } }, /* casadelamoneda */
    { .label = { 149823,  6, 0 } }, /* castle */
    { .label = { 128951,  7, 0 } }, /* castres */
    { .label = {  24528,  6, 0 } }, /* celtic */
    { .label = {  27120,  6, 0 } }, /* center */
    { .label = {  57556, 11, 0 } }, /* chattanooga */
    { .label = {  72787, 10, 0 } }, /* cheltenham */
    { .label = {  35157, 13, 0 } }, /* chesapeakebay */
    { .label = { 128979,  7, 0 } }, /* chicago */
    { .label = {  20171,  8, 0 } }, /* children */
    { .label = {  20171,  9, 0 } }, /* childrens */
    { .label = {  20171, 15, 0 } }, /* childrensgarden */
    { .label = {  44317, 12, 0 } }, /* chiropractic */
    { .label = {  89304,  9, 0 } }, /* chocolate */
    { .label = {  26963, 14, 0 } }, /* christiansburg */
    { .label = {  72831, 10, 0 } }, /* cincinnati */
    { .label = { 149848,  6, 0 } }, /* cinema */
    { .label = { 149873,  6, 0 } }, /* circus */
    { .label = {  44370, 12, 0 } }, /* civilisation */
    { .label = {  44421, 12, 0 } }, /* civilization */
    { .label = { 109477,  8, 0 } }, /* civilwar */
    { .label = { 129010,  7, 0 } }, /* clinton */
    { .label = {  20942,  5, 0 } }, /* clock */
    { .label = {  32507,  4, 0 } }, /* coal */
    { .label = {  27024, 14, 0 } }, /* coastaldefence */
    { .label = { 169792,  4, 0 } }, /* cody */
    { .label = { 129040,  7, 0 } }, /* coldwar */
    { .label = {  72872, 10, 0 } }, /* collection */
    { .label = {   4293, 20, 0 } }, /* colonialwilliamsburg */
    { .label = {  20236, 15, 0 } }, /* coloradoplateau */
    { .label = {  20134,  8, 0 } }, /* columbia */
    { .label = { 109514,  8, 0 } }, /* columbus */
    { .label = {    385, 13, 0 } }, /* communication */
    { .label = {    385, 14, 0 } }, /* communications */
    { .label = {  41528,  9, 0 } }, /* community */
    { .label = {  20300,  8, 0 } }, /* computer */
    { .label = {  20300, 15, 0 } }, /* computerhistory */
    { .label = {   4383, 20, 0 } }, /* xn--comunicaes-v6a2o */
    { .label = {  20368, 12, 0 } }, /* contemporary */
    { .label = {  20368, 15, 0 } }, /* contemporaryart */
    { .label = { 129072,  7, 0 } }, /* convent */
    { .label = {  72916, 10, 0 } }, /* copenhagen */
    { .label = {  57600, 11, 0 } }, /* corporation */
    { .label = {     22, 36, 0 } }, /* xn--correios-e-telecomunicaes-ghc29a */
    { .label = { 109553,  8, 0 } }, /* corvette */
    { .label = { 129103,  7, 0 } }, /* costume */
    { .label = {  20774, 13, 0 } }, /* countryestate */
    { .label = { 149900,  6, 0 } }, /* county */
    { .label = {  34967,  6, 0 } }, /* crafts */
    { .label = {  89343,  9, 0 } }, /* cranbrook */
    { .label = {  68197,  8, 0 } }, /* creation */
    { .label = {  27084,  8, 0 } }, /* cultural */
    { .label = {  27084, 14, 0 } }, /* culturalcenter */
    { .label = {  57433,  7, 0 } }, /* culture */
    { .label = { 162722,  5, 0 } }, /* cyber */
    { .label = { 162747,  5, 0 } }, /* cymru */
    { .label = {  45133,  4, 0 } }, /* dali */
    { .label = { 149928,  6, 0 } }, /* dallas */
    { .label = { 109588,  8, 0 } }, /* database */
    { .label = {  68309,  3, 0 } }, /* ddr */
    { .label = {  15584, 14, 0 } }, /* decorativearts */
    { .label = {  20731,  8, 0 } }, /* delaware */
    { .label = {  57646, 11, 0 } }, /* delmenhorst */
    { .label = { 129134,  7, 0 } }, /* denmark */
    { .label = {  95403,  5, 0 } }, /* depot */
    { .label = {  27302,  6, 0 } }, /* design */
    { .label = { 129164,  7, 0 } }, /* detroit */
    { .label = { 109620,  8, 0 } }, /* dinosaur */
    { .label = {  89382,  9, 0 } }, /* discovery */
    { .label = { 162772,  5, 0 } }, /* dolls */
    { .label = { 109653,  8, 0 } }, /* donostia */
    { .label = { 149953,  6, 0 } }, /* durham */
    { .label = {  72960, 10, 0 } }, /* eastafrica */
    { .label = {  89424,  9, 0 } }, /* eastcoast */
    { .label = {  44279,  9, 0 } }, /* education */
    { .label = {  57694, 11, 0 } }, /* educational */
    { .label = { 109685,  8, 0 } }, /* egyptian */
    { .label = {  89459,  9, 0 } }, /* eisenbahn */
    { .label = { 149980,  6, 0 } }, /* elburg */
    { .label = {  73000, 10, 0 } }, /* elvendrell */
    { .label = {  73046, 10, 0 } }, /* embroidery */
    { .label = {  44475, 12, 0 } }, /* encyclopedic */
    { .label = { 129193,  7, 0 } }, /* england */
    { .label = {  73092, 10, 0 } }, /* entomology */
    { .label = {    561, 11, 0 } }, /* environment */
    { .label = {    561, 25, 0 } }, /* environmentalconservation */
    { .label = { 109721,  8, 0 } }, /* epilepsy */
    { .label = { 162795,  5, 0 } }, /* essex */
    { .label = {  20806,  6, 0 } }, /* estate */
    { .label = {  89497,  9, 0 } }, /* ethnology */
    { .label = { 150009,  6, 0 } }, /* exeter */
    { .label = {  73137, 10, 0 } }, /* exhibition */
    { .label = {  30048,  6, 0 } }, /* family */
    { .label = {  13672,  4, 0 } }, /* farm */
    { .label = {  35215, 13, 0 } }, /* farmequipment */
    { .label = { 129223,  7, 0 } }, /* farmers */
    { .label = {  89538,  9, 0 } }, /* farmstead */
    { .label = { 162817,  5, 0 } }, /* field */
    { .label = { 109760,  8, 0 } }, /* figueres */
    { .label = {  89576,  9, 0 } }, /* filatelia */
    { .label = {  82288,  4, 0 } }, /* film */
    { .label = { 109796,  7, 0 } }, /* fineart */
    { .label = { 109796,  8, 0 } }, /* finearts */
    { .label = { 129253,  7, 0 } }, /* finland */
    { .label = { 109829,  8, 0 } }, /* flanders */
    { .label = { 129284,  7, 0 } }, /* florida */
    { .label = { 115148,  5, 0 } }, /* force */
    { .label = {  44532, 12, 0 } }, /* fortmissoula */
    { .label = {  89614,  9, 0 } }, /* fortworth */
    { .label = {  73182, 10, 0 } }, /* foundation */
    { .label = {  89655,  9, 0 } }, /* francaise */
    { .label = {  89692,  9, 0 } }, /* frankfurt */
    { .label = {  44584, 12, 0 } }, /* franziskaner */
    { .label = {  57740, 11, 0 } }, /* freemasonry */
    { .label = { 109864,  8, 0 } }, /* freiburg */
    { .label = { 109902,  8, 0 } }, /* fribourg */
    { .label = { 135550,  4, 0 } }, /* frog */
    { .label = { 109940,  8, 0 } }, /* fundacio */
    { .label = {  89733,  9, 0 } }, /* furniture */
    { .label = {  72541,  7, 0 } }, /* gallery */
    { .label = {  20078,  6, 0 } }, /* garden */
    { .label = {  18136,  7, 0 } }, /* gateway */
    { .label = {  89773,  9, 0 } }, /* geelvinck */
    { .label = {  57788, 11, 0 } }, /* gemological */
    { .label = { 129315,  7, 0 } }, /* geology */
    { .label = { 129348,  7, 0 } }, /* georgia */
    { .label = { 129377,  7, 0 } }, /* giessen */
    { .label = { 162841,  4, 0 } }, /* glas */
    { .label = { 162841,  5, 0 } }, /* glass */
    { .label = { 162862,  5, 0 } }, /* gorge */
    { .label = {  57837, 11, 0 } }, /* grandrapids */
    { .label = { 169812,  4, 0 } }, /* graz */
    { .label = { 109976,  8, 0 } }, /* guernsey */
    { .label = {  73225, 10, 0 } }, /* halloffame */
    { .label = { 129406,  7, 0 } }, /* hamburg */
    { .label = { 129439,  7, 0 } }, /* handson */
    { .label = {   8811, 18, 0 } }, /* harvestcelebration */
    { .label = { 150035,  6, 0 } }, /* hawaii */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = {  27145, 14, 0 } }, /* heimatunduhren */
    { .label = { 150060,  6, 0 } }, /* hellas */
    { .label = { 110012,  8, 0 } }, /* helsinki */
    { .label = {  20432, 15, 0 } }, /* hembygdsforbund */
    { .label = {  15473,  8, 0 } }, /* heritage */
    { .label = { 110047,  8, 0 } }, /* histoire */
    { .label = {  11288, 10, 0 } }, /* historical */
    { .label = {  11288, 17, 0 } }, /* historicalsociety */
    { .label = {  27206, 14, 0 } }, /* historichouses */
    { .label = {   6730, 10, 0 } }, /* historisch */
    { .label = {   6730, 12, 0 } }, /* historisches */
    { .label = {   4509,  7, 0 } }, /* history */
    { .label = {  15234, 16, 0 } }, /* historyofscience */
    { .label = { 110080,  8, 0 } }, /* horology */
    { .label = {  27240,  5, 0 } }, /* house */
    { .label = {  73271, 10, 0 } }, /* humanities */
    { .label = {  44636, 12, 0 } }, /* illustration */
    { .label = {  35277, 13, 0 } }, /* imageandsound */
    { .label = {  44686,  6, 0 } }, /* indian */
    { .label = {  44686,  7, 0 } }, /* indiana */
    { .label = {  44686, 12, 0 } }, /* indianapolis */
    { .label = {  44736, 12, 0 } }, /* indianmarket */
    { .label = {  44785, 12, 0 } }, /* intelligence */
    { .label = {  57884, 11, 0 } }, /* interactive */
    { .label = { 169831,  4, 0 } }, /* iraq */
    { .label = {    575,  4, 0 } }, /* iron */
    { .label = {  89815,  9, 0 } }, /* isleofman */
    { .label = { 129468,  7, 0 } }, /* jamison */
    { .label = {  89854,  9, 0 } }, /* jefferson */
    { .label = {  89897,  9, 0 } }, /* jerusalem */
    { .label = { 129499,  7, 0 } }, /* jewelry */
    { .label = {  89938,  6, 0 } }, /* jewish */
    { .label = {  89938,  9, 0 } }, /* jewishart */
    { .label = { 172822,  3, 0 } }, /* jfk */
    { .label = {  73313, 10, 0 } }, /* journalism */
    { .label = { 129535,  7, 0 } }, /* judaica */
    { .label = {  57930, 11, 0 } }, /* judygarland */
    { .label = {  73358, 10, 0 } }, /* juedisches */
    { .label = { 169850,  4, 0 } }, /* juif */
    { .label = { 150086,  6, 0 } }, /* karate */
    { .label = {  89979,  9, 0 } }, /* karikatur */
    { .label = { 131027,  4, 0 } }, /* kids */
    { .label = {  73405, 10, 0 } }, /* koebenhavn */
    { .label = { 162884,  5, 0 } }, /* koeln */
    { .label = {  27266,  5, 0 } }, /* kunst */
    { .label = {  35332, 13, 0 } }, /* kunstsammlung */
    { .label = {  27266, 14, 0 } }, /* kunstunddesign */
    { .label = { 162906,  5, 0 } }, /* labor */
    { .label = { 150109,  6, 0 } }, /* labour */
    { .label = { 129567,  7, 0 } }, /* lajolla */
    { .label = {  73450, 10, 0 } }, /* lancashire */
    { .label = { 150136,  6, 0 } }, /* landes */
    { .label = {  17010,  4, 0 } }, /* lans */
    { .label = {  57982, 11, 0 } }, /* xn--lns-qla */
    { .label = { 129599,  7, 0 } }, /* larsson */
    { .label = {  58036, 11, 0 } }, /* lewismiller */
    { .label = { 129627,  7, 0 } }, /* lincoln */
    { .label = { 120533,  4, 0 } }, /* linz */
    { .label = {  20838,  6, 0 } }, /* living */
    { .label = {  20838, 13, 0 } }, /* livinghistory */
    { .label = {  44837, 12, 0 } }, /* localhistory */
    { .label = { 150161,  6, 0 } }, /* london */
    { .label = {  73491, 10, 0 } }, /* losangeles */
    { .label = { 150187,  6, 0 } }, /* louvre */
    { .label = { 110117,  8, 0 } }, /* loyalist */
    { .label = { 129658,  7, 0 } }, /* lucerne */
    { .label = {  73533, 10, 0 } }, /* luxembourg */
    { .label = { 150215,  6, 0 } }, /* luzern */
    { .label = {  13646,  3, 0 } }, /* mad */
    { .label = { 150244,  6, 0 } }, /* madrid */
    { .label = { 110152,  8, 0 } }, /* mallorca */
    { .label = {  73582, 10, 0 } }, /* manchester */
    { .label = { 110186,  7, 0 } }, /* mansion */
    { .label = { 110186,  8, 0 } }, /* mansions */
    { .label = { 169872,  4, 0 } }, /* manx */
    { .label = { 129689,  7, 0 } }, /* marburg */
    { .label = { 110218,  8, 0 } }, /* maritime */
    { .label = { 110251,  8, 0 } }, /* maritimo */
    { .label = { 110284,  8, 0 } }, /* maryland */
    { .label = {  73624, 10, 0 } }, /* marylhurst */
    { .label = {  98775,  5, 0 } }, /* media */
    { .label = { 129721,  7, 0 } }, /* medical */
    { .label = {   6697, 19, 0 } }, /* medizinhistorisches */
    { .label = { 150270,  6, 0 } }, /* meeres */
    { .label = { 110319,  8, 0 } }, /* memorial */
    { .label = {  90016,  9, 0 } }, /* mesaverde */
    { .label = { 110353,  8, 0 } }, /* michigan */
    { .label = {  58086, 11, 0 } }, /* midatlantic */
    { .label = { 110388,  8, 0 } }, /* military */
    { .label = {  58059,  4, 0 } }, /* mill */
    { .label = { 150295,  6, 0 } }, /* miners */
    { .label = { 150320,  6, 0 } }, /* mining */
    { .label = {  90055,  9, 0 } }, /* minnesota */
    { .label = { 129752,  7, 0 } }, /* missile */
    { .label = {  44550,  8, 0 } }, /* missoula */
    { .label = { 150346,  6, 0 } }, /* modern */
    { .label = { 102155,  4, 0 } }, /* moma */
    { .label = { 162928,  5, 0 } }, /* money */
    { .label = { 110423,  8, 0 } }, /* monmouth */
    { .label = {  73669, 10, 0 } }, /* monticello */
    { .label = { 110459,  8, 0 } }, /* montreal */
    { .label = { 150372,  6, 0 } }, /* moscow */
    { .label = {  61766, 10, 0 } }, /* motorcycle */
    { .label = { 110492,  8, 0 } }, /* muenchen */
    { .label = { 110528,  8, 0 } }, /* muenster */
    { .label = { 110562,  8, 0 } }, /* mulhouse */
    { .label = { 150400,  6, 0 } }, /* muncie */
    { .label = { 150427,  6, 0 } }, /* museet */
    { .label = {  44890, 12, 0 } }, /* museumcenter */
    { .label = {  15305, 16, 0 } }, /* museumvereniging */
    { .label = {  40053,  5, 0 } }, /* music */
    { .label = {  15377,  8, 0 } }, /* national */
    { .label = {  15377, 16, 0 } }, /* nationalfirearms */
    { .label = {  15442, 16, 0 } }, /* nationalheritage */
    { .label = {  27328, 14, 0 } }, /* nativeamerican */
    { .label = {   4481, 14, 0 } }, /* naturalhistory */
    { .label = {   4481, 20, 0 } }, /* naturalhistorymuseum */
    { .label = {  20506, 15, 0 } }, /* naturalsciences */
    { .label = {   9000,  6, 0 } }, /* nature */
    { .label = {  11361, 17, 0 } }, /* naturhistorisches */
    { .label = {   6781, 19, 0 } }, /* natuurwetenschappen */
    { .label = { 110599,  8, 0 } }, /* naumburg */
    { .label = { 162951,  5, 0 } }, /* naval */
    { .label = { 110636,  8, 0 } }, /* nebraska */
    { .label = { 162972,  5, 0 } }, /* neues */
    { .label = {  44943, 12, 0 } }, /* newhampshire */
    { .label = {  90091,  9, 0 } }, /* newjersey */
    { .label = {  90134,  9, 0 } }, /* newmexico */
    { .label = { 129782,  7, 0 } }, /* newport */
    { .label = {  90176,  9, 0 } }, /* newspaper */
    { .label = { 129814,  7, 0 } }, /* newyork */
    { .label = { 150453,  6, 0 } }, /* niepce */
    { .label = { 129847,  7, 0 } }, /* norfolk */
    { .label = {    734,  5, 0 } }, /* north */
    { .label = {  97292,  3, 0 } }, /* nrw */
    { .label = { 113472,  3, 0 } }, /* nyc */
    { .label = { 169890,  4, 0 } }, /* nyny */
    { .label = {  35390, 13, 0 } }, /* oceanographic */
    { .label = {  20568, 15, 0 } }, /* oceanographique */
    { .label = { 162993,  5, 0 } }, /* omaha */
    { .label = {  66681,  6, 0 } }, /* online */
    { .label = { 129879,  7, 0 } }, /* ontario */
    { .label = { 129906,  7, 0 } }, /* openair */
    { .label = {  58132,  6, 0 } }, /* oregon */
    { .label = {  58132, 11, 0 } }, /* oregontrail */
    { .label = { 163013,  5, 0 } }, /* otago */
    { .label = { 150480,  6, 0 } }, /* oxford */
    { .label = { 129935,  7, 0 } }, /* pacific */
    { .label = {  90217,  9, 0 } }, /* paderborn */
    { .label = { 150509,  6, 0 } }, /* palace */
    { .label = { 163033,  5, 0 } }, /* paleo */
    { .label = {  58177, 11, 0 } }, /* palmsprings */
    { .label = {  26605,  6, 0 } }, /* panama */
    { .label = { 163055,  5, 0 } }, /* paris */
    { .label = { 110669,  8, 0 } }, /* pasadena */
    { .label = { 110701,  8, 0 } }, /* pharmacy */
    { .label = {  15506, 12, 0 } }, /* philadelphia */
    { .label = {  15506, 16, 0 } }, /* philadelphiaarea */
    { .label = {  90257,  9, 0 } }, /* philately */
    { .label = { 129968,  7, 0 } }, /* phoenix */
    { .label = {  58227, 11, 0 } }, /* photography */
    { .label = { 150535,  6, 0 } }, /* pilots */
    { .label = {  73713, 10, 0 } }, /* pittsburgh */
    { .label = {  58279, 11, 0 } }, /* planetarium */
    { .label = {  73760, 10, 0 } }, /* plantation */
    { .label = { 150562,  6, 0 } }, /* plants */
    { .label = { 163076,  5, 0 } }, /* plaza */
    { .label = { 150588,  6, 0 } }, /* portal */
    { .label = { 110738,  8, 0 } }, /* portland */
    { .label = {  73801, 10, 0 } }, /* portlligat */
    { .label = {    324, 28, 0 } }, /* posts-and-telecommunications */
    { .label = {  44997, 12, 0 } }, /* preservation */
    { .label = { 110773,  8, 0 } }, /* presidio */
    { .label = {  23342,  5, 0 } }, /* press */
    { .label = {  40793,  7, 0 } }, /* project */
    { .label = {  24732,  6, 0 } }, /* public */
    { .label = { 163100,  5, 0 } }, /* pubol */
    { .label = { 150614,  6, 0 } }, /* quebec */
    { .label = { 110808,  8, 0 } }, /* railroad */
    { .label = { 130001,  7, 0 } }, /* railway */
    { .label = {  30258,  8, 0 } }, /* research */
    { .label = {  73845, 10, 0 } }, /* resistance */
    { .label = {  45048, 12, 0 } }, /* riodejaneiro */
    { .label = {  90299,  9, 0 } }, /* rochester */
    { .label = { 130032,  7, 0 } }, /* rockart */
    { .label = {  23471,  4, 0 } }, /* roma */
    { .label = { 150646,  6, 0 } }, /* russia */
    { .label = {  73885, 10, 0 } }, /* saintlouis */
    { .label = {  33023,  5, 0 } }, /* salem */
    { .label = {  45099, 12, 0 } }, /* salvadordali */
    { .label = { 110840,  8, 0 } }, /* salzburg */
    { .label = { 110879,  8, 0 } }, /* sandiego */
    { .label = {  45150, 12, 0 } }, /* sanfrancisco */
    { .label = {  45200, 12, 0 } }, /* santabarbara */
    { .label = {  90337,  9, 0 } }, /* santacruz */
    { .label = { 130061,  7, 0 } }, /* santafe */
    { .label = {  45247, 12, 0 } }, /* saskatchewan */
    { .label = { 169910,  4, 0 } }, /* satx */
    { .label = {  73926, 10, 0 } }, /* savannahga */
    { .label = {  45297, 12, 0 } }, /* schlesisches */
    { .label = {  58326, 11, 0 } }, /* schoenbrunn */
    { .label = {  58375, 11, 0 } }, /* schokoladen */
    { .label = { 121381,  6, 0 } }, /* school */
    { .label = { 130089,  7, 0 } }, /* schweiz */
    { .label = {   8888,  7, 0 } }, /* science */
    { .label = {  11432, 17, 0 } }, /* scienceandhistory */
    { .label = {   8888, 18, 0 } }, /* scienceandindustry */
    { .label = {  27385, 13, 0 } }, /* sciencecenter */
    { .label = {  27385, 14, 0 } }, /* sciencecenters */
    { .label = {  20636, 15, 0 } }, /* science-fiction */
    { .label = {  27444, 14, 0 } }, /* sciencehistory */
    { .label = {   8966,  8, 0 } }, /* sciences */
    { .label = {   8966, 18, 0 } }, /* sciencesnaturelles */
    { .label = { 110912,  8, 0 } }, /* scotland */
    { .label = { 130124,  7, 0 } }, /* seaport */
    { .label = {  73966, 10, 0 } }, /* settlement */
    { .label = { 110946,  8, 0 } }, /* settlers */
    { .label = { 163126,  5, 0 } }, /* shell */
    { .label = {  74008, 10, 0 } }, /* sherbrooke */
    { .label = { 130153,  7, 0 } }, /* sibenik */
    { .label = { 169927,  4, 0 } }, /* silk */
    { .label = {   6533,  3, 0 } }, /* ski */
    { .label = { 163149,  5, 0 } }, /* skole */
    { .label = {  11330,  7, 0 } }, /* society */
    { .label = { 130184,  7, 0 } }, /* sologne */
    { .label = {  27505, 14, 0 } }, /* soundandvision */
    { .label = {  35446, 13, 0 } }, /* southcarolina */
    { .label = {  90376,  9, 0 } }, /* southwest */
    { .label = {  40597,  5, 0 } }, /* space */
    { .label = {  92950,  3, 0 } }, /* spy */
    { .label = { 137597,  6, 0 } }, /* square */
    { .label = {  93346,  5, 0 } }, /* stadt */
    { .label = { 110979,  8, 0 } }, /* stalbans */
    { .label = {  90416,  9, 0 } }, /* starnberg */
    { .label = {  20702,  5, 0 } }, /* state */
    { .label = {  20702, 15, 0 } }, /* stateofdelaware */
    { .label = {   5603,  7, 0 } }, /* station */
    { .label = { 163171,  5, 0 } }, /* steam */
    { .label = {  74052, 10, 0 } }, /* steiermark */
    { .label = { 150670,  6, 0 } }, /* stjohn */
    { .label = {  90454,  9, 0 } }, /* stockholm */
    { .label = {  45350, 12, 0 } }, /* stpetersburg */
    { .label = {  90495,  9, 0 } }, /* stuttgart */
    { .label = { 150698,  6, 0 } }, /* suisse */
    { .label = {  45404, 12, 0 } }, /* surgeonshall */
    { .label = { 150723,  6, 0 } }, /* surrey */
    { .label = { 111012,  8, 0 } }, /* svizzera */
    { .label = { 150750,  6, 0 } }, /* sweden */
    { .label = { 150777,  6, 0 } }, /* sydney */
    { .label = {  56798,  4, 0 } }, /* tank */
    { .label = {  50267,  3, 0 } }, /* tcm */
    { .label = {  74093, 10, 0 } }, /* technology */
    { .label = {  11505, 17, 0 } }, /* telekommunikation */
    { .label = {  74139, 10, 0 } }, /* television */
    { .label = { 163191,  5, 0 } }, /* texas */
    { .label = { 130214,  7, 0 } }, /* textile */
    { .label = { 130245,  7, 0 } }, /* theater */
    { .label = {  58423,  4, 0 } }, /* time */
    { .label = {  58423, 11, 0 } }, /* timekeeping */
    { .label = { 111051,  8, 0 } }, /* topology */
    { .label = { 143376,  6, 0 } }, /* torino */
    { .label = { 106705,  5, 0 } }, /* touch */
    { .label = {  18239,  4, 0 } }, /* town */
    { .label = {  68399,  9, 0 } }, /* transport */
    { .label = {  79696,  4, 0 } }, /* tree */
    { .label = { 130273,  7, 0 } }, /* trolley */
    { .label = {  76034,  5, 0 } }, /* trust */
    { .label = { 130305,  7, 0 } }, /* trustee */
    { .label = {  27184,  5, 0 } }, /* uhren */
    { .label = {  29541,  3, 0 } }, /* ulm */
    { .label = { 111089,  8, 0 } }, /* undersea */
    { .label = {  74182, 10, 0 } }, /* university */
    { .label = {  13354,  3, 0 } }, /* usa */
    { .label = {  74227, 10, 0 } }, /* usantiques */
    { .label = { 150806,  6, 0 } }, /* usarts */
    { .label = {  20765, 15, 0 } }, /* uscountryestate */
    { .label = {  90532,  9, 0 } }, /* usculture */
    { .label = {  15575, 16, 0 } }, /* usdecorativearts */
    { .label = { 111122,  8, 0 } }, /* usgarden */
    { .label = {  90573,  9, 0 } }, /* ushistory */
    { .label = { 130334,  7, 0 } }, /* ushuaia */
    { .label = {  20829, 15, 0 } }, /* uslivinghistory */
    { .label = { 169945,  4, 0 } }, /* utah */
    { .label = { 169962,  4, 0 } }, /* uvic */
    { .label = {  15205,  6, 0 } }, /* valley */
    { .label = { 150830,  6, 0 } }, /* vantaa */
    { .label = {  74272, 10, 0 } }, /* versailles */
    { .label = { 150853,  6, 0 } }, /* viking */
    { .label = { 130363,  7, 0 } }, /* village */
    { .label = { 111156,  8, 0 } }, /* virginia */
    { .label = {  41589,  7, 0 } }, /* virtual */
    { .label = { 130395,  7, 0 } }, /* virtuel */
    { .label = {  74315, 10, 0 } }, /* vlaanderen */
    { .label = {  58472, 11, 0 } }, /* volkenkunde */
    { .label = { 163212,  5, 0 } }, /* wales */
    { .label = { 111190,  8, 0 } }, /* wallonie */
    { .label = {  17378,  3, 0 } }, /* war */
    { .label = {  45456, 12, 0 } }, /* washingtondc */
    { .label = {  35500, 13, 0 } }, /* watchandclock */
    { .label = {  20897, 15, 0 } }, /* watch-and-clock */
    { .label = {   9960,  7, 0 } }, /* western */
    { .label = {  90613,  9, 0 } }, /* westfalen */
    { .label = { 130427,  7, 0 } }, /* whaling */
    { .label = { 111225,  8, 0 } }, /* wildlife */
    { .label = {   4327, 12, 0 } }, /* williamsburg */
    { .label = { 111264,  8, 0 } }, /* windmill */
    { .label = { 111302,  8, 0 } }, /* workshop */
    { .label = {  90653,  4, 0 } }, /* york */
    { .label = {  90653,  9, 0 } }, /* yorkshire */
    { .label = { 111340,  8, 0 } }, /* yosemite */
    { .label = { 163234,  5, 0 } }, /* youth */
    { .label = {  74357, 10, 0 } }, /* zoological */
    { .label = { 130459,  7, 0 } }, /* zoology */
    { .label = {  27565, 14, 0 } }, /* xn--9dbhblg6di */
    { .label = {  74403, 10, 0 } }, /* xn--h1aegh */

    /* entries 6914 to 6927 */
    { .label = {  82226,  4, 0 } }, /* aero */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  53152,  4, 0 } }, /* coop */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {   4540,  6, 0 } }, /* museum */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  23387,  3, 0 } }, /* pro */

    /* entries 6928 to 6938 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  53152,  4, 0 } }, /* coop */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {   4540,  6, 0 } }, /* museum */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6939 to 6945 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 6946 to 6953 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 6954 to 6961 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3989,  3, 0 } }, /* adv */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6962 to 6978 */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  23387,  3, 0 } }, /* pro */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = { 121381,  6, 0 } }, /* school */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {   3009,  2, 0 } }, /* dr */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = {   2900,  2, 0 } }, /* mx */
    { .label = {    133,  2, 0 } }, /* ca */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {    336,  2, 0 } }, /* ws */
    { .label = {  10299,  4, 0 } }, /* mobi */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6979 to 6982 */
    { .label = {  10159,  3, 1 } }, { .child = { 6983, 1 } }, /* her */
    { .label = {   4509,  3, 1 } }, { .child = { 6984, 1 } }, /* his */

    /* entry 6983 */
    { .label = { 157121,  6, 0 } }, /* forgot */

    /* entry 6984 */
    { .label = { 157121,  6, 0 } }, /* forgot */

    /* entries 6985 to 6986 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 6987 to 7115 */
    { .label = {  39152, 13, 0 } }, /* adobeaemcloud */
    { .label = {  78853, 10, 0 } }, /* alwaysdata */
    { .label = {  78895, 10, 0 } }, /* cloudfront */
    { .label = { 117575,  8, 0 } }, /* t3l3p0rt */
    { .label = { 137526,  7, 0 } }, /* myfritz */
    { .label = {  50768, 12, 0 } }, /* blackbaudcdn */
    { .label = { 157013,  6, 0 } }, /* boomla */
    { .label = { 137634,  7, 0 } }, /* bplaced */
    { .label = { 137597,  7, 0 } }, /* square7 */
    { .label = {   1450,  2, 0 } }, /* gb */
    { .label = {   1370,  2, 0 } }, /* hu */
    { .label = {  12841,  2, 0 } }, /* jp */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {   2514,  2, 0 } }, /* uk */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = { 117693,  8, 0 } }, /* clic2000 */
    { .label = {  64477, 11, 0 } }, /* cloudaccess */
    { .label = {  96884,  9, 0 } }, /* cdn77-ssl */
    { .label = {  50825,  5, 1 } }, { .child = { 7116, 1 } }, /* cdn77 */
    { .label = {  96934,  9, 0 } }, /* cloudeity */
    { .label = { 117813,  8, 0 } }, /* feste-ip */
    { .label = {  79266, 10, 0 } }, /* knx-server */
    { .label = {  39460, 13, 0 } }, /* static-access */
    { .label = {  64576, 11, 1 } }, { .child = { 7117, 1 } }, /* cryptonomic */
    { .label = {  79312, 10, 0 } }, /* dattolocal */
    { .label = { 137867,  7, 0 } }, /* mydatto */
    { .label = { 157067,  6, 0 } }, /* debian */
    { .label = {  97096,  9, 0 } }, /* bitbridge */
    { .label = {  51041, 12, 0 } }, /* at-band-camp */
    { .label = { 137996,  7, 0 } }, /* blogdns */
    { .label = { 117995,  8, 0 } }, /* broke-it */
    { .label = {  79445, 10, 0 } }, /* buyshouses */
    { .label = { 118031,  8, 0 } }, /* dnsalias */
    { .label = { 138060,  7, 0 } }, /* dnsdojo */
    { .label = { 138093,  7, 0 } }, /* does-it */
    { .label = {  97181,  9, 0 } }, /* dontexist */
    { .label = { 118063,  8, 0 } }, /* dynalias */
    { .label = {  97220,  9, 0 } }, /* dynathome */
    { .label = {  39753, 13, 0 } }, /* endofinternet */
    { .label = { 138313,  7, 0 } }, /* from-az */
    { .label = { 138379,  7, 0 } }, /* from-co */
    { .label = { 138809,  7, 0 } }, /* from-la */
    { .label = { 139338,  7, 0 } }, /* from-ny */
    { .label = { 139974,  7, 0 } }, /* gets-it */
    { .label = {  51095, 12, 0 } }, /* ham-radio-op */
    { .label = {  97242,  7, 0 } }, /* homeftp */
    { .label = { 157174,  6, 0 } }, /* homeip */
    { .label = {  97380,  9, 0 } }, /* homelinux */
    { .label = { 118133,  8, 0 } }, /* homeunix */
    { .label = {  65130, 11, 0 } }, /* in-the-band */
    { .label = {  97458,  9, 0 } }, /* is-a-chef */
    { .label = {  97499,  9, 0 } }, /* is-a-geek */
    { .label = { 118313,  8, 0 } }, /* isa-geek */
    { .label = {  97578,  9, 0 } }, /* kicks-ass */
    { .label = {  40421, 13, 0 } }, /* office-on-the */
    { .label = { 140154,  7, 0 } }, /* podzone */
    { .label = {  40481, 13, 0 } }, /* scrapper-site */
    { .label = { 157231,  6, 0 } }, /* selfip */
    { .label = { 118452,  8, 0 } }, /* sells-it */
    { .label = { 118487,  8, 0 } }, /* servebbs */
    { .label = { 118525,  8, 0 } }, /* serveftp */
    { .label = { 118597,  8, 0 } }, /* thruhere */
    { .label = { 157260,  6, 0 } }, /* webhop */
    { .label = { 118679,  8, 0 } }, /* definima */
    { .label = { 140224,  7, 0 } }, /* casacam */
    { .label = { 171863,  4, 0 } }, /* dynu */
    { .label = { 168044,  5, 0 } }, /* dynv6 */
    { .label = { 157431,  6, 0 } }, /* twmail */
    { .label = {    204,  2, 0 } }, /* ru */
    { .label = {  66008, 11, 1 } }, { .child = { 7118, 1 } }, /* channelsdvr */
    { .label = { 119347,  8, 1 } }, { .child = { 7119, 1 } }, /* fastlylb */
    { .label = {  17811,  6, 1 } }, { .child = { 7120, 4 } }, /* fastly */
    { .label = { 140645,  7, 0 } }, /* edgeapp */
    { .label = {  51991, 12, 0 } }, /* flynnhosting */
    { .label = {  32329, 14, 0 } }, /* cloudfunctions */
    { .label = {  98331,  9, 0 } }, /* moonscale */
    { .label = { 157820,  6, 0 } }, /* in-dsl */
    { .label = { 157847,  6, 0 } }, /* in-vpn */
    { .label = { 140841,  7, 0 } }, /* ipifony */
    { .label = { 172115,  4, 0 } }, /* iobb */
    { .label = { 119715,  8, 0 } }, /* kinghost */
    { .label = { 172135,  4, 0 } }, /* uni5 */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = { 158075,  6, 0 } }, /* memset */
    { .label = {  41060, 13, 0 } }, /* azurewebsites */
    { .label = {  52265, 12, 0 } }, /* azure-mobile */
    { .label = {  98163,  8, 0 } }, /* cloudapp */
    { .label = {  79222,  5, 0 } }, /* dnsup */
    { .label = { 168356,  5, 0 } }, /* hicam */
    { .label = { 141126,  7, 0 } }, /* now-dns */
    { .label = { 168378,  5, 0 } }, /* ownip */
    { .label = { 158174,  6, 0 } }, /* vpndns */
    { .label = {  32577, 14, 0 } }, /* eating-organic */
    { .label = {  98724,  9, 0 } }, /* mydissent */
    { .label = { 120004,  8, 0 } }, /* myeffect */
    { .label = {  98764,  9, 0 } }, /* mymediapc */
    { .label = { 168495,  5, 0 } }, /* mypsx */
    { .label = {  18023, 16, 0 } }, /* mysecuritycamera */
    { .label = { 158314,  6, 0 } }, /* nhlfan */
    { .label = { 168522,  5, 0 } }, /* no-ip */
    { .label = { 158341,  6, 0 } }, /* pgafan */
    { .label = {   1461, 24, 0 } }, /* privatizehealthinsurance */
    { .label = { 120086,  8, 0 } }, /* bounceme */
    { .label = { 117941,  4, 0 } }, /* ddns */
    { .label = {  81422, 10, 0 } }, /* redirectme */
    { .label = {  98888,  9, 0 } }, /* serveblog */
    { .label = {  32700, 14, 0 } }, /* serveminecraft */
    { .label = {  81310,  5, 0 } }, /* sytes */
    { .label = {  41350, 13, 0 } }, /* cloudycluster */
    { .label = { 120341,  8, 0 } }, /* rackmaze */
    { .label = {  81735, 10, 0 } }, /* schokokeks */
    { .label = {  18094, 16, 0 } }, /* firewall-gateway */
    { .label = { 158655,  6, 0 } }, /* seidat */
    { .label = {  81875, 10, 0 } }, /* senseering */
    { .label = { 120557,  8, 0 } }, /* siteleaf */
    { .label = { 172454,  4, 1 } }, { .child = { 7131, 2 } }, /* srcf */
    { .label = { 141506,  7, 0 } }, /* dsmynas */
    { .label = { 120701,  8, 0 } }, /* familyds */
    { .label = {  41528, 13, 0 } }, /* community-pro */
    { .label = {  99420,  9, 0 } }, /* meinforum */
    { .label = {  67656, 11, 1 } }, { .child = { 7133, 2 } }, /* yandexcloud */
    { .label = {   2924,  2, 0 } }, /* za */

    /* entry 7116 */
    { .label = {      1,  1, 0 } }, /* r */

    /* entry 7117 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 7118 */
    { .label = {     46,  1, 0 } }, /* u */

    /* entry 7119 */
    { .label = {  10250,  3, 0 } }, /* map */

    /* entries 7120 to 7125 */
    { .label = { 140614,  7, 0 } }, /* freetls */
    { .label = {  10250,  3, 0 } }, /* map */
    { .label = {  61865,  4, 1 } }, { .child = { 7126, 2 } }, /* prod */
    { .label = {  24388,  3, 1 } }, { .child = { 7128, 3 } }, /* ssl */

    /* entries 7126 to 7127 */
    { .label = {     26,  1, 0 } }, /* a */
    { .label = { 155094,  6, 0 } }, /* global */

    /* entries 7128 to 7130 */
    { .label = {     26,  1, 0 } }, /* a */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = { 155094,  6, 0 } }, /* global */

    /* entries 7131 to 7132 */
    { .label = {   2773,  3, 0 } }, /* soc */
    { .label = {   4065,  4, 0 } }, /* user */

    /* entries 7133 to 7134 */
    { .label = { 136871,  7, 0 } }, /* storage */
    { .label = {    683,  7, 0 } }, /* website */

    /* entries 7135 to 7144 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   5481,  3, 0 } }, /* per */
    { .label = {  13663,  3, 0 } }, /* rec */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {   7959,  4, 0 } }, /* arts */
    { .label = { 116161,  4, 0 } }, /* firm */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = { 134644,  5, 0 } }, /* other */
    { .label = { 159058,  5, 0 } }, /* store */

    /* entries 7145 to 7160 */
    { .label = {    106,  3, 1 } }, { .child = { 7161, 1 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {     27,  1, 0 } }, /* i */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  10299,  4, 0 } }, /* mobi */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6759,  3, 0 } }, /* sch */
    { .label = {   4293,  3, 0 } }, /* col */
    { .label = { 116161,  4, 0 } }, /* firm */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {  38987,  3, 0 } }, /* ltd */
    { .label = {  10119,  3, 0 } }, /* ngo */

    /* entry 7161 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 7162 to 7175 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 7176 to 7185 */
    { .label = { 171689,  4, 0 } }, /* amsw */
    { .label = {  31413, 14, 0 } }, /* virtueeldomein */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  24117, 15, 0 } }, /* hosting-cluster */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = { 157959,  6, 0 } }, /* khplay */
    { .label = { 120777,  8, 1 } }, { .child = { 7186, 1 } }, /* transurl */
    { .label = { 141971,  7, 0 } }, /* cistron */
    { .label = { 169016,  5, 0 } }, /* demon */

    /* entry 7186 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 7187 to 7944 */
    { .label = {  13356,  3, 0 } }, /* fhs */
    { .label = {   7722,  3, 0 } }, /* vgs */
    { .label = {  74453, 10, 0 } }, /* fylkesbibl */
    { .label = {  90693,  9, 0 } }, /* folkebibl */
    { .label = {   4540,  6, 0 } }, /* museum */
    { .label = { 150881,  6, 0 } }, /* idrett */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {   5603,  4, 0 } }, /* stat */
    { .label = {   7080,  3, 0 } }, /* dep */
    { .label = { 130494,  7, 0 } }, /* kommune */
    { .label = {  11787,  5, 0 } }, /* herad */
    { .label = {     91,  2, 1 } }, { .child = { 7945, 1 } }, /* aa */
    { .label = {   1500,  2, 1 } }, { .child = { 7946, 1 } }, /* ah */
    { .label = {   2306,  2, 1 } }, { .child = { 7947, 1 } }, /* bu */
    { .label = {   3284,  2, 1 } }, { .child = { 7948, 1 } }, /* fm */
    { .label = {   3680,  2, 1 } }, { .child = { 7949, 1 } }, /* hl */
    { .label = {   7165,  2, 1 } }, { .child = { 7950, 1 } }, /* hm */
    { .label = {  90738,  9, 1 } }, { .child = { 7951, 1 } }, /* jan-mayen */
    { .label = {    205,  2, 1 } }, { .child = { 7952, 1 } }, /* mr */
    { .label = {   2989,  2, 1 } }, { .child = { 7953, 1 } }, /* nl */
    { .label = {    252,  2, 1 } }, { .child = { 7954, 1 } }, /* nt */
    { .label = {   5403,  2, 1 } }, { .child = { 7955, 1 } }, /* of */
    { .label = {    528,  2, 1 } }, { .child = { 7956, 1 } }, /* ol */
    { .label = { 158619,  4, 1 } }, { .child = { 7957, 1 } }, /* oslo */
    { .label = {    193,  2, 1 } }, { .child = { 7958, 1 } }, /* rl */
    { .label = {  10496,  2, 1 } }, { .child = { 7959, 1 } }, /* sf */
    { .label = {    179,  2, 1 } }, { .child = { 7960, 1 } }, /* st */
    { .label = { 111375,  8, 1 } }, { .child = { 7961, 1 } }, /* svalbard */
    { .label = {   2442,  2, 1 } }, { .child = { 7962, 1 } }, /* tm */
    { .label = {    163,  2, 1 } }, { .child = { 7963, 1 } }, /* tr */
    { .label = {     54,  2, 1 } }, { .child = { 7964, 1 } }, /* va */
    { .label = {  14922,  2, 1 } }, { .child = { 7965, 1 } }, /* vf */
    { .label = { 111411,  8, 0 } }, /* akrehamn */
    { .label = {  20966, 15, 0 } }, /* xn--krehamn-dxa */
    { .label = {  20070,  6, 0 } }, /* algard */
    { .label = {  35559, 13, 0 } }, /* xn--lgrd-poac */
    { .label = {  38669,  4, 0 } }, /* arna */
    { .label = {  74504, 10, 0 } }, /* brumunddal */
    { .label = { 163258,  5, 0 } }, /* bryne */
    { .label = {  58523, 11, 0 } }, /* bronnoysund */
    { .label = {   9042, 18, 0 } }, /* xn--brnnysund-m8ac */
    { .label = { 150906,  6, 0 } }, /* drobak */
    { .label = {  35621, 13, 0 } }, /* xn--drbak-wua */
    { .label = { 111444,  8, 0 } }, /* egersund */
    { .label = { 130526,  7, 0 } }, /* fetsund */
    { .label = { 163282,  5, 0 } }, /* floro */
    { .label = {  45509, 12, 0 } }, /* xn--flor-jra */
    { .label = {  58573, 11, 0 } }, /* fredrikstad */
    { .label = { 111479,  8, 0 } }, /* hokksund */
    { .label = { 111516,  8, 0 } }, /* honefoss */
    { .label = {  21035, 15, 0 } }, /* xn--hnefoss-q1a */
    { .label = { 111551,  8, 0 } }, /* jessheim */
    { .label = {  90779,  9, 0 } }, /* jorpeland */
    { .label = {  15642, 16, 0 } }, /* xn--jrpeland-54a */
    { .label = { 111588,  8, 0 } }, /* kirkenes */
    { .label = { 111622,  8, 0 } }, /* kopervik */
    { .label = {  45567, 12, 0 } }, /* krokstadelva */
    { .label = { 111660,  8, 0 } }, /* langevag */
    { .label = {  21110, 15, 0 } }, /* xn--langevg-jxa */
    { .label = { 130558,  7, 0 } }, /* leirvik */
    { .label = {  90821,  9, 0 } }, /* mjondalen */
    { .label = {  15726, 16, 0 } }, /* xn--mjndalen-64a */
    { .label = {  90862,  9, 0 } }, /* mo-i-rana */
    { .label = { 130590,  7, 0 } }, /* mosjoen */
    { .label = {  27645, 14, 0 } }, /* xn--mosjen-eya */
    { .label = {  45619, 12, 0 } }, /* nesoddtangen */
    { .label = { 111695,  8, 0 } }, /* orkanger */
    { .label = { 150933,  6, 0 } }, /* osoyro */
    { .label = {  35683, 13, 0 } }, /* xn--osyro-wua */
    { .label = { 150959,  6, 0 } }, /* raholt */
    { .label = {  35744, 13, 0 } }, /* xn--rholt-mra */
    { .label = {  45669, 12, 0 } }, /* sandnessjoen */
    { .label = {   6865, 19, 0 } }, /* xn--sandnessjen-ogb */
    { .label = {  35803, 13, 0 } }, /* skedsmokorset */
    { .label = { 130622,  7, 0 } }, /* slattum */
    { .label = {  74551, 10, 0 } }, /* spjelkavik */
    { .label = {  90899,  9, 0 } }, /* stathelle */
    { .label = { 130652,  7, 0 } }, /* stavern */
    { .label = {  21183, 15, 0 } }, /* stjordalshalsen */
    { .label = {   2387, 22, 0 } }, /* xn--stjrdalshalsen-sqb */
    { .label = { 111728,  8, 0 } }, /* tananger */
    { .label = { 150984,  6, 0 } }, /* tranby */
    { .label = {  58621, 11, 0 } }, /* vossevangen */
    { .label = {  28334,  6, 0 } }, /* afjord */
    { .label = {  35859, 13, 0 } }, /* xn--fjord-lra */
    { .label = { 130681,  7, 0 } }, /* agdenes */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {  90937,  9, 0 } }, /* xn--l-1fa */
    { .label = { 130710,  7, 0 } }, /* alesund */
    { .label = {  27711, 14, 0 } }, /* xn--lesund-hua */
    { .label = {  90984,  9, 0 } }, /* alstahaug */
    { .label = {   4022,  4, 0 } }, /* alta */
    { .label = {  58669, 11, 0 } }, /* xn--lt-liac */
    { .label = {  91021,  9, 0 } }, /* alaheadju */
    { .label = {  15809, 16, 0 } }, /* xn--laheadju-7ya */
    { .label = {  59733,  6, 0 } }, /* alvdal */
    { .label = { 163432,  4, 0 } }, /* amli */
    { .label = {  58720, 11, 0 } }, /* xn--mli-tla */
    { .label = {  39674,  4, 0 } }, /* amot */
    { .label = {  58771, 11, 0 } }, /* xn--mot-tla */
    { .label = { 151011,  6, 0 } }, /* andebu */
    { .label = { 152548,  5, 0 } }, /* andoy */
    { .label = {  45720, 12, 0 } }, /* xn--andy-ira */
    { .label = {  91061,  9, 0 } }, /* andasuolo */
    { .label = {  36825,  5, 0 } }, /* ardal */
    { .label = {  45774, 12, 0 } }, /* xn--rdal-poa */
    { .label = { 130740,  7, 0 } }, /* aremark */
    { .label = { 130768,  7, 0 } }, /* arendal */
    { .label = {  91098,  9, 0 } }, /* xn--s-1fa */
    { .label = { 151038,  6, 0 } }, /* aseral */
    { .label = {  35922, 13, 0 } }, /* xn--seral-lra */
    { .label = { 163305,  5, 0 } }, /* asker */
    { .label = { 163325,  5, 0 } }, /* askim */
    { .label = { 130796,  7, 0 } }, /* askvoll */
    { .label = { 163346,  5, 0 } }, /* askoy */
    { .label = {  45829, 12, 0 } }, /* xn--asky-ira */
    { .label = {  37141,  5, 0 } }, /* asnes */
    { .label = {  45883, 12, 0 } }, /* xn--snes-poa */
    { .label = {  91144,  9, 0 } }, /* audnedaln */
    { .label = { 163368,  5, 0 } }, /* aukra */
    { .label = { 169381,  4, 0 } }, /* aure */
    { .label = { 130828,  7, 0 } }, /* aurland */
    { .label = {  27776, 14, 0 } }, /* aurskog-holand */
    { .label = {   3625, 21, 0 } }, /* xn--aurskog-hland-jnb */
    { .label = {  91182,  9, 0 } }, /* austevoll */
    { .label = {  91222,  9, 0 } }, /* austrheim */
    { .label = { 151061,  6, 0 } }, /* averoy */
    { .label = {  35979, 13, 0 } }, /* xn--avery-yua */
    { .label = {  74600, 10, 0 } }, /* balestrand */
    { .label = {  91260,  9, 0 } }, /* ballangen */
    { .label = {  84919,  5, 0 } }, /* balat */
    { .label = {  45937, 12, 0 } }, /* xn--blt-elab */
    { .label = {  91299,  9, 0 } }, /* balsfjord */
    { .label = {  45995, 12, 0 } }, /* bahccavuotna */
    { .label = {   6952, 19, 0 } }, /* xn--bhccavuotna-k7a */
    { .label = { 151088,  6, 0 } }, /* bamble */
    { .label = { 163388,  5, 0 } }, /* bardu */
    { .label = { 151117,  6, 0 } }, /* beardu */
    { .label = { 151144,  6, 0 } }, /* beiarn */
    { .label = { 130857,  7, 0 } }, /* bajddar */
    { .label = {  27837, 14, 0 } }, /* xn--bjddar-pta */
    { .label = { 151169,  6, 0 } }, /* baidar */
    { .label = {  36041, 13, 0 } }, /* xn--bidr-5nac */
    { .label = {  22795,  4, 0 } }, /* berg */
    { .label = { 151194,  6, 0 } }, /* bergen */
    { .label = { 111759,  8, 0 } }, /* berlevag */
    { .label = {  21248, 15, 0 } }, /* xn--berlevg-jxa */
    { .label = {  58821, 11, 0 } }, /* bearalvahki */
    { .label = {   9131, 18, 0 } }, /* xn--bearalvhki-y4a */
    { .label = { 151221,  6, 0 } }, /* bindal */
    { .label = { 111796,  8, 0 } }, /* birkenes */
    { .label = { 130890,  7, 0 } }, /* bjarkoy */
    { .label = {  27905, 14, 0 } }, /* xn--bjarky-fya */
    { .label = {  91343,  9, 0 } }, /* bjerkreim */
    { .label = { 163411,  5, 0 } }, /* bjugn */
    { .label = { 169982,  4, 0 } }, /* bodo */
    { .label = {  58869, 11, 0 } }, /* xn--bod-2na */
    { .label = { 111831,  8, 0 } }, /* badaddja */
    { .label = {  21323, 15, 0 } }, /* xn--bdddj-mrabd */
    { .label = { 130925,  7, 0 } }, /* budejju */
    { .label = {  16383,  4, 0 } }, /* bokn */
    { .label = {  91386,  9, 0 } }, /* bremanger */
    { .label = {  58523,  7, 0 } }, /* bronnoy */
    { .label = {  27976, 14, 0 } }, /* xn--brnny-wuac */
    { .label = { 130964,  7, 0 } }, /* bygland */
    { .label = { 163438,  5, 0 } }, /* bykle */
    { .label = { 163464,  5, 0 } }, /* barum */
    { .label = {  46048, 12, 0 } }, /* xn--brum-voa */
    { .label = { 111868,  8, 1 } }, { .child = { 7966, 2 } }, /* telemark */
    { .label = { 111902,  8, 1 } }, { .child = { 7968, 4 } }, /* nordland */
    { .label = { 151248,  6, 0 } }, /* bievat */
    { .label = {  36106, 13, 0 } }, /* xn--bievt-0qa */
    { .label = { 163487,  5, 0 } }, /* bomlo */
    { .label = {  46106, 12, 0 } }, /* xn--bmlo-gra */
    { .label = {  91473,  9, 0 } }, /* batsfjord */
    { .label = {  15889, 16, 0 } }, /* xn--btsfjord-9za */
    { .label = {  58924, 11, 0 } }, /* bahcavuotna */
    { .label = {   9219, 18, 0 } }, /* xn--bhcavuotna-s4a */
    { .label = { 163511,  5, 0 } }, /* dovre */
    { .label = { 130998,  7, 0 } }, /* drammen */
    { .label = {  91516,  9, 0 } }, /* drangedal */
    { .label = { 163534,  5, 0 } }, /* dyroy */
    { .label = {  46163, 12, 0 } }, /* xn--dyry-ira */
    { .label = { 163559,  5, 0 } }, /* donna */
    { .label = {  46220, 12, 0 } }, /* xn--dnna-gra */
    { .label = {   4620,  3, 0 } }, /* eid */
    { .label = { 111936,  8, 0 } }, /* eidfjord */
    { .label = { 111975,  8, 0 } }, /* eidsberg */
    { .label = { 131028,  7, 0 } }, /* eidskog */
    { .label = { 112011,  8, 0 } }, /* eidsvoll */
    { .label = {  91554,  9, 0 } }, /* eigersund */
    { .label = { 131059,  7, 0 } }, /* elverum */
    { .label = { 131092,  7, 0 } }, /* enebakk */
    { .label = { 112048,  8, 0 } }, /* engerdal */
    { .label = { 131123,  4, 0 } }, /* etne */
    { .label = { 131123,  7, 0 } }, /* etnedal */
    { .label = { 151275,  6, 0 } }, /* evenes */
    { .label = { 112082,  8, 0 } }, /* evenassi */
    { .label = {  11578, 17, 0 } }, /* xn--eveni-0qa01ga */
    { .label = {  21399, 15, 0 } }, /* evje-og-hornnes */
    { .label = { 131152,  7, 0 } }, /* farsund */
    { .label = { 151301,  6, 0 } }, /* fauske */
    { .label = { 131183,  7, 0 } }, /* fuossko */
    { .label = { 131215,  7, 0 } }, /* fuoisku */
    { .label = { 163579,  5, 0 } }, /* fedje */
    { .label = {   7272,  3, 0 } }, /* fet */
    { .label = { 151328,  6, 0 } }, /* finnoy */
    { .label = {  36174, 13, 0 } }, /* xn--finny-yua */
    { .label = { 151356,  6, 0 } }, /* fitjar */
    { .label = { 151384,  6, 0 } }, /* fjaler */
    { .label = {  46505,  5, 0 } }, /* fjell */
    { .label = { 112115,  8, 0 } }, /* flakstad */
    { .label = {  91593,  9, 0 } }, /* flatanger */
    { .label = {  58972, 11, 0 } }, /* flekkefjord */
    { .label = { 112150,  8, 0 } }, /* flesberg */
    { .label = { 163605,  5, 0 } }, /* flora */
    { .label = {  39438,  3, 0 } }, /* fla */
    { .label = {  74642, 10, 0 } }, /* xn--fl-zia */
    { .label = { 131248,  7, 0 } }, /* folldal */
    { .label = { 131281,  7, 0 } }, /* forsand */
    { .label = { 151413,  6, 0 } }, /* fosnes */
    { .label = { 109864,  4, 0 } }, /* frei */
    { .label = { 163627,  5, 0 } }, /* frogn */
    { .label = { 131311,  7, 0 } }, /* froland */
    { .label = { 151439,  6, 0 } }, /* frosta */
    { .label = { 108216,  5, 0 } }, /* frana */
    { .label = {  46273, 12, 0 } }, /* xn--frna-woa */
    { .label = { 163650,  5, 0 } }, /* froya */
    { .label = {  46328, 12, 0 } }, /* xn--frya-hra */
    { .label = {  13348,  4, 0 } }, /* fusa */
    { .label = { 112188,  8, 0 } }, /* fyresdal */
    { .label = { 163673,  5, 0 } }, /* forde */
    { .label = {  46384, 12, 0 } }, /* xn--frde-gra */
    { .label = { 151464,  6, 0 } }, /* gamvik */
    { .label = {  74692, 10, 0 } }, /* gangaviika */
    { .label = {   7044, 19, 0 } }, /* xn--ggaviika-8ya47h */
    { .label = { 151492,  6, 0 } }, /* gaular */
    { .label = { 131342,  7, 0 } }, /* gausdal */
    { .label = {  91631,  9, 0 } }, /* gildeskal */
    { .label = {  15974, 16, 0 } }, /* xn--gildeskl-g0a */
    { .label = { 163696,  5, 0 } }, /* giske */
    { .label = { 131372,  7, 0 } }, /* gjemnes */
    { .label = { 112225,  8, 0 } }, /* gjerdrum */
    { .label = { 112264,  8, 0 } }, /* gjerstad */
    { .label = { 131405,  7, 0 } }, /* gjesdal */
    { .label = { 151517,  6, 0 } }, /* gjovik */
    { .label = {  36237, 13, 0 } }, /* xn--gjvik-wua */
    { .label = { 131438,  7, 0 } }, /* gloppen */
    { .label = {  22832,  3, 0 } }, /* gol */
    { .label = {  24556,  4, 0 } }, /* gran */
    { .label = { 163718,  5, 0 } }, /* grane */
    { .label = { 131472,  7, 0 } }, /* granvin */
    { .label = {  91671,  9, 0 } }, /* gratangen */
    { .label = { 112300,  8, 0 } }, /* grimstad */
    { .label = { 163738,  5, 0 } }, /* grong */
    { .label = {  91707,  9, 0 } }, /* kraanghke */
    { .label = {  16052, 16, 0 } }, /* xn--kranghke-b0a */
    { .label = {  49519,  4, 0 } }, /* grue */
    { .label = { 163760,  5, 0 } }, /* gulen */
    { .label = { 151548,  6, 0 } }, /* hadsel */
    { .label = { 151574,  6, 0 } }, /* halden */
    { .label = { 163783,  5, 0 } }, /* halsa */
    { .label = { 131502,  5, 0 } }, /* hamar */
    { .label = { 131502,  7, 0 } }, /* hamaroy */
    { .label = { 151600,  6, 0 } }, /* habmer */
    { .label = {  36303, 13, 0 } }, /* xn--hbmer-xqa */
    { .label = { 151627,  6, 0 } }, /* hapmir */
    { .label = {  36369, 13, 0 } }, /* xn--hpmir-xqa */
    { .label = {  74734, 10, 0 } }, /* hammerfest */
    { .label = {  46440, 12, 0 } }, /* hammarfeasta */
    { .label = {   7145, 19, 0 } }, /* xn--hmmrfeasta-s4ac */
    { .label = { 105464,  5, 0 } }, /* haram */
    { .label = { 151654,  6, 0 } }, /* hareid */
    { .label = { 131532,  7, 0 } }, /* harstad */
    { .label = { 151679,  6, 0 } }, /* hasvik */
    { .label = {  74778, 10, 0 } }, /* aknoluokta */
    { .label = {   7234, 19, 0 } }, /* xn--koluokta-7ya57h */
    { .label = {  46489, 12, 0 } }, /* hattfjelldal */
    { .label = { 112334,  8, 0 } }, /* aarborte */
    { .label = {  91745,  9, 0 } }, /* haugesund */
    { .label = { 151706,  5, 0 } }, /* hemne */
    { .label = { 151706,  6, 0 } }, /* hemnes */
    { .label = { 112366,  8, 0 } }, /* hemsedal */
    { .label = {  21468, 15, 1 } }, { .child = { 7972, 2 } }, /* more-og-romsdal */
    { .label = {   2491, 22, 1 } }, { .child = { 7974, 2 } }, /* xn--mre-og-romsdal-qqb */
    { .label = {  41108,  5, 0 } }, /* hitra */
    { .label = { 112401,  8, 0 } }, /* hjartdal */
    { .label = {  74820, 10, 0 } }, /* hjelmeland */
    { .label = { 163826,  5, 0 } }, /* hobol */
    { .label = {  46600, 12, 0 } }, /* xn--hobl-ira */
    { .label = {   8602,  3, 0 } }, /* hof */
    { .label = {  21554,  3, 0 } }, /* hol */
    { .label = { 170001,  4, 0 } }, /* hole */
    { .label = {  59027, 11, 0 } }, /* holmestrand */
    { .label = { 112437,  8, 0 } }, /* holtalen */
    { .label = {  21534, 15, 0 } }, /* xn--holtlen-hxa */
    { .label = {  91785,  9, 0 } }, /* hornindal */
    { .label = { 151732,  6, 0 } }, /* horten */
    { .label = { 151757,  6, 0 } }, /* hurdal */
    { .label = { 163850,  5, 0 } }, /* hurum */
    { .label = { 151784,  6, 0 } }, /* hvaler */
    { .label = {  91823,  9, 0 } }, /* hyllestad */
    { .label = {  74867, 10, 0 } }, /* hagebostad */
    { .label = {  11668, 17, 0 } }, /* xn--hgebostad-g3a */
    { .label = { 112471,  8, 0 } }, /* hoyanger */
    { .label = {  21604, 15, 0 } }, /* xn--hyanger-q1a */
    { .label = {  91864,  9, 0 } }, /* hoylandet */
    { .label = {  16129, 16, 0 } }, /* xn--hylandet-54a */
    { .label = {   2443,  2, 0 } }, /* ha */
    { .label = {  91904,  9, 0 } }, /* xn--h-2fa */
    { .label = { 131560,  7, 0 } }, /* ibestad */
    { .label = { 131590,  7, 0 } }, /* inderoy */
    { .label = {  28044, 14, 0 } }, /* xn--indery-fya */
    { .label = { 131621,  7, 0 } }, /* iveland */
    { .label = { 112506,  8, 0 } }, /* jevnaker */
    { .label = {  90826,  6, 0 } }, /* jondal */
    { .label = { 131652,  7, 0 } }, /* jolster */
    { .label = {  28111, 14, 0 } }, /* xn--jlster-bya */
    { .label = { 112543,  8, 0 } }, /* karasjok */
    { .label = {  74910, 10, 0 } }, /* karasjohka */
    { .label = {   7335, 19, 0 } }, /* xn--krjohka-hwab49j */
    { .label = { 131684,  7, 0 } }, /* karlsoy */
    { .label = { 163874,  5, 0 } }, /* galsa */
    { .label = {  46656, 12, 0 } }, /* xn--gls-elac */
    { .label = { 151811,  6, 0 } }, /* karmoy */
    { .label = {  36435, 13, 0 } }, /* xn--karmy-yua */
    { .label = {  74953, 10, 0 } }, /* kautokeino */
    { .label = {  36497, 13, 0 } }, /* guovdageaidnu */
    { .label = { 163894,  5, 0 } }, /* klepp */
    { .label = { 163920,  5, 0 } }, /* klabu */
    { .label = {  46712, 12, 0 } }, /* xn--klbu-woa */
    { .label = {  91951,  9, 0 } }, /* kongsberg */
    { .label = {  59074, 11, 0 } }, /* kongsvinger */
    { .label = { 131715,  7, 0 } }, /* kragero */
    { .label = {  28179, 14, 0 } }, /* xn--krager-gya */
    { .label = {  46771, 12, 0 } }, /* kristiansand */
    { .label = {  46819, 12, 0 } }, /* kristiansund */
    { .label = {  74995, 10, 0 } }, /* krodsherad */
    { .label = {  11749, 17, 0 } }, /* xn--krdsherad-m8a */
    { .label = { 112578,  8, 0 } }, /* kvalsund */
    { .label = {  59123, 11, 0 } }, /* rahkkeravju */
    { .label = {   9305, 18, 0 } }, /* xn--rhkkervju-01af */
    { .label = { 170019,  4, 0 } }, /* kvam */
    { .label = {  91992,  9, 0 } }, /* kvinesdal */
    { .label = {  75038, 10, 0 } }, /* kvinnherad */
    { .label = {  92032,  9, 0 } }, /* kviteseid */
    { .label = { 131744,  7, 0 } }, /* kvitsoy */
    { .label = {  28243, 14, 0 } }, /* xn--kvitsy-fya */
    { .label = { 112615,  8, 0 } }, /* kvafjord */
    { .label = {  21679, 15, 0 } }, /* xn--kvfjord-nxa */
    { .label = {  36555, 13, 0 } }, /* giehtavuoatna */
    { .label = {  92072,  9, 0 } }, /* kvanangen */
    { .label = {  16211, 16, 0 } }, /* xn--kvnangen-k0a */
    { .label = { 112655,  8, 0 } }, /* navuotna */
    { .label = {  21754, 15, 0 } }, /* xn--nvuotna-hwa */
    { .label = { 131777,  7, 0 } }, /* kafjord */
    { .label = {  28312, 14, 0 } }, /* xn--kfjord-iua */
    { .label = {  92110,  9, 0 } }, /* gaivuotna */
    { .label = {  16287, 16, 0 } }, /* xn--givuotna-8ya */
    { .label = { 151838,  6, 0 } }, /* larvik */
    { .label = { 112688,  8, 0 } }, /* lavangen */
    { .label = { 131811,  7, 0 } }, /* lavagis */
    { .label = { 151865,  6, 0 } }, /* loabat */
    { .label = {  36609, 13, 0 } }, /* xn--loabt-0qa */
    { .label = { 131841,  7, 0 } }, /* lebesby */
    { .label = {  75082, 10, 0 } }, /* davvesiida */
    { .label = {  92148,  9, 0 } }, /* leikanger */
    { .label = {  92186,  9, 0 } }, /* leirfjord */
    { .label = {  93554,  4, 0 } }, /* leka */
    { .label = { 131876,  7, 0 } }, /* leksvik */
    { .label = { 151890,  6, 0 } }, /* lenvik */
    { .label = {  59174, 11, 0 } }, /* leangaviika */
    { .label = {   9400, 18, 0 } }, /* xn--leagaviika-52b */
    { .label = { 163944,  5, 0 } }, /* lesja */
    { .label = { 112722,  8, 0 } }, /* levanger */
    { .label = {  74059,  4, 0 } }, /* lier */
    { .label = { 151918,  6, 0 } }, /* lierne */
    { .label = {  59220, 11, 0 } }, /* lillehammer */
    { .label = {  92229,  9, 0 } }, /* lillesand */
    { .label = {  92268,  9, 0 } }, /* lindesnes */
    { .label = { 151943,  6, 0 } }, /* lindas */
    { .label = {  36675, 13, 0 } }, /* xn--linds-pra */
    { .label = {  18382,  3, 0 } }, /* lom */
    { .label = { 163967,  5, 0 } }, /* loppa */
    { .label = { 151968,  6, 0 } }, /* lahppi */
    { .label = {  36735, 13, 0 } }, /* xn--lhppi-xqa */
    { .label = { 116655,  4, 0 } }, /* lund */
    { .label = { 151997,  6, 0 } }, /* lunner */
    { .label = { 163991,  5, 0 } }, /* luroy */
    { .label = {  46869, 12, 0 } }, /* xn--lury-ira */
    { .label = {  24157,  6, 0 } }, /* luster */
    { .label = { 131909,  7, 0 } }, /* lyngdal */
    { .label = { 152023,  6, 0 } }, /* lyngen */
    { .label = { 170038,  4, 0 } }, /* ivgu */
    { .label = { 152051,  6, 0 } }, /* lardal */
    { .label = { 152076,  6, 0 } }, /* lerdal */
    { .label = {  36803, 13, 0 } }, /* xn--lrdal-sra */
    { .label = { 112757,  8, 0 } }, /* lodingen */
    { .label = {  21823, 15, 0 } }, /* xn--ldingen-q1a */
    { .label = {  92306,  9, 0 } }, /* lorenskog */
    { .label = {  16365, 16, 0 } }, /* xn--lrenskog-54a */
    { .label = { 164015,  5, 0 } }, /* loten */
    { .label = {  46925, 12, 0 } }, /* xn--lten-gra */
    { .label = { 132678,  6, 0 } }, /* malvik */
    { .label = { 131693,  5, 0 } }, /* masoy */
    { .label = {  36861, 13, 0 } }, /* xn--msy-ula0h */
    { .label = { 152102,  6, 0 } }, /* muosat */
    { .label = {  36927, 13, 0 } }, /* xn--muost-0qa */
    { .label = { 152127,  6, 0 } }, /* mandal */
    { .label = { 152152,  6, 0 } }, /* marker */
    { .label = {  92345,  9, 0 } }, /* marnardal */
    { .label = {  75126, 10, 0 } }, /* masfjorden */
    { .label = {  74841,  6, 0 } }, /* meland */
    { .label = { 152177,  6, 0 } }, /* meldal */
    { .label = { 152204,  6, 0 } }, /* melhus */
    { .label = { 164036,  5, 0 } }, /* meloy */
    { .label = {  46979, 12, 0 } }, /* xn--mely-ira */
    { .label = { 131942,  7, 0 } }, /* meraker */
    { .label = {  28380, 14, 0 } }, /* xn--merker-kua */
    { .label = { 131971,  7, 0 } }, /* moareke */
    { .label = {  28444, 14, 0 } }, /* xn--moreke-jua */
    { .label = { 132000,  7, 0 } }, /* midsund */
    { .label = {  28510, 14, 0 } }, /* midtre-gauldal */
    { .label = { 132032,  7, 0 } }, /* modalen */
    { .label = { 164060,  5, 0 } }, /* modum */
    { .label = { 164084,  5, 0 } }, /* molde */
    { .label = { 112792,  8, 0 } }, /* moskenes */
    { .label = { 170058,  4, 0 } }, /* moss */
    { .label = { 152232,  6, 0 } }, /* mosvik */
    { .label = { 132062,  7, 0 } }, /* malselv */
    { .label = {  28572, 14, 0 } }, /* xn--mlselv-iua */
    { .label = {  59269, 11, 0 } }, /* malatvuopmi */
    { .label = {   9490, 18, 0 } }, /* xn--mlatvuopmi-s4a */
    { .label = {  75172, 10, 0 } }, /* namdalseid */
    { .label = { 152260,  6, 0 } }, /* aejrie */
    { .label = { 152286,  6, 0 } }, /* namsos */
    { .label = {  75214, 10, 0 } }, /* namsskogan */
    { .label = {  28638, 14, 0 } }, /* naamesjevuemie */
    { .label = {   3724, 21, 0 } }, /* xn--nmesjevuemie-tcba */
    { .label = {  47035, 12, 0 } }, /* laakesvuemie */
    { .label = {  92381,  9, 0 } }, /* nannestad */
    { .label = { 152310,  6, 0 } }, /* narvik */
    { .label = { 112826,  8, 0 } }, /* narviika */
    { .label = { 112859,  8, 0 } }, /* naustdal */
    { .label = {  59319, 11, 0 } }, /* nedre-eiker */
    { .label = { 112892,  8, 1 } }, { .child = { 7976, 1 } }, /* akershus */
    { .label = { 112926,  8, 1 } }, { .child = { 7977, 1 } }, /* buskerud */
    { .label = { 112814,  5, 0 } }, /* nesna */
    { .label = { 112964,  8, 0 } }, /* nesodden */
    { .label = { 132094,  7, 0 } }, /* nesseby */
    { .label = { 132126,  7, 0 } }, /* unjarga */
    { .label = {  28700, 14, 0 } }, /* xn--unjrga-rta */
    { .label = { 152336,  6, 0 } }, /* nesset */
    { .label = { 112998,  8, 0 } }, /* nissedal */
    { .label = { 113031,  8, 0 } }, /* nittedal */
    { .label = {  59366, 11, 0 } }, /* nord-aurdal */
    { .label = {  92416,  9, 0 } }, /* nord-fron */
    { .label = {  92456,  9, 0 } }, /* nord-odal */
    { .label = { 132157,  7, 0 } }, /* norddal */
    { .label = { 113064,  8, 0 } }, /* nordkapp */
    { .label = {  59413, 11, 0 } }, /* davvenjarga */
    { .label = {   9578, 18, 0 } }, /* xn--davvenjrga-y4a */
    { .label = {  59463, 11, 0 } }, /* nordre-land */
    { .label = {  92495,  9, 0 } }, /* nordreisa */
    { .label = { 164107,  5, 0 } }, /* raisa */
    { .label = {  47087, 12, 0 } }, /* xn--risa-5na */
    { .label = {  36993, 13, 0 } }, /* nore-og-uvdal */
    { .label = { 113101,  8, 0 } }, /* notodden */
    { .label = { 164125,  5, 0 } }, /* naroy */
    { .label = {  37052, 13, 0 } }, /* xn--nry-yla5g */
    { .label = { 113135,  8, 0 } }, /* notteroy */
    { .label = {  21898, 15, 0 } }, /* xn--nttery-byae */
    { .label = {  26116,  4, 0 } }, /* odda */
    { .label = { 152360,  6, 0 } }, /* oksnes */
    { .label = {  37119, 13, 0 } }, /* xn--ksnes-uua */
    { .label = { 152385,  6, 0 } }, /* oppdal */
    { .label = { 113169,  8, 0 } }, /* oppegard */
    { .label = {  21968, 15, 0 } }, /* xn--oppegrd-ixa */
    { .label = { 152414,  6, 0 } }, /* orkdal */
    { .label = { 130832,  6, 0 } }, /* orland */
    { .label = {  37178, 13, 0 } }, /* xn--rland-uua */
    { .label = {   3649,  6, 0 } }, /* orskog */
    { .label = {  37237, 13, 0 } }, /* xn--rskog-uua */
    { .label = { 164146,  5, 0 } }, /* orsta */
    { .label = {  47143, 12, 0 } }, /* xn--rsta-fra */
    { .label = { 132187,  7, 1 } }, { .child = { 7978, 3 } }, /* hedmark */
    { .label = {  92531,  9, 1 } }, { .child = { 7981, 1 } }, /* hordaland */
    { .label = { 110587,  4, 0 } }, /* osen */
    { .label = { 132218,  7, 0 } }, /* osteroy */
    { .label = {  28764, 14, 0 } }, /* xn--ostery-fya */
    { .label = {  59510, 11, 0 } }, /* ostre-toten */
    { .label = {   9668, 18, 0 } }, /* xn--stre-toten-zcb */
    { .label = {  92569,  9, 0 } }, /* overhalla */
    { .label = {  75255, 10, 0 } }, /* ovre-eiker */
    { .label = {  11830, 17, 0 } }, /* xn--vre-eiker-k8a */
    { .label = { 170075,  4, 0 } }, /* oyer */
    { .label = {  59555, 11, 0 } }, /* xn--yer-zna */
    { .label = { 113206,  8, 0 } }, /* oygarden */
    { .label = {  22040, 15, 0 } }, /* xn--ygarden-p1a */
    { .label = {  37297, 13, 0 } }, /* oystre-slidre */
    { .label = {   4568, 20, 0 } }, /* xn--ystre-slidre-ujb */
    { .label = {  92608,  9, 0 } }, /* porsanger */
    { .label = { 113241,  8, 0 } }, /* porsangu */
    { .label = {  11912, 17, 0 } }, /* xn--porsgu-sta26f */
    { .label = {  92646,  9, 0 } }, /* porsgrunn */
    { .label = { 164165,  5, 0 } }, /* radoy */
    { .label = {  47196, 12, 0 } }, /* xn--rady-ira */
    { .label = {  92686,  9, 0 } }, /* rakkestad */
    { .label = {  70739,  4, 0 } }, /* rana */
    { .label = { 152440,  6, 0 } }, /* ruovat */
    { .label = {  92723,  9, 0 } }, /* randaberg */
    { .label = { 161054,  5, 0 } }, /* rauma */
    { .label = { 113276,  8, 0 } }, /* rendalen */
    { .label = { 132248,  7, 0 } }, /* rennebu */
    { .label = { 113309,  8, 0 } }, /* rennesoy */
    { .label = {  22113, 15, 0 } }, /* xn--rennesy-v1a */
    { .label = { 152466,  6, 0 } }, /* rindal */
    { .label = { 132279,  7, 0 } }, /* ringebu */
    { .label = {  92761,  9, 0 } }, /* ringerike */
    { .label = {  92799,  9, 0 } }, /* ringsaker */
    { .label = { 164187,  5, 0 } }, /* rissa */
    { .label = { 164206,  5, 0 } }, /* risor */
    { .label = {  47250, 12, 0 } }, /* xn--risr-ira */
    { .label = {   2711,  4, 0 } }, /* roan */
    { .label = { 152491,  6, 0 } }, /* rollag */
    { .label = { 164226,  5, 0 } }, /* rygge */
    { .label = { 113343,  8, 0 } }, /* ralingen */
    { .label = {  22185, 15, 0 } }, /* xn--rlingen-mxa */
    { .label = { 164250,  5, 0 } }, /* rodoy */
    { .label = {  47302, 12, 0 } }, /* xn--rdy-0nab */
    { .label = { 132311,  7, 0 } }, /* romskog */
    { .label = {  28830, 14, 0 } }, /* xn--rmskog-bya */
    { .label = { 164273,  5, 0 } }, /* roros */
    { .label = {  47363, 12, 0 } }, /* xn--rros-gra */
    { .label = {  93414,  4, 0 } }, /* rost */
    { .label = {  59608, 11, 0 } }, /* xn--rst-0na */
    { .label = { 152517,  6, 0 } }, /* royken */
    { .label = {  37354, 13, 0 } }, /* xn--ryken-vua */
    { .label = { 132342,  7, 0 } }, /* royrvik */
    { .label = {  28897, 14, 0 } }, /* xn--ryrvik-bya */
    { .label = {  40691,  4, 0 } }, /* rade */
    { .label = {  59660, 11, 0 } }, /* xn--rde-ula */
    { .label = { 113376,  8, 0 } }, /* salangen */
    { .label = { 132375,  7, 0 } }, /* siellak */
    { .label = { 132405,  7, 0 } }, /* saltdal */
    { .label = { 116066,  5, 0 } }, /* salat */
    { .label = {  47416, 12, 0 } }, /* xn--slt-elab */
    { .label = {  47472, 12, 0 } }, /* xn--slat-5na */
    { .label = {  92836,  9, 0 } }, /* samnanger */
    { .label = { 113408,  8, 1 } }, { .child = { 7982, 1 } }, /* vestfold */
    { .label = {  75299, 10, 0 } }, /* sandefjord */
    { .label = {   6885,  7, 0 } }, /* sandnes */
    { .label = { 152544,  6, 0 } }, /* sandoy */
    { .label = {  37416, 13, 0 } }, /* xn--sandy-yua */
    { .label = {  92872,  9, 0 } }, /* sarpsborg */
    { .label = { 160725,  5, 0 } }, /* sauda */
    { .label = { 113446,  8, 0 } }, /* sauherad */
    { .label = {  28602,  3, 0 } }, /* sel */
    { .label = { 164293,  5, 0 } }, /* selbu */
    { .label = { 164317,  5, 0 } }, /* selje */
    { .label = { 132434,  7, 0 } }, /* seljord */
    { .label = { 152570,  6, 0 } }, /* sigdal */
    { .label = { 152596,  6, 0 } }, /* siljan */
    { .label = { 152623,  6, 0 } }, /* sirdal */
    { .label = { 164341,  5, 0 } }, /* skaun */
    { .label = {  35803,  7, 0 } }, /* skedsmo */
    { .label = {   6533,  3, 0 } }, /* ski */
    { .label = { 116382,  5, 0 } }, /* skien */
    { .label = { 113479,  8, 0 } }, /* skiptvet */
    { .label = { 113516,  8, 0 } }, /* skjervoy */
    { .label = {  22254, 15, 0 } }, /* xn--skjervy-v1a */
    { .label = { 132467,  7, 0 } }, /* skierva */
    { .label = {  28966, 14, 0 } }, /* xn--skierv-uta */
    { .label = { 164362,  5, 0 } }, /* skjak */
    { .label = {  47529, 12, 0 } }, /* xn--skjk-soa */
    { .label = { 152648,  6, 0 } }, /* skodje */
    { .label = { 113556,  8, 0 } }, /* skanland */
    { .label = {  22332, 15, 0 } }, /* xn--sknland-fxa */
    { .label = { 152677,  6, 0 } }, /* skanit */
    { .label = {  37477, 13, 0 } }, /* xn--sknit-yqa */
    { .label = { 164386,  5, 0 } }, /* smola */
    { .label = {  47586, 12, 0 } }, /* xn--smla-hra */
    { .label = {  75345, 10, 0 } }, /* snillfjord */
    { .label = { 164407,  5, 0 } }, /* snasa */
    { .label = {  47640, 12, 0 } }, /* xn--snsa-roa */
    { .label = { 152701,  6, 0 } }, /* snoasa */
    { .label = { 152723,  6, 0 } }, /* snaase */
    { .label = {  37540, 13, 0 } }, /* xn--snase-nra */
    { .label = { 132497,  7, 0 } }, /* sogndal */
    { .label = { 132527,  7, 0 } }, /* sokndal */
    { .label = {  61812,  4, 0 } }, /* sola */
    { .label = { 152745,  6, 0 } }, /* solund */
    { .label = {  92912,  9, 0 } }, /* songdalen */
    { .label = { 113589,  8, 0 } }, /* sortland */
    { .label = {  92950,  9, 0 } }, /* spydeberg */
    { .label = { 152772,  6, 0 } }, /* stange */
    { .label = {  92994,  9, 0 } }, /* stavanger */
    { .label = { 132557,  7, 0 } }, /* steigen */
    { .label = {  93031,  9, 0 } }, /* steinkjer */
    { .label = {  21183,  8, 0 } }, /* stjordal */
    { .label = {  22402, 15, 0 } }, /* xn--stjrdal-s1a */
    { .label = { 152796,  6, 0 } }, /* stokke */
    { .label = {  59711, 11, 0 } }, /* stor-elvdal */
    { .label = { 132586,  5, 0 } }, /* stord */
    { .label = { 132586,  7, 0 } }, /* stordal */
    { .label = {  93071,  9, 0 } }, /* storfjord */
    { .label = {  75393, 10, 0 } }, /* omasvuotna */
    { .label = {  59050,  6, 0 } }, /* strand */
    { .label = { 132615,  7, 0 } }, /* stranda */
    { .label = { 164425,  5, 0 } }, /* stryn */
    { .label = {  94092,  4, 0 } }, /* sula */
    { .label = { 152822,  6, 0 } }, /* suldal */
    { .label = {   9086,  4, 0 } }, /* sund */
    { .label = { 132642,  7, 0 } }, /* sunndal */
    { .label = { 113622,  8, 0 } }, /* surnadal */
    { .label = { 164447,  5, 0 } }, /* sveio */
    { .label = { 132672,  7, 0 } }, /* svelvik */
    { .label = {  93113,  9, 0 } }, /* sykkylven */
    { .label = { 164469,  5, 0 } }, /* sogne */
    { .label = {  47691, 12, 0 } }, /* xn--sgne-gra */
    { .label = { 164490,  5, 0 } }, /* somna */
    { .label = {  47745, 12, 0 } }, /* xn--smna-gra */
    { .label = {  59760, 11, 0 } }, /* sondre-land */
    { .label = {   9752, 18, 0 } }, /* xn--sndre-land-0cb */
    { .label = {  75435, 10, 0 } }, /* sor-aurdal */
    { .label = {  11999, 17, 0 } }, /* xn--sr-aurdal-l8a */
    { .label = { 113655,  8, 0 } }, /* sor-fron */
    { .label = {  22474, 15, 0 } }, /* xn--sr-fron-q1a */
    { .label = { 113690,  8, 0 } }, /* sor-odal */
    { .label = {  22549, 15, 0 } }, /* xn--sr-odal-q1a */
    { .label = {  47798, 12, 0 } }, /* sor-varanger */
    { .label = {   7439, 19, 0 } }, /* xn--sr-varanger-ggb */
    { .label = {  37595, 13, 0 } }, /* matta-varjjat */
    { .label = {   4664, 20, 0 } }, /* xn--mtta-vrjjat-k7af */
    { .label = { 132706,  7, 0 } }, /* sorfold */
    { .label = {  29030, 14, 0 } }, /* xn--srfold-bya */
    { .label = { 113724,  8, 0 } }, /* sorreisa */
    { .label = {  22623, 15, 0 } }, /* xn--srreisa-q1a */
    { .label = { 164510,  5, 0 } }, /* sorum */
    { .label = {  47848, 12, 0 } }, /* xn--srum-gra */
    { .label = {   6398,  4, 0 } }, /* tana */
    { .label = { 152849,  6, 0 } }, /* deatnu */
    { .label = {  58423,  4, 0 } }, /* time */
    { .label = { 113755,  8, 0 } }, /* tingvoll */
    { .label = { 137309,  4, 0 } }, /* tinn */
    { .label = {  93158,  9, 0 } }, /* tjeldsund */
    { .label = {  37653, 13, 0 } }, /* dielddanuorri */
    { .label = { 164532,  5, 0 } }, /* tjome */
    { .label = {  47903, 12, 0 } }, /* xn--tjme-hra */
    { .label = { 152800,  5, 0 } }, /* tokke */
    { .label = { 102215,  5, 0 } }, /* tolga */
    { .label = { 132738,  7, 0 } }, /* torsken */
    { .label = { 152874,  6, 0 } }, /* tranoy */
    { .label = {  37709, 13, 0 } }, /* xn--trany-yua */
    { .label = { 152899,  6, 0 } }, /* tromso */
    { .label = {  37769, 13, 0 } }, /* xn--troms-zua */
    { .label = { 152924,  6, 0 } }, /* tromsa */
    { .label = { 152928,  5, 0 } }, /* romsa */
    { .label = {  93201,  9, 0 } }, /* trondheim */
    { .label = { 113792,  8, 0 } }, /* troandin */
    { .label = { 152948,  6, 0 } }, /* trysil */
    { .label = { 164556,  5, 0 } }, /* trana */
    { .label = {  47960, 12, 0 } }, /* xn--trna-woa */
    { .label = { 113824,  8, 0 } }, /* trogstad */
    { .label = {  22694, 15, 0 } }, /* xn--trgstad-r1a */
    { .label = {  59807, 11, 0 } }, /* tvedestrand */
    { .label = { 149918,  5, 0 } }, /* tydal */
    { .label = { 152975,  6, 0 } }, /* tynset */
    { .label = { 113857,  8, 0 } }, /* tysfjord */
    { .label = {  48013, 12, 0 } }, /* divtasvuodna */
    { .label = {  37830, 13, 0 } }, /* divttasvuotna */
    { .label = { 153001,  6, 0 } }, /* tysnes */
    { .label = { 153027,  6, 0 } }, /* tysvar */
    { .label = {  37886, 13, 0 } }, /* xn--tysvr-vra */
    { .label = { 113897,  8, 0 } }, /* tonsberg */
    { .label = {  22763, 15, 0 } }, /* xn--tnsberg-q1a */
    { .label = {  75477, 10, 0 } }, /* ullensaker */
    { .label = {  75520, 10, 0 } }, /* ullensvang */
    { .label = {  74575,  5, 0 } }, /* ulvik */
    { .label = { 153054,  6, 0 } }, /* utsira */
    { .label = { 164574,  5, 0 } }, /* vadso */
    { .label = {  48066, 12, 0 } }, /* xn--vads-jra */
    { .label = {  75565, 10, 0 } }, /* cahcesuolo */
    { .label = {   7526, 19, 0 } }, /* xn--hcesuolo-7ya35b */
    { .label = { 132767,  7, 0 } }, /* vaksdal */
    { .label = {   2925,  5, 0 } }, /* valle */
    { .label = {  58643,  4, 0 } }, /* vang */
    { .label = { 113932,  8, 0 } }, /* vanylven */
    { .label = { 164596,  5, 0 } }, /* vardo */
    { .label = {  48123, 12, 0 } }, /* xn--vard-jra */
    { .label = { 132798,  7, 0 } }, /* varggat */
    { .label = {  29098, 14, 0 } }, /* xn--vrggt-xqad */
    { .label = { 164618,  5, 0 } }, /* vefsn */
    { .label = { 132828,  7, 0 } }, /* vaapste */
    { .label = {  93240,  4, 0 } }, /* vega */
    { .label = {  93240,  9, 0 } }, /* vegarshei */
    { .label = {  16446, 16, 0 } }, /* xn--vegrshei-c0a */
    { .label = { 113970,  8, 0 } }, /* vennesla */
    { .label = { 153078,  6, 0 } }, /* verdal */
    { .label = { 153105,  6, 0 } }, /* verran */
    { .label = { 153130,  6, 0 } }, /* vestby */
    { .label = { 132858,  7, 0 } }, /* vestnes */
    { .label = {  37948, 13, 0 } }, /* vestre-slidre */
    { .label = {  48180, 12, 0 } }, /* vestre-toten */
    { .label = {  93279,  9, 0 } }, /* vestvagoy */
    { .label = {  12079, 17, 0 } }, /* xn--vestvgy-ixa6o */
    { .label = {  93321,  9, 0 } }, /* vevelstad */
    { .label = {  23447,  3, 0 } }, /* vik */
    { .label = { 164642,  5, 0 } }, /* vikna */
    { .label = {  75609, 10, 0 } }, /* vindafjord */
    { .label = { 164664,  5, 0 } }, /* volda */
    { .label = {  58621,  4, 0 } }, /* voss */
    { .label = { 164687,  5, 0 } }, /* varoy */
    { .label = {  38005, 13, 0 } }, /* xn--vry-yla5g */
    { .label = { 164710,  5, 0 } }, /* vagan */
    { .label = {  48231, 12, 0 } }, /* xn--vgan-qoa */
    { .label = { 153160,  6, 0 } }, /* voagat */
    { .label = { 153185,  6, 0 } }, /* vagsoy */
    { .label = {  29169, 14, 0 } }, /* xn--vgsy-qoa0j */
    { .label = { 108547,  4, 0 } }, /* vaga */
    { .label = {  59854, 11, 0 } }, /* xn--vg-yiab */
    { .label = { 132888,  7, 1 } }, { .child = { 7983, 1 } }, /* ostfold */
    { .label = {  29245, 14, 1 } }, { .child = { 7984, 1 } }, /* xn--stfold-9xa */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entry 7945 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7946 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7947 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7948 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7949 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7950 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7951 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7952 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7953 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7954 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7955 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7956 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7957 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7958 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7959 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7960 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7961 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7962 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7963 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7964 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7965 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entries 7966 to 7967 */
    { .label = {   2883,  2, 0 } }, /* bo */
    { .label = {  91425,  9, 0 } }, /* xn--b-5ga */

    /* entries 7968 to 7971 */
    { .label = {   2883,  2, 0 } }, /* bo */
    { .label = {  91425,  9, 0 } }, /* xn--b-5ga */
    { .label = { 163803,  5, 0 } }, /* heroy */
    { .label = {  46545, 12, 0 } }, /* xn--hery-ira */

    /* entries 7972 to 7973 */
    { .label = { 163803,  5, 0 } }, /* heroy */
    { .label = {  75299,  5, 0 } }, /* sande */

    /* entries 7974 to 7975 */
    { .label = {  46545, 12, 0 } }, /* xn--hery-ira */
    { .label = {  75299,  5, 0 } }, /* sande */

    /* entry 7976 */
    { .label = {   6901,  3, 0 } }, /* nes */

    /* entry 7977 */
    { .label = {   6901,  3, 0 } }, /* nes */

    /* entries 7978 to 7980 */
    { .label = {     67,  2, 0 } }, /* os */
    { .label = { 151789,  5, 0 } }, /* valer */
    { .label = {  48289, 12, 0 } }, /* xn--vler-qoa */

    /* entry 7981 */
    { .label = {     67,  2, 0 } }, /* os */

    /* entry 7982 */
    { .label = {  75299,  5, 0 } }, /* sande */

    /* entry 7983 */
    { .label = { 151789,  5, 0 } }, /* valer */

    /* entry 7984 */
    { .label = {  48289, 12, 0 } }, /* xn--vler-qoa */

    /* entry 7985 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 7986 to 7992 */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    106,  3, 0 } }, /* com */

    /* entries 7993 to 7998 */
    { .label = { 118347,  8, 0 } }, /* merseine */
    { .label = {  32722,  4, 0 } }, /* mine */
    { .label = { 118563,  8, 0 } }, /* shacknet */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  55252,  3, 0 } }, /* uwu */
    { .label = {  25312, 15, 0 } }, /* enterprisecloud */

    /* entries 7999 to 8016 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 8017, 1 } }, /* co */
    { .label = {   1462,  3, 0 } }, /* cri */
    { .label = {  79824,  4, 0 } }, /* geek */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = { 170093,  4, 0 } }, /* govt */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = {   2052,  3, 0 } }, /* iwi */
    { .label = { 170112,  4, 0 } }, /* kiwi */
    { .label = {  86416,  5, 0 } }, /* maori */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  48348, 12, 0 } }, /* xn--mori-qsa */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  68726, 10, 0 } }, /* parliament */
    { .label = { 121381,  6, 0 } }, /* school */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entry 8017 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 8018 to 8026 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {   4540,  6, 0 } }, /* museum */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  23387,  3, 0 } }, /* pro */

    /* entries 8027 to 8145 */
    { .label = {  78812, 10, 0 } }, /* altervista */
    { .label = { 121330,  5, 1 } }, { .child = { 8146, 1 } }, /* amune */
    { .label = { 117622,  8, 0 } }, /* pimienta */
    { .label = { 137464,  7, 0 } }, /* poivron */
    { .label = { 137496,  7, 0 } }, /* potager */
    { .label = {  64374, 11, 0 } }, /* sweetpepper */
    { .label = {     99,  2, 0 } }, /* ae */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = { 137668,  7, 0 } }, /* certmgr */
    { .label = {  50825,  5, 1 } }, { .child = { 8147, 2 } }, /* cdn77 */
    { .label = {  50825, 12, 1 } }, { .child = { 8149, 1 } }, /* cdn77-secure */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = { 137963,  7, 0 } }, /* duckdns */
    { .label = { 171845,  4, 0 } }, /* tunk */
    { .label = {  31475,  6, 1 } }, { .child = { 8152, 2 } }, /* dyndns */
    { .label = { 137996,  7, 0 } }, /* blogdns */
    { .label = { 117959,  8, 0 } }, /* blogsite */
    { .label = {  10092, 18, 0 } }, /* boldlygoingnowhere */
    { .label = { 118031,  8, 0 } }, /* dnsalias */
    { .label = { 138060,  7, 0 } }, /* dnsdojo */
    { .label = {  65035, 11, 0 } }, /* doesntexist */
    { .label = {  97181,  9, 0 } }, /* dontexist */
    { .label = { 138123,  7, 0 } }, /* doomdns */
    { .label = { 157093,  6, 0 } }, /* dvrdns */
    { .label = { 118063,  8, 0 } }, /* dynalias */
    { .label = {  39753, 13, 0 } }, /* endofinternet */
    { .label = {  17125, 16, 0 } }, /* endoftheinternet */
    { .label = { 138907,  7, 0 } }, /* from-me */
    { .label = {  97301,  9, 0 } }, /* game-host */
    { .label = { 157148,  6, 0 } }, /* gotdns */
    { .label = {  79626, 10, 0 } }, /* hobby-site */
    { .label = { 140004,  7, 0 } }, /* homedns */
    { .label = {  97242,  7, 0 } }, /* homeftp */
    { .label = {  97380,  9, 0 } }, /* homelinux */
    { .label = { 118133,  8, 0 } }, /* homeunix */
    { .label = {  31659, 14, 0 } }, /* is-a-bruinsfan */
    { .label = {  31784, 14, 0 } }, /* is-a-candidate */
    { .label = {  24507, 15, 0 } }, /* is-a-celticsfan */
    { .label = {  97458,  9, 0 } }, /* is-a-chef */
    { .label = {  97499,  9, 0 } }, /* is-a-geek */
    { .label = {  65273, 11, 0 } }, /* is-a-knight */
    { .label = {  24636, 15, 0 } }, /* is-a-linux-user */
    { .label = {  51353, 12, 0 } }, /* is-a-patsfan */
    { .label = {  65419, 11, 0 } }, /* is-a-soxfan */
    { .label = { 118205,  8, 0 } }, /* is-found */
    { .label = { 140095,  7, 0 } }, /* is-lost */
    { .label = { 118242,  8, 0 } }, /* is-saved */
    { .label = {  65608, 11, 0 } }, /* is-very-bad */
    { .label = {  51656, 12, 0 } }, /* is-very-evil */
    { .label = {  51713, 12, 0 } }, /* is-very-good */
    { .label = {  51769, 12, 0 } }, /* is-very-nice */
    { .label = {  40303, 13, 0 } }, /* is-very-sweet */
    { .label = { 118313,  8, 0 } }, /* isa-geek */
    { .label = {  97578,  9, 0 } }, /* kicks-ass */
    { .label = {  65712, 11, 0 } }, /* misconfused */
    { .label = { 140154,  7, 0 } }, /* podzone */
    { .label = {  80068, 10, 0 } }, /* readmyblog */
    { .label = { 157231,  6, 0 } }, /* selfip */
    { .label = {  40538, 13, 0 } }, /* sellsyourhome */
    { .label = { 118487,  8, 0 } }, /* servebbs */
    { .label = { 118525,  8, 0 } }, /* serveftp */
    { .label = {  97699,  9, 0 } }, /* servegame */
    { .label = {  51824, 12, 0 } }, /* stuff-4-sale */
    { .label = { 157260,  6, 0 } }, /* webhop */
    { .label = { 167948,  5, 0 } }, /* ddnss */
    { .label = {  97781,  9, 0 } }, /* accesscam */
    { .label = { 157320,  6, 0 } }, /* camdvr */
    { .label = { 118765,  8, 0 } }, /* freeddns */
    { .label = { 157348,  6, 0 } }, /* mywire */
    { .label = {  65813, 11, 0 } }, /* webredirect */
    { .label = {   2994,  2, 1 } }, { .child = { 8154, 55 } }, /* eu */
    { .label = { 157431,  6, 0 } }, /* twmail */
    { .label = {  17881, 16, 0 } }, /* fedorainfracloud */
    { .label = {  51936, 12, 0 } }, /* fedorapeople */
    { .label = {  40767, 13, 1 } }, { .child = { 8209, 3 } }, /* fedoraproject */
    { .label = {  66405, 11, 0 } }, /* freedesktop */
    { .label = { 119603,  8, 0 } }, /* hepforge */
    { .label = { 157820,  6, 0 } }, /* in-dsl */
    { .label = { 157847,  6, 0 } }, /* in-vpn */
    { .label = {  12224,  2, 0 } }, /* js */
    { .label = { 158046,  6, 0 } }, /* uklugs */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = { 119787,  8, 0 } }, /* mayfirst */
    { .label = {  66846, 11, 0 } }, /* mozilla-iot */
    { .label = {  32517, 14, 0 } }, /* bmoattachments */
    { .label = { 141158,  7, 0 } }, /* dynserv */
    { .label = { 141126,  7, 0 } }, /* now-dns */
    { .label = {  66896, 11, 0 } }, /* cable-modem */
    { .label = {  81014, 10, 0 } }, /* collegefan */
    { .label = {  17952, 16, 0 } }, /* couchpotatofries */
    { .label = { 158231,  6, 0 } }, /* mlbfan */
    { .label = {  18023, 16, 0 } }, /* mysecuritycamera */
    { .label = { 158286,  6, 0 } }, /* nflfan */
    { .label = {  81332, 10, 0 } }, /* read-books */
    { .label = { 158368,  6, 0 } }, /* ufcfan */
    { .label = { 168472,  5, 0 } }, /* hopto */
    { .label = { 168545,  5, 0 } }, /* myftp */
    { .label = { 168522,  5, 0 } }, /* no-ip */
    { .label = { 168425,  5, 0 } }, /* zapto */
    { .label = { 158481,  6, 0 } }, /* pubtls */
    { .label = {  67395, 11, 0 } }, /* my-firewall */
    { .label = {  81827, 10, 0 } }, /* myfirewall */
    { .label = { 168801,  5, 0 } }, /* spdns */
    { .label = { 141506,  7, 0 } }, /* dsmynas */
    { .label = { 120701,  8, 0 } }, /* familyds */
    { .label = { 158785,  6, 0 } }, /* edugit */
    { .label = {  99254,  9, 0 } }, /* tuxfamily */
    { .label = {   5585, 11, 0 } }, /* diskstation */
    { .label = {   4289,  2, 0 } }, /* hk */
    { .label = { 141866,  7, 0 } }, /* wmflabs */
    { .label = {  99380,  9, 0 } }, /* toolforge */
    { .label = { 141901,  7, 0 } }, /* wmcloud */
    { .label = {   2924,  2, 0 } }, /* za */

    /* entry 8146 */
    { .label = {     89,  4, 0 } }, /* tele */

    /* entries 8147 to 8148 */
    { .label = {     19,  1, 0 } }, /* c */
    { .label = {   8717,  3, 0 } }, /* rsc */

    /* entries 8149 to 8150 */
    { .label = { 136382,  6, 1 } }, { .child = { 8151, 1 } }, /* origin */

    /* entry 8151 */
    { .label = {  24388,  3, 0 } }, /* ssl */

    /* entries 8152 to 8153 */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  25036,  4, 0 } }, /* home */

    /* entries 8154 to 8208 */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {    160,  2, 0 } }, /* at */
    { .label = {    117,  2, 0 } }, /* au */
    { .label = {    555,  2, 0 } }, /* be */
    { .label = {   5589,  2, 0 } }, /* bg */
    { .label = {    133,  2, 0 } }, /* ca */
    { .label = {   2713,  2, 0 } }, /* cd */
    { .label = {    190,  2, 0 } }, /* ch */
    { .label = {   2854,  2, 0 } }, /* cn */
    { .label = {    674,  2, 0 } }, /* cy */
    { .label = {   5677,  2, 0 } }, /* cz */
    { .label = {    243,  2, 0 } }, /* de */
    { .label = {   1421,  2, 0 } }, /* dk */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {     98,  2, 0 } }, /* ee */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {    391,  2, 0 } }, /* fi */
    { .label = {    298,  2, 0 } }, /* fr */
    { .label = {   4597,  2, 0 } }, /* gr */
    { .label = {   1659,  2, 0 } }, /* hr */
    { .label = {   1370,  2, 0 } }, /* hu */
    { .label = {    119,  2, 0 } }, /* ie */
    { .label = {    556,  2, 0 } }, /* il */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {    260,  2, 0 } }, /* is */
    { .label = {    151,  2, 0 } }, /* it */
    { .label = {  12841,  2, 0 } }, /* jp */
    { .label = {     43,  2, 0 } }, /* kr */
    { .label = {    695,  2, 0 } }, /* lt */
    { .label = {   2993,  2, 0 } }, /* lu */
    { .label = {   3767,  2, 0 } }, /* lv */
    { .label = {   4288,  2, 0 } }, /* mc */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {    749,  2, 0 } }, /* mk */
    { .label = {    158,  2, 0 } }, /* mt */
    { .label = {   1064,  2, 0 } }, /* my */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    761,  2, 0 } }, /* ng */
    { .label = {   2989,  2, 0 } }, /* nl */
    { .label = {    188,  2, 0 } }, /* no */
    { .label = {   3369,  2, 0 } }, /* nz */
    { .label = { 163055,  5, 0 } }, /* paris */
    { .label = {   2619,  2, 0 } }, /* pl */
    { .label = {   1981,  2, 0 } }, /* pt */
    { .label = { 173190,  3, 0 } }, /* q-a */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {    204,  2, 0 } }, /* ru */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {    699,  2, 0 } }, /* si */
    { .label = {    312,  2, 0 } }, /* sk */
    { .label = {    163,  2, 0 } }, /* tr */
    { .label = {   2514,  2, 0 } }, /* uk */
    { .label = {    296,  2, 0 } }, /* us */

    /* entries 8209 to 8213 */
    { .label = {  13753,  5, 0 } }, /* cloud */
    { .label = {     67,  2, 1 } }, { .child = { 8214, 1 } }, /* os */
    { .label = {   2700,  3, 1 } }, { .child = { 8215, 1 } }, /* stg */

    /* entry 8214 */
    { .label = {   6842,  3, 0 } }, /* app */

    /* entries 8215 to 8216 */
    { .label = {     67,  2, 1 } }, { .child = { 8217, 1 } }, /* os */

    /* entry 8217 */
    { .label = {   6842,  3, 0 } }, /* app */

    /* entries 8218 to 8228 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 109579,  3, 0 } }, /* sld */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  10132,  3, 0 } }, /* ing */
    { .label = {  10089,  3, 0 } }, /* abo */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 8229 to 8237 */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 8238 to 8240 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */

    /* entry 8241 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8242 to 8249 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  10119,  3, 0 } }, /* ngo */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {     27,  1, 0 } }, /* i */

    /* entries 8250 to 8263 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  26115,  3, 0 } }, /* fam */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  43501,  3, 0 } }, /* gok */
    { .label = {   4472,  3, 0 } }, /* gon */
    { .label = {  13209,  3, 0 } }, /* gop */
    { .label = {   9388,  3, 0 } }, /* gos */
    { .label = {  99429,  4, 0 } }, /* info */

    /* entries 8264 to 8436 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4621,  3, 0 } }, /* aid */
    { .label = {  95557,  4, 0 } }, /* agro */
    { .label = {  73945,  3, 0 } }, /* atm */
    { .label = {  72573,  4, 0 } }, /* auto */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = { 164731,  5, 0 } }, /* gmina */
    { .label = { 140810,  3, 0 } }, /* gsm */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  13958,  4, 0 } }, /* mail */
    { .label = { 153213,  6, 0 } }, /* miasta */
    { .label = {  98775,  5, 0 } }, /* media */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  38074, 13, 0 } }, /* nieruchomosci */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   1999,  2, 0 } }, /* pc */
    { .label = { 153236,  6, 0 } }, /* powiat */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = {  75657, 10, 0 } }, /* realestate */
    { .label = {   2926,  3, 0 } }, /* rel */
    { .label = {   6360,  3, 0 } }, /* sex */
    { .label = {  52753,  4, 0 } }, /* shop */
    { .label = { 164752,  5, 0 } }, /* sklep */
    { .label = {  39959,  3, 0 } }, /* sos */
    { .label = { 153263,  6, 0 } }, /* szkola */
    { .label = { 164776,  5, 0 } }, /* targi */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = { 132920,  7, 0 } }, /* tourism */
    { .label = {  10017,  6, 0 } }, /* travel */
    { .label = {  93362,  9, 0 } }, /* turystyka */
    { .label = {   3879,  3, 1 } }, { .child = { 8437, 47 } }, /* gov */
    { .label = { 114038,  8, 0 } }, /* augustow */
    { .label = {  75696, 10, 0 } }, /* babia-gora */
    { .label = { 153324,  6, 0 } }, /* bedzin */
    { .label = { 132950,  7, 0 } }, /* beskidy */
    { .label = {  75739, 10, 0 } }, /* bialowieza */
    { .label = {  93440,  9, 0 } }, /* bialystok */
    { .label = { 132984,  7, 0 } }, /* bielawa */
    { .label = {  75785, 10, 0 } }, /* bieszczady */
    { .label = {  59909, 11, 0 } }, /* boleslawiec */
    { .label = {  93481,  9, 0 } }, /* bydgoszcz */
    { .label = { 164849,  5, 0 } }, /* bytom */
    { .label = { 133015,  7, 0 } }, /* cieszyn */
    { .label = { 133049,  7, 0 } }, /* czeladz */
    { .label = { 164874,  5, 0 } }, /* czest */
    { .label = {  93530,  9, 0 } }, /* dlugoleka */
    { .label = { 153354,  6, 0 } }, /* elblag */
    { .label = {  17029,  3, 0 } }, /* elk */
    { .label = { 153382,  6, 0 } }, /* glogow */
    { .label = { 133085,  7, 0 } }, /* gniezno */
    { .label = { 133117,  7, 0 } }, /* gorlice */
    { .label = { 133148,  7, 0 } }, /* grajewo */
    { .label = { 164898,  5, 0 } }, /* ilawa */
    { .label = { 114074,  8, 0 } }, /* jaworzno */
    { .label = {  48405, 12, 0 } }, /* jelenia-gora */
    { .label = { 164919,  5, 0 } }, /* jgora */
    { .label = { 153411,  6, 0 } }, /* kalisz */
    { .label = {  22838, 15, 0 } }, /* kazimierz-dolny */
    { .label = { 133181,  7, 0 } }, /* karpacz */
    { .label = { 133214,  7, 0 } }, /* kartuzy */
    { .label = { 133248,  7, 0 } }, /* kaszuby */
    { .label = { 114113,  8, 0 } }, /* katowice */
    { .label = { 164942,  5, 0 } }, /* kepno */
    { .label = { 133284,  7, 0 } }, /* ketrzyn */
    { .label = { 133318,  7, 0 } }, /* klodzko */
    { .label = {  75836, 10, 0 } }, /* kobierzyce */
    { .label = {  93571,  9, 0 } }, /* kolobrzeg */
    { .label = { 164965,  5, 0 } }, /* konin */
    { .label = {  75885, 10, 0 } }, /* konskowola */
    { .label = { 164986,  5, 0 } }, /* kutno */
    { .label = { 170345,  4, 0 } }, /* lapy */
    { .label = { 153439,  6, 0 } }, /* lebork */
    { .label = { 133353,  7, 0 } }, /* legnica */
    { .label = { 133383,  7, 0 } }, /* lezajsk */
    { .label = { 114148,  8, 0 } }, /* limanowa */
    { .label = { 165008,  5, 0 } }, /* lomza */
    { .label = { 153467,  6, 0 } }, /* lowicz */
    { .label = { 165032,  5, 0 } }, /* lubin */
    { .label = { 165056,  5, 0 } }, /* lukow */
    { .label = { 133418,  7, 0 } }, /* malbork */
    { .label = {  75929, 10, 0 } }, /* malopolska */
    { .label = { 114182,  8, 0 } }, /* mazowsze */
    { .label = { 153498,  6, 0 } }, /* mazury */
    { .label = { 153528,  6, 0 } }, /* mielec */
    { .label = { 153555,  6, 0 } }, /* mielno */
    { .label = { 133450,  7, 0 } }, /* mragowo */
    { .label = {  71767,  5, 0 } }, /* naklo */
    { .label = { 114222,  8, 0 } }, /* nowaruda */
    { .label = {  46793,  4, 0 } }, /* nysa */
    { .label = { 165081,  5, 0 } }, /* olawa */
    { .label = { 153581,  6, 0 } }, /* olecko */
    { .label = { 153608,  6, 0 } }, /* olkusz */
    { .label = { 133481,  7, 0 } }, /* olsztyn */
    { .label = { 133515,  7, 0 } }, /* opoczno */
    { .label = { 165102,  5, 0 } }, /* opole */
    { .label = { 133549,  7, 0 } }, /* ostroda */
    { .label = {  93615,  9, 0 } }, /* ostroleka */
    { .label = {  93652,  9, 0 } }, /* ostrowiec */
    { .label = {  75973, 10, 0 } }, /* ostrowwlkp */
    { .label = { 170365,  4, 0 } }, /* pila */
    { .label = { 170383,  4, 0 } }, /* pisz */
    { .label = { 133577,  7, 0 } }, /* podhale */
    { .label = { 114256,  8, 0 } }, /* podlasie */
    { .label = {  93691,  9, 0 } }, /* polkowice */
    { .label = { 133609,  7, 0 } }, /* pomorze */
    { .label = {  93734,  9, 0 } }, /* pomorskie */
    { .label = {  76021, 10, 0 } }, /* prochowice */
    { .label = { 114291,  8, 0 } }, /* pruszkow */
    { .label = {  93774,  9, 0 } }, /* przeworsk */
    { .label = { 153638,  6, 0 } }, /* pulawy */
    { .label = { 165125,  5, 0 } }, /* radom */
    { .label = { 114332,  8, 0 } }, /* rawa-maz */
    { .label = { 153669,  6, 0 } }, /* rybnik */
    { .label = { 133643,  7, 0 } }, /* rzeszow */
    { .label = {  87168,  5, 0 } }, /* sanok */
    { .label = { 165146,  5, 0 } }, /* sejny */
    { .label = { 165171,  5, 0 } }, /* slask */
    { .label = { 153698,  6, 0 } }, /* slupsk */
    { .label = {  93818,  9, 0 } }, /* sosnowiec */
    { .label = {  48457, 12, 0 } }, /* stalowa-wola */
    { .label = { 133679,  7, 0 } }, /* skoczow */
    { .label = {  48509, 12, 0 } }, /* starachowice */
    { .label = { 114368,  8, 0 } }, /* stargard */
    { .label = { 133714,  7, 0 } }, /* suwalki */
    { .label = { 114400,  8, 0 } }, /* swidnica */
    { .label = {  76068, 10, 0 } }, /* swiebodzin */
    { .label = {  59959, 11, 0 } }, /* swinoujscie */
    { .label = { 114435,  8, 0 } }, /* szczecin */
    { .label = { 114475,  8, 0 } }, /* szczytno */
    { .label = {  76116, 10, 0 } }, /* tarnobrzeg */
    { .label = { 165192,  5, 0 } }, /* tgory */
    { .label = { 165215,  5, 0 } }, /* turek */
    { .label = { 165237,  5, 0 } }, /* tychy */
    { .label = { 165263,  5, 0 } }, /* ustka */
    { .label = {  93857,  9, 0 } }, /* walbrzych */
    { .label = { 153727,  6, 0 } }, /* warmia */
    { .label = { 114516,  8, 0 } }, /* warszawa */
    { .label = {  19753,  3, 0 } }, /* waw */
    { .label = { 153752,  6, 0 } }, /* wegrow */
    { .label = { 153781,  6, 0 } }, /* wielun */
    { .label = {  93904,  5, 0 } }, /* wlocl */
    { .label = {  93904,  9, 0 } }, /* wloclawek */
    { .label = {  93947,  9, 0 } }, /* wodzislaw */
    { .label = { 133746,  7, 0 } }, /* wolomin */
    { .label = { 133778,  7, 0 } }, /* wroclaw */
    { .label = {  93991,  9, 0 } }, /* zachpomor */
    { .label = { 165284,  5, 0 } }, /* zagan */
    { .label = { 165306,  5, 0 } }, /* zarow */
    { .label = { 165330,  5, 0 } }, /* zgora */
    { .label = {  94034,  9, 0 } }, /* zgorzelec */
    { .label = { 109730,  4, 0 } }, /* beep */
    { .label = { 140937,  7, 0 } }, /* krasnik */
    { .label = { 157989,  6, 0 } }, /* leczna */
    { .label = { 119750,  8, 0 } }, /* lubartow */
    { .label = { 158017,  6, 0 } }, /* lublin */
    { .label = {  98608,  9, 0 } }, /* poniatowa */
    { .label = { 140966,  7, 0 } }, /* swidnik */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   7959,  3, 0 } }, /* art */
    { .label = { 141344,  7, 0 } }, /* gliwice */
    { .label = { 158397,  6, 0 } }, /* krakow */
    { .label = { 158424,  6, 0 } }, /* poznan */
    { .label = { 133778,  4, 0 } }, /* wroc */
    { .label = { 120235,  8, 0 } }, /* zakopane */
    { .label = {  24404,  3, 0 } }, /* gda */
    { .label = { 158732,  6, 0 } }, /* gdansk */
    { .label = { 158758,  6, 0 } }, /* gdynia */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = { 168899,  5, 0 } }, /* sopot */

    /* entries 8437 to 8483 */
    { .label = {    321,  2, 0 } }, /* ap */
    { .label = {    129,  2, 0 } }, /* ic */
    { .label = {    260,  2, 0 } }, /* is */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = { 164796,  5, 0 } }, /* kmpsp */
    { .label = { 140738,  5, 0 } }, /* kppsp */
    { .label = { 164822,  5, 0 } }, /* kwpsp */
    { .label = {  57360,  3, 0 } }, /* psp */
    { .label = { 170131,  4, 0 } }, /* wskr */
    { .label = { 100502,  3, 0 } }, /* kwp */
    { .label = {  11687,  2, 0 } }, /* mw */
    { .label = {   2528,  2, 0 } }, /* ug */
    { .label = {    110,  2, 0 } }, /* um */
    { .label = {  56437,  4, 0 } }, /* umig */
    { .label = { 170150,  4, 0 } }, /* ugim */
    { .label = { 170169,  4, 0 } }, /* upow */
    { .label = {    261,  2, 0 } }, /* uw */
    { .label = {  93403,  9, 0 } }, /* starostwo */
    { .label = {    490,  2, 0 } }, /* pa */
    { .label = {     41,  2, 0 } }, /* po */
    { .label = { 170190,  4, 0 } }, /* psse */
    { .label = {  56158,  3, 0 } }, /* pup */
    { .label = { 170208,  4, 0 } }, /* rzgw */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {    131,  2, 0 } }, /* so */
    { .label = {    153,  2, 0 } }, /* sr */
    { .label = {  34945,  3, 0 } }, /* wsa */
    { .label = {   3657,  3, 0 } }, /* sko */
    { .label = {  90364,  3, 0 } }, /* uzs */
    { .label = { 170230,  4, 0 } }, /* wiih */
    { .label = { 149621,  4, 0 } }, /* winb */
    { .label = { 170249,  4, 0 } }, /* pinb */
    { .label = { 170269,  4, 0 } }, /* wios */
    { .label = { 158798,  4, 0 } }, /* witd */
    { .label = { 153291,  6, 0 } }, /* wzmiuw */
    { .label = {  58645,  3, 0 } }, /* piw */
    { .label = { 102728,  3, 0 } }, /* wiw */
    { .label = { 170287,  4, 0 } }, /* griw */
    { .label = {  17575,  3, 0 } }, /* wif */
    { .label = {  66247,  3, 0 } }, /* oum */
    { .label = {   5567,  3, 0 } }, /* sdn */
    { .label = {   9178,  2, 0 } }, /* zp */
    { .label = { 136903,  4, 0 } }, /* uppo */
    { .label = {  20260,  3, 0 } }, /* mup */
    { .label = { 170306,  4, 0 } }, /* wuoz */
    { .label = { 114004,  8, 0 } }, /* konsulat */
    { .label = { 170328,  4, 0 } }, /* oirm */

    /* entry 8484 */
    { .label = {  18243,  3, 0 } }, /* own */

    /* entries 8485 to 8489 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */

    /* entries 8490 to 8502 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  93969,  4, 0 } }, /* isla */
    { .label = {  23387,  3, 0 } }, /* pro */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {    758,  3, 0 } }, /* est */
    { .label = {  53199,  4, 0 } }, /* prof */
    { .label = {    103,  2, 0 } }, /* ac */

    /* entries 8503 to 8517 */
    { .label = {   3681,  3, 0 } }, /* aaa */
    { .label = {    488,  3, 0 } }, /* aca */
    { .label = { 170404,  4, 0 } }, /* acct */
    { .label = { 142547,  6, 0 } }, /* avocat */
    { .label = {   3030,  3, 0 } }, /* bar */
    { .label = {  33306,  3, 0 } }, /* cpa */
    { .label = {   2740,  3, 0 } }, /* eng */
    { .label = { 100161,  3, 0 } }, /* jur */
    { .label = {  20740,  3, 0 } }, /* law */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = { 165353,  5, 0 } }, /* recht */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = { 118714,  8, 1 } }, { .child = { 8518, 1 } }, /* dnstrace */
    { .label = {  66658,  5, 0 } }, /* barsy */

    /* entry 8518 */
    { .label = {  22129,  3, 0 } }, /* bci */

    /* entries 8519 to 8525 */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  18034,  3, 0 } }, /* sec */
    { .label = {  13752,  3, 0 } }, /* plo */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */

    /* entries 8526 to 8535 */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  24732,  4, 0 } }, /* publ */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  26034,  4, 0 } }, /* nome */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 8536 to 8544 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = { 165375,  5, 0 } }, /* belau */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = { 172365,  4, 0 } }, /* x443 */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 8545 to 8551 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  53152,  4, 0 } }, /* coop */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8552 to 8561 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6759,  3, 0 } }, /* sch */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 8562 to 8565 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 8566 to 8579 */
    { .label = {   7959,  4, 0 } }, /* arts */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 116161,  4, 0 } }, /* firm */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13663,  3, 0 } }, /* rec */
    { .label = { 159058,  5, 0 } }, /* store */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = { 158125,  3, 0 } }, /* www */
    { .label = {  52753,  4, 0 } }, /* shop */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 8580 to 8589 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {   1971,  2, 0 } }, /* ua */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   2542,  2, 0 } }, /* ox */

    /* entries 8590 to 8623 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {   3901,  4, 0 } }, /* test */
    { .label = { 140281,  7, 0 } }, /* adygeya */
    { .label = {  97858,  9, 0 } }, /* bashkiria */
    { .label = {  58000,  3, 0 } }, /* bir */
    { .label = {  22653,  3, 0 } }, /* cbg */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 118928,  8, 0 } }, /* dagestan */
    { .label = { 157458,  6, 0 } }, /* grozny */
    { .label = { 118960,  8, 0 } }, /* kalmykia */
    { .label = { 118996,  8, 0 } }, /* kustanai */
    { .label = { 157488,  6, 0 } }, /* marine */
    { .label = { 119028,  8, 0 } }, /* mordovia */
    { .label = {  15483,  3, 0 } }, /* msk */
    { .label = { 168123,  5, 0 } }, /* mytis */
    { .label = { 140313,  7, 0 } }, /* nalchik */
    { .label = {  52899,  3, 0 } }, /* nov */
    { .label = {  80251, 10, 0 } }, /* pyatigorsk */
    { .label = {     52,  3, 0 } }, /* spb */
    { .label = {  65863, 11, 0 } }, /* vladikavkaz */
    { .label = { 119063,  8, 0 } }, /* vladimir */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = { 157876,  6, 1 } }, { .child = { 8624, 4 } }, /* myjino */
    { .label = { 140998,  7, 1 } }, { .child = { 8636, 1 } }, /* cldmail */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6845,  2, 0 } }, /* pp */
    { .label = {   4873,  3, 0 } }, /* ras */

    /* entries 8624 to 8631 */
    { .label = {  24117,  7, 1 } }, { .child = { 8632, 1 } }, /* hosting */
    { .label = { 140875,  7, 1 } }, { .child = { 8633, 1 } }, /* landing */
    { .label = { 119678,  8, 1 } }, { .child = { 8634, 1 } }, /* spectrum */
    { .label = {  32282,  3, 1 } }, { .child = { 8635, 1 } }, /* vps */

    /* entry 8632 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8633 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8634 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8635 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8636 */
    { .label = {     90,  2, 0 } }, /* hb */

    /* entries 8637 to 8643 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  53152,  4, 0 } }, /* coop */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8644 to 8651 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {  10196,  3, 0 } }, /* pub */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   6759,  3, 0 } }, /* sch */

    /* entries 8652 to 8656 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8657 to 8661 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */

    /* entries 8662 to 8669 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   6697,  3, 0 } }, /* med */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */

    /* entries 8670 to 8711 */
    { .label = {     26,  1, 0 } }, /* a */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = {  21343,  2, 0 } }, /* bd */
    { .label = {  15159,  5, 0 } }, /* brand */
    { .label = {     19,  1, 0 } }, /* c */
    { .label = {     30,  1, 0 } }, /* d */
    { .label = {     25,  1, 0 } }, /* e */
    { .label = {     68,  1, 0 } }, /* f */
    { .label = {   4839,  2, 0 } }, /* fh */
    { .label = { 170421,  4, 0 } }, /* fhsk */
    { .label = { 172840,  3, 0 } }, /* fhv */
    { .label = {      9,  1, 0 } }, /* g */
    { .label = {     90,  1, 0 } }, /* h */
    { .label = {     27,  1, 0 } }, /* i */
    { .label = {     24,  1, 0 } }, /* k */
    { .label = { 133811,  7, 0 } }, /* komforb */
    { .label = {  22910, 15, 0 } }, /* kommunalforbund */
    { .label = { 153809,  6, 0 } }, /* komvux */
    { .label = {     79,  1, 0 } }, /* l */
    { .label = { 153840,  6, 0 } }, /* lanbib */
    { .label = {     29,  1, 0 } }, /* m */
    { .label = {     28,  1, 0 } }, /* n */
    { .label = {  29317, 14, 0 } }, /* naturbruksgymn */
    { .label = {     21,  1, 0 } }, /* o */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {     41,  1, 0 } }, /* p */
    { .label = { 165398,  5, 0 } }, /* parti */
    { .label = {   6845,  2, 0 } }, /* pp */
    { .label = {  23342,  5, 0 } }, /* press */
    { .label = {      1,  1, 0 } }, /* r */
    { .label = {      2,  1, 0 } }, /* s */
    { .label = {     10,  1, 0 } }, /* t */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {     46,  1, 0 } }, /* u */
    { .label = {      8,  1, 0 } }, /* w */
    { .label = {     20,  1, 0 } }, /* x */
    { .label = {     38,  1, 0 } }, /* y */
    { .label = {    202,  1, 0 } }, /* z */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  65725,  4, 0 } }, /* conf */

    /* entries 8712 to 8718 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   5481,  3, 0 } }, /* per */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 8719 to 8729 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = { 119568,  8, 0 } }, /* hashbang */
    { .label = {  81600,  8, 1 } }, { .child = { 8730, 1 } }, /* platform */
    { .label = {    540,  3, 0 } }, /* now */
    { .label = { 173279,  3, 0 } }, /* vxl */
    { .label = { 120885,  8, 0 } }, /* wedeploy */

    /* entry 8730 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8731 to 8732 */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 8733 to 8734 */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 8735 to 8739 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8740 to 8747 */
    { .label = {   7959,  3, 0 } }, /* art */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = { 169150,  4, 0 } }, /* gouv */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   5481,  5, 0 } }, /* perso */
    { .label = {  74182,  4, 0 } }, /* univ */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 8748 to 8754 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6759,  3, 0 } }, /* sch */

    /* entries 8755 to 8760 */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8761 to 8774 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  94079,  9, 0 } }, /* consulado */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  94118,  9, 0 } }, /* embaixada */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 114552,  8, 0 } }, /* principe */
    { .label = { 133845,  7, 0 } }, /* saotome */
    { .label = { 159058,  5, 0 } }, /* store */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = { 159012,  4, 0 } }, /* noho */

    /* entries 8775 to 8827 */
    { .label = { 119099,  8, 0 } }, /* abkhazia */
    { .label = { 140281,  7, 0 } }, /* adygeya */
    { .label = {  80296, 10, 0 } }, /* aktyubinsk */
    { .label = {  65915, 11, 0 } }, /* arkhangelsk */
    { .label = { 140344,  7, 0 } }, /* armenia */
    { .label = { 119135,  8, 0 } }, /* ashgabad */
    { .label = {  80342, 10, 0 } }, /* azerbaijan */
    { .label = { 119169,  8, 0 } }, /* balashov */
    { .label = {  97858,  9, 0 } }, /* bashkiria */
    { .label = { 140371,  7, 0 } }, /* bryansk */
    { .label = { 140403,  7, 0 } }, /* bukhara */
    { .label = { 119205,  8, 0 } }, /* chimkent */
    { .label = { 118928,  8, 0 } }, /* dagestan */
    { .label = {  24899, 15, 0 } }, /* east-kazakhstan */
    { .label = { 168146,  5, 0 } }, /* exnet */
    { .label = { 129348,  7, 0 } }, /* georgia */
    { .label = { 157458,  6, 0 } }, /* grozny */
    { .label = { 140434,  7, 0 } }, /* ivanovo */
    { .label = { 157512,  6, 0 } }, /* jambyl */
    { .label = { 118960,  8, 0 } }, /* kalmykia */
    { .label = { 157544,  6, 0 } }, /* kaluga */
    { .label = { 140465,  7, 0 } }, /* karacol */
    { .label = {  97896,  9, 0 } }, /* karaganda */
    { .label = { 140494,  7, 0 } }, /* karelia */
    { .label = {  97931,  9, 0 } }, /* khakassia */
    { .label = {  97967,  9, 0 } }, /* krasnodar */
    { .label = { 157570,  6, 0 } }, /* kurgan */
    { .label = { 118996,  8, 0 } }, /* kustanai */
    { .label = { 168168,  5, 0 } }, /* lenug */
    { .label = {  80387, 10, 0 } }, /* mangyshlak */
    { .label = { 119028,  8, 0 } }, /* mordovia */
    { .label = {  15483,  3, 0 } }, /* msk */
    { .label = { 119241,  8, 0 } }, /* murmansk */
    { .label = { 140313,  7, 0 } }, /* nalchik */
    { .label = { 168191,  5, 0 } }, /* navoi */
    { .label = {  17742, 16, 0 } }, /* north-kazakhstan */
    { .label = {  52899,  3, 0 } }, /* nov */
    { .label = { 140522,  7, 0 } }, /* obninsk */
    { .label = { 100893,  5, 0 } }, /* penza */
    { .label = { 119276,  8, 0 } }, /* pokrovsk */
    { .label = { 168212,  5, 0 } }, /* sochi */
    { .label = {     52,  3, 0 } }, /* spb */
    { .label = { 119314,  8, 0 } }, /* tashkent */
    { .label = { 157596,  6, 0 } }, /* termez */
    { .label = {  98003,  9, 0 } }, /* togliatti */
    { .label = { 140553,  7, 0 } }, /* troitsk */
    { .label = {  65962, 11, 0 } }, /* tselinograd */
    { .label = { 172061,  4, 0 } }, /* tula */
    { .label = { 172078,  4, 0 } }, /* tuva */
    { .label = {  65863, 11, 0 } }, /* vladikavkaz */
    { .label = { 119063,  8, 0 } }, /* vladimir */
    { .label = { 140582,  7, 0 } }, /* vologda */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 8828 to 8832 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   9541,  3, 0 } }, /* red */

    /* entries 8833 to 8834 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entries 8835 to 8840 */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8841 to 8843 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8844 to 8846 */
    { .label = {    190,  2, 0 } }, /* ch */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {    266,  2, 0 } }, /* we */

    /* entry 8847 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 8848 to 8856 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {    290,  2, 0 } }, /* mi */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  66681,  6, 0 } }, /* online */
    { .label = {  52753,  4, 0 } }, /* shop */

    /* entries 8857 to 8872 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    125,  3, 0 } }, /* nic */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3901,  4, 0 } }, /* test */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entry 8873 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 8874 to 8881 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  44279,  3, 0 } }, /* edu */

    /* entries 8882 to 8901 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    226,  3, 0 } }, /* ens */
    { .label = {   3951,  3, 0 } }, /* fin */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   8930,  3, 0 } }, /* ind */
    { .label = {  73892,  4, 0 } }, /* intl */
    { .label = {   4481,  3, 0 } }, /* nat */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {   5481,  5, 0 } }, /* perso */
    { .label = { 132920,  7, 0 } }, /* tourism */
    { .label = { 153868,  6, 0 } }, /* edunet */
    { .label = { 170441,  4, 0 } }, /* rnrt */
    { .label = {  22169,  3, 0 } }, /* rns */
    { .label = {  57374,  3, 0 } }, /* rnu */
    { .label = { 153894,  6, 0 } }, /* mincom */
    { .label = { 133873,  7, 0 } }, /* agrinet */
    { .label = { 133901,  7, 0 } }, /* defense */
    { .label = { 113267,  5, 0 } }, /* turen */

    /* entries 8902 to 8913 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = { 173104,  3, 0 } }, /* 611 */
    { .label = {  15070,  3, 0 } }, /* oya */
    { .label = { 141537,  7, 0 } }, /* vpnplus */
    { .label = {  52853, 12, 1 } }, { .child = { 8914, 1 } }, /* quickconnect */
    { .label = {  92842,  4, 0 } }, /* nyan */

    /* entry 8914 */
    { .label = {  13654,  6, 0 } }, /* direct */

    /* entries 8915 to 8938 */
    { .label = {    586,  2, 0 } }, /* av */
    { .label = {  25420,  3, 0 } }, /* bbs */
    { .label = {   4332,  3, 0 } }, /* bel */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    106,  3, 1 } }, { .child = { 8939, 1 } }, /* com */
    { .label = {   3009,  2, 0 } }, /* dr */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = { 164942,  3, 0 } }, /* kep */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4292,  3, 0 } }, /* pol */
    { .label = {     89,  3, 0 } }, /* tel */
    { .label = {  34752,  3, 0 } }, /* tsk */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {    311,  2, 1 } }, { .child = { 8940, 1 } }, /* nc */

    /* entry 8939 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entry 8940 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 8941 to 8957 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  23387,  3, 0 } }, /* pro */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  53152,  4, 0 } }, /* coop */
    { .label = { 169247,  4, 0 } }, /* jobs */
    { .label = {  10299,  4, 0 } }, /* mobi */
    { .label = {  10017,  6, 0 } }, /* travel */
    { .label = {   4540,  6, 0 } }, /* museum */
    { .label = {  82226,  4, 0 } }, /* aero */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */

    /* entries 8958 to 8961 */
    { .label = {  31475,  6, 0 } }, /* dyndns */
    { .label = {  64988, 11, 0 } }, /* better-than */
    { .label = {  80021, 10, 0 } }, /* on-the-web */
    { .label = {  80162, 10, 0 } }, /* worse-than */

    /* entries 8962 to 8978 */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    106,  3, 1 } }, { .child = { 8979, 1 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  88621,  3, 0 } }, /* idv */
    { .label = {  40282,  4, 0 } }, /* game */
    { .label = { 170457,  4, 0 } }, /* ebiz */
    { .label = {  99476,  4, 0 } }, /* club */
    { .label = {  48560, 12, 0 } }, /* xn--zf0ao64a */
    { .label = {  68987, 10, 0 } }, /* xn--uc0atv */
    { .label = {  60010, 11, 0 } }, /* xn--czrw28b */
    { .label = {   1489,  3, 0 } }, /* url */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  44750,  3, 0 } }, /* nym */

    /* entry 8979 */
    { .label = { 118892,  8, 0 } }, /* mymailer */

    /* entries 8980 to 8991 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  61691,  5, 0 } }, /* hotel */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  10299,  4, 0 } }, /* mobi */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {   1222,  2, 0 } }, /* tv */

    /* entries 8992 to 9074 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  94157,  9, 0 } }, /* cherkassy */
    { .label = { 114589,  8, 0 } }, /* cherkasy */
    { .label = {  94197,  9, 0 } }, /* chernigov */
    { .label = {  94238,  9, 0 } }, /* chernihiv */
    { .label = {  76161, 10, 0 } }, /* chernivtsi */
    { .label = {  76205, 10, 0 } }, /* chernovtsy */
    { .label = {     19,  2, 0 } }, /* ck */
    { .label = {   2854,  2, 0 } }, /* cn */
    { .label = {   1284,  2, 0 } }, /* cr */
    { .label = { 153921,  6, 0 } }, /* crimea */
    { .label = {   4009,  2, 0 } }, /* cv */
    { .label = {    147,  2, 0 } }, /* dn */
    { .label = {  29381, 14, 0 } }, /* dnepropetrovsk */
    { .label = {  29445, 14, 0 } }, /* dnipropetrovsk */
    { .label = { 133932,  7, 0 } }, /* dominic */
    { .label = { 133963,  7, 0 } }, /* donetsk */
    { .label = {   2718,  2, 0 } }, /* dp */
    { .label = {    539,  2, 0 } }, /* if */
    { .label = {  22980, 15, 0 } }, /* ivano-frankivsk */
    { .label = {   8806,  2, 0 } }, /* kh */
    { .label = { 133993,  7, 0 } }, /* kharkiv */
    { .label = { 134025,  7, 0 } }, /* kharkov */
    { .label = { 134057,  7, 0 } }, /* kherson */
    { .label = {  48629, 12, 0 } }, /* khmelnitskiy */
    { .label = {  48684, 12, 0 } }, /* khmelnytskyi */
    { .label = { 170478,  4, 0 } }, /* kiev */
    { .label = {  76251, 10, 0 } }, /* kirovograd */
    { .label = {     24,  2, 0 } }, /* km */
    { .label = {     43,  2, 0 } }, /* kr */
    { .label = { 110408,  4, 0 } }, /* krym */
    { .label = {   2727,  2, 0 } }, /* ks */
    { .label = {    584,  2, 0 } }, /* kv */
    { .label = { 170497,  4, 0 } }, /* kyiv */
    { .label = {   2037,  2, 0 } }, /* lg */
    { .label = {    695,  2, 0 } }, /* lt */
    { .label = { 134087,  7, 0 } }, /* lugansk */
    { .label = { 165419,  5, 0 } }, /* lutsk */
    { .label = {   3767,  2, 0 } }, /* lv */
    { .label = { 170518,  4, 0 } }, /* lviv */
    { .label = {    749,  2, 0 } }, /* mk */
    { .label = { 114625,  8, 0 } }, /* mykolaiv */
    { .label = { 114663,  8, 0 } }, /* nikolaev */
    { .label = {     69,  2, 0 } }, /* od */
    { .label = { 165442,  5, 0 } }, /* odesa */
    { .label = { 153946,  6, 0 } }, /* odessa */
    { .label = {   2619,  2, 0 } }, /* pl */
    { .label = { 134118,  7, 0 } }, /* poltava */
    { .label = { 165462,  5, 0 } }, /* rivne */
    { .label = { 165484,  5, 0 } }, /* rovno */
    { .label = {    637,  2, 0 } }, /* rv */
    { .label = {    424,  2, 0 } }, /* sb */
    { .label = {  76295, 10, 0 } }, /* sebastopol */
    { .label = {  76339, 10, 0 } }, /* sevastopol */
    { .label = {   1519,  2, 0 } }, /* sm */
    { .label = { 168486,  4, 0 } }, /* sumy */
    { .label = {     89,  2, 0 } }, /* te */
    { .label = { 114698,  8, 0 } }, /* ternopil */
    { .label = {   3282,  2, 0 } }, /* uz */
    { .label = { 114733,  8, 0 } }, /* uzhgorod */
    { .label = { 134149,  7, 0 } }, /* vinnica */
    { .label = {  94279,  9, 0 } }, /* vinnytsia */
    { .label = {  11308,  2, 0 } }, /* vn */
    { .label = { 165506,  5, 0 } }, /* volyn */
    { .label = { 165531,  5, 0 } }, /* yalta */
    { .label = {  60075, 11, 0 } }, /* zaporizhzhe */
    { .label = {  48741, 12, 0 } }, /* zaporizhzhia */
    { .label = { 114772,  8, 0 } }, /* zhitomir */
    { .label = { 114809,  8, 0 } }, /* zhytomyr */
    { .label = {   9178,  2, 0 } }, /* zp */
    { .label = {   9204,  2, 0 } }, /* zt */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {   5509,  3, 0 } }, /* inf */
    { .label = {  38987,  3, 0 } }, /* ltd */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   6845,  2, 0 } }, /* pp */
    { .label = {     54,  1, 0 } }, /* v */

    /* entries 9075 to 9084 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 9085 to 9102 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 9103, 8 } }, /* co */
    { .label = {   3879,  3, 1 } }, { .child = { 9114, 2 } }, /* gov */
    { .label = {  38987,  3, 0 } }, /* ltd */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {   3877,  3, 0 } }, /* nhs */
    { .label = {    209,  3, 1 } }, { .child = { 9116, 3 } }, /* org */
    { .label = {   2619,  3, 0 } }, /* plc */
    { .label = { 153970,  6, 0 } }, /* police */
    { .label = {   6759,  3, 1 } }, { .child = { 9119, 1 } }, /* sch */
    { .label = {  52880,  4, 0 } }, /* conn */
    { .label = { 168260,  5, 0 } }, /* copro */
    { .label = {  66658,  5, 0 } }, /* barsy */

    /* entries 9103 to 9111 */
    { .label = { 117656,  8, 1 } }, { .child = { 9112, 2 } }, /* bytemark */
    { .label = { 119494,  8, 0 } }, /* blogspot */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = {  66658, 11, 0 } }, /* barsyonline */
    { .label = { 141063,  7, 0 } }, /* nh-serv */
    { .label = { 168522,  5, 0 } }, /* no-ip */
    { .label = {  41411, 13, 0 } }, /* wellbeingzone */
    { .label = { 141604,  7, 0 } }, /* gwiddle */

    /* entries 9112 to 9113 */
    { .label = {   3248,  2, 0 } }, /* dh */
    { .label = {  17641,  2, 0 } }, /* vm */

    /* entries 9114 to 9115 */
    { .label = {  99632,  7, 0 } }, /* service */
    { .label = {  80479, 10, 0 } }, /* homeoffice */

    /* entries 9116 to 9118 */
    { .label = { 172178,  4, 0 } }, /* glug */
    { .label = {  77401,  3, 0 } }, /* lug */
    { .label = { 158056,  4, 0 } }, /* lugs */

    /* entry 9119 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9120 to 9245 */
    { .label = {  21014,  3, 0 } }, /* dni */
    { .label = {   9539,  3, 0 } }, /* fed */
    { .label = {   9322,  3, 0 } }, /* isa */
    { .label = { 131027,  4, 0 } }, /* kids */
    { .label = {   7121,  3, 0 } }, /* nsn */
    { .label = {    619,  2, 1 } }, { .child = { 9246, 3 } }, /* ak */
    { .label = {     94,  2, 1 } }, { .child = { 9249, 3 } }, /* al */
    { .label = {     45,  2, 1 } }, { .child = { 9252, 3 } }, /* ar */
    { .label = {    128,  2, 1 } }, { .child = { 9255, 3 } }, /* as */
    { .label = {    199,  2, 1 } }, { .child = { 9258, 3 } }, /* az */
    { .label = {    133,  2, 1 } }, { .child = { 9261, 3 } }, /* ca */
    { .label = {     42,  2, 1 } }, { .child = { 9264, 3 } }, /* co */
    { .label = {   1982,  2, 1 } }, { .child = { 9267, 3 } }, /* ct */
    { .label = {   6841,  2, 1 } }, { .child = { 9270, 3 } }, /* dc */
    { .label = {    243,  2, 1 } }, { .child = { 9273, 3 } }, /* de */
    { .label = {    191,  2, 1 } }, { .child = { 9276, 3 } }, /* fl */
    { .label = {    182,  2, 1 } }, { .child = { 9279, 3 } }, /* ga */
    { .label = {   3007,  2, 1 } }, { .child = { 9282, 3 } }, /* gu */
    { .label = {    195,  2, 1 } }, { .child = { 9285, 2 } }, /* hi */
    { .label = {     27,  2, 1 } }, { .child = { 9287, 3 } }, /* ia */
    { .label = {    143,  2, 1 } }, { .child = { 9290, 3 } }, /* id */
    { .label = {    556,  2, 1 } }, { .child = { 9293, 3 } }, /* il */
    { .label = {    100,  2, 1 } }, { .child = { 9296, 3 } }, /* in */
    { .label = {   2727,  2, 1 } }, { .child = { 9299, 3 } }, /* ks */
    { .label = {    494,  2, 1 } }, { .child = { 9302, 3 } }, /* ky */
    { .label = {    557,  2, 1 } }, { .child = { 9305, 3 } }, /* la */
    { .label = {    194,  2, 1 } }, { .child = { 9308, 3 } }, /* ma */
    { .label = {   6836,  2, 1 } }, { .child = { 9315, 3 } }, /* md */
    { .label = {    591,  2, 1 } }, { .child = { 9318, 3 } }, /* me */
    { .label = {    290,  2, 1 } }, { .child = { 9321, 11 } }, /* mi */
    { .label = {    571,  2, 1 } }, { .child = { 9332, 3 } }, /* mn */
    { .label = {   3360,  2, 1 } }, { .child = { 9335, 3 } }, /* mo */
    { .label = {    126,  2, 1 } }, { .child = { 9338, 3 } }, /* ms */
    { .label = {    158,  2, 1 } }, { .child = { 9341, 3 } }, /* mt */
    { .label = {    311,  2, 1 } }, { .child = { 9344, 3 } }, /* nc */
    { .label = {    354,  2, 1 } }, { .child = { 9347, 2 } }, /* nd */
    { .label = {     40,  2, 1 } }, { .child = { 9349, 3 } }, /* ne */
    { .label = {    704,  2, 1 } }, { .child = { 9352, 3 } }, /* nh */
    { .label = {   9622,  2, 1 } }, { .child = { 9355, 3 } }, /* nj */
    { .label = {    201,  2, 1 } }, { .child = { 9358, 3 } }, /* nm */
    { .label = {    152,  2, 1 } }, { .child = { 9361, 3 } }, /* nv */
    { .label = {   3084,  2, 1 } }, { .child = { 9364, 3 } }, /* ny */
    { .label = {   1412,  2, 1 } }, { .child = { 9367, 3 } }, /* oh */
    { .label = {    468,  2, 1 } }, { .child = { 9370, 3 } }, /* ok */
    { .label = {     47,  2, 1 } }, { .child = { 9373, 3 } }, /* or */
    { .label = {    490,  2, 1 } }, { .child = { 9376, 3 } }, /* pa */
    { .label = {   1283,  2, 1 } }, { .child = { 9379, 3 } }, /* pr */
    { .label = {    393,  2, 1 } }, { .child = { 9382, 2 } }, /* ri */
    { .label = {    601,  2, 1 } }, { .child = { 9384, 3 } }, /* sc */
    { .label = {    253,  2, 1 } }, { .child = { 9387, 2 } }, /* sd */
    { .label = {    700,  2, 1 } }, { .child = { 9389, 3 } }, /* tn */
    { .label = {     18,  2, 1 } }, { .child = { 9392, 3 } }, /* tx */
    { .label = {    635,  2, 1 } }, { .child = { 9395, 3 } }, /* ut */
    { .label = {    569,  2, 1 } }, { .child = { 9398, 3 } }, /* vi */
    { .label = {   2412,  2, 1 } }, { .child = { 9401, 3 } }, /* vt */
    { .label = {     54,  2, 1 } }, { .child = { 9404, 3 } }, /* va */
    { .label = {    181,  2, 1 } }, { .child = { 9407, 3 } }, /* wa */
    { .label = {    216,  2, 1 } }, { .child = { 9410, 3 } }, /* wi */
    { .label = {  12111,  2, 1 } }, { .child = { 9413, 1 } }, /* wv */
    { .label = {   5568,  2, 1 } }, { .child = { 9414, 3 } }, /* wy */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = { 171826,  4, 0 } }, /* drud */
    { .label = { 167923,  5, 0 } }, /* is-by */
    { .label = {  65660, 11, 0 } }, /* land-4-sale */
    { .label = {  51824, 12, 0 } }, /* stuff-4-sale */
    { .label = { 140773,  7, 0 } }, /* graphox */
    { .label = { 118765,  8, 0 } }, /* freeddns */
    { .label = { 141223,  7, 0 } }, /* golffan */
    { .label = { 172397,  4, 0 } }, /* noip */
    { .label = { 141286,  7, 0 } }, /* pointto */
    { .label = { 120271,  8, 0 } }, /* platterp */

    /* entries 9246 to 9248 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9249 to 9251 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9252 to 9254 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9255 to 9257 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9258 to 9260 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9261 to 9263 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9264 to 9266 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9267 to 9269 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9270 to 9272 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9273 to 9275 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9276 to 9278 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9279 to 9281 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9282 to 9284 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9285 to 9286 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9287 to 9289 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9290 to 9292 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9293 to 9295 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9296 to 9298 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9299 to 9301 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9302 to 9304 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9305 to 9307 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9308 to 9311 */
    { .label = { 172784,  3, 1 } }, { .child = { 9312, 3 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9312 to 9314 */
    { .label = {  69344,  3, 0 } }, /* pvt */
    { .label = {  10488,  4, 0 } }, /* chtr */
    { .label = { 153998,  6, 0 } }, /* paroch */

    /* entries 9315 to 9317 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9318 to 9320 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9321 to 9331 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */
    { .label = {  94318,  9, 0 } }, /* ann-arbor */
    { .label = {  90518,  3, 0 } }, /* cog */
    { .label = {   7484,  3, 0 } }, /* dst */
    { .label = {  43751,  5, 0 } }, /* eaton */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {   4540,  3, 0 } }, /* mus */
    { .label = {   7221,  3, 0 } }, /* tec */
    { .label = {  94355,  9, 0 } }, /* washtenaw */

    /* entries 9332 to 9334 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9335 to 9337 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9338 to 9340 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9341 to 9343 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9344 to 9346 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9347 to 9348 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9349 to 9351 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9352 to 9354 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9355 to 9357 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9358 to 9360 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9361 to 9363 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9364 to 9366 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9367 to 9369 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9370 to 9372 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9373 to 9375 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9376 to 9378 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9379 to 9381 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9382 to 9383 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9384 to 9386 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9387 to 9388 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9389 to 9391 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9392 to 9394 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9395 to 9397 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9398 to 9400 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9401 to 9403 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9404 to 9406 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9407 to 9409 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9410 to 9412 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entry 9413 */
    { .label = {    466,  2, 0 } }, /* cc */

    /* entries 9414 to 9416 */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17357,  3, 0 } }, /* lib */

    /* entries 9417 to 9424 */
    { .label = {    106,  3, 1 } }, { .child = { 9425, 1 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  35325,  3, 0 } }, /* gub */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entry 9425 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 9426 to 9429 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 9430 to 9439 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   9350,  2, 1 } }, { .child = { 9440, 1 } }, /* gv */
    { .label = {    668,  2, 0 } }, /* 0e */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entry 9440 */
    { .label = {     30,  1, 0 } }, /* d */

    /* entries 9441 to 9457 */
    { .label = {   7959,  4, 0 } }, /* arts */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 172785,  3, 0 } }, /* e12 */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = { 116161,  4, 0 } }, /* firm */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13663,  3, 0 } }, /* rec */
    { .label = { 159058,  5, 0 } }, /* store */
    { .label = {   7221,  3, 0 } }, /* tec */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 9458 to 9459 */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    160,  2, 0 } }, /* at */

    /* entries 9460 to 9464 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 172784,  3, 0 } }, /* k12 */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 9465 to 9477 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4321,  3, 0 } }, /* int */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  30106,  4, 0 } }, /* name */
    { .label = {  23387,  3, 0 } }, /* pro */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 9478 to 9484 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  17228,  4, 0 } }, /* blog */
    { .label = {   9167,  3, 0 } }, /* dev */
    { .label = {    591,  2, 0 } }, /* me */

    /* entries 9485 to 9494 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3989,  7, 1 } }, { .child = { 9495, 1 } }, /* advisor */
    { .label = { 137699,  7, 0 } }, /* cloud66 */
    { .label = {  31475,  6, 0 } }, /* dyndns */
    { .label = { 157202,  6, 0 } }, /* mypets */

    /* entry 9495 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9496 to 9501 */
    { .label = {  68558, 10, 0 } }, /* xn--55qx5d */
    { .label = {  53337, 11, 0 } }, /* xn--wcvs22d */
    { .label = {  68768, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  68824, 10, 0 } }, /* xn--gmqw5a */
    { .label = {  68676, 10, 0 } }, /* xn--od0alg */
    { .label = {  68987, 10, 0 } }, /* xn--uc0atv */

    /* entries 9502 to 9507 */
    { .label = {  94734,  8, 0 } }, /* xn--o1ac */
    { .label = {  94634,  9, 0 } }, /* xn--c1avg */
    { .label = {  94681,  9, 0 } }, /* xn--90azh */
    { .label = { 114974,  8, 0 } }, /* xn--d1at */
    { .label = {  94734,  9, 0 } }, /* xn--o1ach */
    { .label = { 115014,  8, 0 } }, /* xn--80au */

    /* entries 9508 to 9513 */
    { .label = {  38507, 13, 0 } }, /* xn--12c1fe0br */
    { .label = {  16697, 16, 0 } }, /* xn--12co0c3b4eva */
    { .label = {  38584, 13, 0 } }, /* xn--h3cuzk1di */
    { .label = {  60784, 11, 0 } }, /* xn--o3cyx2a */
    { .label = {  49281, 12, 0 } }, /* xn--m3ch0j3a */
    { .label = {  23210, 15, 0 } }, /* xn--12cfi8ixb8l */

    /* entry 9514 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9515 to 9533 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  57417,  5, 0 } }, /* agric */
    { .label = {   1512,  3, 0 } }, /* alt */
    { .label = {     42,  2, 1 } }, { .child = { 9534, 1 } }, /* co */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 134179,  7, 0 } }, /* grondar */
    { .label = {  20740,  3, 0 } }, /* law */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {  10119,  3, 0 } }, /* ngo */
    { .label = {    125,  3, 0 } }, /* nic */
    { .label = {  17398,  3, 0 } }, /* nis */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 121381,  6, 0 } }, /* school */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {    683,  3, 0 } }, /* web */

    /* entry 9534 */
    { .label = { 119494,  8, 0 } }, /* blogspot */

    /* entries 9535 to 9545 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44279,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  99429,  4, 0 } }, /* info */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {  13820,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6759,  3, 0 } }, /* sch */

    /* entries 9546 to 9550 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25516,  3, 0 } }, /* mil */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 9551 */
    { .label = { 121001,  8, 0 } }, /* official */

    /* entries 9552 to 9560 */
    { .label = { 167875,  5, 0 } }, /* wnext */
    { .label = {  32355,  3, 1 } }, { .child = { 9561, 1 } }, /* run */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {  80661,  6, 0 } }, /* hasura */
    { .label = {  98569,  9, 0 } }, /* loginline */
    { .label = { 141030,  7, 0 } }, /* netlify */
    { .label = { 141573,  7, 0 } }, /* telebit */
    { .label = { 100983,  6, 0 } }, /* vercel */

    /* entry 9561 */
    { .label = {     26,  1, 0 } }, /* a */

    /* entry 9562 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 9563 to 9564 */
    { .label = { 145051,  4, 1 } }, { .child = { 9565, 1 } }, /* nabu */

    /* entry 9565 */
    { .label = {   3816,  2, 0 } }, /* ui */

    /* entry 9566 */
    { .label = {    761,  2, 0 } }, /* ng */

    /* entries 9567 to 9582 */
    { .label = {  64426,  6, 1 } }, { .child = { 9583, 1 } }, /* banzai */
    { .label = { 140678,  7, 1 } }, { .child = { 9584, 1 } }, /* statics */
    { .label = {  32393,  8, 0 } }, /* linkyard */
    { .label = {  66754, 11, 1 } }, { .child = { 9585, 1 } }, /* magentosite */
    { .label = {  99052,  9, 0 } }, /* perspecta */
    { .label = {  48742,  5, 0 } }, /* vapor */
    { .label = {  81693, 10, 1 } }, { .child = { 9586, 1 } }, /* on-rancher */
    { .label = {  82048, 10, 1 } }, { .child = { 9587, 1 } }, /* sensiosite */
    { .label = {  67503, 11, 0 } }, /* trafficplex */
    { .label = { 168947,  5, 0 } }, /* urown */
    { .label = {  99339,  9, 0 } }, /* voorloper */

    /* entry 9583 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9584 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9585 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9586 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9587 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9588 to 9590 */
    { .label = { 137772,  7, 0 } }, /* cloudns */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = { 172198,  4, 0 } }, /* pony */

    /* entries 9591 to 9592 */
    { .label = {   4516,  3, 1 } }, { .child = { 9593, 1 } }, /* owo */

    /* entry 9593 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9594 to 9595 */
    { .label = {  98299,  7, 0 } }, /* ravendb */
    { .label = { 141936,  7, 0 } }, /* myforum */

    /* entry 9596 */
    { .label = {    243,  2, 0 } }, /* de */

    /* entry 9597 */
    { .label = { 117568,  3, 0 } }, /* bss */

    /* entries 9598 to 9610 */
    { .label = {  32055,  3, 1 } }, { .child = { 9611, 1 } }, /* lcl */
    { .label = {   2700,  3, 1 } }, { .child = { 9612, 1 } }, /* stg */
    { .label = { 137741,  7, 0 } }, /* workers */
    { .label = { 171787,  4, 0 } }, /* curv */
    { .label = {  51991,  3, 0 } }, /* fly */
    { .label = {  80774,  5, 0 } }, /* iserv */
    { .label = {  98569,  9, 0 } }, /* loginline */
    { .label = {  67196, 11, 0 } }, /* platter-app */
    { .label = { 100983,  6, 0 } }, /* vercel */
    { .label = { 141834,  7, 1 } }, { .child = { 9613, 1 } }, /* webhare */

    /* entry 9611 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9612 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9613 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9614 to 9615 */
    { .label = {  98163,  9, 1 } }, { .child = { 9616, 1 } }, /* cloudapps */

    /* entry 9616 */
    { .label = { 150161,  6, 0 } }, /* london */

    /* entry 9617 */
    { .label = {  98040,  9, 0 } }, /* fastpanel */

    /* entries 9618 to 9619 */
    { .label = {  98182,  5, 1 } }, { .child = { 9620, 2 } }, /* dapps */

    /* entries 9620 to 9622 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 173170,  3, 1 } }, { .child = { 9623, 1 } }, /* bzz */

    /* entry 9623 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9624 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 9625 to 9626 */
    { .label = {  20300,  7, 1 } }, { .child = { 9627, 1 } }, /* compute */

    /* entry 9627 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9628 to 9629 */
    { .label = { 166975,  5, 1 } }, { .child = { 9630, 1 } }, /* party */

    /* entry 9630 */
    { .label = {   4065,  4, 0 } }, /* user */

    /* entry 9631 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entry 9632 */
    { .label = {  66141,  3, 0 } }, /* ybo */

    /* entry 9633 */
    { .label = { 168852,  5, 0 } }, /* storj */

    /* entries 9634 to 9635 */
    { .label = {   5403,  2, 0 } }, /* of */
    { .label = {    121,  2, 0 } }, /* on */

    /* entry 9636 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entry 9637 */
    { .label = { 158597,  6, 0 } }, /* ptplus */

    /* entry 9638 */
    { .label = {   5403,  2, 0 } }, /* of */

    /* entry 9639 */
    { .label = { 171766,  4, 0 } }, /* cnpy */

    /* entry 9640 */
    { .label = {  13753,  5, 0 } }, /* cloud */

    /* entry 9641 */
    { .label = {  96799,  9, 0 } }, /* discourse */

    /* entries 9642 to 9647 */
    { .label = {  64477, 11, 0 } }, /* cloudaccess */
    { .label = { 117744,  8, 0 } }, /* freesite */
    { .label = { 157624,  6, 0 } }, /* myfast */
    { .label = {  32265,  7, 0 } }, /* fastvps */
    { .label = {  13747,  6, 0 } }, /* pcloud */
    { .label = {  41312,  4, 0 } }, /* half */

    /* entry 9648 */
    { .label = {  99012,  9, 0 } }, /* opencraft */

    /* entry 9649 */
    { .label = {    761,  2, 0 } }, /* ng */

    /* entries 9650 to 9651 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  44279,  3, 0 } }, /* edu */

    /* entries 9652 to 9653 */
    { .label = {  39460,  6, 1 } }, { .child = { 9654, 2 } }, /* static */

    /* entries 9654 to 9655 */
    { .label = {   9167,  3, 0 } }, /* dev */
    { .label = {  40522,  5, 0 } }, /* sites */

    /* entries 9656 to 9659 */
    { .label = { 171807,  4, 0 } }, /* cyon */
    { .label = { 168667,  5, 0 } }, /* mypep */
    { .label = {  79171,  4, 1 } }, { .child = { 9660, 1 } }, /* dweb */

    /* entry 9660 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9661 to 9662 */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {   5403,  2, 0 } }, /* of */

    /* entry 9663 */
    { .label = {  99148,  6, 0 } }, /* router */

    /* entry 9664 */
    { .label = {   6417,  3, 0 } }, /* for */

    /* entry 9665 */
    { .label = {  66658,  5, 0 } }, /* barsy */

    /* entries 9666 to 9667 */
    { .label = {    351,  3, 0 } }, /* and */
    { .label = {   6417,  3, 0 } }, /* for */

    /* entries 9668 to 9672 */
    { .label = { 167809,  5, 1 } }, { .child = { 9673, 1 } }, /* alces */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    858,  4, 0 } }, /* arvo */
    { .label = { 141667,  7, 0 } }, /* azimuth */

    /* entry 9673 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9674 to 9677 */
    { .label = { 168074,  5, 1 } }, { .child = { 9678, 1 } }, /* onred */
    { .label = {   6417,  3, 0 } }, /* for */
    { .label = { 121072,  8, 0 } }, /* homelink */

    /* entry 9678 */
    { .label = {  18280,  7, 0 } }, /* staging */

    /* entry 9679 */
    { .label = {  66658,  5, 0 } }, /* barsy */

    /* entry 9680 */
    { .label = { 141191,  7, 0 } }, /* nerdpol */

    /* entries 9681 to 9683 */
    { .label = { 168805,  4, 0 } }, /* pdns */
    { .label = { 168694,  5, 0 } }, /* plesk */
    { .label = { 168774,  5, 0 } }, /* prvcy */

    /* entry 9684 */
    { .label = {  66141,  3, 0 } }, /* ybo */

    /* entry 9685 */
    { .label = { 172549,  4, 0 } }, /* 1337 */

    /* entry 9686 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entry 9687 */
    { .label = { 168970,  5, 0 } }, /* indie */

    /* entry 9688 */
    { .label = {  66658,  5, 0 } }, /* barsy */

    /* entry 9689 */
    { .label = {  66141,  3, 0 } }, /* ybo */

    /* entry 9690 */
    { .label = {  50732,  4, 0 } }, /* clan */

    /* entries 9691 to 9693 */
    { .label = { 157377,  6, 0 } }, /* myddns */
    { .label = {  99213,  9, 0 } }, /* lima-city */
    { .label = { 120739,  8, 0 } }, /* webspace */

    /* entries 9694 to 9697 */
    { .label = {   3881,  2, 0 } }, /* hs */
    { .label = {  66508, 11, 0 } }, /* development */
    { .label = {  98299,  7, 0 } }, /* ravendb */
    { .label = { 172435,  4, 0 } }, /* repl */

    /* entry 9698 */
    { .label = {   6417,  3, 0 } }, /* for */

    /* entry 9699 */
    { .label = {    761,  2, 0 } }, /* ng */

    /* entry 9700 */
    { .label = {  66141,  3, 0 } }, /* ybo */

    /* entry 9701 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entry 9702 */
    { .label = {  98569,  9, 0 } }, /* loginline */

    /* entry 9703 */
    { .label = {  66658,  5, 0 } }, /* barsy */

    /* entries 9704 to 9713 */
    { .label = { 117778,  8, 0 } }, /* cloudera */
    { .label = { 171807,  4, 0 } }, /* cyon */
    { .label = {  32265,  7, 0 } }, /* fastvps */
    { .label = { 168309,  5, 0 } }, /* lelux */
    { .label = {  98569,  9, 0 } }, /* loginline */
    { .label = {  66658,  5, 0 } }, /* barsy */
    { .label = {  81600, 10, 1 } }, { .child = { 9714, 1 } }, /* platformsh */
    { .label = { 172415,  4, 0 } }, /* byen */
    { .label = { 142000,  7, 0 } }, /* mintere */

    /* entry 9714 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9715 to 9718 */
    { .label = { 157624,  6, 0 } }, /* myfast */
    { .label = {  80884, 10, 0 } }, /* linkitools */
    { .label = {  53253,  4, 0 } }, /* uber */
    { .label = { 158980,  6, 0 } }, /* xs4all */

    /* entry 9719 */
    { .label = { 120442,  8, 0 } }, /* shopware */

    /* entry 9720 */
    { .label = {  66658,  5, 0 } }, /* barsy */

    /* entry 9721 */
    { .label = {  66609, 11, 0 } }, /* knightpoint */

    /* entry 9722 */
    { .label = {  96799,  9, 0 } }, /* discourse */

    /* entry 9723 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 9724 to 9725 */
    { .label = { 141126,  7, 0 } }, /* now-dns */
    { .label = { 168402,  5, 0 } }, /* ntdll */

    /* entry 9726 */
    { .label = {  66141,  3, 0 } }, /* ybo */

    /* entries 9727 to 9728 */
    { .label = {   5403,  2, 0 } }, /* of */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entries 9729 to 9734 */
    { .label = { 117959,  8, 0 } }, /* blogsite */
    { .label = { 168234,  5, 0 } }, /* fhapp */
    { .label = { 119898,  8, 0 } }, /* crafting */
    { .label = { 168425,  5, 0 } }, /* zapto */
    { .label = { 141573,  7, 1 } }, { .child = { 9735, 1 } }, /* telebit */

    /* entry 9735 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9736 to 9740 */
    { .label = { 137699,  7, 0 } }, /* cloud66 */
    { .label = {   3881,  2, 0 } }, /* hs */
    { .label = { 157906,  6, 1 } }, { .child = { 9741, 1 } }, /* triton */
    { .label = {  99213,  4, 0 } }, /* lima */

    /* entry 9741 */
    { .label = {      0,  1, 0 } }, /* * */

};

