with Ada.Containers.Indefinite_Vectors;
with Ada.Strings.Fixed;

with Intl;

package Support_Routines is

   package UString_List is new Ada.Containers.Indefinite_Vectors
     (Positive, String);
   package File_Sorting is new UString_List.Generic_Sorting ("<");

   function N (Msg : String) return String renames Intl.Gettext;

   --  Set the major version here.
   Version_Number : constant String := "16";

   --  Translate the format, then replace the major version.
   Version_Format : constant String
     := N ("music123 version %d by David Starner");
   Version_Index : constant Positive := Ada.Strings.Fixed.Index
     (Source  => Version_Format,
      Pattern => "%d");
   Version : constant String := Ada.Strings.Fixed.Replace_Slice
     (Source => Version_Format,
      Low    => Version_Index,
      High   => Version_Index + 1,
      By     => Version_Number);

   Noted_Error : exception;

   --  The Program field contains the command and its options.
   type Tool
     (Program_Length : Natural) is record
      Program        : String (1 .. Program_Length);
      Extension_List : UString_List.Vector;
   end record;

   package Tool_List is new Ada.Containers.Indefinite_Vectors (Positive, Tool);

   procedure Error (Error_String : String);
   procedure Import_Conffile (Program_List : in out Tool_List.Vector);
   procedure Expand_And_Check_Filenames
     (File_List : in out UString_List.Vector;
      Option_Recurse : in Boolean;
      Extension_List : in Tool_List.Vector;
      Option_Ignore_Extension_Case : in Boolean);
   procedure Display_Songs (File_List : in UString_List.Vector);
   procedure Play_Songs
     (File_List : in out UString_List.Vector;
      Program_List : in Tool_List.Vector;
      Delay_Length : in Duration;
      Option_Quiet : in Boolean;
      Option_Loop : in Boolean;
      Option_Random : in Boolean;
      Option_Eternal_Random : in Boolean;
      Option_Ignore_Extension_Case : in Boolean);
   procedure Randomize_Names (File_List : in out UString_List.Vector);
   procedure Read_Playlist (Full_Name : String;
                            File_List : in out UString_List.Vector);
   function Check_Filename (Full_Name : String;
                            Extension_List : Tool_List.Vector;
                            Option_Ignore_Extension_Case : Boolean)
                           return Boolean;

end Support_Routines;
