/*
 * IMultiChartDrawable.java Copyright (C) 2020. Daniel H. Huson
 *
 *  (Some files contain contributions from other authors, who are then mentioned separately.)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package megan.chart;

import java.awt.*;

/**
 * drawers that fulfill this interface can be used in a multi chart drawer
 * Daniel Huson, 4.2015
 */
public interface IMultiChartDrawable extends IChartDrawer {
    void setWidth(int width);

    int getWidth();

    void setHeight(int height);

    int getHeight();

    void setMargins(int leftMargin, int topMargin, int rightMargin, int bottomMargin);

    void setGraphics(Graphics graphics);

    Graphics getGraphics();

    /**
     * copy all user parameters from the given base drawer
     *
     * @param baseDrawer
     */
    void setValues(IMultiChartDrawable baseDrawer);

    /**
     * creates an instance that is then used to draw a particular panel
     *
     * @return instance
     */
    IMultiChartDrawable createInstance();
}
