package org.apache.maven.scm.command.unlock;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.provider.ScmProviderRepository;

import java.io.File;

/**
 * @author <a href="mailto:evenisse@apache.org">Emmanuel Venisse </a>
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @version $Id: AbstractUnlockCommand.java 686197 2008-08-15 12:13:29Z vsiveton $
 */
public abstract class AbstractUnlockCommand
    extends AbstractCommand
{
    protected abstract ScmResult executeUnlockCommand( ScmProviderRepository repository, File workingDirectory )
        throws ScmException;

    public ScmResult executeCommand( ScmProviderRepository repository, File workingDirectory,
                                     CommandParameters parameters )
        throws ScmException
    {
        return executeUnlockCommand( repository, workingDirectory );
    }
}
