
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file TaylorGridAttributes.h
    \\brief Definition of TaylorGrid Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "TaylorGridWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



TaylorGridWrapper::TaylorGridWrapper(): taylorgrid_(new TaylorGrid())


{


	

}
TaylorGridWrapper::TaylorGridWrapper(TaylorGrid* taylorgrid): taylorgrid_(taylorgrid)
{

	
}

TaylorGridWrapper::~TaylorGridWrapper()
{

}

void TaylorGridWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("TAYLOR_LABEL") ) {
		string label_value = request("TAYLOR_LABEL");
		taylorgrid_->label_ = label_value;
		}
	if  (request.countValues("TAYLOR_LABEL_HEIGHT") ) {
		double label_height_value = request("TAYLOR_LABEL_HEIGHT");
		taylorgrid_->label_height_ = label_height_value;
		}
	if  (request.countValues("TAYLOR_PRIMARY_GRID_INCREMENT") ) {
		double primary_increment_value = request("TAYLOR_PRIMARY_GRID_INCREMENT");
		taylorgrid_->primary_increment_ = primary_increment_value;
		}
	if  (request.countValues("TAYLOR_PRIMARY_GRID_LINE_THICKNESS") ) {
		int primary_thickness_value = request("TAYLOR_PRIMARY_GRID_LINE_THICKNESS");
		taylorgrid_->primary_thickness_ = primary_thickness_value;
		}
	if  (request.countValues("TAYLOR_PRIMARY_GRID_REFERENCE") ) {
		double primary_reference_value = request("TAYLOR_PRIMARY_GRID_REFERENCE");
		taylorgrid_->primary_reference_ = primary_reference_value;
		}
	if  (request.countValues("TAYLOR_REFERENCE_LINE_THICKNESS") ) {
		int reference_thickness_value = request("TAYLOR_REFERENCE_LINE_THICKNESS");
		taylorgrid_->reference_thickness_ = reference_thickness_value;
		}
	if  (request.countValues("TAYLOR_PRIMARY_LABEL") ) {
		string primary_label_value = request("TAYLOR_PRIMARY_LABEL");
		
		taylorgrid_->primary_label_ = MagTranslator<string, bool>()(primary_label_value);
		
		}
	if  (request.countValues("TAYLOR_PRIMARY_LABEL_HEIGHT") ) {
		double primary_label_height_value = request("TAYLOR_PRIMARY_LABEL_HEIGHT");
		taylorgrid_->primary_label_height_ = primary_label_height_value;
		}
	if  (request.countValues("TAYLOR_SECONDARY_GRID") ) {
		string secondary_grid_value = request("TAYLOR_SECONDARY_GRID");
		
		taylorgrid_->secondary_grid_ = MagTranslator<string, bool>()(secondary_grid_value);
		
		}
	if  (request.countValues("TAYLOR_SECONDARY_GRID_REFERENCE") ) {
		double secondary_reference_value = request("TAYLOR_SECONDARY_GRID_REFERENCE");
		taylorgrid_->secondary_reference_ = secondary_reference_value;
		}
	if  (request.countValues("TAYLOR_SECONDARY_GRID_INCREMENT") ) {
		double secondary_increment_value = request("TAYLOR_SECONDARY_GRID_INCREMENT");
		taylorgrid_->secondary_increment_ = secondary_increment_value;
		}
	if  (request.countValues("TAYLOR_SECONDARY_GRID_LINE_THICKNESS") ) {
		int secondary_thickness_value = request("TAYLOR_SECONDARY_GRID_LINE_THICKNESS");
		taylorgrid_->secondary_thickness_ = secondary_thickness_value;
		}
	if  (request.countValues("TAYLOR_SECONDARY_LABEL") ) {
		string secondary_label_value = request("TAYLOR_SECONDARY_LABEL");
		
		taylorgrid_->secondary_label_ = MagTranslator<string, bool>()(secondary_label_value);
		
		}
	if  (request.countValues("TAYLOR_SECONDARY_LABEL_HEIGHT") ) {
		double secondary_label_height_value = request("TAYLOR_SECONDARY_LABEL_HEIGHT");
		taylorgrid_->secondary_label_height_ = secondary_label_height_value;
		}
	
	if  (request.countValues("TAYLOR_LABEL_COLOUR") ) {
		string label_colour_value = request("TAYLOR_LABEL_COLOUR");
		taylorgrid_->label_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(label_colour_value));
	}
		
	if  (request.countValues("TAYLOR_PRIMARY_GRID_LINE_COLOUR") ) {
		string primary_colour_value = request("TAYLOR_PRIMARY_GRID_LINE_COLOUR");
		taylorgrid_->primary_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(primary_colour_value));
	}
		
	
	if  (request.countValues("TAYLOR_PRIMARY_GRID_LINE_STYLE") ) {
		string primary_style_value = request("TAYLOR_PRIMARY_GRID_LINE_STYLE");
		taylorgrid_->primary_style_ = MagTranslator<string, LineStyle>()(primary_style_value);
	}
		
	if  (request.countValues("TAYLOR_REFERENCE_LINE_COLOUR") ) {
		string reference_colour_value = request("TAYLOR_REFERENCE_LINE_COLOUR");
		taylorgrid_->reference_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(reference_colour_value));
	}
		
	
	if  (request.countValues("TAYLOR_REFERENCE_LINE_STYLE") ) {
		string reference_style_value = request("TAYLOR_REFERENCE_LINE_STYLE");
		taylorgrid_->reference_style_ = MagTranslator<string, LineStyle>()(reference_style_value);
	}
		
	if  (request.countValues("TAYLOR_PRIMARY_LABEL_COLOUR") ) {
		string primary_label_colour_value = request("TAYLOR_PRIMARY_LABEL_COLOUR");
		taylorgrid_->primary_label_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(primary_label_colour_value));
	}
		
	if  (request.countValues("TAYLOR_SECONDARY_GRID_LINE_COLOUR") ) {
		string secondary_colour_value = request("TAYLOR_SECONDARY_GRID_LINE_COLOUR");
		taylorgrid_->secondary_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(secondary_colour_value));
	}
		
	
	if  (request.countValues("TAYLOR_SECONDARY_GRID_LINE_STYLE") ) {
		string secondary_style_value = request("TAYLOR_SECONDARY_GRID_LINE_STYLE");
		taylorgrid_->secondary_style_ = MagTranslator<string, LineStyle>()(secondary_style_value);
	}
		
	if  (request.countValues("TAYLOR_SECONDARY_LABEL_COLOUR") ) {
		string secondary_label_colour_value = request("TAYLOR_SECONDARY_LABEL_COLOUR");
		taylorgrid_->secondary_label_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(secondary_label_colour_value));
	}
		
	
}

void TaylorGridWrapper::print(ostream& out)  const
{
	out << "TaylorGridWrapper[]";
}











