#include "osl/move_generator/legalMoves.h"
#include "osl/container/moveVector.h"
#include "osl/record/csaString.h"
#include "osl/state/numEffectState.h"
#include "osl/state/simpleState.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <boost/foreach.hpp>

class generateLegalMovesTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(generateLegalMovesTest);
  CPPUNIT_TEST(testGenerate);
  CPPUNIT_TEST(testGenerateWithFullUnpromotions);
  CPPUNIT_TEST(testUnique);
  CPPUNIT_TEST_SUITE_END();
 private:
  osl::SimpleState state;
 public:
  generateLegalMovesTest();
  void testGenerate();
  void testGenerateWithFullUnpromotions();
  void testUnique();
};

using namespace osl;

CPPUNIT_TEST_SUITE_REGISTRATION(generateLegalMovesTest);

generateLegalMovesTest::generateLegalMovesTest()
{
  state=CsaString(
"P1-KY *  * -KI *  *  * -KE-KY\n"
"P2 * -OU-GI *  * -HI * -KA * \n"
"P3 *  * -KE-KI-FU *  * -FU * \n"
"P4 * -FU-FU-FU-GI * -FU * -FU\n"
"P5-FU *  *  *  * -FU * +KE * \n"
"P6 *  * +FU * +GI * +FU+FU+FU\n"
"P7+FU+FU+KA+FU+FU *  *  *  * \n"
"P8+KY * +KI+KI *  *  *  *  * \n"
"P9+OU+KE+GI *  * +HI *  * +KY\n"
"P-00FU\n"
"+\n").getInitialState();
}

void generateLegalMovesTest::testGenerate()
{
  MoveVector moves;
  LegalMoves::generate(osl::NumEffectState(state), moves);
  Move m22UM = Move(Square(7,7), Square(2,2), PBISHOP, BISHOP, true,  BLACK);
  Move m22KA = Move(Square(7,7), Square(2,2), BISHOP,  BISHOP, false, BLACK);
  CPPUNIT_ASSERT(moves.isMember(m22UM));
  CPPUNIT_ASSERT(!moves.isMember(m22KA));
}

void generateLegalMovesTest::testGenerateWithFullUnpromotions()
{
  MoveVector moves;
  LegalMoves::generateWithFullUnpromotions(osl::NumEffectState(state), moves);
  Move m22UM = Move(Square(7,7), Square(2,2), PBISHOP, BISHOP, true,  BLACK);
  Move m22KA = Move(Square(7,7), Square(2,2), BISHOP,  BISHOP, false, BLACK);
  CPPUNIT_ASSERT(moves.isMember(m22UM));
  CPPUNIT_ASSERT(moves.isMember(m22KA));
}

void generateLegalMovesTest::testUnique()
{
  NumEffectState state(CsaString(
			 "P1-KY-KE *  *  *  *  *  * -KY\n"
			 "P2 * +HI-GI *  *  * -KI-GI * \n"
			 "P3-FU+TO-OU+FU-FU-FU-KE * -FU\n"
			 "P4 *  *  * -FU *  *  * -FU * \n"
			 "P5 *  *  *  *  *  * -FU *  * \n"
			 "P6 *  *  *  *  * +FU *  * +FU\n"
			 "P7+FU * -TO * +FU * +FU+FU * \n"
			 "P8 * -HI *  *  *  * +GI+OU * \n"
			 "P9+KY+KE * +KI * +KI * +KE+KY\n"
			 "P+00KA\n"
			 "P-00KA00KI00GI00FU00FU\n"
			 "-\n").getInitialState());
  MoveVector moves;
  LegalMoves::generateWithFullUnpromotions(state, moves);
  BOOST_FOREACH(Move move, moves) {
    CPPUNIT_ASSERT_EQUAL(1, std::count(moves.begin(), moves.end(), move));
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
