/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

#ifndef CMPIBROKING_H_
#define CMPIBROKING_H_

#include "Instance.h"

using namespace std;

// CMPI broker utility, enumerate the objectpaths of the instances of the given CIM class (classname parameter)
int CB_enumerateInstanceNames(const CMPIBroker* broker, const CMPIContext* ctx, const string& nameSpace, const string& classname, vector<Objectpath>& objectpaths, string& errorMessage);

// CMPI broker utility, enumerate the instances of the given CIM class (classname parameter)
int CB_enumerateInstances(const CMPIBroker* broker, const CMPIContext* ctx, const string& nameSpace, const string& classname, const char** properties, vector<Instance>& instances, string& errorMessage);

// CMPI broker utility, get the instance corresponding to the given Objectpath (op parameter)
int CB_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, const Objectpath& op, const char** properties, Instance& instance, string& errorMessage);

#endif /*CMPIBROKING_H_*/
