/*
 * @(#)ClassUtilUTest.java      0.9.0 17-APR-2001 - 14:40
 *
 * Copyright (C) 2001,2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * This is the off-line version of the ClassUtil unit tests.
 * As insurance, this tests to make sure that the online test version applet is
 * not in the current classpath.
 *
 * @author  Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version $Date: 2003/02/10 22:52:38 $
 * @since   April 17, 2001 (GroboUtils Alpha 0.9.0)
 */
public class ClassUtilUTest extends TestCase
{
    private static final Class THIS_CLASS = ClassUtilUTest.class;
    
    public ClassUtilUTest( String name )
    {
        super( name );
    }
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }

    
    
    public void testInstantiate1()
    {
        assertNotNull( "Singleton method returned null.",
            ClassUtil.getInstance() );
    }
    
    
    private static final String BELIEF_CLASS = "BeliefOfTheDay";
    
    
    public static class InnerClass
    {
        public InnerClass()
        {
            // do nothing
        }
    }
    
    
    public void testGetClass1()
    {
        ClassUtil util = startTest();
        
        Class c = util.getClass( THIS_CLASS.getName() );
        assertNotNull( "getClass( "+THIS_CLASS.getName()+" ) returned null.",
            c );
        assertEquals( "Did not load the class from the default classloader.",
            THIS_CLASS, c );
    }
    
    
    public void testGetClass2()
    {
        ClassUtil util = startTest();
        
        Class c = util.getClass( BELIEF_CLASS );
        assertEquals(
            "getClass( Belief ) was found in the default classloader.",
            null, c );
    }
    
    
    public void testGetClass3()
    {
        ClassUtil util = startTest();
        
        Class c = util.getClass( THIS_CLASS.getName(), null );
        assertNotNull( "getClass( "+THIS_CLASS.getName()+" ) returned null.",
            c );
        assertEquals( "Did not load the class from the default classloader.",
            THIS_CLASS, c );
    }
    
    
    public void testGetClass4()
    {
        ClassUtil util = startTest();
        
        Class c = util.getClass( BELIEF_CLASS, null );
        assertEquals(
            "getClass( Belief ) was found in the default classloader.",
            null, c );
    }
    
    
    public void testFlush1()
    {
        ClassUtil util = startTest();
        
        // there really isn't a way to test that this works correctly,
        // other than monitoring the GC and memory.
    }
    
    
    public void testCreateObject1()
    {
        ClassUtil util = startTest();
        
        Object o = util.createObject( InnerClass.class.getName() );
        assertNotNull( "getClass( "+InnerClass.class.getName()+
            " ) returned null.",
            o );
        assertEquals( "Did not load the class from the default classloader.",
            InnerClass.class, o.getClass() );
    }
    
    
    public void testCreateObject2()
    {
        ClassUtil util = startTest();
        
        // since this class does not have a default constructor,
        // this must fail
        Object o = util.createObject( THIS_CLASS.getName() );
        assertEquals( "Incorrectly loaded the class which doesn't have a "+
            "default constructor.",
            null, o );
    }
    
    
    public void testCreateObject3()
    {
        ClassUtil util = startTest();
        
        // since ClassUtil cannot have a public constructor, this must fail
        // due to lack-of permissions
        Object o = util.createObject( ClassUtil.class.getName() );
        if (o != null)
        {
            System.out.println("Warning - your JVM allowed the creation of "+
                "an object which has a 'protected' level default constructor.");
        }
        /* see above warning
        assertEquals(
            "createObject( ClassUtil ) did not fail due to invalid access "+
            "permissions.",
            null, o );
        */
    }
    
    
    public void testCreateObject4()
    {
        ClassUtil util = startTest();
        
        Object o = util.createObject( BELIEF_CLASS );
        assertEquals(
            "createObject( "+BELIEF_CLASS+" ) incorrectly found a class.",
            null, o );
    }
    
    
    public void testCreateObject5()
    {
        ClassUtil util = startTest();
        
        Object o = util.createObject( InnerClass.class.getName(), null );
        assertNotNull( "getClass( "+InnerClass.class.getName()+
            " ) returned null.",
            o );
        assertEquals( "Did not load the class from the default classloader.",
            InnerClass.class, o.getClass() );
    }
    
    
    public void testCreateObject6()
    {
        ClassUtil util = startTest();
        
        // since this class does not have a default constructor,
        // this must fail
        Object o = util.createObject( THIS_CLASS.getName(), null );
        assertEquals( "Incorrectly loaded the class which doesn't have a "+
            "default constructor.",
            null, o );
    }
    
    
    
    public void testCreateObject7()
    {
        ClassUtil util = startTest();
        
        assertEquals( "Did not return a null instance with a null class.",
            null, util.createObject( (Class)null ) );
    }
    
    
    public void testCreateObject8()
    {
        ClassUtil util = startTest();
        
        Object o = util.createObject( InnerClass.class );
        assertNotNull( "Returned null from creating a proper class.", o );
        assertEquals( "Did not create a proper class.",
            InnerClass.class,  o.getClass() );
    }
    
    
    public void tsetIsJdk2Compatible1()
    {
        ClassUtil util = startTest();
        
        // don't know how to test this other than what ClassUtil does.
        util.isJdk2Compatible();
    }
    
    //---------------------------------
    
    
    // we must assert that the ClassUtil is fresh to avoid incorrect
    // behavior.
    protected ClassUtil startTest()
    {
        ClassUtil util = ClassUtil.getInstance();
        util.flush();
        return util;
    }
}
