/*
 * @(#)AnalysisModuleSetIO.java
 *
 * Copyright (C) 2002,2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.datastore;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

import net.sourceforge.groboutils.codecoverage.v2.IAnalysisModule;

/**
 * Knows how to read and write an AnalysisModuleSet object.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:26 $
 * @since     December 15, 2002
 */
class AnalysisModuleSetIO
{
    public AnalysisModuleSetIO()
    {
        // do nothing
    }
    
    
    public void writeAnalysisModuleSet( AnalysisModuleSet ams, Writer out )
            throws IOException
    {
        AnalysisModuleIO amw = new AnalysisModuleIO();
        
        StringBuffer sb = new StringBuffer();
        
        int count = ams.getAnalysisModuleCount();
        sb.append( count ).append( '{' );
        for (short i = 0; i < count; ++i)
        {
            StringWriter sw = new StringWriter();
            amw.writeAnalysisModule( ams.getAnalysisModuleAt( i ), sw );
            String text = sw.toString();
            sb.append( '[' ).append( i ).append( ';' ).
                append( text.length() ).append( ';' ).append( text ).
                append( ']' );
        }
        sb.append( '}' );
        
        out.write( sb.toString() );
    }
    
    
    public AnalysisModuleSet readAnalysisModuleSet( Reader in )
            throws IOException
    {
        AnalysisModuleIO amr = new AnalysisModuleIO();
        
        int count = ReadUtil.toInt( ReadUtil.readTo( in, '{' ) );
        AnalysisModuleSet ams = new AnalysisModuleSet();
        for (int i = 0; i < count; ++i)
        {
            ReadUtil.readTo( in, '[' );
            int index = ReadUtil.toInt( ReadUtil.readTo( in, ';' ) );
            if (i != index)
            {
                throw new IOException( "Expected to find index "+i+
                    ", but found "+index+"." );
            }
            int size = ReadUtil.toInt( ReadUtil.readTo( in, ';' ) );
            StringReader sr = new StringReader(
                ReadUtil.readCount( in, size ) );
            IAnalysisModule am = amr.readAnalysisModule( sr );
            ams.addAnalysisModule( am );
            ReadUtil.readTo( in, ']' );
        }
        ReadUtil.readTo( in, '}' );
        
        return ams;
    }
}

