use strict;
use warnings;
use Test::More;
use Crypt::KeyWrap qw(aes_key_wrap aes_key_unwrap);
use Crypt::Misc qw(decode_b64u);

my @tv = (
  {
    C => "cbe70897e1bf88f157234415d69daf078cfa311eae362109",
    D => 0,
    I => 0,
    K => "d95c908e74e5cb172fbb8bfd7fd3480d",
    N => "AES",
    P => "45fd2c9c2044984d002e525cea0c7855",
    X => "AES:0:0:32:0032:0048",
  },
  {
    C => "f3f176f516be33146aa632a4308547170197f6294746a4d19e2a844aeb0213ad",
    D => 0,
    I => 0,
    K => "8d7a8d486899fe16ba9df45fab6bd7fe",
    N => "AES",
    P => "8a9ee446b9fe93fc091b9a250961a7ad184bf9628070ec00",
    X => "AES:0:0:32:0048:0064",
  },
  {
    C => "8ecfc167b2a2b6abf29e25e6f93ab01ad2f18518a3968d4efe64a8b562bb870fb7ab8b0c34b2fe6b",
    D => 0,
    I => 0,
    K => "14483415b4cf128a61e2e2a475600a4f",
    N => "AES",
    P => "f81e36b0cea09672b54d2c38ed8d15352c72a6ca2ea21bd89099b0d2c883b928",
    X => "AES:0:0:32:0064:0080",
  },
  {
    C => "1b56f43cf33fd209424fea01e0dcd8dd88c5cdd81f13e9476bc7912a32e617962f180f382e3b356d6bd957be68722e8f",
    D => 0,
    I => 0,
    K => "6468354d3bb868f43a6dbc12444d4724",
    N => "AES",
    P => "a4bab14e6b830f26d91e3f4d142cbb063b9b218ed43e3b73bb74b3bd20000f43bb6b6cbf847ac2cf",
    X => "AES:0:0:32:0080:0096",
  },
  {
    C => "b02c0144fb2a402af8db8681b0c98e00812ec408b6c12598bf60dfa33bb4578ca3989f67e0f0d1f3df186c870bd99f4bde411a1251a50b9a1c7e8b190626e0aae4ad4a115c38f0b5fff1309ab65017a00b38a3db7bebc409275333123a6fc9f0c1c2cf5b0a86cc8658b69e5f85d7c1e0647a6d2372d2879b33ad722baa4e15c89b9c26ada3a480fffbef3230d3c691bbf18477b1f0b3d64c4687b7f81734c340641a114ee47a5eb9e880ddff622133424b2f5d15cc4240cdfd97bbe25e638717f09b4597b44e132df4aa06ab476dc8e98a3b7df980ab5f532db9df1036a1bef4fdf84314132726353e7f524e6a0a2bdc0f755418d5840a0063fbce6f347885c385c5b7301b47088f69d1b31ff4ad55c5e92c72e230ae10933c2f606d792f2049431d5fa316ab5a8caf689fb49fd9478b91d59c35b7f41fa8dbc95d9b87fafe35a101f8066c5a35af6fdcc93c9edf34642050c6a686207f9f8f3bc7d54107da30a3673973cd7f6077da14868c0b77fc3ddd0882bba5923df9d35bb87895439abea7dff9a6dd44606245f830230879c82fa5e935b9bb8932fab68063299800c8221eccdb4dc27eebc17677e15f0471bbc97392c1ebba987f2b632ce40620e2a964a12875c74d3e5e9d89cf55e4bec3db9c66403f5b685296edcb8247ad94a262c7b4afd584b3e702e407f137ae9a56c87244400f404eb7f424a9322d9ec45ab1a83d1eced31e140e00",
    D => 0,
    I => 0,
    K => "c6554c6e17036b09e0c4b764a772e227",
    N => "AES",
    P => "f2a7b464ed38c259aa9180b8b0b1b3fe7fe854088c71927339065907aab427b58fb192e7abb0427f1edafee621c8b5da132b9e70f48acf818572c172caa50bef468a043012318a94ac861e02b82eb762c9dfae4f3b1dee192fc534ee8f4291a5df982d8929c049036f6047a700e3cf9513fffe17aad829c668ae1d1588b6652296a48613cd27c58635972c144a330f5b2ab40189a572d56126752039275cc00ceffb497b984bf7e3eebf0f04c35f9b335e5e39d390161e17651c77ea798f139bdf6f6af4e77c28b4db0fac96c5a655358b67061486859ccd7ef75faa047692109fd75e667cf4b2335f7e83170334a15f7b5311e9224e99f9d667c02d63b4415b61f86e50997a074673fc69a45f4c874ff4d5bb9180bd1c69bd0faa0398104657558f0c34cda08fcf45eaf7912d69ec230718fa9b4020a0c45720ab83eda46b46784773d8c3bfe07f4727ef9ded8c5dbf8b0482172067cd15463ef74d79d2930ffdfe2ea8642f99f8fbfb9a4e51953b32ad64a0b3694c1e5672ab0a00e811eeead1b3a68d0f7f2021b6fdcb5cc42a8341e2aee90ed2bb1d0f299df97c1f5daa2b2c6638580a273540e96c93d27ca7eb5ac5a644e75c94a164343261a362e61e1f2c4a5c4498bb031f177cece0cea1583fd49092f5151b548b333c2d678e4df3ef34e8ad8311ea786f241f828d28bd208aec12a77b35a8b29542ab65cb398a96db",
    X => "AES:0:0:32:1024:1040",
  },
  {
    C => "a3fa5ab1e13daaee02ef935e054729125195a0dff188ccc6",
    D => 0,
    I => 0,
    K => "cc77273466f04df87c5da005dc25c8d24f7785eadc2fcd83",
    N => "AES",
    P => "daaebc7b7ff1e52796e6fd83552139cf",
    X => "AES:0:0:48:0032:0048",
  },
  {
    C => "4d2454fa47a395ac05305bb1c125892c51aa11d55238b56ead0ab6256b686fe2",
    D => 0,
    I => 0,
    K => "f87e4c4228031f46257ac932d934c19fbf272256877d8000",
    N => "AES",
    P => "086a44b36c80838a6af5e5c627e3ea6dac79ed57918df45f",
    X => "AES:0:0:48:0048:0064",
  },
  {
    C => "70506d87e321d908feede827ef2dfe9274b90c50918ce9c6b156814e1802891ea9246ceaebfd6a03",
    D => 0,
    I => 0,
    K => "991af4832a4677c24b6c55d284fb7451c68eb285f2f30a90",
    N => "AES",
    P => "93e27005847926fe518c794d4e30c34b03720f19b2bf377d6077b2b582a14f4f",
    X => "AES:0:0:48:0064:0080",
  },
  {
    C => "66dd0c30315e9b6718f89ad861b502d0f159d01e20620243666236076756ee93a3c0cb2d068dc66d01c71d1e579a727a",
    D => 0,
    I => 0,
    K => "b1753c2540659ad2e742eaa669d09dd21c1f80d15f214e3c",
    N => "AES",
    P => "a73a3b220299a1ee07fdc2c7a4eecce823e16b039878f729ff200e14037839fe9deb24150028ea09",
    X => "AES:0:0:48:0080:0096",
  },
  {
    C => "6d9c31a29748f5ccb7df3f95978a6eb6c35190cda4a4772e0cc31b84ff973bbfa44619f157bd97835904a655675efa2bb9dd98da1e76d86ecfe0aa0fd5c2ebf2cd13ece9f738c2a48b7703e15e6bd5175862087aa544b7cf8c4775b52561d398afbaff71d2a75c59640e6629fe7528da663058555b0e6064778a7329c418dd921457fd69542e0d73b628ddd8bb9c2fc76b648c3b624929b26898528e0a1cb533744cf60d5cfb2a6292a216747300e6a5a303207d882427e03be9526c395c1cfbf6f70d857203817d4ee3746aaf6044af514dfe985d4a0c84e249f39a0aa6e6a97da1eaaaa6ed2a4f084da72e48ece3521e8f9fa107130f2f9bfd6518035814e42ad491eb7925cebf7edb861654e194c304202e5bbaefaca4179fee6f1e44af60d4b8e4604cd213bafe27fbb1c1cde2b5fc2addfb2b7e01e8b3dabf269bf8d35740b1fcefb0c0e6642b49cd536b3dd3d27ac9b89471507c9fdab0de7ed43200e3145ce670cda12fb4f00046129aaca1ce966976a3c35a61ecd9481d8d4a875638c3790ec25849755fa60f943acf4a6cfd62c7f77df43c73f699d10e147b89b1c285a66820db161ae13d9075e720d8dfa00324087636920f0325f17d3800a24bc6ee0089b8bb56887db051b743cf3a3ce5a689f9f59555e1585dd2fbffa7795e5eba0c518ac29d98738b4b8efdf11f4ed42ba2286a68e294b94e167e0becadc6675ed59a4e25500cc8",
    D => 0,
    I => 0,
    K => "e4f1cdecd977dcad04d93caf433e48269ebe13db2f929232",
    N => "AES",
    P => "1a01853bf2bdffde1aaa86424292907275d547bfe693a3d49f9a582fcb8eb0903e17e55a27fd92f6d6534543fad4cefcdfacb6bce5912453ff4a63cf343810f2f5f8d5cb9580a64eb849bd6e20d9be0c404710379ffa644a7e3ba1004b172768277fa56314912c537079d1fca7c47c8d5be0704b5719485ad6a9bcdcdac9de316c797bcb13861fbebe5101f23c546e5dd358f9f448f23bf08f2c08798f6c4c989d5274ee9ac13a85b8b9621bd201ca2c6cef5f209c111b2e2c3945a3774aca8b6a65f826d3f6a7473f674397fa372ba9b4d46e59a6f6c1f32049bb8cad1ddd8d7c3a2e231b874eae34c0a51dc9d564a546e26ae4b5e809236c91af304b8523176bd4dda38ea646e30e784e2330c5c3d6f282986f0c0d7002903c8f624c9f8febbeddd5360c166cfb0dbae67470dfa9ff104174e15f87d4e33d3a43a29bea0e4b024891f8e28bc89a51c505749a65f1b8561763c67b30f79e27faa7a432405add88c1239862a8fce146740cc800504ce495150dab4c761b0258302579c54e711fec31ec960316010d54120b20d5f21c554c9c81952966a1f12ec61611400c0ad09ec2213e5bd56e3b69e73ac36c1d057356856efbd68ee5b2e11e3a7baaf2494d8e1b8dcdf2a092a1066aa668d435da5db94fb7e82878d4eaa6a2960648cbf37df7a93572167713adbbbb81977e32d02ef7cb8fd64ac4782e0084f7d90c2a0010",
    X => "AES:0:0:48:1024:1040",
  },
  {
    C => "f1733778d27dfe1e57a8822d5f5ae62c2837612a93e21420",
    D => 0,
    I => 0,
    K => "4f43cf947aadc06b375ae3cde537e2ac2cd4b1b499406254cd286d459249e929",
    N => "AES",
    P => "eee8798323b347eb2a06d1e2ae31a7a8",
    X => "AES:0:0:64:0032:0048",
  },
  {
    C => "dbf7b7d96d3f620df3fb2506b080456f1ef9279d9b9dcdc2c99266faa068af8d",
    D => 0,
    I => 0,
    K => "669514545e5c321d6404d69732a3832dc322f96af8ca46ec01e0607e09bf887e",
    N => "AES",
    P => "5f89e8643b2b026dfb680f0f0dd45d5c24f6805d874b1931",
    X => "AES:0:0:64:0048:0064",
  },
  {
    C => "8cd08b63bb1efd7e2aedc28103c42712aa0c0bf00263cc52aef5d2e333822b6e0c9c715f7353d950",
    D => 0,
    I => 0,
    K => "05b97f0fb02539f5841b2d58bff4f1d57fb2fa62821f537c1dc0d921a9475751",
    N => "AES",
    P => "2afe143fc9114897ce6129f2a81685130914b1927d452fe2b96c788da94f77ba",
    X => "AES:0:0:64:0064:0080",
  },
  {
    C => "1d056a9cd9c0ac550f1d060e2bb764b0a3e09c3e8ac35d8aa91601125035a19f7bc503cb2794cc68f16b2afc1f325c31",
    D => 0,
    I => 0,
    K => "6e1aeec3b7cc4d7b4d038038b32f49b464f44ae3a787e53ae69c97d0b61bfd13",
    N => "AES",
    P => "6f8982b37a40559448223c8e31160cb9e0280670808c9b3887323b1c68da20966ee12d05832debed",
    X => "AES:0:0:64:0080:0096",
  },
  {
    C => "c51316caa1a0d5cb5530a28974af76370d7ef6851c04559a11dc584f0796969b1934ce398d56b0e97079b78654a8a5d03ad5eb5d5704bc0c3618c2d422ba8e5ca26e5d973350815498419f53b55f83d5447ec373e1ca8c7415f3c10e419951893aeeb840e8ae4b178a5c911d55710352c3dcc4cb7c5c846cd9e093579abdb1ec83d7c86a5e9c8573deb3f9395c612d562b377363c70bff8663b0fdb574ffb2d32cdda1e1a06af8d2b56b52ce2c2a8dc9a0ab9b16f7553d59bd4b563881e96059e735807b9a668abb8c4bfc1f0f61af25631b6552619394f03ee41dd63db72cf38174b504994395f2c15cf0654071bd3d8a90d8c58c2063fd51986655a01f1744a13f4c2ae7d4af70bb896aae23db0274d580bd358dd034608d26cf798c005282189d9c07b391b9d1a961636f18a7ddb72fabdfb14d871a04ee09bf41c3588fcce16b1f812f864e924a19d415a64b0c29e7e196805abc909db5f6f6b782b5604cb2eb2c8295600670ecd45d1261d0055fe2f468da2240ea27c8648e63dace0ba867115cc72796c4d850e8cc8a2f028e45fe3a49a31a4283638fb5b7d12bb4fa6150986c77fc79fa534f4e3cba65de257dafe8cde538c49f513b34bd20bbc2b77557ef275748dd9cf39b7b1744e9b8751a3578be9e1fe15d6e23909305a69d257cc95be633dc10279d9f4c7cb582003f58749980733f5281b6a3ac01a51f49a201a64087c74b127cc9",
    D => 0,
    I => 0,
    K => "afc8b67cc7582833d4f42e0a74e77a8c51781929ac64cf5863aa6faeff2cf2e8",
    N => "AES",
    P => "3a1f50258a5c39c216183f9543402f49060ad4d4f6dc552a763f0e81527d9d19286aa23f68c5e3046e29d3c8888eceb5f51fd54e7586597d9b4e452885f34bd4d3ed002f11201ed3c7d825c9959c9e0f61302f43ec68c073a67d2850ba1ab96e520940b409489d5a0417555e28a51bb7330947944eea9b4bf03e8db68269e3968e1f7b6085265bbe0fb844e5a39575e51ba52fb8d9cfc8cc64192ccb8d2981495e10aaaa7a12fa205d4efa4601fa129c9f51d8a70acd95992f4006692b60456d067ed8dcae635f9bd123aedd7286a5d4d3fbebad838f7dfb4863ee538d82ac4a0e69ca215e37e0880a1cf35ed9fa2b20fc9b85951ab8ceeab3aaa9345751a7285b8c7b4ce3e820df79583e8822f48c9afde5d53542a9f4c13582028675dc792539a52fff5341a1bcae2bc8d519f625e76f379de922172d2019489995e510cf16e9e9639264e3a6eb0aa5dfcb2f8ce2cdd9ac1ddb0e6e42d971aad170ead96c780e7a75ab064dacc348144ef66fbc72c2326faa20344d7387356e0eb2bbabf1d9a50d69c617fd8d794e687c7c240ed8a08a5be5d2c25f5f3bfd6ed16820f61f6a48e103ef342fdd26e1d433cb3a2aed7098d84e344a1fc591e7955fe39e14b08d4f8b3f0f3003c945f51988082d00b7947fa6da377650f2ec19e4d019ea98671f5c2936762cd01b2d1e782c44f6743d28a2275e6a42c4e1b309be9895160ef9ec",
    X => "AES:0:0:64:1024:1040",
  },
  {
    C => "58b7cf4889a4dc3ca4f8fa63bd3d6754f9e616541db63dc1",
    D => 0,
    I => 1,
    K => "80d7ce2475c6797556ff339d99a0912a",
    N => "AES",
    P => "d0f105beb850d66253b7c668d17c51c5",
    X => "AES:0:1:32:0032:0048",
  },
  {
    C => "91b97497a947a84d49e69e4689556cae7b0d67ed039d7adf4615af58c001d13f",
    D => 0,
    I => 1,
    K => "13f56cc2642f8db2964f257b1a2c3054",
    N => "AES",
    P => "4686ddf7b8b489831692401d7f54e6509502f519060f8dd7",
    X => "AES:0:1:32:0048:0064",
  },
  {
    C => "f3cf8f0747e283bc33b115fe58abf828e90d3171e74f2b23f059f0fc5710ed71435202af9d3f77d9",
    D => 0,
    I => 1,
    K => "fec8932bddb6c45e91195363616c6deb",
    N => "AES",
    P => "648944481258d2b2b509feec6e4526182c1bf6d7b9206412702610df204557ba",
    X => "AES:0:1:32:0064:0080",
  },
  {
    C => "9a79584225b518596b8c47db50399a14ff88d55d61aa586b0ff88ea9c00ed0e2629a81114787c076bf1ae9b0eb179ef6",
    D => 0,
    I => 1,
    K => "e3aa3e958382a4b396cf038727f22b87",
    N => "AES",
    P => "b0b6f3342d2a11243f2e9b72551a68469a33dd0f9fed0d71ca3ab08df5ee20fadbafd65163d0028e",
    X => "AES:0:1:32:0080:0096",
  },
  {
    C => "fce2805f034ad6f6e91e0286577bd5ed1ba579e08c328d7de9e9013d2ddc5109ce3b06bdb7e28d992d8adace8e0a4d5bbf8a1f664bd78262c6d9b78a133a6d384709387c1ea9419b16910e219ee489d74f8cc1c733e27902e2f3f68b6f36a269b957253b042ef00fba2f342ad6a50684646291c212b27e4ede2c75ffa01a147c023d0731e7fe406988f73634947bf35080c8caa8f7c2da5e5276f6434f9e693ff646b2ea16c130097ef0745374568ec805cd04eb6e56bbfe50e1225ced3869ae2cd9bad58818f5afe65850d0b7e7b39d8365d537ac2f48c165c6daae86940665feaeae99ae944cb0ae3221f58a59a613a89395283c531ff1509b0d57223515a0ea2a78bebc4cf8a249a4850d93a87b5fa1b695db3251d2d12f569eee7e9900f629dc43878f921db811ab6319b09d26407b8df0bf981349da746ab2f712350220908d0b2d4ee62c913ddb2098af1fa1f40074a883d0bafbce87fad47c3e0e37e554af29857d79251d91ee6f5b9ffac12f543a248b757f3b99edd1030986dbed8fcec1c7131dc09a324d77e92be7e72989c27612125f0c4a1ab878c387cc7806eac130172b16c55baf43bce18190b830e5d37f9cdf7a6bfa31555f9eed1675fcaacec37341aa073949d9d69a97279646b0988d9bd3ff99162adb4056260a1724a72619e4edcd9182410aedebb31be4b61d0d02005d465f7c865bac306dd0d6f1fc14d9cb320c3615e1",
    D => 0,
    I => 1,
    K => "a468dae7466a4605a18d957f88b29d91",
    N => "AES",
    P => "2301af19cf4b8e6b141d95e258ef2559226e123e75af343617af5d2a6e519e530fad4c62e02b65fe1881f97f2dd32e92bc63556324f62e322c2b19230c803d0cf9689e72daa40d8bc19b20a5986488e06047828d7ef8f94d2832b864abb20e18d661eb0645d22227321faba6bbd3ab2a7c4989613a558a5ed1a4ec70c60448a059d4e7e1149096e694dd22614e548b5da7039785530ffbfbadf650efd47f44cc57dc2af130122fe49fdf2a5ebd13021c4b7e05ea8d8bce229c2ab60b6414b8ac4f553a4662dacb256022bad4a8f72e51a5fe3e1b2de66df51b9e6e6b1b4338edaae992bf162c63c6db78ae2d892db24f812857402660002f48ef123d43063e50c602f2ff91caf4d13d7f10a4e92bb9d9e138a553869a8282f5914503ababa31bb41011f2e7dd9ce332400c4c16913edb13c92b4133204f3b4d7b16c507ec0c2559121ec1da668e485573decaa5014e227084af6eb75ada9b30d33e9420316929751cc2b2d23ce4a93ae59991dff9ac03474e1d74f89c70219e2038da1a67290633fde2f1c0fda31b86d040fc0659b2130ad4f1577a6a1a56f83a7b0eced5c2a362fa78a6875330cd0f92fbb0f6206db556454e9d6d7b89630c174747a83982cdc35dfb292379f50011ef1550d36d37c1a7967f7aa9dfc017f2b46780ac06b0cdc225a760fa99a6e6878ec894b700bd6e9c7b7aa02b4ef28dc888b4115d5fc34f",
    X => "AES:0:1:32:1024:1040",
  },
  {
    C => "efa5fb8f79d28a665c21ff94af6532db58903055c9f35028",
    D => 0,
    I => 1,
    K => "602c451a52920a8b92ceda05db1238f432ea1f763535d949",
    N => "AES",
    P => "aa9c354b11848092201f29117be6f7a6",
    X => "AES:0:1:48:0032:0048",
  },
  {
    C => "8feb6db6b11c31ebb68a5b98267a33e87e02a21ba7459ee6c77de6b989d9fa74",
    D => 0,
    I => 1,
    K => "b0a54fd8b064b68cc452d9c87d4e5b021e6749ccdff6ca3a",
    N => "AES",
    P => "009c7c1006ee154e2e8e5f5adcf72cd22664118b856e7fc7",
    X => "AES:0:1:48:0048:0064",
  },
  {
    C => "3cc1e7a52c3b7112782915ca24084e6e391e4c86482608961733caf462952fcb49f2171251d29b2c",
    D => 0,
    I => 1,
    K => "7a1eaf2c21f6e92bbdb89fbb2cd0283ffff3e2ada6b862ce",
    N => "AES",
    P => "124bd817c0849c9b77a84178086e90a381db21a62fc43b313f4023792691e70a",
    X => "AES:0:1:48:0064:0080",
  },
  {
    C => "294294a20dcfd4f8b20b5105aedec366b776510bb30aae52bc9a00359b634248caaa4841766dd992ad477af54c4e3102",
    D => 0,
    I => 1,
    K => "d2822cb9185ab6bafe423a7d52f66e0a25b7439d4755c0fc",
    N => "AES",
    P => "ef7c4998b8b4b2d75f3928c86ad3bd02704ae1255b7fa00b03356a07091d4b0af48d337d4b6bbf0b",
    X => "AES:0:1:48:0080:0096",
  },
  {
    C => "9948283f7b4085e2a234d013d4a6f36ec9a90445f64d29c093684e7c087c2669b44e2f6ccbebc28fbba0d57912b5e5876c27706a95671a5e15e373d69d834bed55ab835eb77c22363598ff2cd9ca8b5d8c53cb4b99b70f703ded71220b7dabc0dc4bc189a70f9e952c8eb58f631e21ac4e69fc36f5ca25c413a11f27177f94a3faf4746aac1185da3c44e8e1925d7b70fe0b250e379fa062327c52b1b828973cf7f80b45cc7d7297a8430245f44ca2f4d8a9a2a51d7d490e0864bfbf62c4661f56ba5264e702e7d7a21684bcae33e75a77e8b72bed1f0179465d76c5e9d69f9a909063455b196f395936115b72979f940ef3cce45bb2a6158368a88e11c73b1d6188fe0038a0e8665d48670b29f85a7c338ea28aaa06c1e6b7ec422bb5ccda0d90f2fbb8c21288088adf6ceabec8910f19e1b4b8855e504e23b2b03c5bb579e6a0e62396b95a28a5ad914db55c554fd19ba24bdb0d32afa82ae45723dd894bb67ec4973751e536339568bbebad2f7041186cc0ca23a406393440e9f8d499e3ff8208978cbdc55e741606aa6753dc474aa57f86d8cc06e8369401797b189abdbc5c51e23a15f1dc67323643a7b189e7c2f0ce8be3faabe3eeb23eb7720b99ffcc81f064d2fd699349b9f9a5028a956c656fc13772e52c9cd0d46517fb5f3db40f013a8460b83257250bfe7dd0fb5e460586ed4d7cac617b874948daa7f0e72e909367228a4589ac17",
    D => 0,
    I => 1,
    K => "52a342bb23fd707a7fc37617e8f85aedc2db03ee11cdc126",
    N => "AES",
    P => "4b1b3189e39048e28a8b19b4aa82bd3f7f5f8c228991ffaede0e044dc8e2b0085e9f646b592b8f0fda3a188a050f4f69af74f17e37e95a3fbedbfdf98ca248a60ca014948087b0eebb3545322181b41b4add568bc0b410d33270c3e0002f6ffa6ab43c74968094cd35bb20babc3fe7c95e62e783faea8aa5c442fdd5e71b2121b329ad13be0da6f15e16558023ded7548494c679b4e3ee3978de709d85dbf5a1b18c729db83852c2e29e99a525c5e33367611200febdc77d95409fb2cdb82be4a77fe6cdaafe0a0f209aa6b494395d8dfeb5b7a7499ef22e03b8c933bf97e24775166e8cb27e1df37991a0153f252fe82c040a59c7a750c501a55d67da82147fc19036a6ac3c6ee3ed5931f800efe77e6c1d2ffe031029308e28c3d330b68e72d433baceb9b996d679070575cb851c2aadae8f51a415883f5c195c876ac16a27b658afbb86330e5967b137c9635c88fe803c953d49203d1f1e36e64ab44e7a1af76405dc3621dbd8fc11c58e94c7265fe1184a180362c50a5f2b8dc7543e260f4faac265df46ff4e9cc10abeb5396cb0eb50452ddcd848c1692ac0981ef31321bfa7e8e01c551bc39371fa2fa9326394b7d170b96628a52a3458706c453cce5aac379b8acab21842fe2af5518be6bc7e8fcb7a64e684b732422e49e703b3784ad5f73d4dadf1a3626a831b9b161082b815daae814cbb48f1ce79aeef4939c1f8",
    X => "AES:0:1:48:1024:1040",
  },
  {
    C => "46e5fa910879cd65c4d5f058612bf72ba5d51441024606e4",
    D => 0,
    I => 1,
    K => "542cb39fc4238ddfe95f618c5b30a3fb188bd08c852cc979524c2451821f815c",
    N => "AES",
    P => "7c2b3a8e89bdaffba69367117ead7990",
    X => "AES:0:1:64:0032:0048",
  },
  {
    C => "a261c68c7a7469c9b3a01c6794e865a254e5c3e7e57d5056955b75dc60a06415",
    D => 0,
    I => 1,
    K => "31a93c13a21f9a6163eac9ae15da8877a4b09edcf50d04c48516f1971cc88d04",
    N => "AES",
    P => "81b0f00ebcd04b3a6e88e7be76357c06a4cc391602a63d5c",
    X => "AES:0:1:64:0048:0064",
  },
  {
    C => "d8690b3327acda2d3029bd9a697074887476abfff5fae69e2f676aebcc5f47c39dca89fddb498044",
    D => 0,
    I => 1,
    K => "aa595905d8006352490215d5f63ae6395fb759e1029d124099111aed6cf01e55",
    N => "AES",
    P => "c29717ff201f7e0af18b7e0620a9e8679e8a759effb5ffad2300897344072238",
    X => "AES:0:1:64:0064:0080",
  },
  {
    C => "01677010a5d047cf0a34c4f5a7ccc42126e4f7e6f47928f309857de9733d7832e85c315e4490d65c8cbc950673d06a9a",
    D => 0,
    I => 1,
    K => "48c4119e6e34b28ec9992246821cd6ab2d3787d1c3f005e500014892895a21ef",
    N => "AES",
    P => "16dfa3e4d97cf599a13b8fdf9c34538d0ea8a12928dbe63044b805d68be3529d6291e4eb2251a0f5",
    X => "AES:0:1:64:0080:0096",
  },
  {
    C => "de8a69620e4d2eefb8287ba5fcb745630c24d65881eecb36daf1826263990bc1eba546f9f6cf1bf6ef8b73831c38fbd1e546e70c8338f5707b434ece94253a4cdeb483a5c8c533239a44bcc0d7c0e2c7a0b18027bc4f27a09f59367beb44688f95816e1bb296ae65f17578fc66939bee0e023521578e2f5ecf84198750643fd0631b5242ab47d01f5ede07212b307501722dbb2a12cc3c96c8253d1d1663ed259a45ec9bdb5c9dc261c05c25e3f06d08160a82433ab1370a3abd9a72047bbc2cc5ec3695bdef2bbf98f0b9e63bcd3e9dce12c31ece8b32516b4390e8246073b97fe6b7c34be4ac324f997074abade4f2456df63c13b50f89de6754ef543d4d11cb76e7eb6ae5c6429920d78d00b32c1839e4dfdea17e770b06e820343afd6dd8b899a5d802e4309a74ca7d7d6010d813f37e30bb3fac9c6ab985b0bc9825880d848b313714c895210c4d0107d9748bf04b599a58840b75041cb6e766fdb5f1bf1e530c31d12a4d4c5b6dab3fc26e9719381451573e791ce84da1ffc85536f0239436d0d481a9eaf27bec7d923c7f658037014d443dc8102f53bd11035d50b89c0792fa84b83f00bd87308a0fdec737c60e25768052cf4313e1fa837ebefb3ff666aa8c4bca9a9b38b911f1e364e5563689f973bcebf011d8de2d261fa419f05ed5377ab17a2ddc389fdeba85c93a3cc94af8d9de82add84030f192399049052529b8e58dabcede20",
    D => 0,
    I => 1,
    K => "26e1ecc0c4d1ca3d757653fb2364dfe0c06b0e9e31b82cff7be190fe01627208",
    N => "AES",
    P => "8d2ed7a04a33b20047cf7b54927d7347d6b36823c14727e8cb12d305e1c1dc80bd42c3eadd9f6f094d6a3997eda34f9af4c8623d82d367b483886167cb4aee3e4c72854121fff6981a6516b949d21b2c944d60f133eefe3a2e53266f5bdbbb13cd92c42e7c6bd464b8f8cbfaebf23d9c7ef6c14b4041d76ae15567c68d42f732d6e87bbbc3f502e62ed512a7ebf95f57258d499fcfd87cf9ec9e9ff58ea545c3e7d241902994e666fbf1765a1633c627c29318daafb987cb57d63fde50c45b5d54c15f8da9c8baa3a2120b48667697442f8639999d2f4ea44671c06fee32828595d82bebf31da2f84aba77ed60b787a6096b53b08f9365f87a6b3a9d265a11d3cff7248e59bafdb996fb6ed64520ffc25bece8dae7e379ec3e7645ffdbde2489d09b927bdbe7da76d6b0e6b3d5b8901d0e4d534e14950382bf3e9a035143b88ad393ce2c3b0f9a668c11d40ce57651814872f0faee8ba5bc0e78f9c308452b8501ad5aef7ef9b4068837141d24a346a71a14f00063b7a3711b782d130a4cdf276134230dab1e91846602a352134a8c52be31e0da6b37b1a540f5474d4727aa99571696b092a933963f3317e302ac4a0d970d64ba3848f7eff0a082c4a6cbedb1282cbfbd46ca9d2c25f48a359fc639e675dc51973491e0a38c2150a8caf6bb9c044184a3dbbf58e89692d7e57a5afa31d65461fd93af8043647bd16a6a6b5936",
    X => "AES:0:1:64:1024:1040",
  },
  {
    C => "2ec966209352c959278dbfcefaf51c96",
    D => 1,
    I => 0,
    K => "ab978bb18796ccbe45eaabefd6a13948",
    N => "AES",
    P => "1e",
    X => "AES:1:0:32:0002:0032",
  },
  {
    C => "e039ce098d8aeaf53ada5b8b634dace7",
    D => 1,
    I => 0,
    K => "160fd350da87a5b5ec47af47a31dd39c",
    N => "AES",
    P => "b46952d9",
    X => "AES:1:0:32:0008:0032",
  },
  {
    C => "3ed08c1d1f5022ea0631ac70f29d5d5063aba7fde653d621",
    D => 1,
    I => 0,
    K => "87e3893fa12f467e8e9a4b5ad9d98efa",
    N => "AES",
    P => "0fba5313c5181a46e3",
    X => "AES:1:0:32:0018:0048",
  },
  {
    C => "c7300d659ddb133f6cdaa600f8a0d0c1547d12b13fccf17a",
    D => 1,
    I => 0,
    K => "7fc7a84392968735201b90eea55f57a3",
    N => "AES",
    P => "3addc5d1251aa009947f97cd",
    X => "AES:1:0:32:0024:0048",
  },
  {
    C => "d3226f55b4b4bb4644f5752aead6505b4fd3ca6e112fb2a4b0e97133ffba7fc2dcdaf6fb68966c1582623180218bee1b768488cc0754d3a7d89367273d9e355ede53e814202666b849c92b5af0f5b0fb816cfcaf3680d8c32a9c17f62224e0367a12f177b46168b282fd4eb1226985ad",
    D => 1,
    I => 0,
    K => "92b6cc0b96b37c9830b37f94232c1c99",
    N => "AES",
    P => "d86a3ecd24b29196dee5de017b5ac4d7e9a15957953595035b46acf22d462730153f8b52befdcd6f5254f940bf178e3379cb460c5a5748c86cb34d963154dce269255fd95f97f01ed01bbea46834d91b0552d1537d73865e8d161f02b3ac0835fe02a31b73",
    X => "AES:1:0:32:0202:0224",
  },
  {
    C => "6db22bb35bd420e933a9acd713a237df",
    D => 1,
    I => 0,
    K => "954aaa6920fd1a63f8fbfbe3b456d6d7dc97378c71b5bab3",
    N => "AES",
    P => "29",
    X => "AES:1:0:48:0002:0032",
  },
  {
    C => "2044d516bf94244b59c0eb34eb47ae9a",
    D => 1,
    I => 0,
    K => "aca929cc3fe259c9c9383198424c4a52f90a07ecac6ac7bc",
    N => "AES",
    P => "8cf43d18",
    X => "AES:1:0:48:0008:0032",
  },
  {
    C => "01edb87ede6a4f66f7c8e3f66be199df676ac3868d0c9297",
    D => 1,
    I => 0,
    K => "00b15609bda6bddad33128aa259044d61b0906f27e6df66d",
    N => "AES",
    P => "f0095af008a5433bc7",
    X => "AES:1:0:48:0018:0048",
  },
  {
    C => "d3cdc2a5bd9c95f30ea571b6da2ffd726bc2e3e2b963228c",
    D => 1,
    I => 0,
    K => "c4e0a649c6cc8afd9b5bafd373da0e54012858c77519bd9e",
    N => "AES",
    P => "7e1414138e3701e8bbd70524",
    X => "AES:1:0:48:0024:0048",
  },
  {
    C => "8d138bc57b2e2b19bef1c95a91403bb791a3f2df47a5f2d45bc96aeebff9bb5d0d80be06c9b9cd7bf2c390f457ebaf8ab594177c8a696af28fb0274639c78ee5fbf74e249fffe202056c218d391e7c64034a837072986f82b110e7963a0d7f7a35e62d97b3b524b00caf723a581d497a",
    D => 1,
    I => 0,
    K => "2c4d89e8fd17ecb20bbda47071ec798bf638a570e19c6e79",
    N => "AES",
    P => "4a4301be175d9d3f3a1ffa904a645e42b92bfcffe12a0260b59e4906ee8be455423647a55b953f8b8879fc5ece14e0e36487b327dabe1f26f6247205015573355bb0fc8ffabdfb3352bf6ed7f21b62c04d4ea4ffb3e35924826c64fc0ab2f43519d6d5386a",
    X => "AES:1:0:48:0202:0224",
  },
  {
    C => "ce1f839cdaf7a85f3a65218a4e677fe9",
    D => 1,
    I => 0,
    K => "3fae5121c5ce495b012bf13fd6c5242c539b31e637aecc56b75957d1d11604d3",
    N => "AES",
    P => "43",
    X => "AES:1:0:64:0002:0032",
  },
  {
    C => "0a6d5b0d980d4e3c64263d611e89326b",
    D => 1,
    I => 0,
    K => "6f7de62109e5ced236c9aa22141569787b6637048598345655b7bea7a0b940ae",
    N => "AES",
    P => "4289859e",
    X => "AES:1:0:64:0008:0032",
  },
  {
    C => "fb5df4509ccc171043358e576678c8d72744d175886d450a",
    D => 1,
    I => 0,
    K => "f63f1d6899fe5a1f8038d0be7d39de9e7f6d25c11e94f21ed3e8cdfc1d007f8d",
    N => "AES",
    P => "9d30e7bf7f9e8d3f6a",
    X => "AES:1:0:64:0018:0048",
  },
  {
    C => "4ef13238834b1389b90888995332c2f1461d85439086770b",
    D => 1,
    I => 0,
    K => "7134f05007d37985bc7f68f92409aef0ece671b397157307a38103a2f2ba8597",
    N => "AES",
    P => "083436d3dfa539900b6a7485",
    X => "AES:1:0:64:0024:0048",
  },
  {
    C => "45691a184ae6cd921f39bdc497383f7cea822df53e009b224e35feee61af962bfd6c63706dd7c5fca35398ffb0200127775efc35dd1dd847b3191a2b3730b7923c8d31db6422e5b0e878338ac599c2d478b99848b25defb8b3219ac3deaa3ac30390b8986ce4523f30ea4ccde080a434",
    D => 1,
    I => 0,
    K => "ab9583bd52cec5bc0e52ecb491b3463809b44cf52bca44bb6f5e4d1003db9d17",
    N => "AES",
    P => "1870bf704cbde83813c1346ac787d6542ae3cfdb8f0a6fa8e3e66de6394025d42d2c2acb3f1d8b32cd28269e05aeaa227688ae0142681088d49906bd03e1d7d7233f48243bf30ae34d0e953f4ea9bac3c0fcf149089822f8c2afe885a7ec91f08374313706",
    X => "AES:1:0:64:0202:0224",
  },
  {
    C => "1be58ef58c742d1fc205915bbbb19152",
    D => 1,
    I => 1,
    K => "79f85745de77103bce1c12220867791d",
    N => "AES",
    P => "13",
    X => "AES:1:1:32:0002:0032",
  },
  {
    C => "bc50b78e685ef73946e05c628da34084",
    D => 1,
    I => 1,
    K => "e97a03ceb118e8ecd6828094f93435b5",
    N => "AES",
    P => "8787cdc8",
    X => "AES:1:1:32:0008:0032",
  },
  {
    C => "93bbe69d48c9ce29ea3bb60785d127349423f2e18a30e57f",
    D => 1,
    I => 1,
    K => "df1c32e0c1cc317945a50910affe6183",
    N => "AES",
    P => "52b63a559b659b81e3",
    X => "AES:1:1:32:0018:0048",
  },
  {
    C => "df4b237e5cd1f91b72136dbcdcaa8c4b39778d6cbcf6832e",
    D => 1,
    I => 1,
    K => "2a3597930117b03a9f7dfae8622486ac",
    N => "AES",
    P => "6d6f08585e7eea010b611b35",
    X => "AES:1:1:32:0024:0048",
  },
  {
    C => "9604f8ac3413b5ce23fb82622e8e60ca5ba4b90bcdf0a52acf52401ce67809dc0e26b0f2f51000be50fe284cdb1ad9fce21a2f969da2392ac7c0822d96aafa082f527149f2fb76ba2a3307d62106f8df3c071a180213b1e7483e32e1dbb00fd47d66ce8f729aad91059533f25351fa4e",
    D => 1,
    I => 1,
    K => "eb542f7099600a16ede45a8379c7e727",
    N => "AES",
    P => "cae927d387c72ce134885502fc094363326f0d68df297db84fb8291cdf6892ae29814de9f45a93e8ad32c1b330869a29d660f669c0314d54a8804caf5e7d6d18e8369e3bbd21c9e40b102cfc77c2f6f79209c0e4f5a90757d067fd1aea101115c9cf0ff066",
    X => "AES:1:1:32:0202:0224",
  },
  {
    C => "6ab04a9159d271b1c335697d63f3a0e2",
    D => 1,
    I => 1,
    K => "3b388df94ce8e629af07b483513609fd6affaedf62eea248",
    N => "AES",
    P => "38",
    X => "AES:1:1:48:0002:0032",
  },
  {
    C => "d70db3c10273a5c362fb3891f016010a",
    D => 1,
    I => 1,
    K => "1e5154438b543de803de95592bc780e317d2aaed1e17ad38",
    N => "AES",
    P => "af04adb8",
    X => "AES:1:1:48:0008:0032",
  },
  {
    C => "9ac19f6f214e8589821d8f1d70a741ec00d256c985624c27",
    D => 1,
    I => 1,
    K => "2b6bf835bd4510cdc860d95a2c1085b9a2f7900c184526f1",
    N => "AES",
    P => "b72935458e3b310103",
    X => "AES:1:1:48:0018:0048",
  },
  {
    C => "4f030ac89686a214d1fdf9258bedd8d95644730bbfca9e75",
    D => 1,
    I => 1,
    K => "6d115bcb39d5d76bfda9ea47fd7dbb9935a0e973e647519a",
    N => "AES",
    P => "b7f6b214ee4f852276d59f21",
    X => "AES:1:1:48:0024:0048",
  },
  {
    C => "6f018113edd2b3fde7f0862bc29cdf61715aee28f60cc6a64eb8f8c69d636511fc359a7198644b2da4c0dad4939f99d2a9adf8297a358bd5403b919107e354b685d6ee96c20d9270b27e27a0acd744c5d80c42869376c7a705acb4a7ee5ced56fb0f90e45325c7df8a2527d3cc8896b1",
    D => 1,
    I => 1,
    K => "222716cf9d410f8ece79f82ae038ee9a80ce5709bb173968",
    N => "AES",
    P => "bcce5c159a9e8802ced0bb50cfa788ba4dc63caa6e2ccaaf3527285bfa0a17c110c63df4691d80f6ef804e78f372be25af286139340383eb55dab74d92a72f47804891e5d5ef7395536cf9cc6bfec6c14e7294225a078f8d5b77c5495d7bcc738a91a151fe",
    X => "AES:1:1:48:0202:0224",
  },
  {
    C => "a205fd2c3fc63fe47b62158bab2e5e85",
    D => 1,
    I => 1,
    K => "cd150528ff9b9c893d907f3186a3d39e7c7ddb76045ce182cebb57f3a7bd93e4",
    N => "AES",
    P => "e4",
    X => "AES:1:1:64:0002:0032",
  },
  {
    C => "efe397b6f49a26c55b3fce003effb1ac",
    D => 1,
    I => 1,
    K => "24deb093ada160eb0730c6feb55461ffd29a5e8d149cce1a100de48bcd99c358",
    N => "AES",
    P => "8b2f0549",
    X => "AES:1:1:64:0008:0032",
  },
  {
    C => "753ff2767c4d1b6de70046fe19393fc7e0d3832fe142c92a",
    D => 1,
    I => 1,
    K => "7d5d5d7e6358553c4e62579cde319f7281a1cf7ab0ddd75c33553bef528f0f9e",
    N => "AES",
    P => "efe51c572741253043",
    X => "AES:1:1:64:0018:0048",
  },
  {
    C => "fd5d5750fc8b9db9783645815a9c3936b0e515cc35b953c7",
    D => 1,
    I => 1,
    K => "914cd9c46121f073064bfbcc1a98c9ab1a395e52255641cbc299632a952e15a7",
    N => "AES",
    P => "b78624855ceeb1ed6331a653",
    X => "AES:1:1:64:0024:0048",
  },
  {
    C => "24badd566fb5da237de770be86b50b9dbe72113a50b5d85708f2e0a3db42cf6d6a197654f1b87e0a73100e78b08d9ffae7fb19e6181ee82995523f00a62b41e065e98d9173d8cc467c7eacbd76350c0fcdfd293fc5ceb635b180eadc3920475271e3323b409e5fc75159c6c878310e50",
    D => 1,
    I => 1,
    K => "174cc4d43afbf5da1f0eb43ba7fb020596bc9a72fce9c2541a9b3f81a08c95e6",
    N => "AES",
    P => "c4c70e1de9911430b8d77346e8114db0345638d4dca5ede2aeeaf8e830a7f02ec0ed9d675d61ef410809188de380f5673b746b2818999895a71f835d76074b550a6570896577c90027c7f5508fade8213615f5a56d02d2acac2ce7c98da371c6c94dfbf410",
    X => "AES:1:1:64:0202:0224",
  },
  {
    C => "d8ec69150ba3980aea57ae4a",
    D => 0,
    I => 0,
    K => "09a638783af66b908137c4d3361c1ae152081195fee41dea",
    N => "DES_EDE",
    P => "965ee3269f2b0a28",
    X => "DES_EDE:0:0:48:0016:0024",
  },
  {
    C => "6f08140b29a5bdc7ee5cf023df19a40f",
    D => 0,
    I => 0,
    K => "df77cfba77e3087ec8fd1b79a8ac5d41c4b7708a9a037a48",
    N => "DES_EDE",
    P => "2a42f3c55aa2b2a9cb6d2af3",
    X => "DES_EDE:0:0:48:0024:0032",
  },
  {
    C => "960d2f3e0616d00c53a082b4d1b9da833bb31d79",
    D => 0,
    I => 0,
    K => "9ab6db4073be11e46b8c5bf4957956395ac87f98727b52d8",
    N => "DES_EDE",
    P => "a9cebce4d9a24720e7676eea61674d91",
    X => "DES_EDE:0:0:48:0032:0040",
  },
  {
    C => "d845253b5fa0a55f0f7407060dc2c2753b1e4b3132b8039e",
    D => 0,
    I => 0,
    K => "3a41eaffde08c438aeffc755dafc59d1462c556a7737490a",
    N => "DES_EDE",
    P => "455c114fca3c2d06c0a717099f3141ef562a79c8",
    X => "DES_EDE:0:0:48:0040:0048",
  },
  {
    C => "a2e8adccaf3c860d22ebc16ab71af0777d02336feb74f46306fc9f2291100b249b250bd67fa67b6c98743a4549fd8f37a7457f50adc10f32e6b289b62bdd53dfc955e29e695a28c2ebe0a9de6176b8053e91181e31c90ac5b6da155f64f3f8712a8c780269752852d648ff1cb21137e1c919679aca0e886a40bf6454952525fc92910733f6d8ac1933f76a247a612aefb00431da8b3a72d23b4358437c9c33150ce96ae297cd403c5d8f8c70b9b84aec5789705da7027d94b23fb4d406fc428e1abab3800a499f009fae12e417f1d392b497a795034edf25c3f31cabcb16f1fa88f9bdbd50276df7ecaea3fe58268e987be02ff08307dbe8933b5942a4677b12729aaa22",
    D => 0,
    I => 0,
    K => "eeecc916cd4f6971f43743a5d8a70e1fe74c1dd22983ddd7",
    N => "DES_EDE",
    P => "c6cc6ff311ba309831452f316efa53c4a4f62dc35fb7291d3dc361e76246eb9f51cc171fcfeb0579d9b77d950a3edffc756a4c4d9e3fc6eb439f29153549f377442f9d30b31ff25a0c3949dfa4da60f9c26cde4dbfe6d31f1fce1afc8da2a11b06a41807c1956c30406bd00ac4ece42077d055aa2224c73d73524da5710156aa4ec39b92a630cbee4a5d54a877598cbeaa8e6f85b75c82e5d717e013b0be25b59a0e1dfa7b6112519b00f191c95398269c23c783e1af23f7917dc84472f59e7d8626b3b49aa28b842e73603fe81eed72b6ee1c8534108163fae7810650b8f25d58e7422cbb59f168f72ad2aeb4800c39cb28d4ac654bc039a000d865693faf11",
    X => "DES_EDE:0:0:48:0512:0520",
  },
  {
    C => "a79c4069abc19f616412df22",
    D => 0,
    I => 1,
    K => "73613eaaa529180cae20da0d8bdedb75712e7ffe7edbae36",
    N => "DES_EDE",
    P => "fd5affd829c11b4e",
    X => "DES_EDE:0:1:48:0016:0024",
  },
  {
    C => "dcf83900419ff3ecd23e3d93c23f7d00",
    D => 0,
    I => 1,
    K => "c85b88faf497044b3ca8965509e656a4af5c7015cac8e0b6",
    N => "DES_EDE",
    P => "c1663e44cc68863b7e5d2acd",
    X => "DES_EDE:0:1:48:0024:0032",
  },
  {
    C => "bedcdc798bd4221c0337921d9c647c470ea03773",
    D => 0,
    I => 1,
    K => "57bc800aca05d2716b0821f33bf90abd5935697ae923f037",
    N => "DES_EDE",
    P => "0b94f181769412bc82f5c4aedfb8ecc1",
    X => "DES_EDE:0:1:48:0032:0040",
  },
  {
    C => "38b18fbc37790e873071f8f6169e3a4feb1d15ec215fddf8",
    D => 0,
    I => 1,
    K => "8461e5aaa4591328e2e80df6244c2f94d8c412bcd8d0b1a2",
    N => "DES_EDE",
    P => "10b25e11a6b393913a0ff5f6fc9d255bc196647f",
    X => "DES_EDE:0:1:48:0040:0048",
  },
  {
    C => "1f5b622e928c595f5afb203daaf378a1735a5befb11e13d0a71343a3f1594be95e5e5e753c958f2e0c6c8f8c61cd320feb69a54a0cd1e442f992593d2d2743d0bbc0cdfd5f21b22c53e27f25ecf77639f38d9fd490c97ba37df3af8fe9656a118d7a2c69f25a75c47fe5b34883469bb43614734bfadd22610a5a297ed437d3bb9fdd50c05a04a2f1b952385dec6461f9301205c73fd5af0b3f382f4b3d283351e7f6d4b71861c788df787866df8dfa3fbf4b72e10603787011e829497c5a29726e94cd05c26edadf45e69f8073ecd9bcb04d48bfbe49f7e7c082eb510f2cdd4786f5e012276f1ec49fd45e20043b7feae815db0c14863aa3a403e1d808102e5cd45d3f55",
    D => 0,
    I => 1,
    K => "f1ad7c02d3c4f0ea93ebb210a1817c67a3303c4bd3c368a3",
    N => "DES_EDE",
    P => "de1886bc77723049d735181560083b180d8358facee0c75519941ca47ccd8b41b6ea0c38fa83d34a80d291cf736beeadadafa691ae35dc6bf8eb5f5660d99ed95e769cc66be5a43ddd6c39dfe2fd4ad679955cf8e00a0f87254b89a901466e8c7da174bcfbbb7145e75e42a0a0383049e93e04c20a110b8a6cdc8f72e30133127a8195575bfcf824e713ee7b7243193330a5b3aec383ed8bf552f6e95bd3e0fe7fc48f57d46e716e61f777c87b3e59ded46f6ec3bb2f9e1e90f088a84b4a6c35855d754706255d35707f427ccfafd513455b849cdb59b90caf505eb874ff93c278acf6afd92cdaf994e9083da0873403175a7b0614982f73e38973cf05fa16f4",
    X => "DES_EDE:0:1:48:0512:0520",
  },
);

{
  # https://www.ietf.org/rfc/rfc3394.txt
  my $kek     = pack("H*", "000102030405060708090a0b0c0d0e0f1011121314151617");
  my $keydata = pack("H*", "00112233445566778899aabbccddeeff");
  my $wrap    = aes_key_wrap($kek, $keydata);
  is(unpack("H*", $wrap), "96778b25ae6ca435f92b5b97c050aed2468ab8a17ad84e5d");
  my $unwrap  = aes_key_unwrap($kek, $wrap);
  is(unpack("H*", $unwrap), "00112233445566778899aabbccddeeff");
}

{
  # https://www.ietf.org/rfc/rfc3394.txt
  my $kek     = pack("H*", "000102030405060708090a0b0c0d0e0f");
  my $keydata = pack("H*", "00112233445566778899aabbccddeeff");
  my $wrap    = aes_key_wrap($kek, $keydata);
  is(unpack("H*", $wrap), "1fa68b0a8112b447aef34bd8fb5a7b829d3e862371d2cfe5");
  my $unwrap  = aes_key_unwrap($kek, $wrap);
  is(unpack("H*", $unwrap), "00112233445566778899aabbccddeeff");
}

{
  # https://tools.ietf.org/html/rfc5649
  my $kek     = pack("H*", "5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
  my $keydata = pack("H*", "c37b7e6492584340bed12207808941155068f738");
  my $wrap    = aes_key_wrap($kek, $keydata);
  is(unpack("H*", $wrap), "138bdeaa9b8fa7fc61f97742e72248ee5ae6ae5360d1ae6a5f54f373fa543b6a");
  my $unwrap  = aes_key_unwrap($kek, $wrap);
  is(unpack("H*", $unwrap), "c37b7e6492584340bed12207808941155068f738");
}

{
  # https://tools.ietf.org/html/rfc5649
  my $kek     = pack("H*", "5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
  my $keydata = pack("H*", "466f7250617369");
  my $wrap    = aes_key_wrap($kek, $keydata);
  is(unpack("H*", $wrap), "afbeb0f07dfbf5419200f2ccb50bb24f");
  my $unwrap  = aes_key_unwrap($kek, $wrap);
  is(unpack("H*", $unwrap), "466f7250617369");
}

{
  # https://tools.ietf.org/html/draft-ietf-jose-json-web-encryption
  my $keydata = join '', map { chr($_) } (4, 211, 31, 197, 84, 157, 252, 254, 11, 100, 157, 250, 63, 170, 106, 206, 107, 124, 212, 45, 111, 107, 9, 219, 200, 177, 0, 240, 143, 156, 44, 207);
  my $kek = decode_b64u("GawgguFyGrWKav7AX4VKUg");
  my $ct  = decode_b64u("6KB707dM9YTIgHtLvtgWQ8mKwboJW3of9locizkDTHzBC2IlrT1oOQ");
  my $wrap    = aes_key_wrap($kek, $keydata);
  is(unpack("H*", $wrap), unpack("H*",$ct));
  my $unwrap  = aes_key_unwrap($kek, $wrap);
  is(unpack("H*", $unwrap), unpack("H*",$keydata));
}

for (@tv) {
  my $kek     = pack("H*", $_->{K});
  my $keydata = pack("H*", $_->{P});
  my $wrap    = aes_key_wrap($kek, $keydata, $_->{N}, $_->{D}, $_->{I});
  is(unpack("H*", $wrap), $_->{C});
  my $unwrap  = aes_key_unwrap($kek, $wrap, $_->{N}, $_->{D}, $_->{I});
  is(unpack("H*", $unwrap), $_->{P});
}

done_testing;