/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.CComplex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.RealNum;

public abstract class Complex
extends Quantity {
    private static CComplex imOne;
    private static CComplex imMinusOne;

    public Complex number() {
        return this;
    }

    public boolean isExact() {
        return this.re().isExact() && this.im().isExact();
    }

    public static CComplex imOne() {
        if (imOne == null) {
            imOne = new CComplex(IntNum.zero(), IntNum.one());
        }
        return imOne;
    }

    public static CComplex imMinusOne() {
        if (imMinusOne == null) {
            imMinusOne = new CComplex(IntNum.zero(), IntNum.minusOne());
        }
        return imMinusOne;
    }

    public double doubleValue() {
        return this.re().doubleValue();
    }

    public double doubleImagValue() {
        return this.im().doubleValue();
    }

    public final double doubleRealValue() {
        return this.doubleValue();
    }

    public long longValue() {
        return this.re().longValue();
    }

    public static Complex make(RealNum re, RealNum im) {
        if (im.isZero()) {
            return re;
        }
        if (!re.isExact() || !im.isExact()) {
            return new DComplex(re.doubleValue(), im.doubleValue());
        }
        return new CComplex(re, im);
    }

    public static Complex make(double re, double im) {
        if (im == 0.0) {
            return new DFloNum(re);
        }
        return new DComplex(re, im);
    }

    public static DComplex polar(double r, double t) {
        return new DComplex(r * Math.cos(t), r * Math.sin(t));
    }

    public static DComplex polar(RealNum r, RealNum t) {
        return Complex.polar(r.doubleValue(), t.doubleValue());
    }

    public static Complex power(Complex x, Complex y) {
        if (y instanceof IntNum) {
            return (Complex)x.power((IntNum)y);
        }
        double x_re = x.doubleRealValue();
        double x_im = x.doubleImagValue();
        double y_re = y.doubleRealValue();
        double y_im = y.doubleImagValue();
        if (x_im == 0.0 && y_im == 0.0 && (x_re >= 0.0 || Double.isInfinite(x_re) || Double.isNaN(x_re))) {
            return new DFloNum(Math.pow(x_re, y_re));
        }
        return DComplex.power(x_re, x_im, y_re, y_im);
    }

    public Numeric abs() {
        return new DFloNum(DComplex.hypot(this.doubleRealValue(), this.doubleImagValue()));
    }

    public RealNum angle() {
        return new DFloNum(Math.atan2(this.doubleImagValue(), this.doubleRealValue()));
    }

    public static boolean equals(Complex x, Complex y) {
        return x.re().equals(y.re()) && x.im().equals(x.im());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Complex)) {
            return false;
        }
        return Complex.equals(this, (Complex)obj);
    }

    public static int compare(Complex x, Complex y) {
        int code = x.im().compare(y.im());
        if (code != 0) {
            return code;
        }
        return x.re().compare(y.re());
    }

    public int compare(Object obj) {
        if (!(obj instanceof Complex)) {
            return ((Numeric)obj).compareReversed(this);
        }
        return Complex.compare(this, (Complex)obj);
    }

    public boolean isZero() {
        return this.re().isZero() && this.im().isZero();
    }

    public String toString(int radix) {
        if (this.im().isZero()) {
            return this.re().toString(radix);
        }
        String imString = this.im().toString(radix) + "i";
        if (imString.charAt(0) != '-') {
            imString = "+" + imString;
        }
        if (this.re().isZero()) {
            return imString;
        }
        return this.re().toString(radix) + imString;
    }

    public static Complex neg(Complex x) {
        return Complex.make(x.re().rneg(), x.im().rneg());
    }

    public Numeric neg() {
        return Complex.neg(this);
    }

    public static Complex add(Complex x, Complex y, int k) {
        return Complex.make(RealNum.add(x.re(), y.re(), k), RealNum.add(x.im(), y.im(), k));
    }

    public Numeric add(Object y, int k) {
        if (y instanceof Complex) {
            return Complex.add(this, (Complex)y, k);
        }
        return ((Numeric)y).addReversed(this, k);
    }

    public Numeric addReversed(Numeric x, int k) {
        if (x instanceof Complex) {
            return Complex.add((Complex)x, this, k);
        }
        throw new IllegalArgumentException();
    }

    public static Complex times(Complex x, Complex y) {
        RealNum x_re = x.re();
        RealNum x_im = x.im();
        RealNum y_re = y.re();
        RealNum y_im = y.im();
        return Complex.make(RealNum.add(RealNum.times(x_re, y_re), RealNum.times(x_im, y_im), -1), RealNum.add(RealNum.times(x_re, y_im), RealNum.times(x_im, y_re), 1));
    }

    public Numeric mul(Object y) {
        if (y instanceof Complex) {
            return Complex.times(this, (Complex)y);
        }
        return ((Numeric)y).mulReversed(this);
    }

    public Numeric mulReversed(Numeric x) {
        if (x instanceof Complex) {
            return Complex.times((Complex)x, this);
        }
        throw new IllegalArgumentException();
    }

    public static Complex divide(Complex x, Complex y) {
        if (!x.isExact() || !y.isExact()) {
            return DComplex.div(x.doubleRealValue(), x.doubleImagValue(), y.doubleRealValue(), y.doubleImagValue());
        }
        RealNum x_re = x.re();
        RealNum x_im = x.im();
        RealNum y_re = y.re();
        RealNum y_im = y.im();
        RealNum q = RealNum.add(RealNum.times(y_re, y_re), RealNum.times(y_im, y_im), 1);
        RealNum n = RealNum.add(RealNum.times(x_re, y_re), RealNum.times(x_im, y_im), 1);
        RealNum d = RealNum.add(RealNum.times(x_im, y_re), RealNum.times(x_re, y_im), -1);
        return Complex.make(RealNum.divide(n, q), RealNum.divide(d, q));
    }

    public Numeric div(Object y) {
        if (y instanceof Complex) {
            return Complex.divide(this, (Complex)y);
        }
        return ((Numeric)y).divReversed(this);
    }

    public Numeric divReversed(Numeric x) {
        if (x instanceof Complex) {
            return Complex.divide((Complex)x, this);
        }
        throw new IllegalArgumentException();
    }

    public Complex exp() {
        return Complex.polar(Math.exp(this.doubleRealValue()), this.doubleImagValue());
    }

    public Complex log() {
        return DComplex.log(this.doubleRealValue(), this.doubleImagValue());
    }

    public Complex sqrt() {
        return DComplex.sqrt(this.doubleRealValue(), this.doubleImagValue());
    }
}

