#!/usr/bin/python
import time
from weblive import WebLive

weblive=WebLive("https://weblive.stgraber.org/weblive/json")

# List servers
print "= list_servers ="
start=time.time()
servers=weblive.list_servers()
for server in servers:
    attributes=servers[server]
    print "== %s ==" % server
    for attribute in attributes:
        if attribute in ('locales','packages'):
            print " * %s: %s" % (attribute,len(attributes[attribute]))
        else:
            print " * %s: %s" % (attribute,attributes[attribute])
    print ""
print "%s\n" % (time.time()-start)

# List everything
print "= list_everything ="
start=time.time()
servers=weblive.list_everything()
for server in servers:
    attributes=servers[server]
    print "== %s ==" % server
    for attribute in attributes:
        if attribute in ('locales','packages'):
            print " * %s: %s" % (attribute,len(attributes[attribute]))
        else:
            print " * %s: %s" % (attribute,attributes[attribute])
    print ""
print "%s\n" % (time.time()-start)

# List locales
if server:
    print "= list_locales ="
    start=time.time()
    locales=weblive.list_locales(server)
    print "== %s ==" % server
    for locale in locales:
        print "* %s" % locale
    print ""
    print "%s\n" % (time.time()-start)

# List packages
if server:
    print "= list_packages ="
    start=time.time()
    packages=weblive.list_packages(server)
    print "== %s ==" % server
    for package in packages:
        print "* %s" % package
    print ""
    print "%s\n" % (time.time()-start)

# Create user
if server:
    print "= create_user ="
    start=time.time()
    user=weblive.create_user(server,'testjson','testjson','testjson','desktop','en_US.UTF-8')
    print "== %s ==" % server
    print user
    print ""
