/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
**************************************************************************/

#include "xml_creator_client.h"

XmlCreatorClient::XmlCreatorClient(QObject *parent)
         : QObject(parent)
{

}

QString XmlCreatorClient::create_xml_question(QString filePath, QString documentName, QString header)
{
    QString xmlDoctype = QString(XML_DOCTYPE);
    QString xmlOpening = QString(XML_OPENING);
    QString xmlClosing = QString(XML_CLOSING);
    QString xmlEnding = QString(XML_ENDING);

    QString xmlParametersDocument = QString(xmlDoctype + header + xmlEnding);
    QString xmlKontrolPackElement = QString(KONTROLPACK);

    QString xmlDocument = QString("");

    xmlDocument.append(xmlParametersDocument);
    xmlDocument.append(xmlOpening + xmlKontrolPackElement + xmlEnding);

    xmlDocument.append(xmlOpening + QString(FILE_XML) + xmlEnding);
    xmlDocument.append(documentName);
    xmlDocument.append(xmlClosing + QString(FILE_XML) + xmlEnding);

    xmlDocument.append(xmlOpening + QString(PATH)+ xmlEnding);
    xmlDocument.append(filePath);
    xmlDocument.append(xmlClosing + QString(PATH) + xmlEnding);

    return xmlDocument;
}
