"""Exposes the txaws certificate validation mechanism for general twisted use

Older versions of of txaws do not include the relevent code in which case an
ImportError will be raised when trying to import this module.
"""

from OpenSSL.SSL import Error as SSLError

from txaws.client.ssl import VerifyingContextFactory


class WebVerifyingContextFactory(object):
    """Compatibility wrapper bridging twisted http client and ssl interfaces

    This differs from the original implementation in txaws.client.base by
    creating a VerifyingContextFactory using the hostname passed, rather than
    ignoring the value and requiring the hostname on construction.
    """

    def getContext(self, hostname, port):
        return VerifyingContextFactory(hostname).getContext()
