/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright (C) chaitanya chandel 2009 <cchandel@yahoo.com>
 * 
 * gui.h is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * gui.h is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "db_sqlite.h"
#include <Elementary.h>

#define ALBUM 0
#define PLAYLIST 1

#define SMALL 0
#define LARGE 1

void create_gui(Evas_Object *win);
void create_add_page(Evas_Object *add_page);
void create_playing_page(Evas_Object *playing_page);
void create_playlist_page(void *data, Evas_Object *obj, void *event_info);
void create_art_page(void *data, Evas_Object *obj, void *event_info);
void create_dir_browser_page(void *data, Evas_Object *obj, void *event_info);
void prev_button_clicked(void *data, Evas_Object *obj, void *event_info);
void play_button_clicked(void *data, Evas_Object *obj, void *event_info);
void next_button_clicked(void *data, Evas_Object *obj, void *event_info);
void add_dir_button_clicked(void *data, Evas_Object *obj, void *event_info);
void vol_changed(void *data, Evas_Object *obj, void *event_info);
void pos_changed_start(void *data, Evas_Object *obj, void *event_info);
void pos_changed(void *data, Evas_Object *obj, void *event_info);
void load_playlist(Evas_Object *li, const char *p_list);
void up_button_clicked(void *data, Evas_Object *obj, void *event_info);
void home_button_clicked(void *data, Evas_Object *obj, void *event_info);
void dir_list_select(void *data, Evas_Object *obj, void *event_info);
void list_dir(char *direc);//, int depth);
void load_dir(Evas_Object *li, char *direc);
void create_manage_playlist_page();
void add_songs_button_clicked(void *data, Evas_Object *obj, void *event_info);
void rem_songs_button_clicked(void *data, Evas_Object *obj, void *event_info);
void del_playlist_button_clicked(void *data, Evas_Object *obj, void *event_info);
void create_eq_page (void *data, Evas_Object *obj, void *event_info);
void popup_message(char *message, char *msg, int butt_state);
void popup_alert(char *message);
int cancel_alert(void *data, Evas_Object *obj, void *event_info);
int ack_alert(void *data, Evas_Object *obj, void *event_info);
void cancel_button_clicked(void *data, Evas_Object *obj, void *event_info);
void song_select(void *data, Evas_Object *obj, void *event_info);
int set_duration(void);
void show_song_info (void);
void remove_song_button_clicked(void *data, Evas_Object *obj, void *event_info);
void save_playlist_button_clicked(void *data, Evas_Object *obj, void *event_info);
int check_audio_files(char *path);
void create_set_page(void *data, Evas_Object *obj, void *event_info);
void toggle_view (void *data, Evas_Object *obj, void *event_info);
void randomize_list(void);
void manage_songs_page(void *data, Evas_Object *obj, void *event_info);
void sel_songs_by_page(void *data, Evas_Object *obj, void *event_info);
void random_tg(void *data, Evas_Object *obj, void *event_info);
void loop_tg(void *data, Evas_Object *obj, void *event_info);
void bt_tg(void *data, Evas_Object *obj, void *event_info);
void show_song_lyrics(void);
void change_view_list(void);

extern int check_file_exists(char *path);
extern void sel_song (void);
extern void populate_filter_list(char *type, Evas_Object *list);
extern void set_song_info(void);
extern void start_mplayer_bt(void);
extern void start_mplayer(void);
extern void key_press(void *data, Evas *canvas_in, Evas_Object *obj, void *event_info);
extern void song_select_play(void *data, Evas_Object *obj, void *event_info);
extern void bass_changed(void *data, Evas_Object *obj, void *event_info);
extern void treble_changed(void *data, Evas_Object *obj, void *event_info);
extern void priority_changed(void *data, Evas_Object *obj, void *event_info);
extern void finger_tg(void *data, Evas_Object *obj, void *event_info);
extern void rescan_button_clicked(void *data, Evas_Object *obj, void *event_info);
extern Eina_Bool update_scan_popup(void *);
extern void song_scan(void);
extern void temp_playlist(void *data, Evas_Object *obj, void *event_info);
extern void edit_playlist_button_clicked(void *data, Evas_Object *obj, void *event_info);
extern void sel_playlist_button_clicked(void *data, Evas_Object *obj, void *event_info);
extern void add_album_button_clicked(void *data, Evas_Object *obj, void *event_info);
extern void remove_songs_button_clicked(void *data, Evas_Object *obj, void *event_info);
extern void populate_home_list(Evas_Object *li);
extern void remove_dir_button_clicked(void *data, Evas_Object *obj, void *event_info);
extern void playlist_song_tg(void *data, Evas_Object *obj, void *event_info);
extern void set_random_mode(void *data, Evas_Object *obj, void *event_info);

Evas_Object *list, *album_list, *pos_slider, *c_play_list, *play_list, *song_lb, *artist_lb, *popup_lb, *add_album_list;
Evas_Object *lyrics_sc, *lyrics_entry, *ic_playlist, *ic_albums, *add_page_win, *manage_playlist_page_win, *im;
Evas_Object *dir_browser_page_win, *vbox, *win, *list_box, *play_button, *ic_shuffle, *ic_repeat, *ic_play, *ic_bt, *ic_view;
Evas_Object *select_songs_page_win, *sel_songs_win, *manage_songs_page_win, *play_dur, *play_cur_pos, *rd, *rd_bt;
Evas_Object *set_page_win, *songs_dir_lb, *popup_bt, *home_list, *shuffle_hv;

extern int song_index, fd, no_songs, play_state, seek, song_dur, loop, finger, *seq, bt, next_song_random;
extern int bass, treble, priority, pid;
extern Elm_Object_Item *old_song;
extern FILE *mp_data;
extern pthread_t thread_id;

extern Ecore_Timer *scan_timer;
int view, songs_scanned, albums_scanned, depth, scanning;
extern char home_dir[255], cur_artist[254], cur_song[254], songs_dir[254];
Elm_Genlist_Item_Class itc_list, itc_dir_list, itc_album_list, itc_c_play_list, itc_play_list, itc_add_album_list, itc_filter_list;
Elm_Genlist_Item_Class itc_filter_final, itc_home_list;
