; UNSUPPORTED: system-windows
; REQUIRES: regkeys

; RUN: igc_opt -S -dce -platformpvc -rev-id B -has-emulated-64-bit-insts -igc-emit-visa --regkey=DumpVISAASMToConsole=1 -simd-mode 16 < %s | FileCheck %s

; CHECK: .decl vector331 v_type=G type=f num_elts=128 align=wordx32
; CHECK: .decl vectorized_cast v_type=G type=hf num_elts=128 align=wordx32

; CHECK: mov (M1, 16) vectorized_cast(0,0)<1> vector331(0,0)<1;1,0>
; CHECK: mov (M1, 16) vectorized_cast(0,16)<1> vector331(1,0)<1;1,0>
; CHECK: mov (M1, 16) vectorized_cast(1,0)<1> vector331(2,0)<1;1,0>
; CHECK: mov (M1, 16) vectorized_cast(1,16)<1> vector331(3,0)<1;1,0>
; CHECK: mov (M1, 16) vectorized_cast(2,0)<1> vector331(4,0)<1;1,0>
; CHECK: mov (M1, 16) vectorized_cast(2,16)<1> vector331(5,0)<1;1,0>
; CHECK: mov (M1, 16) vectorized_cast(3,0)<1> vector331(6,0)<1;1,0>
; CHECK: mov (M1, 16) vectorized_cast(3,16)<1> vector331(7,0)<1;1,0>


define spir_kernel void @_attn_fwd(half addrspace(1)* %0, half addrspace(1)* %1, half addrspace(1)* %2, float %3, i8 addrspace(1)* %4, float addrspace(1)* %5, <8 x i32> %r0, <8 x i32> %payloadHeader, i8* %privateBase, i32 %bufferOffset, i32 %bufferOffset1, i32 %bufferOffset2, i32 %bufferOffset3, i32 %bufferOffset4) {
  br label %._crit_edge

._crit_edge:                                      ; preds = %._crit_edge, %6
  %7 = call <8 x float> @llvm.genx.GenISA.sub.group.dpas.v8f32.v8f32.v8i16.v8i32(<8 x float> zeroinitializer, <8 x i16> zeroinitializer, <8 x i32> zeroinitializer, i32 0, i32 0, i32 0, i32 0, i1 false)
  %8 = extractelement <8 x float> %7, i64 0
  %vector331 = insertelement <8 x float> zeroinitializer, float %8, i32 0
  %vectorized_cast = fptrunc <8 x float> %vector331 to <8 x half>
  %9 = bitcast <8 x half> %vectorized_cast to <8 x i16>
  %10 = call <8 x float> @llvm.genx.GenISA.sub.group.dpas.v8f32.v8f32.v8i16.v8i32(<8 x float> zeroinitializer, <8 x i16> %9, <8 x i32> zeroinitializer, i32 0, i32 0, i32 0, i32 0, i1 false)
  br label %._crit_edge
}

declare <8 x float> @llvm.genx.GenISA.sub.group.dpas.v8f32.v8f32.v8i16.v8i32(<8 x float>, <8 x i16>, <8 x i32>, i32, i32, i32, i32, i1)

; Function Attrs: nofree nosync nounwind readnone speculatable willreturn
declare float @llvm.exp2.f32(float) #0

; uselistorder directives
uselistorder <8 x float> (<8 x float>, <8 x i16>, <8 x i32>, i32, i32, i32, i32, i1)* @llvm.genx.GenISA.sub.group.dpas.v8f32.v8f32.v8i16.v8i32, { 1, 0 }

attributes #0 = { nofree nosync nounwind readnone speculatable willreturn }

!igc.functions = !{!0}
!IGCMetadata = !{!18}

!0 = !{void (half addrspace(1)*, half addrspace(1)*, half addrspace(1)*, float, i8 addrspace(1)*, float addrspace(1)*, <8 x i32>, <8 x i32>, i8*, i32, i32, i32, i32, i32)* @_attn_fwd, !1}
!1 = !{!2, !3, !17}
!2 = !{!"function_type", i32 0}
!3 = !{!"implicit_arg_desc", !4, !5, !6, !7, !9, !11, !13, !15}
!4 = !{i32 0}
!5 = !{i32 1}
!6 = !{i32 13}
!7 = !{i32 15, !8}
!8 = !{!"explicit_arg_num", i32 0}
!9 = !{i32 15, !10}
!10 = !{!"explicit_arg_num", i32 1}
!11 = !{i32 15, !12}
!12 = !{!"explicit_arg_num", i32 2}
!13 = !{i32 15, !14}
!14 = !{!"explicit_arg_num", i32 4}
!15 = !{i32 15, !16}
!16 = !{!"explicit_arg_num", i32 5}
!17 = !{!"sub_group_size", i32 16}
!18 = !{!"ModuleMD", !19, !20, !128, !249, !280, !283, !284, !288, !291, !292, !293, !330, !358, !371, !372, !373, !389, !390, !391, !392, !393, !394, !395, !396, !397, !398, !402, !403, !410, !411, !412, !413, !414, !415, !416, !417, !418, !419, !420, !421, !423, !427, !428, !429, !430, !431, !432, !433, !434, !435, !436, !437, !438, !439, !440, !441, !442, !443, !444, !445, !193, !446, !447, !448, !450, !453, !454, !455, !457, !458, !459, !464, !465}
!19 = !{!"isPrecise", i1 false}
!20 = !{!"compOpt", !21, !22, !23, !24, !25, !26, !27, !28, !29, !30, !31, !32, !33, !34, !35, !36, !37, !38, !39, !40, !41, !42, !43, !44, !45, !46, !47, !48, !49, !50, !51, !52, !53, !54, !55, !56, !57, !58, !59, !60, !61, !62, !63, !64, !65, !66, !67, !68, !69, !70, !71, !72, !73, !74, !75, !76, !77, !78, !79, !80, !81, !82, !83, !84, !85, !86, !87, !88, !89, !90, !91, !92, !93, !94, !95, !96, !97, !98, !99, !100, !102, !103, !104, !105, !106, !107, !108, !109, !110, !111, !112, !113, !114, !115, !116, !117, !118, !119, !120, !121, !122, !123, !124, !125, !126, !127}
!21 = !{!"DenormsAreZero", i1 false}
!22 = !{!"BFTFDenormsAreZero", i1 false}
!23 = !{!"CorrectlyRoundedDivSqrt", i1 false}
!24 = !{!"OptDisable", i1 false}
!25 = !{!"MadEnable", i1 false}
!26 = !{!"NoSignedZeros", i1 false}
!27 = !{!"NoNaNs", i1 false}
!28 = !{!"FloatRoundingMode", i32 0}
!29 = !{!"FloatCvtIntRoundingMode", i32 3}
!30 = !{!"LoadCacheDefault", i32 4}
!31 = !{!"StoreCacheDefault", i32 2}
!32 = !{!"VISAPreSchedRPThreshold", i32 0}
!33 = !{!"SetLoopUnrollThreshold", i32 0}
!34 = !{!"UnsafeMathOptimizations", i1 false}
!35 = !{!"disableCustomUnsafeOpts", i1 false}
!36 = !{!"disableReducePow", i1 false}
!37 = !{!"disableSqrtOpt", i1 false}
!38 = !{!"FiniteMathOnly", i1 false}
!39 = !{!"FastRelaxedMath", i1 false}
!40 = !{!"DashGSpecified", i1 false}
!41 = !{!"FastCompilation", i1 false}
!42 = !{!"UseScratchSpacePrivateMemory", i1 true}
!43 = !{!"RelaxedBuiltins", i1 false}
!44 = !{!"SubgroupIndependentForwardProgressRequired", i1 true}
!45 = !{!"GreaterThan2GBBufferRequired", i1 true}
!46 = !{!"GreaterThan4GBBufferRequired", i1 true}
!47 = !{!"DisableA64WA", i1 false}
!48 = !{!"ForceEnableA64WA", i1 false}
!49 = !{!"PushConstantsEnable", i1 true}
!50 = !{!"HasPositivePointerOffset", i1 false}
!51 = !{!"HasBufferOffsetArg", i1 true}
!52 = !{!"BufferOffsetArgOptional", i1 true}
!53 = !{!"replaceGlobalOffsetsByZero", i1 false}
!54 = !{!"forcePixelShaderSIMDMode", i32 0}
!55 = !{!"ForceGeomFFShaderSIMDMode", i32 0}
!56 = !{!"pixelShaderDoNotAbortOnSpill", i1 false}
!57 = !{!"UniformWGS", i1 false}
!58 = !{!"disableVertexComponentPacking", i1 false}
!59 = !{!"disablePartialVertexComponentPacking", i1 false}
!60 = !{!"PreferBindlessImages", i1 false}
!61 = !{!"UseBindlessMode", i1 false}
!62 = !{!"UseLegacyBindlessMode", i1 true}
!63 = !{!"disableMathRefactoring", i1 false}
!64 = !{!"atomicBranch", i1 false}
!65 = !{!"spillCompression", i1 false}
!66 = !{!"DisableEarlyOut", i1 false}
!67 = !{!"ForceInt32DivRemEmu", i1 false}
!68 = !{!"ForceInt32DivRemEmuSP", i1 false}
!69 = !{!"WaveIntrinsicUsed", i1 false}
!70 = !{!"DisableMultiPolyPS", i1 false}
!71 = !{!"NeedTexture3DLODWA", i1 false}
!72 = !{!"DisableFastestSingleCSSIMD", i1 false}
!73 = !{!"DisableFastestLinearScan", i1 false}
!74 = !{!"UseStatelessforPrivateMemory", i1 false}
!75 = !{!"EnableTakeGlobalAddress", i1 false}
!76 = !{!"IsLibraryCompilation", i1 false}
!77 = !{!"LibraryCompileSIMDSize", i32 0}
!78 = !{!"FastVISACompile", i1 false}
!79 = !{!"MatchSinCosPi", i1 false}
!80 = !{!"ExcludeIRFromZEBinary", i1 false}
!81 = !{!"EmitZeBinVISASections", i1 false}
!82 = !{!"FP64GenEmulationEnabled", i1 false}
!83 = !{!"FP64GenConvEmulationEnabled", i1 false}
!84 = !{!"allowDisableRematforCS", i1 false}
!85 = !{!"DisableIncSpillCostAllAddrTaken", i1 false}
!86 = !{!"DisableCPSOmaskWA", i1 false}
!87 = !{!"DisableFastestGopt", i1 false}
!88 = !{!"WaForceHalfPromotionComputeShader", i1 false}
!89 = !{!"WaForceHalfPromotionPixelVertexShader", i1 false}
!90 = !{!"DisableConstantCoalescing", i1 false}
!91 = !{!"EnableUndefAlphaOutputAsRed", i1 true}
!92 = !{!"WaEnableALTModeVisaWA", i1 false}
!93 = !{!"EnableLdStCombineforLoad", i1 false}
!94 = !{!"EnableLdStCombinewithDummyLoad", i1 false}
!95 = !{!"WaEnableAtomicWaveFusion", i1 false}
!96 = !{!"WaEnableAtomicWaveFusionNonNullResource", i1 false}
!97 = !{!"WaEnableAtomicWaveFusionStateless", i1 false}
!98 = !{!"WaEnableAtomicWaveFusionTyped", i1 false}
!99 = !{!"WaEnableAtomicWaveFusionPartial", i1 false}
!100 = !{!"WaEnableAtomicWaveFusionMoreDimensions", i1 false}
!102 = !{!"WaStoreRawVectorToTypedWrite", i1 false}
!103 = !{!"WaLoadRawVectorToTypedRead", i1 false}
!104 = !{!"WaTypedAtomicBinToRawAtomicBin", i1 false}
!105 = !{!"WaSampleLoadToTypedRead", i1 false}
!106 = !{!"WaZeroSLMBeforeUse", i1 false}
!107 = !{!"WaFlagGroupTypedUAVGloballyCoherent", i1 false}
!108 = !{!"EnableFastSampleD", i1 false}
!109 = !{!"EnableIndependentSharedMemoryFenceFunctionality", i1 false}
!110 = !{!"NewSpillCostFunction", i1 false}
!111 = !{!"EnableVRT", i1 false}
!112 = !{!"ForceLargeGRFNum4RQ", i1 false}
!113 = !{!"Enable2xGRFRetry", i1 false}
!114 = !{!"Detect2xGRFCandidate", i1 false}
!115 = !{!"EnableURBWritesMerging", i1 true}
!116 = !{!"DisableEUFusion", i1 false}
!117 = !{!"DisableFDivToFMulInvOpt", i1 false}
!118 = !{!"initializePhiSampleSourceWA", i1 false}
!119 = !{!"WaDisableSubspanUseNoMaskForCB", i1 false}
!120 = !{!"DisableLoosenSimd32Occu", i1 false}
!121 = !{!"FastestS1Options", i32 0}
!122 = !{!"DisableFastestForWaveIntrinsicsCS", i1 false}
!123 = !{!"ForceLinearWalkOnLinearUAV", i1 false}
!124 = !{!"DisableLscSamplerRouting", i1 false}
!125 = !{!"UseBarrierControlFlowOptimization", i1 false}
!126 = !{!"EnableDynamicRQManagement", i1 false}
!127 = !{!"Quad8InputThreshold", i32 0}
!128 = !{!"FuncMD", !129, !130}
!129 = !{!"FuncMDMap[0]", void (half addrspace(1)*, half addrspace(1)*, half addrspace(1)*, float, i8 addrspace(1)*, float addrspace(1)*, <8 x i32>, <8 x i32>, i8*, i32, i32, i32, i32, i32)* @_attn_fwd}
!130 = !{!"FuncMDValue[0]", !131, !132, !136, !137, !138, !139, !140, !141, !142, !162, !185, !186, !187, !188, !189, !190, !191, !192, !193, !194, !195, !196, !197, !198, !199, !200, !201, !208, !215, !222, !229, !236, !243, !244, !248}
!131 = !{!"localOffsets"}
!132 = !{!"workGroupWalkOrder", !133, !134, !135}
!133 = !{!"dim0", i32 0}
!134 = !{!"dim1", i32 1}
!135 = !{!"dim2", i32 2}
!136 = !{!"funcArgs"}
!137 = !{!"functionType", !"KernelFunction"}
!138 = !{!"inlineDynConstants"}
!139 = !{!"inlineDynRootConstant"}
!140 = !{!"inlineDynConstantDescTable"}
!141 = !{!"m_pInterestingConstants"}
!142 = !{!"rtInfo", !143, !144, !145, !146, !147, !148, !149, !150, !151, !152, !153, !154, !155, !156, !157, !158, !160, !161, !111}
!143 = !{!"callableShaderType", !"NumberOfCallableShaderTypes"}
!144 = !{!"isContinuation", i1 false}
!145 = !{!"hasTraceRayPayload", i1 false}
!146 = !{!"hasHitAttributes", i1 false}
!147 = !{!"hasCallableData", i1 false}
!148 = !{!"ShaderStackSize", i32 0}
!149 = !{!"ShaderHash", i64 0}
!150 = !{!"ShaderName", !""}
!151 = !{!"ParentName", !""}
!152 = !{!"SlotNum", i1* null}
!153 = !{!"NOSSize", i32 0}
!154 = !{!"globalRootSignatureSize", i32 0}
!155 = !{!"Entries"}
!156 = !{!"SpillUnions"}
!157 = !{!"CustomHitAttrSizeInBytes", i32 0}
!158 = !{!"Types", !159}
!159 = !{!"FullFrameTys"}
!160 = !{!"Aliases"}
!161 = !{!"NumGRF", i32 0}
!162 = !{!"resAllocMD", !163, !164, !165, !166, !184}
!163 = !{!"uavsNumType", i32 0}
!164 = !{!"srvsNumType", i32 0}
!165 = !{!"samplersNumType", i32 0}
!166 = !{!"argAllocMDList", !167, !171, !172, !173, !174, !175, !176, !177, !178, !179, !180, !181, !182, !183}
!167 = !{!"argAllocMDListVec[0]", !168, !169, !170}
!168 = !{!"type", i32 0}
!169 = !{!"extensionType", i32 -1}
!170 = !{!"indexType", i32 -1}
!171 = !{!"argAllocMDListVec[1]", !168, !169, !170}
!172 = !{!"argAllocMDListVec[2]", !168, !169, !170}
!173 = !{!"argAllocMDListVec[3]", !168, !169, !170}
!174 = !{!"argAllocMDListVec[4]", !168, !169, !170}
!175 = !{!"argAllocMDListVec[5]", !168, !169, !170}
!176 = !{!"argAllocMDListVec[6]", !168, !169, !170}
!177 = !{!"argAllocMDListVec[7]", !168, !169, !170}
!178 = !{!"argAllocMDListVec[8]", !168, !169, !170}
!179 = !{!"argAllocMDListVec[9]", !168, !169, !170}
!180 = !{!"argAllocMDListVec[10]", !168, !169, !170}
!181 = !{!"argAllocMDListVec[11]", !168, !169, !170}
!182 = !{!"argAllocMDListVec[12]", !168, !169, !170}
!183 = !{!"argAllocMDListVec[13]", !168, !169, !170}
!184 = !{!"inlineSamplersMD"}
!185 = !{!"maxByteOffsets"}
!186 = !{!"IsInitializer", i1 false}
!187 = !{!"IsFinalizer", i1 false}
!188 = !{!"CompiledSubGroupsNumber", i32 0}
!189 = !{!"hasInlineVmeSamplers", i1 false}
!190 = !{!"localSize", i32 0}
!191 = !{!"localIDPresent", i1 false}
!192 = !{!"groupIDPresent", i1 false}
!193 = !{!"privateMemoryPerWI", i32 0}
!194 = !{!"prevFPOffset", i32 0}
!195 = !{!"globalIDPresent", i1 false}
!196 = !{!"hasSyncRTCalls", i1 false}
!197 = !{!"hasNonKernelArgLoad", i1 false}
!198 = !{!"hasNonKernelArgStore", i1 false}
!199 = !{!"hasNonKernelArgAtomic", i1 false}
!200 = !{!"UserAnnotations"}
!201 = !{!"m_OpenCLArgAddressSpaces", !202, !203, !204, !205, !206, !207}
!202 = !{!"m_OpenCLArgAddressSpacesVec[0]", i32 1}
!203 = !{!"m_OpenCLArgAddressSpacesVec[1]", i32 1}
!204 = !{!"m_OpenCLArgAddressSpacesVec[2]", i32 1}
!205 = !{!"m_OpenCLArgAddressSpacesVec[3]", i32 0}
!206 = !{!"m_OpenCLArgAddressSpacesVec[4]", i32 1}
!207 = !{!"m_OpenCLArgAddressSpacesVec[5]", i32 1}
!208 = !{!"m_OpenCLArgAccessQualifiers", !209, !210, !211, !212, !213, !214}
!209 = !{!"m_OpenCLArgAccessQualifiersVec[0]", !"none"}
!210 = !{!"m_OpenCLArgAccessQualifiersVec[1]", !"none"}
!211 = !{!"m_OpenCLArgAccessQualifiersVec[2]", !"none"}
!212 = !{!"m_OpenCLArgAccessQualifiersVec[3]", !"none"}
!213 = !{!"m_OpenCLArgAccessQualifiersVec[4]", !"none"}
!214 = !{!"m_OpenCLArgAccessQualifiersVec[5]", !"none"}
!215 = !{!"m_OpenCLArgTypes", !216, !217, !218, !219, !220, !221}
!216 = !{!"m_OpenCLArgTypesVec[0]", !"half*"}
!217 = !{!"m_OpenCLArgTypesVec[1]", !"half*"}
!218 = !{!"m_OpenCLArgTypesVec[2]", !"half*"}
!219 = !{!"m_OpenCLArgTypesVec[3]", !"float"}
!220 = !{!"m_OpenCLArgTypesVec[4]", !"char*"}
!221 = !{!"m_OpenCLArgTypesVec[5]", !"float*"}
!222 = !{!"m_OpenCLArgBaseTypes", !223, !224, !225, !226, !227, !228}
!223 = !{!"m_OpenCLArgBaseTypesVec[0]", !"half*"}
!224 = !{!"m_OpenCLArgBaseTypesVec[1]", !"half*"}
!225 = !{!"m_OpenCLArgBaseTypesVec[2]", !"half*"}
!226 = !{!"m_OpenCLArgBaseTypesVec[3]", !"float"}
!227 = !{!"m_OpenCLArgBaseTypesVec[4]", !"char*"}
!228 = !{!"m_OpenCLArgBaseTypesVec[5]", !"float*"}
!229 = !{!"m_OpenCLArgTypeQualifiers", !230, !231, !232, !233, !234, !235}
!230 = !{!"m_OpenCLArgTypeQualifiersVec[0]", !""}
!231 = !{!"m_OpenCLArgTypeQualifiersVec[1]", !""}
!232 = !{!"m_OpenCLArgTypeQualifiersVec[2]", !""}
!233 = !{!"m_OpenCLArgTypeQualifiersVec[3]", !""}
!234 = !{!"m_OpenCLArgTypeQualifiersVec[4]", !""}
!235 = !{!"m_OpenCLArgTypeQualifiersVec[5]", !""}
!236 = !{!"m_OpenCLArgNames", !237, !238, !239, !240, !241, !242}
!237 = !{!"m_OpenCLArgNamesVec[0]", !""}
!238 = !{!"m_OpenCLArgNamesVec[1]", !""}
!239 = !{!"m_OpenCLArgNamesVec[2]", !""}
!240 = !{!"m_OpenCLArgNamesVec[3]", !""}
!241 = !{!"m_OpenCLArgNamesVec[4]", !""}
!242 = !{!"m_OpenCLArgNamesVec[5]", !""}
!243 = !{!"m_OpenCLArgScalarAsPointers"}
!244 = !{!"m_OptsToDisablePerFunc", !245, !246, !247}
!245 = !{!"m_OptsToDisablePerFuncSet[0]", !"IGC-AddressArithmeticSinking"}
!246 = !{!"m_OptsToDisablePerFuncSet[1]", !"IGC-AllowSimd32Slicing"}
!247 = !{!"m_OptsToDisablePerFuncSet[2]", !"IGC-SinkLoadOpt"}
!248 = !{!"KABPointerLoc", i1* null}
!249 = !{!"pushInfo", !250, !251, !252, !256, !257, !258, !259, !260, !261, !262, !263, !276, !277, !278, !279}
!250 = !{!"pushableAddresses"}
!251 = !{!"bindlessPushInfo"}
!252 = !{!"dynamicBufferInfo", !253, !254, !255}
!253 = !{!"firstIndex", i32 0}
!254 = !{!"numOffsets", i32 0}
!255 = !{!"forceDisabled", i1 false}
!256 = !{!"MaxNumberOfPushedBuffers", i32 0}
!257 = !{!"inlineConstantBufferSlot", i32 -1}
!258 = !{!"inlineConstantBufferOffset", i32 -1}
!259 = !{!"inlineConstantBufferGRFOffset", i32 -1}
!260 = !{!"constants"}
!261 = !{!"inputs"}
!262 = !{!"constantReg"}
!263 = !{!"simplePushInfoArr", !264, !273, !274, !275}
!264 = !{!"simplePushInfoArrVec[0]", !265, !266, !267, !268, !269, !270, !271, !272}
!265 = !{!"cbIdx", i32 0}
!266 = !{!"pushableAddressGrfOffset", i32 -1}
!267 = !{!"pushableOffsetGrfOffset", i32 -1}
!268 = !{!"offset", i32 0}
!269 = !{!"size", i32 0}
!270 = !{!"isStateless", i1 false}
!271 = !{!"isBindless", i1 false}
!272 = !{!"simplePushLoads"}
!273 = !{!"simplePushInfoArrVec[1]", !265, !266, !267, !268, !269, !270, !271, !272}
!274 = !{!"simplePushInfoArrVec[2]", !265, !266, !267, !268, !269, !270, !271, !272}
!275 = !{!"simplePushInfoArrVec[3]", !265, !266, !267, !268, !269, !270, !271, !272}
!276 = !{!"simplePushBufferUsed", i32 0}
!277 = !{!"pushAnalysisWIInfos"}
!278 = !{!"inlineRTGlobalPtrOffset", i32 0}
!279 = !{!"rtSyncSurfPtrOffset", i32 0}
!280 = !{!"pISAInfo", !281, !282}
!281 = !{!"shaderType", !"UNKNOWN"}
!282 = !{!"URBOutputLength", i32 0}
!283 = !{!"WaEnableICBPromotion", i1 false}
!284 = !{!"vsInfo", !285, !286, !287}
!285 = !{!"DrawIndirectBufferIndex", i32 -1}
!286 = !{!"vertexReordering", i32 -1}
!287 = !{!"MaxNumOfOutputs", i32 0}
!288 = !{!"hsInfo", !289, !290}
!289 = !{!"numPatchAttributesPatchBaseName", !""}
!290 = !{!"numVertexAttributesPatchBaseName", !""}
!291 = !{!"dsInfo", !287}
!292 = !{!"gsInfo", !287}
!293 = !{!"psInfo", !294, !295, !296, !297, !298, !299, !300, !301, !302, !303, !304, !305, !306, !307, !308, !309, !310, !311, !312, !313, !314, !315, !316, !317, !318, !319, !320, !321, !322, !323, !324, !325, !326, !327, !328, !329}
!294 = !{!"BlendStateDisabledMask", i8 0}
!295 = !{!"SkipSrc0Alpha", i1 false}
!296 = !{!"DualSourceBlendingDisabled", i1 false}
!297 = !{!"ForceEnableSimd32", i1 false}
!298 = !{!"DisableSimd32WithDiscard", i1 false}
!299 = !{!"outputDepth", i1 false}
!300 = !{!"outputStencil", i1 false}
!301 = !{!"outputMask", i1 false}
!302 = !{!"blendToFillEnabled", i1 false}
!303 = !{!"forceEarlyZ", i1 false}
!304 = !{!"hasVersionedLoop", i1 false}
!305 = !{!"forceSingleSourceRTWAfterDualSourceRTW", i1 false}
!306 = !{!"requestCPSizeRelevant", i1 false}
!307 = !{!"requestCPSize", i1 false}
!308 = !{!"texelMaskFastClearMode", !"Disabled"}
!309 = !{!"NumSamples", i8 0}
!310 = !{!"blendOptimizationMode"}
!311 = !{!"colorOutputMask"}
!312 = !{!"ProvokingVertexModeNosIndex", i32 0}
!313 = !{!"ProvokingVertexModeNosPatch", !""}
!314 = !{!"ProvokingVertexModeLast", !"Negative"}
!315 = !{!"VertexAttributesBypass", i1 false}
!316 = !{!"LegacyBaryAssignmentDisableLinear", i1 false}
!317 = !{!"LegacyBaryAssignmentDisableLinearNoPerspective", i1 false}
!318 = !{!"LegacyBaryAssignmentDisableLinearCentroid", i1 false}
!319 = !{!"LegacyBaryAssignmentDisableLinearNoPerspectiveCentroid", i1 false}
!320 = !{!"LegacyBaryAssignmentDisableLinearSample", i1 false}
!321 = !{!"LegacyBaryAssignmentDisableLinearNoPerspectiveSample", i1 false}
!322 = !{!"MeshShaderWAPerPrimitiveUserDataEnable", !"Negative"}
!323 = !{!"meshShaderWAPerPrimitiveUserDataEnablePatchName", !""}
!324 = !{!"generatePatchesForRTWriteSends", i1 false}
!325 = !{!"forceVMask", i1 false}
!326 = !{!"needsVMask", i1 false}
!327 = !{!"WaDisableVRS", i1 false}
!328 = !{!"RelaxMemoryVisibilityFromPSOrdering", i1 false}
!329 = !{!"WaEnableVMaskUnderNonUnifromCF", i1 false}
!330 = !{!"csInfo", !331, !332, !333, !334, !335, !32, !33, !336, !337, !338, !339, !340, !341, !342, !343, !344, !345, !346, !347, !348, !65, !349, !350, !351, !352, !354, !355, !356, !357}
!331 = !{!"maxWorkGroupSize", i32 0}
!332 = !{!"waveSize", i32 0}
!333 = !{!"ComputeShaderSecondCompile"}
!334 = !{!"forcedSIMDSize", i8 0}
!335 = !{!"forceTotalGRFNum", i32 0}
!336 = !{!"forceSpillCompression", i1 false}
!337 = !{!"allowLowerSimd", i1 false}
!338 = !{!"disableSimd32Slicing", i1 false}
!339 = !{!"disableSplitOnSpill", i1 false}
!340 = !{!"enableNewSpillCostFunction", i1 false}
!341 = !{!"forceVISAPreSched", i1 false}
!342 = !{!"forceUniformBuffer", i1 false}
!343 = !{!"forceUniformSurfaceSampler", i1 false}
!344 = !{!"disableLocalIdOrderOptimizations", i1 false}
!345 = !{!"disableDispatchAlongY", i1 false}
!346 = !{!"neededThreadIdLayout", i1* null}
!347 = !{!"forceTileYWalk", i1 false}
!348 = !{!"atomicBranch", i32 0}
!349 = !{!"disableEarlyOut", i1 false}
!350 = !{!"walkOrderEnabled", i1 false}
!351 = !{!"walkOrderOverride", i32 0}
!352 = !{!"ResForHfPacking"}
!354 = !{!"constantFoldSimdSize", i1 false}
!355 = !{!"isNodeShader", i1 false}
!356 = !{!"threadGroupMergeSize", i32 0}
!357 = !{!"threadGroupMergeOverY", i1 false}
!358 = !{!"msInfo", !359, !360, !361, !362, !363, !364, !365, !366, !367, !368, !369, !314, !312, !370, !355}
!359 = !{!"PrimitiveTopology", i32 3}
!360 = !{!"MaxNumOfPrimitives", i32 0}
!361 = !{!"MaxNumOfVertices", i32 0}
!362 = !{!"MaxNumOfPerPrimitiveOutputs", i32 0}
!363 = !{!"MaxNumOfPerVertexOutputs", i32 0}
!364 = !{!"WorkGroupSize", i32 0}
!365 = !{!"WorkGroupMemorySizeInBytes", i32 0}
!366 = !{!"IndexFormat", i32 6}
!367 = !{!"SubgroupSize", i32 0}
!368 = !{!"VPandRTAIndexAutostripEnable", i1 false}
!369 = !{!"MeshShaderWAPerPrimitiveUserDataEnable", i1 false}
!370 = !{!"numPrimitiveAttributesPatchBaseName", !""}
!371 = !{!"taskInfo", !287, !364, !365, !367}
!372 = !{!"NBarrierCnt", i32 0}
!373 = !{!"rtInfo", !374, !375, !376, !377, !378, !379, !380, !381, !382, !383, !384, !385, !386, !387, !388}
!374 = !{!"RayQueryAllocSizeInBytes", i32 0}
!375 = !{!"NumContinuations", i32 0}
!376 = !{!"RTAsyncStackAddrspace", i32 -1}
!377 = !{!"RTAsyncStackSurfaceStateOffset", i1* null}
!378 = !{!"SWHotZoneAddrspace", i32 -1}
!379 = !{!"SWHotZoneSurfaceStateOffset", i1* null}
!380 = !{!"SWStackAddrspace", i32 -1}
!381 = !{!"SWStackSurfaceStateOffset", i1* null}
!382 = !{!"RTSyncStackAddrspace", i32 -1}
!383 = !{!"RTSyncStackSurfaceStateOffset", i1* null}
!384 = !{!"doSyncDispatchRays", i1 false}
!385 = !{!"MemStyle", !"Xe"}
!386 = !{!"GlobalDataStyle", !"Xe"}
!387 = !{!"NeedsBTD", i1 true}
!388 = !{!"uberTileDimensions", i1* null}
!389 = !{!"EnableTextureIndirection", i1 false}
!390 = !{!"EnableSamplerIndirection", i1 false}
!391 = !{!"samplerStateStride", i32 0}
!392 = !{!"samplerStateOffset", i32 0}
!393 = !{!"textureStateStride", i32 0}
!394 = !{!"textureStateOffset", i32 0}
!395 = !{!"CurUniqueIndirectIdx", i32 0}
!396 = !{!"inlineDynTextures"}
!397 = !{!"inlineResInfoData"}
!398 = !{!"immConstant", !399, !400, !401}
!399 = !{!"data"}
!400 = !{!"sizes"}
!401 = !{!"zeroIdxs"}
!402 = !{!"stringConstants"}
!403 = !{!"inlineBuffers", !404, !408, !409}
!404 = !{!"inlineBuffersVec[0]", !405, !406, !407}
!405 = !{!"alignment", i32 0}
!406 = !{!"allocSize", i64 0}
!407 = !{!"Buffer"}
!408 = !{!"inlineBuffersVec[1]", !405, !406, !407}
!409 = !{!"inlineBuffersVec[2]", !405, !406, !407}
!410 = !{!"GlobalPointerProgramBinaryInfos"}
!411 = !{!"ConstantPointerProgramBinaryInfos"}
!412 = !{!"GlobalBufferAddressRelocInfo"}
!413 = !{!"ConstantBufferAddressRelocInfo"}
!414 = !{!"forceLscCacheList"}
!415 = !{!"SrvMap"}
!416 = !{!"RootConstantBufferOffsetInBytes"}
!417 = !{!"RasterizerOrderedByteAddressBuffer"}
!418 = !{!"RasterizerOrderedViews"}
!419 = !{!"MinNOSPushConstantSize", i32 0}
!420 = !{!"inlineProgramScopeOffsets"}
!421 = !{!"shaderData", !422}
!422 = !{!"numReplicas", i32 0}
!423 = !{!"URBInfo", !424, !425, !426}
!424 = !{!"has64BVertexHeaderInput", i1 false}
!425 = !{!"has64BVertexHeaderOutput", i1 false}
!426 = !{!"hasVertexHeader", i1 true}
!427 = !{!"m_ForcePullModel", i1 false}
!428 = !{!"UseBindlessImage", i1 false}
!429 = !{!"enableRangeReduce", i1 false}
!430 = !{!"disableNewTrigFuncRangeReduction", i1 false}
!431 = !{!"enableFRemToSRemOpt", i1 false}
!432 = !{!"enableSampleptrToLdmsptrSample0", i1 false}
!433 = !{!"enableSampleLptrToLdmsptrSample0", i1 false}
!434 = !{!"WaForceSIMD32MicropolyRasterize", i1 false}
!435 = !{!"allowMatchMadOptimizationforVS", i1 false}
!436 = !{!"disableMatchMadOptimizationForCS", i1 false}
!437 = !{!"disableMemOptforNegativeOffsetLoads", i1 false}
!438 = !{!"enableThreeWayLoadSpiltOpt", i1 false}
!439 = !{!"statefulResourcesNotAliased", i1 false}
!440 = !{!"disableMixMode", i1 false}
!441 = !{!"genericAccessesResolved", i1 false}
!442 = !{!"disableSeparateSpillPvtScratchSpace", i1 false}
!443 = !{!"enableSeparateSpillPvtScratchSpace", i1 false}
!444 = !{!"disableSeparateScratchWA", i1 false}
!445 = !{!"enableRemoveUnusedTGMFence", i1 false}
!446 = !{!"PrivateMemoryPerFG"}
!447 = !{!"m_OptsToDisable"}
!448 = !{!"capabilities", !449}
!449 = !{!"globalVariableDecorationsINTEL", i1 false}
!450 = !{!"m_ShaderResourceViewMcsMask", !451, !452}
!451 = !{!"m_ShaderResourceViewMcsMaskVec[0]", i64 0}
!452 = !{!"m_ShaderResourceViewMcsMaskVec[1]", i64 0}
!453 = !{!"computedDepthMode", i32 0}
!454 = !{!"isHDCFastClearShader", i1 false}
!455 = !{!"argRegisterReservations", !456}
!456 = !{!"argRegisterReservationsVec[0]", i32 0}
!457 = !{!"SIMD16_SpillThreshold", i8 0}
!458 = !{!"SIMD32_SpillThreshold", i8 0}
!459 = !{!"m_CacheControlOption", !460, !461, !462, !463}
!460 = !{!"LscLoadCacheControlOverride", i8 0}
!461 = !{!"LscStoreCacheControlOverride", i8 0}
!462 = !{!"TgmLoadCacheControlOverride", i8 0}
!463 = !{!"TgmStoreCacheControlOverride", i8 0}
!464 = !{!"ModuleUsesBindless", i1 false}
!465 = !{!"predicationMap"}
