// Code generated by gqlclientgen - DO NOT EDIT.

package gitsrht

import (
	"context"
	"encoding/json"
	"fmt"
	gqlclient "git.sr.ht/~emersion/gqlclient"
)

type ACL struct {
	Id         int32          `json:"id"`
	Created    gqlclient.Time `json:"created"`
	Repository *Repository    `json:"repository"`
	Entity     *Entity        `json:"entity"`
	Mode       *AccessMode    `json:"mode,omitempty"`
}

// A cursor for enumerating access control list entries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type ACLCursor struct {
	Results []ACL   `json:"results"`
	Cursor  *Cursor `json:"cursor,omitempty"`
}

type AccessKind string

const (
	AccessKindRo AccessKind = "RO"
	AccessKindRw AccessKind = "RW"
)

type AccessMode string

const (
	// Read-only
	AccessModeRo AccessMode = "RO"
	// Read/write
	AccessModeRw AccessMode = "RW"
)

type AccessScope string

const (
	AccessScopeProfile      AccessScope = "PROFILE"
	AccessScopeRepositories AccessScope = "REPOSITORIES"
	AccessScopeObjects      AccessScope = "OBJECTS"
	AccessScopeAcls         AccessScope = "ACLS"
)

// Arbitrary file attached to a git repository
type Artifact struct {
	Id       int32          `json:"id"`
	Created  gqlclient.Time `json:"created"`
	Filename string         `json:"filename"`
	Checksum string         `json:"checksum"`
	Size     int32          `json:"size"`
	Url      string         `json:"url"`
}

// A cursor for enumerating artifacts
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type ArtifactCursor struct {
	Results []Artifact `json:"results"`
	Cursor  *Cursor    `json:"cursor,omitempty"`
}

type BinaryBlob struct {
	Type    ObjectType `json:"type"`
	Id      string     `json:"id"`
	ShortId string     `json:"shortId"`
	Raw     string     `json:"raw"`
	Base64  string     `json:"base64"`
}

func (*BinaryBlob) isObject() {}

func (*BinaryBlob) isBlob() {}

type Blob struct {
	Id string `json:"id"`

	// Underlying value of the GraphQL interface
	Value BlobValue `json:"-"`
}

func (base *Blob) UnmarshalJSON(b []byte) error {
	type Raw Blob
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "TextBlob":
		base.Value = new(TextBlob)
	case "BinaryBlob":
		base.Value = new(BinaryBlob)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Blob: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// BlobValue is one of: TextBlob | BinaryBlob
type BlobValue interface {
	isBlob()
}

type Commit struct {
	Type      ObjectType `json:"type"`
	Id        string     `json:"id"`
	ShortId   string     `json:"shortId"`
	Raw       string     `json:"raw"`
	Author    *Signature `json:"author"`
	Committer *Signature `json:"committer"`
	Message   string     `json:"message"`
	Tree      *Tree      `json:"tree"`
	Parents   []Commit   `json:"parents"`
	Diff      string     `json:"diff"`
}

func (*Commit) isObject() {}

// A cursor for enumerating commits
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type CommitCursor struct {
	Results []Commit `json:"results"`
	Cursor  *Cursor  `json:"cursor,omitempty"`
}

type Cursor string

type Entity struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Updated gqlclient.Time `json:"updated"`
	// The canonical name of this entity. For users, this is their username
	// prefixed with '~'. Additional entity types will be supported in the future.
	CanonicalName string `json:"canonicalName"`
	// Returns a specific repository owned by the entity.
	Repository *Repository `json:"repository,omitempty"`
	// Returns a list of repositories owned by the entity.
	Repositories *RepositoryCursor `json:"repositories"`

	// Underlying value of the GraphQL interface
	Value EntityValue `json:"-"`
}

func (base *Entity) UnmarshalJSON(b []byte) error {
	type Raw Entity
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "User":
		base.Value = new(User)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Entity: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// EntityValue is one of: User
type EntityValue interface {
	isEntity()
}

// Describes the status of optional features
type Features struct {
	Artifacts bool `json:"artifacts"`
}

type Filter struct {
	// Number of results to return.
	Count *int32 `json:"count,omitempty"`
	// Search terms. The exact meaning varies by usage, but generally these are
	// compatible with the web UI's search syntax.
	Search *string `json:"search,omitempty"`
}

// This event is used for pre-receive and post-receive git hooks.
type GitEvent struct {
	Uuid       string         `json:"uuid"`
	Event      WebhookEvent   `json:"event"`
	Date       gqlclient.Time `json:"date"`
	Repository *Repository    `json:"repository"`
	Pusher     *Entity        `json:"pusher"`
	Updates    []*UpdatedRef  `json:"updates"`
}

func (*GitEvent) isWebhookPayload() {}

type GitEventInput struct {
	RepositoryID int32              `json:"repositoryID"`
	Event        WebhookEvent       `json:"event"`
	Updates      []*UpdatedRefInput `json:"updates"`
}

type GitWebhookInput struct {
	RepositoryID int32          `json:"repositoryID"`
	Url          string         `json:"url"`
	Events       []WebhookEvent `json:"events"`
	Query        string         `json:"query"`
}

type GitWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
}

func (*GitWebhookSubscription) isWebhookSubscription() {}

type OAuthClient struct {
	Uuid string `json:"uuid"`
}

type Object struct {
	Type    ObjectType `json:"type"`
	Id      string     `json:"id"`
	ShortId string     `json:"shortId"`
	// Raw git object, base64 encoded
	Raw string `json:"raw"`

	// Underlying value of the GraphQL interface
	Value ObjectValue `json:"-"`
}

func (base *Object) UnmarshalJSON(b []byte) error {
	type Raw Object
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "Commit":
		base.Value = new(Commit)
	case "Tree":
		base.Value = new(Tree)
	case "TextBlob":
		base.Value = new(TextBlob)
	case "BinaryBlob":
		base.Value = new(BinaryBlob)
	case "Tag":
		base.Value = new(Tag)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Object: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// ObjectValue is one of: Commit | Tree | TextBlob | BinaryBlob | Tag
type ObjectValue interface {
	isObject()
}

type ObjectType string

const (
	ObjectTypeCommit ObjectType = "COMMIT"
	ObjectTypeTree   ObjectType = "TREE"
	ObjectTypeBlob   ObjectType = "BLOB"
	ObjectTypeTag    ObjectType = "TAG"
)

type Redirect struct {
	Created      gqlclient.Time `json:"created"`
	Name         string         `json:"name"`
	Owner        *Entity        `json:"owner"`
	OriginalPath string         `json:"originalPath"`
	Repository   *Repository    `json:"repository,omitempty"`
}

type Reference struct {
	Name      string          `json:"name"`
	Target    string          `json:"target"`
	Follow    *Object         `json:"follow,omitempty"`
	Artifacts *ArtifactCursor `json:"artifacts"`
}

// A cursor for enumerating a list of references
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type ReferenceCursor struct {
	Results []Reference `json:"results"`
	Cursor  *Cursor     `json:"cursor,omitempty"`
}

type RepoInput struct {
	Name        *string     `json:"name,omitempty"`
	Description *string     `json:"description,omitempty"`
	Visibility  *Visibility `json:"visibility,omitempty"`
	// Updates the custom README associated with this repository. Note that the
	// provided HTML will be sanitized when displayed on the web; see
	// https://man.sr.ht/markdown/#post-processing
	Readme *string `json:"readme,omitempty"`
	// Updates the repository HEAD reference, which serves as the default branch.
	// Must be a valid branch name.
	HEAD *string `json:"HEAD,omitempty"`
}

type Repository struct {
	Id          int32          `json:"id"`
	Created     gqlclient.Time `json:"created"`
	Updated     gqlclient.Time `json:"updated"`
	Owner       *Entity        `json:"owner"`
	Name        string         `json:"name"`
	Description *string        `json:"description,omitempty"`
	Visibility  Visibility     `json:"visibility"`
	// The repository's custom README, if set.
	//
	// NOTICE: This returns unsanitized HTML. It is the client's responsibility to
	// sanitize this for display on the web, if so desired.
	Readme *string `json:"readme,omitempty"`
	// The access that applies to this user for this repository
	Access     AccessMode       `json:"access"`
	Acls       *ACLCursor       `json:"acls"`
	Objects    []*Object        `json:"objects"`
	References *ReferenceCursor `json:"references"`
	// The HEAD reference for this repository (equivalent to the default branch)
	HEAD *Reference `json:"HEAD,omitempty"`
	// Returns a list of comments sorted by committer time (similar to `git log`'s
	// default ordering).
	//
	// If `from` is specified, it is interpreted as a revspec to start logging
	// from. A clever reader may notice that using commits[-1].from + "^" as the
	// from parameter is equivalent to passing the cursor to the next call.
	Log *CommitCursor `json:"log"`
	// Returns a tree entry for a given path, at the given revspec.
	Path *TreeEntry `json:"path,omitempty"`
	// Returns the commit for a given revspec.
	Revparse_single *Commit `json:"revparse_single,omitempty"`
	RepoPath        string  `json:"repoPath"`
}

// A cursor for enumerating a list of repositories
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type RepositoryCursor struct {
	Results []Repository `json:"results"`
	Cursor  *Cursor      `json:"cursor,omitempty"`
}

type RepositoryEvent struct {
	Uuid       string         `json:"uuid"`
	Event      WebhookEvent   `json:"event"`
	Date       gqlclient.Time `json:"date"`
	Repository *Repository    `json:"repository"`
}

func (*RepositoryEvent) isWebhookPayload() {}

// Instance specific settings
type Settings struct {
	SshUser string `json:"sshUser"`
}

type Signature struct {
	Name  string         `json:"name"`
	Email string         `json:"email"`
	Time  gqlclient.Time `json:"time"`
}

type Tag struct {
	Type    ObjectType `json:"type"`
	Id      string     `json:"id"`
	ShortId string     `json:"shortId"`
	Raw     string     `json:"raw"`
	Target  *Object    `json:"target"`
	Name    string     `json:"name"`
	Tagger  *Signature `json:"tagger"`
	Message *string    `json:"message,omitempty"`
}

func (*Tag) isObject() {}

type TextBlob struct {
	Type    ObjectType `json:"type"`
	Id      string     `json:"id"`
	ShortId string     `json:"shortId"`
	Raw     string     `json:"raw"`
	Text    string     `json:"text"`
}

func (*TextBlob) isObject() {}

func (*TextBlob) isBlob() {}

type Tree struct {
	Type    ObjectType       `json:"type"`
	Id      string           `json:"id"`
	ShortId string           `json:"shortId"`
	Raw     string           `json:"raw"`
	Entries *TreeEntryCursor `json:"entries"`
	Entry   *TreeEntry       `json:"entry,omitempty"`
}

func (*Tree) isObject() {}

type TreeEntry struct {
	Id     string  `json:"id"`
	Name   string  `json:"name"`
	Object *Object `json:"object"`
	// Unix-style file mode, i.e. 0755 or 0644 (octal)
	Mode int32 `json:"mode"`
}

// A cursor for enumerating tree entries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type TreeEntryCursor struct {
	Results []TreeEntry `json:"results"`
	Cursor  *Cursor     `json:"cursor,omitempty"`
}

type UpdatedRef struct {
	Ref *Reference `json:"ref,omitempty"`
	Old *Object    `json:"old,omitempty"`
	New *Object    `json:"new,omitempty"`
	// Note: this only returns up to the most recent 50 commits included in the
	// update, i.e. old..new or new~50..new, whichever has fewer commits.
	Log *CommitCursor `json:"log,omitempty"`
	// Difference from old..new in the unified diff format.
	//
	// This field is null if the diff requires more than one second to prepare.
	Diff *string `json:"diff,omitempty"`
}

type UpdatedRefInput struct {
	Ref string `json:"ref"`
	Old string `json:"old"`
	New string `json:"new"`
}

type User struct {
	Id            int32             `json:"id"`
	Created       gqlclient.Time    `json:"created"`
	Updated       gqlclient.Time    `json:"updated"`
	CanonicalName string            `json:"canonicalName"`
	Username      string            `json:"username"`
	Email         string            `json:"email"`
	Url           *string           `json:"url,omitempty"`
	Location      *string           `json:"location,omitempty"`
	Bio           *string           `json:"bio,omitempty"`
	Repository    *Repository       `json:"repository,omitempty"`
	Repositories  *RepositoryCursor `json:"repositories"`
}

func (*User) isEntity() {}

type UserWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type UserWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
}

func (*UserWebhookSubscription) isWebhookSubscription() {}

type Version struct {
	Major int32 `json:"major"`
	Minor int32 `json:"minor"`
	Patch int32 `json:"patch"`
	// If this API version is scheduled for deprecation, this is the date on which
	// it will stop working; or null if this API version is not scheduled for
	// deprecation.
	DeprecationDate gqlclient.Time `json:"deprecationDate,omitempty"`
	// Optional features
	Features *Features `json:"features"`
	// Config settings
	Settings *Settings `json:"settings"`
}

type Visibility string

const (
	// Visible to everyone, listed on your profile
	VisibilityPublic Visibility = "PUBLIC"
	// Visible to everyone (if they know the URL), not listed on your profile
	VisibilityUnlisted Visibility = "UNLISTED"
	// Not visible to anyone except those explicitly added to the access list
	VisibilityPrivate Visibility = "PRIVATE"
)

type WebhookDelivery struct {
	Uuid         string               `json:"uuid"`
	Date         gqlclient.Time       `json:"date"`
	Event        WebhookEvent         `json:"event"`
	Subscription *WebhookSubscription `json:"subscription"`
	RequestBody  string               `json:"requestBody"`
	// These details are provided only after a response is received from the
	// remote server. If a response is sent whose Content-Type is not text/*, or
	// cannot be decoded as UTF-8, the response body will be null. It will be
	// truncated after 64 KiB.
	ResponseBody    *string `json:"responseBody,omitempty"`
	ResponseHeaders *string `json:"responseHeaders,omitempty"`
	ResponseStatus  *int32  `json:"responseStatus,omitempty"`
}

// A cursor for enumerating a list of webhook deliveries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookDeliveryCursor struct {
	Results []WebhookDelivery `json:"results"`
	Cursor  *Cursor           `json:"cursor,omitempty"`
}

type WebhookEvent string

const (
	WebhookEventRepoCreated    WebhookEvent = "REPO_CREATED"
	WebhookEventRepoUpdate     WebhookEvent = "REPO_UPDATE"
	WebhookEventRepoDeleted    WebhookEvent = "REPO_DELETED"
	WebhookEventGitPreReceive  WebhookEvent = "GIT_PRE_RECEIVE"
	WebhookEventGitPostReceive WebhookEvent = "GIT_POST_RECEIVE"
)

type WebhookPayload struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`

	// Underlying value of the GraphQL interface
	Value WebhookPayloadValue `json:"-"`
}

func (base *WebhookPayload) UnmarshalJSON(b []byte) error {
	type Raw WebhookPayload
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "RepositoryEvent":
		base.Value = new(RepositoryEvent)
	case "GitEvent":
		base.Value = new(GitEvent)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookPayload: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookPayloadValue is one of: RepositoryEvent | GitEvent
type WebhookPayloadValue interface {
	isWebhookPayload()
}

type WebhookSubscription struct {
	Id     int32          `json:"id"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
	Url    string         `json:"url"`
	// If this webhook was registered by an authorized OAuth 2.0 client, this
	// field is non-null.
	Client *OAuthClient `json:"client,omitempty"`
	// All deliveries which have been sent to this webhook.
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	// Returns a sample payload for this subscription, for testing purposes
	Sample string `json:"sample"`

	// Underlying value of the GraphQL interface
	Value WebhookSubscriptionValue `json:"-"`
}

func (base *WebhookSubscription) UnmarshalJSON(b []byte) error {
	type Raw WebhookSubscription
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "UserWebhookSubscription":
		base.Value = new(UserWebhookSubscription)
	case "GitWebhookSubscription":
		base.Value = new(GitWebhookSubscription)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookSubscription: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookSubscriptionValue is one of: UserWebhookSubscription | GitWebhookSubscription
type WebhookSubscriptionValue interface {
	isWebhookSubscription()
}

// A cursor for enumerating a list of webhook subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookSubscriptionCursor struct {
	Results []WebhookSubscription `json:"results"`
	Cursor  *Cursor               `json:"cursor,omitempty"`
}

func RepositoryIDByName(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query repositoryIDByName ($name: String!) {\n\tme {\n\t\trepository(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func RepositoryIDByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query repositoryIDByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\trepository(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func ListArtifacts(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query listArtifacts ($name: String!) {\n\tme {\n\t\trepository(name: $name) {\n\t\t\t... artifacts\n\t\t}\n\t}\n}\nfragment artifacts on Repository {\n\treferences {\n\t\tresults {\n\t\t\tname\n\t\t\tartifacts {\n\t\t\t\tresults {\n\t\t\t\t\tid\n\t\t\t\t\tfilename\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func ListArtifactsByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query listArtifactsByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\trepository(name: $name) {\n\t\t\t... artifacts\n\t\t}\n\t}\n}\nfragment artifacts on Repository {\n\treferences {\n\t\tresults {\n\t\t\tname\n\t\t\tartifacts {\n\t\t\t\tresults {\n\t\t\t\t\tid\n\t\t\t\t\tfilename\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func RepositoryByName(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query repositoryByName ($name: String!) {\n\tme {\n\t\trepository(name: $name) {\n\t\t\t... repository\n\t\t}\n\t}\n}\nfragment repository on Repository {\n\tname\n\tdescription\n\tvisibility\n\treferences {\n\t\tresults {\n\t\t\tname\n\t\t}\n\t}\n\tlog {\n\t\tresults {\n\t\t\tshortId\n\t\t\tauthor {\n\t\t\t\tname\n\t\t\t\temail\n\t\t\t\ttime\n\t\t\t}\n\t\t\tmessage\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func RepositoryByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query repositoryByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\trepository(name: $name) {\n\t\t\t... repository\n\t\t}\n\t}\n}\nfragment repository on Repository {\n\tname\n\tdescription\n\tvisibility\n\treferences {\n\t\tresults {\n\t\t\tname\n\t\t}\n\t}\n\tlog {\n\t\tresults {\n\t\t\tshortId\n\t\t\tauthor {\n\t\t\t\tname\n\t\t\t\temail\n\t\t\t\ttime\n\t\t\t}\n\t\t\tmessage\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func Repositories(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (repositories *RepositoryCursor, err error) {
	op := gqlclient.NewOperation("query repositories ($cursor: Cursor) {\n\trepositories(cursor: $cursor) {\n\t\t... repos\n\t}\n}\nfragment repos on RepositoryCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Repositories *RepositoryCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Repositories, err
}

func RepositoriesByUser(client *gqlclient.Client, ctx context.Context, username string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query repositoriesByUser ($username: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\trepositories(cursor: $cursor) {\n\t\t\t... repos\n\t\t}\n\t}\n}\nfragment repos on RepositoryCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("username", username)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func ExportRepository(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query exportRepository ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\trepository(name: $name) {\n\t\t\t... repositoryExport\n\t\t}\n\t}\n}\nfragment repositoryExport on Repository {\n\tname\n\towner {\n\t\tcanonicalName\n\t}\n\tdescription\n\tvisibility\n\treadme\n\tHEAD {\n\t\tname\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func ExportRepositories(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (repositories *RepositoryCursor, err error) {
	op := gqlclient.NewOperation("query exportRepositories ($cursor: Cursor) {\n\trepositories(cursor: $cursor) {\n\t\tresults {\n\t\t\t... repositoryExport\n\t\t}\n\t\tcursor\n\t}\n}\nfragment repositoryExport on Repository {\n\tname\n\towner {\n\t\tcanonicalName\n\t}\n\tdescription\n\tvisibility\n\treadme\n\tHEAD {\n\t\tname\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Repositories *RepositoryCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Repositories, err
}

func SshSettings(client *gqlclient.Client, ctx context.Context) (version *Version, err error) {
	op := gqlclient.NewOperation("query sshSettings {\n\tversion {\n\t\tsettings {\n\t\t\tsshUser\n\t\t}\n\t}\n}\n")
	var respData struct {
		Version *Version
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Version, err
}

func CompleteRepositories(client *gqlclient.Client, ctx context.Context) (repositories *RepositoryCursor, err error) {
	op := gqlclient.NewOperation("query completeRepositories {\n\trepositories {\n\t\tresults {\n\t\t\tname\n\t\t}\n\t}\n}\n")
	var respData struct {
		Repositories *RepositoryCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Repositories, err
}

func RevsByRepoName(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query revsByRepoName ($name: String!) {\n\tme {\n\t\trepository(name: $name) {\n\t\t\t... revs\n\t\t}\n\t}\n}\nfragment revs on Repository {\n\treferences {\n\t\tresults {\n\t\t\tname\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func RevsByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query revsByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\trepository(name: $name) {\n\t\t\t... revs\n\t\t}\n\t}\n}\nfragment revs on Repository {\n\treferences {\n\t\tresults {\n\t\t\tname\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func AclByRepoName(client *gqlclient.Client, ctx context.Context, name string, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query aclByRepoName ($name: String!, $cursor: Cursor) {\n\tme {\n\t\t... acl\n\t}\n}\nfragment acl on User {\n\trepository(name: $name) {\n\t\tacls(cursor: $cursor) {\n\t\t\tresults {\n\t\t\t\tid\n\t\t\t\tcreated\n\t\t\t\tentity {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t\tmode\n\t\t\t}\n\t\t\tcursor\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func AclByUser(client *gqlclient.Client, ctx context.Context, username string, name string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query aclByUser ($username: String!, $name: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\t... acl\n\t}\n}\nfragment acl on User {\n\trepository(name: $name) {\n\t\tacls(cursor: $cursor) {\n\t\t\tresults {\n\t\t\t\tid\n\t\t\t\tcreated\n\t\t\t\tentity {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t\tmode\n\t\t\t}\n\t\t\tcursor\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func UserWebhooks(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (userWebhooks *WebhookSubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query userWebhooks ($cursor: Cursor) {\n\tuserWebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		UserWebhooks *WebhookSubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserWebhooks, err
}

func CompleteCoMaintainers(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query completeCoMaintainers ($name: String!) {\n\tme {\n\t\trepository(name: $name) {\n\t\t\tacls {\n\t\t\t\tresults {\n\t\t\t\t\tentity {\n\t\t\t\t\t\tcanonicalName\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func GitWebhooks(client *gqlclient.Client, ctx context.Context, repositoryID int32, cursor *Cursor) (gitWebhooks *WebhookSubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query gitWebhooks ($repositoryID: Int!, $cursor: Cursor) {\n\tgitWebhooks(repositoryID: $repositoryID, cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("repositoryID", repositoryID)
	op.Var("cursor", cursor)
	var respData struct {
		GitWebhooks *WebhookSubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.GitWebhooks, err
}

func UploadArtifact(client *gqlclient.Client, ctx context.Context, repoId int32, revspec string, file gqlclient.Upload) (uploadArtifact *Artifact, err error) {
	op := gqlclient.NewOperation("mutation uploadArtifact ($repoId: Int!, $revspec: String!, $file: Upload!) {\n\tuploadArtifact(repoId: $repoId, revspec: $revspec, file: $file) {\n\t\tfilename\n\t}\n}\n")
	op.Var("repoId", repoId)
	op.Var("revspec", revspec)
	op.Var("file", file)
	var respData struct {
		UploadArtifact *Artifact
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UploadArtifact, err
}

func DeleteArtifact(client *gqlclient.Client, ctx context.Context, id int32) (deleteArtifact *Artifact, err error) {
	op := gqlclient.NewOperation("mutation deleteArtifact ($id: Int!) {\n\tdeleteArtifact(id: $id) {\n\t\tfilename\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteArtifact *Artifact
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteArtifact, err
}

func CreateRepository(client *gqlclient.Client, ctx context.Context, name string, visibility Visibility, description *string, cloneUrl *string) (createRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation createRepository ($name: String!, $visibility: Visibility!, $description: String, $cloneUrl: String) {\n\tcreateRepository(name: $name, visibility: $visibility, description: $description, cloneUrl: $cloneUrl) {\n\t\tid\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t\tname\n\t}\n}\n")
	op.Var("name", name)
	op.Var("visibility", visibility)
	op.Var("description", description)
	op.Var("cloneUrl", cloneUrl)
	var respData struct {
		CreateRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateRepository, err
}

func DeleteRepository(client *gqlclient.Client, ctx context.Context, id int32) (deleteRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation deleteRepository ($id: Int!) {\n\tdeleteRepository(id: $id) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteRepository, err
}

func UpdateACL(client *gqlclient.Client, ctx context.Context, repoId int32, mode AccessMode, entity string) (updateACL *ACL, err error) {
	op := gqlclient.NewOperation("mutation updateACL ($repoId: Int!, $mode: AccessMode!, $entity: ID!) {\n\tupdateACL(repoId: $repoId, mode: $mode, entity: $entity) {\n\t\tentity {\n\t\t\tcanonicalName\n\t\t}\n\t}\n}\n")
	op.Var("repoId", repoId)
	op.Var("mode", mode)
	op.Var("entity", entity)
	var respData struct {
		UpdateACL *ACL
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateACL, err
}

func DeleteACL(client *gqlclient.Client, ctx context.Context, id int32) (deleteACL *ACL, err error) {
	op := gqlclient.NewOperation("mutation deleteACL ($id: Int!) {\n\tdeleteACL(id: $id) {\n\t\tentity {\n\t\t\tcanonicalName\n\t\t}\n\t\trepository {\n\t\t\tname\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteACL *ACL
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteACL, err
}

func DeleteUserWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteUserWebhook ($id: Int!) {\n\tdeleteUserWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteUserWebhook, err
}

func CreateUserWebhook(client *gqlclient.Client, ctx context.Context, config UserWebhookInput) (createUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createUserWebhook ($config: UserWebhookInput!) {\n\tcreateUserWebhook(config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("config", config)
	var respData struct {
		CreateUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateUserWebhook, err
}

func UpdateRepository(client *gqlclient.Client, ctx context.Context, id int32, input RepoInput) (updateRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation updateRepository ($id: Int!, $input: RepoInput!) {\n\tupdateRepository(id: $id, input: $input) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	op.Var("input", input)
	var respData struct {
		UpdateRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateRepository, err
}

func ClearCustomReadme(client *gqlclient.Client, ctx context.Context, id int32) (updateRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation clearCustomReadme ($id: Int!) {\n\tupdateRepository(id: $id, input: {readme:null}) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		UpdateRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateRepository, err
}

func ClearDescription(client *gqlclient.Client, ctx context.Context, id int32) (updateRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation clearDescription ($id: Int!) {\n\tupdateRepository(id: $id, input: {description:null}) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		UpdateRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateRepository, err
}

func CreateGitWebhook(client *gqlclient.Client, ctx context.Context, config GitWebhookInput) (createGitWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createGitWebhook ($config: GitWebhookInput!) {\n\tcreateGitWebhook(config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("config", config)
	var respData struct {
		CreateGitWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateGitWebhook, err
}

func DeleteGitWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteGitWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteGitWebhook ($id: Int!) {\n\tdeleteGitWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteGitWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteGitWebhook, err
}
