// Code generated by smithy-go-codegen DO NOT EDIT.

package taxsettings

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/taxsettings/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds or updates tax registration for multiple accounts in batch. This can be
// used to add or update tax registrations for up to five accounts in one batch.
// You can't set a TRN if there's a pending TRN. You'll need to delete the pending
// TRN first.
//
// To call this API operation for specific countries, see the following
// country-specific requirements.
//
// Bangladesh
//
//   - You must specify the tax registration certificate document in the
//     taxRegistrationDocuments field of the VerificationDetails object.
//
// Brazil
//
//   - You must complete the tax registration process in the [Payment preferences]page in the Billing
//     and Cost Management console. After your TRN and billing address are verified,
//     you can call this API operation.
//
//   - For Amazon Web Services accounts created through Organizations, you can
//     call this API operation when you don't have a billing address.
//
// Georgia
//
//   - The valid personType values are Physical Person and Business .
//
// Kenya
//
//   - You must specify the personType in the kenyaAdditionalInfo field of the
//     additionalTaxInformation object.
//
//   - If the personType is Physical Person , you must specify the tax registration
//     certificate document in the taxRegistrationDocuments field of the
//     VerificationDetails object.
//
// Malaysia
//
//   - If you use this operation to set a tax registration number (TRN) in
//     Malaysia, only resellers with a valid sales and service tax (SST) number are
//     required to provide tax registration information.
//
//   - By using this API operation to set a TRN in Malaysia, Amazon Web Services
//     will regard you as self-declaring that you're an authorized business reseller
//     registered with the Royal Malaysia Customs Department (RMCD) and have a valid
//     SST number.
//
//   - Amazon Web Services reserves the right to seek additional information
//     and/or take other actions to support your self-declaration as appropriate.
//
//   - If you're not a reseller of Amazon Web Services, we don't recommend that
//     you use this operation to set the TRN in Malaysia.
//
//   - Only use this API operation to upload the TRNs for accounts through which
//     you're reselling Amazon Web Services.
//
//   - Amazon Web Services is currently registered under the following service tax
//     codes. You must include at least one of the service tax codes in the service tax
//     code strings to declare yourself as an authorized registered business reseller.
//
// Taxable service and service tax codes:
//
// # Consultancy - 9907061674
//
// # Training or coaching service - 9907071685
//
// # IT service - 9907101676
//
// # Digital services and electronic medium - 9907121690
//
// Nepal
//
//   - The sector valid values are Business and Individual .
//
// Saudi Arabia
//
//   - For address , you must specify addressLine3 .
//
// South Korea
//
//   - You must specify the certifiedEmailId and legalName in the
//     TaxRegistrationEntry object. Use Korean characters for legalName .
//
//   - You must specify the businessRepresentativeName , itemOfBusiness , and
//     lineOfBusiness in the southKoreaAdditionalInfo field of the
//     additionalTaxInformation object. Use Korean characters for these fields.
//
//   - You must specify the tax registration certificate document in the
//     taxRegistrationDocuments field of the VerificationDetails object.
//
//   - For the address object, use Korean characters for addressLine1 ,
//     addressLine2 city , postalCode , and stateOrRegion .
//
// Spain
//
//   - You must specify the registrationType in the spainAdditionalInfo field of
//     the additionalTaxInformation object.
//
//   - If the registrationType is Local , you must specify the tax registration
//     certificate document in the taxRegistrationDocuments field of the
//     VerificationDetails object.
//
// Turkey
//
//   - You must specify the sector in the taxRegistrationEntry object.
//
//   - If your sector is Business , Individual , or Government :
//
//   - Specify the taxOffice . If your sector is Individual , don't enter this
//     value.
//
//   - (Optional) Specify the kepEmailId . If your sector is Individual , don't
//     enter this value.
//
//   - Note: In the Tax Settings page of the Billing console, Government appears as
//     Public institutions
//
//   - If your sector is Business and you're subject to KDV tax, you must specify
//     your industry in the industries field.
//
//   - For address , you must specify districtOrCounty .
//
// Ukraine
//
//   - The sector valid values are Business and Individual .
//
// [Payment preferences]: https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods
func (c *Client) BatchPutTaxRegistration(ctx context.Context, params *BatchPutTaxRegistrationInput, optFns ...func(*Options)) (*BatchPutTaxRegistrationOutput, error) {
	if params == nil {
		params = &BatchPutTaxRegistrationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchPutTaxRegistration", params, optFns, c.addOperationBatchPutTaxRegistrationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchPutTaxRegistrationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchPutTaxRegistrationInput struct {

	//  List of unique account identifiers.
	//
	// This member is required.
	AccountIds []string

	// Your TRN information that will be stored to the accounts mentioned in putEntries
	// .
	//
	// This member is required.
	TaxRegistrationEntry *types.TaxRegistrationEntry

	noSmithyDocumentSerde
}

type BatchPutTaxRegistrationOutput struct {

	// List of errors for the accounts the TRN information could not be added or
	// updated to.
	//
	// This member is required.
	Errors []types.BatchPutTaxRegistrationError

	// The status of your TRN stored in the system after processing. Based on the
	// validation occurring on the TRN, the status can be Verified , Pending or
	// Rejected .
	Status types.TaxRegistrationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchPutTaxRegistrationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchPutTaxRegistration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchPutTaxRegistration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchPutTaxRegistration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpBatchPutTaxRegistrationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchPutTaxRegistration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchPutTaxRegistration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchPutTaxRegistration",
	}
}
