package main

import (
	"context"
	"flag"
	"fmt"
	"os"
	"strings"

	"github.com/google/subcommands"
	"github.com/kotakanbe/go-cve-dictionary/commands"
)

// Name ... Name
const Name string = "go-cve-dictionary"

// Version ... Version
var version = "0.2.0"

// Revision of Git
var revision string

func main() {
	subcommands.Register(subcommands.HelpCommand(), "")
	subcommands.Register(subcommands.FlagsCommand(), "")
	subcommands.Register(subcommands.CommandsCommand(), "")
	subcommands.Register(&commands.ServerCmd{}, "server")
	subcommands.Register(&commands.FetchJvnCmd{}, "fetchjvn")
	subcommands.Register(&commands.FetchNvdCmd{}, "fetchnvd")
	subcommands.Register(&commands.ListCmd{}, "list")

	var v = flag.Bool("v", false, "Show version")

	if envArgs := os.Getenv("GO_CVE_DICTIONARY_ARGS"); 0 < len(envArgs) {
		flag.CommandLine.Parse(strings.Fields(envArgs))
	} else {
		flag.Parse()
	}

	if *v {
		fmt.Printf("go-cve-dictionary %s %s\n", version, revision)
		os.Exit(int(subcommands.ExitSuccess))
	}

	ctx := context.Background()
	os.Exit(int(subcommands.Execute(ctx)))
}
