% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci}
\alias{ci}
\alias{ci.numeric}
\alias{ci.binom}
\alias{ci.lm}
\alias{ci.lme}
\alias{ci.estimable}
\alias{ci.fit_contrast}
\title{Compute Confidence Intervals}
\usage{
ci(x, confidence = 0.95, alpha = 1 - confidence, ...)

\method{ci}{numeric}(x, confidence = 0.95, alpha = 1 - confidence, na.rm = FALSE, ...)
}
\arguments{
\item{x}{object from which to compute confidence intervals.}

\item{confidence}{confidence level. Defaults to 0.95.}

\item{alpha}{type one error rate.  Defaults to 1.0-\code{confidence}}

\item{\dots}{Arguments for methods}

\item{na.rm}{\code{logical} indicating whether missing values should be removed.}
}
\value{
vector or matrix with one row per model parameter and
elements/columns \code{Estimate}, \verb{CI lower}, \verb{CI upper},
\verb{Std. Error}, \code{DF} (for lme objects only), and \code{p-value}.
}
\description{
Compute and display confidence intervals for model estimates.  Methods are
provided for the mean of a numeric vector \code{ci.default}, the probability
of a binomial vector \code{ci.binom}, and for \code{lm}, \code{lme}, and
\code{mer} objects are provided.
}
\examples{


# mean and confidence interval
ci( rnorm(10) )

# binomial proportion and exact confidence interval
b <- rbinom( prob=0.75, size=1, n=20 )
ci.binom(b) # direct call
class(b) <- 'binom'
ci(b)       # indirect call

# confidence intervals for regression parameteres
data(state)
reg  <-  lm(Area ~ Population, data=as.data.frame(state.x77))
ci(reg)

}
\seealso{
\code{\link[stats:confint]{stats::confint()}}, \code{\link[stats:lm]{stats::lm()}},
\code{\link[stats:summary.lm]{stats::summary.lm()}}
}
\author{
Gregory R. Warnes \email{greg@warnes.net}
}
\keyword{regression}
