/*
 *  
 *  $Id: imprimevistasimple.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-14 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "simpleviewexportdelegate.h"
#include <api/istudycontext.h>
#include "gvistacompleja.h"
#include "gvistasimple.h"

#include <vtk/vtkginkgoimageviewer.h>
#include <vtkSmartPointer.h>
#include <vtkObject.h>
#include <vtkRenderer.h>
#include <vtkPointData.h>
#include <vtkImageData.h>
#include <vtkMatrix4x4.h>
#include <vtkImageReslice.h>
#include <vtkImageMapToRGBA.h>
#include <vtkExecutive.h>
#include <vtkInformationVector.h>
#include <vtkAlgorithmOutput.h>
#include <vtkInformation.h>
#include <vtkScalarsToColors.h>

namespace GNKVisualizator {

	SimpleViewExportDelegate::SimpleViewExportDelegate(GNC::GCS::IImageExportContract* exportContract, GVistaCompleja* pView): m_pView(pView),
		GNC::GCS::IImageExportDelegate(exportContract),
		ImageMap(vtkImageMapToRGBA::New())
	{
		//setup scalars to colors
		vtkScalarsToColors* pTabla = m_pView->IVista->GetEstudio()->Viewer->GetLookupTable();
		ImageMap->SetLookupTable(pTabla);
		ImageMap->SetOutputFormatToRGB();
	}

	SimpleViewExportDelegate::~SimpleViewExportDelegate()
	{
		ImageMap->Delete();
	}

	GNC::GCS::IVista* SimpleViewExportDelegate::GetView()
	{
		return m_pView->IVista;
	}

	void SimpleViewExportDelegate::GetCurrentImage(ImageType::Pointer& ptrImage, TValorationMaps& mapasValoracion, bool conWidgets, const GNC::GCS::Vector& size)
	{
		GetImage(ptrImage, m_pView->IVista->GetEstudio()->ActiveFileIndex, mapasValoracion, conWidgets, size);
	}

	void SimpleViewExportDelegate::GetImage(ImageType::Pointer& ptrImage, int index, TValorationMaps& /*mapasValoracion*/, bool conWidgets, const GNC::GCS::Vector& size)
	{
		vtkSmartPointer<vtkGinkgoImageViewer>& Viewer = m_pView->IVista->GetEstudio()->Viewer;
		if (!Viewer->IsInstalledAndInitialized())
			return ;

		if(Viewer->GetNumberOfComponents() == 3) {
			Print(GetVtkImage(index), conWidgets, index, size, ptrImage, m_pView->m_pManager);
		} else {
			vtkSmartPointer<vtkImageData> input = GetVtkImage(index);
			ImageMap->SetInput(input);
			ImageMap->Update();
			Print(ImageMap->GetOutput(), conWidgets, index, size, ptrImage, m_pView->m_pManager);
		}		
	}

	int SimpleViewExportDelegate::GetNumberOfSlices()
	{
		return m_pView->IVista->GetEstudio()->GetSliceNumber();
	}

	GNC::GCS::IImageExportDelegate::TValorationMaps SimpleViewExportDelegate::GetValorationMaps()
	{
		GNC::GCS::IImageExportDelegate::TValorationMaps maps;
		return maps;
	}


	SimpleViewExportContractDelegate::SimpleViewExportContractDelegate(GVistaCompleja* pView): m_pView(pView)
	{
	}

	SimpleViewExportContractDelegate::~SimpleViewExportContractDelegate()
	{
	}

	GNC::GCS::Ptr<GNC::GCS::IImageExportDelegate> SimpleViewExportContractDelegate::GetNewExportDelegate()
	{
		GNC::GCS::Ptr<GNC::GCS::IImageExportDelegate> pReturn(new SimpleViewExportDelegate(this, m_pView));
		return pReturn;
	}

	GNC::GCS::IVista* SimpleViewExportContractDelegate::GetView()
	{
		return m_pView->IVista;
	}

	bool SimpleViewExportContractDelegate::CanBeExported()
	{
		return m_pView->m_VistasSimples.front()->ViewImage2D->IsInstalledAndInitialized();
	}
}

