/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.FillerPlayer;
import friendless.games.filler.PlayerRating;
import friendless.games.filler.PlayerRatings;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class PlayerWrapper {
    Class fpClass;
    boolean enabled;
    String name;
    String className;
    PlayerRating rating;
    ResourceBundle resources;
    String icon;

    public PlayerWrapper(String string, ResourceBundle resourceBundle) {
        this.resources = resourceBundle;
        this.enabled = true;
        try {
            this.className = string;
            this.fpClass = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
    }

    public void setRatings() {
        this.rating = PlayerRatings.includePlayer(this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlayerWrapper)) {
            return false;
        }
        PlayerWrapper playerWrapper = (PlayerWrapper)object;
        return this.getFullName().equals(playerWrapper.getFullName());
    }

    public String getFullName() {
        if (this.name == null) {
            this.getDetailsFromClass();
        }
        return this.className + "/" + this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    void getDetailsFromClass() {
        try {
            FillerPlayer fillerPlayer = this.getInstance();
            this.name = fillerPlayer.getName();
            this.icon = fillerPlayer.getIcon();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        if (this.name == null) {
            this.getDetailsFromClass();
        }
        try {
            return this.resources.getString("player.name." + this.name);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return this.name;
        }
    }

    public String getIcon() {
        if (this.icon == null) {
            this.getDetailsFromClass();
        }
        return this.icon;
    }

    Class getPlayerClass() {
        return this.fpClass;
    }

    FillerPlayer getInstance() {
        try {
            return (FillerPlayer)this.fpClass.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    int[] getRecordAgainst(PlayerWrapper playerWrapper) {
        return this.rating.getRecordAgainst(playerWrapper);
    }

    String getShortHeadToHead(PlayerWrapper playerWrapper) {
        return this.rating.getShortHeadToHead(playerWrapper);
    }

    int getRating() {
        return this.rating.rating;
    }

    public String toString() {
        return this.getName() + " (" + this.getRating() + ")";
    }

    public String getDescription() {
        if (this.name == null) {
            this.getDetailsFromClass();
        }
        try {
            return this.resources.getString("description." + this.name);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return "{0}";
        }
    }
}

