#!/usr/bin/env python

import pygtk ; pygtk.require('2.0')
import gtk
from gtk import gdk,glade
import  gobject
import signal, sys, os
import ffxml
import pygame, pygame.key

STANDALONE = 0
NETWORKSERV = 1
NETWORKCLIENT = 2

class ConfigDialog:
  def __init__(self,dialogwidget,xml):
    self.xml = xml
    self.dialogwidget = dialogwidget
# setting up event handlers
    funcmap = {}
    for key in dir(self.__class__):
      if key[:3] == 'on_':
        funcmap[key] = getattr(self,key)
    xml.signal_autoconnect(funcmap)

  def run(self):
    self.loadconfigfile()
    xml = self.xml
# resolution 
    xml.get_widget('xresolution').set_value(self.config.resolution[0])
    xml.get_widget('yresolution').set_value(self.config.resolution[1])
# hostname
    if self.config.hostname == None:
      xml.get_widget('hostname').set_sensitive(False)
      xml.get_widget('enablehostname').set_active(False)
    else:
      xml.get_widget('hostname').set_sensitive(True)
      xml.get_widget('hostname').set_text(self.config.hostname)
      xml.get_widget('enablehostname').set_active(True)
# players
    self.createplayerconfig()
## start the stuff
    self.dialogwidget.show()
    if self.dialogwidget.run() == gtk.RESPONSE_OK:
      self.saveconfigfile()
    self.dialogwidget.hide()
    self.clearplayerconfig()

  def createplayerconfig(self):
    notebook = self.xml.get_widget('confignotebook')
    maxid = 1
    list = self.config.get_playerids()
    if (len(list) > 0):
      list.sort(lambda x,y: x < y)
      maxid = list[-1]
    for x in range(0,maxid+1):
      if not x in list:
        self.config.add_player(x,"Player " + str(x))
      w = self.createplayerwidget(notebook,x)

  def clearplayerconfig(self):
    notebook = self.xml.get_widget('confignotebook')
    for x in range(0,len(self.config.get_playerids())):
      notebook.remove_page(1)

  def playernamechange(self, entry,id):
    self.config.set_playername(id,entry.get_text())

  def createplayerwidget(self,notebook,id):
    f = gtk.Frame()
    t = gtk.Table(4,2,True);
    t.set_row_spacings(3)
    t.set_col_spacings(3)
# name configuration
    t.attach(gtk.Label("Name:"),0,1,0,1)
    entry = gtk.Entry()
    entry.set_text(self.config.get_playername(id))
    entry.connect('changed',self.playernamechange,id)
    t.attach(entry,1,2,0,1)
    pygame.display.init()
# keys configuration
    i = 1
    for x in ['throw','jump','left','right']:
      t.attach(gtk.Label(x + ':'),0,1,i,i+1)

      keys = self.config.get_playerkeys(id,x)
      for k in keys[1:]:
        self.config.del_playerkey(id,k)
     
      if len(keys) == 0:
        key = -1
      else:
        key = int(keys[0][1])
      b = gtk.Button(pygame.key.name(key))
      b.connect('clicked',self.grabbutton,(id,x))
      t.attach(b,1,2,i,i+1)
      i += 1

    f.add(t)
    f.show_all()
    notebook.append_page(f,gtk.Label('player ' + str(id)))
    pygame.display.quit()

  def grabbutton(self,gtkwidget,info):
    (id,action) = info
    pygame.display.init()
    a = pygame.display.set_mode((240,160))
    a.fill((0xff,0xff,0xff))
    f = pygame.font.Font(None,30)
    s = f.render('Please press the ',True,(0,0,0))
    a.blit(s,(30,30))
    s = f.render('button for ' + action,True,(0,0,0))
    a.blit(s,(30,70))
    pygame.display.update()
    pygame.event.set_grab(1)
    pygame.event.set_grab(0)
    while True:
      while gtk.events_pending():
        gtk.main_iteration()
      event = pygame.event.wait()
      pygame.display.update()
      if event.type == pygame.QUIT:
        print 'quit event'
        break;
      elif event.type == pygame.KEYDOWN:
        if event.key != pygame.K_ESCAPE:
          k = self.config.get_playerkeys(id,action)
          map(lambda x: self.config.del_playerkey(id,x),k)
          self.config.add_playerkey(id,(action,event.key))
          gtkwidget.set_label(pygame.key.name(event.key))
        break
    pygame.display.quit()
    return True

  def saveconfigfile(self):
    dir = os.getenv('HOME') + '/.ffrenzy/'
    self.config.resolution = (
                          self.xml.get_widget('xresolution').get_value_as_int(),
                          self.xml.get_widget('yresolution').get_value_as_int()
                        )
    if self.xml.get_widget('enablehostname').get_active():
      self.config.hostname = self.xml.get_widget('hostname').get_text()
    else:
      self.config.hostname = None

    try: 
      os.makedirs(dir)
    except OSError,error:
      if error.errno != 17:
        raise(error)

    file = open(dir + 'config.xml','w')
    file.write(self.config.toxml())
    file.close()

  def loadconfigfile(self):
    try:
      self.config = ffxml.ffconfigxml(os.getenv('HOME') 
                                      + '/.ffrenzy/config.xml')
    except IOError, error:
      if error.errno == 2:
        d = gtk.MessageDialog(None,gtk.DIALOG_MODAL,0,
                          gtk.BUTTONS_OK,
                          'Failed to load configuration failed. using defaults',
                         )
        d.run()
        d.destroy()
        self.config = ffxml.ffconfigxml(None)
      else:
        raise(error)

  def on_enablehostname_toggled(self,widget,*args):
    self.xml.get_widget('hostname').set_sensitive(widget.get_active())

  def on_playerremove_clicked(self,widget,*args):
    ids = self.config.get_playerids()
    if len(ids) == 0:
      return
    self.config.del_player(max(ids))
    notebook = self.xml.get_widget('confignotebook')
    notebook.remove_page(max(ids) + 1)

  def on_playeradd_clicked(self,widget,*args):
    ids = self.config.get_playerids()
    ids.append(-1)
    x = max(ids) + 1
    self.config.add_player(x,"Player " + str(x))
    self.createplayerwidget(self.xml.get_widget('confignotebook'),x)

class Program:
  def __init__(self,gladefile,binary,leveldir):
    gxml = self.xml = glade.XML(gladefile)
    funcmap = {}
    for key in dir(self.__class__):
      if key[:3] == 'on_':
        funcmap[key] = getattr(self,key)

    gxml.signal_autoconnect(funcmap)
    self.configdialog = None
    self.binary = binary
    self.leveldir = leveldir
    self.gametype = STANDALONE
    gxml.get_widget('standalone').set_active(True)
    gxml.get_widget('servername').set_sensitive(False)
    gxml.get_widget('totalplayers').set_sensitive(False)
    gxml.get_widget('servername').set_text('hostname')

    store = self.store = self.load_levels(leveldir)
    self.treeview = treeview = gxml.get_widget('levels')
    treeview.set_model(store)
    select = treeview.get_selection()
    iter = store.get_iter_first()
    select.select_iter(iter)
    self.do_selection(select)
    select.connect('changed',self.do_selection)

    c = gtk.TreeViewColumn(None,gtk.CellRendererText(),text=0)
    treeview.append_column(c)

  def load_levels(self,leveldir):
    store = gtk.ListStore(gobject.TYPE_STRING)
    files = os.listdir(leveldir)
    for x in files:
      if x[-4:] == '.xml':
        iter = store.append()
        store.set(iter,0,x[:-4])
    return store

  def do_selection(self,selection):
    (store,iter) = selection.get_selected()
    if iter != None:
      self.xml.get_widget('levelname').set_text(store.get_value(iter,0))

  def on_delete_event(self,*args):
    gtk.main_quit()

  def on_destroy_event(self,*args):
    gtk.main_quit()

  def on_configuration_clicked(self,*args):
    if self.configdialog == None:
      self.configdialog = ConfigDialog(
                               self.xml.get_widget('ffconfig'),
                               self.xml)
    self.configdialog.run()

  def on_standalonegame_toggled(self,widget,*args):
    self.gametype = STANDALONE
    self.xml.get_widget('levelframe').set_sensitive(True)
    self.xml.get_widget('servername').set_sensitive(False)
    self.xml.get_widget('totalplayers').set_sensitive(False)
    self.xml.get_widget('localplayers').set_range(2,100)

  def on_netclient_toggled(self,widget,*args):
    self.gametype = NETWORKCLIENT
    self.xml.get_widget('levelframe').set_sensitive(False)
    self.xml.get_widget('servername').set_sensitive(True)
    self.xml.get_widget('totalplayers').set_sensitive(False)
    self.xml.get_widget('localplayers').set_range(0,100)

  def on_netserv_toggled(self,widget,*args):
    self.gametype = NETWORKSERV
    self.xml.get_widget('levelframe').set_sensitive(True)
    self.xml.get_widget('servername').set_sensitive(False)
    self.xml.get_widget('totalplayers').set_sensitive(True)
    self.xml.get_widget('localplayers').set_range(0,100)

  def on_soundeffectcheck_toggled(self,widget,*args):
    self.xml.get_widget('musiccheck').set_sensitive(
                            self.xml.get_widget('soundeffectcheck').get_active()
                          )

  def on_openbutton_clicked(self,widget,*args):
    select = gtk.FileSelection("Choose level")
    while True:
      res = select.run()
      if res == gtk.RESPONSE_OK:
        filename = select.get_filename()
        if not os.path.isfile(filename):
           d = gtk.MessageDialog(None,gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, 
                                 gtk.BUTTONS_OK,filename + " is not a file")
           d.run()
           d.destroy()
        else:
          self.xml.get_widget('levelname').set_text(filename)
          self.treeview.get_selection().unselect_all()
          break
      else:
        break
    select.destroy()


  def on_gamestart_clicked(self,widget,*args):
    startcmd = self.binary
    startcmd += ' -p ' 
    startcmd += str(self.xml.get_widget('localplayers').get_value_as_int())

    if (self.xml.get_widget('musiccheck').get_active()):
      startcmd += ' -m '
    if (self.xml.get_widget('fullscreencheck').get_active()):
      startcmd += ' -f '
    if (not self.xml.get_widget('soundeffectcheck').get_active()):
      startcmd += ' -q '

    if self.gametype == NETWORKCLIENT:
      startcmd += ' -c ' + self.xml.get_widget('servername').get_text()
    else:
      levelname = self.xml.get_widget('levelname').get_text()
      if (levelname != ''):
        if levelname[0] != '/':
          levelname = self.leveldir + '/' + levelname + '.xml'
        startcmd += ' -l ' + levelname

    if self.gametype == NETWORKSERV:
      startcmd += ' -s ' 
      startcmd += str(self.xml.get_widget('totalplayers').get_value_as_int())

    self.xml.get_widget('mainwindow').hide()
    while gtk.events_pending():
      gtk.main_iteration()
    print '>' + startcmd
    os.system(startcmd)
    self.xml.get_widget('mainwindow').show()

  def on_close_clicked(self,widget,*args):
    gtk.main_quit()
   

def run(gladefile,binary,leveldir):
  pygame.font.init()

  signal.signal(signal.SIGINT,signal.SIG_DFL)
  prog = Program(gladefile,binary,leveldir)
  gtk.main()
