/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file common.c
 * \brief This file contains common functions for FRITZ!Box and Speedport
 */

#include <ffgtk.h>
#include <router/common.h>

/**
 * \brief Parse firmware string and extract type number
 * \param psProfile profile structure
 */
void commonParseFirmware( struct sProfile *psProfile ) {
	char *pnType;
	int nStart, nEnd, nPorts;

	nPorts = PORT_ANALOG1 | PORT_ANALOG2 | PORT_ANALOG3 | PORT_ISDNALL |
				PORT_ISDN1 | PORT_ISDN2 | PORT_ISDN3 | PORT_ISDN4 |
				PORT_ISDN5 | PORT_ISDN6 | PORT_ISDN7 | PORT_ISDN8 |
				PORT_DECT1 | PORT_DECT2 | PORT_DECT3 | PORT_DECT4 |
				PORT_DECT5 | PORT_DECT6 | PORT_SOFTPHONE;
	psProfile -> sRouterInfo.nType = 0;

	if ( psProfile -> sRouterInfo.pnFirmware != NULL && strlen( psProfile -> sRouterInfo.pnFirmware ) > 0 ) {
		pnType = psProfile -> sRouterInfo.pnFirmware;
		nStart = 0;
		while ( *pnType != 0 && !isdigit( *pnType ) ) {
			nStart++;
			pnType++;
		}

		if ( *pnType == 0 ) {
			return;
		}

		nEnd = findString( psProfile -> sRouterInfo.pnFirmware, nStart, "." );
		if ( nEnd == -1 ) {
			Debug( KERN_DEBUG, "Could not find firmware end\n" );
			return;
		}

		pnType = getSubString( psProfile -> sRouterInfo.pnFirmware, nStart, nEnd - nStart );

		if ( pnType != NULL ) {
			psProfile -> sRouterInfo.nType = atoi( pnType );
			free( pnType );
		} else {
			Debug( KERN_DEBUG, "Could not get type\n" );
		}

		switch ( psProfile -> sRouterInfo.nType ) {
			case FRITZBOX_FON:
			case FRITZBOX_ATA:
			case FRITZBOX_FON_WLAN:
			case FRITZBOX_SPEEDPORT_W501V:
			case FRITZBOX_SPEEDPORT_W701V:
			case FRITZBOX_7140:
			case FRITZBOX_7141:
			case FRITZBOX_7113:
				nPorts = PORT_ANALOG1 | PORT_ANALOG2;
				break;
			case EUMEX_300:
				nPorts = PORT_ANALOG1 | PORT_ANALOG2 | PORT_ANALOG3;
				break;
			case FRITZBOX_SPEEDPORT_W900V:
				nPorts = PORT_ANALOG1 | PORT_ANALOG2 | PORT_ISDNALL |
					PORT_ISDN1 | PORT_ISDN2 | PORT_ISDN3 | PORT_ISDN4 |
					PORT_ISDN5 | PORT_ISDN6 | PORT_ISDN7 | PORT_ISDN8 |
					PORT_DECT1 | PORT_DECT2 | PORT_DECT3 | PORT_DECT4 |
					PORT_DECT5 | PORT_DECT6;
				break;
			case FRITZBOX_5140:
				nPorts = PORT_ANALOG1 | PORT_ANALOG2 | PORT_ISDNALL |
					PORT_ISDN1 | PORT_ISDN2 | PORT_ISDN3 | PORT_ISDN4 |
					PORT_ISDN5 | PORT_ISDN6 | PORT_ISDN7 | PORT_ISDN8;
				break;
			case FRITZBOX_5050:
			case FRITZBOX_7050:
			case FRITZBOX_7170:
			case FRITZBOX_7170A:
				nPorts = PORT_ANALOG1 | PORT_ANALOG2 | PORT_ANALOG3 | PORT_ISDNALL |
					PORT_ISDN1 | PORT_ISDN2 | PORT_ISDN3 | PORT_ISDN4 |
					PORT_ISDN5 | PORT_ISDN6 | PORT_ISDN7 | PORT_ISDN8;
				break;
			case FRITZBOX_5012:
				nPorts = PORT_ISDNALL |
					PORT_ISDN1 | PORT_ISDN2 | PORT_ISDN3 | PORT_ISDN4 |
					PORT_ISDN5 | PORT_ISDN6 | PORT_ISDN7 | PORT_ISDN8;
				break;
			case FRITZBOX_7150:
				nPorts = PORT_DECT1 | PORT_DECT2 | PORT_DECT3 | PORT_DECT4 |
					PORT_DECT5 | PORT_DECT6;
				break;
			case FRITZBOX_7240:
				nPorts = PORT_ANALOG1 | PORT_ANALOG2 |
					PORT_DECT1 | PORT_DECT2 | PORT_DECT3 | PORT_DECT4 |
					PORT_DECT5 | PORT_DECT6 |
					PORT_IP1 | PORT_IP2 | PORT_IP3 | PORT_IP4 |
					PORT_IP5 | PORT_IP6 | PORT_IP7 | PORT_IP8 |
					PORT_IP9 | PORT_IP10;
				break;
			case FRITZBOX_7270:
			case FRITZBOX_7270V3:
			case FRITZBOX_SPEEDPORT_W920V:
			case FRITZBOX_7340:
			case FRITZBOX_7390:
				nPorts = PORT_ANALOG1 | PORT_ANALOG2 | PORT_ISDNALL |
					PORT_ISDN1 | PORT_ISDN2 | PORT_ISDN3 | PORT_ISDN4 |
					PORT_ISDN5 | PORT_ISDN6 | PORT_ISDN7 | PORT_ISDN8 |
					PORT_DECT1 | PORT_DECT2 | PORT_DECT3 | PORT_DECT4 |
					PORT_DECT5 | PORT_DECT6 |
					PORT_IP1 | PORT_IP2 | PORT_IP3 | PORT_IP4 |
					PORT_IP5 | PORT_IP6 | PORT_IP7 | PORT_IP8 |
					PORT_IP9 | PORT_IP10;
				break;
			case FRITZBOX_7320:
				nPorts = PORT_ANALOG1 |
					PORT_DECT1 | PORT_DECT2 | PORT_DECT3 | PORT_DECT4 |
					PORT_DECT5 | PORT_DECT6 |
					PORT_IP1 | PORT_IP2 | PORT_IP3 | PORT_IP4 |
					PORT_IP5 | PORT_IP6 | PORT_IP7 | PORT_IP8 |
					PORT_IP9 | PORT_IP10;
				break;
			case FRITZBOX_7570:
				nPorts = PORT_DECT1 | PORT_DECT2 | PORT_DECT3 | PORT_DECT4 |
					PORT_DECT5 | PORT_DECT6 |
					PORT_IP1 | PORT_IP2 | PORT_IP3 | PORT_IP4 |
					PORT_IP5 | PORT_IP6 | PORT_IP7 | PORT_IP8 |
					PORT_IP9 | PORT_IP10;
				break;
			case FRITZBOX_3270:
			case FRITZBOX_3270V3:
				nPorts =
					PORT_IP1 | PORT_IP2 | PORT_IP3 | PORT_IP4 |
					PORT_IP5 | PORT_IP6 | PORT_IP7 | PORT_IP8 |
					PORT_IP9 | PORT_IP10;
				break;
		}
	}

	nPorts |= PORT_SOFTPHONE;

	routerSetPorts( psProfile, nPorts );
}
